/***************************************************************************
 *   Copyright (C) 2005 by Thierry CHARLES   *
 *   thierry@les-charles.net   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef _PARSER_POVFILE_INFO_H_
#define _PARSER_POVFILE_INFO_H_

#include <deque>
#include <map>
#include "lib/commons.h"

#include "xpe_components/parser/fileinfo.h"

class PovFileInfo;

/**
 * element de fichier pov
 */
class PovFileElt
{
    public:
        enum EltType { Include, Local, Declare, Macro, Bookmark };

        PovFileElt(EltType _t, const wxString & _sName, const TStringList _params, uint _iLine, wxString _sHelp)
            : type(_t), sName(_sName), parameters(_params), iLine(_iLine), sHelp(_sHelp) {}
        virtual ~PovFileElt() {}

        /** renvoie le type de l'element */
        EltType getType() const { return this->type; }
        /** renvoie le nom de l'element */
        const wxString & getName() const { return this->sName; }
        /** renvoie la liste des parametres */
        const TStringList & getParameters() const { return this->parameters; }
        /** renvoie la ligne a laquelle l'element a ete declare */
        uint getLine() const { return this->iLine; }
        /** renvoie l'aide associee a l'element (commentaire du style javadoc juste avant la declaration) */
        const wxString & getHelp() const { return this->sHelp; }

        /** renvoie le nom identifiant */
        const wxString & getIndentityName();

    private:
        EltType type;
        wxString sName;
        TStringList parameters;
        uint iLine;
        wxString sHelp;
        wxString sIdentityName;
};

typedef std::map<wxString,PovFileElt *> TNamedPovFileEltMap;

/**
 * container d'infos de parsing propre aux fichiers pov
 */
class PovFileInfo : public FileInfo
{
    public :
        PovFileInfo(FileType _t, const wxString & _sFileName) : FileInfo(_t,_sFileName) {}
        PovFileInfo(FileType _t, const int _iEditorId) : FileInfo(_t, _iEditorId) {}
        PovFileInfo(const PovFileInfo & info);
        PovFileInfo() {}
        virtual ~PovFileInfo() {}

        /** ecris toutes les informations parsees dans un fichier de cache pour permettre a l'application de liberer la memoire */
        virtual void dumpToCache();
        /** lis les informations de parsing prealablement stockees dans un fichier de cache */
        virtual bool readFromCache();
        /** supprime les informations de parsing prealablement stockees dans un fichier de cache */
        virtual void removeCache();

        /** cree une instance du parser a utiliser pour ce type de fichier */
        virtual FileParser * getParser() const;

        /** ajoute un element trouve dans le fichier source */
        void addElement(const PovFileElt & elt) { this->elts.push_back(elt); }

        /** nettoie la structure (avant de la remplir via le parsing) */
        void clear();

        /** copie les infos recuperees du parsing dans l'instance courante*/
        virtual void copyParsingInfo(const FileInfo * info);

        /** duplique l'instance */
        virtual FileInfo * clone();

        /** cree une map d'elements Nom => PovFileElt* */
        TNamedPovFileEltMap getDistinctElements();
    protected:
        /** renvoie le nom du fichier de cache a utiliser pour stocker les informations */
        wxString getCacheFile() const;

    private:
        typedef std::deque<PovFileElt> TOrderedEltsList;
        TOrderedEltsList elts;
};

#endif // _PARSER_POVFILE_INFO_H_

