/***************************************************************************
 *   Copyright (C) 2005 by Thierry CHARLES   *
 *   thierry@les-charles.net   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "povfileinfo.h"
#include "povparser.h"

#include <wx/regex.h>

#include "lib/lib_logging.h"
#include "lib/lib_file.h"
#include "lib/lib_md5.h"

#include "xpe_components/editor/editor_panelelement.h"
#include "xpe_components/mainwindow.h"

/** renvoie le nom identifiant */
const wxString & PovFileElt::getIndentityName()
{
    if(!this->sIdentityName.length())
    {
        this->sIdentityName = this->sName;

        if(this->parameters.size())
        {
            this->sIdentityName += wxT("(");
            TStringList::iterator it = this->parameters.begin();
            while(it != this->parameters.end())
            {
                this->sIdentityName += (*it);
                it++;
                if(it != this->parameters.end())
                    this->sIdentityName += wxT(", ");
            }
            this->sIdentityName += wxT(")");
        }
    }

    return this->sIdentityName;
}


PovFileInfo::PovFileInfo(const PovFileInfo & info)
    : FileInfo(&info)
{
}

/** renvoie le nom du fichier de cache a utiliser pour stocker les informations */
wxString PovFileInfo::getCacheFile() const
{
    wxString sFileName;
    if(this->getEditorId() != 0)
    {
        TApplicationPanel * panel = getMainWindowCenterPanel();
        if(panel)
        {
            EditorPanelElement * elt = dynamic_cast<EditorPanelElement *>(panel->getElement(this->getEditorId()));
            if(elt)
            {
                sFileName = elt->getFilename();
            }
        }
    }

    if(!sFileName.length())
        sFileName = this->getFileName();

    if(!sFileName.length())
        return wxString();

    wxString sCacheFile = CurrentApplication()->getApplCachePath() + wxT("/PovFileInfo/");

    wxString sMD5;
    if(!libmd5::computeString(sFileName,sMD5))
        return wxString();

    sFileName = libfile::basename(sFileName);
    wxRegEx expr(wxT("[^:alnum:]"));
    expr.ReplaceAll(&sFileName,wxT("_"));
    sCacheFile += sFileName + wxT("_") + sMD5 + wxT(".xml");

    return sCacheFile;
}

/** cris toutes les informations parses dans un fichier de cache pour permettre a l'application de librer la mmoire */
void PovFileInfo::dumpToCache()
{
    wxString sFilename = this->getCacheFile();
    if(!sFilename.length())
        return;
}

/** lis les informations de parsing pralablement stockes dans un fichier de cache */
bool PovFileInfo::readFromCache()
{
    this->setLastParseTime( 0 );

    wxString sFilename = this->getCacheFile();
    if(!sFilename.length())
        return false;



    return false;
}

/** supprime les informations de parsing pralablement stockes dans un fichier de cache */
void PovFileInfo::removeCache()
{
    wxString sFilename = this->getCacheFile();
    if(!sFilename.length())
        return;

    libfile::remove(sFilename);
}

/** cre une instance du parser a utiliser pour ce type de fichier */
FileParser * PovFileInfo::getParser() const
{
    return new PovParser();
}

/** nettoie la structure (avant de la remplir via le parsing) */
void PovFileInfo::clear()
{
    FileInfo::clear();
    this->elts.erase(this->elts.begin(),this->elts.end());
}

void PovFileInfo::copyParsingInfo(const FileInfo * info)
{
    FileInfo::copyParsingInfo(info);
    const PovFileInfo * povInfo = dynamic_cast<const PovFileInfo *>(info);
    if(povInfo)
        this->elts = povInfo->elts;
}

/** duplique l'instance */
FileInfo * PovFileInfo::clone()
{
    return new PovFileInfo(*this);
}

/** cre une map d'lments Nom => PovFileElt* */
TNamedPovFileEltMap PovFileInfo::getDistinctElements()
{
    TNamedPovFileEltMap map;

    TOrderedEltsList::iterator it = this->elts.begin();
    while(it != this->elts.end())
    {
        map[(*it).getIndentityName()] = &(*it);
        it++;
    }

    return map;
}
