/***************************************************************************
 *   Copyright (C) 2005 by Thierry CHARLES   *
 *   thierry@les-charles.net   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef _RENDERER_PANEL_ELEMENT_H_
#define _RENDERER_PANEL_ELEMENT_H_

#include <wx/menu.h>
#include <wx/event.h>
#include <wx/timer.h>
#include <wx/combobox.h>

#include "lib/commons.h"
#include "lib/povinifile.h"
#include "components/stdgui/tgenbutton.h"
#include "components/stdgui/tgenbuttonlistener.h"
#include "components/framework/tapplication.h"
#include "components/framework/tpanelelement.h"
#include "components/framework/elementinfo.h"


#define PELT_TYPE_RENDERER "PELT_TYPE_RENDERER"

class wxTextCtrl;
class wxTimer;
class TProcess;

/**
 * @short Un element de panneau d'application affichant la console povray
 * @author Thierry CHARLES <thierry@les-charles.net>
 * @version 0.1
 */
class RendererPanelElement : public TPanelElement, protected TGenButtonListener, public wxEvtHandler
{
    TRANSLATABLE;
    public:
        RendererPanelElement(TApplicationPanel * _owner, int iID = -1);
        virtual ~RendererPanelElement();

        /** renvoie une constante identifiant le type de cet element de maniere a pouvoir le reconstruire lors du chargement des preferences */
        virtual const char * getElementType() const { return PELT_TYPE_RENDERER; }

        /** charge les parametres du composant a partir des informations contenues dans le noeud passe en parametre */
        virtual bool loadParameters(TiXmlElement * parametersNode);
        /** renvoie les parametres du composant sous la forme d'un noeud xml */
        virtual TiXmlElement * getParameters();
        /** indique si le composant doit etre sauvegarde */
        virtual bool mightBeSaved() const { return true; }

        static TPanelElementInfo getElementInfo() { return TPanelElementInfo(PELT_TYPE_RENDERER,wxSTr("Povray output"), getDefaultIcon(), 1, 1); }

        /** renvoie l'icone associee au composant */
        static const TBitmap * getDefaultIcon();

        /** timer tick */
        void onTimer(wxTimerEvent& event);

        /** click menu */
        void onMenuEvent(wxCommandEvent & evt);

    protected:
        /** construit le panneau conteneur et son contenu (appelle automatiquement par getContentPanel et detruit automatiquement par le destructeur) */
        virtual TPanel * buildContentPanel();

        /** gere les evenements sur les boutons du composant */
        virtual void buttonActivated(TGenButton * btn);

        /** gere le toggle des boutons */
        virtual void buttonToggled(TGenButton * btn);

        /** lance le rendu */
        void render(bool bForceFile);

        /** filtre des donnees brutes issues de la console et les affiche */
        void filterToConsole(const wxString & sIn);

        /** analyse le contenu de la console pour trouver d'ventuelles erreurs */
        void analyseConsoleErrors();

        /** mets a jour la liste de profils */
        void updateIniProfiles();

    private:
        TGenButton * iniChooserBtn;
        wxComboBox * iniProfileCombo;
        wxTextCtrl * options;
        wxTextCtrl * console;
        TGenButton * renderBtn;
        TGenButton * stopBtn;
        TProcess * povProcess;
        wxTimer * timer;
        wxString sOptionsBuf;
        wxMenu * menu;
        int iStartMenuId;
        wxMenuItem * menuStart;
        int iStopMenuId;
        wxMenuItem * menuStop;
        wxString sIniFile;
        TIniFile iniFileData;
};

class RendererRes : public TApplicationRessource
{
    public:
        explicit RendererRes(const wxString & _sRenderer = wxT(""), const bool _bUseTransparencyFix = false) : sRenderer(_sRenderer), bUseTransparencyFix(_bUseTransparencyFix) {}
        virtual ~RendererRes() {}

        /** defini le binaire a utiliser pour le rendu */
        void setRenderer(const wxString & _sRenderer) { this->sRenderer = _sRenderer; }
        /** indique le binaire a utiliser pour le rendu */
        const wxString & getRenderer() const { return this->sRenderer; }
        /** defini si on doit appliquer le fix de transparence pour la fenetre de rendu */
        void setUseTransparencyFix(const bool _bUseTransparencyFix) { this->bUseTransparencyFix = _bUseTransparencyFix; }
        /** indique si on doit appliquer le fix de transparence pour la fenetre de rendu */
        bool useTransparencyFix() const { return this->bUseTransparencyFix; }
        /** renvoie la valeur par dfaut de l'executable povray */
        static wxString getInitialisationValue();
    private:
        wxString sRenderer;
        bool bUseTransparencyFix;
};

#endif // _RENDERER_PANEL_ELEMENT_H_
