/***************************************************************************
 *   Copyright (C) 2005 by Thierry CHARLES   *
 *   thierry@les-charles.net   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "help_panelelt.h"

#include <wx/textctrl.h>

#include "components/framework/tapplicationpanel.h"
#include "components/framework/tapplication.h"
#include "components/stdgui/tpanel.h"
#include "components/stdgui/tbitmap.h"

#include "lib/lib_string.h"

#include "bmp_id.h"


HelpPanelElement * HelpPanelElement::instance = NULL;

HelpPanelElement::HelpPanelElement(TApplicationPanel * _owner, int iID)
    : TPanelElement(_owner, iID, wxT(""), wxT("")),
    help(NULL)
{
    instance = this;

    this->setTooltip(wxTr("Get documentation here"));
    this->setExtensivity(1);
    this->setBitmap(getDefaultIcon());

    if(NavigatorPanelElement::getInstance())
        NavigatorPanelElement::getInstance()->addSelectionListener(this);
}

HelpPanelElement::~HelpPanelElement()
{
    if(NavigatorPanelElement::getInstance())
        NavigatorPanelElement::getInstance()->removeSelectionListener(this);

    instance = NULL;
}

const TBitmap * HelpPanelElement::getDefaultIcon()
{
    return GET_BMP(BMP_HELP_ID);
}

/** construit le panneau conteneur et son contenu (appell automatiquement par getContentPanel et dtruit automatiquement par le destructeur) */
TPanel * HelpPanelElement::buildContentPanel()
{
    TPanel * contentPanel = new TPanel(this->getOwner()->getContentPanel());
    wxBoxSizer * sizer = new wxBoxSizer( wxVERTICAL);
    contentPanel->SetSizer(sizer);

    this->help = new wxTextCtrl(contentPanel, -1, wxT(""), wxDefaultPosition, wxDefaultSize, wxTE_PROCESS_TAB|wxTE_MULTILINE|wxTE_NOHIDESEL|wxTE_BESTWRAP|wxTE_READONLY);

    sizer->Add(this->help,1,wxEXPAND);
    sizer->Show(this->help,true);

    return contentPanel;
}

/** changement de slection dans le navigateur */
void HelpPanelElement::selectionChanged(NavigatorPanelElement * navigator, NavigatorItemData * selectedItem)
{
    if(!selectedItem)
        return;
    if(!selectedItem->getHelp().length())
        return;

    this->help->Clear();
    wxTextAttr defaultAttr = this->help->GetDefaultStyle();
    wxTextAttr boldAttr;
    wxFont font = this->help->GetFont();
    font.SetWeight(wxFONTWEIGHT_BOLD);
    boldAttr.SetFont(font);
    boldAttr.SetFlags(wxTEXT_ATTR_FONT_WEIGHT);
    this->help->SetDefaultStyle(boldAttr);
    this->help->AppendText(selectedItem->getName() + wxT(" :\n"));
    this->help->SetDefaultStyle(defaultAttr);
    this->help->AppendText(selectedItem->getHelp());
}
