/***************************************************************************
 *   Copyright (C) 2005 by Thierry CHARLES   *
 *   thierry@les-charles.net   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef _DOCUMENTS_PANEL_ELEMENT_H_
#define _DOCUMENTS_PANEL_ELEMENT_H_

#include <wx/event.h>
#include "lib/commons.h"
#include "components/framework/tpanelelement.h"
#include "components/framework/tapplicationpanel.h"
#include "components/framework/elementinfo.h"

#define PELT_TYPE_DOCUMENTS "PELT_TYPE_DOCUMENTS"

class TListCtrl;

/**
 * @short Un �l�ment de panneau d'application affichant la liste des documents en cours d'�dition
 * @author Thierry CHARLES <thierry@les-charles.net>
 * @version 0.1
 */
class DocumentsPanelElement : public TPanelElement, protected TApplicationPanelListener, public wxEvtHandler
{
    TRANSLATABLE;
    public:
        DocumentsPanelElement(TApplicationPanel * _owner, int iID = -1);
        virtual ~DocumentsPanelElement();

        /** renvoie une constante identifiant le type de cet �l�ment de mani�re a pouvoir le reconstruire lors du chargement des preferences */
        virtual const char * getElementType() const { return PELT_TYPE_DOCUMENTS; }

        /** indique si le composant doit etre sauvegarde */
        virtual bool mightBeSaved() const { return true; }

        static TPanelElementInfo getElementInfo() { return TPanelElementInfo(PELT_TYPE_DOCUMENTS,wxSTr("Documents"), getDefaultIcon(), 0, 99); }

        /** renvoie l'icone associ�e au composant */
        static const TBitmap * getDefaultIcon();

    protected:
        /** construit le panneau conteneur et son contenu (appell� automatiquement par getContentPanel et d�truit automatiquement par le destructeur) */
        virtual TPanel * buildContentPanel();

        /** indique qu'un element va etre supprime d'un paneau */
        virtual void removingElement(TApplicationPanel * panel, TPanelElement * elt);
        /** indique qu'un element est ajoute a un panneau */
        virtual void addingElement(TApplicationPanel * panel, TPanelElement * elt);
        /** indique que les donnees d'un element ont change */
        virtual void elementDataChanged(TApplicationPanel * panel, const TPanelElement * elt);


        /** mets a jour la liste des documents ouverts */
        void updateDocumentsList();

        void onListViewSize(wxSizeEvent & evt);
        void onListDblClick(wxCommandEvent & event);

    private:
        TListCtrl * docs;
};

#endif // _NOTES_PANEL_ELEMENT_H_
