/***************************************************************************
 *   Copyright (C) 2005 by Thierry CHARLES   *
 *   thierry@les-charles.net   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "file_panelelement.h"
#include "xpe_components/res_id.h"
#include "xpe_components/mainwindow.h"
#include "components/framework/tapplicationpanel.h"
#include "components/framework/tapplication.h"
#include "components/framework/tmainwindow.h"
#include "components/stdgui/tpanel.h"
#include "components/stdgui/tbitmap.h"

#include <wx/filename.h>

#include "lib/lib_logging.h"
#include "lib/lib_file.h"

FileViewerPanelElement::FileViewerPanelElement(TApplicationPanel * _owner, int iID)
    : TPanelElement(_owner, iID, wxT("New file")),
        bModified(false),
        bmpNormal(NULL),
        bmpModified(NULL)
{
    this->sFilename = wxT("");
    this->iLastModificationTime = wxDateTime::GetTimeNow();
}

FileViewerPanelElement::~FileViewerPanelElement()
{
}

/** charge un fichier apres avoir vidange le contenu du composant */
bool FileViewerPanelElement::loadFile(const wxString & sFile)
{
    if(this->loadFileImpl(sFile))
    {
        this->setFilename(sFile);

        this->setModified(false);

        wxFileName fn(sFile);
        wxDateTime lastMod;
        fn.GetTimes(NULL,&lastMod,NULL);
        this->iLastModificationTime = lastMod.GetTicks();

        return true;
    }

    return false;
}

/** ecris les modifs du fichier */
bool FileViewerPanelElement::writeFile()
{
    return this->writeFile(this->sFilename);
}

/** ecris un fichier */
bool FileViewerPanelElement::writeFile(const wxString & sFile)
{
    bool bRes = this->writeFileImpl(sFile);

    if(bRes)
    {
        this->setFilename(sFile);

        this->setModified(false);
    }

    return bRes;
}

/** defini le nom du panel en fonction du nom du fichier affiche */
void FileViewerPanelElement::setFilename(const wxString & sFile)
{
    if(sFile == this->sFilename)
        return;

    this->sFilename = sFile;

    this->setName(libfile::basename(sFile));
    this->setTooltip(this->sFilename);
}

/** defini les image pour l'etat modifie / non-modifie du composant */
void FileViewerPanelElement::setBitmaps(const TBitmap * bmpNormal, const TBitmap * bmpModified)
{
    this->bmpNormal = bmpNormal;
    this->bmpModified = bmpModified;
    this->setBitmap(this->bModified ? bmpModified : bmpNormal);
}

/** defini si le composant a ete modifie */
void FileViewerPanelElement::setModified(bool b)
{
    bool bChanged = (b != this->isModified());
    this->bModified = b;
    if(b)
        this->iLastModificationTime = wxDateTime::GetTimeNow();
    if(bChanged)
    {
        if(b)
            this->setBitmap(this->bmpModified);
        else
            this->setBitmap(this->bmpNormal);
    }
}

/** demande la fermeture du panneau */
void FileViewerPanelElement::doCloseElement()
{
    XPEMainWindow * mainWindow = dynamic_cast<XPEMainWindow *>(CurrentApplication()->getMainWindow());
    if(!mainWindow)
        return;

    mainWindow->requestTabClose(this);
}

