/***************************************************************************
 *   Copyright (C) 2005 by Thierry CHARLES   *
 *   thierry@les-charles.net   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef _STYLES_RESSOURCE_H_
#define _STYLES_RESSOURCE_H_

#include "components/framework/tapplication.h"
#include "components/framework/xmlcfgcmp.h"
#include "components/codeeditor/tcodeeditor.h"
#include "components/codeeditor/tstyle.h"
#include "lib/tcolor.h"
#include "lib/commons.h"
#include <map>

#define XMLCC_NODE_STYLESRES_PARAMETERS "StylesRessource"

class StylesRes : public TApplicationRessource, public XmlConfiguredComponent
{
    public:
        StylesRes() : iFontSize(11) {}
        virtual ~StylesRes() {}

        /** d�fini la couleur d'arriere plan de l'editeur */
        void setBgColor(const TColor & color);
        /** renvoie la couleur d'arriere plan de l'editeur */
        const TColor & getBgColor() const { return this->bgColor; }

        /** defini le style pour un ID donne */
        void setStyle(int iStyleID, const TStyle & style);
        /** renvoie le style pour un ID donne */
        const TStyle & getStyle(int iStyleID) { return this->stylesMap[iStyleID]; }

        /** d�fini la taille de la police */
        void setFontSize(int iFontSize);
        /** renvoie la taille de la police */
        int getFontSize() const { return this->iFontSize; }

        /**
         * defini le style de la selection
         * @param iSelection id de la selection a manipuler
         * @param iStyle ID du style a appliquer a la s�lection (voir setStyle)
         */
        void setSelectionStyle(const int iSelection, const int iStyleId);

        /** applique les styles a l'editeur passe en parametre */
        virtual void applyStyles(TCodeEditor * editor) const;

        /** charge les parametres du composant a partir des informations contenues dans le noeud pass� en param�tre */
        virtual bool loadParameters(TiXmlElement * parametersNode);
        /** charge les parametres par d�faut */
        virtual void loadDefaultParameters();
        /** renvoie les parametres du composant sous la forme d'un noeud xml */
        virtual TiXmlElement * getParameters();

    private:
        TColor bgColor;
        TStylesMap stylesMap;
        typedef std::map<int,int> TSelectionsStyleMap;
        TSelectionsStyleMap selectionsStyleMap;
        int iFontSize;
};




#endif
