/***************************************************************************
 *   Copyright (C) 2005 by Thierry CHARLES   *
 *   thierry@les-charles.net   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef _POV_PANEL_ELEMENT_H_
#define _POV_PANEL_ELEMENT_H_

#include "lib/commons.h"
#include "xpe_components/editor/editor_panelelement.h"

#define PELT_TYPE_POVEDITOR "PELT_TYPE_POVEDITOR"

class StylesRes;
class PovFileInfo;

/**
 * @short Un element de panneau d'application
 * @author Thierry CHARLES <thierry@les-charles.net>
 * @version 0.1
 */
class PovPanelElement : public EditorPanelElement
{
    TRANSLATABLE;
    public:
        PovPanelElement(TApplicationPanel * _owner, int iID = -1);
        virtual ~PovPanelElement();

        /** renvoie une constante identifiant le type de cet element de maniere a pouvoir le reconstruire lors du chargement des preferences */
        virtual const char * getElementType() const { return PELT_TYPE_POVEDITOR; }

        /** commente la ligne ou se trouve le curseur ou la selection */
        void commentIn();
        /** de-commente la ligne ou se trouve le curseur ou la selection */
        void commentOut();

        /**
         * renvoie la liste des completions correspondant  un mot
         * @param sWordStart debut du mot a completer
         */
        virtual TStringList getCompletionsForWord(TCodeEditor * ce, const wxString & sWordStart);

    protected:
        /** charge un fichier apres avoir vidange le contenu du composant */
        virtual bool loadFileImpl(const wxString & sFile);

        /** construit le panneau conteneur et son contenu (appelle automatiquement par getContentPanel et detruit automatiquement par le destructeur) */
        virtual TPanel * buildContentPanel();

        /** recupere la liste des declarations utilisables pour l'auto-completion */
        void fillCompletionsWith(TStringSet & completions, PovFileInfo * info, const wxString & sWordStart, bool bIsInclude);
};

#endif // _POV_PANEL_ELEMENT_H_
