/***************************************************************************
 *   Copyright (C) 2005 by Thierry CHARLES   *
 *   thierry@les-charles.net   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef _EDITOR_PANEL_ELEMENT_H_
#define _EDITOR_PANEL_ELEMENT_H_

#include <wx/event.h>
#include <wx/string.h>

#include "lib/commons.h"
#include "components/framework/tpanelelement.h"
#include "components/codeeditor/tdocument.h"
#include "xpe_components/editor/stylesres.h"
#include "xpe_components/editor/keywordsres.h"
#include "xpe_components/filepelt/file_panelelement.h"

class TCodeEditor;

#define STYLE_BRACKET           201


/**
 * @short Un element de panneau d'application contenant un editeur
 * @author Thierry CHARLES <thierry@les-charles.net>
 * @version 0.1
 */
class EditorPanelElement : public FileViewerPanelElement, protected TDocumentListener, public TRessourceListener, public wxEvtHandler, public TCodeEditorAutoCompletionSource
{
    public:
        EditorPanelElement(TApplicationPanel * _owner, int iID = -1);
        virtual ~EditorPanelElement();

        /** renvoie un pointeur sur l'editeur */
        TCodeEditor * getEditor() { return this->editor; }

        /** indique si le composant doit etre sauvegarde dans la config en XML */
        virtual bool mightBeSaved() const { return false; }

        /** indique qu'un evenement s'est declanche sur la ressource */
        virtual void ressourceEvent(TApplicationRessource * res, const int iEvent);

        /** defini la ressources de mots cles geree par l'enlighter et demarre l'ecoute */
        virtual void setKeywordsListRes(KeywordsListRes * resKeywords);

        /** libre les ressources graphiques */
        virtual void discardContentPanel();

        /**
         * renvoie la liste des completions correspondant  un mot
         * @param sWordStart debut du mot a completer
         */
        virtual TStringList getCompletionsForWord(TCodeEditor * ce, const wxString & sWordStart);

    protected:
        /** charge un fichier apres avoir vidange le contenu du composant */
        virtual bool loadFileImpl(const wxString & sFile);

        /** ecris un fichier */
        virtual bool writeFileImpl(const wxString & sFile);

        /** construit le panneau conteneur et son contenu (appelle automatiquement par getContentPanel et detruit automatiquement par le destructeur) */
        TPanel * buildContentPanel(bool bWithRafterBrackets);

        /** defini l'editeur de texte */
        void setEditor(TCodeEditor * ed);

        /** signale un changement dans le document. Cet evenement intervient systematiquement apres un autre plus specialise (documentTextInserted ou documentTextRemoved) */
        virtual void documentChanged(TDocument * doc);

        /** signale l'insertion de texte dans le document. puis appelle documentChanged */
        virtual void documentTextInserted(TDocument * doc, const TPoint & ptFrom, const TPoint & ptTo) {};
        /** signale la suppression de texte dans le document. puis appelle documentChanged */
        virtual void documentTextRemoved(TDocument * doc, const TPoint & ptFrom, const TPoint & ptTo) {};
        /** signale de grosses modifs sur le document. puis appelle documentChanged */
        virtual void documentHeavilyModified(TDocument * doc) {};

        void onMouseRightClick(wxMouseEvent & event);
        void onEditorPopupMenuCommand(wxCommandEvent & event);

        /** construit le menu et le connecte au listeners */
        virtual void buildEditorPopupMenu(wxMenu * menu);
        /** prepare le menu construit par buildEditorPopupMenu (etat et textes des wxMenuItems) */
        virtual void prepareEditorPopupMenu(wxMenu * menu, long iEditorX, long iEditorY);

        /** recherche la presence d'un nom de fichier a la position indiquee du composant */
        virtual bool checkForFileNameAt(wxString & sFile, long iEditorX, long iEditorY);

    private:
        StylesRes * resStyles;
        KeywordsListRes * resKeywords;
        TCodeEditor * editor;
        wxString sFileToOpen; // nom du fichier dtect au moment du clic droit

        wxMenu editorPopupMenu;
        bool bEditorPopupMenuBuild;
        wxMenuItem * openFileMenuItem;
        wxMenuItem * cutMenuItem;
        wxMenuItem * copyMenuItem;
        wxMenuItem * pasteMenuItem;

        enum MenuEntry { OpenFile, Cut, Copy, Paste };
};

#endif // _EDITOR_PANEL_ELEMENT_H_
