/***************************************************************************
 *   Copyright (C) 2005 by Thierry CHARLES   *
 *   thierry@les-charles.net   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef _XPE_EXIT_DLG_H_
#define _XPE_EXIT_DLG_H_

#include <wx/dialog.h>
#include <wx/button.h>
#include "components/stdgui/tlistctrl.h"
#include <wx/string.h>

#include <deque>

#include "lib/commons.h"
#include "components/framework/translation.h"

class EditorPanelElement;

/** Dialogue de fermeture de l'appli permettant de choisir les fichiers a sauvegarder */
class XPEExitDlg : public wxDialog, virtual public TranslatableCmp
{
    TRANSLATABLE;
    public:
        typedef std::deque<EditorPanelElement *> TEltsList;

        XPEExitDlg(wxWindow * owner);
        virtual ~XPEExitDlg() {}

        /** d�fini la liste des fichiers modifi�s */
        void setModifiedElements(const TEltsList & modifiedElements);

        /** renvoie la liste des �l�ments s�lectionn�s */
        TEltsList getSelectedElements() const;

    private:
        TListCtrl * list;
        wxButton * btnOk;
        wxButton * btnCancel;
};


#endif
