/***************************************************************************
 *   Copyright (C) 2005 by Thierry CHARLES   *
 *   thierry@les-charles.net   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "xpe_exit_dlg.h"

#include <wx/sizer.h>
#include <wx/panel.h>
#include <wx/stattext.h>

#include "xpe_components/editor/editor_panelelement.h"


XPEExitDlg::XPEExitDlg(wxWindow * owner)
    : wxDialog(owner,-1,wxT("Modified files"),wxDefaultPosition,wxDefaultSize,wxDEFAULT_DIALOG_STYLE|wxSTAY_ON_TOP|wxRESIZE_BORDER),
    list(NULL)
{
    this->SetTitle(wxTr("Modified files"));
    wxSizer * mainSizer = new wxBoxSizer(wxVERTICAL);

    wxStaticText * label = new wxStaticText(this,-1,wxTr("Select files to save"));
    mainSizer->Add(label,0,wxTOP|wxLEFT|wxRIGHT|wxEXPAND,5);

    mainSizer->AddSpacer(3);

    this->list = new TListCtrl(this,-1,wxDefaultPosition,wxDefaultSize,wxLC_REPORT|wxLC_NO_HEADER);
    mainSizer->Add(this->list,1,wxBOTTOM|wxLEFT|wxRIGHT|wxEXPAND,5);
    this->list->InsertColumn(0,wxT(""));

    wxPanel * buttonsPanel = new wxPanel(this,-1);
    wxSizer * buttonsSizer = new wxBoxSizer(wxHORIZONTAL);

    buttonsSizer->AddStretchSpacer(10);

    this->btnOk = new wxButton(buttonsPanel,wxID_OK);
    buttonsSizer->Add(this->btnOk,0,wxEXPAND);

    this->btnCancel = new wxButton(buttonsPanel,wxID_CANCEL);
    buttonsSizer->Add(this->btnCancel,0,wxLEFT|wxEXPAND,5);
    buttonsPanel->SetSizer(buttonsSizer);

    mainSizer->Add(buttonsPanel,0,wxLEFT|wxRIGHT|wxBOTTOM|wxEXPAND,5);

    this->SetSizerAndFit(mainSizer);

}

/** d�fini la liste des fichiers modifi�s */
void XPEExitDlg::setModifiedElements(const XPEExitDlg::TEltsList & modifiedElements)
{
    TEltsList::const_iterator itB = modifiedElements.begin();
    TEltsList::const_iterator itE = modifiedElements.end();

    int iIdx = 0;
    while(itB != itE)
    {
        const wxString * s;
        if((*itB)->getFilename().length() > 0)
            s = &(*itB)->getFilename();
        else
            s = &(*itB)->getName();

        int i = this->list->InsertItem(iIdx,*s);
        this->list->SetItemData(i,long(*itB));

        itB++;
        iIdx++;
    }

    this->list->SetColumnWidth(0,wxLIST_AUTOSIZE);
    wxSize size = this->GetSize();
    size.SetWidth(this->list->GetColumnWidth(0) + 30);
    this->SetSize(size);
}

/** renvoie la liste des �l�ments s�lectionn�s */
XPEExitDlg::TEltsList XPEExitDlg::getSelectedElements() const
{
    TEltsList selection;

    int iItem = -1;
    while(true)
    {
        iItem = this->list->GetNextItem(iItem,wxLIST_NEXT_ALL,wxLIST_STATE_SELECTED);
        if(iItem < 0)
            break;
        selection.push_back((EditorPanelElement *)this->list->GetItemData(iItem));
    }

    return selection;
}
