/***************************************************************************
 *   Copyright (C) 2005 by Thierry CHARLES   *
 *   thierry@les-charles.net   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "search_dlg.h"

#include <wx/sizer.h>
#include <wx/panel.h>
#include <wx/stattext.h>

BEGIN_EVENT_TABLE(SearchDlg, wxDialog)
    EVT_KEY_UP (SearchDlg::onKeyboardEvent)
END_EVENT_TABLE()
        
SearchDlg::SearchDlg(wxWindow * owner)
    : wxDialog(owner,-1,wxT("Find ..."), wxDefaultPosition,wxDefaultSize,wxDEFAULT_DIALOG_STYLE|wxSTAY_ON_TOP|wxRESIZE_BORDER),
    searchField(NULL), caseSensitiveChk(NULL)
{
    this->SetTitle(wxTr("Find ..."));
    wxSizer * mainSizer = new wxBoxSizer(wxVERTICAL);

    wxStaticText * label = new wxStaticText(this,-1,wxTr("Text to search for :"));
    mainSizer->Add(label,0,wxTOP|wxLEFT|wxRIGHT|wxEXPAND,5);

    mainSizer->AddSpacer(3);

    this->searchField = new wxTextCtrl(this,-1);
    mainSizer->Add(this->searchField,1,wxBOTTOM|wxLEFT|wxRIGHT|wxEXPAND,5);

    this->caseSensitiveChk = new wxCheckBox(this, -1, wxTr("case-sensitive"));
    mainSizer->Add(this->caseSensitiveChk,1,wxBOTTOM|wxLEFT|wxRIGHT|wxEXPAND,5);


    wxPanel * buttonsPanel = new wxPanel(this,-1);
    wxSizer * buttonsSizer = new wxBoxSizer(wxHORIZONTAL);

    buttonsSizer->AddStretchSpacer(10);

    this->btnOk = new TGenButton(buttonsPanel);
    this->btnOk->setText(wxTr("Find"));
    this->btnOk->addButtonListener(this);
    buttonsSizer->Add(this->btnOk,0,wxEXPAND);

    this->btnCancel = new TGenButton(buttonsPanel);
    this->btnCancel->setText(wxTr("Cancel"));
    this->btnCancel->addButtonListener(this);
    buttonsSizer->Add(this->btnCancel,0,wxLEFT|wxEXPAND,5);
    buttonsPanel->SetSizer(buttonsSizer);

    mainSizer->Add(buttonsPanel,0,wxLEFT|wxRIGHT|wxBOTTOM|wxEXPAND,5);

    this->SetSizerAndFit(mainSizer);

}

/**
 * affiche le dialogue de recherche
 * @param sInitialSearch valeur recherche
 * @return false si annule
 */
bool SearchDlg::show(const wxString & sInitialSearch)
{
    this->searchField->SetValue(sInitialSearch);
    return this->show();
}

/**
 * affiche le dialogue de recherche
 * @return false si annule
 */
bool SearchDlg::show()
{
    this->searchField->SetFocus();
    this->searchField->SetSelection(-1,-1);
    return this->ShowModal() == wxID_OK;
}

/**
 * renvoie la chaine qu'il faut rechercher
 */
wxString SearchDlg::getSearchString()
{
    return this->searchField->GetValue();
}

/**
 * indique si la recherche est sensible a la casse
 */
bool SearchDlg::isCaseSensitive()
{
    return this->caseSensitiveChk->GetValue();
}

/** click bouton */
void SearchDlg::buttonActivated(TGenButton * btn)
{
    if(btn == this->btnOk)
    {
        this->EndModal(wxID_OK);
    }
    else
    {
        this->EndModal(wxID_CANCEL);
    }
}

/** validation clavier */
void SearchDlg::onKeyboardEvent(wxKeyEvent & evt)
{
    if(evt.GetKeyCode() == WXK_RETURN)
        this->buttonActivated(this->btnOk);
    if(evt.GetKeyCode() == WXK_ESCAPE)
        this->buttonActivated(this->btnCancel);
}



