/***************************************************************************
 *   Copyright (C) 2005 by Thierry CHARLES   *
 *   thierry@les-charles.net   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef _REPLACE_DLG_H_
#define _REPLACE_DLG_H_

#include <wx/dialog.h>
#include <wx/textctrl.h>
#include <wx/checkbox.h>
#include <wx/string.h>

#include <deque>

#include "lib/commons.h"
#include "components/framework/translation.h"
#include "components/stdgui/tgenbutton.h"
#include "components/stdgui/tgenbuttonlistener.h"


/** Dialogue de fermeture de l'appli permettant de choisir les fichiers a sauvegarder */
class ReplaceDlg : public wxDialog, virtual public TranslatableCmp, TGenButtonListener
{
    TRANSLATABLE;
    public:
        ReplaceDlg(wxWindow * owner);
        virtual ~ReplaceDlg() {}

        /**
         * affiche le dialogue de recherche
         * @param sInitialSearch valeur recherch�e
         * @return false si annule
         */
        bool show(const wxString & sInitialSearch);

        /**
         * affiche le dialogue de recherche
         * @return false si annule
         */
        bool show();

        /**
         * renvoie la chaine qu'il faut rechercher
         */
        wxString getSearchString() const;

        /**
         * renvoie la chaine de remplacement
         */
        wxString getReplaceString() const;

        /**
         * indique si la recherche est sensible a la casse
         */
        bool isCaseSensitive() const;

        /**
         * indique si on a cliqu sur "replace all"
         */
        bool getMightReplaceAll() const { return this->bReplaceAll; }

        virtual void buttonActivated(TGenButton * btn);
        
        /** validation clavier */
        void onKeyboardEvent(wxKeyEvent & evt);
        
    private:
        DECLARE_EVENT_TABLE();

        wxTextCtrl * searchField;
        wxTextCtrl * replaceField;
        wxCheckBox * caseSensitiveChk;

        bool bReplaceAll;

        TGenButton * btnReplace;
        TGenButton * btnReplaceAll;
        TGenButton * btnCancel;
};


#endif
