/***************************************************************************
 *   Copyright (C) 2005 by Thierry CHARLES                                 *
 *   thierry@les-charles.net                                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef _COLOR_DLG_H_
#define _COLOR_DLG_H_

#include <wx/dialog.h>
#include <wx/spinctrl.h>
#include <wx/textctrl.h>
#include <wx/checkbox.h>
#include <wx/string.h>
#include <wx/slider.h>

#include "lib/lib_string.h"
#include "lib/commons.h"
#include "lib/tcolor.h"
#include "components/framework/tapplication.h"
#include "components/framework/translation.h"
#include "components/stdgui/tlabel.h"
#include "components/stdgui/tpanel.h"
#include "components/stdgui/tgenbutton.h"
#include "components/stdgui/tgenbuttonlistener.h"
#include "components/stdgui/thuesaturationmap.h"


/** Dialogue de fermeture de l'appli permettant de choisir les fichiers a sauvegarder */
class ColorDlg : public wxDialog, virtual public TranslatableCmp, TGenButtonListener
{
    TRANSLATABLE;
    public:
        ColorDlg(wxWindow * owner);
        virtual ~ColorDlg() {}

        /**
         * affiche le dialogue de recherche
         * @param initialColor couleur initiale
         * @return false si annule
         */
        bool show(const TColor & initialColor);

        /**
         * affiche le dialogue de recherche
         * @return false si annule
         */
        bool show();

        /**
         * renvoie la couleur selectionnee
         */
        TColor getColor() const;

        /**
         * indique si on doit utiliser la couleur corrigee
         */
        bool useGammaCorrection() const;

        virtual void buttonActivated(TGenButton * btn);

        /** changement d'tat d'une checkbox */
        void checkboxClicked(wxCommandEvent& event);

        /** changement de valeur d'un spinctrl */
        void spinctrlUpdated(wxSpinEvent& event);

        /** mets a jour les champs en fonction des couleurs stockes */
        void updateFields();

        /** dplacement du slider de "Value" */
        void sliderMoved(wxScrollEvent& event);

        /** click sur la map de hue/saturation */
        void hueSaturationMapClicked(wxMouseEvent & event);

    private:
        DECLARE_EVENT_TABLE();

        TColor stdColor;
        TColor correctedColor;

        THueSaturationMap * hueSatMap;
        wxSlider * valueSlider;

        TLabel * stdColorLbl;

        wxSpinCtrl * hueField;
        wxSpinCtrl * saturationField;
        wxSpinCtrl * valueField;

        wxSpinCtrl * redField;
        wxSpinCtrl * greenField;
        wxSpinCtrl * blueField;

        wxTextCtrl * decRedField;
        wxTextCtrl * decGreenField;
        wxTextCtrl * decBlueField;

        wxCheckBox * useGammaCorrectionChk;

        TLabel * correctedColorLbl;

        wxCheckBox * linkGammaCorrectionChk;

        wxSpinCtrl * gammaRedField;
        wxSpinCtrl * gammaGreenField;
        wxSpinCtrl * gammaBlueField;

        wxTextCtrl * correctedRedField;
        wxTextCtrl * correctedGreenField;
        wxTextCtrl * correctedBlueField;

        wxTextCtrl * decCorrectedRedField;
        wxTextCtrl * decCorrectedGreenField;
        wxTextCtrl * decCorrectedBlueField;

        TGenButton * btnOk;
        TGenButton * btnCancel;
        TGenButton * btnReset;
};

class ColorDlgRes : public TApplicationRessource
{
    public:
        ColorDlgRes();
        virtual ~ColorDlgRes() {}

        /** defini si on doit utiliser la correction gamma */
        void setUseGammaCorrection(const bool b) { this->bUseGammaCorrection = b; }
        /** defini si on doit utiliser la correction gamma */
        bool useGammaCorrection() const { return this->bUseGammaCorrection; }

        /** defini si on doit lier les canneaux de correction gamma */
        void setLinkGammaCorrection(const bool b) { this->bLinkGammaCorrection = b; }
        /** defini si on doit lier les canneaux de correction gamma */
        bool linkGammaCorrection() const { return this->bLinkGammaCorrection; }

        /** defini la correction gamma a utiliser */
        void storeGammaCorrection(double fRed, double fGreen, double fBlue);
        /** renvoie la correction gamma a utiliser */
        void getGammaCorrection(double * fRed, double * fGreen, double * fBlue);

        /** remet la correction  la valeur par dfaut */
        void resetGammaCorrection() { this->fGCRed = -1.0; this->fGCGreen = -1.0; this->fGCBlue = -1.0; }

        /** charge les parametres du composant a partir des informations contenues dans le noeud passe en parametre */
        virtual bool loadParameters(TiXmlElement * parametersNode);
        /** renvoie les parametres du composant sous la forme d'un noeud xml */
        virtual void fillParameters(TiXmlElement * root);

    private:
        bool bUseGammaCorrection;
        bool bLinkGammaCorrection;

        double fGCRed;
        double fGCGreen;
        double fGCBlue;
        bool bHasDefaultGC;
        double fDefaultGCRed;
        double fDefaultGCGreen;
        double fDefaultGCBlue;
};


#endif
