/***************************************************************************
 *   Copyright (C) 2005 by Thierry CHARLES   *
 *   thierry@les-charles.net   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "renderer_cfg.h"

#include <wx/filename.h>
#include <wx/filedlg.h>

#include "components/framework/tapplication.h"
#include "components/framework/tapplicationpanel.h"
#include "components/stdgui/tbitmap.h"
#include "xpe_components/res_id.h"
#include "xpe_components/panelelt/renderer_panelelt.h"

#include "lib/tprocess.h"
#include "lib/lib_file.h"

#include "xpe.h"

#include "bmp_id.h"

RendererConfigPanelElement::RendererConfigPanelElement(TApplicationPanel * _owner, int iID)
    :TConfigPanelElement(_owner, (iID < 0) ? static_cast<XPE *>(CurrentApplication())->getUPEID() : iID),
    contentPanel(NULL),
    reinitBtn(NULL),
    errorLabel(NULL),
    povBinField(NULL),
    povBinChooserBtn(NULL),
    povTransparencyFixChk(NULL)
{
    this->setName(wxTr("Povray"));
}

void RendererConfigPanelElement::buttonActivated(TGenButton * btn)
{
    if(btn == this->reinitBtn)
    {
        this->init();
    }
    else if(btn == this->povBinChooserBtn)
    {
        wxFileDialog * dlg = new wxFileDialog(dynamic_cast<wxWindow *>(this->getOwner()->getOwner()), wxTr("Choose the povray binary"), wxT(""), wxT(""), wxT("*"),wxOPEN|wxFILE_MUST_EXIST);
        int iRes = dlg->ShowModal();
        if(iRes == wxID_OK)
        {
            this->povBinField->SetValue(dlg->GetPath());
            this->canCommit();
        }
        delete dlg;
    }
}

/** initialise le panneau avec les parametres actuels de l'application */
void RendererConfigPanelElement::init()
{
    RendererRes * res = static_cast<RendererRes *>(CurrentApplication()->getRessource(POV_RENDERER_RESSOURCE_ID));
    if(res)
    {
        this->povBinField->SetValue(res->getRenderer());
        if(this->povTransparencyFixChk)
            this->povTransparencyFixChk->SetValue(res->useTransparencyFix());
    }
    else
    {
        this->povBinField->SetValue(RendererRes::getInitialisationValue());
        if(this->povTransparencyFixChk)
            this->povTransparencyFixChk->SetValue(false);
    }
    this->canCommit();
}

/** valide les modifications */
void RendererConfigPanelElement::commit()
{
    RendererRes * res = static_cast<RendererRes *>(CurrentApplication()->getRessource(POV_RENDERER_RESSOURCE_ID));
    if(!res)
    {
        res = new RendererRes();
        CurrentApplication()->publishRessource(POV_RENDERER_RESSOURCE_ID,res);
    }

    res->setRenderer(this->povBinField->GetValue());
    if(this->povTransparencyFixChk)
        res->setUseTransparencyFix(this->povTransparencyFixChk->IsChecked());
}

/** indique si le panneau est dans un tat valide */
bool RendererConfigPanelElement::canCommit()
{
    if(!this->povBinField->GetValue().length())
    {
        this->errorLabel->SetLabel(wxTr("Please choose povray executable"));
//        return false;
        return true;
    }

#ifdef __WXMSW__
    bool b = libfile::exists(this->povBinField->GetValue()) && libfile::isBinary(this->povBinField->GetValue());
    if(!b)
        this->errorLabel->SetLabel(wxTr("Unable to find ") + this->povBinField->GetValue());
#else
    TProcess proc;
    proc.setCommandLine(this->povBinField->GetValue());
    bool b = proc.start();
    if(b)
        proc.stop(true);
    if(!b)
        this->errorLabel->SetLabel(wxTr("Unable to execute ") + this->povBinField->GetValue());
#endif
    else
        this->errorLabel->SetLabel(wxT(""));
    this->contentPanel->GetSizer()->Layout();
    return b;
}

/** construit le panneau conteneur et son contenu (appell automatiquement par getContentPanel et dtruit automatiquement par le destructeur) */
TPanel * RendererConfigPanelElement::buildContentPanel()
{
    if(this->contentPanel)
        return this->contentPanel;

    this->contentPanel = new TPanel(dynamic_cast<wxWindow *>(this->getOwner()->getOwner()));
    wxBoxSizer * mainSizer = new wxBoxSizer( wxVERTICAL);
    contentPanel->SetSizer(mainSizer);

    mainSizer->AddSpacer(5);

    this->reinitBtn = new TGenButton(this->contentPanel);
    this->reinitBtn->setBitmap( GET_BMP(BMP_REFRESH_ID) );
    this->reinitBtn->setText(wxTr("Reload"));
    this->reinitBtn->addButtonListener( this );
    mainSizer->Add(this->reinitBtn,0,wxALIGN_RIGHT|wxLEFT|wxRIGHT,5);

    wxStaticText * label = new wxStaticText(this->contentPanel,-1,wxTr("Povray executable :"));
    mainSizer->Add(label,0,wxEXPAND|wxLEFT|wxRIGHT,5);

    mainSizer->AddSpacer(3);

    TPanel * panel = new TPanel(this->contentPanel);
    wxBoxSizer * sizer = new wxBoxSizer( wxHORIZONTAL );
    this->povBinField = new wxTextCtrl(panel, -1);
    sizer->Add(this->povBinField,1,wxEXPAND);
    sizer->AddSpacer(3);
    this->povBinChooserBtn = new TGenButton(panel);
    this->povBinChooserBtn->setBitmap( GET_BMP(BMP_FILE_OPEN_ID) );
    this->povBinChooserBtn->addButtonListener( this );
    sizer->Add(this->povBinChooserBtn,0,wxEXPAND);
    panel->SetSizer(sizer);
    mainSizer->Add(panel,0,wxEXPAND|wxLEFT|wxRIGHT,5);

    mainSizer->AddSpacer(3);

    this->errorLabel = new wxStaticText(this->contentPanel, -1, wxT(""));
    mainSizer->Add(this->errorLabel,0,wxALIGN_CENTER|wxLEFT|wxRIGHT,5);

    mainSizer->AddSpacer(5);

#ifndef __WXMSW__
    this->povTransparencyFixChk = new wxCheckBox(this->contentPanel, -1, wxTr("Use transparency fix"));
    mainSizer->Add(this->povTransparencyFixChk, 0, wxALIGN_LEFT|wxLEFT|wxRIGHT,5);
#endif

    mainSizer->AddStretchSpacer(10);

    return this->contentPanel;
}

