/***************************************************************************
 *   Copyright (C) 2005 by Thierry CHARLES   *
 *   thierry@les-charles.net   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "licensedlg.h"

#include <wx/panel.h>
#include <wx/sizer.h>
#include <wx/stattext.h>
#include <wx/textctrl.h>
#include <wx/button.h>

#include "lib/lib_string.h"

#include "license.h"

TLicenseDlg::TLicenseDlg()
    : wxDialog(NULL,-1,wxString(wxT("License agreement")))
{
    wxSizer * sizer = new wxBoxSizer(wxVERTICAL);
    wxStaticText * label = new wxStaticText(this,-1,wxT("To continue, you must agree with terms of the following license :"));
    sizer->Add(label,0,wxEXPAND|wxLEFT|wxRIGHT|wxTOP,5);

    wxTextCtrl * text = new wxTextCtrl(this,-1,ISO2WX(SZ_LICENSE),wxDefaultPosition,wxDefaultSize,wxTE_READONLY|wxTE_MULTILINE|wxHSCROLL);
    sizer->Add(text,1,wxEXPAND|wxLEFT|wxRIGHT,5);

    label = new wxStaticText(this,-1,wxT("Do you agree with terms of this license ?"));
    sizer->Add(label,0,wxEXPAND|wxLEFT|wxRIGHT,5);

    wxPanel * buttonsPanel = new wxPanel(this,-1);
    wxSizer * buttonsSizer = new wxBoxSizer(wxHORIZONTAL);

    buttonsSizer->AddStretchSpacer(10);

    wxButton * btn = new wxButton(buttonsPanel,wxID_YES);
    btn->SetDefault();
    buttonsSizer->Add(btn,0,wxEXPAND);

    btn = new wxButton(buttonsPanel,wxID_NO);
    buttonsSizer->Add(btn,0,wxLEFT|wxEXPAND,5);

    buttonsPanel->SetSizer(buttonsSizer);

    sizer->Add(buttonsPanel,0,wxEXPAND|wxLEFT|wxRIGHT|wxBOTTOM,5);

    this->SetSizer(sizer);
    sizer->Layout();

    this->SetSize(wxSize(800,600));
    this->Connect( wxID_YES, wxEVT_COMMAND_BUTTON_CLICKED, wxCommandEventHandler(TLicenseDlg::buttonClicked), NULL, this);
    this->Connect( wxID_NO, wxEVT_COMMAND_BUTTON_CLICKED, wxCommandEventHandler(TLicenseDlg::buttonClicked), NULL, this);
}

void TLicenseDlg::buttonClicked(wxCommandEvent & event)
{
    this->EndModal(event.GetId() == wxID_YES ? wxYES : wxNO);
}

