/***************************************************************************
 *   Copyright (C) 2005 by Thierry CHARLES   *
 *   thierry@les-charles.net   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef _LIBFILE_H_
#define _LIBFILE_H_

#include "lib/commons.h"
#include <wx/string.h>
#include <wx/dir.h>
#include <wx/arrstr.h>

namespace libfile
{
    wxString normalize(const wxString & sFullPath);
    wxString basename(const wxString & sFullPath);
    wxString extension(const wxString & sFilename);
    wxString dirname(const wxString & sFullPath);
    bool mkdir(const wxString & sFullPath);
    bool exists(const wxString & sFullPath);
    bool remove(const wxString & sFullPath);
    bool isAbsolute(const wxString & sFullPath);
    bool isBinary(const wxString & sFullPath);
    bool isFile(const wxString & sFullPath);
    bool isDirectory(const wxString & sFullPath);

    class TDirTraverser : public wxDirTraverser
    {
        public:
            TDirTraverser(wxArrayString& _files, wxArrayString& _dirs) : files(_files), dirs(_dirs) { }
            virtual ~TDirTraverser(){}

            virtual wxDirTraverseResult OnFile(const wxString& filename)
            {
                files.Add(filename);
                return wxDIR_CONTINUE;
            }

            virtual wxDirTraverseResult OnDir(const wxString& dirname)
            {
                dirs.Add(dirname);
                return wxDIR_IGNORE;
            }

        private:
            wxArrayString& files;
            wxArrayString& dirs;
    };
}

#endif

