/***************************************************************************
 *   Copyright (C) 2005 by Thierry CHARLES   *
 *   thierry@les-charles.net   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "lib_file.h"

#include <wx/ffile.h>
#include <wx/filefn.h>
#include <wx/filename.h>


namespace libfile
{
    wxString normalize(const wxString & sFullPath)
    {
        wxString sNomalizedName = sFullPath;
        sNomalizedName.Replace(wxT("\\"),wxT("/"));
        uint iReplacements;
        do
        {
            iReplacements = sNomalizedName.Replace(wxT("//"),wxT("/"));
        }
        while(iReplacements);
        return sNomalizedName;
    }

    wxString basename(const wxString & sFullPath)
    {
        wxString sBasename = normalize(sFullPath);
        int i = sBasename.Find('/',true);
        if(i < 0)
            return sBasename;
        if(sBasename.length() > uint(i+1))
            return sBasename.Mid(i+1);
        else
            return wxT("");
    }

    wxString extension(const wxString & sFilename)
    {
        wxString sBasename = basename(sFilename);
        int i = sBasename.Find('.',true);
        if(i < 0)
            return wxT("");
        return sBasename.Mid(i+1);
    }

    wxString dirname(const wxString & sFullPath)
    {
        return ::wxPathOnly(sFullPath);
    }

    bool mkdir(const wxString & sFullPath)
    {
        char c = sFullPath.GetChar(sFullPath.length()-1);
        wxFileName fname(sFullPath + ((c != '/' && c != '\\') ? wxT("/") : wxT("")));
        return fname.Mkdir(0755,wxPATH_MKDIR_FULL);
    }

    bool exists(const wxString & sFullPath)
    {
        return isFile(sFullPath) || isDirectory(sFullPath);
    }

    bool isFile(const wxString & sFullPath)
    {
        return ::wxFileExists(sFullPath);
    }

    bool isDirectory(const wxString & sFullPath)
    {
        char c = sFullPath.GetChar(sFullPath.length()-1);
        return ::wxDirExists(sFullPath + ((c != '/' && c != '\\') ? wxT("/") : wxT("")));
    }

    bool remove(const wxString & sFullPath)
    {
        if(!sFullPath.length())
            return false;

//        char c = sFullPath.GetChar(sFullPath.length()-1);
        if(::wxFileExists(sFullPath))
        {
            return ::wxRemoveFile(sFullPath);
        }
/*        else if(::wxDirExists(sFullPath + ((c != '/' && c != '\\') ? wxT("/") : wxT(""))))
        {
            return ::wxRmdir(sFullPath + ((c != '/' && c != '\\') ? wxT("/") : wxT("")));
        }*/
        else
            return false;
    }

    bool isAbsolute( const wxString & sFullPath )
    {
#ifdef __WXMSW__
        return (isalpha(sFullPath[0]) && sFullPath[1] == ':' && sFullPath[2] == '/');
#else
        return (sFullPath[0] == '/');
#endif
    }

    bool isBinary(const wxString & sFullPath)
    {
        static unsigned char buffer[4096];

        if(!wxFileName::FileExists(sFullPath))
            return false;

        // on fait un appel en C pour viter WX n'affiche un message d'erreur gRRR !
        FILE * fp = fopen((const char *)sFullPath.fn_str(),"rb");
        if(!fp)
            return true;
        wxFFile file(fp);
        if(!file.IsOpened())
            return true;
        size_t length = file.Read(buffer,4096);

        for(size_t i = 0 ; i < length ; i++)
        {
            unsigned char c = buffer[i];
            if(c != '\r' && c != '\n' && c != '\t' && (c < 0x20 || (c > 0x7E && c < 0xA0)))
            {
                return true;
            }
        }

        return false;
    }
}

