/***************************************************************************
 *   Copyright (C) 2005 by Thierry CHARLES   *
 *   thierry@les-charles.net   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "StdOutLogFormater.h"
#include "LoggingLevel.h"

#include <iostream>
#include <time.h>
#include <string.h>

namespace logging
{
    StdOutLogFormater::StdOutLogFormater(){}
    StdOutLogFormater::~StdOutLogFormater()
    {
        if(this == StdOutLogFormater::instance)
            StdOutLogFormater::instance = NULL;
    }

    StdOutLogFormater * StdOutLogFormater::getInstance()
    {
        if(StdOutLogFormater::instance == NULL)
            StdOutLogFormater::instance = new StdOutLogFormater();
        return StdOutLogFormater::instance;
    }

    /** enregistre le message prformat sur la sortie standard */
    void StdOutLogFormater::storeFormatedMessage(std::string sMessage)
    {
        std::cout << sMessage << std::endl;
    }

    StdOutLogFormater * StdOutLogFormater::instance = NULL;
}
