/***************************************************************************
 *   Copyright (C) 2005 by Thierry CHARLES   *
 *   thierry@les-charles.net   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef _STDGUI_TSPLITTER_H_
#define _STDGUI_TSPLITTER_H_

#include <wx/splitter.h>
#include "lib/commons.h"

/**
 * @short Un splitter
 * @author Thierry CHARLES <thierry@les-charles.net>
 * @version 0.1
 */
class TSplitter : public wxSplitterWindow
{
    public :
        TSplitter() : wxSplitterWindow(), bLocked(false) {}
        /** voir doc de wxSplitterWindow */
        TSplitter(wxWindow* parent, long iStyle = wxSP_3DSASH) : wxSplitterWindow(parent, -1, wxDefaultPosition, wxDefaultSize, iStyle), bLocked(false) {}

        virtual ~TSplitter(){}

        virtual bool OnSashPositionChange(int iPos){ if(this->bLocked) return false; else return wxSplitterWindow::OnSashPositionChange(iPos); }

        void setLocked(bool b) { this->bLocked = b; }
        bool getLocked() const { return this->bLocked; }

    private :
        bool bLocked;
};

#endif // _STDGUI_TSPLITTER_H_
