/***************************************************************************
 *   Copyright (C) 2005 by Thierry CHARLES   *
 *   thierry@les-charles.net   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef _TOOLBAR_PANEL_ELEMENT_H_
#define _TOOLBAR_PANEL_ELEMENT_H_

#include <map>
#include <deque>

#include "lib/commons.h"
#include "components/stdgui/tgenbutton.h"
#include "components/stdgui/tbitmap.h"
#include "components/stdgui/tgenbuttonlistener.h"
#include "components/framework/tapplication.h"
#include "components/framework/tpanelelement.h"


/**
 * @short Un �l�ment de panneau d'application affichant des icones de raccourci
 * @author Thierry CHARLES <thierry@les-charles.net>
 * @version 0.1
 */
class ToolbarPanelElement : public TPanelElement, private TGenButtonListener
{
    TRANSLATABLE;
    public:
        ToolbarPanelElement(TApplicationPanel * _owner, int iID = -1);
        virtual ~ToolbarPanelElement();

        /**
         * se d�clanche lors de la pression d'un bouton de la toolbar
         * @param iButtonID ID du bouton press�
         * @param bStateDown indique si le bouton est enfonc� ou relach�
         */
        virtual void buttonClicked(int iButtonID, bool bStateDown) = 0;

        /** ajoute un bouton � la barre d'outils. La barre se construit de gauche � droite ou de haut en bas selon l'orientation du panneau p�re. */
        void addButton(int iButtonID, const TBitmap * bmp, const wxString & sLabel, const wxString & sTooltip, bool bTogglable);

        /** ajoute un s�parateur � la barre d'outils. La barre se construit de gauche � droite ou de haut en bas selon l'orientation du panneau p�re. */
        void addSeparator();

        /** indique si il est possible d'afficher un titre pour le panneau */
        virtual bool mightShowTitleBar() const { return false; }

    protected:
        /** construit le panneau conteneur et son contenu (appell� automatiquement par getContentPanel et d�truit automatiquement par le destructeur) */
        virtual TPanel * buildContentPanel();

    private:
        /** g�re les �v�nements sur les boutons du composant */
        virtual void buttonActivated(TGenButton * btn);
        /** g�re les �v�nements sur les boutons du composant */
        virtual void buttonToggled(TGenButton * btn);

        struct TButtonInfo
        {
            int iButtonID;
            const TBitmap * bmp;
            wxString sLabel;
            wxString sTooltip;
            bool bTogglable;
            TGenButton * btn;
        };

        typedef std::deque<TButtonInfo> TButtonsInfoList;
        typedef std::map<TGenButton *,TButtonInfo *> TButtonsMap;

        TButtonsInfoList infoList;
        TButtonsMap btnsMap;

        TPanel * contentPanel;
};

#endif // _TOOLS_PANEL_ELEMENT_H_
