/***************************************************************************
 *   Copyright (C) 2006 by Thierry CHARLES   *
 *   thierry@les-charles.net   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef _STDGUI_TGENBUTTON_H_
#define _STDGUI_TGENBUTTON_H_ _

#include <wx/control.h>
#include <wx/string.h>
#include <set>

#include "lib/commons.h"
#include "components/framework/translation.h"

class TBitmap;
class TGenButtonListener;

/**
 * Un bouton generique avec image, label et toggleable
 * @author Thierry CHARLES
 */
class TGenButton : public wxControl, virtual public TranslatableCmp
{
    TRANSLATABLE;
    public:
        DECLARE_DYNAMIC_CLASS(TGenButton);
        virtual ~TGenButton(){}

        enum BitmapSide{Left,Right,Top,Bottom};
        enum TextOrientation{LeftToRight=0,TopToBottom=90,RightToLeft=180,BottomToTop=270};

        TGenButton(wxWindow * parent = NULL);

        /** defini le bouton comme plat */
        void setFlat(bool b);
        /** indique si le bouton est plat */
        bool isFlat() const { return this->bFlat; }

        /** defini le bouton comme toggleable */
        void setToggleable(bool b);
        /** indique si le bouton est toggleable */
        bool isToggleable() const { return this->bToggle; }

        /** defini le bouton comme enfonce */
        void setToggled(bool b);
        /** indique si le bouton est enfonce */
        bool isToggled() const { return this->bToggled; }

        /** defini le texte du bouton */
        void setText(const wxString & s);
        /** renvoie le texte du bouton */
        wxString getText() const { return this->sText; }
        /** renvoie le texte du bouton */
        const wxString & getText() { return this->sText; }
        /** defini l'orientation du texte */
        void setTextOrientation(TextOrientation orient);
        /** renvoie l'orientation du texte */
        TextOrientation getTextOrientation() const { return this->textOrientation; }

        /** defini l'image a afficher (NULL si aucune) */
        void setBitmap(const TBitmap * bmp);
        /** renvoie l'image affichee sur le bouton (NULL si aucune) */
        const TBitmap * getBitmap() const { return this->bitmap; }
        /** defini la position de l'image par rapport au texte */
        void setBitmapSide(BitmapSide side);
        /** renvoie la position de l'image par rapport au texte */
        BitmapSide getBitmapSide() const { return this->bitmapSide; }

        /** calcule la taille optimale du bouton */
        virtual wxSize DoGetBestSize() const;

        /** ajoute un ecouteur */
        bool addButtonListener(TGenButtonListener * l);
        /** enleve un ecouteur */
        bool removeButtonListener(TGenButtonListener * l);

        /** propage l'evenement "bouton active" aux ecouteurs */
        void fireButtonActivated();
        /** propage l'evenement "bouton bascule" aux ecouteurs */
        void fireButtonToggled();
        /** propage l'evenement "clic droit sur le bouton" aux ecouteurs */
        void fireButtonRightClicked();


        void onPaint(wxPaintEvent& event);
        void onMouseEnter(wxMouseEvent& event);
        void onMouseLeave(wxMouseEvent& event);
        void onMouseLeftDown(wxMouseEvent& event);
        void onMouseLeftUp(wxMouseEvent& event);
        void onMouseRightDown(wxMouseEvent& event);
        void onResize(wxSizeEvent & event);
        void onFocusChange(wxFocusEvent & event);
        void onKeyDown(wxKeyEvent & event);
        void onKeyUp(wxKeyEvent & event);

        DECLARE_EVENT_TABLE();

    protected:
        /** calcule si necessaire les tailles des elements composant l'image et les remplies */
        void getElementsSize(int & iTextWidth, int & iTextHeight, int & iBmpWidth, int & iBmpHeight) const;
        /** calcule si necessaire la taille de la composante textuelle du bouton et la remplie */
        void getTextElementSize(int & iTextWidth, int & iTextHeight) const;
        /** precalcule les dimentions des composants et les conserve de maniere a optimiser les traitements ulterieurs */
        void prepareElementsSize();

    private:
        bool bMouseInside;
        bool bDown;
        bool bFlat;
        bool bToggle;
        bool bToggled;

        int iRoundEdgeSize;

        wxString sText;
        TextOrientation textOrientation;
        int iOptimTextWidth;
        int iOptimTextHeight;

        const TBitmap * bitmap;
        BitmapSide bitmapSide;

        typedef std::set<TGenButtonListener *> TGenButtonListenersList;
        /** liste des ecouteurs */
        TGenButtonListenersList listeners;
};

#endif

