/***************************************************************************
 *   Copyright (C) 2005 by Thierry CHARLES   *
 *   thierry@les-charles.net   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef _TRANSLATION_SYSTEM_H_
#define _TRANSLATION_SYSTEM_H_

#include <wx/string.h>
#include <typeinfo>
#include "lib/commons.h"
#include "lib/lib_string.h"

/**
 * Cette classe defini un objet sachant traduire son interface.
 * Elle propose a cet effet une fonction de traduction prenant en parametre
 * le contexte d'execution ainsi que le texte a traduire. A partir de la, le
 * systeme s'occupe de rechercher une reference dans sa base isue d'un fichier
 * de traduction.
 */
class TranslatableCmp
{
    protected:
        /** renvoie le contexte par d�faut pour cet objet (nom de la classe) */
        virtual wxString getDefaultContext() const = 0;

    public:
        virtual ~TranslatableCmp(){}

        /** demande la traduction du texte a l'application */
        wxString tr(const wxString & sToTranslate) const { return this->tr(this->getDefaultContext(), sToTranslate ); }
        /** demande la traduction du texte a l'application */
        wxString tr(const wxString & sContext, const wxString & sToTranslate) const;

        /** demande la traduction du texte a l'application */
        static wxString _tr(const wxString & sToTranslate);
};

/** combinaison de la macro wxT et de l'appel a la m�thode tr(wxString) */
#define wxTr(s) tr(wxT(s))

/** combinaison de la macro wxT et de l'appel a la m�thode _tr(wxString) */
#define wxSTr(s) _tr(wxT(s))

/** d�fini les �l�ments n�cessaires au syst�me de traduction. Doit etre place dans une zone de declaration private */
#define TRANSLATABLE \
    protected: \
virtual wxString getDefaultContext() const \
{ \
    const char * szTypeName = typeid(this).name(); \
    while(szTypeName[0] == 'P' || szTypeName[0] == 'K') \
        szTypeName++; \
    while(isdigit(szTypeName[0])) \
        szTypeName++; \
    return ISO2WX(szTypeName); \
} \
    private:


#endif

