/***************************************************************************
 *   Copyright (C) 2005 by Thierry CHARLES   *
 *   thierry@les-charles.net   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef _TPANEL_ELEMENT_H_
#define _TPANEL_ELEMENT_H_

#include <wx/string.h>

#include <wx/menu.h>

class TPanel;
class TBitmap;

class TApplicationPanel;

#include "lib/commons.h"
#include "components/framework/xmlcfgcmp.h"
#include "components/framework/translation.h"

/**
 * Un element de panneau d'application
 * @author Thierry CHARLES <thierry@les-charles.net>
 * @version 0.1
 */
class TPanelElement : public XmlConfiguredComponent, virtual public TranslatableCmp
{
    public:
        TPanelElement(TApplicationPanel * _owner, int iID, const wxString & _sName = wxT(""), wxString _sTooltip = wxT("")) : owner(_owner), iEltId(iID), sName(_sName), sTooltip(_sTooltip), bAlwaysVisible(false), bMightBeVisible(false), contentPanel(NULL), bitmap(NULL), iExtensivity(1)
        {
            if(!iEltId)
                fprintf(stderr,"id null !!!!\n");
        }
        virtual ~TPanelElement();

        /** renvoie une reference constante au nom du composant */
        const wxString & getName() { return this->sName; }
        /** renvoie le nom du composant */
        wxString getName() const { return this->sName; }
        /** definit le nom du composant */
        void setName(const wxString & sName);

        /** renvoie une reference constante a la description du composant */
        const wxString & getTooltip() { return this->sTooltip; }
        /** renvoie la description du composant */
        wxString getTooltip() const { return this->sTooltip; }
        /** definit la description du composant */
        void setTooltip(const wxString & sTooltip);


        /** renvoie l'ID du composant */
        int getID() const { return this->iEltId; }
        /** definit l'ID du composant */
        void setID(const int iID) { this->iEltId = iID; }

        /** indique si le composant doit toujours etre visible */
        bool isAlwaysVisible() const { return this->bAlwaysVisible; }
        /** defini si le composant doit toujours etre visible */
        void setAlwaysVisible( bool b ) { this->bAlwaysVisible = b; }


        /** libre les ressources graphiques */
        virtual void discardContentPanel();

        TPanel * getContentPanel();

        /** renvoie l'image associee au panneau */
        const TBitmap * getBitmap() const { return this->bitmap; }

        /** indique si il faut ajouter une croix de fermeture sur l'onglet */
        virtual bool mightShowClosingCross() const { return false; }

        /** demande la fermeture du panneau */
        virtual void doCloseElement() {}

        /** renvoie le panneau auquel cet element appartient */
        TApplicationPanel * getOwner() const { return this->owner; }
        /** defini le panneau proprietaire de l'objet. Il est TRES fortement recommande de surcharger cet methode pour agir sur les elements sous-jacents */
        void setOwner(TApplicationPanel * _owner) { this->owner = _owner; }

        /** defini la propension de l'element a s'etendre lorsqu'il reste de la place sur le panneau (0 => ne s'etend pas, >0 => extension relative aux autres elements */
        void setExtensivity( const int iExtensivity ) { this->iExtensivity = iExtensivity; }
        /** indique la propension de l'element a s'etendre lorsqu'il reste de la place sur le panneau (0 => ne s'etend pas, >0 => extension relative aux autres elements */
        int getExtensivity() const { return this->iExtensivity; }

        /** renvoie une constante identifiant le type de cet element de maniere a pouvoir le reconstruire lors du chargement des preferences */
        virtual const char * getElementType() const = 0;

        /** charge les parametres du composant a partir des informations contenues dans le noeud passe en parametre */
        virtual bool loadParameters(TiXmlElement * parametersNode);
        /** renvoie les parametres du composant sous la forme d'un noeud xml */
        virtual TiXmlElement * getParameters();

        /** renvoie le menu a afficher en cas de click droit sur le bouton representant */
        virtual wxMenu * getPopupMenu() { return NULL; }

        /** indique si il est possible d'afficher un titre pour le panneau */
        virtual bool mightShowTitleBar() const { return true; }

    protected:
        /** construit le panneau conteneur et son contenu (appelle automatiquement par getContentPanel et detruit automatiquement par le destructeur) */
        virtual TPanel * buildContentPanel() = 0;
        /** defini l'image qui doit servir d'icone. devrait etre appele dans le constructeur */
        void setBitmap(const TBitmap * bitmap);

    private:
        TApplicationPanel * owner;
        int                 iEltId;
        wxString            sName;
        wxString            sTooltip;
        bool                bAlwaysVisible;
        bool                bMightBeVisible;
        TPanel *            contentPanel;
        const TBitmap *     bitmap;
        int                 iExtensivity;
};

#endif // _TPANEL_ELEMENT_H_
