/***************************************************************************
 *   Copyright (C) 2005 by Thierry CHARLES   *
 *   thierry@les-charles.net   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "tpanelelement.h"
#include "tapplicationpanel.h"

#include <wx/sizer.h>

#include "components/stdgui/tpanel.h"
#include "components/stdgui/tbitmap.h"


TPanelElement::~TPanelElement()
{
    this->discardContentPanel();
}

TPanel * TPanelElement::getContentPanel()
{
    if(!this->contentPanel)
        this->contentPanel = this->buildContentPanel();

    return this->contentPanel;
}

void TPanelElement::setName(const wxString & sName)
{
    this->sName = sName;
    this->owner->panelElementNameUpdated(this);
}

void TPanelElement::discardContentPanel()
{
    if(!this->contentPanel)
        return;

    this->getOwner()->getComposedPanel()->GetSizer()->Detach(this->contentPanel);

    delete this->contentPanel;
    this->contentPanel = NULL;
}

/** dfinit la description du composant */
void TPanelElement::setTooltip(const wxString & sTooltip)
{
    this->sTooltip = sTooltip;
    this->owner->panelElementTooltipUpdated(this);
}

/** dfini l'image qui doit servir d'icone. devrait tre appel dans le constructeur */
void TPanelElement::setBitmap(const TBitmap * bitmap)
{
     this->bitmap = bitmap;
     this->owner->panelElementBitmapUpdated(this);
}

/** charge les parametres du composant a partir des informations contenues dans le noeud pass� en param�tre */
bool TPanelElement::loadParameters(TiXmlElement * parametersNode)
{
    return true;
}

/** renvoie les parametres du composant sous la forme d'un noeud xml */
TiXmlElement * TPanelElement::getParameters()
{
    TiXmlElement * root = new TiXmlElement(XMLCC_NODE_ELEMENT_PARAMS);
    return root;
}
