/***************************************************************************
 *   Copyright (C) 2005 by Thierry CHARLES   *
 *   thierry@les-charles.net   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef _THREADHANDLER_H_
#define _THREADHANDLER_H_

#include "lib/commons.h"
#include <set>

/**
 * Gestionnaire de threads int�gr� permettant l'arret automatique du thread qu'il dirige avant que WX ne mette la pagaille
 * @short Gestionnaire de threads
 */
class ThreadHandler
{
    public:
        ThreadHandler();
        virtual ~ThreadHandler();

        /** arrete le thread le plus vite possible. Cette m�thode est appell�e a la fermeture de l'application avant que WX ne commence la lib�ration de ses donn�es sur les thread et en rende l'arret impossible. L'objet thread devrait �tre d�truit �galement ! */
        virtual void haltThread() = 0;
};

typedef std::set<ThreadHandler *> TThreadHandlersList;

#endif //_THREADHANDLER_H_
