/***************************************************************************
 *   Copyright (C) 2005 by Thierry CHARLES   *
 *   thierry@les-charles.net   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "tconfigdlg.h"
#include "tapplicationpanel.h"
#include "tapplication.h"
#include "tmainwindow.h"

#include "components/stdgui/tpanel.h"

#include "lib/lib_logging.h"

TConfigDlg::TConfigDlg()
    : wxDialog(CurrentApplication()->getMainWindow(),-1,wxT("Preferences"), wxDefaultPosition,wxDefaultSize,wxDEFAULT_DIALOG_STYLE|wxSTAY_ON_TOP|wxRESIZE_BORDER), TApplicationWindow(wxT("TConfigDlg")),
    panel(NULL),btnOk(NULL),btnCancel(NULL),lastRefused(NULL)
{
    this->SetTitle( wxTr("Preferences") );

    this->panel = new TApplicationPanel(this,CONFIG_DLG_MAINPANEL_ID,TApplicationPanel::Left);
    this->panel->setDisplayMode(TApplicationPanel::Exclusive);
    this->panel->setMightHaveNoVisibleElement(false);
    this->registerPanel(this->panel);

    wxSizer * mainSizer = new wxBoxSizer(wxVERTICAL);

    TPanel * mainPanel = this->panel->getComposedPanel();
    mainPanel->Reparent(this);
    mainSizer->Add(mainPanel,1,wxTOP|wxLEFT|wxRIGHT|wxEXPAND,5);

    mainSizer->AddSpacer(3);

    wxPanel * buttonsPanel = new wxPanel(this,-1);
    wxSizer * buttonsSizer = new wxBoxSizer(wxHORIZONTAL);

    buttonsSizer->AddStretchSpacer(10);

    this->btnOk = new TGenButton(buttonsPanel);
    this->btnOk->setText(wxTr("OK"));
    this->btnOk->addButtonListener(this);
    buttonsSizer->Add(this->btnOk,0,wxEXPAND);

    this->btnCancel = new TGenButton(buttonsPanel);
    this->btnCancel->setText(wxTr("Cancel"));
    this->btnCancel->addButtonListener(this);
    buttonsSizer->Add(this->btnCancel,0,wxLEFT|wxEXPAND,5);
    buttonsPanel->SetSizer(buttonsSizer);

    mainSizer->Add(buttonsPanel,0,wxLEFT|wxRIGHT|wxBOTTOM|wxEXPAND,5);
    this->SetSizer(mainSizer);
}


/** initialise tous les panneaux contenus avec les parametres actuels de l'application */
void TConfigDlg::init()
{
    for(int i = 0 ; i < this->panel->getElementsCount() ; i++)
    {
        static_cast<TConfigPanelElement *>(this->panel->getElementAt( i ))->init();
    }
}

/** valide les modifications sur tous les panneaux contenus */
void TConfigDlg::commit()
{
    for(int i = 0 ; i < this->panel->getElementsCount() ; i++)
    {
        static_cast<TConfigPanelElement *>(this->panel->getElementAt( i ))->commit();
    }
}

/** indique si tous les panneaux sont dans un tat valide */
bool TConfigDlg::canCommit()
{
    for(int i = 0 ; i < this->panel->getElementsCount() ; i++)
    {
        TConfigPanelElement * elt = static_cast<TConfigPanelElement *>(this->panel->getElementAt( i ));
        if(!elt->canCommit())
        {
            this->lastRefused = elt;
            return false;
        }
    }
    this->lastRefused = NULL;
    return true;
}

/** ajoute un element a la liste des panneaux de configuration */
void TConfigDlg::addConfigElement(TConfigPanelElement * elt)
{
    this->panel->addElement( elt );
}

/** enleve un element de la liste des panneaux de configuration */
void TConfigDlg::removeConfigElement(int iEltID )
{
    this->panel->removeElement( iEltID, true );
}

/** click bouton */
void TConfigDlg::buttonActivated(TGenButton * btn)
{
    if(btn == this->btnOk)
    {
        if(this->canCommit())
        {
            this->commit();
            this->EndModal(wxID_OK);
        }
        else
        {
            wxMessageBox(wxTr("Incorrect parameters."), wxTr("Erreur"),wxOK|wxICON_ERROR,this);
            if(this->lastRefused)
            {
                this->panel->setElementVisible( this->lastRefused->getID(), true );
            }
        }
    }
    else
    {
        this->EndModal(wxID_CANCEL);
    }
}

/** affiche le dialogue de gestion des preferences */
int TConfigDlg::ShowModal()
{
    this->init();
    this->GetSizer()->Layout();
    wxSize maxBestSize = this->GetSize();
    wxSize diffSize;
    if(this->panel->getElementsCount())
    {
        wxSize bestSize = this->panel->getElementAt(0)->getContentPanel()->GetBestSize();
        diffSize.SetWidth(maxBestSize.GetWidth() - bestSize.GetWidth());
        diffSize.SetHeight(maxBestSize.GetHeight() - bestSize.GetHeight());
    }
    for(int i = 0 ; i < this->panel->getElementsCount() ; i++)
    {
        wxSize bestSize = this->panel->getElementAt(i)->getContentPanel()->GetBestSize();
        if(bestSize.GetWidth() > maxBestSize.GetWidth())
            maxBestSize.SetWidth(bestSize.GetWidth());
        if(bestSize.GetHeight() > maxBestSize.GetHeight())
            maxBestSize.SetHeight(bestSize.GetHeight());
    }
    maxBestSize.SetWidth(diffSize.GetWidth() + maxBestSize.GetWidth());
    maxBestSize.SetHeight(diffSize.GetHeight() + maxBestSize.GetHeight());
    this->SetSize(maxBestSize);
    return wxDialog::ShowModal();
}
