/***************************************************************************
 *   Copyright (C) 2005 by Thierry CHARLES   *
 *   thierry@les-charles.net   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef _ELEMENT_INFO_H_
#define _ELEMENT_INFO_H_

#include "lib/commons.h"

#include <wx/string.h>

class TBitmap;

/**
 * cette classe contient les lments de base au controle des lments.
 * Elle n'est pas utilise dans le framework, elle est juste a disposition des dveloppeurs
 */
class TPanelElementInfo
{
    public:
        TPanelElementInfo()
            : szType(NULL), sTypeName(wxT("")), iMinOccurs(0), iMaxOccurs(0), iOccurences(0), bmp(NULL)
        {}
        TPanelElementInfo(const char * _szType, wxString _sTypeName, const TBitmap * _icon, uint _iMinOccurs, uint _iMaxOccurs)
            : szType(_szType), sTypeName(_sTypeName), iMinOccurs(_iMinOccurs), iMaxOccurs(_iMaxOccurs), iOccurences(0), bmp(_icon)
        {}
        virtual ~TPanelElementInfo(){}

        /** vrifie que les contraintes lies  l'lment sont bien vrifies */
        virtual bool checkConstraints() const { return (this->iOccurences >= this->iMinOccurs)
                                    && (this->iOccurences <= this->iMaxOccurs); }

        /** traite l'ajout d'une occurence */
        void inc() { this->iOccurences++; }
        /** traite la suppression d'une occurence */
        void dec() { if(this->iOccurences) this->iOccurences--; }

        /** renvoie le type de l'lement */
        const char * getType() const { return this->szType; }
        /** renvoie le nom du type de l'lement (devrait etre unique) */
        const wxString getTypeName() const { return this->sTypeName; }
        /** renvoie le nombre minimum d'occurences de l'lement */
        uint getMinOccurs() const { return this->iMinOccurs; }
        /** renvoie le nombre maximum d'occurences de l'lement */
        uint getMaxOccurs() const { return this->iMaxOccurs; }
        /** renvoie le nombre d'occurences dclares de l'lement */
        uint getOccurences() const { return this->iOccurences; }
        /** renvoie l'icone a utiliser pour ce type d'lment (pourrait etre NULL) */
        const TBitmap * getIcon() const { return this->bmp; }


        /** indique si on peut ajouter un lment */
        bool canAdd() const { return this->iOccurences < this->iMaxOccurs; }

        /** indique si on peut supprimer un lment */
        bool canDel() const { return this->iOccurences > this->iMinOccurs; }

    private:
        const char * szType;
        wxString sTypeName;
        uint iMinOccurs;
        uint iMaxOccurs;
        uint iOccurences;
        const TBitmap * bmp;
};



#endif
