/***************************************************************************
 *   Copyright (C) 2005 by Thierry CHARLES   *
 *   thierry@les-charles.net   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef _TPOINT_H_
#define _TPOINT_H_

#include <ostream>
#include "lib/commons.h"

/**
 * @short Un point avec des coordonn�es enti�res
 * @author Thierry CHARLES <thierry@les-charles.net>
 * @version 0.1
 */
struct TPoint
{
    int x;
    int y;
    
    TPoint() : x(-1),y(-1) {}
    TPoint(int _x, int _y) : x(_x), y(_y) {}
    
    /** renvoie true si x et y sont positifs */
    bool isValid() const { return ((this->x >= 0) && (this->y >= 0)); }
};

bool operator <  (const TPoint &ptA,const TPoint &ptB);
bool operator >  (const TPoint &ptA,const TPoint &ptB);
bool operator <= (const TPoint &ptA,const TPoint &ptB);
bool operator >= (const TPoint &ptA,const TPoint &ptB);
bool operator == (const TPoint &ptA,const TPoint &ptB);
bool operator != (const TPoint &ptA,const TPoint &ptB);

std::ostream & operator << (std::ostream &out, const TPoint &pt);
#endif
