/***************************************************************************
 *   Copyright (C) 2006 by Thierry CHARLES   *
 *   thierry@les-charles.net   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef _STDGUI_TCLOCK_H_
#define _STDGUI_TCLOCK_H_ _

#include <wx/control.h>
#include <wx/timer.h>

#include "lib/commons.h"
#include "components/stdgui/tbitmap.h"
#include "components/framework/translation.h"

#define _STDGUI_TCLOCK_PAINT_TIMER_ 1

/**
 * Une horloge
 * @author Thierry CHARLES
 */
class TClock : public wxControl, virtual public TranslatableCmp
{
    TRANSLATABLE;
    public:
        DECLARE_DYNAMIC_CLASS(TClock);

        enum ClockType{Analogical,Digital};


        TClock(wxWindow * parent = NULL);
        virtual ~TClock();

        /** resize ==> dessine le composant */
        void onSize(wxSizeEvent& event);
        /** dessine le composant */
        void onPaint(wxPaintEvent& event);
        /** traite les evenements du timer de redessinage */
        void onPaintTimer(wxTimerEvent& event) { this->Refresh(); }

        /** d�fini le type d'horloge */
        void setClockType( const ClockType& type ) { this->clockType = type; }
        /** indique le type d'horloge */
        ClockType getClockType() const { return this->clockType; }

        /** calcule la taille optimale de l'horloge */
        virtual wxSize DoGetBestSize() const;

        /** affiche ou cache le composant */
        virtual bool Show(bool show = true);

        /** configure l'horloge pour l'affichage des secondes */
        void setDisplaySeconds( bool b );
        /** indique si l'horloge est configur�e pour l'affichage des secondes */
        bool getDisplaySeconds() const { return this->bSeconds; }

        /** configure l'horloge pour l'affichage de la date */
        void setDisplayDate( bool b ) {  this->bDate = b; }
        /** indique si l'horloge est configur�e pour l'affichage de la date */
        bool getDisplayDate() const { return this->bDate; }

        /** d�fini la taille du cadran ou de la police suivant le type d'horloge */
        void setClockSize( const int iSize );
        /** donne la taille du cadran ou de la police suivant le type d'horloge */
        int getClockSize() const { return this->iClockSize; }

        /** d�fini comment sont affich�s les nombres des heures */
        void setNumbersProperties(bool bHasNumbers, bool bMightHaveSubNumbers);
        /** indique si les nombres des quarts sont affich�s */
        bool getHasNumbers() { return this->bHasNumbers; }
        /** indique si tous les nombres des heures peuvent etre affich�s */
        bool getMightHaveSubNumbers() { return this->bMightHaveSubNumbers; }

        /** d�fini comment sont affich�s les rep�res des heures */
        void setDecorationsProperties(bool bHasDecorations, bool bMightHaveSubDecorations);
        /** indique si les rep�res des quarts sont affich�s */
        bool getHasDecorations() { return this->bHasDecorations; }
        /** indique si tous les rep�res des heures peuvent etre affich�s */
        bool getMightHaveSubDecorations() { return this->bMightHaveSubDecorations; }

        DECLARE_EVENT_TABLE();

    protected:
        void flushCache();
        void prepareMinuteBitmap(const tm & timeStruct);
        void prepareBG();

    private:
        ClockType   clockType;
        int         iClockSize;
        bool        bHasNumbers;
        bool        bMightHaveSubNumbers;
        bool        bHasDecorations;
        bool        bMightHaveSubDecorations;
        bool        bSeconds;
        bool        bDate;
        wxTimer     paintTimer;
        int         iLastMinute;
        TBitmap     * minuteBitmap;
        TBitmap     * bg;
};

#endif

