/***************************************************************************
 *   Copyright (C) 2005 by Thierry CHARLES   *
 *   thierry@les-charles.net   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef _CLOCK_PANEL_ELEMENT_H_
#define _CLOCK_PANEL_ELEMENT_H_

#include <wx/menu.h>
#include <wx/event.h>
#include "lib/commons.h"
#include "components/framework/tapplication.h"
#include "components/framework/tpanelelement.h"
#include "components/framework/elementinfo.h"

#define PELT_TYPE_TCLOCK "PELT_TYPE_TCLOCK"

class TClock;
class TBitmap;

/**
 * @short Un element de panneau d'application affichant une horloge
 * @author Thierry CHARLES <thierry@les-charles.net>
 * @version 0.1
 */
class ClockPanelElement : public TPanelElement, public wxEvtHandler
{
    TRANSLATABLE;
    public:
        ClockPanelElement(TApplicationPanel * _owner, int iID = -1);
        virtual ~ClockPanelElement();

        virtual void onMouseRightDown(wxMouseEvent & evt);
        virtual void onMenuClick(wxCommandEvent& evt);

        /** renvoie une constante identifiant le type de cet element de maniere a pouvoir le reconstruire lors du chargement des preferences */
        virtual const char * getElementType() const { return PELT_TYPE_TCLOCK; }

        /** charge les parametres du composant a partir des informations contenues dans le noeud passe en parametre */
        virtual bool loadParameters(TiXmlElement * parametersNode);
        /** renvoie les parametres du composant sous la forme d'un noeud xml */
        virtual TiXmlElement * getParameters();
        /** indique si le composant doit etre sauvegarde */
        virtual bool mightBeSaved() const { return true; }

        static TPanelElementInfo getElementInfo() { return TPanelElementInfo(PELT_TYPE_TCLOCK,wxSTr("Clock"),getDefaultIcon(), 0, 99); }

        /** renvoie le menu a afficher en cas de click droit sur le bouton representant */
        virtual wxMenu * getPopupMenu();

    protected:
        /** construit le panneau conteneur et son contenu (appelle automatiquement par getContentPanel et detruit automatiquement par le destructeur) */
        virtual TPanel * buildContentPanel();

        /** defini la taille de l'horloge et de la police de la date */
        void setClockSize(int iSize);

    private:
        void buildMenu();

        static TBitmap * defaultIcon;
        static const TBitmap * getDefaultIcon();

        TClock * clock;
        wxMenu * rightClickMenu;
        wxMenu * tailleSubMenu;
        bool bDigital;
        bool bDate;
        bool bSeconds;
        bool bDecorations;
        bool bDecorationsDetail;
        bool bNumbers;
        bool bNumbersDetail;
        int iClockSize;

        enum MenuItems{
            Menu_Digital = MENU_ID_STATIC_FIRST,
            Menu_Date,
            Menu_Seconds,
            Menu_Decorations,
            Menu_DecDetails,
            Menu_Numbers,
            Menu_NumDetails,
            Menu_Size_50,
            Menu_Size_100,
            Menu_Size_150,
            Menu_Size_200,
        };
};

#endif // _CLOCK_PANEL_ELEMENT_H_
