/***************************************************************************
 *   Copyright (C) 2006 by Thierry CHARLES   *
 *   thierry@les-charles.net   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef _STDGUI_TCALCULATOR_H_
#define _STDGUI_TCALCULATOR_H_ _

#include <wx/colour.h>

#include "lib/commons.h"
#include "components/stdgui/tpanel.h"
#include "components/stdgui/tlabel.h"
#include "components/stdgui/tgenbutton.h"
#include "components/stdgui/tgenbuttonlistener.h"
#include "components/framework/tapplication.h"
#include "components/framework/translation.h"

// 1 radian = 57 degres
#define TCALCULATOR_RADIAN_DEGREE_RATIO 57.295779513

class InvalidExpressionException
{
    public :
        InvalidExpressionException(const wxString & s = wxT("")) : sMessage(s) {}
        const wxString & getMessage() const { return this->sMessage; }
    private :
        wxString sMessage;
};

/**
 * Une calculatrice
 * @author Thierry CHARLES
 */
class TCalculator : public TPanel, virtual public TranslatableCmp, public TGenButtonListener
{
    TRANSLATABLE;
    public:
        DECLARE_DYNAMIC_CLASS(TCalculator);

        TCalculator(wxWindow * parent = NULL);
        virtual ~TCalculator();

        /** un bouton a ete active */
        virtual void buttonActivated(TGenButton * btn);
        
        /** une action a t ralise sur le composant */
        virtual void perform(const wxString & sAction);
        
        /** value une expression mathmatique */
        double evaluate(const wxString & sExp) throw (InvalidExpressionException);
        
        virtual void onKeyEvent(wxKeyEvent & _keyEvent);
        virtual void onRightClick(wxMouseEvent & _mouseEvent);
        virtual void onMenuClick(wxCommandEvent& evt);
        
        /** renvoie le menu a afficher en cas de click droit sur le bouton representant */
        virtual wxMenu * getPopupMenu();
        
        DECLARE_EVENT_TABLE();
    protected:

    private:
        void buildMenu();
        void perform(const wxString & sFunction, wxString & sFormula);
        void buildButton(TPanel * panel, const wxString & s, const wxColour & colour, const wxString & t = wxT(""));
        
        double readFormula(const wxString & sExp, int & iStartPos) throw (InvalidExpressionException);
        double readNumber(const wxString & sExp, int & iStartPos) throw (InvalidExpressionException);
        double readTerminal(const wxString & sExp, int & iStartPos) throw (InvalidExpressionException);
        
        
        TLabel * display;
        
        wxMenu * rightClickMenu;
        
        enum MenuItems{
            Menu_Copy = MENU_ID_STATIC_FIRST
        };
};

#endif

