/***************************************************************************
 *   Copyright (C) 2005 by Thierry CHARLES   *
 *   thierry@les-charles.net   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef _CALCULATOR_PANEL_ELEMENT_H_
#define _CALCULATOR_PANEL_ELEMENT_H_

#include "lib/commons.h"
#include "components/framework/tapplication.h"
#include "components/framework/tpanelelement.h"
#include "components/framework/elementinfo.h"

#define PELT_TYPE_TCALCULATOR "PELT_TYPE_TCALCULATOR"

class TCalculator;
class TBitmap;

/**
 * @short Un element de panneau d'application affichant une calculatrice
 * @author Thierry CHARLES <thierry@les-charles.net>
 */
class CalculatorPanelElement : public TPanelElement, public wxEvtHandler
{
    TRANSLATABLE;
    public:
        CalculatorPanelElement(TApplicationPanel * _owner, int iID = -1);
        virtual ~CalculatorPanelElement();

        /** renvoie une constante identifiant le type de cet element de maniere a pouvoir le reconstruire lors du chargement des preferences */
        virtual const char * getElementType() const { return PELT_TYPE_TCALCULATOR; }

        /** indique si le composant doit etre sauvegarde */
        virtual bool mightBeSaved() const { return true; }

        static TPanelElementInfo getElementInfo() { return TPanelElementInfo(PELT_TYPE_TCALCULATOR,wxSTr("Calculator"),getDefaultIcon(), 0, 99); }

    protected:
        /** construit le panneau conteneur et son contenu (appelle automatiquement par getContentPanel et detruit automatiquement par le destructeur) */
        virtual TPanel * buildContentPanel();

    private:
        static TBitmap * defaultIcon;
        static const TBitmap * getDefaultIcon();

        TCalculator * calculator;
};

#endif // _CALCULATOR_PANEL_ELEMENT_H_
