/*
 * WriteWonderlandCellRenderCode.cpp
 *
 * Copyright (C) 2009 J. "MUFTI" Scheurich
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program (see the file "COPYING" for details); if 
 * not, write to the Free Software Foundation, Inc., 675 Mass Ave, 
 * Cambridge, MA 02139, USA.
 */

/*
 * Copyright (c) 2004-2009, Sun Microsystems, Inc., All Rights Reserved
 *
 * Redistributions in source code form must reproduce the above
 * copyright and this condition.
 *
 * The contents of this file are subject to the GNU General Public
 * License, Version 2 (the "License"); you may not use this file
 * except in compliance with the License. A copy of the License is
 * available at http://www.opensource.org/licenses/gpl-license.php.
 *\n") )
 * Sun designates this particular file as subject to the "Classpath"
 * exception as provided by Sun in the License file that accompanied
 * this code.
 */

// The license file:

/*
The GNU General Public License (GPL) Version 2, June 1991
Copyright (C) 1989, 1991 Free Software Foundation, Inc.
59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
Everyone is permitted to copy and distribute verbatim copies
of this license document, but changing it is not allowed.

Preamble

The licenses for most software are designed to take away your freedom to share
and change it. By contrast, the GNU General Public License is intended to
guarantee your freedom to share and change free software--to make sure the
software is free for all its users. This General Public License applies to most
of the Free Software Foundation's software and to any other program whose author
commit to using it. (Some other Free Software Foundation software is covered by
the GNU Library General Public License instead.) You can apply it to your
programs, too.

When we speak of free software, we are referring to freedom, not price. Our
General Public Licenses are designed to make sure that you have the freedom to
distribute copies of free software (and charge for this service if you wish),
that you receive source code or can get it if you want it, that you can change
the software or use pieces of it in new free programs; and that you know you
can do these things.

To protect your rights, we need to make restrictions that forbid anyone to deny
you these rights or to ask you to surrender the rights. These restrictions
translate to certain responsibilities for you if you distribute copies of the
software, or if you modify it.

For example, if you distribute copies of such a program, whether gratis or for
a fee, you must give the recipients all the rights that you have. You must make
sure that they, too, receive or can get the source code. And you must show them
these terms so they know their rights.

We protect your rights with two steps: (1) copyright the software, and (2) offer
you this license which gives you legal permission to copy, distribute and/or
modify the software.

Also, for each author's protection and ours, we want to make certain that
everyone understands that there is no warranty for this free software. If the
software is modified by someone else and passed on, we want its recipients to
know that what they have is not the original, so that any problems introduced
by others will not reflect on the original authors' reputations.

Finally, any free program is threatened constantly by software patents. We wish 
to avoid the danger that redistributors of a free program will individually
obtain patent licenses, in effect making the program proprietary. To prevent
this, we have made it clear that any patent must be licensed for everyone's
free use or not licensed at all.

The precise terms and conditions for copying, distribution and modification
follow.

TERMS AND CONDITIONS FOR COPYING, DISTRIBUTION AND MODIFICATION

0. This License applies to any program or other work which contains a notice
placed by the copyright holder saying it may be distributed under the terms of
this General Public License. The "Program", below, refers to any such program
or work, and a "work based on the Program" means either the Program or any
derivative work under copyright law: that is to say, a work containing the
Program or a portion of it, either verbatim or with modifications and/or
translated into another language. (Hereinafter, translation is included without
limitation in the term "modification".) Each licensee is addressed as "you".

Activities other than copying, distribution and modification are not covered by
this License; they are outside its scope. The act of running the Program is not
restricted, and the output from the Program is covered only if its contents
constitute a work based on the Program (independent of having been made by
running the Program). Whether that is true depends on what the Program does.

1. You may copy and distribute verbatim copies of the Program's source code as
you receive it, in any medium, provided that you conspicuously and appropriately
publish on each copy an appropriate copyright notice and disclaimer of warranty;
 keep intact all the notices that refer to this License and to the absence of
any warranty; and give any other recipients of the Program a copy of this
License along with the Program.

You may charge a fee for the physical act of transferring a copy, and you may
at your option offer warranty protection in exchange for a fee.

2. You may modify your copy or copies of the Program or any portion of it, thus
forming a work based on the Program, and copy and distribute such modifications
or work under the terms of Section 1 above, provided that you also meet all of
these conditions:

a) You must cause the modified files to carry prominent notices stating that
you changed the files and the date of any change.

b) You must cause any work that you distribute or publish, that in whole or in
part contains or is derived from the Program or any part thereof, to be licensed
as a whole at no charge to all third parties under the terms of this License.

c) If the modified program normally reads commands interactively when run, you
must cause it, when started running for such interactive use in the most
ordinary way, to print or display an announcement including an appropriate
copyright notice and a notice that there is no warranty (or else, saying that
you provide a warranty) and that users may redistribute the program under these
conditions, and telling the user how to view a copy of this License. (Exception:
if the Program itself is interactive but does not normally print such an
announcement, your work based on the Program is not required to print an
announcement.)

These requirements apply to the modified work as a whole. If identifiable
sections of that work are not derived from the Program, and can be reasonably
considered independent and separate works in themselves, then this License, and
its terms, do not apply to those sections when you distribute them as separate
works. But when you distribute the same sections as part of a whole which is a
work based on the Program, the distribution of the whole must be on the terms of
this License, whose permissions for other licensees extend to the entire whole,
and thus to each and every part regardless of who wrote it.

Thus, it is not the intent of this section to claim rights or contest your
rights to work written entirely by you; rather, the intent is to exercise the
right to control the distribution of derivative or collective works based on
the Program.

In addition, mere aggregation of another work not based on the Program with the
Program (or with a work based on the Program) on a volume of a storage or
distribution medium does not bring the other work under the scope of this
License.

3. You may copy and distribute the Program (or a work based on it, under
Section 2) in object code or executable form under the terms of Sections 1 and
2 above provided that you also do one of the following:

a) Accompany it with the complete corresponding machine-readable source code,
which must be distributed under the terms of Sections 1 and 2 above on a medium
customarily used for software interchange; or,

b) Accompany it with a written offer, valid for at least three years, to give
any third party, for a charge no more than your cost of physically performing
source distribution, a complete machine-readable copy of the corresponding
source code, to be distributed under the terms of Sections 1 and 2 above on a
medium customarily used for software interchange; or,

c) Accompany it with the information you received as to the offer to distribute
corresponding source code. (This alternative is allowed only for noncommercial
distribution and only if you received the program in object code or executable
form with such an offer, in accord with Subsection b above.)

The source code for a work means the preferred form of the work for making
modifications to it. For an executable work, complete source code means all
the source code for all modules it contains, plus any associated interface
definition files, plus the scripts used to control compilation and installation
of the executable. However, as a special exception, the source code distributed
need not include anything that is normally distributed (in either source or
binary form) with the major components (compiler, kernel, and so on) of the
operating system on which the executable runs, unless that component itself
accompanies the executable.

If distribution of executable or object code is made by offering access to copy
from a designated place, then offering equivalent access to copy the source
code from the same place counts as distribution of the source code, even though
third parties are not compelled to copy the source along with the object code.

4. You may not copy, modify, sublicense, or distribute the Program except as
expressly provided under this License. Any attempt otherwise to copy, modify,
sublicense or distribute the Program is void, and will automatically terminate
your rights under this License. However, parties who have received copies, or
rights, from you under this License will not have their licenses terminated so
long as such parties remain in full compliance.

5. You are not required to accept this License, since you have not signed it.
However, nothing else grants you permission to modify or distribute the Program
or its derivative works. These actions are prohibited by law if you do not
accept this License. Therefore, by modifying or distributing the Program (or
any work based on the Program), you indicate your acceptance of this License to
do so, and all its terms and conditions for copying, distributing or modifying
the Program or works based on it.

6. Each time you redistribute the Program (or any work based on the Program),
the recipient automatically receives a license from the original licensor to
copy, distribute or modify the Program subject to these terms and conditions.
You may not impose any further restrictions on the recipients' exercise of the
rights granted herein. You are not responsible for enforcing compliance by
third parties to this License.

7. If, as a consequence of a court judgment or allegation of patent infringement
or for any other reason (not limited to patent issues), conditions are imposed
on you (whether by court order, agreement or otherwise) that contradict the
conditions of this License, they do not excuse you from the conditions of this
License. If you cannot distribute so as to satisfy simultaneously your
obligations under this License and any other pertinent obligations, then as a
consequence you may not distribute the Program at all. For example, if a patent
license would not permit royalty-free redistribution of the Program by all
those who receive copies directly or indirectly through you, then the only way
you could satisfy both it and this License would be to refrain entirely from
distribution of the Program.

If any portion of this section is held invalid or unenforceable under any
particular circumstance, the balance of the section is intended to apply and
the section as a whole is intended to apply in other circumstances.

It is not the purpose of this section to induce you to infringe any patents or
other property right claims or to contest validity of any such claims; this
section has the sole purpose of protecting the integrity of the free software
distribution system, which is implemented by public license practices. Many
people have made generous contributions to the wide range of software
distributed through that system in reliance on consistent application of that
system; it is up to the author/donor to decide if he or she is willing to
distribute software through any other system and a licensee cannot impose that
choice.

This section is intended to make thoroughly clear what is believed to be a
consequence of the rest of this License.

8. If the distribution and/or use of the Program is restricted in certain
countries either by patents or by copyrighted interfaces, the original
copyright holder who places the Program under this License may add an explicit
geographical distribution limitation excluding those countries, so that
distribution is permitted only in or among countries not thus excluded. In such
case, this License incorporates the limitation as if written in the body of
this License.

9. The Free Software Foundation may publish revised and/or new versions of the
General Public License from time to time. Such new versions will be similar in
spirit to the present version, but may differ in detail to address new problems
or concerns.

Each version is given a distinguishing version number. If the Program specifies
a version number of this License which applies to it and "any later version",
you have the option of following the terms and conditions either of that
version or of any later version published by the Free Software Foundation. If 
the Program does not specify a version number of this License, you may choose
any version ever published by the Free Software Foundation.

10. If you wish to incorporate parts of the Program into other free programs
whose distribution conditions are different, write to the author to ask for
permission. For software which is copyrighted by the Free Software Foundation,
write to the Free Software Foundation; we sometimes make exceptions for this.
Our decision will be guided by the two goals of preserving the free status of
all derivatives of our free software and of promoting the sharing and reuse of
software generally.

NO WARRANTY

11. BECAUSE THE PROGRAM IS LICENSED FREE OF CHARGE, THERE IS NO WARRANTY FOR
THE PROGRAM, TO THE EXTENT PERMITTED BY APPLICABLE LAW. EXCEPT WHEN OTHERWISE
STATED IN WRITING THE COPYRIGHT HOLDERS AND/OR OTHER PARTIES PROVIDE THE
PROGRAM "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED,
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
FITNESS FOR A PARTICULAR PURPOSE. THE ENTIRE RISK AS TO THE QUALITY AND
PERFORMANCE OF THE PROGRAM IS WITH YOU. SHOULD THE PROGRAM PROVE DEFECTIVE,
YOU ASSUME THE COST OF ALL NECESSARY SERVICING, REPAIR OR CORRECTION.

12. IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO IN WRITING WILL
ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MAY MODIFY AND/OR REDISTRIBUTE THE 
PROGRAM AS PERMITTED ABOVE, BE LIABLE TO YOU FOR DAMAGES, INCLUDING ANY GENERAL,
SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE OR
INABILITY TO USE THE PROGRAM (INCLUDING BUT NOT LIMITED TO LOSS OF DATA OR DATA
BEING RENDERED INACCURATE OR LOSSES SUSTAINED BY YOU OR THIRD PARTIES OR A
FAILURE OF THE PROGRAM TO OPERATE WITH ANY OTHER PROGRAMS), EVEN IF SUCH HOLDER
OR OTHER PARTY HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.

END OF TERMS AND CONDITIONS

How to Apply These Terms to Your New Programs

If you develop a new program, and you want it to be of the greatest possible
use to the public, the best way to achieve this is to make it free software 
which everyone can redistribute and change under these terms.

To do so, attach the following notices to the program. It is safest to attach i
them to the start of each source file to most effectively convey the exclusion 
of warranty; and each file should have at least the "copyright" line and a 
pointer to where the full notice is found.

One line to give the program's name and a brief idea of what it does.

Copyright (C) <year> <name of author>

This program is free software; you can redistribute it and/or modify it under 
the terms of the GNU General Public License as published by the Free Software 
Foundation; either version 2 of the License, or (at your option) any later 
version.

This program is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
PARTICULAR PURPOSE. See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License along with
this program; if not, write to the Free Software Foundation, Inc., 59 Temple
Place, Suite 330, Boston, MA 02111-1307 USA

Also add information on how to contact you by electronic and paper mail.

If the program is interactive, make it output a short notice like this when it
starts in an interactive mode:

Gnomovision version 69, Copyright (C) year name of author Gnomovision comes
with ABSOLUTELY NO WARRANTY; for details type `show w'. This is free software,
and you are welcome to redistribute it under certain conditions; type `show c'
for details.

The hypothetical commands `show w' and `show c' should show the appropriate
parts of the General Public License. Of course, the commands you use may be
called something other than `show w' and `show c'; they could even be mouse-
clicks or menu items--whatever suits your program.

You should also get your employer (if you work as a programmer) or your school,
if any, to sign a "copyright disclaimer" for the program, if necessary. Here is
a sample; alter the names:

Yoyodyne, Inc., hereby disclaims all copyright interest in the program
`Gnomovision' (which makes passes at compilers) written by James Hacker.

signature of Ty Coon, 1 April 1989
Ty Coon, President of Vice

This General Public License does not permit incorporating your program into
proprietary programs. If your program is a subroutine library, you may consider
it more useful to permit linking proprietary applications with the library. If
this is what you want to do, use the GNU Library General Public License instead
of this License.

"CLASSPATH" EXCEPTION TO THE GPL VERSION 2

Certain source files distributed by Sun Microsystems, Inc.  are subject to the
following clarification and special exception to the GPL Version 2, but only
where Sun has expressly included in the particular source file's header the
words "Sun designates this particular file as subject to the "Classpath"
exception as provided by Sun in the License file that accompanied this code." 

Linking this library statically or dynamically with other modules is making a
combined work based on this library.  Thus, the terms and conditions of the GNU
General Public License Version 2 cover the whole combination. 

As a special exception, the copyright holders of this library give you 
permission to link this library with independent modules to produce an 
executable, regardless of the license terms of these independent modules, 
and to copy and distribute the resulting executable under terms of your 
choice, provided that you also meet, for each linked independent module, 
the terms and conditions of the license of that module.  An independent 
module is a module which is not derived from or based on this library.  If 
you modify this library, you may extend this exception to your version of 
the library, but you are not obligated to do so.  If you do not wish to do 
so, delete this exception statement from your version.
*/

#include "DuneApp.h"
#include "swt.h"

int 
writeCellRendererCode(int f, const char *upperName, const char *lowerName,
                  Scene *scene) 
{
    const char *prefix = TheApp->getCPrefix();

    if (strlen(prefix) == 0)
        swDebugf("internal error: prefix not set !\n");
 
    RET_ONERROR( mywritestr(f, "/**\n") )
    RET_ONERROR( mywritestr(f, " * Project Wonderland\n") )
    RET_ONERROR( mywritestr(f, " *\n") )
    RET_ONERROR( mywritestr(f, " * Copyright (c) 2004-2009, Sun Microsystems, Inc., All Rights Reserved\n") )
    RET_ONERROR( mywritestr(f, " *\n") )
    RET_ONERROR( mywritestr(f, " * Redistributions in source code form must reproduce the above\n") )
    RET_ONERROR( mywritestr(f, " * copyright and this condition.\n") )
    RET_ONERROR( mywritestr(f, " *\n") )
    RET_ONERROR( mywritestr(f, " * The contents of this file are subject to the GNU General Public\n") )
    RET_ONERROR( mywritestr(f, " * License, Version 2 (the \"License\"); you may not use this file\n") )
    RET_ONERROR( mywritestr(f, " * except in compliance with the License. A copy of the License is\n") )
    RET_ONERROR( mywritestr(f, " * available at http://www.opensource.org/licenses/gpl-license.php.\n") )
    RET_ONERROR( mywritestr(f, " *\n") )
    RET_ONERROR( mywritestr(f, " * Sun designates this particular file as subject to the \"Classpath\"\n") )
    RET_ONERROR( mywritestr(f, " * exception as provided by Sun in the License file that accompanied\n") )
    RET_ONERROR( mywritestr(f, " * this code.\n") )
    RET_ONERROR( mywritestr(f, " */\n") )
    RET_ONERROR( mywritestr(f, " // CylinderSensor code in MyCylinderSensorProcessEventCallback based on cylinder_sensor.cpp of openvrml (GNU Lesser General Public License)\n") )
    RET_ONERROR( mywritestr(f, " // SphereSensor code in MySphereSensorProcessEventCallback based on sphere_sensor.cpp of openvrml (GNU Lesser General Public License)\n") )
    RET_ONERROR( mywritestr(f, "package org.jdesktop.wonderland.modules.") )
    RET_ONERROR( mywritestr(f, lowerName) )
    RET_ONERROR( mywritestr(f, ".client.jme.cellrenderer;\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "import com.jme.app.SimpleGame;\n") )
    RET_ONERROR( mywritestr(f, "import com.jme.scene.Node;\n") )
    RET_ONERROR( mywritestr(f, "import com.jme.scene.TriMesh;\n") )
    RET_ONERROR( mywritestr(f, "import com.jme.scene.TriMesh.Mode;\n") )
    RET_ONERROR( mywritestr(f, "import com.jme.scene.Line;\n") )
    RET_ONERROR( mywritestr(f, "import com.jme.scene.Point;\n") )
    RET_ONERROR( mywritestr(f, "import com.jme.scene.shape.Quad;\n") )
    RET_ONERROR( mywritestr(f, "import com.jme.scene.Text;\n") )
    RET_ONERROR( mywritestr(f, "import com.jme.scene.TexCoords;\n") )
    RET_ONERROR( mywritestr(f, "import com.jme.scene.state.RenderState;\n") )
    RET_ONERROR( mywritestr(f, "import com.jme.scene.state.LightState;\n") )
    RET_ONERROR( mywritestr(f, "import com.jme.scene.state.CullState;\n") )
    RET_ONERROR( mywritestr(f, "import com.jme.scene.state.MaterialState;\n") )
    RET_ONERROR( mywritestr(f, "import com.jme.scene.state.MaterialState.ColorMaterial;\n") )
    RET_ONERROR( mywritestr(f, "import com.jme.scene.state.TextureState;\n") )
    RET_ONERROR( mywritestr(f, "import com.jme.scene.state.BlendState;\n") )
    RET_ONERROR( mywritestr(f, "import com.jme.scene.Spatial;\n") )
    RET_ONERROR( mywritestr(f, "import com.jme.scene.SharedNode;\n") )
    RET_ONERROR( mywritestr(f, "import com.jme.scene.BillboardNode;\n") )
    RET_ONERROR( mywritestr(f, "import com.jme.scene.lod.DiscreteLodNode;\n") )
    RET_ONERROR( mywritestr(f, "import com.jme.scene.DistanceSwitchModel;\n") )
    RET_ONERROR( mywritestr(f, "import com.jme.scene.Geometry;\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "import com.jme.scene.shape.Box;\n") )
    RET_ONERROR( mywritestr(f, "import com.jme.bounding.BoundingBox;\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "import com.jme.system.DisplaySystem;\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "import com.jme.renderer.Renderer;\n") )
    RET_ONERROR( mywritestr(f, "import com.jme.renderer.ColorRGBA;\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "import com.jme.light.DirectionalLight;\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "import com.jme.image.Image;\n") )
    RET_ONERROR( mywritestr(f, "import com.jme.image.Texture;\n") )
    RET_ONERROR( mywritestr(f, "import com.jme.image.Texture2D;\n") )
    RET_ONERROR( mywritestr(f, "import com.jme.image.Texture.MinificationFilter;\n") )
    RET_ONERROR( mywritestr(f, "import com.jme.image.Texture.MagnificationFilter;\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "import com.jme.util.TextureManager;\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "import java.net.MalformedURLException;\n") )
    RET_ONERROR( mywritestr(f, "import java.net.URL;\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "import java.awt.Color;\n") )
    RET_ONERROR( mywritestr(f, "import java.awt.Font;\n") )
    RET_ONERROR( mywritestr(f, "import java.awt.Graphics2D;\n") )
    RET_ONERROR( mywritestr(f, "import java.awt.geom.Rectangle2D;\n") )
    RET_ONERROR( mywritestr(f, "import java.awt.geom.AffineTransform;\n") )
    RET_ONERROR( mywritestr(f, "import java.awt.image.BufferedImage;\n") )
    RET_ONERROR( mywritestr(f, "import java.awt.RenderingHints;\n") )
    RET_ONERROR( mywritestr(f, "import java.awt.Toolkit;\n") )
    RET_ONERROR( mywritestr(f, "import java.awt.event.KeyEvent;\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "import com.jmex.font3d.Text3D;\n") )
    RET_ONERROR( mywritestr(f, "import com.jmex.font3d.Font3D;\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "import com.jme.util.geom.NormalGenerator;\n") )
    RET_ONERROR( mywritestr(f, "import com.jme.util.geom.BufferUtils;\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "import com.jme.math.Vector3f;\n") )
    RET_ONERROR( mywritestr(f, "import com.jme.math.Matrix4f;\n") )
    RET_ONERROR( mywritestr(f, "import com.jme.math.TransformMatrix;\n") )
    RET_ONERROR( mywritestr(f, "import com.jme.math.Quaternion;\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "import java.nio.FloatBuffer;\n") )
    RET_ONERROR( mywritestr(f, "import java.nio.IntBuffer;\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "import java.net.MalformedURLException;\n") )
    RET_ONERROR( mywritestr(f, "import java.net.URL;\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "import java.util.ArrayList;\n") )
    RET_ONERROR( mywritestr(f, "import java.util.logging.Level;\n") )
    RET_ONERROR( mywritestr(f, "import java.util.logging.Logger;\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "import org.jdesktop.wonderland.common.cell.CellTransform;\n") )
    RET_ONERROR( mywritestr(f, "import org.jdesktop.wonderland.common.cell.state.CellServerState;\n") )
    RET_ONERROR( mywritestr(f, "import org.jdesktop.wonderland.common.cell.state.PositionComponentServerState;\n") )
    RET_ONERROR( mywritestr(f, "import org.jdesktop.wonderland.client.cell.Cell;\n") )
    RET_ONERROR( mywritestr(f, "import org.jdesktop.wonderland.client.cell.asset.AssetUtils;\n") )
    RET_ONERROR( mywritestr(f, "import org.jdesktop.wonderland.client.cell.view.ViewCell;\n") )
    RET_ONERROR( mywritestr(f, "import org.jdesktop.wonderland.client.cell.view.LocalAvatar;\n") )
    RET_ONERROR( mywritestr(f, "import org.jdesktop.wonderland.client.jme.ClientContextJME;\n") )
    RET_ONERROR( mywritestr(f, "import org.jdesktop.wonderland.client.jme.cellrenderer.BasicRenderer;\n") )
    RET_ONERROR( mywritestr(f, "import org.jdesktop.wonderland.client.jme.SceneWorker;\n") )
    RET_ONERROR( mywritestr(f, "import org.jdesktop.wonderland.client.jme.ViewManager;\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "import org.jdesktop.mtgame.ProcessorComponent;\n") )
    RET_ONERROR( mywritestr(f, "import org.jdesktop.mtgame.ProcessorArmingCollection;\n") )
    RET_ONERROR( mywritestr(f, "import org.jdesktop.mtgame.processor.WorkProcessor.WorkCommit;\n") )
    RET_ONERROR( mywritestr(f, "import org.jdesktop.mtgame.NewFrameCondition;\n") )
    RET_ONERROR( mywritestr(f, "import org.jdesktop.mtgame.Entity;\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "import org.jdesktop.wonderland.modules.") )
    RET_ONERROR( mywritestr(f, lowerName) )
    RET_ONERROR( mywritestr(f, ".client.") )
    RET_ONERROR( mywritestr(f, upperName) )
    RET_ONERROR( mywritestr(f, "Cell;\n") )
    RET_ONERROR( mywritestr(f, "\n") )

    RET_ONERROR( mywritestr(f, "// draws a X3DV file with shapes (converted to) IndexedTriangleSet,TriangleSet\n") )
    RET_ONERROR( mywritestr(f, "// and triangulated IndexedFaceSet nodes\n") )
    RET_ONERROR( mywritestr(f, "\n") )

    RET_ONERROR( mywritestr(f, "class ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Util {\n") )
    RET_ONERROR( mywritestr(f, "    // global data for the whole scenegraph\n") )
    RET_ONERROR( mywritestr(f, "    public static Cell cell;\n") )
    RET_ONERROR( mywritestr(f, "    public static Logger logger;\n") )
    RET_ONERROR( mywritestr(f, "    private static int nodeCount = 0;\n") )
    RET_ONERROR( mywritestr(f, "    private static ArrayList<") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "Node> triMeshNodeList = new ArrayList();\n") )
    RET_ONERROR( mywritestr(f, "    private static ArrayList<") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "Node> touchSensorNodeList = new ArrayList();\n") )
    RET_ONERROR( mywritestr(f, "    private static ArrayList<") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "Node> planeSensorNodeList = new ArrayList();\n") )
    RET_ONERROR( mywritestr(f, "    private static ArrayList<") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "Node> cylinderSensorNodeList = new ArrayList();\n") )
    RET_ONERROR( mywritestr(f, "    private static ArrayList<") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "Node> sphereSensorNodeList = new ArrayList();\n") )
    RET_ONERROR( mywritestr(f, "    private static ArrayList<") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "Node> keySensorNodeList = new ArrayList();\n") )
    RET_ONERROR( mywritestr(f, "    private static ArrayList<") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "Node> stringSensorNodeList = new ArrayList();\n") )
    RET_ONERROR( mywritestr(f, "    public static ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "Node hitPlaneSensor = null;\n") )
    RET_ONERROR( mywritestr(f, "    public static ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "Node hitCylinderSensor = null;\n") )
    RET_ONERROR( mywritestr(f, "    public static ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "Node hitSphereSensor = null;\n") )
    RET_ONERROR( mywritestr(f, "    public static ViewManager viewManager = ViewManager.getViewManager();\n") )
    RET_ONERROR( mywritestr(f, "    public static boolean planeSensorAutoOffsetWarning = false;\n") )
    RET_ONERROR( mywritestr(f, "    public static boolean cylinderSensorAutoOffsetWarning = false;\n") )
    RET_ONERROR( mywritestr(f, "    public static boolean sphereSensorAutoOffsetWarning = false;\n") )
    RET_ONERROR( mywritestr(f, "    public static ViewCell viewCell;\n") )
    RET_ONERROR( mywritestr(f, "    public static PositionComponentServerState positionComponentServerState;\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "    public static void reset() {\n") )
    RET_ONERROR( mywritestr(f, "        nodeCount = 0;\n") )
    RET_ONERROR( mywritestr(f, "        triMeshNodeList = new ArrayList();\n") )
    RET_ONERROR( mywritestr(f, "        touchSensorNodeList = new ArrayList();\n") )
    RET_ONERROR( mywritestr(f, "        planeSensorNodeList = new ArrayList();\n") )
    RET_ONERROR( mywritestr(f, "        cylinderSensorNodeList = new ArrayList();\n") )
    RET_ONERROR( mywritestr(f, "        sphereSensorNodeList = new ArrayList();\n") )
    RET_ONERROR( mywritestr(f, "        keySensorNodeList = new ArrayList();\n") )
    RET_ONERROR( mywritestr(f, "        stringSensorNodeList = new ArrayList();\n") )
    RET_ONERROR( mywritestr(f, "        hitPlaneSensor = null;\n") )
    RET_ONERROR( mywritestr(f, "        hitCylinderSensor = null;\n") )
    RET_ONERROR( mywritestr(f, "        hitSphereSensor = null;\n") )
    RET_ONERROR( mywritestr(f, "    }\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "    public static String registerTriMeshNode(") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "Node node) {\n") )
    RET_ONERROR( mywritestr(f, "        triMeshNodeList.add(node);\n") )
    RET_ONERROR( mywritestr(f, "        return \"") )
    RET_ONERROR( mywritestr(f, lowerName) )
    RET_ONERROR( mywritestr(f, "\" + \"_\" + nodeCount++;\n") )
    RET_ONERROR( mywritestr(f, "    }\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "    public static void registerTouchSensorNode(") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "Node node) {\n") )
    RET_ONERROR( mywritestr(f, "        touchSensorNodeList.add(node);\n") )
    RET_ONERROR( mywritestr(f, "    }\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "    public static void registerPlaneSensorNode(") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "Node node) {\n") )
    RET_ONERROR( mywritestr(f, "        planeSensorNodeList.add(node);\n") )
    RET_ONERROR( mywritestr(f, "    }\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "    public static void registerCylinderSensorNode(") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "Node node) {\n") )
    RET_ONERROR( mywritestr(f, "        cylinderSensorNodeList.add(node);\n") )
    RET_ONERROR( mywritestr(f, "    }\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "    public static void registerSphereSensorNode(") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "Node node) {\n") )
    RET_ONERROR( mywritestr(f, "        sphereSensorNodeList.add(node);\n") )
    RET_ONERROR( mywritestr(f, "    }\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "    public static void registerKeySensorNode(") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "Node node) {\n") )
    RET_ONERROR( mywritestr(f, "        keySensorNodeList.add(node);\n") )
    RET_ONERROR( mywritestr(f, "    }\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "    public static void registerStringSensorNode(") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "Node node) {\n") )
    RET_ONERROR( mywritestr(f, "        stringSensorNodeList.add(node);\n") )
    RET_ONERROR( mywritestr(f, "    }\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "    public static ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "Node getNode(int nodeNumber) {\n") )
    RET_ONERROR( mywritestr(f, "        if (nodeNumber >= triMeshNodeList.size())\n") )
    RET_ONERROR( mywritestr(f, "            return null;\n") )
    RET_ONERROR( mywritestr(f, "        return triMeshNodeList.get(nodeNumber);\n") )
    RET_ONERROR( mywritestr(f, "    }\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "    public static void buildTouchableNodesList() {\n") )
    RET_ONERROR( mywritestr(f, "        for (int i = 0; i < touchSensorNodeList.size(); i++) {\n") )
    RET_ONERROR( mywritestr(f, "            ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "Node node = touchSensorNodeList.get(i);\n") )
    RET_ONERROR( mywritestr(f, "            ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Data data = (") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Data)node.m_data;\n") )
    RET_ONERROR( mywritestr(f, "            ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_HandleDragSensors.buildMouseSensorNodeList(node,\n") )
    RET_ONERROR( mywritestr(f, "                  data.touchSensorHitNodeList, triMeshNodeList);\n") )
    RET_ONERROR( mywritestr(f, "        }\n") )
    RET_ONERROR( mywritestr(f, "    }\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "    public static void buildPlaneSensorNodesList() {\n") )
    RET_ONERROR( mywritestr(f, "        for (int i = 0; i < planeSensorNodeList.size(); i++) {\n") )
    RET_ONERROR( mywritestr(f, "            ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "Node node = planeSensorNodeList.get(i);\n") )
    RET_ONERROR( mywritestr(f, "            ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Data data = (") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Data)node.m_data;\n") )
    RET_ONERROR( mywritestr(f, "            ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_HandleDragSensors.buildMouseSensorNodeList(node,\n") )
    RET_ONERROR( mywritestr(f, "                  data.planeSensorHitNodeList, triMeshNodeList);\n") )
    RET_ONERROR( mywritestr(f, "        }\n") )
    RET_ONERROR( mywritestr(f, "    }\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "    public static void buildCylinderSensorNodesList() {\n") )
    RET_ONERROR( mywritestr(f, "        for (int i = 0; i < cylinderSensorNodeList.size(); i++) {\n") )
    RET_ONERROR( mywritestr(f, "            ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "Node node = cylinderSensorNodeList.get(i);\n") )
    RET_ONERROR( mywritestr(f, "            ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Data data = (") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Data)node.m_data;\n") )
    RET_ONERROR( mywritestr(f, "            ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_HandleDragSensors.buildMouseSensorNodeList(node,\n") )
    RET_ONERROR( mywritestr(f, "                  data.cylinderSensorHitNodeList, triMeshNodeList);\n") )
    RET_ONERROR( mywritestr(f, "        }\n") )
    RET_ONERROR( mywritestr(f, "    }\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "    public static void buildSphereSensorNodesList() {\n") )
    RET_ONERROR( mywritestr(f, "        for (int i = 0; i < sphereSensorNodeList.size(); i++) {\n") )
    RET_ONERROR( mywritestr(f, "            ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "Node node = sphereSensorNodeList.get(i);\n") )
    RET_ONERROR( mywritestr(f, "            ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Data data = (") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Data)node.m_data;\n") )
    RET_ONERROR( mywritestr(f, "            ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_HandleDragSensors.buildMouseSensorNodeList(node,\n") )
    RET_ONERROR( mywritestr(f, "                  data.sphereSensorHitNodeList, triMeshNodeList);\n") )
    RET_ONERROR( mywritestr(f, "        }\n") )
    RET_ONERROR( mywritestr(f, "    }\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "    public static void handleTouchSensors(") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "Node hitNode, boolean pressed, boolean released) {\n") )
    RET_ONERROR( mywritestr(f, "        for (int i = 0; i < touchSensorNodeList.size(); i++) {\n") )
    RET_ONERROR( mywritestr(f, "            ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "Node node = touchSensorNodeList.get(i);\n") )
    RET_ONERROR( mywritestr(f, "            ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Data data = (") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Data)node.m_data;\n") )
    RET_ONERROR( mywritestr(f, "            if (data.touchSensorHitNodeList.contains(hitNode)) {\n") )
    RET_ONERROR( mywritestr(f, "                data.isPressed = pressed;\n") )
    RET_ONERROR( mywritestr(f, "                data.isReleased = released;\n") )
    RET_ONERROR( mywritestr(f, "            }\n") )
    RET_ONERROR( mywritestr(f, "        }\n") )
    RET_ONERROR( mywritestr(f, "    }\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "    public static void handlePlaneSensors(") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "Node hitNode, float[] trackpoint) {\n") )
    RET_ONERROR( mywritestr(f, "        for (int i = 0; i < planeSensorNodeList.size(); i++) {\n") )
    RET_ONERROR( mywritestr(f, "            ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "Node node = planeSensorNodeList.get(i);\n") )
    RET_ONERROR( mywritestr(f, "            ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Data data = (") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Data)node.m_data;\n") )
    RET_ONERROR( mywritestr(f, "            if (data.planeSensorHitNodeList.contains(hitNode)) {\n") )
    RET_ONERROR( mywritestr(f, "                data.trackpoint[0] = trackpoint[0];\n") )
    RET_ONERROR( mywritestr(f, "                data.trackpoint[1] = trackpoint[1];\n") )
    RET_ONERROR( mywritestr(f, "                if (data.isPressed && !data.oldPressedFlag)\n") )
    RET_ONERROR( mywritestr(f, "                    data.trackpoint[2] = trackpoint[2];\n") )
    RET_ONERROR( mywritestr(f, "                ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Util.hitPlaneSensor = node;\n") )
    RET_ONERROR( mywritestr(f, "            }\n") )
    RET_ONERROR( mywritestr(f, "        }\n") )
    RET_ONERROR( mywritestr(f, "    }\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "    public static void handleCylinderSensors(") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "Node hitNode, float[] trackpoint) {\n") )
    RET_ONERROR( mywritestr(f, "        for (int i = 0; i < cylinderSensorNodeList.size(); i++) {\n") )
    RET_ONERROR( mywritestr(f, "            ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "Node node = cylinderSensorNodeList.get(i);\n") )
    RET_ONERROR( mywritestr(f, "            ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Data data = (") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Data)node.m_data;\n") )
    RET_ONERROR( mywritestr(f, "            if (data.cylinderSensorHitNodeList.contains(hitNode)) {\n") )
    RET_ONERROR( mywritestr(f, "                data.trackpoint[0] = trackpoint[0];\n") )
    RET_ONERROR( mywritestr(f, "                data.trackpoint[1] = trackpoint[1];\n") )
    RET_ONERROR( mywritestr(f, "//                if (data.isPressed && !data.oldPressedFlag)\n") )
    RET_ONERROR( mywritestr(f, "                    data.trackpoint[2] = trackpoint[2];\n") )
    RET_ONERROR( mywritestr(f, "                ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Util.hitCylinderSensor = node;\n") )
    RET_ONERROR( mywritestr(f, "            }\n") )
    RET_ONERROR( mywritestr(f, "        }\n") )
    RET_ONERROR( mywritestr(f, "    }\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "    public static void handleSphereSensors(") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "Node hitNode, float[] trackpoint) {\n") )
    RET_ONERROR( mywritestr(f, "        for (int i = 0; i < sphereSensorNodeList.size(); i++) {\n") )
    RET_ONERROR( mywritestr(f, "            ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "Node node = sphereSensorNodeList.get(i);\n") )
    RET_ONERROR( mywritestr(f, "            ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Data data = (") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Data)node.m_data;\n") )
    RET_ONERROR( mywritestr(f, "            if (data.sphereSensorHitNodeList.contains(hitNode)) {\n") )
    RET_ONERROR( mywritestr(f, "                data.trackpoint[0] = trackpoint[0];\n") )
    RET_ONERROR( mywritestr(f, "                data.trackpoint[1] = trackpoint[1];\n") )
    RET_ONERROR( mywritestr(f, "                data.trackpoint[2] = trackpoint[2];\n") )
    RET_ONERROR( mywritestr(f, "                if (data.isPressed && !data.oldPressedFlag) {\n") )
    RET_ONERROR( mywritestr(f, "                    data.firstHitTrackpoint[0] = trackpoint[0];\n") )
    RET_ONERROR( mywritestr(f, "                    data.firstHitTrackpoint[1] = trackpoint[1];\n") )
    RET_ONERROR( mywritestr(f, "                    data.firstHitTrackpoint[2] = trackpoint[2];\n") )
    RET_ONERROR( mywritestr(f, "                }\n") )
    RET_ONERROR( mywritestr(f, "                ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Util.hitSphereSensor = node;\n") )
    RET_ONERROR( mywritestr(f, "            }\n") )
    RET_ONERROR( mywritestr(f, "        }\n") )
    RET_ONERROR( mywritestr(f, "    }\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "    public static void handleStringSensors(boolean pressed, boolean released, int keycode, String keystring) {\n") )
    RET_ONERROR( mywritestr(f, "        for (int i = 0; i < stringSensorNodeList.size(); i++) {\n") )
    RET_ONERROR( mywritestr(f, "            ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "Node node = stringSensorNodeList.get(i);\n") )
    RET_ONERROR( mywritestr(f, "            ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Data data = (") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Data)node.m_data;\n") )
    RET_ONERROR( mywritestr(f, "            data.isPressed = pressed;\n") )
    RET_ONERROR( mywritestr(f, "            data.isReleased = released;\n") )
    RET_ONERROR( mywritestr(f, "            data.keycode = keycode;\n") )
    RET_ONERROR( mywritestr(f, "            if (data.keycode == -1)\n") )
    RET_ONERROR( mywritestr(f, "                data.keystring = keystring;\n") )
    RET_ONERROR( mywritestr(f, "            else\n") )
    RET_ONERROR( mywritestr(f, "                data.keystring = \"\";\n") )
    RET_ONERROR( mywritestr(f, "        }\n") )
    RET_ONERROR( mywritestr(f, "    }\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "    public static void handleKeySensors(boolean pressed, boolean released, int keycode, String keystring) {\n") )
    RET_ONERROR( mywritestr(f, "        for (int i = 0; i < keySensorNodeList.size(); i++) {\n") )
    RET_ONERROR( mywritestr(f, "            ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "Node node = keySensorNodeList.get(i);\n") )
    RET_ONERROR( mywritestr(f, "            ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Data data = (") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Data)node.m_data;\n") )
    RET_ONERROR( mywritestr(f, "            data.isPressed = pressed;\n") )
    RET_ONERROR( mywritestr(f, "            data.isReleased = released;\n") )
    RET_ONERROR( mywritestr(f, "            data.keycode = keycode;\n") )
    RET_ONERROR( mywritestr(f, "            if (data.keycode == -1)\n") )
    RET_ONERROR( mywritestr(f, "                data.keystring = keystring;\n") )
    RET_ONERROR( mywritestr(f, "            else\n") )
    RET_ONERROR( mywritestr(f, "                data.keystring = \"\";\n") )
    RET_ONERROR( mywritestr(f, "        }\n") )
    RET_ONERROR( mywritestr(f, "    }\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "    public static Texture loadTexture(String url) {\n") )
    RET_ONERROR( mywritestr(f, "         URL textureUrl = null;\n") )
    RET_ONERROR( mywritestr(f, "         try {\n") )
    RET_ONERROR( mywritestr(f, "             textureUrl = AssetUtils.getAssetURL(url);\n") )
    RET_ONERROR( mywritestr(f, "         } catch (MalformedURLException ex) {\n") )
    RET_ONERROR( mywritestr(f, "             return null;\n") )
    RET_ONERROR( mywritestr(f, "         }\n") )
    RET_ONERROR( mywritestr(f, "         return TextureManager.loadTexture(textureUrl,\n") )
    RET_ONERROR( mywritestr(f, "                     Texture.MinificationFilter.NearestNeighborNoMipMaps,\n") )
    RET_ONERROR( mywritestr(f, "                     Texture.MagnificationFilter.NearestNeighbor,\n") )
    RET_ONERROR( mywritestr(f, "                     1.0f, true);\n") )
    RET_ONERROR( mywritestr(f, "    }\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "    public static URL getUrl(String[] urls) {\n") )
    RET_ONERROR( mywritestr(f, "        URL textureUrl = null;\n") )
    RET_ONERROR( mywritestr(f, "        for (int i = 0; i < urls.length; i++) {\n") )
    RET_ONERROR( mywritestr(f, "            try {\n") )
    RET_ONERROR( mywritestr(f, "               /* in Wonderland\n") )
    RET_ONERROR( mywritestr(f, "                * textureUrl = AssetUtils.getAssetURL(urls[i]);\n") )
    RET_ONERROR( mywritestr(f, "                */\n") )
    RET_ONERROR( mywritestr(f, "                String prefix = \"\";\n") )
    RET_ONERROR( mywritestr(f, "                if (urls[i].charAt(0) == '/')\n") )
    RET_ONERROR( mywritestr(f, "                    prefix = \"//\";\n") )
    RET_ONERROR( mywritestr(f, "                textureUrl = new URL(\"file\", \"\", prefix + urls[i]);\n") )
    RET_ONERROR( mywritestr(f, "            } catch (MalformedURLException ex) {\n") )
    RET_ONERROR( mywritestr(f, "                if (i == urls.length - 1)\n") )
    RET_ONERROR( mywritestr(f, "                    return null;\n") )
    RET_ONERROR( mywritestr(f, "                else\n") )
    RET_ONERROR( mywritestr(f, "                    continue;\n") )
    RET_ONERROR( mywritestr(f, "            }\n") )
    RET_ONERROR( mywritestr(f, "            return textureUrl;\n") )
    RET_ONERROR( mywritestr(f, "        }\n") )
    RET_ONERROR( mywritestr(f, "        return textureUrl;\n") )
    RET_ONERROR( mywritestr(f, "    }\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "    public static void makeTexture(Geometry geometry, ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "Node node) {\n") )
    RET_ONERROR( mywritestr(f, "        TextureState textureState = ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_TextureToJme.makeTexture(node);\n") )
    RET_ONERROR( mywritestr(f, "        if (textureState != null)\n") )
    RET_ONERROR( mywritestr(f, "            geometry.setRenderState(textureState);\n") )
    RET_ONERROR( mywritestr(f, "    }\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "    public static void applyStates(Geometry geometry, boolean newStates,\n") )
    RET_ONERROR( mywritestr(f, "                                   ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "Node node, ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "Node color,\n") )
    RET_ONERROR( mywritestr(f, "                                   boolean solid, boolean ccw) {\n") )
    RET_ONERROR( mywritestr(f, "        MaterialState materialState = null;\n") )
    RET_ONERROR( mywritestr(f, "        ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Data data = (") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Data)node.m_data;\n") )
    RET_ONERROR( mywritestr(f, "        // MaterialState needs to be reused\n") )
    RET_ONERROR( mywritestr(f, "        if (newStates) {\n") )
    RET_ONERROR( mywritestr(f, "            materialState = ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_MaterialToJme.makeMaterial(node);\n") )
    RET_ONERROR( mywritestr(f, "            data.materialState = materialState;\n") )
    RET_ONERROR( mywritestr(f, "        } else {\n") )
    RET_ONERROR( mywritestr(f, "            materialState = data.materialState;\n") )
    RET_ONERROR( mywritestr(f, "            ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_MaterialToJme.setMaterial(materialState, node);\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "        }\n") )
    RET_ONERROR( mywritestr(f, "        materialState.setMaterialFace(MaterialState.MaterialFace.FrontAndBack);\n") )
    RET_ONERROR( mywritestr(f, "/*\n") )
    RET_ONERROR( mywritestr(f, "        if (solid)\n") )
    RET_ONERROR( mywritestr(f, "           if (ccw)\n") )
    RET_ONERROR( mywritestr(f, "              materialState.setMaterialFace(MaterialState.MaterialFace.Front);\n") )
    RET_ONERROR( mywritestr(f, "           else\n") )
    RET_ONERROR( mywritestr(f, "              materialState.setMaterialFace(MaterialState.MaterialFace.Back);\n") )
    RET_ONERROR( mywritestr(f, "*/\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "        if (color != null)\n") )
    RET_ONERROR( mywritestr(f, "            geometry.setLightCombineMode(Spatial.LightCombineMode.Off);\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "//        geometry.clearRenderState(RenderState.StateType.Cull);\n") )
    RET_ONERROR( mywritestr(f, "        CullState cullState = DisplaySystem.getDisplaySystem().getRenderer().createCullState();\n") )
    RET_ONERROR( mywritestr(f, "        cullState.setCullFace(CullState.Face.None);\n") )
    RET_ONERROR( mywritestr(f, "        if (solid)\n") )
    RET_ONERROR( mywritestr(f, "           if (ccw)\n") )
    RET_ONERROR( mywritestr(f, "              cullState.setCullFace(CullState.Face.Back);\n") )
    RET_ONERROR( mywritestr(f, "          else\n") )
    RET_ONERROR( mywritestr(f, "              cullState.setCullFace(CullState.Face.Front);\n") )
    RET_ONERROR( mywritestr(f, "        geometry.setRenderState(cullState);\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "        if (") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_TextureToJme.isTransparentTexture(node) ||\n") )
    RET_ONERROR( mywritestr(f, "            ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_MaterialToJme.isTransparentMaterial(node)) {\n") )
    RET_ONERROR( mywritestr(f, "            geometry.setRenderState(") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_AlphaToJme.makeAlpha());\n") )
    RET_ONERROR( mywritestr(f, "            geometry.setRenderQueueMode(Renderer.QUEUE_TRANSPARENT);\n") )
    RET_ONERROR( mywritestr(f, "        }\n") )
    RET_ONERROR( mywritestr(f, "        geometry.setRenderState(materialState);\n") )
    RET_ONERROR( mywritestr(f, "    }\n") )
    RET_ONERROR( mywritestr(f, "}\n") )
    RET_ONERROR( mywritestr(f, "\n") )

    RET_ONERROR( mywritestr(f, "class ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Data {\n") )
    RET_ONERROR( mywritestr(f, "    /* all data that may be additinally stored by a ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "Node */\n") )
    RET_ONERROR( mywritestr(f, "    public Spatial node;\n") )
    RET_ONERROR( mywritestr(f, "    public DoWithDataCallback callback = null;\n") )
    RET_ONERROR( mywritestr(f, "    public MaterialState materialState = null;\n") )
    RET_ONERROR( mywritestr(f, "    public Texture texture = null;\n") )
    RET_ONERROR( mywritestr(f, "    public Texture oldTexture = null;\n") )
    RET_ONERROR( mywritestr(f, "    public Texture veryOldTexture = null;\n") )
    RET_ONERROR( mywritestr(f, "    public int oldIndex = -1;\n") )
    RET_ONERROR( mywritestr(f, "    public double startTime = 0;\n") )
    RET_ONERROR( mywritestr(f, "    public double stopTime = 0;\n") )
    RET_ONERROR( mywritestr(f, "    public ArrayList<") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "Node> touchSensorHitNodeList = new ArrayList();\n") )
    RET_ONERROR( mywritestr(f, "    public ArrayList<") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "Node> planeSensorHitNodeList = new ArrayList();\n") )
    RET_ONERROR( mywritestr(f, "    public ArrayList<") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "Node> cylinderSensorHitNodeList = new ArrayList();\n") )
    RET_ONERROR( mywritestr(f, "    public ArrayList<") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "Node> sphereSensorHitNodeList = new ArrayList();\n") )
    RET_ONERROR( mywritestr(f, "    public TransformMatrix dragSensorMatrix = null;\n") )
    RET_ONERROR( mywritestr(f, "    public boolean isPressed = false;\n") )
    RET_ONERROR( mywritestr(f, "    public boolean isReleased = false;\n") )
    RET_ONERROR( mywritestr(f, "    public boolean oldPressedFlag = false;\n") )
    RET_ONERROR( mywritestr(f, "    public int keycode = -1;\n") )
    RET_ONERROR( mywritestr(f, "    public String keystring = \"\";\n") )
    RET_ONERROR( mywritestr(f, "    public float[] trackpoint = new float[3];\n") )
    RET_ONERROR( mywritestr(f, "    public float[] firstHitTrackpoint = new float[3];\n") )
    RET_ONERROR( mywritestr(f, "    public boolean isInsideProximity = false;\n") )
    RET_ONERROR( mywritestr(f, "}\n") )
    RET_ONERROR( mywritestr(f, "\n") )

    RET_ONERROR( mywritestr(f, "class ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_HandleDragSensors {\n") )
    RET_ONERROR( mywritestr(f, "    public static boolean isInPath(") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "Node node, ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "Node pathNode) {\n") )
    RET_ONERROR( mywritestr(f, "        ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "Node parentNode = pathNode;\n") )
    RET_ONERROR( mywritestr(f, "        ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Data data = (") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Data)node.m_data;\n") )
    RET_ONERROR( mywritestr(f, "        Vector3f tempStore = new Vector3f();\n") )
    RET_ONERROR( mywritestr(f, "        data.dragSensorMatrix = new TransformMatrix();\n") )
    RET_ONERROR( mywritestr(f, "        data.dragSensorMatrix.loadIdentity();\n") )
    RET_ONERROR( mywritestr(f, "        do {\n") )
    RET_ONERROR( mywritestr(f, "            if (parentNode == node)\n") )
    RET_ONERROR( mywritestr(f, "                return true;\n") )
    RET_ONERROR( mywritestr(f, "            if (data.callback == null) {\n") )
    RET_ONERROR( mywritestr(f, "                // dragSensor is at root level\n") )
    RET_ONERROR( mywritestr(f, "                return true;\n") )
    RET_ONERROR( mywritestr(f, "            }\n") )
    RET_ONERROR( mywritestr(f, "            Object object = data.callback.getNullOrObject(parentNode);\n") )
    RET_ONERROR( mywritestr(f, "            if (object != null)\n") )
    RET_ONERROR( mywritestr(f, "                data.dragSensorMatrix.multLocal((TransformMatrix)object, tempStore);\n") )
    RET_ONERROR( mywritestr(f, "            parentNode = parentNode.m_parent;\n") )
    RET_ONERROR( mywritestr(f, "        } while (parentNode != null);\n") )
    RET_ONERROR( mywritestr(f, "        return false;\n") )
    RET_ONERROR( mywritestr(f, "    }\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "    public static void buildMouseSensorNodeList(") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "Node mouseSensor,\n") )
    RET_ONERROR( mywritestr(f, "        ArrayList<") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "Node> targetNodeList,  ArrayList<") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "Node> pathNodeList) {\n") )
    RET_ONERROR( mywritestr(f, "        ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "Node mouseSensorParent = mouseSensor.m_parent;\n") )
    RET_ONERROR( mywritestr(f, "        for (int i = 0; i < pathNodeList.size(); i++) {\n") )
    RET_ONERROR( mywritestr(f, "            ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "Node nodeToCheck = pathNodeList.get(i);\n") )
    RET_ONERROR( mywritestr(f, "            if (isInPath(mouseSensorParent, nodeToCheck))\n") )
    RET_ONERROR( mywritestr(f, "                targetNodeList.add(nodeToCheck);\n") )
    RET_ONERROR( mywritestr(f, "        }\n") )
    RET_ONERROR( mywritestr(f, "    }\n") )
    RET_ONERROR( mywritestr(f, "}\n") )
    RET_ONERROR( mywritestr(f, "\n") )

    RET_ONERROR( mywritestr(f, "class ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_GeometryBuffers {\n") )
    RET_ONERROR( mywritestr(f, "    public FloatBuffer verticesBuffer = null;\n") )
    RET_ONERROR( mywritestr(f, "    public FloatBuffer normalsBuffer = null;\n") )
    RET_ONERROR( mywritestr(f, "    public FloatBuffer colorsBuffer = null;\n") )
    RET_ONERROR( mywritestr(f, "    public TexCoords texCoords = null;\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "    public void accountBuffers(") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "Node coord, ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "Node normal,\n") )
    RET_ONERROR( mywritestr(f, "                               ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "Node color, ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "Node texCoord) {\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "        float vertices[] = null;\n") )
    RET_ONERROR( mywritestr(f, "        verticesBuffer = null;\n") )
    RET_ONERROR( mywritestr(f, "        if (coord != null) {\n") )
    RET_ONERROR( mywritestr(f, "            vertices = ((") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "Coordinate)coord).point;\n") )
    RET_ONERROR( mywritestr(f, "            verticesBuffer = BufferUtils.createFloatBuffer(vertices.length);\n") )
    RET_ONERROR( mywritestr(f, "            verticesBuffer.put(vertices);\n") )
    RET_ONERROR( mywritestr(f, "        }\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "        normalsBuffer = null;\n") )
    RET_ONERROR( mywritestr(f, "        if (normal != null) {\n") )
    RET_ONERROR( mywritestr(f, "            float normals[] = ((") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "Normal)normal).vector;\n") )
    RET_ONERROR( mywritestr(f, "            if (normals != null) {\n") )
    RET_ONERROR( mywritestr(f, "                normalsBuffer = BufferUtils.createFloatBuffer(normals.length);\n") )
    RET_ONERROR( mywritestr(f, "                normalsBuffer.put(normals);\n") )
    RET_ONERROR( mywritestr(f, "            }\n") )
    RET_ONERROR( mywritestr(f, "        }\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "        if (vertices != null)\n") )
    RET_ONERROR( mywritestr(f, "            colorsBuffer = ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_ColorToJme.makeColor(color, vertices.length / 3);\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "        texCoords = null;\n") )
    RET_ONERROR( mywritestr(f, "        if (texCoord != null) {\n") )
    RET_ONERROR( mywritestr(f, "            float texCoordinates[] = ((") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "TextureCoordinate)texCoord).point;\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "            if (texCoordinates != null) {\n") )
    RET_ONERROR( mywritestr(f, "                 FloatBuffer texCoordsBuffer = BufferUtils.createFloatBuffer(\n") )
    RET_ONERROR( mywritestr(f, "                                                         texCoordinates.length);\n") )
    RET_ONERROR( mywritestr(f, "                texCoordsBuffer.put(texCoordinates);\n") )
    RET_ONERROR( mywritestr(f, "                texCoords = new TexCoords(texCoordsBuffer);\n") )
    RET_ONERROR( mywritestr(f, "            }\n") )
    RET_ONERROR( mywritestr(f, "        }\n") )
    RET_ONERROR( mywritestr(f, "    }\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "    IntBuffer accountIndicesBuffer(int coordIndex[]) {\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "        if (coordIndex == null)\n") )
    RET_ONERROR( mywritestr(f, "            return null;\n") )
    RET_ONERROR( mywritestr(f, "        int numIndices = 0;\n") )
    RET_ONERROR( mywritestr(f, "        for (int i = 0; i < coordIndex.length; i++)\n") )
    RET_ONERROR( mywritestr(f, "            if (coordIndex[i] > -1)\n") )
    RET_ONERROR( mywritestr(f, "                numIndices++;\n") )
    RET_ONERROR( mywritestr(f, "        int indices[] = new int[numIndices];\n") )
    RET_ONERROR( mywritestr(f, "        int currentIndex = 0;\n") )
    RET_ONERROR( mywritestr(f, "        for (int i = 0; i < coordIndex.length; i++)\n") )
    RET_ONERROR( mywritestr(f, "            if (coordIndex[i] > -1)\n") )
    RET_ONERROR( mywritestr(f, "                indices[currentIndex++] = coordIndex[i];\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "        IntBuffer indicesBuffer = BufferUtils.createIntBuffer(indices.length);\n") )
    RET_ONERROR( mywritestr(f, "        indicesBuffer.put(indices);\n") )
    RET_ONERROR( mywritestr(f, "        return indicesBuffer;\n") )
    RET_ONERROR( mywritestr(f, "    }\n") )
    RET_ONERROR( mywritestr(f, "}\n") )
    RET_ONERROR( mywritestr(f, "\n") )

    RET_ONERROR( mywritestr(f, "class ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Interpolator {\n") )
    RET_ONERROR( mywritestr(f, "    static float interpolate(float t, float key, float oldKey,\n") )
    RET_ONERROR( mywritestr(f, "                             float value, float oldValue) {\n") )
    RET_ONERROR( mywritestr(f, "        float delta = (key == oldKey) ? 0 : (t - oldKey) / (key - oldKey);\n") )
    RET_ONERROR( mywritestr(f, "        return oldValue + delta * (value - oldValue);\n") )
    RET_ONERROR( mywritestr(f, "    }\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "    public static void accountInterpolator(float target[], float fraction,\n") )
    RET_ONERROR( mywritestr(f, "                                           float keys[], float keyValues[],\n") )
    RET_ONERROR( mywritestr(f, "                                           int stride) {\n") )
    RET_ONERROR( mywritestr(f, "        int numKeys = keys.length;\n") )
    RET_ONERROR( mywritestr(f, "        if (numKeys > 0) {\n") )
    RET_ONERROR( mywritestr(f, "            for (int j = 0; j < stride; j++)\n") )
    RET_ONERROR( mywritestr(f, "                target[j]=keyValues[j];\n") )
    RET_ONERROR( mywritestr(f, "            int oldi = 0;\n") )
    RET_ONERROR( mywritestr(f, "            int i;\n") )
    RET_ONERROR( mywritestr(f, "            for (i = 0; i < numKeys; i++) {\n") )
    RET_ONERROR( mywritestr(f, "                if ((fraction >= keys[oldi]) && (fraction < keys[i])) {\n") )
    RET_ONERROR( mywritestr(f, "                    for (int j = 0; j < stride; j++)\n") )
    RET_ONERROR( mywritestr(f, "                        target[j] = interpolate(fraction, keys[i], keys[oldi],\n") )
    RET_ONERROR( mywritestr(f, "                                                keyValues[(i * stride + j)],\n") )
    RET_ONERROR( mywritestr(f, "                                                keyValues[(oldi * stride + j)]);\n") )
    RET_ONERROR( mywritestr(f, "                    break;\n") )
    RET_ONERROR( mywritestr(f, "                }\n") )
    RET_ONERROR( mywritestr(f, "                oldi = i;\n") )
    RET_ONERROR( mywritestr(f, "            }\n") )
    RET_ONERROR( mywritestr(f, "            if (i == numKeys)\n") )
    RET_ONERROR( mywritestr(f, "                for (int j = 0; j < stride; j++)\n") )
    RET_ONERROR( mywritestr(f, "                    target[j] = keyValues[(numKeys - 1) * stride + j];\n") )
    RET_ONERROR( mywritestr(f, "        }\n") )
    RET_ONERROR( mywritestr(f, "    }\n") )
    RET_ONERROR( mywritestr(f, "}\n") )
    RET_ONERROR( mywritestr(f, "\n") )

    RET_ONERROR( mywritestr(f, "class ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_AppearanceToJme {\n") )
    RET_ONERROR( mywritestr(f, "    static ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "Appearance getAppearance(") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "Node node) {\n") )
    RET_ONERROR( mywritestr(f, "        if (((") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "Shape)node.m_parent) == null)\n") )
    RET_ONERROR( mywritestr(f, "            return null;\n") )
    RET_ONERROR( mywritestr(f, "        return (") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "Appearance)((") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "Shape)node.m_parent).appearance;\n") )
    RET_ONERROR( mywritestr(f, "    }\n") )
    RET_ONERROR( mywritestr(f, "}\n") )
    RET_ONERROR( mywritestr(f, "\n") )

    RET_ONERROR( mywritestr(f, "class ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_MaterialToJme {\n") )
    RET_ONERROR( mywritestr(f, "    static ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "Material getMaterial(") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "Node node) {\n") )
    RET_ONERROR( mywritestr(f, "        ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "Appearance appearance = ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_AppearanceToJme.getAppearance(node);\n") )
    RET_ONERROR( mywritestr(f, "        if (appearance != null) {\n") )
    RET_ONERROR( mywritestr(f, "            ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "Material material = (") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "Material)((") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "Appearance)appearance).material;\n") )
    RET_ONERROR( mywritestr(f, "            return material;\n") )
    RET_ONERROR( mywritestr(f, "        }\n") )
    RET_ONERROR( mywritestr(f, "        return null;\n") )
    RET_ONERROR( mywritestr(f, "    }\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "    static void setMaterial(MaterialState materialState, ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "Node node) {\n") )
    RET_ONERROR( mywritestr(f, "        ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "Material material = getMaterial(node);\n") )
    RET_ONERROR( mywritestr(f, "        if (material == null)\n") )
    RET_ONERROR( mywritestr(f, "            return;\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "        materialState.setAmbient(new ColorRGBA(material.diffuseColor[0],\n") )
    RET_ONERROR( mywritestr(f, "                                               material.diffuseColor[1],\n") )
    RET_ONERROR( mywritestr(f, "                                               material.diffuseColor[2],\n") )
    RET_ONERROR( mywritestr(f, "                                               1 - material.transparency));\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "        materialState.setDiffuse(new ColorRGBA(material.diffuseColor[0],\n") )
    RET_ONERROR( mywritestr(f, "                                               material.diffuseColor[1],\n") )
    RET_ONERROR( mywritestr(f, "                                               material.diffuseColor[2],\n") )
    RET_ONERROR( mywritestr(f, "                                               1 - material.transparency));\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "        materialState.setEmissive(new ColorRGBA(material.emissiveColor[0],\n") )
    RET_ONERROR( mywritestr(f, "                                                material.emissiveColor[1],\n") )
    RET_ONERROR( mywritestr(f, "                                                material.emissiveColor[2],\n") )
    RET_ONERROR( mywritestr(f, "                                                1 - material.transparency));\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "        materialState.setSpecular(new ColorRGBA(material.specularColor[0],\n") )
    RET_ONERROR( mywritestr(f, "                                                material.specularColor[1],\n") )
    RET_ONERROR( mywritestr(f, "                                                material.specularColor[2],\n") )
    RET_ONERROR( mywritestr(f, "                                                1 - material.transparency));\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "        materialState.setShininess(material.shininess * 128.0f);\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "        materialState.setEnabled(true);\n") )
    RET_ONERROR( mywritestr(f, "   }\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "   static boolean isTransparentMaterial(") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "Node node) {\n") )
    RET_ONERROR( mywritestr(f, "       ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "Material material = getMaterial(node);\n") )
    RET_ONERROR( mywritestr(f, "       if (material != null)\n") )
    RET_ONERROR( mywritestr(f, "           return material.transparency > 0.0f;\n") )
    RET_ONERROR( mywritestr(f, "       return true;\n") )
    RET_ONERROR( mywritestr(f, "   }\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "   static MaterialState makeMaterial(") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "Node node) {\n") )
    RET_ONERROR( mywritestr(f, "       MaterialState materialState = DisplaySystem.getDisplaySystem().getRenderer().createMaterialState();\n") )
    RET_ONERROR( mywritestr(f, "       setMaterial(materialState, node);\n") )
    RET_ONERROR( mywritestr(f, "       return materialState;\n") )
    RET_ONERROR( mywritestr(f, "   }\n") )
    RET_ONERROR( mywritestr(f, "}\n") )
    RET_ONERROR( mywritestr(f, "\n") )

    RET_ONERROR( mywritestr(f, "class ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_TextureToJme {\n") )
    RET_ONERROR( mywritestr(f, "    static TextureState makeTexture(") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "Node node) {\n") )
    RET_ONERROR( mywritestr(f, "        ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "Appearance appearance = ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_AppearanceToJme.getAppearance(node);\n") )
    RET_ONERROR( mywritestr(f, "        if (appearance != null) {\n") )
    RET_ONERROR( mywritestr(f, "            if ((appearance.texture != null) &&\n") )
    RET_ONERROR( mywritestr(f, "                (appearance.texture.getClass() == ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "ImageTexture.class)) {\n") )
    RET_ONERROR( mywritestr(f, "                ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "ImageTexture textureNode = (") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "ImageTexture)appearance.texture;\n") )
    RET_ONERROR( mywritestr(f, "                if (textureNode.url.length > 0) {\n") )
    RET_ONERROR( mywritestr(f, "                    for (int i = 0; i < textureNode.url.length; i++) {\n") )
    RET_ONERROR( mywritestr(f, "                        Texture texture = ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Util.loadTexture(textureNode.url[i]);\n") )
    RET_ONERROR( mywritestr(f, "                        if (texture == null)\n") )
    RET_ONERROR( mywritestr(f, "                            continue;\n") )
    RET_ONERROR( mywritestr(f, "                        texture.setWrap(Texture.WrapAxis.S, textureNode.repeatS ? Texture.WrapMode.Repeat : Texture.WrapMode.Clamp);\n") )
    RET_ONERROR( mywritestr(f, "                        texture.setWrap(Texture.WrapAxis.T, textureNode.repeatT ? Texture.WrapMode.Repeat : Texture.WrapMode.Clamp);\n") )
    RET_ONERROR( mywritestr(f, "                        texture.setMatrix(") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_TextureToJme.getTextureTransformMatrix(node));\n") )
    RET_ONERROR( mywritestr(f, "                        ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Data data = (") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Data)node.m_data;\n") )
    RET_ONERROR( mywritestr(f, "                        data.texture = texture;\n") )
    RET_ONERROR( mywritestr(f, "                        TextureState textureState = DisplaySystem.getDisplaySystem().getRenderer().createTextureState();\n") )
    RET_ONERROR( mywritestr(f, "                        textureState.setTexture(texture, 0);\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "                        return textureState;\n") )
    RET_ONERROR( mywritestr(f, "                    }\n") )
    RET_ONERROR( mywritestr(f, "                }\n") )
    RET_ONERROR( mywritestr(f, "            }\n") )
    RET_ONERROR( mywritestr(f, "        }\n") )
    RET_ONERROR( mywritestr(f, "        return null;\n") )
    RET_ONERROR( mywritestr(f, "    }\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "    static Matrix4f getTextureTransformMatrix(") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "Node node) {\n") )
    RET_ONERROR( mywritestr(f, "        Matrix4f transformMatrix = new Matrix4f();\n") )
    RET_ONERROR( mywritestr(f, "        ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "Appearance appearance = ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_AppearanceToJme.getAppearance(node);\n") )
    RET_ONERROR( mywritestr(f, "        if (appearance != null) {\n") )
    RET_ONERROR( mywritestr(f, "            if ((appearance.texture != null) &&\n") )
    RET_ONERROR( mywritestr(f, "                (appearance.texture.getClass() == ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "ImageTexture.class)) {\n") )
    RET_ONERROR( mywritestr(f, "                float scale[] = new float[2];\n") )
    RET_ONERROR( mywritestr(f, "                scale[0] = 1.0f;\n") )
    RET_ONERROR( mywritestr(f, "                scale[1] = 1.0f;\n") )
    RET_ONERROR( mywritestr(f, "                float center[] = new float[2];\n") )
    RET_ONERROR( mywritestr(f, "                center[0] = 1.0f;\n") )
    RET_ONERROR( mywritestr(f, "                center[1] = 1.0f;\n") )
    RET_ONERROR( mywritestr(f, "                float rotation = 0.0f;\n") )
    RET_ONERROR( mywritestr(f, "                float translation[] = new float[2];\n") )
    RET_ONERROR( mywritestr(f, "                translation[0] = 1.0f;\n") )
    RET_ONERROR( mywritestr(f, "                translation[1] = 1.0f;\n") )
    RET_ONERROR( mywritestr(f, "                if ((appearance.textureTransform != null) &&\n") )
    RET_ONERROR( mywritestr(f, "                    (appearance.textureTransform.getClass() == ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "TextureTransform.class)) {\n") )
    RET_ONERROR( mywritestr(f, "                    ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "TextureTransform textureTransformNode = (") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "TextureTransform)appearance.textureTransform;\n") )
    RET_ONERROR( mywritestr(f, "                    scale[0] = textureTransformNode.scale[0];\n") )
    RET_ONERROR( mywritestr(f, "                    scale[1] = textureTransformNode.scale[1];\n") )
    RET_ONERROR( mywritestr(f, "                    center[0] = textureTransformNode.center[0];\n") )
    RET_ONERROR( mywritestr(f, "                    center[1] = textureTransformNode.center[1];\n") )
    RET_ONERROR( mywritestr(f, "                    rotation = textureTransformNode.rotation;\n") )
    RET_ONERROR( mywritestr(f, "                    translation[0] = textureTransformNode.translation[0];\n") )
    RET_ONERROR( mywritestr(f, "                    translation[1] = textureTransformNode.translation[1];\n") )
    RET_ONERROR( mywritestr(f, "                }\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "                transformMatrix.loadIdentity();\n") )
    RET_ONERROR( mywritestr(f, "                Matrix4f multMatrix = new Matrix4f();\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "                multMatrix.loadIdentity();\n") )
    RET_ONERROR( mywritestr(f, "                multMatrix.setTranslation(-center[0], -center[1], 0.0f);\n") )
    RET_ONERROR( mywritestr(f, "                transformMatrix = transformMatrix.mult(multMatrix);\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "                multMatrix.loadIdentity();\n") )
    RET_ONERROR( mywritestr(f, "                multMatrix.scale(new Vector3f(scale[0], scale[1], 0));\n") )
    RET_ONERROR( mywritestr(f, "                transformMatrix = transformMatrix.mult(multMatrix);\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "                multMatrix.loadIdentity();\n") )
    RET_ONERROR( mywritestr(f, "                multMatrix.fromAngleAxis(rotation,\n") )
    RET_ONERROR( mywritestr(f, "                                         new Vector3f(0.0f, 0.0f, 1.0f));\n") )
    RET_ONERROR( mywritestr(f, "                transformMatrix = transformMatrix.mult(multMatrix);\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "                multMatrix.loadIdentity();\n") )
    RET_ONERROR( mywritestr(f, "                multMatrix.setTranslation(center[0], center[1], 0.0f);\n") )
    RET_ONERROR( mywritestr(f, "                transformMatrix = transformMatrix.mult(multMatrix);\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "                multMatrix.loadIdentity();\n") )
    RET_ONERROR( mywritestr(f, "                multMatrix.setTranslation(translation[0], translation[1], 0.0f);\n") )
    RET_ONERROR( mywritestr(f, "                transformMatrix = transformMatrix.mult(multMatrix);\n") )
    RET_ONERROR( mywritestr(f, "            }\n") )
    RET_ONERROR( mywritestr(f, "        }\n") )
    RET_ONERROR( mywritestr(f, "        return transformMatrix;\n") )
    RET_ONERROR( mywritestr(f, "    }\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "    static boolean isTransparentTexture(") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "Node node) {\n") )
    RET_ONERROR( mywritestr(f, "        ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "Appearance appearance = ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_AppearanceToJme.getAppearance(node);\n") )
    RET_ONERROR( mywritestr(f, "        if (appearance != null) {\n") )
    RET_ONERROR( mywritestr(f, "            if ((appearance.texture != null) &&\n") )
    RET_ONERROR( mywritestr(f, "                (") )
    RET_ONERROR( mywritestr(f, "appearance.texture.getClass() == ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "ImageTexture.class)) {\n") )
    RET_ONERROR( mywritestr(f, "                ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "ImageTexture textureNode = (") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "ImageTexture)appearance.texture;\n") )
    RET_ONERROR( mywritestr(f, "                URL textureUrl = ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Util.getUrl(textureNode.url);\n") )
    RET_ONERROR( mywritestr(f, "                if (textureUrl != null) {\n") )
    RET_ONERROR( mywritestr(f, "                    java.awt.Image img = java.awt.Toolkit.getDefaultToolkit().getImage(textureUrl);\n") )
    RET_ONERROR( mywritestr(f, "                    return TextureManager.hasAlpha(img);\n") )
    RET_ONERROR( mywritestr(f, "               }\n") )
    RET_ONERROR( mywritestr(f, "            }\n") )
    RET_ONERROR( mywritestr(f, "        }\n") )
    RET_ONERROR( mywritestr(f, "        return false;\n") )
    RET_ONERROR( mywritestr(f, "    }\n") )
    RET_ONERROR( mywritestr(f, "}\n") )
    RET_ONERROR( mywritestr(f, "\n") )

    RET_ONERROR( mywritestr(f, "class ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_AlphaToJme {\n") )
    RET_ONERROR( mywritestr(f, "    static BlendState makeAlpha() {\n") )
    RET_ONERROR( mywritestr(f, "        BlendState blendState = DisplaySystem.getDisplaySystem().getRenderer().createBlendState();\n") )
    RET_ONERROR( mywritestr(f, "        blendState.setTestEnabled(true);\n") )
    RET_ONERROR( mywritestr(f, "        blendState.setBlendEnabled(true);\n") )
    RET_ONERROR( mywritestr(f, "        blendState.setSourceFunction(BlendState.SourceFunction.SourceAlpha);\n") )
    RET_ONERROR( mywritestr(f, "        blendState.setDestinationFunction(BlendState.DestinationFunction.OneMinusSourceAlpha);\n") )
    RET_ONERROR( mywritestr(f, "        blendState.setTestFunction(BlendState.TestFunction.GreaterThan);\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "        return blendState;\n") )
    RET_ONERROR( mywritestr(f, "    }\n") )
    RET_ONERROR( mywritestr(f, "}\n") )
    RET_ONERROR( mywritestr(f, "\n") )

    RET_ONERROR( mywritestr(f, "class ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_ColorToJme {\n") )
    RET_ONERROR( mywritestr(f, "    static FloatBuffer makeColor(") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "Node node, int needed_length) {\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "        int numDefinedColors = 0;\n") )
    RET_ONERROR( mywritestr(f, "        float r = 0.8f;\n") )
    RET_ONERROR( mywritestr(f, "        float b = 0.8f;\n") )
    RET_ONERROR( mywritestr(f, "        float g = 0.8f;\n") )
    RET_ONERROR( mywritestr(f, "        float a = 1;\n") )
    RET_ONERROR( mywritestr(f, "        float color[] = new float[needed_length * 4];\n") )
    RET_ONERROR( mywritestr(f, "        if (node != null) {\n") )
    RET_ONERROR( mywritestr(f, "            if (node.getClass() == ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "Color.class) {\n") )
    RET_ONERROR( mywritestr(f, "                ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "Color colors = (") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "Color) node;\n") )
    RET_ONERROR( mywritestr(f, "                if (colors.color.length == 3) {\n") )
    RET_ONERROR( mywritestr(f, "                    r = colors.color[0];\n") )
    RET_ONERROR( mywritestr(f, "                    b = colors.color[1];\n") )
    RET_ONERROR( mywritestr(f, "                    g = colors.color[2];\n") )
    RET_ONERROR( mywritestr(f, "                } else {\n") )
    RET_ONERROR( mywritestr(f, "                    int numColors = colors.color.length / 3 <= needed_length ?\n") )
    RET_ONERROR( mywritestr(f, "                                    colors.color.length / 3 : needed_length;\n") )
    RET_ONERROR( mywritestr(f, "                    for (int i = 0; i < numColors; i++) {\n") )
    RET_ONERROR( mywritestr(f, "                        for (int j = 0; j < 3; j++)\n") )
    RET_ONERROR( mywritestr(f, "                            color[i * 4 + j] = colors.color[i * 3 + j];\n") )
    RET_ONERROR( mywritestr(f, "                        color[i * 4 + 3] = 1;\n") )
    RET_ONERROR( mywritestr(f, "                        numDefinedColors++;\n") )
    RET_ONERROR( mywritestr(f, "                    }\n") )
    RET_ONERROR( mywritestr(f, "                }\n") )
    RET_ONERROR( mywritestr(f, "            } else if (node.getClass() == ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "ColorRGBA.class) {\n") )
    RET_ONERROR( mywritestr(f, "                ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "ColorRGBA colors = (") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "ColorRGBA) node;\n") )
    RET_ONERROR( mywritestr(f, "                if (colors.color.length == 4) {\n") )
    RET_ONERROR( mywritestr(f, "                    r = colors.color[0];\n") )
    RET_ONERROR( mywritestr(f, "                    b = colors.color[1];\n") )
    RET_ONERROR( mywritestr(f, "                    g = colors.color[2];\n") )
    RET_ONERROR( mywritestr(f, "                    a = colors.color[3];\n") )
    RET_ONERROR( mywritestr(f, "                } else {\n") )
    RET_ONERROR( mywritestr(f, "                    int numColors = colors.color.length / 4 <= needed_length ?\n") )
    RET_ONERROR( mywritestr(f, "                                    colors.color.length / 4 : needed_length;\n") )
    RET_ONERROR( mywritestr(f, "                    for (int i = 0; i < numColors * 4; i++) {\n") )
    RET_ONERROR( mywritestr(f, "                        color[i] = colors.color[i];\n") )
    RET_ONERROR( mywritestr(f, "                        numDefinedColors++;\n") )
    RET_ONERROR( mywritestr(f, "                    }\n") )
    RET_ONERROR( mywritestr(f, "                }\n") )
    RET_ONERROR( mywritestr(f, "            }\n") )
    RET_ONERROR( mywritestr(f, "        }\n") )
    RET_ONERROR( mywritestr(f, "        for (int i = numDefinedColors; i < needed_length; i++) {\n") )
    RET_ONERROR( mywritestr(f, "            color[i * 4 + 0] = r;\n") )
    RET_ONERROR( mywritestr(f, "            color[i * 4 + 1] = g;\n") )
    RET_ONERROR( mywritestr(f, "            color[i * 4 + 2] = b;\n") )
    RET_ONERROR( mywritestr(f, "            color[i * 4 + 3] = a;\n") )
    RET_ONERROR( mywritestr(f, "        }\n") )
    RET_ONERROR( mywritestr(f, "        FloatBuffer colorsBuffer = BufferUtils.createFloatBuffer(color.length);\n") )
    RET_ONERROR( mywritestr(f, "        colorsBuffer.put(color);\n") )
    RET_ONERROR( mywritestr(f, "        return colorsBuffer;\n") )
    RET_ONERROR( mywritestr(f, "    }\n") )
    RET_ONERROR( mywritestr(f, "}\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "class MyTriangleSetDoWithDataCallback extends ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "TriangleSetDoWithDataCallback {\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "    ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_GeometryBuffers buffers = new ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_GeometryBuffers();\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "    IntBuffer accountIndicesBuffer(") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "Node coord) {\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "        float vertices[] = ((") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "Coordinate)coord).point;\n") )
    RET_ONERROR( mywritestr(f, "        int indices[] = new int[vertices.length / 3];\n") )
    RET_ONERROR( mywritestr(f, "        for (int i = 0; i < indices.length; i++)\n") )
    RET_ONERROR( mywritestr(f, "            indices[i] = i;\n") )
    RET_ONERROR( mywritestr(f, "        IntBuffer indicesBuffer = BufferUtils.createIntBuffer(indices.length);\n") )
    RET_ONERROR( mywritestr(f, "        indicesBuffer.put(indices);\n") )
    RET_ONERROR( mywritestr(f, "        return indicesBuffer;\n") )
    RET_ONERROR( mywritestr(f, "    }\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "    public void update(") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "Node node) {\n") )
    RET_ONERROR( mywritestr(f, "        ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "TriangleSet triangles = (") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "TriangleSet) node;\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "        buffers.accountBuffers(triangles.coord, triangles.normal,\n") )
    RET_ONERROR( mywritestr(f, "                               triangles.color, triangles.texCoord);\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "        if (triangles.coord == null)\n") )
    RET_ONERROR( mywritestr(f, "            return;\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "        ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Data data = (") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Data)node.m_data;\n") )
    RET_ONERROR( mywritestr(f, "        TriMesh tri = (TriMesh)data.node;\n") )
    RET_ONERROR( mywritestr(f, "        tri.reconstruct(buffers.verticesBuffer,\n") )
    RET_ONERROR( mywritestr(f, "                        buffers.normalsBuffer,\n") )
    RET_ONERROR( mywritestr(f, "                        buffers.colorsBuffer,\n") )
    RET_ONERROR( mywritestr(f, "                        buffers.texCoords,\n") )
    RET_ONERROR( mywritestr(f, "                        accountIndicesBuffer(triangles.coord));\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "        ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Util.applyStates(tri, false, triangles,\n") )
    RET_ONERROR( mywritestr(f, "                             triangles.color, triangles.solid, triangles.ccw);\n") )
    RET_ONERROR( mywritestr(f, "    }\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "    public void doWithData(") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "Node node) {\n") )
    RET_ONERROR( mywritestr(f, "        ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "TriangleSet triangles = (") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "TriangleSet) node;\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "        buffers.accountBuffers(triangles.coord, triangles.normal,\n") )
    RET_ONERROR( mywritestr(f, "                               triangles.color, triangles.texCoord);\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "        if (triangles.coord == null)\n") )
    RET_ONERROR( mywritestr(f, "            return;\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "        TriMesh tri = new TriMesh(") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Util.registerTriMeshNode(node),\n") )
    RET_ONERROR( mywritestr(f, "                                  buffers.verticesBuffer,\n") )
    RET_ONERROR( mywritestr(f, "                                  buffers.normalsBuffer,\n") )
    RET_ONERROR( mywritestr(f, "                                  buffers.colorsBuffer,\n") )
    RET_ONERROR( mywritestr(f, "                                  buffers.texCoords,\n") )
    RET_ONERROR( mywritestr(f, "                                  accountIndicesBuffer(triangles.coord));\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "        ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Data data = new ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Data();\n") )
    RET_ONERROR( mywritestr(f, "        node.m_data = data;\n") )
    RET_ONERROR( mywritestr(f, "        data.node = tri;\n") )
    RET_ONERROR( mywritestr(f, "        data.callback = this;\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "        ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Util.applyStates(tri, true, triangles,\n") )
    RET_ONERROR( mywritestr(f, "                             triangles.color, triangles.solid, triangles.ccw);\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "        ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Util.makeTexture(tri, triangles);\n") )
    RET_ONERROR( mywritestr(f, "    }\n") )
    RET_ONERROR( mywritestr(f, "}\n") )
    RET_ONERROR( mywritestr(f, "\n") )

    RET_ONERROR( mywritestr(f, "class MyIndexedTriangleSetDoWithDataCallback extends ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "IndexedTriangleSetDoWithDataCallback {\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "    ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_GeometryBuffers buffers = new ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_GeometryBuffers();\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "    public void update(") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "Node node) {\n") )
    RET_ONERROR( mywritestr(f, "        ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "IndexedTriangleSet triangles = (") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "IndexedTriangleSet) node;\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "        buffers.accountBuffers(triangles.coord, triangles.normal,\n") )
    RET_ONERROR( mywritestr(f, "                               triangles.color, triangles.texCoord);\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "        if ((triangles.coord == null) || (triangles.index == null))\n") )
    RET_ONERROR( mywritestr(f, "            return;\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "        ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Data data = (") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Data)node.m_data;\n") )
    RET_ONERROR( mywritestr(f, "        TriMesh tri = (TriMesh)data.node;\n") )
    RET_ONERROR( mywritestr(f, "        tri.reconstruct(buffers.verticesBuffer,\n") )
    RET_ONERROR( mywritestr(f, "                        buffers.normalsBuffer,\n") )
    RET_ONERROR( mywritestr(f, "                        buffers.colorsBuffer,\n") )
    RET_ONERROR( mywritestr(f, "                        buffers.texCoords,\n") )
    RET_ONERROR( mywritestr(f, "                        buffers.accountIndicesBuffer(triangles.index));\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "        ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Util.applyStates(tri, false, triangles,\n") )
    RET_ONERROR( mywritestr(f, "                             triangles.color, triangles.solid, triangles.ccw);\n") )
    RET_ONERROR( mywritestr(f, "    }\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "    public void doWithData(") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "Node node) {\n") )
    RET_ONERROR( mywritestr(f, "        ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "IndexedTriangleSet triangles = (") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "IndexedTriangleSet) node;\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "        buffers.accountBuffers(triangles.coord, triangles.normal,\n") )
    RET_ONERROR( mywritestr(f, "                               triangles.color, triangles.texCoord);\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "        if ((triangles.coord == null) || (triangles.index == null))\n") )
    RET_ONERROR( mywritestr(f, "            return;\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "        TriMesh tri = new TriMesh(") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Util.registerTriMeshNode(node),\n") )
    RET_ONERROR( mywritestr(f, "                                  buffers.verticesBuffer,\n") )
    RET_ONERROR( mywritestr(f, "                                  buffers.normalsBuffer,\n") )
    RET_ONERROR( mywritestr(f, "                                  buffers.colorsBuffer,\n") )
    RET_ONERROR( mywritestr(f, "                                  buffers.texCoords,\n") )
    RET_ONERROR( mywritestr(f, "                                  buffers.accountIndicesBuffer(triangles.index));\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "        ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Data data = new ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Data();\n") )
    RET_ONERROR( mywritestr(f, "        node.m_data = data;\n") )
    RET_ONERROR( mywritestr(f, "        data.node = tri;\n") )
    RET_ONERROR( mywritestr(f, "        data.callback = this;\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "        ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Util.applyStates(tri, true, triangles,\n") )
    RET_ONERROR( mywritestr(f, "                             triangles.color, triangles.solid, triangles.ccw);\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "        ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Util.makeTexture(tri, triangles);\n") )
    RET_ONERROR( mywritestr(f, "    }\n") )
    RET_ONERROR( mywritestr(f, "}\n") )
    RET_ONERROR( mywritestr(f, "\n") )

    RET_ONERROR( mywritestr(f, "class MyCoordinateProcessEventCallback extends ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "CoordinateProcessEventCallback\n") )
    RET_ONERROR( mywritestr(f, "{\n") )
    RET_ONERROR( mywritestr(f, "    public boolean processEvent(") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "Node node, String event) {\n") )
    RET_ONERROR( mywritestr(f, "        if (node != null) {\n") )
    RET_ONERROR( mywritestr(f, "            ((") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Data)node.m_parent.m_data).callback.update(node.m_parent);\n") )
    RET_ONERROR( mywritestr(f, "             return true;\n") )
    RET_ONERROR( mywritestr(f, "        }\n") )
    RET_ONERROR( mywritestr(f, "        return false;\n") )
    RET_ONERROR( mywritestr(f, "    }\n") )
    RET_ONERROR( mywritestr(f, "}\n") )
    RET_ONERROR( mywritestr(f, "\n") )

    RET_ONERROR( mywritestr(f, "class MyColorProcessEventCallback extends ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "ColorProcessEventCallback\n") )
    RET_ONERROR( mywritestr(f, "{\n") )
    RET_ONERROR( mywritestr(f, "    public boolean processEvent(") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "Node node, String event) {\n") )
    RET_ONERROR( mywritestr(f, "        if (node != null) {\n") )
    RET_ONERROR( mywritestr(f, "            ((") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Data)node.m_parent.m_data).callback.update(node.m_parent);\n") )
    RET_ONERROR( mywritestr(f, "            return true;\n") )
    RET_ONERROR( mywritestr(f, "        }\n") )
    RET_ONERROR( mywritestr(f, "        return false;\n") )
    RET_ONERROR( mywritestr(f, "    }\n") )
    RET_ONERROR( mywritestr(f, "}\n") )
    RET_ONERROR( mywritestr(f, "\n") )

    RET_ONERROR( mywritestr(f, "class MyNormalProcessEventCallback extends ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "NormalProcessEventCallback\n") )
    RET_ONERROR( mywritestr(f, "{\n") )
    RET_ONERROR( mywritestr(f, "    public boolean processEvent(") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "Node node, String event) {\n") )
    RET_ONERROR( mywritestr(f, "        if (node != null) {\n") )
    RET_ONERROR( mywritestr(f, "            ((") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Data)node.m_parent.m_data).callback.update(node.m_parent);\n") )
    RET_ONERROR( mywritestr(f, "            return true;\n") )
    RET_ONERROR( mywritestr(f, "        }\n") )
    RET_ONERROR( mywritestr(f, "        return false;\n") )
    RET_ONERROR( mywritestr(f, "    }\n") )
    RET_ONERROR( mywritestr(f, "}\n") )
    RET_ONERROR( mywritestr(f, "\n") )

    RET_ONERROR( mywritestr(f, "class MyTextureCoordinateProcessEventCallback extends ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "TextureCoordinateProcessEventCallback\n") )
    RET_ONERROR( mywritestr(f, "{\n") )
    RET_ONERROR( mywritestr(f, "    public boolean processEvent(") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "Node node, String event) {\n") )
    RET_ONERROR( mywritestr(f, "        if (node != null) {\n") )
    RET_ONERROR( mywritestr(f, "            ((") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Data)node.m_parent.m_data).callback.update(node.m_parent);\n") )
    RET_ONERROR( mywritestr(f, "            return true;\n") )
    RET_ONERROR( mywritestr(f, "        }\n") )
    RET_ONERROR( mywritestr(f, "        return false;\n") )
    RET_ONERROR( mywritestr(f, "    }\n") )
    RET_ONERROR( mywritestr(f, "}\n") )
    RET_ONERROR( mywritestr(f, "\n") )

    RET_ONERROR( mywritestr(f, "class MyIndexedFaceSetDoWithDataCallback extends ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "IndexedFaceSetDoWithDataCallback {\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "    ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_GeometryBuffers buffers = new ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_GeometryBuffers();\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "    public void accountBuffers(") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "Node coord, int coordIndices[],\n") )
    RET_ONERROR( mywritestr(f, "                               ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "Node normal, int normalIndices[],\n") )
    RET_ONERROR( mywritestr(f, "                               ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "Node color, ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "Node texCoord) {\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "        float vertices[] = null;\n") )
    RET_ONERROR( mywritestr(f, "        buffers.verticesBuffer = null;\n") )
    RET_ONERROR( mywritestr(f, "        if (coord != null) {\n") )
    RET_ONERROR( mywritestr(f, "            vertices = ((") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "Coordinate)coord).point;\n") )
    RET_ONERROR( mywritestr(f, "            buffers.verticesBuffer = BufferUtils.createFloatBuffer(vertices.length);\n") )
    RET_ONERROR( mywritestr(f, "            buffers.verticesBuffer.put(vertices);\n") )
    RET_ONERROR( mywritestr(f, "        }\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "        buffers.normalsBuffer = null;\n") )
    RET_ONERROR( mywritestr(f, "        if (normal != null) {\n") )
    RET_ONERROR( mywritestr(f, "            float normals[] = ((") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "Normal)normal).vector;\n") )
    RET_ONERROR( mywritestr(f, "            float newNormals[] = new float[vertices.length];\n") )
    RET_ONERROR( mywritestr(f, "            for (int i = 0; i < vertices.length; i++)\n") )
    RET_ONERROR( mywritestr(f, "                 newNormals[i] = 0;\n") )
    RET_ONERROR( mywritestr(f, "            if (normals != null) {\n") )
    RET_ONERROR( mywritestr(f, "                int normalCount = 0;\n") )
    RET_ONERROR( mywritestr(f, "                for (int i = 0; i < coordIndices.length; i++) {\n") )
    RET_ONERROR( mywritestr(f, "                    int newIndex = coordIndices[i];\n") )
    RET_ONERROR( mywritestr(f, "                    int newNormalIndex = newIndex;\n") )
    RET_ONERROR( mywritestr(f, "                    if (normalIndices != null)\n") )
    RET_ONERROR( mywritestr(f, "                        newNormalIndex = normalIndices[i];\n") )
    RET_ONERROR( mywritestr(f, "                    if ((newIndex > -1) && (newIndex < vertices.length)) {\n") )
    RET_ONERROR( mywritestr(f, "                        newNormals[newIndex * 3]     += normals[newNormalIndex * 3];\n") )
    RET_ONERROR( mywritestr(f, "                        newNormals[newIndex * 3 + 1] += normals[newNormalIndex * 3 + 1];\n") )
    RET_ONERROR( mywritestr(f, "                        newNormals[newIndex * 3 + 2] += normals[newNormalIndex * 3 + 2];\n") )
    RET_ONERROR( mywritestr(f, "                    }\n") )
    RET_ONERROR( mywritestr(f, "                }\n") )
    RET_ONERROR( mywritestr(f, "                for (int i = 0; i < newNormals.length; i += 3) {\n") )
    RET_ONERROR( mywritestr(f, "                    double len = java.lang.Math.sqrt(newNormals[i] *\n") )
    RET_ONERROR( mywritestr(f, "                                                    newNormals[i] +\n") )
    RET_ONERROR( mywritestr(f, "                                                    newNormals[i + 1] *\n") )
    RET_ONERROR( mywritestr(f, "                                                    newNormals[i + 1] +\n") )
    RET_ONERROR( mywritestr(f, "                                                    newNormals[i + 2] *\n") )
    RET_ONERROR( mywritestr(f, "                                                    newNormals[i + 2]);\n") )
    RET_ONERROR( mywritestr(f, "                    if (len != 0) {\n") )
    RET_ONERROR( mywritestr(f, "                        newNormals[i] /= len;\n") )
    RET_ONERROR( mywritestr(f, "                        newNormals[i + 1] /= len;\n") )
    RET_ONERROR( mywritestr(f, "                        newNormals[i + 2] /= len;\n") )
    RET_ONERROR( mywritestr(f, "                    }\n") )
    RET_ONERROR( mywritestr(f, "                }\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "                buffers.normalsBuffer = BufferUtils.createFloatBuffer(newNormals.length);\n") )
    RET_ONERROR( mywritestr(f, "                buffers.normalsBuffer.put(newNormals);\n") )
    RET_ONERROR( mywritestr(f, "            }\n") )
    RET_ONERROR( mywritestr(f, "        }\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "        if (vertices != null)\n") )
    RET_ONERROR( mywritestr(f, "            buffers.colorsBuffer = ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_ColorToJme.makeColor(color, vertices.length / 3);\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "        buffers.texCoords = null;\n") )
    RET_ONERROR( mywritestr(f, "        if (texCoord != null) {\n") )
    RET_ONERROR( mywritestr(f, "            float texCoordinates[] = ((") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "TextureCoordinate)texCoord).point;\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "            if (texCoordinates != null) {\n") )
    RET_ONERROR( mywritestr(f, "                 FloatBuffer texCoordsBuffer = BufferUtils.createFloatBuffer(\n") )
    RET_ONERROR( mywritestr(f, "                                                         texCoordinates.length);\n") )
    RET_ONERROR( mywritestr(f, "                texCoordsBuffer.put(texCoordinates);\n") )
    RET_ONERROR( mywritestr(f, "                buffers.texCoords = new TexCoords(texCoordsBuffer);\n") )
    RET_ONERROR( mywritestr(f, "            }\n") )
    RET_ONERROR( mywritestr(f, "        }\n") )
    RET_ONERROR( mywritestr(f, "    }\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "    public void update(") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "Node node) {\n") )
    RET_ONERROR( mywritestr(f, "        ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "IndexedFaceSet triangles = (") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "IndexedFaceSet) node;\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "        accountBuffers(triangles.coord, triangles.coordIndex,\n") )
    RET_ONERROR( mywritestr(f, "                       triangles.normal, triangles.normalIndex,\n") )
    RET_ONERROR( mywritestr(f, "                       triangles.color, triangles.texCoord);\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "        ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Data data = (") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Data)node.m_data;\n") )
    RET_ONERROR( mywritestr(f, "        TriMesh tri = (TriMesh)data.node;\n") )
    RET_ONERROR( mywritestr(f, "        tri.reconstruct(buffers.verticesBuffer,\n") )
    RET_ONERROR( mywritestr(f, "                        buffers.normalsBuffer,\n") )
    RET_ONERROR( mywritestr(f, "                        buffers.colorsBuffer,\n") )
    RET_ONERROR( mywritestr(f, "                        buffers.texCoords,\n") )
    RET_ONERROR( mywritestr(f, "                        buffers.accountIndicesBuffer(triangles.coordIndex));\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "        ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Util.applyStates(tri, false, triangles,\n") )
    RET_ONERROR( mywritestr(f, "                             triangles.color, triangles.solid, triangles.ccw);\n") )
    RET_ONERROR( mywritestr(f, "    }\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "    public void doWithData(") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "Node node) {\n") )
    RET_ONERROR( mywritestr(f, "        ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "IndexedFaceSet triangles = (") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "IndexedFaceSet) node;\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "        accountBuffers(triangles.coord, triangles.coordIndex,\n") )
    RET_ONERROR( mywritestr(f, "                       triangles.normal, triangles.normalIndex,\n") )
    RET_ONERROR( mywritestr(f, "                       triangles.color, triangles.texCoord);\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "        TriMesh tri = new TriMesh(") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Util.registerTriMeshNode(node),\n") )
    RET_ONERROR( mywritestr(f, "                                  buffers.verticesBuffer,\n") )
    RET_ONERROR( mywritestr(f, "                                  buffers.normalsBuffer,\n") )
    RET_ONERROR( mywritestr(f, "                                  buffers.colorsBuffer,\n") )
    RET_ONERROR( mywritestr(f, "                                  buffers.texCoords,\n") )
    RET_ONERROR( mywritestr(f, "                                  buffers.accountIndicesBuffer(triangles.coordIndex));\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "        ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Data data = new ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Data();\n") )
    RET_ONERROR( mywritestr(f, "        node.m_data = data;\n") )
    RET_ONERROR( mywritestr(f, "        data.node = tri;\n") )
    RET_ONERROR( mywritestr(f, "        data.callback = this;\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "        ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Util.applyStates(tri, true, triangles,\n") )
    RET_ONERROR( mywritestr(f, "                             triangles.color, triangles.solid, triangles.ccw);\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "        ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Util.makeTexture(tri, triangles);\n") )
    RET_ONERROR( mywritestr(f, "    }\n") )
    RET_ONERROR( mywritestr(f, "}\n") )
    RET_ONERROR( mywritestr(f, "\n") )

    RET_ONERROR( mywritestr(f, "class MyIndexedLineSetDoWithDataCallback extends ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "IndexedLineSetDoWithDataCallback {\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "    ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_GeometryBuffers buffers = new ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_GeometryBuffers();\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "    FloatBuffer accountVerticesBuffer(") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "Node node) {\n") )
    RET_ONERROR( mywritestr(f, "        ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "IndexedLineSet lines = (") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "IndexedLineSet) node;\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "        int indices[] = lines.coordIndex;\n") )
    RET_ONERROR( mywritestr(f, "        float vertices[] = ((") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "Coordinate)lines.coord).point;\n") )
    RET_ONERROR( mywritestr(f, "        float newVertices[] = new float[indices.length * 2 * 3];\n") )
    RET_ONERROR( mywritestr(f, "        int newVerticesLen = 0;\n") )
    RET_ONERROR( mywritestr(f, "        for (int i = 1; i < indices.length; i++) {\n") )
    RET_ONERROR( mywritestr(f, "            if ((indices[i] > -1) && (indices[i - 1] > -1))  {\n") )
    RET_ONERROR( mywritestr(f, "                newVertices[newVerticesLen++] = vertices[3 * indices[i - 1]];\n") )
    RET_ONERROR( mywritestr(f, "                newVertices[newVerticesLen++] = vertices[3 * indices[i - 1] + 1];\n") )
    RET_ONERROR( mywritestr(f, "                newVertices[newVerticesLen++] = vertices[3 * indices[i - 1] + 2];\n") )
    RET_ONERROR( mywritestr(f, "                newVertices[newVerticesLen++] = vertices[3 * indices[i]];\n") )
    RET_ONERROR( mywritestr(f, "                newVertices[newVerticesLen++] = vertices[3 * indices[i] + 1];\n") )
    RET_ONERROR( mywritestr(f, "                newVertices[newVerticesLen++] = vertices[3 * indices[i] + 2];\n") )
    RET_ONERROR( mywritestr(f, "            }\n") )
    RET_ONERROR( mywritestr(f, "        }\n") )
    RET_ONERROR( mywritestr(f, "        float lineVertices[] = new float[newVerticesLen];\n") )
    RET_ONERROR( mywritestr(f, "        for (int i = 0; i < newVerticesLen; i++)\n") )
    RET_ONERROR( mywritestr(f, "            lineVertices[i] = newVertices[i];\n") )
    RET_ONERROR( mywritestr(f, "        FloatBuffer verticesBuffer = BufferUtils.createFloatBuffer(lineVertices.length);\n") )
    RET_ONERROR( mywritestr(f, "        verticesBuffer.put(lineVertices);\n") )
    RET_ONERROR( mywritestr(f, "        return verticesBuffer;\n") )
    RET_ONERROR( mywritestr(f, "    }\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "    public void update(") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "Node node) {\n") )
    RET_ONERROR( mywritestr(f, "        ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "IndexedLineSet lines = (") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "IndexedLineSet) node;\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "        if (lines.coord == null)\n") )
    RET_ONERROR( mywritestr(f, "            return;\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "        FloatBuffer colorsBuffer = ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_ColorToJme.makeColor(lines.color,\n") )
    RET_ONERROR( mywritestr(f, "                                         lines.coordIndex.length * 2 * 3);\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "        ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Data data = (") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Data)node.m_data;\n") )
    RET_ONERROR( mywritestr(f, "        Line line = (Line)data.node;\n") )
    RET_ONERROR( mywritestr(f, "        line.reconstruct(accountVerticesBuffer(node), (FloatBuffer)null,\n") )
    RET_ONERROR( mywritestr(f, "                         colorsBuffer, (TexCoords)null);\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "        ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Util.applyStates(line, false, lines,\n") )
    RET_ONERROR( mywritestr(f, "                             lines.color, false, true);\n") )
    RET_ONERROR( mywritestr(f, "    }\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "    public void doWithData(") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "Node node) {\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "        ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "IndexedLineSet lines = (") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "IndexedLineSet) node;\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "        if (lines.coord == null)\n") )
    RET_ONERROR( mywritestr(f, "            return;\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "        FloatBuffer colorsBuffer = ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_ColorToJme.makeColor(lines.color,\n") )
    RET_ONERROR( mywritestr(f, "                                         lines.coordIndex.length * 2 * 3);\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "        FloatBuffer normalsBuffer = null;\n") )
    RET_ONERROR( mywritestr(f, "        TexCoords texCoords = new TexCoords(null);\n") )
    RET_ONERROR( mywritestr(f, "        Line line = new Line(") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Util.registerTriMeshNode(node),\n") )
    RET_ONERROR( mywritestr(f, "                             accountVerticesBuffer(node),\n") )
    RET_ONERROR( mywritestr(f, "                             normalsBuffer,\n") )
    RET_ONERROR( mywritestr(f, "                             colorsBuffer,\n") )
    RET_ONERROR( mywritestr(f, "                             texCoords);\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "        ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Data data = new ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Data();\n") )
    RET_ONERROR( mywritestr(f, "        node.m_data = data;\n") )
    RET_ONERROR( mywritestr(f, "        data.node = line;\n") )
    RET_ONERROR( mywritestr(f, "        data.callback = this;\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "        ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Util.applyStates(line, true, lines,\n") )
    RET_ONERROR( mywritestr(f, "                             lines.color, false, true);\n") )
    RET_ONERROR( mywritestr(f, "   }\n") )
    RET_ONERROR( mywritestr(f, "}\n") )
    RET_ONERROR( mywritestr(f, "\n") )

    RET_ONERROR( mywritestr(f, "class MyPointSetDoWithDataCallback extends ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "PointSetDoWithDataCallback {\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "    public void update(") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "Node node) {\n") )
    RET_ONERROR( mywritestr(f, "        ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "PointSet points = (") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "PointSet) node;\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "        if (points.coord == null)\n") )
    RET_ONERROR( mywritestr(f, "            return;\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "        float vertices[] = ((") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "Coordinate)points.coord).point;\n") )
    RET_ONERROR( mywritestr(f, "        FloatBuffer verticesBuffer = BufferUtils.createFloatBuffer(vertices.length);\n") )
    RET_ONERROR( mywritestr(f, "        verticesBuffer.put(vertices);\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "        FloatBuffer colorsBuffer = ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_ColorToJme.makeColor(points.color, vertices.length);\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "        FloatBuffer normalsBuffer = null;\n") )
    RET_ONERROR( mywritestr(f, "        TexCoords texCoords = new TexCoords(null);\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "        ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Data data = (") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Data)node.m_data;\n") )
    RET_ONERROR( mywritestr(f, "        Point point = (Point)data.node;\n") )
    RET_ONERROR( mywritestr(f, "        point.reconstruct(verticesBuffer, (FloatBuffer)null, colorsBuffer,\n") )
    RET_ONERROR( mywritestr(f, "                          (TexCoords)null);\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "        ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Util.applyStates(point, false, points,\n") )
    RET_ONERROR( mywritestr(f, "                             points.color, false, true);\n") )
    RET_ONERROR( mywritestr(f, "    }\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "    public void doWithData(") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "Node node) {\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "        ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "PointSet points = (") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "PointSet) node;\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "        if (points.coord == null)\n") )
    RET_ONERROR( mywritestr(f, "            return;\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "        float vertices[] = ((") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "Coordinate)points.coord).point;\n") )
    RET_ONERROR( mywritestr(f, "        FloatBuffer verticesBuffer = BufferUtils.createFloatBuffer(vertices.length);\n") )
    RET_ONERROR( mywritestr(f, "        verticesBuffer.put(vertices);\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "        FloatBuffer colorsBuffer = ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_ColorToJme.makeColor(points.color, vertices.length);\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "        FloatBuffer normalsBuffer = null;\n") )
    RET_ONERROR( mywritestr(f, "        TexCoords texCoords = new TexCoords(null);\n") )
    RET_ONERROR( mywritestr(f, "        Point point = new Point(") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Util.registerTriMeshNode(node),\n") )
    RET_ONERROR( mywritestr(f, "                                verticesBuffer,\n") )
    RET_ONERROR( mywritestr(f, "                                normalsBuffer,\n") )
    RET_ONERROR( mywritestr(f, "                                colorsBuffer,\n") )
    RET_ONERROR( mywritestr(f, "                                texCoords);\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "        ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Data data = new ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Data();\n") )
    RET_ONERROR( mywritestr(f, "        node.m_data = data;\n") )
    RET_ONERROR( mywritestr(f, "        data.node = point;\n") )
    RET_ONERROR( mywritestr(f, "        data.callback = this;\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "        ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Util.applyStates(point, true, points,\n") )
    RET_ONERROR( mywritestr(f, "                             points.color, false, true);\n") )
    RET_ONERROR( mywritestr(f, "    }\n") )
    RET_ONERROR( mywritestr(f, "}\n") )
    RET_ONERROR( mywritestr(f, "\n") )

    RET_ONERROR( mywritestr(f, "class MyTextProcessEventCallback extends ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "TextProcessEventCallback\n") )
    RET_ONERROR( mywritestr(f, "{\n") )
    RET_ONERROR( mywritestr(f, "    public boolean processEvent(") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "Node node, String event) {\n") )
    RET_ONERROR( mywritestr(f, "        if (node != null) {\n") )
    RET_ONERROR( mywritestr(f, "            ((") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Data)node.m_data).callback.update(node);\n") )
    RET_ONERROR( mywritestr(f, "            return true;\n") )
    RET_ONERROR( mywritestr(f, "        }\n") )
    RET_ONERROR( mywritestr(f, "        return false;\n") )
    RET_ONERROR( mywritestr(f, "    }\n") )
    RET_ONERROR( mywritestr(f, "}\n") )
    RET_ONERROR( mywritestr(f, "\n") )

    RET_ONERROR( mywritestr(f, "class MyTextDoWithDataCallback extends ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "TextDoWithDataCallback {\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "    final int textureUpdate = 1;\n") )
    RET_ONERROR( mywritestr(f, "    final int textureSwitch = 2;\n") )
    RET_ONERROR( mywritestr(f, "    final int triangulation = 3;\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "    int renderMethod = textureSwitch;\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "    final int textRes = 256;\n") )
    RET_ONERROR( mywritestr(f, "    final int maxQuadRes = 2048; // maximal 2^n texturesize on (most ?) older cards\n") )
    RET_ONERROR( mywritestr(f, "    final float scaleFactor = 1.2f;\n") )
    RET_ONERROR( mywritestr(f, "    final float offset = 0.2f;\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "    ColorRGBA makeTextColor(") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "Node node) {\n") )
    RET_ONERROR( mywritestr(f, "        ColorRGBA color = new ColorRGBA(0.8f, 0.8f, 0.8f, 0.0f);\n") )
    RET_ONERROR( mywritestr(f, "        ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "Appearance appearance = (") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "Appearance)((") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "Shape)node.m_parent).appearance;\n") )
    RET_ONERROR( mywritestr(f, "        if (appearance != null) {\n") )
    RET_ONERROR( mywritestr(f, "            ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "Material material = (") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "Material)((") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "Appearance)appearance).material;\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "            if (material != null) // try to emulate diffuse/emissive mix\n") )
    RET_ONERROR( mywritestr(f, "                color = new ColorRGBA((material.diffuseColor[0] +\n") )
    RET_ONERROR( mywritestr(f, "                                      1 -\n") )
    RET_ONERROR( mywritestr(f, "                                      (1 - material.emissiveColor[0]) / 2) / 2.0f,\n") )
    RET_ONERROR( mywritestr(f, "                                      (material.diffuseColor[1] +\n") )
    RET_ONERROR( mywritestr(f, "                                      1 -\n") )
    RET_ONERROR( mywritestr(f, "                                      (1 - material.emissiveColor[1]) / 2) / 2.0f,\n") )
    RET_ONERROR( mywritestr(f, "                                      (material.diffuseColor[2] +\n") )
    RET_ONERROR( mywritestr(f, "                                      1 -\n") )
    RET_ONERROR( mywritestr(f, "                                      (1 - material.emissiveColor[2]) / 2) / 2.0f,\n") )
    RET_ONERROR( mywritestr(f, "                                      1 - material.transparency);\n") )
    RET_ONERROR( mywritestr(f, "        }\n") )
    RET_ONERROR( mywritestr(f, "        return color;\n") )
    RET_ONERROR( mywritestr(f, "    }\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "    int getFontSize(") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "Node node) {\n") )
    RET_ONERROR( mywritestr(f, "        ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "Text text = (") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "Text) node;\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "        int size = 1;\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "        ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "FontStyle fontStyle = (") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "FontStyle)text.fontStyle;\n") )
    RET_ONERROR( mywritestr(f, "        if (fontStyle != null)\n") )
    RET_ONERROR( mywritestr(f, "            size = fontStyle.size < 1 ? 1 : (int)fontStyle.size;\n") )
    RET_ONERROR( mywritestr(f, "        return size;\n") )
    RET_ONERROR( mywritestr(f, "    }\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "    Font makeTextFont(") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "Node node) {\n") )
    RET_ONERROR( mywritestr(f, "        ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "Text text = (") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "Text) node;\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "        Font font = null;\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "        ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "FontStyle fontStyle = (") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "FontStyle)text.fontStyle;\n") )
    RET_ONERROR( mywritestr(f, "        int size = textRes;\n") )
    RET_ONERROR( mywritestr(f, "        String family = \"Serif\";\n") )
    RET_ONERROR( mywritestr(f, "        int style = Font.PLAIN;\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "        if (fontStyle != null) {\n") )
    RET_ONERROR( mywritestr(f, "            if (fontStyle.style != null) {\n") )
    RET_ONERROR( mywritestr(f, "                if (fontStyle.style.equals(\"PLAIN\"))\n") )
    RET_ONERROR( mywritestr(f, "                    style = Font.PLAIN;\n") )
    RET_ONERROR( mywritestr(f, "                else if (fontStyle.style.equals(\"BOLD\"))\n") )
    RET_ONERROR( mywritestr(f, "                    style = Font.BOLD;\n") )
    RET_ONERROR( mywritestr(f, "                else if (fontStyle.style.equals(\"ITALIC\"))\n") )
    RET_ONERROR( mywritestr(f, "                    style = Font.ITALIC;\n") )
    RET_ONERROR( mywritestr(f, "                else if (fontStyle.style.equals(\"BOLDITALIC\"))\n") )
    RET_ONERROR( mywritestr(f, "                    style = Font.ITALIC | Font.BOLD;\n") )
    RET_ONERROR( mywritestr(f, "                else\n") )
    RET_ONERROR( mywritestr(f, "                    style = Font.PLAIN;\n") )
    RET_ONERROR( mywritestr(f, "            }\n") )
    RET_ONERROR( mywritestr(f, "            if (fontStyle.family != null) {\n") )
    RET_ONERROR( mywritestr(f, "                for (int i = 0; i < fontStyle.family.length; i++) {\n") )
    RET_ONERROR( mywritestr(f, "                    if (fontStyle.family[i].equals(\"SERIF\")) {\n") )
    RET_ONERROR( mywritestr(f, "                        family = \"Serif\";\n") )
    RET_ONERROR( mywritestr(f, "                    } else if (fontStyle.family[i].equals(\"SANS\")) {\n") )
    RET_ONERROR( mywritestr(f, "                        family = \"SansSerif\";\n") )
    RET_ONERROR( mywritestr(f, "                    } else if (fontStyle.family[i].equals(\"TYPEWRITER\")) {\n") )
    RET_ONERROR( mywritestr(f, "                        family = \"Monospaced\";\n") )
    RET_ONERROR( mywritestr(f, "                    } else {\n") )
    RET_ONERROR( mywritestr(f, "                        font = new Font(fontStyle.family[i], style, size);\n") )
    RET_ONERROR( mywritestr(f, "                        if (font.getFamily().equals(fontStyle.family[i]))\n") )
    RET_ONERROR( mywritestr(f, "                            break;\n") )
    RET_ONERROR( mywritestr(f, "                        else\n") )
    RET_ONERROR( mywritestr(f, "                            continue;\n") )
    RET_ONERROR( mywritestr(f, "                    }\n") )
    RET_ONERROR( mywritestr(f, "                    font = new Font(family, style, size);\n") )
    RET_ONERROR( mywritestr(f, "                    break;\n") )
    RET_ONERROR( mywritestr(f, "                }\n") )
    RET_ONERROR( mywritestr(f, "            } else\n") )
    RET_ONERROR( mywritestr(f, "               font = new Font(family, style, size);\n") )
    RET_ONERROR( mywritestr(f, "        } else\n") )
    RET_ONERROR( mywritestr(f, "            font = new Font(family, style, size);\n") )
    RET_ONERROR( mywritestr(f, "        return font;\n") )
    RET_ONERROR( mywritestr(f, "    }\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "    Spatial makeText(") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "Node node, boolean update) {\n") )
    RET_ONERROR( mywritestr(f, "        ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "Text text = (") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "Text) node;\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "        boolean expensiveUpdate = false;\n") )
    RET_ONERROR( mywritestr(f, "        if (renderMethod == textureSwitch)\n") )
    RET_ONERROR( mywritestr(f, "            expensiveUpdate = true;\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "        if ((text.string == null) || (text.string.length == 0))\n") )
    RET_ONERROR( mywritestr(f, "            return null;\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "        if (((") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "Shape)node.m_parent) == null)\n") )
    RET_ONERROR( mywritestr(f, "            return null;\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "        Quad txt = null;\n") )
    RET_ONERROR( mywritestr(f, "        if (update)\n") )
    RET_ONERROR( mywritestr(f, "            txt = (Quad)((") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Data)node.m_data).node;\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "        int len = 0;\n") )
    RET_ONERROR( mywritestr(f, "        for (int i = 0; i < text.string.length; i++)\n") )
    RET_ONERROR( mywritestr(f, "            if (text.string[i].length() > len)\n") )
    RET_ONERROR( mywritestr(f, "                len = text.string[i].length();\n") )
    RET_ONERROR( mywritestr(f, "        if (len == 0)\n") )
    RET_ONERROR( mywritestr(f, "            return null;\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "        int size = getFontSize(node);\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "        int quadRes = 256;\n") )
    RET_ONERROR( mywritestr(f, "        if ((len > 64) || (text.string.length > 64))\n") )
    RET_ONERROR( mywritestr(f, "            quadRes = maxQuadRes;\n") )
    RET_ONERROR( mywritestr(f, "        else if ((len > 32) || (text.string.length > 32))\n") )
    RET_ONERROR( mywritestr(f, "            quadRes = (2048 >= maxQuadRes) ? maxQuadRes : 2048;\n") )
    RET_ONERROR( mywritestr(f, "        else if ((len > 16) || (text.string.length > 16))\n") )
    RET_ONERROR( mywritestr(f, "            quadRes = (1024 >= maxQuadRes) ? maxQuadRes : 1024;\n") )
    RET_ONERROR( mywritestr(f, "        else if ((len > 8) || (text.string.length > 8))\n") )
    RET_ONERROR( mywritestr(f, "            quadRes = 512;\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "        BufferedImage img = new BufferedImage(quadRes, quadRes,\n") )
    RET_ONERROR( mywritestr(f, "                                              BufferedImage.TYPE_INT_ARGB);\n") )
    RET_ONERROR( mywritestr(f, "        Graphics2D g2d = (Graphics2D) img.getGraphics();\n") )
    RET_ONERROR( mywritestr(f, "        g2d.setFont(makeTextFont(node));\n") )
    RET_ONERROR( mywritestr(f, "        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING,\n") )
    RET_ONERROR( mywritestr(f, "                             RenderingHints.VALUE_ANTIALIAS_ON);\n") )
    RET_ONERROR( mywritestr(f, "        g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING,\n") )
    RET_ONERROR( mywritestr(f, "                             RenderingHints.VALUE_TEXT_ANTIALIAS_ON);\n") )
    RET_ONERROR( mywritestr(f, "        AffineTransform transform = new AffineTransform();\n") )
    RET_ONERROR( mywritestr(f, "        transform.scale(((float)quadRes) / (textRes * len),\n") )
    RET_ONERROR( mywritestr(f, "                        ((float)quadRes) / (textRes * text.string.length));\n") )
    RET_ONERROR( mywritestr(f, "        float colors[] = makeTextColor(node).getColorArray();\n") )
    RET_ONERROR( mywritestr(f, "        Color color = new Color(colors[0], colors[1], colors[2]);\n") )
    RET_ONERROR( mywritestr(f, "        g2d.setColor(color);\n") )
    RET_ONERROR( mywritestr(f, "        g2d.transform(transform);\n") )
    RET_ONERROR( mywritestr(f, "        for (int i = 0; i < text.string.length; i++) {\n") )
    RET_ONERROR( mywritestr(f, "            g2d.drawString(text.string[i], 0, textRes * (i + 1.0f - offset));\n") )
    RET_ONERROR( mywritestr(f, "        }\n") )
    RET_ONERROR( mywritestr(f, "        g2d.dispose();\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "        if (txt == null)\n") )
    RET_ONERROR( mywritestr(f, "            txt = new Quad(") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Util.registerTriMeshNode(node),\n") )
    RET_ONERROR( mywritestr(f, "                           len * size * scaleFactor, text.string.length * size * scaleFactor);\n") )
    RET_ONERROR( mywritestr(f, "        else\n") )
    RET_ONERROR( mywritestr(f, "            txt.resize(len * size * scaleFactor, text.string.length * size * scaleFactor);\n") )
    RET_ONERROR( mywritestr(f, "        txt.setLocalTranslation(len * size / 2.0f, (2 - text.string.length) * size / 2.0f - offset, 0);\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "        if (update || expensiveUpdate) {\n") )
    RET_ONERROR( mywritestr(f, "            TextureManager.releaseTexture(((") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Data)node.m_data).veryOldTexture);\n") )
    RET_ONERROR( mywritestr(f, "            TextureManager.deleteTextureFromCard(((") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Data)node.m_data).veryOldTexture);\n") )
    RET_ONERROR( mywritestr(f, "        }\n") )
    RET_ONERROR( mywritestr(f, "        Texture tex = TextureManager.loadTexture(img,\n") )
    RET_ONERROR( mywritestr(f, "                                     MinificationFilter.BilinearNoMipMaps,\n") )
    RET_ONERROR( mywritestr(f, "                                     MagnificationFilter.Bilinear, true);\n") )
    RET_ONERROR( mywritestr(f, "        ((") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Data)node.m_data).oldTexture = tex;\n") )
    RET_ONERROR( mywritestr(f, "        ((") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Data)node.m_data).veryOldTexture = ((") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Data)node.m_data).oldTexture;\n") )
    RET_ONERROR( mywritestr(f, "        TextureState ts = DisplaySystem.getDisplaySystem().getRenderer().createTextureState();\n") )
    RET_ONERROR( mywritestr(f, "        ts.setEnabled(true);\n") )
    RET_ONERROR( mywritestr(f, "        ts.setTexture(tex);\n") )
    RET_ONERROR( mywritestr(f, "        txt.setRenderState(ts);\n") )
    RET_ONERROR( mywritestr(f, "        txt.setRenderState(") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_AlphaToJme.makeAlpha());\n") )
    RET_ONERROR( mywritestr(f, "        txt.setRenderQueueMode(Renderer.QUEUE_TRANSPARENT);\n") )
    RET_ONERROR( mywritestr(f, "        if (update || expensiveUpdate)\n") )
    RET_ONERROR( mywritestr(f, "            txt.updateRenderState();\n") )
    RET_ONERROR( mywritestr(f, "        return txt;\n") )
    RET_ONERROR( mywritestr(f, "    }\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "    public void update(") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "Node node) {\n") )
    RET_ONERROR( mywritestr(f, "        if (renderMethod == triangulation) {\n") )
    RET_ONERROR( mywritestr(f, "            ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "Text text = (") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "Text) node;\n") )
    RET_ONERROR( mywritestr(f, "            Text3D text3d = (Text3D)((") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Data)node.m_data).node;\n") )
    RET_ONERROR( mywritestr(f, "            text3d.setText(text.string[0]);\n") )
    RET_ONERROR( mywritestr(f, "        } else if (renderMethod == textureSwitch) {\n") )
    RET_ONERROR( mywritestr(f, "            ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "Shape shape = (") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "Shape)node.m_parent;\n") )
    RET_ONERROR( mywritestr(f, "            Node jmeShape = (Node)((") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Data)shape.m_data).node;\n") )
    RET_ONERROR( mywritestr(f, "            boolean detached = false;\n") )
    RET_ONERROR( mywritestr(f, "            if (shape.geometry != null)\n") )
    RET_ONERROR( mywritestr(f, "                if (shape.geometry.m_data != null) {\n") )
    RET_ONERROR( mywritestr(f, "                    Spatial txt = makeText(node, false);\n") )
    RET_ONERROR( mywritestr(f, "                    detached = true;\n") )
    RET_ONERROR( mywritestr(f, "                    if ((jmeShape.getChildren() != null) && \n") )
    RET_ONERROR( mywritestr(f, "                        (!jmeShape.getChildren().isEmpty()))\n") )
    RET_ONERROR( mywritestr(f, "                        jmeShape.detachChildAt(0);\n") )
    RET_ONERROR( mywritestr(f, "                    if (txt != null)\n") )
    RET_ONERROR( mywritestr(f, "                        jmeShape.attachChild(txt);\n") )
    RET_ONERROR( mywritestr(f, "                }\n") )
    RET_ONERROR( mywritestr(f, "            if (!detached)\n") ) 
    RET_ONERROR( mywritestr(f, "                if ((jmeShape.getChildren() != null) && \n") )
    RET_ONERROR( mywritestr(f, "                    (!jmeShape.getChildren().isEmpty()))\n") )
    RET_ONERROR( mywritestr(f, "                    jmeShape.detachChildAt(0);\n") )
    RET_ONERROR( mywritestr(f, "        } else\n") )
    RET_ONERROR( mywritestr(f, "            makeText(node, true);\n") )
    RET_ONERROR( mywritestr(f, "    }\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "    public void doWithData(") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "Node node) {\n") )
    RET_ONERROR( mywritestr(f, "        ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "Text text = (") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "Text) node;\n") )
    RET_ONERROR( mywritestr(f, "        node.m_data = new ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Data();\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "        if (renderMethod == triangulation) {\n") )
    RET_ONERROR( mywritestr(f, "            Font3D font = new Font3D(makeTextFont(node), 0.0, false, true, true);\n") )
    RET_ONERROR( mywritestr(f, "            Text3D text3d = new Text3D(font, text.string[0], 1);\n") )
    RET_ONERROR( mywritestr(f, "            text3d.setFontColor(new ColorRGBA(1,0,0,0));\n") )
    RET_ONERROR( mywritestr(f, "            ((") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Data)node.m_data).node = text3d;\n") )
    RET_ONERROR( mywritestr(f, "        } else {\n") )
    RET_ONERROR( mywritestr(f, "            ((") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Data)node.m_data).node = makeText(node, false);\n") )
    RET_ONERROR( mywritestr(f, "        }\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "        ((") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Data)node.m_data).callback = this;\n") )
    RET_ONERROR( mywritestr(f, "    }\n") )
    RET_ONERROR( mywritestr(f, "}\n") )
    RET_ONERROR( mywritestr(f, "\n") )

    RET_ONERROR( mywritestr(f, "class MyMaterialProcessEventCallback extends ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "MaterialProcessEventCallback {\n") )
    RET_ONERROR( mywritestr(f, "    public boolean processEvent(") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "Node node, String event) {\n") )
    RET_ONERROR( mywritestr(f, "        ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "Node appearance = node.m_parent;\n") )
    RET_ONERROR( mywritestr(f, "        if (appearance != null) {\n") )
    RET_ONERROR( mywritestr(f, "            ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "Shape shape = (") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "Shape)(appearance.m_parent);\n") )
    RET_ONERROR( mywritestr(f, "            if (shape != null) {\n") )
    RET_ONERROR( mywritestr(f, "                ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "Node geometry = shape.geometry;\n") )
    RET_ONERROR( mywritestr(f, "                if (geometry != null)\n") )
    RET_ONERROR( mywritestr(f, "                    if ((geometry.m_data != null) &&\n") )
    RET_ONERROR( mywritestr(f, "                        ((") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Data)geometry.m_data).callback != null)\n") )
    RET_ONERROR( mywritestr(f, "                        ((") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Data)geometry.m_data).callback.update(geometry);\n") )
    RET_ONERROR( mywritestr(f, "            }\n") )
    RET_ONERROR( mywritestr(f, "        }\n") )
    RET_ONERROR( mywritestr(f, "        return true;\n") )
    RET_ONERROR( mywritestr(f, "    }\n") )
    RET_ONERROR( mywritestr(f, "}\n") )
    RET_ONERROR( mywritestr(f, "\n") )

    RET_ONERROR( mywritestr(f, "class MyTextureTransformProcessEventCallback extends ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "TextureTransformProcessEventCallback {\n") )
    RET_ONERROR( mywritestr(f, "    public boolean processEvent(") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "Node node, String event) {\n") )
    RET_ONERROR( mywritestr(f, "        ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "Node appearance = node.m_parent;\n") )
    RET_ONERROR( mywritestr(f, "        if (appearance != null) {\n") )
    RET_ONERROR( mywritestr(f, "            ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "Shape shape = (") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "Shape)(appearance.m_parent);\n") )
    RET_ONERROR( mywritestr(f, "            if (shape != null) {\n") )
    RET_ONERROR( mywritestr(f, "                ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "Node geometry = shape.geometry;\n") )
    RET_ONERROR( mywritestr(f, "                if (geometry != null)\n") )
    RET_ONERROR( mywritestr(f, "                    if ((geometry.m_data != null) &&\n") )
    RET_ONERROR( mywritestr(f, "                        ((") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Data)geometry.m_data).callback != null) {\n") )
    RET_ONERROR( mywritestr(f, "                        ((") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Data)geometry.m_data).callback.update(geometry);\n") )
    RET_ONERROR( mywritestr(f, "                        Texture texture = ((") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Data)geometry.m_data).texture;\n") )
    RET_ONERROR( mywritestr(f, "                        TextureState textureState = DisplaySystem.getDisplaySystem().getRenderer().createTextureState();\n") )
    RET_ONERROR( mywritestr(f, "                        texture.setMatrix(") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_TextureToJme.getTextureTransformMatrix(geometry));\n") )
    RET_ONERROR( mywritestr(f, "                        textureState.setTexture(texture, 0);\n") )
    RET_ONERROR( mywritestr(f, "                    }\n") )
    RET_ONERROR( mywritestr(f, "            }\n") )
    RET_ONERROR( mywritestr(f, "        }\n") )
    RET_ONERROR( mywritestr(f, "        return true;\n") )
    RET_ONERROR( mywritestr(f, "    }\n") )
    RET_ONERROR( mywritestr(f, "}\n") )
    RET_ONERROR( mywritestr(f, "\n") )

    RET_ONERROR( mywritestr(f, "class MyShapeProcessEventCallback extends ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "ShapeProcessEventCallback {\n") )
    RET_ONERROR( mywritestr(f, "    public boolean processEvent(") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "Node node, String event) {\n") )
    RET_ONERROR( mywritestr(f, "        MyShapeDoWithDataCallback callback = (MyShapeDoWithDataCallback)(((") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Data)node.m_data).callback);\n") )
    RET_ONERROR( mywritestr(f, "        callback.update(node);\n") )
    RET_ONERROR( mywritestr(f, "        return true;\n") )
    RET_ONERROR( mywritestr(f, "    }\n") )
    RET_ONERROR( mywritestr(f, "}\n") )
    RET_ONERROR( mywritestr(f, "\n") )

    RET_ONERROR( mywritestr(f, "class MyShapeDoWithDataCallback extends ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "ShapeDoWithDataCallback {\n") )
    RET_ONERROR( mywritestr(f, "    public void update(") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "Node node) {\n") )
    RET_ONERROR( mywritestr(f, "        ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "Node updateNode = ((") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "Shape)node.m_parent.m_parent).geometry;\n") )
    RET_ONERROR( mywritestr(f, "        ((") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Data)updateNode.m_data).callback.update(updateNode);\n") )
    RET_ONERROR( mywritestr(f, "    }\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "    public void doWithData(") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "Node node) {\n") )
    RET_ONERROR( mywritestr(f, "        ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "Shape shape = (") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "Shape) node;\n") )
    RET_ONERROR( mywritestr(f, "        Node jmeShape = new Node(\"Shape\");\n") )
    RET_ONERROR( mywritestr(f, "        if (shape.geometry != null)\n") )
    RET_ONERROR( mywritestr(f, "            if (shape.geometry.m_data != null)\n") )
    RET_ONERROR( mywritestr(f, "                if (((") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Data)shape.geometry.m_data).node != null)\n") )
    RET_ONERROR( mywritestr(f, "                    jmeShape.attachChild(((Spatial)((") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Data)shape.geometry.m_data).node));\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "        node.m_data = new ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Data();\n") )
    RET_ONERROR( mywritestr(f, "        ((") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Data)node.m_data).node = jmeShape;\n") )
    RET_ONERROR( mywritestr(f, "        ((") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Data)node.m_data).callback = this;\n") )
    RET_ONERROR( mywritestr(f, "    }\n") )
    RET_ONERROR( mywritestr(f, "}\n") )
    RET_ONERROR( mywritestr(f, "\n") )

    RET_ONERROR( mywritestr(f, "class MyTransformDoWithDataCallback extends ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "TransformDoWithDataCallback {\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "    public Object getNullOrObject(") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "Node node) {") )
    RET_ONERROR( mywritestr(f, "        if (node.getClass() == ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "Transform.class)\n") )
    RET_ONERROR( mywritestr(f, "            return getTransformMatrix(node);\n") )
    RET_ONERROR( mywritestr(f, "        else\n") )
    RET_ONERROR( mywritestr(f, "            return null;\n") )
    RET_ONERROR( mywritestr(f, "    }\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "    public TransformMatrix getTransformMatrix(") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "Node node) {\n") )
    RET_ONERROR( mywritestr(f, "        ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "Transform transform = (") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "Transform) node;\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "        // a usual 4x4 Matrix holding all information can not be applied\n") )
    RET_ONERROR( mywritestr(f, "        // directly to a Spatial, so some information (scaleOrientation gets lost)\n") )
    RET_ONERROR( mywritestr(f, "        TransformMatrix matrix = new TransformMatrix();\n") )
    RET_ONERROR( mywritestr(f, "        matrix.loadIdentity();\n") )
    RET_ONERROR( mywritestr(f, "        TransformMatrix multMatrix = new TransformMatrix();\n") )
    RET_ONERROR( mywritestr(f, "        Vector3f tempStore = new Vector3f();\n") )
    RET_ONERROR( mywritestr(f, "        Quaternion quat = new Quaternion();\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "        multMatrix.loadIdentity();\n") )
    RET_ONERROR( mywritestr(f, "        multMatrix.setTranslation(transform.translation[0],\n") )
    RET_ONERROR( mywritestr(f, "                                  transform.translation[1],\n") )
    RET_ONERROR( mywritestr(f, "                                  transform.translation[2]);\n") )
    RET_ONERROR( mywritestr(f, "        matrix.multLocal(multMatrix, tempStore);\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "        multMatrix.loadIdentity();\n") )
    RET_ONERROR( mywritestr(f, "        multMatrix.setTranslation(transform.center[0],\n") )
    RET_ONERROR( mywritestr(f, "                                  transform.center[1],\n") )
    RET_ONERROR( mywritestr(f, "                                  transform.center[2]);\n") )
    RET_ONERROR( mywritestr(f, "        matrix.multLocal(multMatrix, tempStore);\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "        multMatrix.loadIdentity();\n") )
    RET_ONERROR( mywritestr(f, "        quat.fromAngleAxis(transform.rotation[3],\n") )
    RET_ONERROR( mywritestr(f, "                           new Vector3f(transform.rotation[0],\n") )
    RET_ONERROR( mywritestr(f, "                                        transform.rotation[1],\n") )
    RET_ONERROR( mywritestr(f, "                                        transform.rotation[2]));\n") )
    RET_ONERROR( mywritestr(f, "        multMatrix.setRotationQuaternion(quat);\n") )
    RET_ONERROR( mywritestr(f, "        matrix.multLocal(multMatrix, tempStore);\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "        // scaleOrientation (shearing ?) not supported by TransformMatrix ?\n") )
    RET_ONERROR( mywritestr(f, "        multMatrix.loadIdentity();\n") )
    RET_ONERROR( mywritestr(f, "        quat.loadIdentity();\n") )
    RET_ONERROR( mywritestr(f, "        quat.fromAngleAxis(transform.scaleOrientation[3],\n") )
    RET_ONERROR( mywritestr(f, "                           new Vector3f(transform.scaleOrientation[0],\n") )
    RET_ONERROR( mywritestr(f, "                                        transform.scaleOrientation[1],\n") )
    RET_ONERROR( mywritestr(f, "                                        transform.scaleOrientation[2]));\n") )
    RET_ONERROR( mywritestr(f, "        multMatrix.setRotationQuaternion(quat);\n") )
    RET_ONERROR( mywritestr(f, "        matrix.multLocal(multMatrix, tempStore);\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "        multMatrix.loadIdentity();\n") )
    RET_ONERROR( mywritestr(f, "        multMatrix.setScale(new Vector3f(transform.scale[0],\n") )
    RET_ONERROR( mywritestr(f, "                                         transform.scale[1],\n") )
    RET_ONERROR( mywritestr(f, "                                         transform.scale[2]));\n") )
    RET_ONERROR( mywritestr(f, "        matrix.multLocal(multMatrix, tempStore);\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "        // scaleOrientation (shearing ?) not supported by TransformMatrix ?\n") )
    RET_ONERROR( mywritestr(f, "        multMatrix.loadIdentity();\n") )
    RET_ONERROR( mywritestr(f, "        quat.loadIdentity();\n") )
    RET_ONERROR( mywritestr(f, "        quat.fromAngleAxis(-transform.scaleOrientation[3],\n") )
    RET_ONERROR( mywritestr(f, "                           new Vector3f(transform.scaleOrientation[0],\n") )
    RET_ONERROR( mywritestr(f, "                                        transform.scaleOrientation[1],\n") )
    RET_ONERROR( mywritestr(f, "                                        transform.scaleOrientation[2]));\n") )
    RET_ONERROR( mywritestr(f, "        multMatrix.setRotationQuaternion(quat);\n") )
    RET_ONERROR( mywritestr(f, "        matrix.multLocal(multMatrix, tempStore);\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "        // \"TransformMatrix\" is not a 4x4 Matrix, -center needs scale\n") )
    RET_ONERROR( mywritestr(f, "        multMatrix.loadIdentity();\n") )
    RET_ONERROR( mywritestr(f, "        multMatrix.setTranslation(-transform.center[0] * transform.scale[0],\n") )
    RET_ONERROR( mywritestr(f, "                                  -transform.center[1] * transform.scale[1],\n") )
    RET_ONERROR( mywritestr(f, "                                  -transform.center[2] * transform.scale[2]);\n") )
    RET_ONERROR( mywritestr(f, "        matrix.multLocal(multMatrix, tempStore);\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "        return matrix;\n") )
    RET_ONERROR( mywritestr(f, "    }\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "    public void update(") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "Node node) {\n") )
    RET_ONERROR( mywritestr(f, "        ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "Transform transform = (") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "Transform) node;\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "        Node jmeTransform = ((Node)((") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Data)node.m_data).node);\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "        TransformMatrix matrix = getTransformMatrix(node);\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "        matrix.applyToSpatial(jmeTransform);\n") )
    RET_ONERROR( mywritestr(f, "    }\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "    public void doWithData(") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "Node node) {\n") )
    RET_ONERROR( mywritestr(f, "        ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "Transform transform = (") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "Transform) node;\n") )
    RET_ONERROR( mywritestr(f, "        Node jmeTransform = new Node(\"Transform\");\n") )
    RET_ONERROR( mywritestr(f, "        node.m_data = new ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Data();\n") )
    RET_ONERROR( mywritestr(f, "        ((") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Data)node.m_data).node = jmeTransform;\n") )
    RET_ONERROR( mywritestr(f, "        ((") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Data)node.m_data).callback = this;\n") )
    RET_ONERROR( mywritestr(f, "        if (transform.children != null) {\n") )
    RET_ONERROR( mywritestr(f, "            for (int i = 0; i < transform.children.length; i++) {\n") )
    RET_ONERROR( mywritestr(f, "                if (transform.children[i] == null)\n") )
    RET_ONERROR( mywritestr(f, "                    continue;\n") )
    RET_ONERROR( mywritestr(f, "                if (transform.children[i].m_data == null)\n") )
    RET_ONERROR( mywritestr(f, "                    continue;\n") )
    RET_ONERROR( mywritestr(f, "                if (((") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Data)transform.children[i].m_data).node == null)\n") )
    RET_ONERROR( mywritestr(f, "                    continue;\n") )
    RET_ONERROR( mywritestr(f, "                jmeTransform.attachChild(((Node)((") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Data)transform.children[i].m_data).node));\n") )
    RET_ONERROR( mywritestr(f, "            }\n") )
    RET_ONERROR( mywritestr(f, "        }\n") )
    RET_ONERROR( mywritestr(f, "        update(node);\n") )
    RET_ONERROR( mywritestr(f, "    }\n") )
    RET_ONERROR( mywritestr(f, "}\n") )
    RET_ONERROR( mywritestr(f, "\n") )

    RET_ONERROR( mywritestr(f, "class MyTransformProcessEventCallback extends ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "TransformProcessEventCallback {\n") )
    RET_ONERROR( mywritestr(f, "    public boolean processEvent(") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "Node node, String event) {\n") )
    RET_ONERROR( mywritestr(f, "        MyTransformDoWithDataCallback callback = (MyTransformDoWithDataCallback)(((") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Data)node.m_data).callback);\n") )
    RET_ONERROR( mywritestr(f, "        callback.update(node);\n") )
    RET_ONERROR( mywritestr(f, "        return true;\n") )
    RET_ONERROR( mywritestr(f, "    }\n") )
    RET_ONERROR( mywritestr(f, "}\n") )
    RET_ONERROR( mywritestr(f, "\n") )

    RET_ONERROR( mywritestr(f, "class MyGroupDoWithDataCallback extends ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "GroupDoWithDataCallback {\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "    public void doWithData(") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "Node node) {\n") )
    RET_ONERROR( mywritestr(f, "        ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "Group group = (") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "Group)node;\n") )
    RET_ONERROR( mywritestr(f, "        Node jmeGroup = new Node(\"Group\");\n") )
    RET_ONERROR( mywritestr(f, "        if (node.m_parent != null) {\n") )
    RET_ONERROR( mywritestr(f, "            // not root node\n") )
    RET_ONERROR( mywritestr(f, "            node.m_data = new ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Data();\n") )
    RET_ONERROR( mywritestr(f, "            ((") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Data)node.m_data).node = jmeGroup;\n") )
    RET_ONERROR( mywritestr(f, "        }\n") )
    RET_ONERROR( mywritestr(f, "        if (group.children != null) {\n") )
    RET_ONERROR( mywritestr(f, "            for (int i = 0; i < group.children.length; i++) {\n") )
    RET_ONERROR( mywritestr(f, "                if (group.children[i] == null)\n") )
    RET_ONERROR( mywritestr(f, "                    continue;\n") )
    RET_ONERROR( mywritestr(f, "                if (group.children[i].m_data == null)\n") )
    RET_ONERROR( mywritestr(f, "                    continue;\n") )
    RET_ONERROR( mywritestr(f, "                if (((") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Data)group.children[i].m_data).node == null)\n") )
    RET_ONERROR( mywritestr(f, "                    continue;\n") )
    RET_ONERROR( mywritestr(f, "                ((Node)((") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Data)node.m_data).node).attachChild(((Node)((") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Data)group.children[i].m_data).node));\n") )
    RET_ONERROR( mywritestr(f, "            }\n") )
    RET_ONERROR( mywritestr(f, "        }\n") )
    RET_ONERROR( mywritestr(f, "    }\n") )
    RET_ONERROR( mywritestr(f, "}\n") )
    RET_ONERROR( mywritestr(f, "\n") )

    RET_ONERROR( mywritestr(f, "class MyStaticGroupDoWithDataCallback extends ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "StaticGroupDoWithDataCallback {\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "    public void doWithData(") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "Node node) {\n") )
    RET_ONERROR( mywritestr(f, "        ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "StaticGroup group = (") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "StaticGroup)node;\n") )
    RET_ONERROR( mywritestr(f, "        Node jmeGroup = new Node(\"StaticGroup\");\n") )
    RET_ONERROR( mywritestr(f, "        if (node.m_parent != null) {\n") )
    RET_ONERROR( mywritestr(f, "            // not root node\n") )
    RET_ONERROR( mywritestr(f, "            node.m_data = new ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Data();\n") )
    RET_ONERROR( mywritestr(f, "            ((") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Data)node.m_data).node = jmeGroup;\n") )
    RET_ONERROR( mywritestr(f, "        }\n") )
    RET_ONERROR( mywritestr(f, "        if (group.children != null) {\n") )
    RET_ONERROR( mywritestr(f, "            for (int i = 0; i < group.children.length; i++) {\n") )
    RET_ONERROR( mywritestr(f, "                if (group.children[i] == null)\n") )
    RET_ONERROR( mywritestr(f, "                    continue;\n") )
    RET_ONERROR( mywritestr(f, "                if (group.children[i].m_data == null)\n") )
    RET_ONERROR( mywritestr(f, "                    continue;\n") )
    RET_ONERROR( mywritestr(f, "                if (((") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Data)group.children[i].m_data).node == null)\n") )
    RET_ONERROR( mywritestr(f, "                    continue;\n") )
    RET_ONERROR( mywritestr(f, "                ((Node)((") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Data)node.m_data).node).attachChild(((Node)((") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Data)group.children[i].m_data).node));\n") )
    RET_ONERROR( mywritestr(f, "            }\n") )
    RET_ONERROR( mywritestr(f, "        }\n") )
    RET_ONERROR( mywritestr(f, "    }\n") )
    RET_ONERROR( mywritestr(f, "}\n") )
    RET_ONERROR( mywritestr(f, "\n") )

    RET_ONERROR( mywritestr(f, "class MyAnchorDoWithDataCallback extends ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "AnchorDoWithDataCallback {\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "    public void doWithData(") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "Node node) {\n") )
    RET_ONERROR( mywritestr(f, "        ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "Anchor anchor = (") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "Anchor)node;\n") )
    RET_ONERROR( mywritestr(f, "        Node jmeAnchor = new Node(\"Anchor\");\n") )
    RET_ONERROR( mywritestr(f, "        if (anchor.children != null) {\n") )
    RET_ONERROR( mywritestr(f, "            for (int i = 0; i < anchor.children.length; i++) {\n") )
    RET_ONERROR( mywritestr(f, "                if (anchor.children[i] == null)\n") )
    RET_ONERROR( mywritestr(f, "                    continue;\n") )
    RET_ONERROR( mywritestr(f, "                if (anchor.children[i].m_data == null)\n") )
    RET_ONERROR( mywritestr(f, "                    continue;\n") )
    RET_ONERROR( mywritestr(f, "                if (((") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Data)anchor.children[i].m_data).node == null)\n") )
    RET_ONERROR( mywritestr(f, "                    continue;\n") )
    RET_ONERROR( mywritestr(f, "                jmeAnchor.attachChild(((Node)((") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Data)anchor.children[i].m_data).node));\n") )
    RET_ONERROR( mywritestr(f, "            }\n") )
    RET_ONERROR( mywritestr(f, "       }\n") )
    RET_ONERROR( mywritestr(f, "       node.m_data = new ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Data();\n") )
    RET_ONERROR( mywritestr(f, "       ((") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Data)node.m_data).node = jmeAnchor;\n") )
    RET_ONERROR( mywritestr(f, "    }\n") )
    RET_ONERROR( mywritestr(f, "}\n") )
    RET_ONERROR( mywritestr(f, "\n") )

    RET_ONERROR( mywritestr(f, "class MySwitchProcessEventCallback extends ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "SwitchProcessEventCallback\n") )
    RET_ONERROR( mywritestr(f, "{\n") )
    RET_ONERROR( mywritestr(f, "    public boolean processEvent(") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "Node node, String event) {\n") )
    RET_ONERROR( mywritestr(f, "        if (node != null) {\n") )
    RET_ONERROR( mywritestr(f, "            ((") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Data)node.m_data).callback.update(node);\n") )
    RET_ONERROR( mywritestr(f, "             return true;\n") )
    RET_ONERROR( mywritestr(f, "        }\n") )
    RET_ONERROR( mywritestr(f, "        return false;\n") )
    RET_ONERROR( mywritestr(f, "    }\n") )
    RET_ONERROR( mywritestr(f, "}\n") )
    RET_ONERROR( mywritestr(f, "\n") )

    RET_ONERROR( mywritestr(f, "class MySwitchDoWithDataCallback extends ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "SwitchDoWithDataCallback {\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "    public void update(") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "Node node) {\n") )
    RET_ONERROR( mywritestr(f, "        ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "Switch swith = (") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "Switch)node;\n") )
    RET_ONERROR( mywritestr(f, "        if (swith.whichChoice == ((") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Data)node.m_data).oldIndex)\n") )
    RET_ONERROR( mywritestr(f, "            return;\n") )
    RET_ONERROR( mywritestr(f, "        Node jmeSwitch = (Node)((") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Data)node.m_data).node;\n") )
    RET_ONERROR( mywritestr(f, "        if (!jmeSwitch.getChildren().isEmpty())\n") )
    RET_ONERROR( mywritestr(f, "            jmeSwitch.detachChildAt(0);\n") )
    RET_ONERROR( mywritestr(f, "        if ((swith.whichChoice < 0) ||\n") )
    RET_ONERROR( mywritestr(f, "            (swith.whichChoice >= swith.children.length))\n") )
    RET_ONERROR( mywritestr(f, "            return;\n") )
    RET_ONERROR( mywritestr(f, "        if ((swith.children[swith.whichChoice] != null) &&\n") )
    RET_ONERROR( mywritestr(f, "            (swith.children[swith.whichChoice].m_data != null) &&\n") )
    RET_ONERROR( mywritestr(f, "            (((") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Data)swith.children[swith.whichChoice].m_data).node != null))\n") )
    RET_ONERROR( mywritestr(f, "            jmeSwitch.attachChild(((Node)((") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Data)swith.children[swith.whichChoice].m_data).node));\n") )
    RET_ONERROR( mywritestr(f, "        ((") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Data)node.m_data).oldIndex = swith.whichChoice;\n") )
    RET_ONERROR( mywritestr(f, "    }\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "    public void doWithData(") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "Node node) {\n") )
    RET_ONERROR( mywritestr(f, "        ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "Switch swith = (") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "Switch)node;\n") )
    RET_ONERROR( mywritestr(f, "        if ((swith.whichChoice < 0) ||\n") )
    RET_ONERROR( mywritestr(f, "            (swith.whichChoice >= swith.children.length))\n") )
    RET_ONERROR( mywritestr(f, "            return;\n") )
    RET_ONERROR( mywritestr(f, "        Node jmeSwitch = new Node(\"Switch\");\n") )
    RET_ONERROR( mywritestr(f, "        if ((swith.children[swith.whichChoice] != null) &&\n") )
    RET_ONERROR( mywritestr(f, "            (swith.children[swith.whichChoice].m_data != null) &&\n") )
    RET_ONERROR( mywritestr(f, "            (((") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Data)swith.children[swith.whichChoice].m_data).node != null))\n") )
    RET_ONERROR( mywritestr(f, "            jmeSwitch.attachChild(((Node)((") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Data)swith.children[swith.whichChoice].m_data).node));\n") )
    RET_ONERROR( mywritestr(f, "        node.m_data = new ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Data();\n") )
    RET_ONERROR( mywritestr(f, "        ((") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Data)node.m_data).node = jmeSwitch;\n") )
    RET_ONERROR( mywritestr(f, "        ((") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Data)node.m_data).callback = this;\n") )
    RET_ONERROR( mywritestr(f, "        ((") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Data)node.m_data).oldIndex = swith.whichChoice;\n") )
    RET_ONERROR( mywritestr(f, "    }\n") )
    RET_ONERROR( mywritestr(f, "}\n") )
    RET_ONERROR( mywritestr(f, "\n") )

    RET_ONERROR( mywritestr(f, "class MyCollisionDoWithDataCallback extends ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "CollisionDoWithDataCallback {\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "    public void doWithData(") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "Node node) {\n") )
    RET_ONERROR( mywritestr(f, "        ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "Collision collision = (") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "Collision)node;\n") )
    RET_ONERROR( mywritestr(f, "        Node jmeCollision = new Node(\"Collision\");\n") )
    RET_ONERROR( mywritestr(f, "        if (collision.children != null) {\n") )
    RET_ONERROR( mywritestr(f, "            for (int i = 0; i < collision.children.length; i++) {\n") )
    RET_ONERROR( mywritestr(f, "                if (collision.children[i] == null)\n") )
    RET_ONERROR( mywritestr(f, "                    continue;\n") )
    RET_ONERROR( mywritestr(f, "                if (collision.children[i].m_data == null)\n") )
    RET_ONERROR( mywritestr(f, "                    continue;\n") )
    RET_ONERROR( mywritestr(f, "                if (((") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Data)collision.children[i].m_data).node == null)\n") )
    RET_ONERROR( mywritestr(f, "                    continue;\n") )
    RET_ONERROR( mywritestr(f, "                jmeCollision.attachChild(((Node)((") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Data)collision.children[i].m_data).node));\n") )
    RET_ONERROR( mywritestr(f, "            }\n") )
    RET_ONERROR( mywritestr(f, "        }\n") )
    RET_ONERROR( mywritestr(f, "        node.m_data = new ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Data();\n") )
    RET_ONERROR( mywritestr(f, "        ((") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Data)node.m_data).node = jmeCollision;\n") )
    RET_ONERROR( mywritestr(f, "    }\n") )
    RET_ONERROR( mywritestr(f, "}\n") )
    RET_ONERROR( mywritestr(f, "\n") )

    RET_ONERROR( mywritestr(f, "class MyBillboardDoWithDataCallback extends ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "BillboardDoWithDataCallback {\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "    public void doWithData(") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "Node node) {\n") )
    RET_ONERROR( mywritestr(f, "        ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "Billboard billboard = (") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "Billboard)node;\n") )
    RET_ONERROR( mywritestr(f, "        boolean valid = false;\n") )
    RET_ONERROR( mywritestr(f, "        int axis = -1;\n") )
    RET_ONERROR( mywritestr(f, "        if (billboard.axisOfRotation[0] == 0)\n") )
    RET_ONERROR( mywritestr(f, "            if (billboard.axisOfRotation[1] == 0)\n") )
    RET_ONERROR( mywritestr(f, "                if (billboard.axisOfRotation[2] == 0) {\n") )
    RET_ONERROR( mywritestr(f, "                    valid = true;\n") )
    RET_ONERROR( mywritestr(f, "                    axis = BillboardNode.CAMERA_ALIGNED;\n") )
    RET_ONERROR( mywritestr(f, "                } else {\n") )
    RET_ONERROR( mywritestr(f, "                    valid = true;\n") )
    RET_ONERROR( mywritestr(f, "                    axis = BillboardNode.AXIAL_Z;\n") )
    RET_ONERROR( mywritestr(f, "                } else if (billboard.axisOfRotation[2] == 0) {\n") )
    RET_ONERROR( mywritestr(f, "                   valid = true;\n") )
    RET_ONERROR( mywritestr(f, "                   axis = BillboardNode.AXIAL_Y;\n") )
    RET_ONERROR( mywritestr(f, "                }\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "        BillboardNode jmeBillboard = new BillboardNode(valid ? \"Billboard\" :\n") )
    RET_ONERROR( mywritestr(f, "                                                       \"unsupported Billboard\");\n") )
    RET_ONERROR( mywritestr(f, "        if (valid)\n") )
    RET_ONERROR( mywritestr(f, "            jmeBillboard.setAlignment(axis);\n") )
    RET_ONERROR( mywritestr(f, "        node.m_data = new ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Data();\n") )
    RET_ONERROR( mywritestr(f, "        ((") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Data)node.m_data).node = jmeBillboard;\n") )
    RET_ONERROR( mywritestr(f, "        if (billboard.children != null) {\n") )
    RET_ONERROR( mywritestr(f, "            for (int i = 0; i < billboard.children.length; i++) {\n") )
    RET_ONERROR( mywritestr(f, "                if (billboard.children[i] == null)\n") )
    RET_ONERROR( mywritestr(f, "                    continue;\n") )
    RET_ONERROR( mywritestr(f, "                if (billboard.children[i].m_data == null)\n") )
    RET_ONERROR( mywritestr(f, "                    continue;\n") )
    RET_ONERROR( mywritestr(f, "                if (((") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Data)billboard.children[i].m_data).node == null)\n") )
    RET_ONERROR( mywritestr(f, "                    continue;\n") )
    RET_ONERROR( mywritestr(f, "                jmeBillboard.attachChild(((Node)((") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Data)billboard.children[i].m_data).node));\n") )
    RET_ONERROR( mywritestr(f, "            }\n") )
    RET_ONERROR( mywritestr(f, "        }\n") )
    RET_ONERROR( mywritestr(f, "    }\n") )
    RET_ONERROR( mywritestr(f, "}\n") )
    RET_ONERROR( mywritestr(f, "\n") )

    RET_ONERROR( mywritestr(f, "class MyLODDoWithDataCallback extends ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "LODDoWithDataCallback {\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "    public void doWithData(") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "Node node) {\n") )
    RET_ONERROR( mywritestr(f, "        ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "LOD lod = (") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "LOD)node;\n") )
    RET_ONERROR( mywritestr(f, "        DistanceSwitchModel switchModel = new DistanceSwitchModel();\n") )
    RET_ONERROR( mywritestr(f, "        DiscreteLodNode jmeLOD = new DiscreteLodNode(\"LOD\", switchModel);\n") )
    RET_ONERROR( mywritestr(f, "        node.m_data = new ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Data();\n") )
    RET_ONERROR( mywritestr(f, "        ((") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Data)node.m_data).node = jmeLOD;\n") )
    RET_ONERROR( mywritestr(f, "        if (lod.children != null) {\n") )
    RET_ONERROR( mywritestr(f, "            for (int i = 0; i < lod.children.length; i++) {\n") )
    RET_ONERROR( mywritestr(f, "                if (lod.children[i] == null)\n") )
    RET_ONERROR( mywritestr(f, "                    continue;\n") )
    RET_ONERROR( mywritestr(f, "                if (lod.children[i].m_data == null)\n") )
    RET_ONERROR( mywritestr(f, "                    continue;\n") )
    RET_ONERROR( mywritestr(f, "                if (((") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Data)lod.children[i].m_data).node == null)\n") )
    RET_ONERROR( mywritestr(f, "                    continue;\n") )
    RET_ONERROR( mywritestr(f, "                jmeLOD.attachChild(((Node)((") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Data)lod.children[i].m_data).node));\n") )
    RET_ONERROR( mywritestr(f, "                if (i < lod.children.length) {\n") )
    RET_ONERROR( mywritestr(f, "                    float minRange = 0;\n") )
    RET_ONERROR( mywritestr(f, "                    if (i > 0)\n") )
    RET_ONERROR( mywritestr(f, "                        minRange = lod.range[i - 1];\n") )
    RET_ONERROR( mywritestr(f, "                    float maxRange = java.lang.Float.MAX_VALUE;\n") )
    RET_ONERROR( mywritestr(f, "                    if (i < lod.range.length)\n") )
    RET_ONERROR( mywritestr(f, "                        maxRange = lod.range[i];\n") )
    RET_ONERROR( mywritestr(f, "                    switchModel.setModelDistance(i, minRange, maxRange);\n") )
    RET_ONERROR( mywritestr(f, "                }\n") )
    RET_ONERROR( mywritestr(f, "            }\n") )
    RET_ONERROR( mywritestr(f, "        }\n") )
    RET_ONERROR( mywritestr(f, "    }\n") )
    RET_ONERROR( mywritestr(f, "}\n") )
    RET_ONERROR( mywritestr(f, "\n") )

    RET_ONERROR( mywritestr(f, "class MyCADPartDoWithDataCallback extends ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "CADPartDoWithDataCallback {\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "    public Object getNullOrObject(") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "Node node) {\n") )
    RET_ONERROR( mywritestr(f, "        if (node.getClass() == ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "CADPart.class)\n") )
    RET_ONERROR( mywritestr(f, "            return getTransformMatrix(node);\n") )
    RET_ONERROR( mywritestr(f, "        else\n") )
    RET_ONERROR( mywritestr(f, "            return null;\n") )
    RET_ONERROR( mywritestr(f, "    }\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "    public TransformMatrix getTransformMatrix(") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "Node node) {\n") )
    RET_ONERROR( mywritestr(f, "        ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "CADPart cadPart = (") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "CADPart)node;\n") )
    RET_ONERROR( mywritestr(f, "        TransformMatrix matrix = new TransformMatrix();\n") )
    RET_ONERROR( mywritestr(f, "        TransformMatrix multMatrix = new TransformMatrix();\n") )
    RET_ONERROR( mywritestr(f, "        Vector3f tempStore = new Vector3f();\n") )
    RET_ONERROR( mywritestr(f, "        Quaternion quat = new Quaternion();\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "        multMatrix.setTranslation(cadPart.translation[0],\n") )
    RET_ONERROR( mywritestr(f, "                                  cadPart.translation[1],\n") )
    RET_ONERROR( mywritestr(f, "                                  cadPart.translation[2]);\n") )
    RET_ONERROR( mywritestr(f, "        matrix.multLocal(multMatrix, tempStore);\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "        multMatrix.loadIdentity();\n") )
    RET_ONERROR( mywritestr(f, "        multMatrix.setTranslation(cadPart.center[0],\n") )
    RET_ONERROR( mywritestr(f, "                                  cadPart.center[1],\n") )
    RET_ONERROR( mywritestr(f, "                                  cadPart.center[2]);\n") )
    RET_ONERROR( mywritestr(f, "        matrix.multLocal(multMatrix, tempStore);\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "        multMatrix.loadIdentity();\n") )
    RET_ONERROR( mywritestr(f, "        quat.fromAngleAxis(cadPart.rotation[3],\n") )
    RET_ONERROR( mywritestr(f, "                           new Vector3f(cadPart.rotation[0],\n") )
    RET_ONERROR( mywritestr(f, "                                        cadPart.rotation[1],\n") )
    RET_ONERROR( mywritestr(f, "                                        cadPart.rotation[2]));\n") )
    RET_ONERROR( mywritestr(f, "        multMatrix.setRotationQuaternion(quat);\n") )
    RET_ONERROR( mywritestr(f, "        matrix.multLocal(multMatrix, tempStore);\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "        // scaleOrientation (shearing ?) not supported by TransformMatrix ?\n") )
    RET_ONERROR( mywritestr(f, "        multMatrix.loadIdentity();\n") )
    RET_ONERROR( mywritestr(f, "        quat.loadIdentity();\n") )
    RET_ONERROR( mywritestr(f, "        quat.fromAngleAxis(cadPart.scaleOrientation[3],\n") )
    RET_ONERROR( mywritestr(f, "                           new Vector3f(cadPart.scaleOrientation[0],\n") )
    RET_ONERROR( mywritestr(f, "                                        cadPart.scaleOrientation[1],\n") )
    RET_ONERROR( mywritestr(f, "                                        cadPart.scaleOrientation[2]));\n") )
    RET_ONERROR( mywritestr(f, "        multMatrix.setRotationQuaternion(quat);\n") )
    RET_ONERROR( mywritestr(f, "        matrix.multLocal(multMatrix, tempStore);\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "        multMatrix.loadIdentity();\n") )
    RET_ONERROR( mywritestr(f, "        multMatrix.setScale(new Vector3f(cadPart.scale[0],\n") )
    RET_ONERROR( mywritestr(f, "                                         cadPart.scale[1],\n") )
    RET_ONERROR( mywritestr(f, "                                         cadPart.scale[2]));\n") )
    RET_ONERROR( mywritestr(f, "        matrix.multLocal(multMatrix, tempStore);\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "        // scaleOrientation (shearing ?) not supported by TransformMatrix ?\n") )
    RET_ONERROR( mywritestr(f, "        multMatrix.loadIdentity();\n") )
    RET_ONERROR( mywritestr(f, "        quat.loadIdentity();\n") )
    RET_ONERROR( mywritestr(f, "        quat.fromAngleAxis(-cadPart.scaleOrientation[3],\n") )
    RET_ONERROR( mywritestr(f, "                           new Vector3f(cadPart.scaleOrientation[0],\n") )
    RET_ONERROR( mywritestr(f, "                                        cadPart.scaleOrientation[1],\n") )
    RET_ONERROR( mywritestr(f, "                                        cadPart.scaleOrientation[2]));\n") )
    RET_ONERROR( mywritestr(f, "        multMatrix.setRotationQuaternion(quat);\n") )
    RET_ONERROR( mywritestr(f, "        matrix.multLocal(multMatrix, tempStore);\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "        // \"TransformMatrix\" is not a 4x4 Matrix, -center needs scale\n") )
    RET_ONERROR( mywritestr(f, "        multMatrix.loadIdentity();\n") )
    RET_ONERROR( mywritestr(f, "        multMatrix.setTranslation(-cadPart.center[0] * cadPart.scale[0],\n") )
    RET_ONERROR( mywritestr(f, "                                  -cadPart.center[1] * cadPart.scale[1],\n") )
    RET_ONERROR( mywritestr(f, "                                  -cadPart.center[2] * cadPart.scale[2]);\n") )
    RET_ONERROR( mywritestr(f, "        matrix.multLocal(multMatrix, tempStore);\n") )
    RET_ONERROR( mywritestr(f, "        return matrix;\n") )
    RET_ONERROR( mywritestr(f, "    }\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "    public void doWithData(") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "Node node) {\n") )
    RET_ONERROR( mywritestr(f, "        ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "CADPart cadPart = (") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "CADPart)node;\n") )
    RET_ONERROR( mywritestr(f, "        Node jmeCADPart = new Node(\"CADPart\");\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "        TransformMatrix matrix = getTransformMatrix(node);\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "        matrix.applyToSpatial(jmeCADPart);\n") )
    RET_ONERROR( mywritestr(f, "        if (cadPart.children != null) {\n") )
    RET_ONERROR( mywritestr(f, "            for (int i = 0; i < cadPart.children.length; i++) {\n") )
    RET_ONERROR( mywritestr(f, "                if (cadPart.children[i] == null)\n") )
    RET_ONERROR( mywritestr(f, "                    continue;\n") )
    RET_ONERROR( mywritestr(f, "                if (cadPart.children[i].m_data == null)\n") )
    RET_ONERROR( mywritestr(f, "                    continue;\n") )
    RET_ONERROR( mywritestr(f, "                if (((") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Data)cadPart.children[i].m_data).node == null)\n") )
    RET_ONERROR( mywritestr(f, "                    continue;\n") )
    RET_ONERROR( mywritestr(f, "                jmeCADPart.attachChild(((Node)((") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Data)cadPart.children[i].m_data).node));\n") )
    RET_ONERROR( mywritestr(f, "            }\n") )
    RET_ONERROR( mywritestr(f, "        }\n") )
    RET_ONERROR( mywritestr(f, "        node.m_data = new ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Data();\n") )
    RET_ONERROR( mywritestr(f, "        ((") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Data)node.m_data).node = jmeCADPart;\n") )
    RET_ONERROR( mywritestr(f, "    }\n") )
    RET_ONERROR( mywritestr(f, "}\n") )
    RET_ONERROR( mywritestr(f, "\n") )

    RET_ONERROR( mywritestr(f, "class MyCADAssemblyDoWithDataCallback extends ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "CADAssemblyDoWithDataCallback {\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "    public void doWithData(") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "Node node) {\n") )
    RET_ONERROR( mywritestr(f, "        ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "CADAssembly cadAssembly = (") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "CADAssembly)node;\n") )
    RET_ONERROR( mywritestr(f, "        Node jmeCADAssembly = new Node(\"CADAssembly\");\n") )
    RET_ONERROR( mywritestr(f, "        if (cadAssembly.children != null) {\n") )
    RET_ONERROR( mywritestr(f, "            for (int i = 0; i < cadAssembly.children.length; i++) {\n") )
    RET_ONERROR( mywritestr(f, "                if (cadAssembly.children[i] == null)\n") )
    RET_ONERROR( mywritestr(f, "                    continue;\n") )
    RET_ONERROR( mywritestr(f, "                if (cadAssembly.children[i].m_data == null)\n") )
    RET_ONERROR( mywritestr(f, "                    continue;\n") )
    RET_ONERROR( mywritestr(f, "                if (((") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Data)cadAssembly.children[i].m_data).node == null)\n") )
    RET_ONERROR( mywritestr(f, "                    continue;\n") )
    RET_ONERROR( mywritestr(f, "                jmeCADAssembly.attachChild((Node)((") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Data)cadAssembly.children[i].m_data).node);\n") )
    RET_ONERROR( mywritestr(f, "            }\n") )
    RET_ONERROR( mywritestr(f, "        }\n") )
    RET_ONERROR( mywritestr(f, "        node.m_data = new ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Data();\n") )
    RET_ONERROR( mywritestr(f, "        ((") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Data)node.m_data).node = jmeCADAssembly;\n") )
    RET_ONERROR( mywritestr(f, "    }\n") )
    RET_ONERROR( mywritestr(f, "}\n") )
    RET_ONERROR( mywritestr(f, "\n") )

    RET_ONERROR( mywritestr(f, "class MyCADLayerDoWithDataCallback extends ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "CADLayerDoWithDataCallback {\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "    public void doWithData(") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "Node node) {\n") )
    RET_ONERROR( mywritestr(f, "        ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "CADLayer cadLayer = (") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "CADLayer)node;\n") )
    RET_ONERROR( mywritestr(f, "        Node jmeCADLayer = new Node(\"CADLayer\");\n") )
    RET_ONERROR( mywritestr(f, "        node.m_data = new ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Data();\n") )
    RET_ONERROR( mywritestr(f, "        ((") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Data)node.m_data).node = jmeCADLayer;\n") )
    RET_ONERROR( mywritestr(f, "        if (cadLayer.children == null)\n") )
    RET_ONERROR( mywritestr(f, "            return;\n") )
    RET_ONERROR( mywritestr(f, "        for (int i = 0; i < cadLayer.children.length; i++) {\n") )
    RET_ONERROR( mywritestr(f, "            if (cadLayer.children[i] == null)\n") )
    RET_ONERROR( mywritestr(f, "                continue;\n") )
    RET_ONERROR( mywritestr(f, "            if (cadLayer.children[i].m_data == null)\n") )
    RET_ONERROR( mywritestr(f, "                continue;\n") )
    RET_ONERROR( mywritestr(f, "            if (((") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Data)cadLayer.children[i].m_data).node == null)\n") )
    RET_ONERROR( mywritestr(f, "                continue;\n") )
    RET_ONERROR( mywritestr(f, "            if ((cadLayer.visible == null) || (i >= cadLayer.visible.length))\n") )
    RET_ONERROR( mywritestr(f, "                ((Node)((") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Data)node.m_data).node).attachChild(((Node)((") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Data)cadLayer.children[i].m_data).node));\n") )
    RET_ONERROR( mywritestr(f, "            else if (cadLayer.visible[i])\n") )
    RET_ONERROR( mywritestr(f, "                ((Node)((") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Data)node.m_data).node).attachChild(((Node)((") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Data)cadLayer.children[i].m_data).node));\n") )
    RET_ONERROR( mywritestr(f, "        }\n") )
    RET_ONERROR( mywritestr(f, "    }\n") )
    RET_ONERROR( mywritestr(f, "}\n") )
    RET_ONERROR( mywritestr(f, "\n") )

    RET_ONERROR( mywritestr(f, "class MyCADFaceDoWithDataCallback extends ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "CADFaceDoWithDataCallback {\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "    public void doWithData(") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "Node node) {\n") )
    RET_ONERROR( mywritestr(f, "        ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "CADFace cadFace = (") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "CADFace)node;\n") )
    RET_ONERROR( mywritestr(f, "        Node jmeCADFace = new Node(\"CADFace\");\n") )
    RET_ONERROR( mywritestr(f, "        node.m_data = new ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Data();\n") )
    RET_ONERROR( mywritestr(f, "        ((") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Data)node.m_data).node = jmeCADFace;\n") )
    RET_ONERROR( mywritestr(f, "        ((Node)((") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Data)node.m_data).node).attachChild(((Node)((") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Data)cadFace.shape.m_data).node));\n") )
    RET_ONERROR( mywritestr(f, "    }\n") )
    RET_ONERROR( mywritestr(f, "}\n") )
    RET_ONERROR( mywritestr(f, "\n") )

    RET_ONERROR( mywritestr(f, "class MyPositionInterpolatorProcessEventCallback extends ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "PositionInterpolatorProcessEventCallback {\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "    private boolean warned;\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "    MyPositionInterpolatorProcessEventCallback() {\n") )
    RET_ONERROR( mywritestr(f, "        warned = false;\n") )
    RET_ONERROR( mywritestr(f, "    }\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "    public boolean processEvent(") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "Node node, String event) {\n") )
    RET_ONERROR( mywritestr(f, "        ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "PositionInterpolator interpolator = (") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "PositionInterpolator)node;\n") )
    RET_ONERROR( mywritestr(f, "        if (interpolator.key.length * 3 != interpolator.keyValue.length) {\n") )
    RET_ONERROR( mywritestr(f, "            if (!warned)\n") )
    RET_ONERROR( mywritestr(f, "               System.out.println(\"invalid PositionInterpolator: number keys do not match number values\");\n") )
    RET_ONERROR( mywritestr(f, "            warned = true;\n") )
    RET_ONERROR( mywritestr(f, "            return false;\n") )
    RET_ONERROR( mywritestr(f, "        }\n") )
    RET_ONERROR( mywritestr(f, "        ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Interpolator.accountInterpolator(interpolator.value_changed,\n") )
    RET_ONERROR( mywritestr(f, "                                             interpolator.set_fraction,\n") )
    RET_ONERROR( mywritestr(f, "                                             interpolator.key,\n") )
    RET_ONERROR( mywritestr(f, "                                             interpolator.keyValue, 3);\n") )
    RET_ONERROR( mywritestr(f, "        return true;\n") )
    RET_ONERROR( mywritestr(f, "    }\n") )
    RET_ONERROR( mywritestr(f, "}\n") )
    RET_ONERROR( mywritestr(f, "\n") )

    RET_ONERROR( mywritestr(f, "class MyPositionInterpolator2DProcessEventCallback extends ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "PositionInterpolator2DProcessEventCallback {\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "    private boolean warned;\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "    MyPositionInterpolator2DProcessEventCallback() {\n") )
    RET_ONERROR( mywritestr(f, "        warned = false;\n") )
    RET_ONERROR( mywritestr(f, "    }\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "    public boolean processEvent(") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "Node node, String event) {\n") )
    RET_ONERROR( mywritestr(f, "        ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "PositionInterpolator2D interpolator = (") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "PositionInterpolator2D)node;\n") )
    RET_ONERROR( mywritestr(f, "        if (interpolator.key.length * 2 != interpolator.keyValue.length) {\n") )
    RET_ONERROR( mywritestr(f, "            if (!warned)\n") )
    RET_ONERROR( mywritestr(f, "               System.out.println(\"invalid PositionInterpolator: number keys do not match number values\");\n") )
    RET_ONERROR( mywritestr(f, "            warned = true;\n") )
    RET_ONERROR( mywritestr(f, "            return false;\n") )
    RET_ONERROR( mywritestr(f, "        }\n") )
    RET_ONERROR( mywritestr(f, "        ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Interpolator.accountInterpolator(interpolator.value_changed,\n") )
    RET_ONERROR( mywritestr(f, "                                             interpolator.set_fraction,\n") )
    RET_ONERROR( mywritestr(f, "                                             interpolator.key,\n") )
    RET_ONERROR( mywritestr(f, "                                             interpolator.keyValue, 2);\n") )
    RET_ONERROR( mywritestr(f, "        return true;\n") )
    RET_ONERROR( mywritestr(f, "    }\n") )
    RET_ONERROR( mywritestr(f, "}\n") )
    RET_ONERROR( mywritestr(f, "\n") )

    RET_ONERROR( mywritestr(f, "class MyOrientationInterpolatorProcessEventCallback extends ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "OrientationInterpolatorProcessEventCallback {\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "    private boolean warned;\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "    MyOrientationInterpolatorProcessEventCallback() {\n") )
    RET_ONERROR( mywritestr(f, "        warned = false;\n") )
    RET_ONERROR( mywritestr(f, "    }\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "    public boolean processEvent(") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "Node node, String event) {\n") )
    RET_ONERROR( mywritestr(f, "        ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "OrientationInterpolator interpolator = (") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "OrientationInterpolator)node;\n") )
    RET_ONERROR( mywritestr(f, "        if (interpolator.key.length * 4 != interpolator.keyValue.length) {\n") )
    RET_ONERROR( mywritestr(f, "            if (!warned)\n") )
    RET_ONERROR( mywritestr(f, "               System.out.println(\"invalid OrientationInterpolator: number keys do not match number values\");\n") )
    RET_ONERROR( mywritestr(f, "            warned = true;\n") )
    RET_ONERROR( mywritestr(f, "            return false;\n") )
    RET_ONERROR( mywritestr(f, "        }\n") )
    RET_ONERROR( mywritestr(f, "        ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Interpolator.accountInterpolator(interpolator.value_changed,\n") )
    RET_ONERROR( mywritestr(f, "                                             interpolator.set_fraction,\n") )
    RET_ONERROR( mywritestr(f, "                                             interpolator.key,\n") )
    RET_ONERROR( mywritestr(f, "                                             interpolator.keyValue, 4);\n") )
    RET_ONERROR( mywritestr(f, "        return true;\n") )
    RET_ONERROR( mywritestr(f, "    }\n") )
    RET_ONERROR( mywritestr(f, "}\n") )
    RET_ONERROR( mywritestr(f, "\n") )

    RET_ONERROR( mywritestr(f, "class MyColorInterpolatorProcessEventCallback extends ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "ColorInterpolatorProcessEventCallback {\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "    private boolean warned;\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "    MyColorInterpolatorProcessEventCallback() {\n") )
    RET_ONERROR( mywritestr(f, "        warned = false;\n") )
    RET_ONERROR( mywritestr(f, "    }\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "    public boolean processEvent(") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "Node node, String event) {\n") )
    RET_ONERROR( mywritestr(f, "        ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "ColorInterpolator interpolator = (") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "ColorInterpolator)node;\n") )
    RET_ONERROR( mywritestr(f, "        if (interpolator.key.length * 3 != interpolator.keyValue.length) {\n") )
    RET_ONERROR( mywritestr(f, "            if (!warned)\n") )
    RET_ONERROR( mywritestr(f, "               System.out.println(\"invalid ColorInterpolator: number keys do not match number values\");\n") )
    RET_ONERROR( mywritestr(f, "            warned = true;\n") )
    RET_ONERROR( mywritestr(f, "            return false;\n") )
    RET_ONERROR( mywritestr(f, "        }\n") )
    RET_ONERROR( mywritestr(f, "        ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Interpolator.accountInterpolator(interpolator.value_changed,\n") )
    RET_ONERROR( mywritestr(f, "                                             interpolator.set_fraction,\n") )
    RET_ONERROR( mywritestr(f, "                                             interpolator.key,\n") )
    RET_ONERROR( mywritestr(f, "                                             interpolator.keyValue, 3);\n") )
    RET_ONERROR( mywritestr(f, "        return true;\n") )
    RET_ONERROR( mywritestr(f, "    }\n") )
    RET_ONERROR( mywritestr(f, "}\n") )
    RET_ONERROR( mywritestr(f, "\n") )

    RET_ONERROR( mywritestr(f, "class MyScalarInterpolatorProcessEventCallback extends ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "ScalarInterpolatorProcessEventCallback {\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "    private boolean warned;\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "    MyScalarInterpolatorProcessEventCallback() {\n") )
    RET_ONERROR( mywritestr(f, "        warned = false;\n") )
    RET_ONERROR( mywritestr(f, "    }\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "    public boolean processEvent(") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "Node node, String event) {\n") )
    RET_ONERROR( mywritestr(f, "        ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "ScalarInterpolator interpolator = (") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "ScalarInterpolator)node;\n") )
    RET_ONERROR( mywritestr(f, "        if (interpolator.key.length != interpolator.keyValue.length) {\n") )
    RET_ONERROR( mywritestr(f, "            if (!warned)\n") )
    RET_ONERROR( mywritestr(f, "               System.out.println(\"invalid ScalarInterpolator: number keys do not match number values\");\n") )
    RET_ONERROR( mywritestr(f, "            warned = true;\n") )
    RET_ONERROR( mywritestr(f, "            return false;\n") )
    RET_ONERROR( mywritestr(f, "        }\n") )
    RET_ONERROR( mywritestr(f, "        float value[] = new float[1];\n") )
    RET_ONERROR( mywritestr(f, "        ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Interpolator.accountInterpolator(value,\n") )
    RET_ONERROR( mywritestr(f, "                                             interpolator.set_fraction,\n") )
    RET_ONERROR( mywritestr(f, "                                             interpolator.key,\n") )
    RET_ONERROR( mywritestr(f, "                                             interpolator.keyValue, 1);\n") )
    RET_ONERROR( mywritestr(f, "        interpolator.value_changed = value[0];\n") )
    RET_ONERROR( mywritestr(f, "        return true;\n") )
    RET_ONERROR( mywritestr(f, "    }\n") )
    RET_ONERROR( mywritestr(f, "}\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "\n") )

    RET_ONERROR( mywritestr(f, "class MyCoordinateInterpolatorProcessEventCallback extends ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "CoordinateInterpolatorProcessEventCallback {\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "    int targetSize;\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "    public boolean processEvent(") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "Node node, String event) {\n") )
    RET_ONERROR( mywritestr(f, "        ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "CoordinateInterpolator interpolator = (") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "CoordinateInterpolator)node;\n") )
    RET_ONERROR( mywritestr(f, "        if (interpolator.value_changed == null) {\n") )
    RET_ONERROR( mywritestr(f, "            targetSize = interpolator.keyValue.length / interpolator.key.length;\n") )
    RET_ONERROR( mywritestr(f, "            interpolator.value_changed = new float[targetSize == 0 ? 1 :\n") )
    RET_ONERROR( mywritestr(f, "                                                   targetSize];\n") )
    RET_ONERROR( mywritestr(f, "        }\n") )
    RET_ONERROR( mywritestr(f, "        ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Interpolator.accountInterpolator(interpolator.value_changed,\n") )
    RET_ONERROR( mywritestr(f, "                                             interpolator.set_fraction,\n") )
    RET_ONERROR( mywritestr(f, "                                             interpolator.key,\n") )
    RET_ONERROR( mywritestr(f, "                                             interpolator.keyValue,\n") )
    RET_ONERROR( mywritestr(f, "                                             interpolator.value_changed.length);\n") )
    RET_ONERROR( mywritestr(f, "        return true;\n") )
    RET_ONERROR( mywritestr(f, "    }\n") )
    RET_ONERROR( mywritestr(f, "}\n") )
    RET_ONERROR( mywritestr(f, "\n") )

    RET_ONERROR( mywritestr(f, "class MyCoordinateInterpolator2DProcessEventCallback extends ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "CoordinateInterpolator2DProcessEventCallback {\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "    int targetSize;\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "    public boolean processEvent(") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "Node node, String event) {\n") )
    RET_ONERROR( mywritestr(f, "        ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "CoordinateInterpolator2D interpolator = (") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "CoordinateInterpolator2D)node;\n") )
    RET_ONERROR( mywritestr(f, "        if (interpolator.value_changed == null) {\n") )
    RET_ONERROR( mywritestr(f, "            targetSize = interpolator.keyValue.length / interpolator.key.length;\n") )
    RET_ONERROR( mywritestr(f, "            interpolator.value_changed = new float[targetSize == 0 ? 1 :\n") )
    RET_ONERROR( mywritestr(f, "                                                   targetSize];\n") )
    RET_ONERROR( mywritestr(f, "        }\n") )
    RET_ONERROR( mywritestr(f, "        ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Interpolator.accountInterpolator(interpolator.value_changed,\n") )
    RET_ONERROR( mywritestr(f, "                                             interpolator.set_fraction,\n") )
    RET_ONERROR( mywritestr(f, "                                             interpolator.key,\n") )
    RET_ONERROR( mywritestr(f, "                                             interpolator.keyValue,\n") )
    RET_ONERROR( mywritestr(f, "                                             interpolator.value_changed.length);\n") )
    RET_ONERROR( mywritestr(f, "        return true;\n") )
    RET_ONERROR( mywritestr(f, "    }\n") )
    RET_ONERROR( mywritestr(f, "}\n") )
    RET_ONERROR( mywritestr(f, "\n") )

    RET_ONERROR( mywritestr(f, "class MyNormalInterpolatorProcessEventCallback extends ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "NormalInterpolatorProcessEventCallback {\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "    public boolean processEvent(") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "Node node, String event) {\n") )
    RET_ONERROR( mywritestr(f, "        int targetSize = 0;\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "        ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "NormalInterpolator interpolator = (") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "NormalInterpolator)node;\n") )
    RET_ONERROR( mywritestr(f, "        if (interpolator.value_changed == null) {\n") )
    RET_ONERROR( mywritestr(f, "            targetSize = interpolator.keyValue.length / interpolator.key.length;\n") )
    RET_ONERROR( mywritestr(f, "            interpolator.value_changed = new float[targetSize == 0 ? 1 :\n") )
    RET_ONERROR( mywritestr(f, "                                                   targetSize];\n") )
    RET_ONERROR( mywritestr(f, "        }\n") )
    RET_ONERROR( mywritestr(f, "        ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Interpolator.accountInterpolator(interpolator.value_changed,\n") )
    RET_ONERROR( mywritestr(f, "                                             interpolator.set_fraction,\n") )
    RET_ONERROR( mywritestr(f, "                                             interpolator.key,\n") )
    RET_ONERROR( mywritestr(f, "                                             interpolator.keyValue,\n") )
    RET_ONERROR( mywritestr(f, "                                             interpolator.value_changed.length);\n") )
    RET_ONERROR( mywritestr(f, "        /* normalize results */\n") )
    RET_ONERROR( mywritestr(f, "        for (int i = 0; i < targetSize; i += 3) {\n") )
    RET_ONERROR( mywritestr(f, "            double vec0 = interpolator.keyValue[3 * i];\n") )
    RET_ONERROR( mywritestr(f, "            double vec1 = interpolator.keyValue[3 * i + 1];\n") )
    RET_ONERROR( mywritestr(f, "            double vec2 = interpolator.keyValue[3 * i + 2];\n") )
    RET_ONERROR( mywritestr(f, "            double len = Math.sqrt(vec0 * vec0 + vec1 * vec1 + vec2 * vec2);\n") )
    RET_ONERROR( mywritestr(f, "            if (len != 0)\n") )
    RET_ONERROR( mywritestr(f, "                for (int j = 0; j < 3; j++)\n") )
    RET_ONERROR( mywritestr(f, "                    interpolator.keyValue[3 * i + j] /= len;\n") )
    RET_ONERROR( mywritestr(f, "        }\n") )
    RET_ONERROR( mywritestr(f, "        return true;\n") )
    RET_ONERROR( mywritestr(f, "    }\n") )
    RET_ONERROR( mywritestr(f, "}\n") )
    RET_ONERROR( mywritestr(f, "\n") )

    RET_ONERROR( mywritestr(f, "class MyStringSensorDoWithDataCallback extends ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "StringSensorDoWithDataCallback {\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "    public void doWithData(") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "Node node) {\n") )
    RET_ONERROR( mywritestr(f, "        ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Util.registerStringSensorNode(node);\n") )
    RET_ONERROR( mywritestr(f, "        node.m_data = new ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Data();\n") )
    RET_ONERROR( mywritestr(f, "    }\n") )
    RET_ONERROR( mywritestr(f, "}\n") )
    RET_ONERROR( mywritestr(f, "\n") )

    RET_ONERROR( mywritestr(f, "class MyStringSensorProcessEventCallback extends ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "StringSensorProcessEventCallback {\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "    public boolean processEvent(") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "Node node, String event) {\n") )
    RET_ONERROR( mywritestr(f, "        ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "StringSensor stringSensor = (") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "StringSensor)node;\n") )
    RET_ONERROR( mywritestr(f, "        ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Data data = (") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Data)node.m_data;\n") )
    RET_ONERROR( mywritestr(f, "        if (data.isPressed && stringSensor.enabled) {\n") )
    RET_ONERROR( mywritestr(f, "            stringSensor.isActive = true;\n") )
    RET_ONERROR( mywritestr(f, "            if (data.isPressed != data.oldPressedFlag) {\n") )
    RET_ONERROR( mywritestr(f, "                if (((data.keycode == ") )
    RET_ONERROR( mywritestr(f, upperName) )
    RET_ONERROR( mywritestr(f, "Cell.keyCodeDelete) || \n") )
    RET_ONERROR( mywritestr(f, "                     (data.keycode == ") )
    RET_ONERROR( mywritestr(f, upperName) )
    RET_ONERROR( mywritestr(f, "Cell.keyCodeBackspace)) && \n") )
    RET_ONERROR( mywritestr(f, "                    stringSensor.deletionAllowed\n") )
    RET_ONERROR( mywritestr(f, "                   ) {\n") ) 
    RET_ONERROR( mywritestr(f, "                    if (stringSensor.enteredText.length() > 0)\n") )
    RET_ONERROR( mywritestr(f, "                        stringSensor.enteredText = stringSensor.enteredText.substring(0, stringSensor.enteredText.length() - 1);\n") )
    RET_ONERROR( mywritestr(f, "                } else if (data.keycode == ") )
    RET_ONERROR( mywritestr(f, upperName) )
    RET_ONERROR( mywritestr(f, "Cell.keyCodeEnter) {\n") ) 
    RET_ONERROR( mywritestr(f, "                    stringSensor.enteredText += data.keystring;\n") )
    RET_ONERROR( mywritestr(f, "                    stringSensor.finalText = stringSensor.enteredText;\n") )
    RET_ONERROR( mywritestr(f, "                    stringSensor.enteredText = \"\";\n") )
    RET_ONERROR( mywritestr(f, "                    stringSensor.isActive = false;\n") )
    RET_ONERROR( mywritestr(f, "                } else\n") )
    RET_ONERROR( mywritestr(f, "                    stringSensor.enteredText += data.keystring;\n") )
    RET_ONERROR( mywritestr(f, "                data.oldPressedFlag = data.isPressed;\n") )
    RET_ONERROR( mywritestr(f, "                return true;\n") )
    RET_ONERROR( mywritestr(f, "            }\n") )
    RET_ONERROR( mywritestr(f, "        }\n") )
    RET_ONERROR( mywritestr(f, "        data.oldPressedFlag = data.isPressed;\n") )
    RET_ONERROR( mywritestr(f, "        return false;\n") )
    RET_ONERROR( mywritestr(f, "    }\n") )
    RET_ONERROR( mywritestr(f, "}\n") )
    RET_ONERROR( mywritestr(f, "\n") )

    RET_ONERROR( mywritestr(f, "class MyKeySensorDoWithDataCallback extends ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "KeySensorDoWithDataCallback {\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "    public void doWithData(") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "Node node) {\n") )
    RET_ONERROR( mywritestr(f, "        ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Util.registerKeySensorNode(node);\n") )
    RET_ONERROR( mywritestr(f, "        node.m_data = new ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Data();\n") )
    RET_ONERROR( mywritestr(f, "        ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "KeySensor keySensor = (") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "KeySensor)node;\n") )
    RET_ONERROR( mywritestr(f, "        keySensor.altKey = false;") )
    RET_ONERROR( mywritestr(f, "        keySensor.controlKey = false;") )
    RET_ONERROR( mywritestr(f, "        keySensor.shiftKey = false;") )
    RET_ONERROR( mywritestr(f, "    }\n") )
    RET_ONERROR( mywritestr(f, "}\n") )
    RET_ONERROR( mywritestr(f, "\n") )

    RET_ONERROR( mywritestr(f, "class MyKeySensorProcessEventCallback extends ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "KeySensorProcessEventCallback {\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "    public boolean processEvent(") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "Node node, String event) {\n") )
    RET_ONERROR( mywritestr(f, "        ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "KeySensor keySensor = (") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "KeySensor)node;\n") )
    RET_ONERROR( mywritestr(f, "        ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Data data = (") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Data)node.m_data;\n") )
    RET_ONERROR( mywritestr(f, "        if (data.isPressed && keySensor.enabled) {\n") )
    RET_ONERROR( mywritestr(f, "            keySensor.isActive = true;\n") )
    RET_ONERROR( mywritestr(f, "            if (data.isPressed != data.oldPressedFlag) {\n") )
    RET_ONERROR( mywritestr(f, "                if (data.keycode == -1)\n") )
    RET_ONERROR( mywritestr(f, "                    keySensor.keyPress = data.keystring;\n") )
    RET_ONERROR( mywritestr(f, "                else if ((data.keycode != ") )
    RET_ONERROR( mywritestr(f, upperName) )
    RET_ONERROR( mywritestr(f, "Cell.keyCodeDelete) && \n") )
    RET_ONERROR( mywritestr(f, "                         (data.keycode != ") )
    RET_ONERROR( mywritestr(f, upperName) )
    RET_ONERROR( mywritestr(f, "Cell.keyCodeBackspace) && \n") )
    RET_ONERROR( mywritestr(f, "                         (data.keycode != ") )
    RET_ONERROR( mywritestr(f, upperName) )
    RET_ONERROR( mywritestr(f, "Cell.keyCodeEnter)) { \n") )
    RET_ONERROR( mywritestr(f, "                    if (data.keycode == ") )
    RET_ONERROR( mywritestr(f, upperName) )
    RET_ONERROR( mywritestr(f, "Cell.keyCodeAlt) \n") )
    RET_ONERROR( mywritestr(f, "                        keySensor.altKey = true;\n") )
    RET_ONERROR( mywritestr(f, "                    else if (data.keycode == ") )
    RET_ONERROR( mywritestr(f, upperName) )
    RET_ONERROR( mywritestr(f, "Cell.keyCodeControl) \n") )
    RET_ONERROR( mywritestr(f, "                        keySensor.controlKey = true;\n") )
    RET_ONERROR( mywritestr(f, "                    else if (data.keycode == ") )
    RET_ONERROR( mywritestr(f, upperName) )
    RET_ONERROR( mywritestr(f, "Cell.keyCodeShift) \n") )
    RET_ONERROR( mywritestr(f, "                        keySensor.shiftKey = true;\n") )    
    RET_ONERROR( mywritestr(f, "                    else \n") )
    RET_ONERROR( mywritestr(f, "                        keySensor.actionKeyPress = data.keycode;\n") )
    RET_ONERROR( mywritestr(f, "                }\n" ) )    
    RET_ONERROR( mywritestr(f, "                data.oldPressedFlag = data.isPressed;\n") )
    RET_ONERROR( mywritestr(f, "                return true;\n") )
    RET_ONERROR( mywritestr(f, "            }\n") )
    RET_ONERROR( mywritestr(f, "        }\n") )
    RET_ONERROR( mywritestr(f, "        if (data.isReleased && keySensor.enabled) {\n") )
    RET_ONERROR( mywritestr(f, "            keySensor.isActive = false;\n") )
    RET_ONERROR( mywritestr(f, "            if (data.isReleased == data.oldPressedFlag) {\n") )
    RET_ONERROR( mywritestr(f, "                if (data.keycode == -1)\n") )
    RET_ONERROR( mywritestr(f, "                    keySensor.keyRelease = data.keystring;\n") )
    RET_ONERROR( mywritestr(f, "                else if ((data.keycode != ") )
    RET_ONERROR( mywritestr(f, upperName) )
    RET_ONERROR( mywritestr(f, "Cell.keyCodeDelete) && \n") )
    RET_ONERROR( mywritestr(f, "                         (data.keycode != ") )
    RET_ONERROR( mywritestr(f, upperName) )
    RET_ONERROR( mywritestr(f, "Cell.keyCodeBackspace) && \n") )
    RET_ONERROR( mywritestr(f, "                         (data.keycode != ") )
    RET_ONERROR( mywritestr(f, upperName) )
    RET_ONERROR( mywritestr(f, "Cell.keyCodeEnter)) { \n") )
    RET_ONERROR( mywritestr(f, "                    if (data.keycode == ") )
    RET_ONERROR( mywritestr(f, upperName) )
    RET_ONERROR( mywritestr(f, "Cell.keyCodeAlt) \n") )
    RET_ONERROR( mywritestr(f, "                        keySensor.altKey = false;\n") )
    RET_ONERROR( mywritestr(f, "                    else if (data.keycode == ") )
    RET_ONERROR( mywritestr(f, upperName) )
    RET_ONERROR( mywritestr(f, "Cell.keyCodeControl) \n") )
    RET_ONERROR( mywritestr(f, "                        keySensor.controlKey = false;\n") )
    RET_ONERROR( mywritestr(f, "                    else if (data.keycode == ") )
    RET_ONERROR( mywritestr(f, upperName) )
    RET_ONERROR( mywritestr(f, "Cell.keyCodeShift) \n") )
    RET_ONERROR( mywritestr(f, "                        keySensor.shiftKey = false;\n") )    
    RET_ONERROR( mywritestr(f, "                    else \n") )
    RET_ONERROR( mywritestr(f, "                        keySensor.actionKeyRelease = data.keycode;\n") )
    RET_ONERROR( mywritestr(f, "                }\n" ) )    
    RET_ONERROR( mywritestr(f, "                data.oldPressedFlag = data.isPressed;\n") )
    RET_ONERROR( mywritestr(f, "                return true;\n") )
    RET_ONERROR( mywritestr(f, "            }\n") )
    RET_ONERROR( mywritestr(f, "        }\n") )
    RET_ONERROR( mywritestr(f, "        data.oldPressedFlag = data.isPressed;\n") )
    RET_ONERROR( mywritestr(f, "        return false;\n") )
    RET_ONERROR( mywritestr(f, "    }\n") )
    RET_ONERROR( mywritestr(f, "}\n") )
    RET_ONERROR( mywritestr(f, "\n") )

    RET_ONERROR( mywritestr(f, "class MyTouchSensorDoWithDataCallback extends ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "TouchSensorDoWithDataCallback {\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "    public void doWithData(") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "Node node) {\n") )
    RET_ONERROR( mywritestr(f, "        ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Util.registerTouchSensorNode(node);\n") )
    RET_ONERROR( mywritestr(f, "        node.m_data = new ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Data();\n") )
    RET_ONERROR( mywritestr(f, "    }\n") )
    RET_ONERROR( mywritestr(f, "}\n") )
    RET_ONERROR( mywritestr(f, "\n") )

    RET_ONERROR( mywritestr(f, "class MyTouchSensorProcessEventCallback extends ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "TouchSensorProcessEventCallback {\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "    public boolean processEvent(") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "Node node, String event) {\n") )
    RET_ONERROR( mywritestr(f, "        ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "TouchSensor touchSensor = (") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "TouchSensor)node;\n") )
    RET_ONERROR( mywritestr(f, "        ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Data data = (") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Data)node.m_data;\n") )
    RET_ONERROR( mywritestr(f, "        if (data.isPressed && touchSensor.enabled) {\n") )
    RET_ONERROR( mywritestr(f, "            touchSensor.isActive = true;\n") )
    RET_ONERROR( mywritestr(f, "            touchSensor.touchTime = System.currentTimeMillis() / 1000.0;\n") )
    RET_ONERROR( mywritestr(f, "            if (data.isPressed != data.oldPressedFlag) {\n") )
    RET_ONERROR( mywritestr(f, "                data.oldPressedFlag = data.isPressed;\n") )
    RET_ONERROR( mywritestr(f, "                return true;\n") )
    RET_ONERROR( mywritestr(f, "            }\n") )
    RET_ONERROR( mywritestr(f, "        }\n") )
    RET_ONERROR( mywritestr(f, "        if (data.isReleased && touchSensor.enabled) {\n") )
    RET_ONERROR( mywritestr(f, "            touchSensor.isActive = false;\n") )
    RET_ONERROR( mywritestr(f, "            if (data.isReleased == data.oldPressedFlag) {\n") )
    RET_ONERROR( mywritestr(f, "                data.oldPressedFlag = data.isPressed;\n") )
    RET_ONERROR( mywritestr(f, "                return true;\n") )
    RET_ONERROR( mywritestr(f, "            }\n") )
    RET_ONERROR( mywritestr(f, "        }\n") )
    RET_ONERROR( mywritestr(f, "        data.oldPressedFlag = data.isPressed;\n") )
    RET_ONERROR( mywritestr(f, "        return false;\n") )
    RET_ONERROR( mywritestr(f, "    }\n") )
    RET_ONERROR( mywritestr(f, "}\n") )
    RET_ONERROR( mywritestr(f, "\n") )

    RET_ONERROR( mywritestr(f, "class MyPlaneSensorDoWithDataCallback extends ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "PlaneSensorDoWithDataCallback {\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "    public void doWithData(") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "Node node) {\n") )
    RET_ONERROR( mywritestr(f, "        ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Util.registerPlaneSensorNode(node);\n") )
    RET_ONERROR( mywritestr(f, "        node.m_data = new ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Data();\n") )
    RET_ONERROR( mywritestr(f, "    }\n") )
    RET_ONERROR( mywritestr(f, "}\n") )
    RET_ONERROR( mywritestr(f, "\n") )

    RET_ONERROR( mywritestr(f, "class MyPlaneSensorProcessEventCallback extends ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "PlaneSensorProcessEventCallback {\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "    public boolean processEvent(") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "Node node, String event) {\n") )
    RET_ONERROR( mywritestr(f, "        ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "PlaneSensor planeSensor = (") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "PlaneSensor)node;\n") )
    RET_ONERROR( mywritestr(f, "        if (!planeSensor.enabled) {\n") )
    RET_ONERROR( mywritestr(f, "            if (planeSensor.isActive) {\n") )
    RET_ONERROR( mywritestr(f, "                planeSensor.isActive = false;\n") )
    RET_ONERROR( mywritestr(f, "                return true;\n") )
    RET_ONERROR( mywritestr(f, "            } else \n") )
    RET_ONERROR( mywritestr(f, "                return false;\n") )
    RET_ONERROR( mywritestr(f, "        }\n") )
    RET_ONERROR( mywritestr(f, "        ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Data data = (") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Data)node.m_data;\n") )
    RET_ONERROR( mywritestr(f, "        if ((!") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Util.planeSensorAutoOffsetWarning) && (!planeSensor.autoOffset)) {\n") )
    RET_ONERROR( mywritestr(f, "            ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Util.logger.warning(\"Sorry, only autoOffset == true is supported (yet)\\n\");\n") )
    RET_ONERROR( mywritestr(f, "            ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Util.planeSensorAutoOffsetWarning = true;\n") )
    RET_ONERROR( mywritestr(f, "        }\n") )
    RET_ONERROR( mywritestr(f, "        if (") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Util.hitPlaneSensor != planeSensor)\n") )
    RET_ONERROR( mywritestr(f, "            if (planeSensor.isActive) {\n") )
    RET_ONERROR( mywritestr(f, "                planeSensor.isActive = false;\n") )
    RET_ONERROR( mywritestr(f, "                return true;\n") )
    RET_ONERROR( mywritestr(f, "            } else \n") )
    RET_ONERROR( mywritestr(f, "                return false;\n") )
    RET_ONERROR( mywritestr(f, "        ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "Node parentPathNode = node;\n") )
    RET_ONERROR( mywritestr(f, "        Vector3f tempStore = new Vector3f();\n") )
    RET_ONERROR( mywritestr(f, "        TransformMatrix parentTransform = new TransformMatrix();\n") )
    RET_ONERROR( mywritestr(f, "        while (parentPathNode.m_parent != null) {\n") )
    RET_ONERROR( mywritestr(f, "             parentPathNode = parentPathNode.m_parent;\n") )
    RET_ONERROR( mywritestr(f, "             ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Data parentData = (") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Data)parentPathNode.m_data;\n") )
    RET_ONERROR( mywritestr(f, "             if ((parentData != null) && (parentData.callback != null)) {\n") )
    RET_ONERROR( mywritestr(f, "                 Object object = parentData.callback.getNullOrObject(parentPathNode);\n") )
    RET_ONERROR( mywritestr(f, "                 if (object != null)\n") )
    RET_ONERROR( mywritestr(f, "                     parentTransform.multLocal((TransformMatrix)object, tempStore);\n") )
    RET_ONERROR( mywritestr(f, "             }\n") )
    RET_ONERROR( mywritestr(f, "        }\n") )
    RET_ONERROR( mywritestr(f, "        Vector3f transform = new Vector3f();\n") )
    RET_ONERROR( mywritestr(f, "        parentTransform.getTranslation(transform);\n") )
    RET_ONERROR( mywritestr(f, "        planeSensor.trackPoint_changed[0] = data.trackpoint[0] - transform.getX();\n") )
    RET_ONERROR( mywritestr(f, "        planeSensor.trackPoint_changed[1] = data.trackpoint[1] - transform.getY();\n") )
    RET_ONERROR( mywritestr(f, "        planeSensor.trackPoint_changed[2] = data.trackpoint[2] - transform.getZ();\n") )
    RET_ONERROR( mywritestr(f, "        boolean limitedX = false;\n") )
    RET_ONERROR( mywritestr(f, "        if (planeSensor.minPosition[0] <= planeSensor.maxPosition[0]) {\n") )
    RET_ONERROR( mywritestr(f, "            if (data.trackpoint[0] - transform.getX() <= planeSensor.minPosition[0]) {\n") )
    RET_ONERROR( mywritestr(f, "                planeSensor.translation_changed[0] = planeSensor.minPosition[0];\n") )
    RET_ONERROR( mywritestr(f, "                limitedX = true;\n") )
    RET_ONERROR( mywritestr(f, "            }\n") )
    RET_ONERROR( mywritestr(f, "            if (data.trackpoint[0] - transform.getX() >= planeSensor.maxPosition[0]) {\n") )
    RET_ONERROR( mywritestr(f, "                planeSensor.translation_changed[0] = planeSensor.maxPosition[0];\n") )
    RET_ONERROR( mywritestr(f, "                limitedX = true;\n") )
    RET_ONERROR( mywritestr(f, "            }\n") )
    RET_ONERROR( mywritestr(f, "        }\n") )
    RET_ONERROR( mywritestr(f, "        if (!limitedX)\n") )
    RET_ONERROR( mywritestr(f, "            planeSensor.translation_changed[0] = data.trackpoint[0] - transform.getX();\n") )
    RET_ONERROR( mywritestr(f, "        boolean limitedY = false;\n") )
    RET_ONERROR( mywritestr(f, "        if (planeSensor.minPosition[1] <= planeSensor.maxPosition[1]) {\n") )
    RET_ONERROR( mywritestr(f, "            if (data.trackpoint[1] - transform.getY() <= planeSensor.minPosition[1]) {\n") )
    RET_ONERROR( mywritestr(f, "                planeSensor.translation_changed[1] = planeSensor.minPosition[1];\n") )
    RET_ONERROR( mywritestr(f, "                limitedY = true;\n") )
    RET_ONERROR( mywritestr(f, "            }\n") )
    RET_ONERROR( mywritestr(f, "            if (data.trackpoint[1] - transform.getY() >= planeSensor.maxPosition[1]) {\n") )
    RET_ONERROR( mywritestr(f, "                planeSensor.translation_changed[1] = planeSensor.maxPosition[1];\n") )
    RET_ONERROR( mywritestr(f, "                limitedY = true;\n") )
    RET_ONERROR( mywritestr(f, "            }\n") )
    RET_ONERROR( mywritestr(f, "        }\n") )
    RET_ONERROR( mywritestr(f, "        if (!limitedY)\n") )
    RET_ONERROR( mywritestr(f, "            planeSensor.translation_changed[1] = data.trackpoint[1] - transform.getY();\n") )
    RET_ONERROR( mywritestr(f, "        planeSensor.translation_changed[2] = 0.0f;\n") )
    RET_ONERROR( mywritestr(f, "        if (!planeSensor.isActive)\n") )
    RET_ONERROR( mywritestr(f, "            planeSensor.isActive = true;\n") )
    RET_ONERROR( mywritestr(f, "        return true;\n") )
    RET_ONERROR( mywritestr(f, "    }\n") )
    RET_ONERROR( mywritestr(f, "}\n") )
    RET_ONERROR( mywritestr(f, "\n") )

    RET_ONERROR( mywritestr(f, "class MyCylinderSensorDoWithDataCallback extends ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "CylinderSensorDoWithDataCallback {\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "    public void doWithData(") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "Node node) {\n") )
    RET_ONERROR( mywritestr(f, "        ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Util.registerCylinderSensorNode(node);\n") )
    RET_ONERROR( mywritestr(f, "        node.m_data = new ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Data();\n") )
    RET_ONERROR( mywritestr(f, "    }\n") )
    RET_ONERROR( mywritestr(f, "}\n") )
    RET_ONERROR( mywritestr(f, "\n") )

    RET_ONERROR( mywritestr(f, "class MyCylinderSensorProcessEventCallback extends ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "CylinderSensorProcessEventCallback {\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "    public boolean processEvent(") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "Node node, String event) {\n") )
    RET_ONERROR( mywritestr(f, "        ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "CylinderSensor cylinderSensor = (") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "CylinderSensor)node;\n") )
    RET_ONERROR( mywritestr(f, "        if (!cylinderSensor.enabled)\n") )
    RET_ONERROR( mywritestr(f, "            if (cylinderSensor.isActive) {\n") )
    RET_ONERROR( mywritestr(f, "                cylinderSensor.isActive = false;\n") )
    RET_ONERROR( mywritestr(f, "                return true;\n") )
    RET_ONERROR( mywritestr(f, "            } else \n") )
    RET_ONERROR( mywritestr(f, "                return false;\n") )
    RET_ONERROR( mywritestr(f, "        ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Data data = (") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Data)node.m_data;\n") )
    RET_ONERROR( mywritestr(f, "        if ((!") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Util.cylinderSensorAutoOffsetWarning) && (!cylinderSensor.autoOffset)) {\n") )
    RET_ONERROR( mywritestr(f, "            ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Util.logger.warning(\"Sorry, only autoOffset == true is supported (yet)\\n\");\n") )
    RET_ONERROR( mywritestr(f, "            ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Util.cylinderSensorAutoOffsetWarning = true;\n") )
    RET_ONERROR( mywritestr(f, "        }\n") )
    RET_ONERROR( mywritestr(f, "        if (") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Util.hitCylinderSensor != cylinderSensor)\n") )
    RET_ONERROR( mywritestr(f, "            if (cylinderSensor.isActive) {\n") )
    RET_ONERROR( mywritestr(f, "                cylinderSensor.isActive = false;\n") )
    RET_ONERROR( mywritestr(f, "                return true;\n") )
    RET_ONERROR( mywritestr(f, "            } else \n") )
    RET_ONERROR( mywritestr(f, "                return false;\n") )
    RET_ONERROR( mywritestr(f, "        ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "Node parentPathNode = node;\n") )
    RET_ONERROR( mywritestr(f, "        Vector3f tempStore = new Vector3f();\n") )
    RET_ONERROR( mywritestr(f, "        TransformMatrix parentTransform = new TransformMatrix();\n") )
    RET_ONERROR( mywritestr(f, "        while (parentPathNode.m_parent != null) {\n") )
    RET_ONERROR( mywritestr(f, "             parentPathNode = parentPathNode.m_parent;\n") )
    RET_ONERROR( mywritestr(f, "             ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Data parentData = (") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Data)parentPathNode.m_data;\n") )
    RET_ONERROR( mywritestr(f, "             if ((parentData != null) && (parentData.callback != null)) {\n") )
    RET_ONERROR( mywritestr(f, "                 Object object = parentData.callback.getNullOrObject(parentPathNode);\n") )
    RET_ONERROR( mywritestr(f, "                 if (object != null)\n") )
    RET_ONERROR( mywritestr(f, "                     parentTransform.multLocal((TransformMatrix)object, tempStore);\n") )
    RET_ONERROR( mywritestr(f, "             }\n") )
    RET_ONERROR( mywritestr(f, "        }\n") )
    RET_ONERROR( mywritestr(f, "        Vector3f transform = new Vector3f();\n") )
    RET_ONERROR( mywritestr(f, "        parentTransform.getTranslation(transform);\n") )
    RET_ONERROR( mywritestr(f, "        cylinderSensor.trackPoint_changed[0] = data.trackpoint[0] - transform.getX();\n") )
    RET_ONERROR( mywritestr(f, "        cylinderSensor.trackPoint_changed[1] = data.trackpoint[1] - transform.getY();\n") )
    RET_ONERROR( mywritestr(f, "        cylinderSensor.trackPoint_changed[2] = data.trackpoint[2] - transform.getZ();\n") )
    RET_ONERROR( mywritestr(f, "        // from openvrml-0.18.8/src/node/vrml97/cylinder_sensor.cpp\n") )
    RET_ONERROR( mywritestr(f, "        Vector3f bearing = new Vector3f(transform.x, transform.y, transform.z);\n") )
    RET_ONERROR( mywritestr(f, "        bearing.normalize();\n") )
    RET_ONERROR( mywritestr(f, "        Vector3f up = new Vector3f(0, 1, 0);\n") )
    RET_ONERROR( mywritestr(f, "        double angle = Math.acos(bearing.dot(up));\n") )
    RET_ONERROR( mywritestr(f, "        if ((new Float(angle)).isNaN())\n") )
    RET_ONERROR( mywritestr(f, "            angle = 0;\n") )
    RET_ONERROR( mywritestr(f, "        if (angle > Math.PI / 2)\n") )
    RET_ONERROR( mywritestr(f, "            angle = Math.PI - angle;\n") )
    RET_ONERROR( mywritestr(f, "        boolean disk = (angle < cylinderSensor.diskAngle);\n") )
    RET_ONERROR( mywritestr(f, "        Vector3f dir1 = new Vector3f(data.trackpoint[0], 0, data.trackpoint[2]);\n") )
    RET_ONERROR( mywritestr(f, "        dir1.normalize();\n") )
    RET_ONERROR( mywritestr(f, "        float radius = disk ? 1 : dir1.length();\n") )
    RET_ONERROR( mywritestr(f, "        Vector3f dir2 = new Vector3f(transform.x, 0, transform.z);\n") )
    RET_ONERROR( mywritestr(f, "        dir2.normalize();\n") )
    RET_ONERROR( mywritestr(f, "        Vector3f cx = new Vector3f();\n") )
    RET_ONERROR( mywritestr(f, "        cx.cross(dir1, dir2);\n") )
    RET_ONERROR( mywritestr(f, "        cx.normalize();\n") )
    RET_ONERROR( mywritestr(f, "        double rot = radius * Math.acos(dir2.dot(dir1));\n") )
    RET_ONERROR( mywritestr(f, "        if ((new Float(rot)).isNaN())\n") )
    RET_ONERROR( mywritestr(f, "            rot = 0;\n") )
    RET_ONERROR( mywritestr(f, "        float epsilon = Float.MIN_VALUE * 2 * 2;\n") )
    RET_ONERROR( mywritestr(f, "        if ((cx.y > -1.0 - epsilon) && (cx.y < -1.0 + epsilon))\n") )
    RET_ONERROR( mywritestr(f, "            rot = -rot;\n") )
    RET_ONERROR( mywritestr(f, "        if (data.trackpoint[0] < 0)\n") )
    RET_ONERROR( mywritestr(f, "            rot = -rot;\n") )
    RET_ONERROR( mywritestr(f, "        if (cylinderSensor.maxAngle >= cylinderSensor.minAngle) {\n") )
    RET_ONERROR( mywritestr(f, "            if (rot >= cylinderSensor.maxAngle)\n") )
    RET_ONERROR( mywritestr(f, "                rot = cylinderSensor.maxAngle;\n") )
    RET_ONERROR( mywritestr(f, "            else if (rot <= cylinderSensor.minAngle)\n") )
    RET_ONERROR( mywritestr(f, "                rot = cylinderSensor.minAngle;\n") )
    RET_ONERROR( mywritestr(f, "        }\n") )
    RET_ONERROR( mywritestr(f, "        cylinderSensor.rotation_changed[0] = 0.0f;\n") )
    RET_ONERROR( mywritestr(f, "        cylinderSensor.rotation_changed[1] = 1.0f;\n") )
    RET_ONERROR( mywritestr(f, "        cylinderSensor.rotation_changed[2] = 0.0f;\n") )
    RET_ONERROR( mywritestr(f, "        cylinderSensor.rotation_changed[3] = (float)rot;\n") )
    RET_ONERROR( mywritestr(f, "        if (!cylinderSensor.isActive)\n") )
    RET_ONERROR( mywritestr(f, "            cylinderSensor.isActive = true;\n") )
    RET_ONERROR( mywritestr(f, "        return true;\n") )
    RET_ONERROR( mywritestr(f, "    }\n") )
    RET_ONERROR( mywritestr(f, "}\n") )
    RET_ONERROR( mywritestr(f, "\n") )

    RET_ONERROR( mywritestr(f, "class MySphereSensorDoWithDataCallback extends ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "SphereSensorDoWithDataCallback {\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "    public void doWithData(") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "Node node) {\n") )
    RET_ONERROR( mywritestr(f, "        ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Util.registerSphereSensorNode(node);\n") )
    RET_ONERROR( mywritestr(f, "        node.m_data = new ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Data();\n") )
    RET_ONERROR( mywritestr(f, "    }\n") )
    RET_ONERROR( mywritestr(f, "}\n") )
    RET_ONERROR( mywritestr(f, "\n") )

    RET_ONERROR( mywritestr(f, "// \"better than nothing\" SphereSensor 8-(\n") )
    RET_ONERROR( mywritestr(f, "class MySphereSensorProcessEventCallback extends ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "SphereSensorProcessEventCallback {\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "    public boolean processEvent(") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "Node node, String event) {\n") )
    RET_ONERROR( mywritestr(f, "        ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "SphereSensor sphereSensor = (") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "SphereSensor)node;\n") )
    RET_ONERROR( mywritestr(f, "        if (!sphereSensor.enabled)\n") )
    RET_ONERROR( mywritestr(f, "            if (sphereSensor.isActive) {\n") )
    RET_ONERROR( mywritestr(f, "                sphereSensor.isActive = false;\n") )
    RET_ONERROR( mywritestr(f, "                return true;\n") )
    RET_ONERROR( mywritestr(f, "            } else\n") )
    RET_ONERROR( mywritestr(f, "                return false;\n") )
    RET_ONERROR( mywritestr(f, "        ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Data data = (") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Data)node.m_data;\n") )
    RET_ONERROR( mywritestr(f, "        if ((!") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Util.sphereSensorAutoOffsetWarning) && (!sphereSensor.autoOffset)) {\n") )
    RET_ONERROR( mywritestr(f, "            ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Util.logger.warning(\"Sorry, only autoOffset == true is supported (yet)\\n\");\n") )
    RET_ONERROR( mywritestr(f, "            ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Util.sphereSensorAutoOffsetWarning = true;\n") )
    RET_ONERROR( mywritestr(f, "        }\n") )
    RET_ONERROR( mywritestr(f, "        if (") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Util.hitSphereSensor != sphereSensor)\n") )
    RET_ONERROR( mywritestr(f, "            if (sphereSensor.isActive) {\n") )
    RET_ONERROR( mywritestr(f, "                sphereSensor.isActive = false;\n") )
    RET_ONERROR( mywritestr(f, "                return true;\n") )
    RET_ONERROR( mywritestr(f, "            } else\n") )
    RET_ONERROR( mywritestr(f, "                return false;\n") )
    RET_ONERROR( mywritestr(f, "        ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "Node parentPathNode = node;\n") )
    RET_ONERROR( mywritestr(f, "        Vector3f tempStore = new Vector3f();\n") )
    RET_ONERROR( mywritestr(f, "        TransformMatrix parentTransform = new TransformMatrix();\n") )
    RET_ONERROR( mywritestr(f, "        while (parentPathNode.m_parent != null) {\n") )
    RET_ONERROR( mywritestr(f, "             parentPathNode = parentPathNode.m_parent;\n") )
    RET_ONERROR( mywritestr(f, "             ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Data parentData = (") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Data)parentPathNode.m_data;\n") )
    RET_ONERROR( mywritestr(f, "             if ((parentData != null) && (parentData.callback != null)) {\n") )
    RET_ONERROR( mywritestr(f, "                 Object object = parentData.callback.getNullOrObject(parentPathNode);\n") )
    RET_ONERROR( mywritestr(f, "                 if (object != null)\n") )
    RET_ONERROR( mywritestr(f, "                     parentTransform.multLocal((TransformMatrix)object, tempStore);\n") )
    RET_ONERROR( mywritestr(f, "             }\n") )
    RET_ONERROR( mywritestr(f, "        }\n") )
    RET_ONERROR( mywritestr(f, "        Vector3f transform = new Vector3f();\n") )
    RET_ONERROR( mywritestr(f, "        parentTransform.getTranslation(transform);\n") )
    RET_ONERROR( mywritestr(f, "        sphereSensor.trackPoint_changed[0] = data.trackpoint[0] - transform.getX();\n") )
    RET_ONERROR( mywritestr(f, "        sphereSensor.trackPoint_changed[1] = data.trackpoint[1] - transform.getY();\n") )
    RET_ONERROR( mywritestr(f, "        sphereSensor.trackPoint_changed[2] = data.trackpoint[2] - transform.getZ();\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "        Vector3f dir1 = new Vector3f(data.trackpoint[0] - transform.x,\n") )
    RET_ONERROR( mywritestr(f, "                                     data.trackpoint[1] - transform.y,\n") )
    RET_ONERROR( mywritestr(f, "                                     data.trackpoint[2] - transform.z);\n") )
    RET_ONERROR( mywritestr(f, "        float dist = dir1.length();\n") )
    RET_ONERROR( mywritestr(f, "        Vector3f dir2 = new Vector3f(data.firstHitTrackpoint[0] - transform.x,\n") )
    RET_ONERROR( mywritestr(f, "                                     data.firstHitTrackpoint[1] - transform.y,\n") )
    RET_ONERROR( mywritestr(f, "                                     data.firstHitTrackpoint[2] - transform.z);\n") )
    RET_ONERROR( mywritestr(f, "        dir2.normalize();\n") )
    RET_ONERROR( mywritestr(f, "        double rot = dist * Math.acos(dir1.dot(dir2));\n") )
    RET_ONERROR( mywritestr(f, "        if ((new Float(rot)).isNaN())\n") )
    RET_ONERROR( mywritestr(f, "            rot = 0;\n") )
    RET_ONERROR( mywritestr(f, "        float epsilon = Float.MIN_VALUE * 2 * 2;\n") )
    RET_ONERROR( mywritestr(f, "        Vector3f dir4 = new Vector3f(dir1.x, dir1.y, dir1.z);\n") )
    RET_ONERROR( mywritestr(f, "        Vector3f dir3 = new Vector3f(dir2.x, dir2.y, dir2.z);\n") )
    RET_ONERROR( mywritestr(f, "        Vector3f cx = new Vector3f(dir3.y * dir4.z - dir3.z * dir4.y, dir3.z * dir4.x - dir3.x * dir4.z, dir3.x * dir4.y - dir3.y * dir4.x);\n") )
    RET_ONERROR( mywritestr(f, "        if (cx.length() < epsilon) {\n") )
    RET_ONERROR( mywritestr(f, "            dir3.z = dir3.z - 2;\n") )
    RET_ONERROR( mywritestr(f, "            dir4.z = dir4.z - 2;\n") )
    RET_ONERROR( mywritestr(f, "            cx = new Vector3f(dir3.y * dir4.z - dir3.z * dir4.y, dir3.z * dir4.x - dir3.x * dir4.z, dir3.x * dir4.y - dir3.y * dir4.x);\n") )
    RET_ONERROR( mywritestr(f, "        }\n") )
    RET_ONERROR( mywritestr(f, "        if (cx.length() < epsilon)\n") )
    RET_ONERROR( mywritestr(f, "            return false;\n") )
    RET_ONERROR( mywritestr(f, "        cx.normalize();\n") )
    RET_ONERROR( mywritestr(f, "        sphereSensor.rotation_changed[0] = cx.x;\n") )
    RET_ONERROR( mywritestr(f, "        sphereSensor.rotation_changed[1] = cx.y;\n") )
    RET_ONERROR( mywritestr(f, "        sphereSensor.rotation_changed[2] = cx.z;\n") )
    RET_ONERROR( mywritestr(f, "        sphereSensor.rotation_changed[3] = (float)rot;\n") )
    RET_ONERROR( mywritestr(f, "        if (!sphereSensor.isActive)\n") )
    RET_ONERROR( mywritestr(f, "            sphereSensor.isActive = true;\n") )
    RET_ONERROR( mywritestr(f, "        return true;\n") )
    RET_ONERROR( mywritestr(f, "    }\n") )
    RET_ONERROR( mywritestr(f, "}\n") )
    RET_ONERROR( mywritestr(f, "\n") )

    RET_ONERROR( mywritestr(f, "class MyProximitySensorDoWithDataCallback extends ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "ProximitySensorDoWithDataCallback {\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "    public void doWithData(") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "Node node) {\n") )
    RET_ONERROR( mywritestr(f, "        node.m_data = new ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Data();\n") )
    RET_ONERROR( mywritestr(f, "    }\n") )
    RET_ONERROR( mywritestr(f, "}\n") )
    RET_ONERROR( mywritestr(f, "\n") )

    RET_ONERROR( mywritestr(f, "class MyProximitySensorProcessEventCallback extends ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "ProximitySensorProcessEventCallback {\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "    public boolean processEvent(") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "Node node, String event) {\n") )
    RET_ONERROR( mywritestr(f, "        ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "ProximitySensor proximitySensor = (") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "ProximitySensor)node;\n") )
    RET_ONERROR( mywritestr(f, "        if (!proximitySensor.enabled)\n") )
    RET_ONERROR( mywritestr(f, "            return false;\n") )
    RET_ONERROR( mywritestr(f, "        ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Data data = (") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Data)node.m_data;\n") )
    RET_ONERROR( mywritestr(f, "        ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "Node parentPathNode = node;\n") )
    RET_ONERROR( mywritestr(f, "        Vector3f tempStore = new Vector3f();\n") )
    RET_ONERROR( mywritestr(f, "        TransformMatrix parentTransform = new TransformMatrix();\n") )
    RET_ONERROR( mywritestr(f, "        while (parentPathNode.m_parent != null) {\n") )
    RET_ONERROR( mywritestr(f, "             parentPathNode = parentPathNode.m_parent;\n") )
    RET_ONERROR( mywritestr(f, "             ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Data parentData = (") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Data)parentPathNode.m_data;\n") )
    RET_ONERROR( mywritestr(f, "             if ((parentData != null) && (parentData.callback != null)) {\n") )
    RET_ONERROR( mywritestr(f, "                 Object object = parentData.callback.getNullOrObject(parentPathNode);\n") )
    RET_ONERROR( mywritestr(f, "                 if (object != null)\n") )
    RET_ONERROR( mywritestr(f, "                     parentTransform.multLocal((TransformMatrix)object, tempStore);\n") )
    RET_ONERROR( mywritestr(f, "             }\n") )
    RET_ONERROR( mywritestr(f, "        }\n") )
    RET_ONERROR( mywritestr(f, "        CellTransform cellTransform = ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Util.viewCell.getWorldTransform();\n") )
    RET_ONERROR( mywritestr(f, "        Vector3f cellTranslation = ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Util.positionComponentServerState.getTranslation();\n") )
    RET_ONERROR( mywritestr(f, "        Quaternion cellRotation = ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Util.positionComponentServerState.getRotation();\n") )
    RET_ONERROR( mywritestr(f, "        Vector3f cellScale = ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Util.positionComponentServerState.getScaling();\n") )
    RET_ONERROR( mywritestr(f, "        TransformMatrix cellMatrix = new TransformMatrix(cellRotation, cellTranslation);\n") )
    RET_ONERROR( mywritestr(f, "        TransformMatrix multMatrix = new TransformMatrix();\n") )
    RET_ONERROR( mywritestr(f, "        multMatrix.setScale(cellScale);\n") )
    RET_ONERROR( mywritestr(f, "        cellMatrix.multLocal(multMatrix, tempStore);\n") )
    RET_ONERROR( mywritestr(f, "        Quaternion avatarOrientationWorld = new Quaternion();\n") )
    RET_ONERROR( mywritestr(f, "        cellTransform.getRotation(avatarOrientationWorld);\n") )
    RET_ONERROR( mywritestr(f, "        avatarOrientationWorld = avatarOrientationWorld.oppositeLocal();\n") )
    RET_ONERROR( mywritestr(f, "        Vector3f avatarPositionWorld = new Vector3f();\n") )
    RET_ONERROR( mywritestr(f, "        cellTransform.getTranslation(avatarPositionWorld);\n") )
    RET_ONERROR( mywritestr(f, "        TransformMatrix avatarMatrix = new TransformMatrix(avatarOrientationWorld, avatarPositionWorld);\n") )
    RET_ONERROR( mywritestr(f, "        avatarMatrix.inverse();\n") )
    RET_ONERROR( mywritestr(f, "        avatarMatrix.multLocal(cellMatrix, tempStore);\n") )
    RET_ONERROR( mywritestr(f, "        avatarMatrix.inverse();\n") )
    RET_ONERROR( mywritestr(f, "        TransformMatrix resultMatrix = avatarMatrix;\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "        Vector3f position = resultMatrix.getTranslation(null);\n") )
    RET_ONERROR( mywritestr(f, "\n") )

    RET_ONERROR( mywritestr(f, "        Vector3f min = new Vector3f(proximitySensor.center[0] - proximitySensor.size[0] / 2,\n") )
    RET_ONERROR( mywritestr(f, "                                    proximitySensor.center[1] - proximitySensor.size[1] / 2,\n") )
    RET_ONERROR( mywritestr(f, "                                    proximitySensor.center[2] - proximitySensor.size[2] / 2);\n") )
    RET_ONERROR( mywritestr(f, "        Vector3f max = new Vector3f(proximitySensor.center[0] + proximitySensor.size[0] / 2,\n") )
    RET_ONERROR( mywritestr(f, "                                    proximitySensor.center[1] + proximitySensor.size[1] / 2,\n") )
    RET_ONERROR( mywritestr(f, "                                    proximitySensor.center[2] + proximitySensor.size[2] / 2);\n") )
    RET_ONERROR( mywritestr(f, "        min = parentTransform.multPoint(min);\n") )
    RET_ONERROR( mywritestr(f, "        max = parentTransform.multPoint(max);\n") )

    RET_ONERROR( mywritestr(f, "        boolean isInside = true;\n") )
    RET_ONERROR( mywritestr(f, "        if (position.x < min.x)\n") )
    RET_ONERROR( mywritestr(f, "            isInside = false;\n") )
    RET_ONERROR( mywritestr(f, "        if (position.x > max.x)\n") )
    RET_ONERROR( mywritestr(f, "            isInside = false;\n") )
    RET_ONERROR( mywritestr(f, "        if (position.y < min.y)\n") )
    RET_ONERROR( mywritestr(f, "            isInside = false;\n") )
    RET_ONERROR( mywritestr(f, "        if (position.y > max.y)\n") )
    RET_ONERROR( mywritestr(f, "            isInside = false;\n") )
    RET_ONERROR( mywritestr(f, "        if (position.z < min.z)\n") )
    RET_ONERROR( mywritestr(f, "            isInside = false;\n") )
    RET_ONERROR( mywritestr(f, "        if (position.z > max.z)\n") )
    RET_ONERROR( mywritestr(f, "            isInside = false;\n") )
    RET_ONERROR( mywritestr(f, "        if (!isInside) {\n") )
    RET_ONERROR( mywritestr(f, "            if (data.isInsideProximity) {\n") )
    RET_ONERROR( mywritestr(f, "                data.isInsideProximity = false;\n") )
    RET_ONERROR( mywritestr(f, "                proximitySensor.exitTime = System.currentTimeMillis() / 1000.0;\n") )
    RET_ONERROR( mywritestr(f, "                proximitySensor.isActive = false;\n") )
    RET_ONERROR( mywritestr(f, "                return true;\n") )
    RET_ONERROR( mywritestr(f, "            } else\n") )
    RET_ONERROR( mywritestr(f, "                return false;\n") )
    RET_ONERROR( mywritestr(f, "        }\n") )
    RET_ONERROR( mywritestr(f, "        if (isInside && !data.isInsideProximity) {\n") )
    RET_ONERROR( mywritestr(f, "            data.isInsideProximity = true;\n") )
    RET_ONERROR( mywritestr(f, "            proximitySensor.enterTime = System.currentTimeMillis() / 1000.0;\n") )
    RET_ONERROR( mywritestr(f, "            proximitySensor.isActive = true;\n") )
    RET_ONERROR( mywritestr(f, "        }\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "        parentTransform.inverse();\n") )
    RET_ONERROR( mywritestr(f, "        resultMatrix = parentTransform;\n") )
    RET_ONERROR( mywritestr(f, "        resultMatrix.multLocal(avatarMatrix, tempStore);\n") )
    RET_ONERROR( mywritestr(f, "\n") ) 
    RET_ONERROR( mywritestr(f, "        position = resultMatrix.getTranslation(null);\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "        proximitySensor.position_changed[0] = position.x;\n") )
    RET_ONERROR( mywritestr(f, "        proximitySensor.position_changed[1] = position.y;\n") )
    RET_ONERROR( mywritestr(f, "        proximitySensor.position_changed[2] = position.z;\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "        Quaternion orientation = new Quaternion();\n") )
    RET_ONERROR( mywritestr(f, "        resultMatrix.getRotation(orientation);\n") )
    RET_ONERROR( mywritestr(f, "        Vector3f axis = new Vector3f();\n") )
    RET_ONERROR( mywritestr(f, "        float angle = orientation.toAngleAxis(axis);\n") )
    RET_ONERROR( mywritestr(f, "        axis.normalize();\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "        proximitySensor.orientation_changed[0] = axis.x;\n") )
    RET_ONERROR( mywritestr(f, "        proximitySensor.orientation_changed[1] = axis.y;\n") )
    RET_ONERROR( mywritestr(f, "        proximitySensor.orientation_changed[2] = axis.z;\n") )
    RET_ONERROR( mywritestr(f, "        proximitySensor.orientation_changed[3] = angle;\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "        return true;\n") )
    RET_ONERROR( mywritestr(f, "    }\n") )
    RET_ONERROR( mywritestr(f, "}\n") )
    RET_ONERROR( mywritestr(f, "\n") )

    RET_ONERROR( mywritestr(f, "class MyTimeSensorDoWithDataCallback extends ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "TimeSensorDoWithDataCallback {\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "    public void doWithData(") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "Node node) {\n") )
    RET_ONERROR( mywritestr(f, "        ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "TimeSensor timeSensor = (") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "TimeSensor)node;\n") )
    RET_ONERROR( mywritestr(f, "        node.m_data = new ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Data();\n") )
    RET_ONERROR( mywritestr(f, "        timeSensor.isActive = false;\n") )
    RET_ONERROR( mywritestr(f, "    }\n") )
    RET_ONERROR( mywritestr(f, "}\n") )
    RET_ONERROR( mywritestr(f, "\n") )

    RET_ONERROR( mywritestr(f, "class MyTimeSensorProcessEventCallback extends ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "TimeSensorProcessEventCallback {\n") )
    RET_ONERROR( mywritestr(f, "    public boolean processEvent(") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "Node node, String event) {\n") )
    RET_ONERROR( mywritestr(f, "        ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "TimeSensor timeSensor = (") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "TimeSensor)node;\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "        ") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Data data = (") )
    RET_ONERROR( mywritestr(f, prefix) )
    RET_ONERROR( mywritestr(f, "_Data)node.m_data;\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "        if (!timeSensor.enabled)\n") )
    RET_ONERROR( mywritestr(f, "            return false;\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "        double currentTime = System.currentTimeMillis() / 1000.0;\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "        if (timeSensor.isActive) {\n") )
    RET_ONERROR( mywritestr(f, "            timeSensor.time = currentTime;\n") )
    RET_ONERROR( mywritestr(f, "        } else {\n") )
    RET_ONERROR( mywritestr(f, "            if (timeSensor.startTime > data.stopTime)\n") )
    RET_ONERROR( mywritestr(f, "                data.startTime = timeSensor.startTime;\n") )
    RET_ONERROR( mywritestr(f, "        }\n") )
    RET_ONERROR( mywritestr(f, "        if (timeSensor.stopTime > data.stopTime)\n") )
    RET_ONERROR( mywritestr(f, "            data.stopTime = timeSensor.stopTime;\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "        if (!timeSensor.loop) {\n") )
    RET_ONERROR( mywritestr(f, "            if (data.stopTime > data.startTime) {\n") )
    RET_ONERROR( mywritestr(f, "                if (timeSensor.isActive) {\n") )
    RET_ONERROR( mywritestr(f, "                    data.stopTime = currentTime;\n") )
    RET_ONERROR( mywritestr(f, "                    timeSensor.isActive = false;\n") )
    RET_ONERROR( mywritestr(f, "                    return true;\n") )
    RET_ONERROR( mywritestr(f, "                }\n") )
    RET_ONERROR( mywritestr(f, "                return false;\n") )
    RET_ONERROR( mywritestr(f, "            }\n") )
    RET_ONERROR( mywritestr(f, "            if (currentTime > data.startTime + timeSensor.cycleInterval) {\n") )
    RET_ONERROR( mywritestr(f, "                timeSensor.fraction_changed = 1.0f;\n") )
    RET_ONERROR( mywritestr(f, "                if (timeSensor.isActive) {\n") )
    RET_ONERROR( mywritestr(f, "                    data.stopTime = currentTime;\n") )
    RET_ONERROR( mywritestr(f, "                    timeSensor.isActive = false;\n") )
    RET_ONERROR( mywritestr(f, "                    return true;\n") )
    RET_ONERROR( mywritestr(f, "                }\n") )
    RET_ONERROR( mywritestr(f, "                return false;\n") )
    RET_ONERROR( mywritestr(f, "            }\n") )
    RET_ONERROR( mywritestr(f, "            if (currentTime < timeSensor.startTime)\n") )
    RET_ONERROR( mywritestr(f, "                return false;\n") )
    RET_ONERROR( mywritestr(f, "        }\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "        timeSensor.isActive = true;\n") )
    RET_ONERROR( mywritestr(f, "\n") )
    RET_ONERROR( mywritestr(f, "        double callTime = currentTime - data.startTime;\n") )
    RET_ONERROR( mywritestr(f, "        timeSensor.fraction_changed = (float)((callTime%\n") )
    RET_ONERROR( mywritestr(f, "                                               timeSensor.cycleInterval) /\n") )
    RET_ONERROR( mywritestr(f, "                                              timeSensor.cycleInterval);\n") )
    RET_ONERROR( mywritestr(f, "        return true;\n") )
    RET_ONERROR( mywritestr(f, "    }\n") )
    RET_ONERROR( mywritestr(f, "}\n") )

    return 0;
}

