/*
 * NodePlaneSensor.h
 *
 * Copyright (C) 1999 Stephen F. White
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program (see the file "COPYING" for details); if 
 * not, write to the Free Software Foundation, Inc., 675 Mass Ave, 
 * Cambridge, MA 02139, USA.
 */

#pragma once

#include "Node.h"
#include "ProtoMacros.h"
#include "Proto.h"
#include "SFMFTypes.h"

class ProtoPlaneSensor : public WonderlandExportProto {
public:
                    ProtoPlaneSensor(Scene *scene);
    virtual Node   *create(Scene *scene);

    virtual int     getType() const { return VRML_PLANE_SENSOR; }
    virtual int     getNodeClass() const { return SENSOR_NODE | CHILD_NODE; }
    virtual int     getProfile(void) const { return PROFILE_INTERACTIVE; }

    virtual bool    isDeclaredInRwd_h() { return true; }      

    virtual bool    isCRouteSource(void) { return true; }

    FieldIndex autoOffset;
    FieldIndex axisRotation;
    FieldIndex description;
    FieldIndex enabled;
    FieldIndex maxPosition;
    FieldIndex minPosition;
    FieldIndex offset;
};

class NodePlaneSensor : public Node {
public:
                    NodePlaneSensor(Scene *scene, Proto *proto);

    virtual int     getX3dVersion(void) const { return 0; } 
    virtual Node   *copy() const { return new NodePlaneSensor(*this); }

    virtual bool    hasX3domOnOutputChange(void) { return true; } 

    fieldMacros(SFBool,     autoOffset,   ProtoPlaneSensor)
    fieldMacros(SFRotation, axisRotation, ProtoPlaneSensor)
    fieldMacros(SFString,   description,  ProtoPlaneSensor)
    fieldMacros(SFBool,     enabled,      ProtoPlaneSensor)
    fieldMacros(SFVec2f,    maxPosition,  ProtoPlaneSensor)
    fieldMacros(SFVec2f,    minPosition,  ProtoPlaneSensor)
    fieldMacros(SFVec3f,    offset,       ProtoPlaneSensor)
};


