#
##
##  This file is part of pyFormex 1.0.5  (Sat Feb 16 10:40:32 CET 2019)
##  pyFormex is a tool for generating, manipulating and transforming 3D
##  geometrical models by sequences of mathematical operations.
##  Home page: http://pyformex.org
##  Project page:  http://savannah.nongnu.org/projects/pyformex/
##  Copyright 2004-2018 (C) Benedict Verhegghe (benedict.verhegghe@ugent.be)
##  Distributed under the GNU General Public License version 3 or later.
##
##  This program is free software: you can redistribute it and/or modify
##  it under the terms of the GNU General Public License as published by
##  the Free Software Foundation, either version 3 of the License, or
##  (at your option) any later version.
##
##  This program is distributed in the hope that it will be useful,
##  but WITHOUT ANY WARRANTY; without even the implied warranty of
##  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
##  GNU General Public License for more details.
##
##  You should have received a copy of the GNU General Public License
##  along with this program.  If not, see http://www.gnu.org/licenses/.
##
"""vtk_light.load

This module loads the vtk modules needed by/useful in pyFormex.
"""

from pyformex import vtk_light

print("Loading VTK_light")

# --------------------------------------
from vtkCommonCore import *
from vtkCommonMath import *
from vtkCommonMisc import *
from vtkCommonSystem import *
from vtkCommonTransforms import *
from vtkCommonDataModel import *
from vtkCommonColor import *
from vtkCommonExecutionModel import *
from vtkFiltersCore import *
from vtkCommonComputationalGeometry import *
from vtkFiltersGeneral import *
from vtkImagingCore import *
from vtkImagingFourier import *
from vtkFiltersStatistics import *
from vtkFiltersExtraction import *
from vtkInfovisCore import *
from vtkFiltersGeometry import *
from vtkFiltersSources import *
from vtkRenderingCore import *
from vtkRenderingFreeType import *
from vtkRenderingContext2D import *
from vtkChartsCore import *
from vtkIOCore import *
from vtkIOGeometry import *
from vtkIOXMLParser import *
from vtkIOXML import *
from vtkDomainsChemistry import *
from vtkIOLegacy import *
from vtkParallelCore import *
from vtkFiltersAMR import *
from vtkFiltersFlowPaths import *
from vtkFiltersGeneric import *
from vtkImagingSources import *
from vtkFiltersHybrid import *
from vtkFiltersHyperTree import *
from vtkImagingGeneral import *
from vtkFiltersImaging import *
from vtkFiltersModeling import *
from vtkFiltersParallel import *
from vtkParallelMPI import *
from vtkFiltersParallelFlowPaths import *
from vtkFiltersParallelGeometry import *
from vtkFiltersParallelImaging import *
from vtkFiltersParallelMPI import *
from vtkFiltersParallelStatistics import *
from vtkFiltersProgrammable import *
from vtkFiltersPython import *
from vtkFiltersReebGraph import *
from vtkFiltersSMP import *
from vtkFiltersSelection import *
from vtkFiltersTexture import *
from vtkFiltersVerdict import *
from vtkInteractionStyle import *
from vtkIOImage import *
from vtkImagingHybrid import *
from vtkRenderingOpenGL import *
from vtkIOSQL import *
from vtkInfovisLayout import *
from vtkRenderingLabel import *
from vtkImagingColor import *
from vtkRenderingAnnotation import *
from vtkRenderingVolume import *
from vtkInteractionWidgets import *
from vtkViewsCore import *
from vtkViewsInfovis import *
#from vtkGeovisCore import *
from vtkIOAMR import *
from vtkIOEnSight import *
from vtkIOExodus import *
#from vtkRenderingContextOpenGL import *
#from vtkRenderingGL2PS import *
from vtkIOExport import *
from vtkIOMovie import *
from vtkIOFFMPEG import *
from vtkIOGDAL import *
from vtkIOGeoJSON import *
from vtkIOImport import *
from vtkIOInfovis import *
from vtkIOLSDyna import *
from vtkIOMINC import *
from vtkIOMPIImage import *
from vtkIONetCDF import *
from vtkIOParallel import *
from vtkIOMPIParallel import *
from vtkIOMySQL import *
from vtkIOODBC import *
from vtkIOPLY import *
from vtkIOParallelExodus import *
from vtkIOParallelLSDyna import *
from vtkIOParallelNetCDF import *
from vtkIOParallelXML import *
from vtkIOPostgreSQL import *
from vtkIOVPIC import *
from vtkIOVideo import *
from vtkIOXdmf2 import *
from vtkImagingMath import *
from vtkImagingMorphological import *
from vtkImagingStatistics import *
from vtkImagingStencil import *
from vtkInfovisBoostGraphAlgorithms import *
from vtkInteractionImage import *
from vtkParallelMPI4Py import *
#from vtkPythonInterpreter import *
#from vtkRenderingExternal import *
#from vtkRenderingImage import *
#from vtkRenderingLIC import *
#from vtkRenderingLOD import *
#from vtkRenderingMatplotlib import *
#from vtkRenderingParallel import *
#from vtkRenderingParallelLIC import *
#from vtkRenderingQt import *
#from vtkRenderingVolumeOpenGL import *
#from vtkRenderingVolumeAMR import *
#from vtkTestingRendering import *
#from vtkViewsContext2D import *
#from vtkViewsGeovis import *
# --------------------------------------

# useful macro for getting type names
__vtkTypeNameDict = {VTK_VOID:"void",
                     VTK_DOUBLE:"double",
                     VTK_FLOAT:"float",
                     VTK_LONG:"long",
                     VTK_UNSIGNED_LONG:"unsigned long",
                     VTK_INT:"int",
                     VTK_UNSIGNED_INT:"unsigned int",
                     VTK_SHORT:"short",
                     VTK_UNSIGNED_SHORT:"unsigned short",
                     VTK_CHAR:"char",
                     VTK_UNSIGNED_CHAR:"unsigned char",
                     VTK_SIGNED_CHAR:"signed char",
                     VTK_LONG_LONG:"long long",
                     VTK_UNSIGNED_LONG_LONG:"unsigned long long",
                     VTK___INT64:"__int64",
                     VTK_UNSIGNED___INT64:"unsigned __int64",
                     VTK_ID_TYPE:"vtkIdType",
                     VTK_BIT:"bit"}

def vtkImageScalarTypeNameMacro(type):
  return __vtkTypeNameDict[type]

# import convenience decorators
#from util.misc import calldata_type

# import the vtkVariant helpers
#from util.vtkVariant import *

#from vtk_light.util.numpy_support import *

# End
