jp2a
====

jp2a is a simple JPEG to ASCII converter.

The source is available at <https://github.com/cslarsen/jp2a>. This project
used to be hosted on SourceForge.

License
-------

Copyright 2006, 2015 Christian Stigen Larsen  
Distributed under the GNU General Public License v2.

You can read the full license in the file COPYING.  jp2a also uses other
libraries.  These licenses can be found in the file LICENSES.

Example: Oswald the lucky rabbit
--------------------------------
                                                                 ......
                                                         .:lOKMMMMMMMMMM0l
                                                    .;dOMMMMMMMMMMMMMMMMMMW.
                                                .ckWMMMMMMMMMMMMMMMMMMMMMMMO
                                             .dXMMMMMMMMMMMMMMMMMMMMMMMMMMO
                                          .xWMMMMMMMMMMMMMMMMMMMMMMMMMMO:.
                                        lXMMMMMMMMMMMMMMMMMMMMMWOOxc'
                    .;lxOOOOOxdl:.    cMMMMMMMMMMMMMMMMWKklc'..
                'llc..   ..:oMMMMMMKxNMMMMMMMMMM0kl:'.
              :0'             cMMMMMMMMMMMMWd'.
            .K:l0              .MMMMMMMMMMl.
           ,K    W              ,MMMMMMMMMMMMN0dl'
           M.    M               MMMMMMMMMMMMMMMMMMKx:.
          cMMK                   WMMMMMMMMMMMMMMMMMMMMMXd'
          NMMM:                  MMMMMMMMMMMXWMMMMMMMMMMMMNd'
          KMMMW                  MMMMMMMMMMM' ;XMMMMMMMMMMMMMWd'
           MMMM                 XMMMMMMMMMMM    dMMMMMMMMMMMMMMMNc
      ''   NMKWl'             .KMMMMMMMMMMM'     :MMMMMMMMMMMMMMMMMd
     KMWMKOk    '           ,lXMMMMMMMMMMM;       .KMMMMMMMMMMMMMMMM0
     KMMMMM.                    .cOMMMMMW'          kMMMMMMMMMMMMMMMMX
      cOXMNXl.            ......   .MWd. .0cc:'      .NMMMMMMMMMMMMMMMk
            .cololoxKWWWXWMMMMMMM:  M   c:. .l0ok      oMMMMMMMMMMMMMMM
                      .'Mo,MMMMNk:lO' :l  .OMMMMl       .OMMMMMMMMMMMMN
                       X0'OkxkxOK;.  :: ,.XMMMMMMO    :O   lXMMMMMMMMk
                        kc,,o0M0.:;c'N  ko;lMMMMMM:'xMMMNWKO,.clxdl:.
                       ;00xkM:d ,   ..     oMMMMMM cMMMMMMMMl
                       c   N0l       .  .l:;;oKMMk  MMMMMMMMM0
                       O   ,.ocOc..l..k'   .:c;'O   0MMMMMMMX.
                      X     N..l  .c           K.   OMMMMMMM
                     .'     c.     :           M .  OMMM0,.;
                    :,   N.;W       ;          O...o .,.
                    d    M  ;X'     :l             :
                    d..':. lcKol,,,,'.:c,,'.cd;'o,'.
                      . ;:,WMMMMMMXx,; M0XXNNWM.
                           MMMMMMMM   .MMMMMMMM
                           MMMMMMMM   .MMMMMMMM.
                          :ONMMMMMM0:':MMMMMMMMM:
                ;c:,'',::lX'  '',''   .MMMMMMMMMMWK:c:
               x.          .lloc;.',lxl..lKMMMMMKl   M
              0           .;,;'......;::c'  ..     ;dl;l'
             ;O:        .d'              .lkk::::;,     'k
             N.'oc'.    M                   :            X
              lo:. ',::xN:                             .x0'
                .,lccccM .ll,.                . ;;:::;c'.0
                       .kl.  .c::lcccccc:cc::;  .''clccl.
                          'lcl:lc::,,'::cc:cc:c,..

The Oswald character is Copyright Walt Disney, and, unfortunately, not in the
public domain.  However, I believe that I can use this picture under the fair
use clause, for demonstrational purposes, especially in low-resolution, ASCII
format. If I am wrong, I will promptly remove it.

Installation
------------

Look in your system's package manager. I don't maintain Windows binaries
anymore.

Building
--------

If you want to compile from source, you need autotools and automake. You may
need to specify the path to jpeglib. I usually just do

    autoreconf -vi
    ./configure --with-jpeg-prefix=/usr/local \
                --with-curl-config=`which curl-config`
    make -j

Before installing, you may want to check that jp2a works by running `src/jp2a`
on some `.jpg` files. The `check` target is currently broken, and won't help
you. When you're ready to install,

    make -j install

jp2a depends on jpeglib. If configure can't automatically find it, specify with

    ./configure --with-jpeg-include=PATH --with-jpeg-lib=PATH

or you can just type the prefix

    ./configure --with-jpeg-prefix=/usr/local/

You can also compile jp2a with libcurl, so it can automatically download images
from the net:

    ./configure --enable-curl

This will look for `curl-config' in $PATH, but you can specify it directly with
--with-curl-config=PATH if you need to.

Windows
-------

You need a working jpeglib for Windows and set up include paths yourself.
You will need to manually type out a `config.h` file. Example:

    WIN32
    NDEBUG
    _CONSOLE
    PACKAGE_STRING=\"jp2a x.x.x-win32\"
    PACKAGE_BUGREPORT=\"csl@csl.name\"
    HAVE_STRING_H
    HAVE_STDLIB_H
    FEAT_CURL
    HAVE_CURL_CURL_H
    CURL_STATICLIB
    FEAT_TERMLIB

You need to add jpeg.lib to the linker. If you want libcurl support, you need
that as well. It should be available from http://curl.haxx.se
