/*                          T U R B . C
 * BRL-CAD
 *
 * This file may be freely distributed without prior notice.
 * This data is in the public domain.
 */
/** @file liboptical/turb.c
 *
 * Noise table for turbulence calculations.
 *
 */

#include "common.h"

#include "vmath.h"


/* TODO: it'd be useful to figure out which random number generator
 * created this table so we could create a substantially bigger one
 * while retaining these 20x20x20 values for backwards-compatibility.
 */
const fastf_t turb_table[20][20][20] = {
    {{ 0.105489192064851520, -0.203732953406870370, -0.001023580785840750, -0.418433680199086670,
       0.019490496721118689, -0.494057352188974620,  0.379220851697027680, -0.381280504632741210,
       0.073469225782901049, -0.087082616984844208, -0.120197215583175420,  0.007280763704329729,
       -0.410010809544473890,  0.172839613631367680,  0.151103318203240630,  0.361020417418330910,
       0.328508053440600630,  0.290775284171104430,  0.019846369512379169,  0.486816851422190670},

     {-0.331657008267939090, -0.248990453314036130,  0.221187937073409560,  0.032173486426472664,
      -0.381944438908249140,  0.371780597139149900, -0.234566528815776110, -0.231887178029865030,
      0.392486185766756530, -0.320674721617251630, -0.161621741019189360, -0.002024622168391943,
      -0.024407675024122000,  0.337354678660631180,  0.079541698098182678,  0.495082822162657980,
      0.343297326471656560, -0.041237450204789639, -0.386197682470083240, -0.083233447745442390},

     { 0.371679932810366150, -0.006394898053258657,  0.424047315958887340,  0.461669123265892270,
       -0.333555284421890970,  0.075150634162127972,  0.322689541149884460,  0.494952769484370950,
       -0.134074081666767600, -0.157464089337736370,  0.481769620906561610,  0.034268910065293312,
       0.093545457348227501,  0.202957558445632460, -0.433557603508234020,  0.211601018439978360,
       0.074738155584782362, -0.168124131858348850,  0.479713840875774620, -0.032775658648461103},

     { 0.011201146524399519, -0.181907900143414740,  0.465199719648808240,  0.486793471965938810,
       -0.344553221482783560,  0.044741417746990919,  0.481876294128596780,  0.498744104988873000,
       -0.496496032457798720, -0.404321388341486450, -0.084489342290908098,  0.375183900818228720,
       0.089283714070916176, -0.160442026332020760,  0.336853024084120990,  0.255728429649025200,
       0.414708608295768500,  0.159542565234005450,  0.250681199133396150, -0.219365473370999100},

     {-0.497921524103730920,  0.232450820505619050,  0.314903437159955500,  0.095623933710157871,
      -0.064591621048748493,  0.381345833651721480, -0.192775047849863770, -0.489853465463966130,
      -0.286778298206627370, -0.213061206974089150, -0.022629123646765947,  0.224422848783433440,
      0.105030893348157410, -0.057429403997957706,  0.211216320749372240,  0.260477671865373850,
      0.487312013749033210,  0.193092614877969030,  0.259221777319908140,  0.490815981291234490},

     { 0.288771226536482570, -0.325267564970999960,  0.365999882109463210, -0.121945059392601250,
       0.014290408696979284,  0.202852906659245490, -0.366216629277914760, -0.071000983007252216,
       -0.137604528106749060,  0.384464569855481390,  0.209633544087409970, -0.135526051744818690,
       0.116915390361100440,  0.024536981247365475,  0.460097881965339180, -0.447676230687648060,
       -0.094117185100913048, -0.232677165884524580, -0.437529695685952900,  0.119104517158120870},

     { 0.054261627607047558,  0.039841180667281151, -0.156472634058445690, -0.340707479044795040,
       0.482411776669323440, -0.445256313309073450,  0.419770192820578810,  0.469723790418356660,
       0.247836301568895580,  0.178991970140486960,  0.460539771709591150,  0.036607528105378151,
       0.353724405169487000,  0.326539654284715650,  0.414662469178438190, -0.131985185667872430,
       0.029392560943961143, -0.451554160099476580,  0.297013831324875350,  0.391788032837212090},

     { 0.432910409756004810,  0.006647375412285328, -0.243738018907606600,  0.049825800582766533,
       -0.468815643340349200, -0.283640136942267420,  0.102149569895118470, -0.062932827975600958,
       -0.016317302361130714,  0.164619874209165570, -0.443828310817480090, -0.462055674754083160,
       -0.295538945123553280, -0.100300944875925780, -0.302763153798878190, -0.313127168454229830,
       -0.045557258184999228, -0.382992960978299380, -0.343403378035873170, -0.297720956616103650},

     { 0.295999009627848860, -0.382863605860620740,  0.238886571489274500,  0.149723414797335860,
       0.443676048424094920,  0.153549040667712690, -0.482261770870536570, -0.026931390631943941,
       0.201994880568236110,  0.314752060920000080, -0.135143357794731860,  0.134905290789902210,
       -0.178600563667714600,  0.121118623763322830, -0.315268908627331260, -0.147416206542402510,
       0.337478486821055410,  0.286880661267787220,  0.289650965481996540, -0.178838815540075300},

     {-0.048499464057385921,  0.345822654664516450, -0.140894490294158460,  0.155961590819060800,
      -0.254478290211409330,  0.056342355906963348,  0.342834422830492260,  0.199964451603591440,
      0.173349395394325260,  0.499431044794619080,  0.402243494987487790, -0.030651594977825880,
      -0.383432561066001650,  0.141130066476762290, -0.380928180180490020, -0.439756512641906740,
      -0.205320892389863730, -0.363189950585365300,  0.033312096726149321,  0.496673988178372380},

     { 0.451562110334634780,  0.398168739397078750,  0.131579278968274590, -0.227038453333079810,
       0.019287363160401583,  0.316310370340943340,  0.125545340124517680, -0.143234150018543000,
       0.103191032074391840, -0.084803694393485785,  0.177927034907042980, -0.445308431982994080,
       -0.238981039728969340, -0.462967455387115480,  0.210653158836066720,  0.006540670059621334,
       0.093374900985509157,  0.053487581666558981, -0.293494878336787220, -0.233275703620165590},

     { 0.052918626926839352, -0.391251383349299430,  0.236072701402008530,  0.169486065860837700,
       0.249878683593124150,  0.355144521221518520,  0.229729553684592250, -0.455442208796739580,
       0.491954570636153220, -0.236958349589258430, -0.458768220618367200,  0.443516680970788000,
       -0.338789610192179680,  0.172811058815568690, -0.283521771896630530,  0.180497752968221900,
       -0.010878570843487978,  0.342023568227887150, -0.462736396584659810, -0.407687538769096140},

     {-0.242780125699937340,  0.215190638322383170, -0.352995970752090220,  0.018238834571093321,
      0.252223182935267690,  0.357657188549637790, -0.475220494903624060, -0.154401916079223160,
      -0.088855229783803225, -0.268715373240411280,  0.112322380300611260,  0.464063397143036130,
      -0.159966756124049430, -0.151604918297380210,  0.133549463469535110, -0.410088072530925270,
      -0.296460396610200410, -0.136720982845872640, -0.365530281327664850, -0.304505825974047180},

     { 0.126320667564868930, -0.324298501946032050, -0.360989144537597890,  0.287531057838350530,
       0.348512556869536640, -0.144510916434228420, -0.031971189193427563, -0.162366013508290050,
       -0.302487348206341270,  0.005292414221912622, -0.070053552277386189, -0.045267473906278610,
       -0.279516947455704210,  0.076950477436184883,  0.472971361130476000,  0.472706235945224760,
       -0.065392334014177322,  0.497750866226851940, -0.181695680133998390,  0.345752436202019450},

     {-0.270964507013559340,  0.430626700632274150,  0.309815833810716870,  0.069068736862391233,
      -0.220978217665106060, -0.056634702719748020,  0.158980664331465960, -0.017438614275306463,
      0.306644314434379340,  0.293450383003801110,  0.178055560216307640, -0.067035018000751734,
      0.469151881523430350,  0.317066415678709750, -0.279503960162401200,  0.317664438392966990,
      -0.327444500755518670,  0.188524851109832530, -0.344701575115323070, -0.129931848961859940},

     {-0.306182734668254850,  0.085244873072952032,  0.324800677597522740, -0.085699681658297777,
      -0.337804649490863080,  0.297772038727998730, -0.112993445713073020,  0.096803016494959593,
      0.295522904954850670,  0.205310874152928590, -0.057444547303020954, -0.475441602058708670,
      0.135937574785202740, -0.247628713492304090,  0.093627135269343853,  0.414959357585757970,
      0.195736583787947890, -0.247392200399190190, -0.102479256689548490,  0.002380898222327232},

     {-0.453941816929727790, -0.424423696473240850,  0.435345880687236790, -0.484789935406297450,
      0.392642719205468890, -0.344158079475164410,  0.332874502986669540, -0.434801781550049780,
      0.344366771634668110,  0.488172928337007760, -0.064733630046248436, -0.461815962567925450,
      0.073417801409959793, -0.239932952448725700, -0.047515644226223230,  0.235613151919096710,
      -0.442160913720726970,  0.339490910060703750, -0.167583831585943700,  0.353361991234123710},

     { 0.044801784213632345,  0.274971621111035350,  0.377920389175415040, -0.319260640535503630,
       -0.472657091915607450, -0.028452475555241108, -0.404301282949745660,  0.223079491872340440,
       0.224155324511229990, -0.006780539639294147, -0.274539609439671040,  0.270213507581502200,
       0.068795764353126287, -0.339193728752434250,  0.285423572175204750, -0.038561516441404819,
       -0.183351808227598670,  0.118298075161874290,  0.026636702474206686, -0.338985036127269270},

     { 0.106471003498882060,  0.461903072427958250, -0.300800998695194720, -0.320111195091158150,
       -0.278029880020767450,  0.151683357078582050,  0.415501956827938560, -0.220190793741494420,
       -0.008825732860714197, -0.252081874758005140, -0.366828802507370710, -0.464023948647081850,
       -0.477110253181308510, -0.488908413331955670, -0.283284589182585480, -0.449767345096915960,
       -0.017360888421535492, -0.187585872132331130,  0.273312146775424480, -0.293205563910305500},

     { 0.305633588694036010,  0.498772537335753440,  0.477007943671196700, -0.125570646952837710,
       -0.340421191416680810,  0.262431515846401450,  0.335867836605757470, -0.023772999178618193,
       -0.119270408991724250, -0.137495460920035840,  0.137241964694112540,  0.487200594972819090,
       -0.175592388492077590,  0.336440965998917820, -0.332910600118339060,  0.046377731487154961,
       -0.011875676922500134, -0.417408642824739220,  0.326186937745660540,  0.479298590216785670}},

    {{-0.169490517582744360,  0.459358135238289830, -0.484725358430296180, -0.146600770764052870,
      0.470449722371995450, -0.268009947147220370, -0.096368115860968828, -0.046911166049540043,
      0.044404180720448494, -0.323055968619883060,  0.159883270040154460, -0.149962230585515500,
      -0.324283431284129620,  0.136891213711351160,  0.224467122461646800, -0.164704622235149150,
      -0.100677270442247390,  0.060334959533065557,  0.311522378586232660,  0.280052320566028360},

     { 0.422839498613029720, -0.051235656719654799,  0.267252915538847450, -0.252752889413386580,
       -0.214794690720736980,  0.434342315886169670,  0.293624842073768380,  0.273329632356762890,
       -0.483066326938569550,  0.119811780285090210,  0.252628222573548560, -0.152556844521313910,
       0.079169915523380041,  0.267902864143252370,  0.200842385180294510,  0.049619637895375490,
       0.499892916996032000, -0.395525730680674310, -0.497291528154164550,  0.044297098182141781},

     {-0.218581699300557370,  0.162591741885989900,  0.394334867596626280, -0.042865130119025707,
      -0.200517044402658940,  0.118801990523934360,  0.292430247645825150,  0.198805685155093670,
      -0.320863049943000080,  0.103952626232057810, -0.021141993813216686, -0.398023551329970360,
      -0.447283030487596990, -0.253889078274369240, -0.150776440743356940, -0.162077721208333970,
      -0.319546762388199570, -0.357151598203927280, -0.388748088851571080, -0.302613089326769110},

     { 0.262660182081162930,  0.363880133721977470,  0.044830066617578268, -0.158169902395457030,
       0.131782997865229850, -0.254327548202127220,  0.391449735965579750,  0.131675915326923130,
       -0.149853278882801530,  0.394158207811415200, -0.324026986490935090,  0.131565022282302380,
       0.056749950163066387, -0.429692118894308810, -0.411300107836723330,  0.356232905760407450,
       0.189109871629625560,  0.381130139809101820,  0.055038591381162405,  0.368246821686625480},

     {-0.014917233958840370, -0.466103402432054280,  0.470223270822316410,  0.037799735553562641,
      -0.219992480706423520, -0.180553169921040530,  0.375722014345228670, -0.039539242628961802,
      -0.037704768124967813,  0.486973925493657590,  0.157847668044269080, -0.275044586043804880,
      0.350854059215635060, -0.297322265338152650,  0.066785512026399374, -0.017362942919135094,
      -0.051649813540279865, -0.041764752008020878, -0.385687027592211960,  0.298496908042579890},

     {-0.147606544196605680, -0.209714014083147050, -0.069938069675117731,  0.409143405966460700,
      -0.139406132511794570,  0.018761822488158941,  0.265376312192529440, -0.450296260882169010,
      -0.100108037702739240, -0.179585096426308160,  0.417950561270117760,  0.384974728338420390,
      -0.145688498858362440,  0.388173832092434170, -0.077225536108016968,  0.134319020435214040,
      -0.292379337828606370, -0.201503521762788300, -0.405220222193747760,  0.169915894512087110},

     {-0.214529596269130710,  0.252627446316182610,  0.394871308468282220, -0.363675537053495650,
      0.455305180978029970, -0.038343179505318403,  0.118961520027369260, -0.096344632096588612,
      0.419892068486660720,  0.233274492900818590, -0.297847724054008720, -0.227714475244283680,
      -0.476439521182328460,  0.132214206270873550, -0.318571069277822970, -0.115845653694123030,
      -0.349023971240967510,  0.446805242914706470, -0.066141914110630751,  0.050867991056293249},

     {-0.232779853511601690, -0.148191352840512990, -0.064157280605286360,  0.121531647630035880,
      -0.260017520748078820,  0.358617183286696670, -0.244149331469088790, -0.052396858576685190,
      -0.342886338476091620, -0.149369553662836550, -0.382480964064598080, -0.057415934745222330,
      -0.396742107346653940, -0.487609655130654570,  0.078908528201282024, -0.441436925902962680,
      -0.025952834635972977, -0.302129951771348710, -0.037781557999551296, -0.106060765683650970},

     { 0.431144541129469870,  0.164370717946439980,  0.166224759072065350,  0.454705020412802700,
       -0.203415075782686470,  0.347653689794242380, -0.161140633281320330, -0.052439047023653984,
       0.294458933174610140,  0.272717452608048920,  0.498428944032639270, -0.438320920336991550,
       -0.375473900232464080, -0.065728336572647095,  0.183210727758705620, -0.135491420980542900,
       -0.207111153285950420,  0.439061396289616820,  0.312111720908433200, -0.049997491762042046},

     {-0.210308157373219730,  0.429630756843835120,  0.392586573492735620, -0.107050264254212380,
      0.442021101713180540, -0.028504898305982351, -0.048487190157175064, -0.083931732457131147,
      0.169365149922668930,  0.413731251843273640,  0.310007501859217880,  0.100509691517800090,
      0.078101969789713621, -0.023767739068716764,  0.055214711930602789,  0.374686894007027150,
      -0.176114049274474380,  0.394074078649282460, -0.177752153016626830, -0.381655116099864240},

     { 0.166791531722992660, -0.179323208983987570, -0.319976035971194510,  0.291317631490528580,
       0.254948454443365340,  0.363234691787511110, -0.344173789024353030, -0.452162698842585090,
       0.302296088077127930,  0.467937931884080170, -0.002160190604627132, -0.408012069296091790,
       0.397568688727915290, -0.109573617111891510, -0.015062333550304174,  0.339589790906757120,
       0.361921484582126140,  0.436450476292520760, -0.244341941550374030,  0.031286634504795074},

     { 0.350181728135794400, -0.434334439691156150, -0.368203673977404830, -0.071716302074491978,
       0.041897821240127087,  0.187011037953197960, -0.197029408067464830,  0.365783771965652700,
       0.081085117068141699,  0.125218438915908340,  0.484128656331449750, -0.252123351208865640,
       0.445895229931920770, -0.335847379639744760, -0.460805719718337060,  0.200843684375286100,
       -0.472612687852233650, -0.304979508742690090,  0.248680985532701020,  0.329683400224894290},

     {-0.337041576858609910, -0.253479205071926120,  0.421671330928802490, -0.439472887665033340,
      0.136947177816182370, -0.093391002155840397,  0.400116903241723780, -0.001131337601691484,
      -0.156940525863319640, -0.344225038308650260, -0.469844702631235120, -0.306758797261863950,
      -0.278559477999806400, -0.338048376608639960,  0.121524900663644080,  0.263338343240320680,
      0.348962661810219290,  0.424495493061840530,  0.129122115205973390, -0.069952221121639013},

     { 0.049713931977748871,  0.113250771537423130,  0.177924427669495340, -0.004390837624669075,
       0.277403391897678380,  0.217118707951158290, -0.303547153249382970,  0.304790704045444730,
       0.412139199674129490,  0.445133832748979330,  0.134474104270339010, -0.424902377184480430,
       -0.308345372322946790,  0.056145435664802790, -0.364375264849513770,  0.328601805958896880,
       0.462754433508962390, -0.464258361607789990, -0.172529531642794610, -0.194186092354357240},

     {-0.308483399916440250, -0.142374234274029730, -0.000944889616221189, -0.087042877916246653,
      0.019577389582991600, -0.379419988486915830, -0.323704534675925970, -0.131459948606789110,
      -0.454924495425075290,  0.305417580995708700,  0.298587830271571870,  0.094789436552673578,
      -0.081331647466868162, -0.023487742058932781, -0.409601401071995500, -0.303928255103528500,
      -0.306369034107774500, -0.213148553855717180, -0.499137551058083770, -0.394229834433645010},

     {-0.268014721106737850,  0.135336553677916530, -0.319132211152464150, -0.076360093429684639,
      -0.308518010657280680, -0.183507476001977920, -0.247758287470787760, -0.345763577148318290,
      -0.147765837144106630,  0.079712181352078915, -0.039949669502675533,  0.043750762939453125,
      0.437337947078049180,  0.459105441346764560,  0.456707885488867760, -0.043084663338959217,
      -0.420314547140151260, -0.366996649187058210,  0.325455388054251670, -0.375239042565226550},

     { 0.438420931808650490,  0.124043218325823550,  0.219550393987447020, -0.142910715192556380,
       -0.399444523733109240,  0.309948993381112810,  0.053161029703915119, -0.205813557375222440,
       -0.403199560474604370,  0.054023478645831347, -0.100043391808867450, -0.171214281581342220,
       -0.310639967676252130,  0.080824397038668394,  0.252425624988973140, -0.119157978333532810,
       0.397316921502351760, -0.495332662016153340,  0.035078444518148899, -0.250448915641754870},

     { 0.084379519335925579,  0.495128775481134650,  0.293301847297698260,  0.021717466413974762,
       0.454234216827899220,  0.250009732786566020,  0.478632803540676830, -0.466080330312252040,
       0.383013084065169100,  0.304088191594928500, -0.341319372877478600,  0.321434015873819590,
       -0.071868589613586664,  0.378231021109968420, -0.321476699318736790,  0.028686886653304100,
       0.188180014491081240,  0.231684330385178330,  0.322873329278081660,  0.284980454016476870},

     {-0.214292190503329040, -0.277170062065124510, -0.386233827564865350, -0.024932158179581165,
      0.303654334973543880,  0.366191797889769080,  0.355909863952547310,  0.200971256475895640,
      0.370859135873615740, -0.109011691529303790,  0.450522340834140780, -0.044761344790458679,
      -0.113882916048169140,  0.243824188597500320,  0.476956121623516080, -0.159648699220269920,
      -0.006166078615933657,  0.455588925164192910, -0.125729029532521960, -0.123152994550764560},

     { 0.259677117224782710,  0.032951597589999437, -0.301718978211283680, -0.312191472388803960,
       -0.088817380834370852, -0.123195677530020480,  0.216495414264500140, -0.400637366343289610,
       -0.391511346679180860,  0.039368744008243084,  0.384343088138848540, -0.105803537182509900,
       0.262198681943118570,  0.498109260573983190,  0.369264304637908940,  0.065853016916662455,
       0.364301058463752270,  0.225174168590456250, -0.233175726141780610,  0.235160194337368010}},

    {{-0.383837522473186250, -0.282653385307639840, -0.309601150453090670,  0.002279561478644609,
      0.461170803289860490, -0.332645028363913300,  0.342630862724035980, -0.044995274860411882,
      -0.377056103199720380, -0.283098166808485980,  0.331851730588823560,  0.382621014025062320,
      0.249853431247174740, -0.469867247622460130, -0.429570458363741640, -0.338963949587196110,
      -0.093062924686819315,  0.286924956366419790, -0.239601315930485730,  0.015425728633999825},

     {-0.173706299625337120, -0.355258227791637180,  0.409622191451489930, -0.411507617682218550,
      -0.357148966751992700,  0.278886496089398860,  0.154345399234443900, -0.492847908288240430,
      0.004060665145516396,  0.421169673092663290,  0.242312286514788870,  0.120223142672330140,
      -0.361483711749315260,  0.432711136061698200, -0.377497295849025250, -0.400312908459454770,
      -0.399933892302215100,  0.465133566875010730,  0.054691816680133343, -0.276989995036274190},

     {-0.317964599467813970, -0.113456452265381810, -0.394368981011211870,  0.431888831779360770,
      -0.083323699887841940, -0.323939438909292220, -0.407075117807835340,  0.323613375425338750,
      0.462985517457127570, -0.146676433738321070, -0.160960895940661430, -0.210720782168209550,
      -0.001934661064296961, -0.251338704489171500, -0.122228399850428100,  0.140916372183710340,
      -0.472452207934111360, -0.467883000615984200,  0.148068463895469900,  0.031608457211405039},

     { 0.453286672942340370, -0.109619249589741230, -0.348168400116264820, -0.408197038806974890,
       -0.176908113062381740, -0.225665695965290070, -0.308509947266429660, -0.076842005364596844,
       -0.260532128624618050,  0.246181869879364970,  0.146167999599128960, -0.078496728092432022,
       -0.367274582386016850,  0.251799019053578380, -0.146607896313071250,  0.049401717726141214,
       0.427859580144286160, -0.053683014120906591, -0.126984906382858750,  0.390845097601413730},

     { 0.299640552140772340,  0.212054197676479820, -0.319875684566795830, -0.202294108923524620,
       0.460715493652969600,  0.057895915582776070,  0.438622263260185720,  0.488263285718858240,
       0.090012914966791868,  0.086690727621316910,  0.019871742930263281,  0.043299587909132242,
       0.477071478031575680,  0.171703342813998460,  0.135102549102157350, -0.199836635030806060,
       0.446037646848708390,  0.326592602301388980,  0.223321360070258380, -0.314494481775909660},

     { 0.072774472180753946, -0.130510640330612660,  0.107008790131658320,  0.205499889794737100,
       -0.378711621277034280,  0.460400893818587060, -0.245098392479121690, -0.450852041132748130,
       -0.093282120302319527,  0.127916701138019560,  0.439993056468665600, -0.293641567695885900,
       -0.160029100719839330, -0.379882628098130230,  0.004064323380589485, -0.199313607066869740,
       0.178013287484645840, -0.057313412893563509, -0.211050321348011490, -0.231973797082901000},

     {-0.470622685272246600,  0.308821421582251790,  0.311325790826231240, -0.493551207240670920,
      -0.019475235603749752, -0.053571659605950117, -0.193387841805815700, -0.073437588755041361,
      -0.226979057304561140, -0.470066481735557320,  0.112067929934710260,  0.345795414876192810,
      -0.100577122066169980, -0.280923279933631420,  0.051295304670929909,  0.020711257122457027,
      -0.320522385649383070,  0.306196912191808220,  0.069859215989708900,  0.086195494048297405},

     {-0.065886386204510927,  0.009852272924035788,  0.292553926352411510,  0.274084513075649740,
      0.129969644825905560, -0.203381749801337720, -0.425229093991220000, -0.192017067223787310,
      0.239304837305098770, -0.136279415339231490,  0.076009135693311691,  0.268682152032852170,
      -0.327457993756979700, -0.112665073480457070,  0.275130944792181250,  0.153066770639270540,
      0.333763266913592820, -0.418256897013634440, -0.420370818115770820, -0.393215790390968320},

     {-0.388323378749191760,  0.191697111818939450,  0.452579624485224490,  0.011099499650299549,
      0.410773832350969310,  0.003874929156154394, -0.468189243227243420, -0.409748553298413750,
      -0.189928158186376090,  0.101669972762465480,  0.176446940749883650,  0.244185455609112980,
      -0.388477754313498740, -0.030999132432043552,  0.018269968684762716,  0.241491890978068110,
      0.265619117766618730,  0.093040874693542719, -0.450525176245719190,  0.004923955071717501},

     { 0.456761459354311230,  0.125483959447592500, -0.226393892895430330, -0.370696534402668480,
       -0.487181114032864570, -0.451262948103249070,  0.282370236236602070,  0.346582153346389530,
       -0.369519844651222230,  0.361999418120831250,  0.453366362955421210, -0.257843223400413990,
       0.053696530405431986,  0.405945987906306980,  0.253256276249885560, -0.035529637243598700,
       -0.090179082937538624,  0.285067033022642140,  0.054721809457987547,  0.219892758876085280},

     {-0.113262993749231100, -0.268831249792128800, -0.035921785514801741, -0.001740748062729836,
      0.200169617775827650,  0.482348183169960980, -0.260248857084661720, -0.034211264457553625,
      0.075389057863503695, -0.210774033330380920,  0.470712690614163880,  0.032150517217814922,
      0.414709926117211580, -0.255681202281266450,  0.161453982815146450,  0.427528812550008300,
      -0.206944149918854240, -0.056175780948251486,  0.274110965896397830, -0.076463994570076466},

     {-0.194176362361758950,  0.227477328851819040,  0.165692782029509540,  0.359520168043673040,
      0.133423316758126020, -0.081050941254943609, -0.176009469199925660, -0.456755765713751320,
      -0.295983908232301470,  0.378712340258061890,  0.263136993162333970,  0.090753098018467426,
      -0.390118909534066920, -0.272784791886806490, -0.410987649578601120,  0.310050708707422020,
      -0.290436608716845510, -0.171236506663262840, -0.224160555750131610,  0.284952449612319470},

     { 0.117989460472017530, -0.253447864670306440, -0.182897033169865610,  0.032699386589229107,
       -0.009129066951572895,  0.478556950110942130, -0.039771800860762596,  0.283926783129572870,
       -0.077618830837309361, -0.265660834964364770, -0.292537211440503600,  0.228204806800931690,
       0.461816494353115560,  0.373155571054667230,  0.087724974844604731,  0.095239811111241579,
       -0.207895370200276370,  0.411715505644679070,  0.138484045397490260, -0.003879278432577848},

     { 0.290427845902740960, -0.098378960974514484, -0.413126179948449130,  0.400308936834335330,
       0.128836247138679030, -0.324113829527050260,  0.210359645541757350,  0.338399638421833520,
       0.004649663809686899,  0.486199089791625740,  0.123352088034152980, -0.377360875718295570,
       -0.267248774878680710,  0.440455055329948660,  0.155338511336594820,  0.223622158635407690,
       0.419012005440890790, -0.384433289524167780,  0.007548941764980555, -0.158606825396418570},

     {-0.150094124022871260,  0.215011730790138240, -0.430402018129825590, -0.188277629669755700,
      0.088167301844805479,  0.157322956714779140,  0.406962181441485880,  0.380271931644529100,
      0.069038462825119495,  0.045446227304637432, -0.123607346788048740, -0.140533691272139550,
      0.447067266330122950, -0.036733526736497879, -0.240224754437804220,  0.075903513468801975,
      0.139152643736451860,  0.470134891103953120, -0.085696848109364510, -0.356197691988199950},

     { 0.456333981361240150, -0.462344759609550240, -0.233558567706495520, -0.310914793517440560,
       0.478110295720398430,  0.421779943630099300,  0.412707365117967130,  0.397122301161289220,
       -0.462653345428407190, -0.079743692651391029, -0.261484524235129360, -0.112747469451278450,
       -0.364731961861252780, -0.191886542364954950,  0.198974900878965850,  0.223435339983552690,
       0.465436414815485480,  0.105937082320451740,  0.103707271628081800,  0.034474877640604973},

     {-0.348616690374910830,  0.480099924840033050,  0.393941186368465420, -0.401549424044787880,
      -0.056633601430803537, -0.346283567603677510,  0.174354089424014090, -0.417480957694351670,
      -0.376148676499724390, -0.411342758219689130, -0.273678649682551620, -0.419814695138484240,
      -0.373687517829239370, -0.007237216923385859, -0.230729488190263510, -0.395577222108840940,
      -0.085457273293286562, -0.318022123072296380, -0.498454920947551730, -0.048110618721693754},

     { 0.102234184276312590, -0.259939445182681080,  0.339141911827027800,  0.237502222415059800,
       0.048174012918025255,  0.038116812705993652, -0.039062437601387501,  0.013610427733510733,
       -0.355946104507893320, -0.435355165973305700, -0.451914694625884290, -0.204562794882804160,
       -0.455255240667611360,  0.442026491742581130, -0.106112218461930750, -0.011888842098414898,
       -0.404257075861096380, -0.431758129037916660,  0.070630200207233429, -0.280405751895159480},

     {-0.343100887257605790,  0.296951550990343090, -0.200220447033643720, -0.216788405086845160,
      -0.210285665933042760,  0.069050064776092768, -0.112365627195686100,  0.204257060773670670,
      0.251027942169457670, -0.110820548143237830, -0.343853557482361790, -0.146737873554229740,
      0.129240007139742370,  0.495288354344666000, -0.409235650673508640, -0.322585979942232370,
      0.033405167516320944,  0.051701911725103855,  0.191024447791278360,  0.177459063008427620},

     { 0.116346746217459440,  0.239109753165394070,  0.472896268125623460,  0.161091505549848080,
       0.181136244907975200, -0.133215950336307290, -0.350797336548566820,  0.276879169512540100,
       -0.064974078908562660,  0.219832863658666610,  0.496473417617380620,  0.091925033833831549,
       0.016784414649009705, -0.203747029416263100,  0.375136629212647680,  0.306498748715966940,
       0.365303035825490950, -0.237228997983038430,  0.010755809955298901,  0.116330977994948630}},

    {{ 0.151950454339385030,  0.166902252472937110,  0.469593104440718890, -0.218809538520872590,
       0.162190606817603110, -0.439642546232789750, -0.041395518463104963, -0.304404225666075940,
       0.112059365957975390, -0.350371070671826600,  0.373054837342351680, -0.271593887824565170,
       0.388738682493567470,  0.345951105933636430,  0.389497617725282910,  0.069874927401542664,
       -0.287264844402670860, -0.461299718823283910, -0.153245903085917230,  0.147761076688766480},

     { 0.258533144835382700, -0.156772485468536620, -0.260313889011740680, -0.224682440049946310,
       0.139480485580861570, -0.385177259799093010, -0.418183691333979370,  0.004783521406352520,
       -0.122406257782131430,  0.092572118621319532, -0.378885500598698850, -0.470455803442746400,
       -0.240525628905743360, -0.409292396157979970, -0.189265341963618990,  0.421664978377521040,
       -0.348934941925108430,  0.269339139573276040, -0.382739247288554910,  0.263124424032866950},

     { 0.418968068901449440,  0.490315590519458060,  0.491530536208301780,  0.307706751395016910,
       0.336266696453094480,  0.381028153933584690, -0.122418320737779140, -0.450998147949576380,
       0.419728435110300780,  0.224335776176303630,  0.196762929204851390,  0.178261579945683480,
       -0.432436708826571700,  0.436449040193110700,  0.453579139895737170,  0.207043776754289870,
       -0.448728219605982300, -0.464604550972580910, -0.288172701839357610, -0.071134477388113737},

     { 0.127967567648738620, -0.167058202438056470, -0.041590280365198851,  0.387441939208656550,
       -0.076350598596036434,  0.269144377671182160,  0.309106917586177590,  0.074714459478855133,
       0.038483517710119486,  0.426367670297622680, -0.162161116488277910, -0.042548413388431072,
       0.416683260817080740, -0.170630580279976130, -0.234841661527752880,  0.252949957270175220,
       -0.289602426346391440,  0.142740017734467980,  0.301951809786260130, -0.369873991236090660},

     {-0.132924206089228390, -0.001285261008888483,  0.308387589175254110, -0.065360914915800095,
      -0.064836220815777779,  0.261966729070991280, -0.358317138161510230, -0.013564440421760082,
      0.297362178098410370, -0.146489840000867840,  0.415301082190126180, -0.074670253787189722,
      0.186451957561075690, -0.126289198175072670, -0.187228314578533170, -0.389898640569299460,
      -0.357144820038229230, -0.378121396992355590,  0.184815818909555670,  0.181338697671890260},

     {-0.451753726694732900, -0.477345297113060950, -0.361209715716540810,  0.464929534588009120,
      -0.147975877393037080, -0.096051377244293690,  0.217879491858184340,  0.062421696726232767,
      -0.453311359509825710,  0.019831301644444466,  0.192547705490142110, -0.086235565133392811,
      -0.481453959364444020,  0.000935294665396214,  0.348403519950807090, -0.046290180180221796,
      -0.237097975797951220,  0.490086382254958150,  0.440145379398018120, -0.439735797699540850},

     {-0.156403457745909690,  0.355446462053805590, -0.014406051486730576, -0.469951499719172720,
      -0.270842736121267080,  0.298365633934736250, -0.359850140288472180, -0.127987556159496310,
      0.420244236942380670,  0.324965678621083500, -0.446648858487606050,  0.468490510713309050,
      0.347620381508022550, -0.307858573738485570,  0.433420045301318170, -0.300355495419353250,
      0.096090049017220736,  0.151299537159502510,  0.262066201306879520,  0.142778689973056320},

     {-0.328869160730391740, -0.045386093202978373, -0.443456875160336490, -0.310323120094835760,
      0.455549201928079130,  0.404946644790470600,  0.143386700190603730, -0.281548773869872090,
      0.395033027045428750,  0.083532079588621855, -0.221284571569412950, -0.261370430234819650,
      -0.061021458357572556,  0.264309377409517770, -0.231321929953992370,  0.168135805986821650,
      0.062675011344254017, -0.091172070242464542, -0.459851750172674660, -0.017080751247704029},

     {-0.266206391621381040, -0.406500608194619420, -0.048590240534394979, -0.418586009647697210,
      -0.214359181933104990, -0.115170195233076810, -0.218941505067050460,  0.381730867084115740,
      -0.463870658073574300, -0.456875303760170940,  0.024509557057172060, -0.292739818803966050,
      -0.002261396963149309,  0.081052681896835566, -0.103062938433140520, -0.046712195035070181,
      -0.014000672847032547, -0.459676238242536780,  0.171739031095057730, -0.118967645801603790},

     { 0.123855841346085070,  0.450454459991306070,  0.119661923963576560, -0.437165616545826200,
       0.214763837400823830,  0.388339994009584190,  0.230970189440995450, -0.222561151254922150,
       -0.202832076232880350,  0.271118439268320800,  0.260358097497373820,  0.030961532611399889,
       0.364617831073701380, -0.288232143037021160,  0.112375522963702680, -0.349741350859403610,
       0.096597661729902029,  0.393434017896652220, -0.468010483309626580,  0.132727004121989010},

     { 0.436558714136481290,  0.056499073747545481,  0.339987185318022970, -0.065702682826668024,
       -0.362448243889957670, -0.263075753115117550,  0.387585122603923080,  0.123551083263009790,
       -0.222751991357654330,  0.059324153698980808, -0.495416562538594010,  0.401103850454092030,
       0.009778613690286875,  0.124245361890643840,  0.463938233908265830, -0.275457548908889290,
       0.012585355900228024,  0.194908423349261280,  0.001981300301849842,  0.309753280133008960},

     {-0.033973137382417917, -0.237660602200776340, -0.159285187255591150, -0.169355305843055250,
      -0.025892744772136211,  0.453090335708111520, -0.019096656702458858, -0.429295083042234180,
      0.346524353604763750,  0.012892859987914562,  0.203431921079754830,  0.283083067741245030,
      -0.430608065798878670,  0.043419106863439083, -0.282619615085422990, -0.293056309688836340,
      0.280343353748321530, -0.395034492481499910,  0.330494773574173450, -0.442408637143671510},

     { 0.164289661683142190,  0.335078211035579440,  0.458695213310420510, -0.325931724626570940,
       -0.040676427073776722,  0.422633447218686340, -0.101389273069798950,  0.471908929292112590,
       0.117541870567947630,  0.400592027232050900,  0.281662209425121550, -0.416431266814470290,
       -0.337068574968725440, -0.377622977830469610, -0.085786572657525539,  0.137038680259138350,
       -0.424532642122358080,  0.395116771105676890,  0.207743597682565450,  0.421991711482405660},

     {-0.091990368906408548, -0.088824481237679720,  0.205074779223650690, -0.022598434705287218,
      0.454594625625759360,  0.422455164138227700,  0.184345255605876450,  0.234937979839742180,
      -0.472579327877610920,  0.014840029180049896,  0.292529342696070670,  0.191710333805531260,
      -0.150081759318709370,  0.251224556006491180,  0.365778609178960320,  0.309241813607513900,
      0.173858003225177530, -0.235610663890838620,  0.281150742899626490, -0.208600126206874850},

     {-0.335018636658787730,  0.062812952324748039, -0.125031393021345140, -0.172087211161851880,
      0.185189974494278430,  0.289182034786790610,  0.464951469097286460,  0.260657332371920350,
      0.184298805892467500,  0.172695066779851910,  0.182649043854326010, -0.407691563013941050,
      -0.416129413992166520, -0.112276176922023300,  0.069710002746433020, -0.461534788366407160,
      -0.189821012318134310, -0.245944741647690530,  0.273403191473335030, -0.162400340195745230},

     { 0.268895287998020650,  0.065932534169405699, -0.470690006390213970, -0.381186471320688720,
       -0.182842909824103120,  0.395088602788746360,  0.428055342286825180,  0.491015093401074410,
       -0.340522060636430980,  0.209206085652112960, -0.217585032805800440, -0.175540697295218710,
       -0.227980962023139000,  0.157383574638515710,  0.152372091542929410,  0.457209012936800720,
       -0.053434390574693680,  0.117323561105877160,  0.217866345308721070, -0.369135584682226180},

     {-0.209981372114270930, -0.099484610371291637, -0.276827147696167230, -0.126110786106437440,
      0.288239212706685070,  0.292882855050265790, -0.087645574007183313, -0.401581799611449240,
      -0.453061886131763460, -0.314242382533848290, -0.063982139807194471,  0.315833401866257190,
      0.251690152101218700, -0.034672146197408438,  0.434646930545568470, -0.431152757722884420,
      -0.139583542943000790,  0.362702272832393650, -0.440137663856148720,  0.019894396420568228},

     { 0.071908358484506607, -0.157722696661949160,  0.344353699125349520,  0.343927396927028890,
       0.499660877976566550, -0.003274208866059780,  0.301136409863829610, -0.053773512598127127,
       -0.385950647760182620,  0.019002755172550678,  0.077090902719646692, -0.095932019874453545,
       0.419518144801259040,  0.300263755489140750,  0.277957194484770300,  0.207757357973605390,
       0.093146610539406538, -0.309688379522413020,  0.306175558362156150,  0.140084724407643080},

     {-0.123930762056261300, -0.257806580979377030, -0.044081873726099730, -0.372240609955042600,
      0.207521272823214530, -0.109434943180531260, -0.303393367212265730, -0.432062270119786260,
      -0.246732669882476330, -0.243531031068414450,  0.087832126300781965,  0.325175688602030280,
      0.098746272269636393, -0.067814174108207226,  0.169103085529059170,  0.098407150711864233,
      0.428911617025732990, -0.029760504607111216, -0.455366361886262890, -0.457039030734449630},

     { 0.489242251031100750,  0.121724541299045090, -0.052971050608903170,  0.408760395832359790,
       -0.078011703211814165, -0.275013856124132870,  0.116517753805965190, -0.484865092672407630,
       -0.084702235646545887, -0.077306687366217375,  0.155219632200896740,  0.291367002762854100,
       0.164886731654405590, -0.388862241525202990,  0.419126392807811500, -0.127591995522379880,
       0.001702815759927034, -0.384266974404454230, -0.059654265176504850,  0.254970145877450700}},

    {{-0.127798005472868680, -0.471822138875722890,  0.080145834479480982,  0.470948267262429000,
      -0.039636312983930111, -0.250751079525798560,  0.069355417974293232, -0.110724695958197120,
      0.219488415867090230,  0.113989056088030340, -0.067763726692646742,  0.208730666898190980,
      -0.264286402612924580,  0.379265223164111380,  0.117491063196212050,  0.157701894175261260,
      -0.395748632960021500, -0.265991182997822760,  0.172836801968514920,  0.019549131859093904},

     { 0.156702129635959860, -0.171943565830588340, -0.189083865378052000, -0.178411138709634540,
       -0.060805807355791330, -0.269957472570240500,  0.193996866233646870,  0.440897008404135700,
       -0.154224446509033440, -0.365657398942857980,  0.195867154281586410,  0.217977548018097880,
       -0.337479537818580870, -0.223987010773271320,  0.188925815280526880,  0.122884149663150310,
       0.025261909700930119, -0.241718766745179890, -0.487840546295046810, -0.255249674431979660},

     { 0.372270289808511730, -0.055604272522032261,  0.453480992931872610, -0.392016112804412840,
       -0.176339049357920890,  0.070972056128084660,  0.265685781836509700, -0.072087682317942381,
       0.304980873130261900, -0.061477416194975376,  0.447461449541151520, -0.038316996768116951,
       0.266579017974436280, -0.241622415836900470,  0.283271864522248510, -0.294226789381355050,
       -0.011579887941479683, -0.022731269244104624, -0.353329780511558060,  0.334195665549486880},

     { 0.111611331813037400,  0.342537373770028350,  0.052173213567584753,  0.274131794460117820,
       -0.381449637003242970, -0.258900970686227080, -0.102984055876731870,  0.143812272697687150,
       -0.000619737431406975, -0.090824602171778679,  0.388562598731368780, -0.128349447622895240,
       0.353571125306189060,  0.342043591663241390, -0.020365559961646795, -0.322767924051731820,
       -0.086984352208673954, -0.254679778125137090,  0.105144394095987080, -0.282003479078412060},

     { 0.183842805679887530,  0.052605843637138605,  0.179679524153470990, -0.049578176345676184,
       0.310983428265899420, -0.037048610858619213,  0.156195034272968770, -0.200596459675580260,
       0.440220119897276160,  0.302865253761410710, -0.366400794126093390,  0.051831452175974846,
       0.145402627997100350,  0.185772419441491370, -0.174036753363907340,  0.263952990993857380,
       0.426871448755264280,  0.222979190759360790, -0.092234735842794180, -0.073748288210481405},

     {-0.367845411412417890, -0.203672137111425400,  0.297902264166623350,  0.485725714359432460,
      -0.361628545448184010, -0.222463295795023440, -0.337042209692299370,  0.051387102343142033,
      0.022856926079839468,  0.268102184403687720,  0.269383623264729980, -0.293300268240273000,
      -0.179291971493512390, -0.050936852116137743,  0.157121555414050820, -0.368308543227612970,
      0.412014537025243040, -0.186683409847319130, -0.068905002903193235,  0.352234656922519210},

     {-0.383818156085908410,  0.064694202970713377, -0.095933890901505947,  0.261584471911191940,
      -0.249533377587795260,  0.230029355734586720,  0.025537463370710611, -0.322661928366869690,
      -0.046991453506052494,  0.433302727527916430,  0.103589783422648910,  0.085163135547190905,
      -0.270369409583508970, -0.098507952410727739,  0.070888849906623363, -0.131997955031692980,
      0.179028752259910110,  0.233846640214324000,  0.419389147311449050, -0.298114321660250430},

     { 0.001948825083673000,  0.188772770576179030, -0.091414589434862137,  0.322656853590160610,
       -0.362164081539958720, -0.434293034020811320,  0.454348310362547640, -0.450149544514715670,
       -0.120976443868130450, -0.114556692540645600,  0.402085112873464820, -0.004794599488377571,
       0.450137510430067780, -0.193848778028041120, -0.243210127577185630, -0.299395867157727480,
       -0.463819421827793120,  0.282327335793524980, -0.122057795524597170, -0.010810875333845615},

     { 0.215630063321441410,  0.481531987898051740, -0.425647739786654710,  0.445260653737932440,
       -0.116975964047014710,  0.145241110119968650, -0.186737301293760540, -0.437947211787104610,
       -0.120912249200046060, -0.267348153982311490, -0.236061533447355030,  0.381036575883626940,
       0.421424617059528830,  0.172523877117782830,  0.203693429473787550, -0.440739464480429890,
       0.238230843562632800,  0.158041739836335180, -0.390889008529484270, -0.382745600305497650},

     {-0.456514952704310420, -0.488803895656019450,  0.112459800206124780,  0.493622557725757360,
      -0.182652673684060570,  0.369249673094600440, -0.305773309431970120, -0.146472095511853690,
      0.151577008888125420,  0.072168895509094000,  0.342717029619961980, -0.132792927324771880,
      0.053700883407145739,  0.417069289833307270, -0.187532273586839440,  0.436724919360131030,
      0.062310400418937206,  0.125730425585061310,  0.498777707573026420,  0.441398151218891140},

     { 0.358382271602749820, -0.237283825408667330,  0.322434727102518080,  0.279806888662278650,
       0.435240051709115510,  0.026128156576305628,  0.339067424647510050,  0.173470895271748300,
       -0.315830103587359190,  0.448178416118025780,  0.290725295431911950, -0.272345056291669610,
       0.459374520462006330, -0.096814904361963272, -0.278722498565912250, -0.223278153222054240,
       -0.227565231267362830, -0.084495807997882366,  0.130249751731753350,  0.424011778086423870},

     { 0.487673087511211630, -0.027033218648284674, -0.208781149238348010,  0.041373971384018660,
       -0.109963928814977410,  0.103686577174812560, -0.021901109255850315,  0.452346471603959800,
       -0.270582997240126130, -0.023123401217162609,  0.393744622822850940, -0.412200725171715020,
       0.239592773374170060,  0.216179349925369020,  0.367606163490563630,  0.174832825083285570,
       -0.257692493498325350,  0.206673588138073680, -0.151696279179304840, -0.073522597085684538},

     { 0.154852004256099460, -0.360970983747392890,  0.154132346622645850,  0.114226524718105790,
       0.042214111890643835,  0.375409848056733610,  0.390948371961712840,  0.314648881088942290,
       -0.209085959475487470,  0.021198123693466187,  0.238660659175366160, -0.221412871964275840,
       0.494164905045181510, -0.470120490062981840,  0.319961099419742820, -0.115799023769795890,
       0.133566087111830710, -0.201940009370446210, -0.163452551700174810,  0.362983090337365870},

     { 0.274936589412391190, -0.269707928877323870,  0.450782365165650840,  0.014529362786561251,
       0.446471421513706450,  0.318388528656214480, -0.310637812130153180, -0.311221071984618900,
       0.025062117259949446,  0.037665908690541983,  0.115256331395357850, -0.320085878483951090,
       0.176694924943149090, -0.230611321981996300,  0.294140646699815990, -0.281090962700545790,
       -0.355201473459601400,  0.185089018661528830, -0.466442081611603500, -0.064287432935088873},

     {-0.293712857645004990,  0.272218577563762660,  0.214299695100635290, -0.299547952599823470,
      0.302098087500780820,  0.034260794986039400,  0.084653023630380630, -0.064335825387388468,
      0.332320785615593190,  0.421200471930205820, -0.201352735050022600,  0.107257375027984380,
      -0.348507456481456760, -0.250570369884371760, -0.378213262185454370, -0.402036034967750310,
      -0.432181840762495990, -0.188851074315607550, -0.213257106952369210,  0.092880276497453451},

     { 0.348814834840595720,  0.401999224442988630,  0.272794398013502360,  0.025509759783744812,
       -0.328612097073346380,  0.066935044713318348,  0.244418797083199020, -0.183813570532947780,
       -0.247975936625152830,  0.277976715471595530,  0.251898996531963350, -0.041688794270157814,
       0.050195293035358191, -0.033801308367401361,  0.158763253130018710, -0.147706619463860990,
       -0.499540513381361960, -0.256583722773939370,  0.287957555614411830,  0.332780272234231230},

     {-0.335383250843733550, -0.413395179435610770, -0.059962352737784386, -0.183890707325190310,
      -0.163965548854321240,  0.061824385076761246, -0.085926742292940617, -0.096147389616817236,
      0.372973311226814990,  0.200816151220351460,  0.496732886880636220,  0.221788146067410710,
      0.102815375663340090,  0.269527284894138570, -0.252702094148844480,  0.274203278589993720,
      -0.163537669926881790,  0.491716703400015830, -0.409610291942954060,  0.088486393447965384},

     { 0.269693418871611360,  0.342288704589009280, -0.453202400356531140, -0.180111287627369170,
       -0.191512603312730790,  0.205560852773487570,  0.172182092908769850, -0.191053116694092750,
       0.448977129999548200, -0.039860351476818323, -0.358272843994200230, -0.386406120378524070,
       0.046744469553232193,  0.081764803268015385, -0.070296827703714371,  0.382778920698910950,
       -0.356410811189562080,  0.343776430469006300, -0.213368468917906280, -0.483437499962747100},

     { 0.044592581689357758, -0.216635582037270070,  0.238350646104663610, -0.352592042647302150,
       -0.447108297143131490,  0.485648551955819130,  0.421611236408352850, -0.110645967070013280,
       0.477365255355834960, -0.487999055534601210,  0.477840426843613390,  0.247058674693107600,
       0.354289649520069360, -0.475361973512917760, -0.433052612934261560, -0.337222953792661430,
       0.230198879260569810,  0.239129479974508290, -0.028276070486754179,  0.179176009725779290},

     {-0.300730871036648750,  0.113451085519045590,  0.292769889347255230,  0.246013598516583440,
      -0.304784110747277740, -0.277526938356459140,  0.128792519215494390, -0.161194921936839820,
      -0.433750507887452840,  0.415424050297588110, -0.144632421899586920,  0.110842073801904920,
      -0.301211531739681960, -0.406281775794923310,  0.258250031620264050, -0.248319828882813450,
      -0.420633223839104180,  0.179861268028616910,  0.141034204512834550, -0.443267968017607930}},

    {{ 0.191862212494015690,  0.118874631356447940,  0.303790706675499680,  0.046151862014085054,
       0.143512657843530180,  0.370738093741238120,  0.208928908221423630, -0.126288462895900010,
       0.109867573715746400, -0.319347161799669270, -0.447112453170120720,  0.309136702679097650,
       0.294103923719376330,  0.345657436177134510,  0.055150301195681095,  0.489319812972098590,
       -0.431869501713663340, -0.316057179588824510, -0.171875108964741230, -0.365620009601116180},

     {-0.400633129291236400,  0.183492469135671850,  0.245222064666450020, -0.201844661030918360,
      0.277210693340748550,  0.003472096286714077,  0.049835510551929474,  0.356577469967305660,
      -0.316666635684669020, -0.309130284935235980,  0.413309501949697730,  0.375195576809346680,
      0.309744346421211960,  0.217100208625197410, -0.078652560710906982, -0.046742995735257864,
      0.087838302366435528, -0.369723652489483360,  0.326968541368842120, -0.302294123917818070},

     {-0.189070814289152620,  0.379856088664382700, -0.493157420773059130, -0.394966890104115010,
      0.225513524841517210,  0.061992880422621965, -0.405647077132016420,  0.293644023127853870,
      0.245935701299458740, -0.077522185631096363,  0.428024013992398980,  0.345302572008222340,
      -0.394029716495424510,  0.173246078658849000, -0.356542088557034730,  0.383180977310985330,
      -0.323281825054436920,  0.193293421994894740,  0.239758447278290990, -0.139948460739105940},

     { 0.384163137059658770,  0.153067949227988720, -0.264752883929759260,  0.193907483480870720,
       -0.129831842146813870,  0.156594555359333750, -0.352835512254387140,  0.458006460219621660,
       0.286870903335511680,  0.474133029114454980, -0.344287663698196410, -0.402199910953640940,
       0.353989117778837680, -0.337445084471255540, -0.297166801057755950,  0.079502643086016178,
       0.224547796417027710, -0.202813877724111080, -0.126853333786129950, -0.029516502283513546},

     { 0.219663936644792560, -0.198829319793730970, -0.184213930275291200,  0.325634220149368050,
       0.474416758865118030, -0.040756018832325935,  0.208815197460353370, -0.348865066189318900,
       -0.347462596837431190, -0.051426355261355639,  0.011186473071575165, -0.463299459777772430,
       -0.398358406033366920,  0.246433589607477190,  0.230608023703098300, -0.028190248180180788,
       -0.096971855033189058,  0.377772511448711160, -0.070183787960559130, -0.310100951697677370},

     { 0.351905541028827430,  0.085528548806905746, -0.212300862185657020,  0.205894658807665110,
       0.248083464335650210, -0.009467663243412971, -0.214602698106318710, -0.027368739247322083,
       0.287718459032475950,  0.158543968573212620,  0.443114758469164370,  0.007382395677268505,
       0.459714648779481650, -0.241099171340465550, -0.166983383707702160,  0.434131408110260960,
       0.218144809827208520, -0.458168186247348790, -0.414733658079057930,  0.370682213455438610},

     {-0.009594541043043137,  0.096452815458178520,  0.407382753677666190,  0.092047052923589945,
      -0.157113594934344290,  0.137990777846425770, -0.436143194790929560,  0.245914550032466650,
      0.015763289295136929, -0.006326982751488686,  0.435813598800450560, -0.132331169676035640,
      -0.420798433944582940, -0.276487263385206460, -0.426436510402709250,  0.327285030856728550,
      0.214045073371380570, -0.141039208509027960, -0.200083708390593530,  0.001763532869517803},

     {-0.482495239935815330, -0.256968949455767870, -0.490854071453213690,  0.477219409309327600,
      0.001931879203766584, -0.157837455160915850,  0.411350817419588570, -0.279923310969024900,
      -0.116005640942603350,  0.496617159340530630, -0.409241097513586280,  0.374399818014353510,
      0.093069974798709154,  0.498141656629741190, -0.033553129062056541,  0.435956379864364860,
      0.136132434476166960,  0.030303676147013903,  0.181870930362492800, -0.348104276228696110},

     {-0.476023306138813500,  0.117684529162943360,  0.019564554560929537, -0.396821740083396430,
      0.341197265777736900,  0.093128044158220291,  0.430463290773332120,  0.055242339149117470,
      0.452088835649192330, -0.269620417151600120, -0.442994127981364730,  0.469593596179038290,
      -0.026589366607367992, -0.433848198968917130,  0.446813005488365890,  0.475342512596398590,
      -0.091685654129832983,  0.358163822907954450, -0.304580798372626300,  0.292308704927563670},

     { 0.354780982248485090, -0.213821895420551300,  0.166708522941917180, -0.052149042487144470,
       -0.215680238790810110, -0.366844605654478070, -0.116192662622779610,  0.420452195685356860,
       0.163459070492535830, -0.434321732260286810, -0.427652080543339250,  0.187435764353722330,
       0.183362796902656560,  0.091912474017590284,  0.290614024735987190,  0.024560062680393457,
       -0.314959481824189420,  0.221077315509319310, -0.420197597704827790, -0.362870645709335800},

     { 0.451456898357719180, -0.363191725686192510, -0.393277049530297520, -0.075132468249648809,
       -0.297039924655109640, -0.446464044041931630, -0.099789955653250217,  0.111274421680718660,
       0.411699778866022830,  0.095629246439784765, -0.096416873391717672,  0.266480761114507910,
       0.381807351019233470, -0.429708349984139200, -0.285668281372636560, -0.333872887771576640,
       -0.296552955638617280,  0.098139056470245123, -0.413420692086219790,  0.366906114853918550},

     { 0.163817324209958310, -0.341072772629559040,  0.054341879673302174, -0.152819878421723840,
       0.250839701853692530, -0.155044095590710640,  0.371740184258669610,  0.435880220029503110,
       -0.433966780081391330,  0.451542586553841830, -0.426990425679832700, -0.482509881258010860,
       -0.411649138666689400, -0.320267475210130210, -0.057642349507659674, -0.208689063321799040,
       -0.266731519252061840,  0.342567695304751400,  0.402585358358919620, -0.355031740386039020},

     {-0.061803058255463839, -0.193831514567136760,  0.411449021194130180, -0.179995707236230370,
      -0.123539864551275970, -0.374219260178506370, -0.013868595007807016,  0.079907179810106754,
      0.223919796291738750,  0.072710712905973196, -0.053186705335974693, -0.112262879032641650,
      0.231637940276414160, -0.498844825662672520,  0.234917242545634510, -0.017522357869893312,
      -0.153888921253383160,  0.106657426804304120, -0.081642137374728918, -0.087855700869113207},

     { 0.058200013823807240, -0.008632563054561615, -0.070365582127124071,  0.146550875157117840,
       0.171099962200969460,  0.371992068365216260,  0.437861811835318800,  0.404368442948907610,
       0.214559763669967650,  0.340447170659899710, -0.450663296971470120, -0.347243294585496190,
       -0.353384343907237050,  0.460785724222660060, -0.027239001821726561,  0.023075791541486979,
       -0.413433535955846310,  0.458892403170466420, -0.397017028648406270,  0.310486260801553730},

     { 0.031603116076439619,  0.049796266015619040, -0.301776618231087920, -0.236758943181484940,
       0.050951440818607807,  0.433140624314546590,  0.245718698948621750,  0.397062519565224650,
       0.039798051118850708, -0.335923438426107170, -0.190793181303888560, -0.402001935057342050,
       0.155443998984992500,  0.238841236568987370,  0.244548940099775790, -0.173456038814038040,
       0.110833305399864910,  0.182410752400755880, -0.269087595865130420, -0.174606930930167440},

     { 0.022857923060655594, -0.219750892836600540, -0.021850225050002337,  0.169473579153418540,
       -0.258965168613940480,  0.450910773128271100, -0.307450629305094480, -0.172398704104125500,
       0.409803176764398810, -0.204467657953500750, -0.361912443302571770, -0.058593707159161568,
       0.345328608062118290, -0.163689061533659700,  0.204647349659353490, -0.103719951119273900,
       -0.230548437219113110, -0.049633950926363468, -0.206657431088387970,  0.309249613899737600},

     { 0.114442610647529360,  0.102549387607723470,  0.407247679308056830, -0.230113390367478130,
       -0.158609375357627870,  0.151796619407832620,  0.096430570818483829,  0.452223930042237040,
       -0.165792628191411500,  0.327342975419014690, -0.222383000887930390,  0.357065294869244100,
       -0.392407917417585850,  0.255766774062067270,  0.026538874022662640, -0.151373085565865040,
       0.206677547655999660,  0.219088244717568160,  0.176228210330009460,  0.116480724420398470},

     {-0.485379413235932590,  0.314315767027437690, -0.442112982738763090,  0.359949195291846990,
      -0.349373294506222010,  0.262534367386251690, -0.243770755827426910, -0.079921731725335121,
      -0.287099583540111780,  0.049571813084185123, -0.270672117825597520,  0.327343027107417580,
      -0.347878798842430110, -0.363424438517540690, -0.402770362794399260, -0.006488174200057983,
      0.288372181355953220,  0.193660208024084570, -0.054264244157820940, -0.377420446835458280},

     { 0.021003183443099260,  0.223352754954248670,  0.479644848499447110,  0.128595266491174700,
       -0.020880470518022776,  0.006183722522109747,  0.477222180925309660, -0.314202922862023120,
       -0.274728032294660810,  0.153450391255319120,  0.302277801558375360, -0.260107445530593400,
       -0.032233841717243195,  0.360164818819612260, -0.400158250238746400,  0.118392863776534800,
       0.122699186205863950, -0.143929005600512030, -0.461528867948800330,  0.335599602665752170},

     { 0.405642807483673100, -0.232200985774397850,  0.162942630238831040, -0.442235991358757020,
       -0.095625423826277256,  0.260172267444431780,  0.051275834441184998, -0.307253242470324040,
       -0.046167524531483650,  0.497011590283364060, -0.184673689305782320,  0.474835659377276900,
       0.220364345703274010, -0.205028840806335210,  0.103430925868451600, -0.300516124814748760,
       0.301154882181435820,  0.080653106793761253, -0.114719047676771880, -0.473573150113224980}},

    {{-0.265896501950919630, -0.312441246118396520, -0.233680595643818380,  0.201869656331837180,
      -0.452276427298784260, -0.133838845416903500, -0.179737479891628030,  0.170422759372740980,
      0.222232148982584480, -0.141266347840428350,  0.006022362038493156,  0.127874956466257570,
      0.126532666385173800, -0.331035007722675800,  0.185638965573161840, -0.469092757441103460,
      0.429137259721755980, -0.263085199985653160, -0.276345999911427500, -0.117030264344066380},

     {-0.266073609236627820,  0.038980311248451471, -0.142194604966789480,  0.454290736466646190,
      0.333951470442116260,  0.461236320901662110, -0.346225388348102570,  0.135106352623552080,
      0.041889427695423365,  0.039055563975125551,  0.161533202510327100,  0.275992925744503740,
      0.226614317856729030,  0.427852607332170010, -0.022137417923659086,  0.274337890557944770,
      -0.205986238084733490,  0.298125102184712890, -0.055239350069314241, -0.483754089102149010},

     {-0.343141245655715470,  0.450783012434840200,  0.144120867364108560,  0.283391420729458330,
      -0.380251995287835600, -0.170240167062729600,  0.314298663754016160, -0.451114735100418330,
      0.066674633417278528, -0.462047336157411340, -0.068144999444484711,  0.300601024180650710,
      0.076932975091040134,  0.289660395588725810,  0.254891760647296910, -0.089115554001182318,
      0.250896716490387920,  0.408666372299194340, -0.454009201377630230, -0.207213855814188720},

     {-0.052278063725680113,  0.207524001598358150, -0.431220930069684980, -0.325663745868951080,
      0.135376608930528160,  0.046641652006655931,  0.448674144688993690,  0.429390370845794680,
      -0.155233245808631180, -0.106565204914659260,  0.445636281743645670,  0.001625508535653353,
      -0.155782192479819060,  0.089757149107754230, -0.214983070734888320, -0.036034187767654657,
      0.419516982510685920, -0.400684406980872150,  0.012851077131927013, -0.013808384072035551},

     {-0.362731742672622200,  0.444706077687442300, -0.213207359891384840,  0.214201232418417930,
      0.234366473276168110, -0.458315599244087930, -0.374914321582764390, -0.014736810233443975,
      0.450350773055106400, -0.328923522494733330,  0.278049333952367310, -0.101927290670573710,
      0.378600479103624820,  0.346828403882682320,  0.072408963460475206,  0.013977088034152985,
      -0.106529944110661750,  0.021083108149468899, -0.056632541120052338,  0.238236810080707070},

     { 0.414517903234809640, -0.110996259376406670, -0.260137681383639570, -0.241264289245009420,
       0.478760889731347560,  0.024879248347133398,  0.222701523452997210,  0.398277872242033480,
       0.124194841366261240, -0.264447399415075780, -0.115530511830002070,  0.261463098693639040,
       -0.319741321261972190,  0.171262128278613090, -0.024335668422281742,  0.414625152014195920,
       0.212946529034525160,  0.100750009994953870, -0.100111657753586770,  0.163297302089631560},

     { 0.271826487500220540, -0.322062323801219460, -0.438629988580942150,  0.150426966603845360,
       -0.475233919452875850,  0.133778974879533050, -0.335595945362001660, -0.081763863563537598,
       -0.345137916505336760,  0.107771513517946000, -0.343527053017169240, -0.430620013270527120,
       0.496775254141539340, -0.103664734400808810, -0.171884302049875260,  0.475536144338548180,
       0.421214513946324590, -0.449182778596878050,  0.373814016580581670,  0.045409355778247118},

     {-0.213630178011953830, -0.241716494783759120, -0.193127545528113840, -0.033371499273926020,
      0.429545633494853970,  0.282536786049604420, -0.118746346794068810,  0.142492162995040420,
      -0.116713203489780430,  0.281141995452344420, -0.194210534915328030, -0.344886715989559890,
      0.459079671651124950, -0.132840523030608890,  0.305540251079946760,  0.483845752198249100,
      -0.499061548151075840,  0.469944305717945100, -0.097918110899627209, -0.344199464656412600},

     { 0.077715819701552391,  0.058554836083203554, -0.274819477461278440,  0.074491073843091726,
       0.454890101682394740,  0.053296220488846302,  0.050027218181639910,  0.376104616094380620,
       0.104113441891968250, -0.076158764772117138, -0.078486028127372265,  0.390483263880014420,
       0.182124740444123740,  0.228386426344513890, -0.142888234928250310,  0.111670373938977720,
       0.010923212859779596,  0.238365418277680870, -0.245837463065981860,  0.394210009369999170},

     { 0.019507413730025291,  0.059952002484351397, -0.450676706619560720, -0.021412914618849754,
       0.427111479453742500,  0.354863544460386040, -0.037567161954939365,  0.428049931302666660,
       0.324807850643992420,  0.364514727145433430, -0.416149532888084650, -0.097476329654455185,
       -0.076930436771363020, -0.190969010349363090,  0.477014744188636540, -0.122040335088968280,
       0.362327210139483210,  0.027041962835937738, -0.245935718994587660, -0.033559347968548536},

     { 0.450883198063820600,  0.175578252878040080, -0.143076084088534120,  0.133007938507944350,
       -0.096035320311784744,  0.214035680983215570, -0.255321687553077940,  0.414887892547994850,
       -0.047598900739103556, -0.001159150153398514,  0.309097901917994020,  0.471908512990921740,
       -0.441207147669047120,  0.358421195298433300, -0.049504401162266731,  0.485904331784695390,
       0.213284740224480630,  0.412928436882793900,  0.413954263087362050,  0.038092590868473053},

     { 0.277443164028227330,  0.497804730199277400,  0.440616261214017870, -0.299487272743135690,
       -0.193164280150085690,  0.417631005402654410,  0.078472392167896032, -0.330837070010602470,
       -0.055327031761407852,  0.332536673638969660,  0.135603582020848990, -0.104443833697587250,
       0.008114926517009735,  0.492527498397976160, -0.471435895189642910,  0.412079606205224990,
       0.206563179381191730, -0.226757582277059560,  0.326967498753219840, -0.341035720892250540},

     { 0.272083267569541930,  0.136065400671213870, -0.369127207901328800,  0.330876119900494810,
       -0.005513403564691544,  0.081368390936404467,  0.316780451685190200, -0.292228663340210910,
       -0.005703172180801630,  0.230734714772552250,  0.245863927528262140, -0.228260008152574300,
       0.228539445437490940,  0.186480188742280010, -0.027747280895709991, -0.464624834712594750,
       0.104111194144934420, -0.449274888262152670, -0.295461904257535930, -0.451215837150812150},

     { 0.383261785376816990,  0.340141677763313060, -0.055659670848399401, -0.108623288106173280,
       0.332669176161289220, -0.027095565572381020, -0.196543681435287000,  0.039232356008142233,
       0.246146852150559430, -0.369576182682067160,  0.198196635115891700,  0.018230119720101357,
       0.266489218454808000,  0.329069427214562890, -0.150893760379403830, -0.239024185109883550,
       -0.089562181383371353, -0.334113308694213630, -0.031252848450094461,  0.404734646435827020},

     { 0.396621406078338620, -0.285388920921832320, -0.323525361251086000,  0.125160851515829560,
       0.401091267820447680,  0.148727357853204010,  0.160536017268896100,  0.005202461965382099,
       0.199452469591051340,  0.365074113011360170,  0.053986624814569950,  0.082714254967868328,
       0.205215790774673220,  0.498326954431831840,  0.474090967327356340,  0.037884967401623726,
       -0.028768611140549183, -0.222452714107930660, -0.422882676590234040, -0.282621758989989760},

     {-0.092028896789997816,  0.275313958525657650,  0.235608360730111600, -0.325539678335189820,
      0.104383385740220550, -0.415285399649292230, -0.064563863445073366, -0.485178795643150810,
      -0.249398708343505860,  0.404183288104832170,  0.419555851258337500, -0.352777302265167240,
      -0.381205632817000150, -0.403969509992748500,  0.272383549716323610, -0.480114364996552470,
      0.244757847860455510, -0.067080433014780283,  0.025088097434490919, -0.055789682082831860},

     {-0.202006320003420110, -0.420925277750939130, -0.473075427114963530, -0.496790529228746890,
      -0.422598323319107290, -0.498984459787607190,  0.041094438172876835,  0.048633065540343523,
      -0.221437173895537850,  0.118211761582642790,  0.266011306550353770,  0.186533929780125620,
      -0.106474279891699550,  0.001619667280465364,  0.360994251444935800,  0.497909106314182280,
      0.086334267631173134, -0.203569611534476280, -0.487269689328968520,  0.336935559287667270},

     /* FIXME: The following array of numbers has only 16 entries!
      * Are the Remaining 4 initialized to zero?  Is that
      * intentional? */
     {-0.299386323429644110,  0.432286161929368970,  0.484158257488161330, -0.180591955780982970,
      -0.471683348063379530,  0.256541807204484940, -0.160706320777535440,  0.273074500262737270,
      0.443456499371677640, -0.255790608935058120, -0.009335475042462349, -0.479141823947429660,
      -0.254775068257004020, -0.468241036403924230,  0.069491242058575153,  0.023787757847458124},

     { 0.149970725178718570, -0.164497451391071080, -0.289678312372416260, -0.456503554247319700,
       0.337122216355055570, -0.428684060461819170, -0.458594447933137420, -0.076543516013771296,
       -0.132253671996295450, -0.445864137262105940, -0.239607956260442730,  0.068360004574060440,
       0.486422025132924320, -0.255449698772281410,  0.387768048793077470, -0.485261322930455210,
       -0.498907891567796470, -0.272938271518796680,  0.287813177332282070, -0.309446517378091810},

     {-0.408556494861841200, -0.494902004487812520,  0.178008536808192730, -0.465099995490163560,
      -0.250692612957209350, -0.331326938234269620, -0.444241818971931930, -0.005467681214213371,
      -0.299567974638193850,  0.125249423086643220, -0.481679923366755250,  0.350402751006186010,
      0.460751971695572140, -0.271358235273510220,  0.393899196758866310,  0.297874188050627710,
      -0.200042295735329390,  0.435304748825728890, -0.278669327497482300,  0.167704032268375160}},

    {{ 0.489440611563622950, -0.018277283757925034, -0.263935963157564400,  0.475862636696547270,
       0.226273017469793560, -0.376167913898825650,  0.490601314231753350,  0.227365125901997090,
       -0.149106185417622330,  0.278414491564035420,  0.417918608523905280, -0.057662680279463530,
       0.283512487541884180,  0.095927145332098007, -0.022762675303965807, -0.467180125415325160,
       0.264600207097828390,  0.032995505724102259,  0.027352193370461464,  0.465032232925295830},

     {-0.341755071189254520,  0.045672270003706217,  0.315434983931481840, -0.381003099493682380,
      0.274314034730196000,  0.209334180690348150,  0.416871089022606610, -0.425728261005133390,
      0.144638929516077040, -0.361798238474875690,  0.241975771263241770,  0.134079541079699990,
      0.119924477767199280,  0.478039808571338650,  0.109942178241908550, -0.153802504763007160,
      -0.398128105327486990,  0.100543492473661900, -0.426437378861010070, -0.047234290745109320},

     {-0.121042015962302680,  0.491481229662895200,  0.395103028975427150, -0.337529528420418500,
      0.087408374994993210, -0.127659646328538660, -0.304709653835743670, -0.147991417907178400,
      0.405335859395563600,  0.222642539534717800, -0.182959184981882570, -0.436419211793690920,
      -0.231685189995914700, -0.367524201050400730, -0.317422310821712020, -0.457371155265718700,
      0.341809979639947410, -0.400551221799105410, -0.383099415805190800, -0.013551090843975544},

     {-0.262349460273981090,  0.358876355458050970, -0.379471549298614260,  0.357575017493218180,
      0.336916164029389620,  0.230470628943294290, -0.296227487269788980,  0.438788058701902630,
      -0.168985878583043810, -0.222664866130799060, -0.108446232043206690,  0.209972105454653500,
      -0.231183636467903850, -0.213343202602118250,  0.372442577499896290,  0.356224738527089360,
      0.158997151069343090, -0.432267076335847380, -0.291766679380089040,  0.064333010930567980},

     { 0.290375463664531710,  0.025274136103689671,  0.127913799136877060, -0.441309726331382990,
       0.157749935053288940,  0.310491488315165040, -0.398680881597101690, -0.000440084841102362,
       0.409940266516059640, -0.281780297402292490,  0.486008824314922090, -0.352409193757921460,
       -0.422903941478580240, -0.393462724983692170, -0.494834176264703270,  0.414012222550809380,
       0.337007903959602120, -0.291061663534492250,  0.352800281718373300, -0.331977974623441700},

     {-0.013726529665291309, -0.255645950324833390,  0.377994131296873090,  0.255089833866804840,
      0.031010847073048353,  0.250436708796769380,  0.111314572393894200, -0.309992001391947270,
      0.318169632460922000,  0.319547893479466440,  0.254341009538620710,  0.108545096125453710,
      -0.155177970416843890, -0.117745191324502230,  0.167235369794070720, -0.497428035363554950,
      -0.307253702543675900,  0.268554488662630320,  0.002131879795342684, -0.397313436027616260},

     { 0.486774191260337830, -0.011859295424073935, -0.249722629319876430, -0.436129750218242410,
       0.094677979592233896, -0.244556805584579710,  0.477882472798228260, -0.068314115982502699,
       -0.035618468653410673,  0.330682754516601560,  0.099707909394055605,  0.450655001681298020,
       -0.424963195808231830, -0.022297959309071302,  0.205744836013764140,  0.106047651730477810,
       -0.271861250512301920, -0.182940591592341660,  0.296055650338530540, -0.453691617585718630},

     {-0.363392698112875220,  0.050396659877151251,  0.154853478539735080, -0.018570668529719114,
      0.432651468552649020, -0.177911151200532910, -0.015998703427612782, -0.374602233991026880,
      -0.409356662537902590,  0.486133176367729900, -0.271915669552981850, -0.422582471277564760,
      -0.025726119056344032, -0.021638298872858286, -0.358712221030145880, -0.431048138998448850,
      0.233804895542562010, -0.380829748231917620,  0.000637745019048452, -0.301813573110848670},

     { 0.449853006284683940, -0.399654345586895940, -0.351158570963889360, -0.475110189523547890,
       0.078047695569694042,  0.354586265049874780,  0.130937462206929920,  0.306186445057392120,
       -0.328354326542466880, -0.073006887454539537,  0.352494827471673490, -0.191747024189680810,
       0.477389772422611710,  0.007348306477069855,  0.289682307280600070,  0.410041241440922020,
       0.329437155276536940, -0.226316396147012710, -0.464560992550104860,  0.420080492738634350},

     {-0.240183219313621520, -0.236476662103086710,  0.497498021461069580,  0.234090661630034450,
      0.241885039024055000, -0.361214199569076300,  0.303042522631585600, -0.024310064967721701,
      -0.242043947800993920, -0.196319732349365950,  0.173876361921429630, -0.292190941516309980,
      -0.095974077470600605,  0.322717790957540270, -0.267301130574196580,  0.482073618099093440,
      0.177304056007415060,  0.363636331632733350,  0.288260063156485560,  0.348949729930609460},

     {-0.209370555356144910,  0.140754891093820330, -0.342797294259071350, -0.231980782933533190,
      -0.351896802429109810,  0.446885013021528720, -0.321939541492611170,  0.477540352847427130,
      -0.279431382659822700, -0.286500533577054740,  0.397620845586061480, -0.019614601973444223,
      -0.022977195680141449,  0.395118867047131060, -0.285523940343409780, -0.281092156190425160,
      -0.466095332056283950, -0.482481417246162890,  0.194597778841853140, -0.208139279857277870},

     {-0.178801149595528840, -0.131525859236717220, -0.000330220907926559,  0.225224772933870550,
      -0.308808067813515660,  0.232368648517876860,  0.207298391032963990,  0.368495988193899390,
      0.096004980150610209, -0.004441545344889164,  0.217445718124508860,  0.386634424794465300,
      -0.363686654251068830,  0.374648423865437510, -0.345346357673406600, -0.215583456680178640,
      0.321533437352627520, -0.167285899166017770, -0.238043103832751510, -0.457897945307195190},

     { 0.046213567256927490, -0.340422258246690030,  0.022487452719360590, -0.476763627957552670,
       -0.445303391199558970,  0.236963512375950810, -0.257855784147977830, -0.411398723255842920,
       0.254482095129787920,  0.436741994693875310, -0.119538002647459510, -0.424319054000079630,
       -0.194783864542841910,  0.380131776444613930,  0.300905718933790920, -0.003591932356357574,
       0.112500424962490800,  0.008204110432416201, -0.135095943696796890, -0.291494594886898990},

     {-0.496237434912472960, -0.417650225572288040, -0.404860169626772400, -0.359924089163541790,
      0.456998198758810760, -0.250206527300179000, -0.075507545843720436,  0.278531636111438270,
      0.082507573533803225,  0.186449350323528050,  0.320633690804243090, -0.371278858743608000,
      0.346027092076838020, -0.156878856476396320, -0.348042486701160670,  0.400723700877279040,
      -0.419915344100445510, -0.105898270849138500,  0.489324978087097410,  0.334566751495003700},

     {-0.169156276155263190, -0.130213024560362100,  0.410247697494924070,  0.136059859301894900,
      -0.250081248115748170,  0.211153416428714990, -0.367532072588801380,  0.362419176846742630,
      -0.280642473138868810, -0.002628016285598278, -0.429075418040156360, -0.276879908051341770,
      0.079721758142113686, -0.333935587666928770, -0.136803997214883570,  0.036719956900924444,
      -0.084142114967107773,  0.287688456941396000, -0.184748406987637280,  0.498365459032356740},

     {-0.025862192735075951, -0.364114716183394190, -0.372913399711251260, -0.179835100658237930,
      -0.020993572659790516, -0.220955886412411930, -0.279111399315297600,  0.059091083705425262,
      0.173145842738449570, -0.289786421228200200, -0.106342164799571040, -0.496010433416813610,
      0.080000554211437702, -0.196094467304646970,  0.140049425885081290,  0.329919306095689540,
      -0.484941050875931980,  0.272517353296279910,  0.192338482942432170, -0.265583523549139500},

     {-0.230110662989318370,  0.263263064902275800, -0.042463431600481272,  0.349611095618456600,
      0.429327477701008320,  0.320732571650296450, -0.113668947480618950, -0.154814637266099450,
      0.108421028591692450,  0.201582645997405050, -0.156449178233742710, -0.417441163677722220,
      0.337467929814010860, -0.029362577944993973, -0.097276264335960150, -0.183525642380118370,
      0.249681535642594100,  0.123612336348742250,  0.375565441325306890, -0.077172621618956327},

     { 0.333825915120542050, -0.230776723474264140, -0.073183055035769939, -0.086173530668020248,
       0.073128809221088886, -0.433133628685027360, -0.256254224572330710,  0.088187758345156908,
       0.339383724611252550,  0.436084258370101450,  0.322604234796017410, -0.390726937912404540,
       0.199347323738038540, -0.219859196338802580,  0.458884157706052060,  0.128674801439046860,
       -0.399126624688506130, -0.154784789774566890,  0.473860164172947410,  0.209294403903186320},

     {-0.453202143777161840, -0.182589013595134020,  0.291853240225464110,  0.384265786502510310,
      0.288048408459872010, -0.305423023644834760, -0.299259855877608060,  0.037729944568127394,
      0.318189312703907490, -0.423694414552301170,  0.460557322949171070,  0.152015228290110830,
      -0.154471138026565310, -0.112625731620937590, -0.434158302377909420,  0.418657671194523570,
      -0.045759360305964947, -0.190412526484578850,  0.006845429539680481, -0.206375635694712400},

     {-0.254328268114477400, -0.170550335198640820, -0.097102573607116938,  0.445019055623561140,
      0.109590468462556600, -0.138218415901064870,  0.073693857062608004,  0.210463843774050470,
      0.206996794790029530,  0.047554021701216698, -0.080241752322763205,  0.253794651012867690,
      0.364965008106082680, -0.288388511631637810,  0.138060437515378000,  0.153013416565954690,
      -0.093811535276472569,  0.338800581637769940, -0.309256638865917920, -0.275622222572565080}},

    {{ 0.415106167085468770, -0.348699315451085570,  0.376393005717545750, -0.239364970941096540,
       0.038674952927976847,  0.442234703805297610, -0.320707299746572970,  0.492915592622011900,
       -0.248177822679281230,  0.186138130258768800, -0.213460043072700500, -0.002506090793758631,
       -0.484412204939872030,  0.189437383785843850, -0.057487034704536200,  0.125178263522684570,
       -0.448781032115221020, -0.483793177641928200, -0.164357892703264950,  0.258215762674808500},

     { 0.063760844059288502,  0.255400354973971840,  0.012010414153337479, -0.071274147834628820,
       0.467011843342334030, -0.349929148331284520, -0.418260730803012850, -0.126799691934138540,
       0.488871433772146700, -0.227517369668930770,  0.097578085958957672,  0.403977600857615470,
       -0.076216685120016336, -0.026028908323496580, -0.335387369617819790,  0.462458267807960510,
       -0.083794204518198967, -0.156094669364392760,  0.455373860429972410,  0.168027972802519800},

     {-0.469956539105623960, -0.258086182177066800, -0.334478117525577550, -0.454368744045495990,
      0.431351201608777050,  0.108034847769886260,  0.170809519477188590,  0.482570169493556020,
      0.124241670127958060, -0.493548373226076360,  0.240785932634025810, -0.311997485347092150,
      0.261851982213556770, -0.247203653212636710,  0.116728366818279030,  0.228863825555890800,
      -0.097132801543921232,  0.198467636015266180, -0.397935865912586450, -0.108261367771774530},

     { 0.470950266811996700,  0.199642220046371220, -0.204283766448497770, -0.105266418308019640,
       -0.326386688277125360, -0.039671136066317558, -0.142808150034397840,  0.089819107670336962,
       0.304234194569289680, -0.187434289604425430, -0.242152919527143240,  0.334277655929327010,
       0.054479528218507767, -0.076631037052720785,  0.379908911883831020, -0.014169270172715187,
       -0.468596189282834530,  0.050718431826680899, -0.031599100213497877,  0.155645481310784820},

     { 0.057170058600604534, -0.290813167579472060,  0.343647995963692670, -0.180977959185838700,
       -0.038016820792108774, -0.039623637218028307, -0.452114133164286610,  0.364850377663969990,
       -0.341156000737100840, -0.350049999076873060, -0.243410989642143250, -0.370205733925104140,
       0.349592220969498160,  0.052305243909358978,  0.024527847766876221, -0.476794467307627200,
       -0.487365892156958580,  0.381719697732478380,  0.113024640362709760,  0.316868302412331100},

     {-0.305714591406285760,  0.370871721301227810,  0.151145958341658120,  0.248764936812222000,
      -0.205759315751492980,  0.031054870691150427, -0.265404332894831900, -0.174355504568666220,
      -0.418226697482168670,  0.202996566891670230,  0.481289976742118600,  0.138943361118435860,
      0.412183399312198160,  0.324937972705811260,  0.457965402398258450, -0.125833421479910610,
      -0.214685664512217040, -0.494148730766028170, -0.260983043815940620, -0.055841665249317884},

     {-0.344198729842901230, -0.004394033458083868,  0.073952600825577974, -0.494606508873403070,
      -0.452088789548724890, -0.401519550941884520, -0.471400976181030270, -0.439454681705683470,
      0.480200146790593860,  0.141623664647340770,  0.377413621172308920, -0.325514444615691900,
      0.012495385948568583,  0.028559579513967037,  0.423250492662191390,  0.306736070197075610,
      -0.440385549794882540, -0.342153840232640500, -0.367619434371590610, -0.358612247277051210},

     { 0.360842726659029720, -0.386329457629472020,  0.280331114307045940,  0.273026125971227880,
       0.438608515076339240,  0.238296516705304380, -0.352807295508682730, -0.276077148970216510,
       0.244147785939276220, -0.113790339324623350,  0.168081185780465600,  0.399949056096374990,
       0.381815627682954070, -0.257966212928295140,  0.405342547222971920,  0.429726838134229180,
       -0.159485763870179650,  0.433941571041941640,  0.490272156894207000, -0.179285617079585790},

     { 0.075565235689282417,  0.367685778066515920, -0.004800061229616404, -0.411939378362149000,
       -0.103754642419517040, -0.081549568567425013,  0.394796692300587890, -0.044140191748738289,
       0.076296591199934483, -0.472822742071002720,  0.097247560974210501, -0.062860682141035795,
       -0.359152199234813450, -0.122421324718743560, -0.289834556169807910, -0.420543684158474210,
       -0.384124808013439180, -0.142641851678490640, -0.196620833128690720,  0.360022977925837040},

     { 0.243567808996886010,  0.471460353117436170,  0.259972034022212030,  0.125383436679840090,
       -0.286505859810858960,  0.165314581245183940,  0.055110275279730558,  0.054008376318961382,
       0.099256152752786875,  0.045382432173937559,  0.374722759239375590, -0.325178611557930710,
       -0.086931789759546518, -0.130077301990240810, -0.237117989454418420,  0.309313567820936440,
       0.288373129442334180, -0.342321297153830530, -0.234826623927801850, -0.135330279357731340},

     {-0.315144039224833250,  0.362420937512069940,  0.301809038501232860, -0.174296238459646700,
      -0.260000387206673620, -0.488025517668575050, -0.094839922152459621, -0.144125194754451510,
      -0.130667369347065690,  0.208539244718849660, -0.284102216828614470, -0.387099559884518380,
      0.179999597836285830,  0.475869817659258840,  0.238283876795321700,  0.393493738025426860,
      0.141184398904442790, -0.206605847924947740, -0.052497885655611753, -0.259559448342770340},

     { 0.338776584248989820, -0.177775125950574870, -0.084738059435039759, -0.248155205510556700,
       0.192147572059184310,  0.178143951110541820, -0.438841637223958970, -0.019479298032820225,
       0.335822653956711290, -0.173668261151760820,  0.345190422609448430, -0.479321385268121960,
       -0.311247323639690880,  0.146999461576342580, -0.153617623262107370, -0.071247710380703211,
       0.158973943907767530,  0.251542454585433010,  0.284627094864845280, -0.471693424973636870},

     {-0.039918300695717335, -0.499475121963769200, -0.358792984858155250, -0.359918702393770220,
      0.476394695695489650,  0.379490891937166450, -0.466424964368343350,  0.117579095065593720,
      -0.327114955522120000, -0.018922849558293819,  0.358019646722823380, -0.488338371273130180,
      0.303302024491131310, -0.226718412712216380, -0.236493576318025590, -0.004550403449684381,
      0.451425538398325440, -0.175335213541984560,  0.475970298517495390,  0.287248192355036740},

     { 0.150996525306254630,  0.321160721592605110,  0.307926807552576070,  0.339749202132225040,
       -0.031839816831052303, -0.345690815709531310, -0.231498508248478170, -0.372865872923284770,
       0.405851638875901700, -0.446871413383632900, -0.344559297896921630, -0.134066661819815640,
       -0.446346535347402100, -0.203352282755076890,  0.006014635786414146, -0.469951839186251160,
       -0.323861390352249150,  0.039589671883732080,  0.147627255879342560, -0.150976345874369140},

     {-0.479333177674561740,  0.005646902602165937, -0.139314717147499320,  0.323968846816569570,
      0.278928490355610850,  0.124191706534475090, -0.180581556633114810,  0.230354028753936290,
      0.448856492992490530, -0.204611257649958130,  0.017602221574634314,  0.099853018764406443,
      -0.383450536057353020, -0.174470970872789620, -0.060397779103368521,  0.084709647111594677,
      -0.020161786582320929,  0.208103712648153310,  0.211843774188309910, -0.114310147706419230},

     { 0.261232299264520410,  0.367284476757049560,  0.251623190473765130,  0.314885763917118310,
       -0.336067805998027320, -0.242362173274159430,  0.344933924730867150, -0.159929196350276470,
       0.297227498609572650, -0.007438819389790297,  0.189094457775354390,  0.317894320935010910,
       0.498208083678036930, -0.450220258906483650,  0.141863167751580480,  0.277136574033647780,
       0.173971447627991440,  0.461281611118465660,  0.007490602787584066,  0.122827941086143260},

     {-0.243329646531492470, -0.474907175637781620, -0.277319040149450300, -0.126780182588845490,
      -0.149378146510571240,  0.162283180747181180,  0.457929464522749190,  0.330460066907107830,
      -0.129613106604665520,  0.169773239176720380, -0.283850080799311400, -0.368380807340145110,
      0.037057715933769941,  0.467773110140115020,  0.446504956576973200,  0.200989909935742620,
      -0.274589063134044410,  0.291438881773501630, -0.458939285948872570, -0.477361564524471760},

     {-0.215999937616288660,  0.230155171826481820,  0.340532756410539150, -0.217791853938251730,
      0.279934912919998170, -0.017604075837880373, -0.440655279904603960, -0.046093638986349106,
      -0.056322464719414711,  0.066835323348641396, -0.423265697900205850,  0.200347889214754100,
      0.091928147710859776, -0.200584738049656150, -0.426432293374091390,  0.442550001665949820,
      0.461698442697525020, -0.468502828385680910,  0.273010068573057650, -0.167914663907140490},

     { 0.201270410791039470,  0.489159988239407540, -0.036295471247285604, -0.261671873275190590,
       0.456933098379522560, -0.089790514670312405,  0.439318036660552020, -0.317655964754521850,
       -0.298351632896810770,  0.480378750711679460, -0.295017529278993610, -0.014351570047438145,
       0.210533923003822570, -0.454484772868454460,  0.267856576014310120, -0.009531164076179266,
       0.027911151293665171,  0.327201296575367450,  0.444375196937471630,  0.471588686574250460},

     {-0.105963380075991150, -0.478890500962734220,  0.171936575789004560,  0.485964767634868620,
      -0.179475239012390380,  0.245504282880574460,  0.428514769300818440, -0.217776796314865350,
      0.277001454494893550,  0.201524838339537380,  0.114308539777994160, -0.021728134714066982,
      0.190684826578944920, -0.421986931469291450,  0.216599992010742430,  0.147617924958467480,
      -0.011777445673942566,  0.155918028671294450,  0.329961960203945640,  0.189870921429246660}},

    {{ 0.136296779848635200, -0.465055569075047970, -0.324480648618191480, -0.153169297147542240,
       -0.419540341943502430,  0.443375927861779930,  0.337299538776278500,  0.108370809350162740,
       0.270577224437147380,  0.281674736179411410,  0.079959495924413204, -0.335386155638843770,
       0.302784235216677190, -0.248103927820920940, -0.349421388003975150, -0.376691003330051900,
       0.497400355059653520, -0.420906618237495420, -0.094467799644917250,  0.274401809554547070},

     { 0.280618220102041960, -0.480159259401261810, -0.247326325159519910, -0.028696953319013119,
       -0.402146190870553260,  0.469273666851222520, -0.381079028360545640,  0.086076363455504179,
       0.125191695522516970,  0.448882931843400000, -0.224052714649587870, -0.238511524628847840,
       0.483827362768352030, -0.048533363267779350,  0.108319178223609920, -0.435712979175150390,
       -0.105157435405999420, -0.054381282534450293,  0.172657830175012350, -0.334580210968852040},

     {-0.272706546355038880, -0.247382673900574450, -0.169966366607695820, -0.469922311138361690,
      0.004513398278504610, -0.019387754146009684, -0.346613314468413590,  0.001913753338158131,
      0.059705627616494894,  0.058918886352330446, -0.223684437107294800, -0.159676152281463150,
      0.078759626951068640,  0.028989237733185291,  0.311626894399523740,  0.176613436080515380,
      -0.001737095415592194,  0.430547866038978100, -0.237310199998319150, -0.376545399427413940},

     { 0.379430797882378100,  0.038637085352092981, -0.115056924056261780,  0.363258160650730130,
       0.490103722084313630,  0.493262254633009430,  0.427545181475579740, -0.115053712856024500,
       -0.061119027901440859,  0.100203011650592090,  0.050366076175123453,  0.166174425743520260,
       0.352820337750017640,  0.380399710033088920,  0.196252114605158570, -0.142666263505816460,
       -0.138988044112920760,  0.349638800602406260,  0.359247489832341670,  0.420717583503574130},

     {-0.091442313045263290, -0.364436946809291840, -0.238958568777889010,  0.487317313905805350,
      0.164552290923893450, -0.427331674378365280,  0.163930749986320730, -0.337184804026037450,
      -0.496783808339387180,  0.426620549988001590, -0.213730203453451400,  0.382646989542990920,
      -0.034742364659905434,  0.171212872490286830,  0.245905150193721060, -0.044638642109930515,
      0.164475127123296260,  0.173450331669300790,  0.340307645034044980, -0.396643900778144600},

     {-0.226346656680107120, -0.109326278790831570,  0.269530524965375660, -0.373526318930089470,
      -0.228926568757742640, -0.034217359963804483, -0.016192582435905933,  0.132085387129336600,
      -0.184578559361398220, -0.156945092137902980,  0.052802970632910728,  0.223979127593338490,
      -0.021382038947194815,  0.313844401855021720,  0.211296441499143840, -0.356829748023301360,
      0.386512727476656440, -0.124772808514535430, -0.194014552049338820,  0.389728919137269260},

     {-0.198152258060872550,  0.092255244497209787,  0.272375908680260180,  0.267105377279222010,
      -0.236531882546842100,  0.018281058873981237, -0.277533264830708500,  0.427943244576454160,
      -0.308268609456717970, -0.437225619796663520, -0.468700655736029150, -0.034615266136825085,
      -0.046551898121833801,  0.300829869229346510,  0.091858415398746729,  0.224521533120423560,
      -0.233387490734457970, -0.424334167037159200, -0.143393079284578560,  0.082033949904143810},

     {-0.081279259175062180,  0.409409891348332170, -0.193986922502517700,  0.397338701877743010,
      0.223254293669015170, -0.482690481003373860, -0.459491045679897070,  0.109767021145671610,
      -0.107463289052248000, -0.153505597729235890, -0.000504059251397848,  0.194384452886879440,
      0.438749647233635190, -0.228128150571137670, -0.038510169833898544, -0.297782235313206910,
      0.290152908768504860,  0.183956565801054240, -0.369838990736752750,  0.481884299311786890},

     { 0.246730946004390720, -0.338539646472781900, -0.052730966359376907, -0.299820952117443080,
       0.462290223222225900, -0.460872550960630180,  0.424700581468641760, -0.271097267512232070,
       -0.385206717997789380, -0.218692497815936800,  0.310936682857573030,  0.033514023292809725,
       -0.309282606467604640, -0.383050239644944670, -0.069147274829447269,  0.413971687201410530,
       -0.365740720182657240, -0.028638320509344339,  0.023738708812743425,  0.026795990765094757},

     { 0.317856082227081060, -0.476765350438654420, -0.278819556348025800,  0.256605729460716250,
       -0.204893501009792090,  0.182670273818075660,  0.458823494147509340, -0.414740592241287230,
       -0.133373160380870100, -0.411015496589243410, -0.432856292463839050, -0.386642213910818100,
       -0.249555142596364020,  0.014412741176784039, -0.186463166028261180, -0.287264919374138120,
       0.053540190216153860, -0.261762584559619430, -0.058362186886370182,  0.168333472218364480},

     { 0.019544917624443769, -0.247425504028797150, -0.298152504488825800,  0.210262311622500420,
       -0.130475743208080530,  0.132700221147388220,  0.124233998823910950,  0.003783536609262228,
       -0.395938099361956120, -0.352027292363345620, -0.469420472625643010,  0.421917982865124940,
       -0.328792642802000050, -0.248240028973668810,  0.178523712325841190, -0.033686143346130848,
       0.434430244844406840,  0.137347206473350520,  0.051573264412581921, -0.198942915070801970},

     { 0.226331710349768400,  0.118716971948742870, -0.085585128981620073,  0.476776567753404380,
       -0.366870286874473090,  0.227951704990118740, -0.310488351620733740,  0.186669903341680770,
       0.466189120896160600,  0.131149461492896080, -0.144996623974293470, -0.014265961479395628,
       0.383723957929760220,  0.056850871536880732, -0.304003649856895210, -0.246751785278320310,
       -0.310448907315731050,  0.320230349432677030,  0.257031751330941920, -0.206387006212025880},

     { 0.468203057069331410,  0.287611278705298900, -0.284469023346900940, -0.360589585267007350,
       -0.460628750268369910,  0.394054689444601540,  0.105724271386861800,  0.473801494576036930,
       0.031401895917952061, -0.342702464200556280, -0.225141420494765040, -0.242266393732279540,
       0.276014508213847880,  0.189273450523614880, -0.265489825978875160,  0.409144221339374780,
       -0.082774844020605087, -0.075978177599608898,  0.095814125146716833, -0.116585723124444480},

     {-0.444828715641051530,  0.450817501172423360,  0.369148315396159890,  0.438895242288708690,
      0.007668372709304094, -0.434855333995074030, -0.307856542989611630,  0.197219465859234330,
      0.385375015437603000,  0.449175208341330290,  0.490832459647208450,  0.353578072506934400,
      0.236786487046629190, -0.293636563699692490,  0.492988487239927050,  0.276157736778259280,
      -0.399581874255090950,  0.098712758626788855,  0.249959231354296210,  0.131820022128522400},

     { 0.256010294891893860, -0.475182188674807550,  0.389553628396242860,  0.032024803105741739,
       0.214091261848807330, -0.375936197116971020, -0.058830975554883480, -0.368683582171797750,
       0.048085625283420086, -0.463016850408166650,  0.014730694703757763,  0.103256909642368560,
       0.487800650764256720, -0.116120989434421060,  0.042152151931077242, -0.004530976060777903,
       -0.050976323429495096,  0.234295608941465620, -0.307311510201543570, -0.165601307991892100},

     { 0.183470817282795910, -0.316479050554335120, -0.312023235484957700, -0.079742695670574903,
       -0.110115614254027610, -0.319034747779369350, -0.303584958892315630, -0.009697488043457270,
       0.279678010847419500,  0.446374272927641870, -0.377877465914934870,  0.035688305739313364,
       0.471192084252834320, -0.488323837518692020, -0.432286891154944900,  0.185283346101641650,
       -0.364260034635663030,  0.008882133755832911,  0.316599764395505190,  0.183825591113418340},

     { 0.045865283347666264, -0.168669540900737050, -0.212917499244213100,  0.033665934577584267,
       0.215209469664841890,  0.329234653152525420, -0.470865041483193640, -0.335766853764653210,
       0.063530262093991041, -0.278176551684737210, -0.001368161756545305, -0.252998920157551770,
       -0.094655602239072323,  0.186608603224158290,  0.167258384171873330,  0.295228783506900070,
       0.367573855444788930,  0.363673425745218990, -0.214468704536557200,  0.147251866292208430},

     { 0.310047698672860860, -0.092346170451492071, -0.317059827502816920,  0.281239782925695180,
       -0.080670007504522800, -0.249346718657761810, -0.033476870972663164,  0.055069957859814167,
       0.259535415098071100, -0.216877106577157970, -0.261104451026767490, -0.194599301088601350,
       0.114453352987766270,  0.025978050194680691,  0.339066633488982920, -0.170337177347391840,
       -0.144787296652793880,  0.368201592005789280, -0.006104030646383762,  0.418742965441197160},

     {-0.409974959678947930,  0.492527807597070930, -0.334255954716354610, -0.004630561918020248,
      0.179136410821229220,  0.333002429921180010, -0.209401778411120180,  0.046710266266018152,
      0.196675855666399000,  0.076129517517983913, -0.306037866976112130,  0.006723554339259863,
      0.483783347066491840, -0.123097694478929040, -0.212036662735044960, -0.096886660438030958,
      0.127555586863309140,  0.254486466292291880,  0.458183297887444500, -0.112908997572958470},

     {-0.462390639819204810, -0.302921153139323000,  0.192491701338440180,  0.152062713168561460,
      0.223056897055357690,  0.031558334827423096,  0.481725535821169610, -0.421730399597436190,
      -0.100240073166787620, -0.024378494825214148,  0.497012566309422250, -0.010215032845735550,
      -0.031850686762481928, -0.337243388406932350,  0.485154405236244200, -0.352714275941252710,
      0.495759041514247660, -0.224247373174875970,  0.193995990790426730,  0.192434897180646660}},

    {{ 0.351882144343107940,  0.387958123814314600, -0.300841548480093480,  0.335665491875261070,
       -0.235139570664614440, -0.012878211215138435, -0.261221168562769890,  0.392416016198694710,
       -0.258391744457185270, -0.303037870675325390, -0.220492981374263760, -0.220782384276390080,
       -0.105959023348987100,  0.471998719964176420,  0.431280328892171380, -0.382902126293629410,
       0.003557054791599512,  0.413005864713341000, -0.304632525425404310,  0.403316981624811890},

     {-0.111372629646211860, -0.307619959115982060, -0.106898051220923660,  0.356776683591306210,
      -0.144863347522914410, -0.121743645984679460, -0.495937592349946500, -0.149104305543005470,
      0.154008981306105850,  0.198058398440480230, -0.456669408362358810,  0.005891125649213791,
      0.086016522254794836, -0.257510956376791000, -0.158443382475525140,  0.350876951590180400,
      0.229610832408070560,  0.080335449427366257,  0.243292968254536390,  0.471219087950885300},

     { 0.277297578752040860, -0.477200013119727370, -0.249563296325504780, -0.328661444596946240,
       0.494798707310110330, -0.318282967433333400, -0.211563570424914360, -0.001644237898290157,
       -0.405277102254331110, -0.016196095850318670, -0.098327255807816982, -0.016649731900542974,
       0.176183945033699270,  0.294774692971259360, -0.159873048309236760, -0.468679402489215140,
       -0.326968952547758820, -0.155810640659183260, -0.117783708032220600,  0.327040028758347030},

     {-0.457752241753041740, -0.074453115928918123, -0.167068845592439170,  0.128264280501753090,
      0.168035927694290880,  0.174487772397696970, -0.020858767442405224, -0.102353239897638560,
      -0.245176778174936770, -0.277565799187868830, -0.131134151481091980, -0.467879199422895910,
      -0.254765812307596210,  0.119302552193403240, -0.296540643554180860, -0.259967104997485880,
      0.301019585225731130, -0.008104213979095221,  0.238388657569885250,  0.395742482971400020},

     { 0.475699690170586110, -0.359938598237931730, -0.120907248929142950,  0.151883635204285380,
       0.434836094733327630,  0.219219702761620280,  0.183204232715070250, -0.392132857814431190,
       -0.436590937897562980, -0.434579474851489070,  0.434907170943915840, -0.394343179650604720,
       -0.009032590780407190, -0.232161674182862040,  0.233921101316809650, -0.340996663086116310,
       0.442326098214834930, -0.286937666125595570,  0.056650097016245127, -0.302850679960101840},

     {-0.064503465313464403,  0.425515945535153150, -0.270729879382997750,  0.180730722378939390,
      0.044818498194217682, -0.067270522937178612,  0.420763617847114800, -0.154161916580051180,
      0.424625263083726170,  0.159152275417000060, -0.258419433608651160,  0.400324953254312280,
      0.299213677179068330,  0.120673317462205890,  0.052208588458597660,  0.234049771912395950,
      -0.160106979776173830, -0.264587178360670800,  0.341916914563626050, -0.096697917673736811},

     {-0.199166653212159870,  0.276824085507541890,  0.008958903141319752,  0.291800756007432940,
      -0.455337588675320150, -0.257119995541870590,  0.450804092921316620,  0.486988509539514780,
      -0.044057661667466164,  0.007454189937561750, -0.315862170420587060,  0.391438873019069430,
      -0.067029864061623812, -0.086592049337923527,  0.072169595398008823,  0.477788634132593870,
      0.346137427724897860, -0.007066786754876375, -0.176373282447457310,  0.270762691274285320},

     {-0.347914511337876320,  0.065207283943891525,  0.171087644528597590,  0.451299165841192010,
      -0.314119398593902590, -0.276703766547143460,  0.185348938219249250,  0.025773621629923582,
      -0.041290944907814264,  0.027265852782875299,  0.429075703956186770,  0.259542401880025860,
      -0.195910061709582810, -0.061965392902493477,  0.051343157887458801, -0.151247649919241670,
      0.180914611555635930,  0.002147250808775425, -0.164259140379726890, -0.363143050111830230},

     {-0.490398559253662820,  0.019878689665347338, -0.471704177092760800, -0.057428423315286636,
      0.433286640327423810,  0.100465418770909310, -0.079639789182692766,  0.279424068052321670,
      -0.406601367983967070,  0.243986928369849920,  0.050186759326606989, -0.254515878856182100,
      -0.190805787686258550, -0.278725595679134130, -0.303216713014990090, -0.004925186280161142,
      -0.055429362226277590,  0.382132225204259160, -0.479151564650237560,  0.403279692865908150},

     {-0.090601922012865543,  0.449924139771610500,  0.162822094745934010,  0.213488016743212940,
      -0.112041253130882980, -0.285834747366607190, -0.437759633176028730, -0.431126641109585760,
      0.216312503442168240, -0.102018773555755620, -0.294269691221416000,  0.225913944188505410,
      0.417859916109591720, -0.265973867848515510, -0.331514478661119940,  0.351146556437015530,
      0.334491550922393800,  0.088845732156187296,  0.130570624954998490,  0.427890182938426730},

     {-0.167167339008301500, -0.319242615718394520, -0.326625695917755370,  0.142026873305439950,
      -0.097968211397528648, -0.129842408467084170, -0.362898312509059910,  0.346602426376193760,
      -0.247710183262825010, -0.342049877159297470,  0.249882119242101910,  0.161687895189970730,
      -0.392125737387686970, -0.087295786011964083, -0.124824088066816330, -0.004166990052908659,
      0.126869466621428730, -0.062583721242845058,  0.064706368837505579, -0.156818029936403040},

     { 0.335397505201399330,  0.270436677616089580, -0.430904085282236340,  0.253257421776652340,
       -0.495537190232425930, -0.262418563943356280,  0.104403978213667870,  0.338954360689967870,
       0.326427168212831020, -0.265025396831333640,  0.266844544094055890, -0.340740170795470480,
       -0.084268012084066868,  0.440218848176300530,  0.301286702975630760,  0.317763776518404480,
       -0.189623560290783640,  0.438388390466570850,  0.164366203360259530,  0.062666256912052631},

     {-0.403661486692726610, -0.085751677397638559, -0.275645847897976640, -0.295787223614752290,
      0.326952537056058650,  0.099530064035207033,  0.200045786332339050, -0.046177996322512627,
      -0.463053657207638030, -0.235247844830155370,  0.297003974206745620,  0.372343847993761300,
      -0.464811167214065790,  0.366099888924509290,  0.125601269770413640, -0.460348356980830430,
      -0.396318675018846990, -0.269994751550257210,  0.378606003709137440,  0.430108493193984030},

     {-0.035020148381590843,  0.145450547803193330, -0.410631677135825160,  0.380711839534342290,
      0.085669396445155144,  0.390655025839805600,  0.198475616518408060,  0.396045836154371500,
      0.329043416306376460, -0.137158180121332410, -0.041287906933575869,  0.425381929613649850,
      0.277090142481029030,  0.183066245168447490, -0.370405294001102450,  0.104042679537087680,
      -0.217403690796345470,  0.329640492331236600, -0.442135316319763660, -0.180457348003983500},

     {-0.405607352498918770,  0.354868657886981960, -0.308113499544560910, -0.370418519247323270,
      0.220968546811491250,  0.317487770225852730, -0.330766876228153710,  0.324649871792644260,
      -0.452506981324404480, -0.452160872519016270,  0.254758364986628290,  0.012472870759665966,
      0.193289675749838350,  0.344126687850803140, -0.106815289705991740, -0.221040927805006500,
      0.234781713690608740, -0.408339673187583680, -0.324995091650635000,  0.063825129996985197},

     {-0.045497853308916092,  0.133717001881450410, -0.010792939923703671, -0.268407710362225770,
      -0.183216752950102090,  0.118801766075193880,  0.335634969174861910,  0.099379556719213724,
      -0.051557741127908230,  0.393499652855098250,  0.418922208715230230,  0.042834906373172998,
      0.248368310742080210, -0.389191290829330680,  0.172416387125849720, -0.030663142446428537,
      0.428296479862183330,  0.341649510897696020, -0.206013270653784280,  0.475789498537778850},

     { 0.389488638844341040, -0.451254905201494690, -0.011737630702555180,  0.082778314594179392,
       0.392871782649308440,  0.381447080057114360,  0.361737386789172890,  0.127653496805578470,
       0.473107406869530680, -0.463257704861462120, -0.308521373197436330, -0.072390445973724127,
       0.170459297019988300,  0.180685686878860000,  0.159201843664050100,  0.487242544535547490,
       -0.200512546580284830, -0.005163187161087990,  0.086622101254761219,  0.247929712291806940},

     {-0.111663533840328450,  0.005544309969991446, -0.209235381335020070, -0.363295223098248240,
      0.116353019606322050,  0.463181006256490950,  0.106041634920984510,  0.044649499468505383,
      0.304830517154186960,  0.400028364267200230,  0.020438998006284237,  0.194319155998528000,
      0.448773459065705540, -0.491298632230609660, -0.222902529407292600,  0.341645242180675270,
      0.390148447826504710, -0.361165142618119720, -0.030701261013746262,  0.363255854696035390},

     {-0.324422847013920550,  0.160777365788817410, -0.209134591277688740,  0.346036450006067750,
      -0.158536946866661310,  0.450067252386361360,  0.333278994541615250,  0.140950506553053860,
      -0.055095934309065342, -0.080098904203623533, -0.111119781155139210,  0.333240531850606200,
      0.425445406232029200,  0.179644837509840730,  0.469945308752357960,  0.041798425838351250,
      0.142825843766331670,  0.075986943673342466, -0.413552074693143370, -0.052343638613820076},

     {-0.023984691593796015,  0.106886923313140870, -0.358024482615292070, -0.075211232528090477,
      0.115588291082531210, -0.080927011556923389, -0.233565990347415210,  0.005736738909035921,
      0.057907845824956894,  0.235732748638838530, -0.131007405929267410,  0.233484998811036350,
      -0.103489885106682780,  0.159858002793043850,  0.079521449282765388,  0.237973168026655910,
      0.109925255645066500, -0.087199556175619364, -0.121076325420290230, -0.445170678663998840}},

    {{ 0.332701540086418390,  0.267803893424570560,  0.388069853186607360,  0.258146946318447590,
       -0.052551269065588713,  0.358015161938965320, -0.200054627843201160, -0.409725424833595750,
       -0.065997893922030926, -0.113606702536344530,  0.037930936552584171,  0.410017414484173060,
       0.493280220776796340,  0.179906453937292100, -0.165193818043917420,  0.108868512324988840,
       -0.401020557619631290,  0.101240192074328660, -0.385394748765975240,  0.156887288670986890},

     {-0.163027059286832810, -0.016402154695242643, -0.109627712517976760,  0.233483055606484410,
      -0.356544151436537500,  0.469893736764788630, -0.028543776366859674,  0.253381104208529000,
      -0.117305818945169450,  0.350379898212850090,  0.308210425544530150, -0.284604278858751060,
      0.118183791637420650,  0.196280278731137510,  0.473542667459696530, -0.434367476962506770,
      0.054295440670102835, -0.226511960383504630, -0.344092901796102520,  0.488297546748071910},

     { 0.159881337080150840,  0.193838034756481650,  0.398314961232244970,  0.153161557856947180,
       -0.126255511306226250, -0.266878856346011160, -0.237969929818063970, -0.027276068460196257,
       0.334361335728317500, -0.123364678118377920, -0.370388779789209370, -0.328665723558515310,
       0.360233167186379430,  0.019983507692813873,  0.404817332513630390, -0.496310984250158070,
       -0.010122755076736212, -0.123726443853229280,  0.257070119958370920,  0.372571425978094340},

     {-0.273346545174717900,  0.065280545502901077, -0.412032852880656720,  0.344837246462702750,
      -0.238439175765961410, -0.438490185420960190,  0.410469769500195980,  0.315856265369802710,
      -0.165002145804464820, -0.433623132295906540,  0.304153812117874620,  0.494879191275686030,
      0.260214902460575100,  0.202468773815780880,  0.148040749132633210, -0.366040608379989860,
      0.435589917469769720,  0.410070819780230520,  0.106683323159813880,  0.269951253198087220},

     {-0.213293858338147400,  0.236294543370604520,  0.441285529639571910, -0.353060691151767970,
      -0.243721948936581610,  0.346102862153202300, -0.349371674936264750,  0.246155295986682180,
      -0.277623581234365700,  0.407698445022106170,  0.118726721964776520, -0.050970126409083605,
      -0.027021009009331465,  0.206693869084119800, -0.206132879946380850,  0.234539815224707130,
      0.268203683663159610, -0.295663109980523590,  0.050396080594509840, -0.396798462141305210},

     {-0.229286242276430130, -0.145450106821954250, -0.401919270865619180, -0.469071339350193740,
      -0.442981333006173370,  0.246121478732675310, -0.335111947730183600,  0.492608584463596340,
      0.156192298512905840,  0.271571375429630280,  0.262559837661683560,  0.442898440174758430,
      0.007865918800234795,  0.203845367301255460, -0.410162250977009530,  0.264143969863653180,
      0.049948229920119047, -0.259533925913274290,  0.010299266315996647,  0.272324648685753350},

     {-0.351835480425506830, -0.370974011719226840, -0.278645477723330260,  0.121143510565161710,
      0.335719857830554250,  0.015221642330288887, -0.144316674210131170,  0.103923541493713860,
      0.219558532349765300,  0.406079406850039960,  0.207125079818069930,  0.490272290538996460,
      -0.239370699971914290,  0.305205808952450750, -0.478799048811197280, -0.182352032978087660,
      0.051327287685126066, -0.313910996541380880, -0.189743448514491320, -0.292480413801968100},

     { 0.457660378888249400, -0.427183610852807760, -0.349581973627209660, -0.034473702311515808,
       0.276661756448447700, -0.259744224138557910, -0.270329732447862630, -0.173390013631433250,
       -0.019278150051832199,  0.239969533868134020, -0.401065364945679900,  0.128886369522660970,
       0.368995522614568470, -0.179710842669010160, -0.249970119912177320,  0.204715380445122720,
       0.335510800126940010,  0.105713206343352790, -0.191361078061163430,  0.055069332476705313},

     { 0.011792613193392754, -0.484235998243093490,  0.045341623015701771,  0.272421913221478460,
       0.320969811175018550,  0.066542574204504490, -0.409930119756609200, -0.127702901139855380,
       0.252631577663123610, -0.099673568271100521,  0.079816685523837805,  0.210291956551373000,
       -0.026857179123908281,  0.230234711896628140, -0.324181745760142800, -0.250195422675460580,
       0.470490487758070230, -0.094511477742344141,  0.076414564158767462, -0.048787661828100681},

     {-0.354541943874210120,  0.175349199213087560, -0.419901292305439710, -0.485546421259641650,
      0.495638357009738680, -0.169871411751955750,  0.219168959185481070,  0.331149157136678700,
      0.435841794591397050, -0.472192118410021070, -0.113781510386615990, -0.052365592215210199,
      -0.456428116653114560,  0.431560113094747070, -0.279943678993731740,  0.364541694521903990,
      -0.001897312700748444, -0.189873798750340940, -0.263161206152290110, -0.249265734571963550},

     { 0.210452632978558540,  0.316655479371547700,  0.461026221979409460, -0.316404546145349740,
       0.046890191268175840, -0.363155523315072060, -0.066599968820810318,  0.017380679491907358,
       0.042332998942583799, -0.490185404662042860,  0.468593017663806680,  0.187791055068373680,
       0.185163795016705990, -0.451308274641633030,  0.202244634274393320,  0.180802152026444670,
       -0.121179686393588780, -0.078586406540125608,  0.011951309163123369, -0.185337891802191730},

     {-0.050778524950146675,  0.398169798776507380,  0.262296515982598070, -0.007206641137599945,
      0.329729911871254440,  0.482352836988866330, -0.142664946615695950, -0.172167400363832710,
      -0.207520961761474610,  0.094173847232013941,  0.078566865064203739, -0.497068328782916070,
      -0.089170673396438360,  0.039593087043613195, -0.313472874928265810,  0.457719518337398770,
      0.176437563728541140,  0.119927156716585160, -0.024899802170693874, -0.281229437328875060},

     { 0.129741752054542300, -0.056306784506887197,  0.406561618205159900, -0.185094452928751710,
       -0.007615059148520231,  0.108806252479553220,  0.495707699097692970,  0.371205254923552270,
       -0.469780154060572390,  0.007659008260816336, -0.314132636878639460, -0.020558678545057774,
       -0.094171192497014999,  0.448163879569619890,  0.472234680317342280, -0.264441280625760560,
       0.430516716558486220, -0.170430266298353670,  0.063391319010406733, -0.277004244737327100},

     { 0.423743581399321560, -0.358041815925389530, -0.274072573520243170, -0.165427091997116800,
       0.181551271583884950, -0.087545447982847691, -0.207707573659718040, -0.142011164687573910,
       -0.467618291266262530,  0.267392624169588090,  0.076759398449212313,  0.162123460788279770,
       -0.288914160337299110, -0.016678983345627785,  0.477029008325189350,  0.203470780979841950,
       -0.407872730866074560,  0.472736707422882320,  0.074676035903394222, -0.377652884926646950},

     {-0.019604283850640059,  0.260543399024754760,  0.101788436528295280,  0.386224523652344940,
      0.208707278594374660,  0.074023116845637560, -0.378216756973415610,  0.139223995618522170,
      0.403592851012945180,  0.185174562502652410,  0.362219750881195070,  0.327336432412266730,
      0.327132746577262880, -0.411852822639048100, -0.338090659584850070,  0.008684018161147833,
      0.000601729378104210, -0.045798232778906822,  0.366672853939235210,  0.032983438111841679},

     {-0.278405608609318730, -0.056567747611552477, -0.304893100634217260, -0.067319768480956554,
      0.426753269042819740, -0.327864092309027910, -0.363848987501114610, -0.481119461823254820,
      -0.355127384886145590,  0.210827048402279620, -0.358772346749901770,  0.125268331263214350,
      -0.028629552572965622,  0.243016090244054790,  0.011492854915559292, -0.319922273512929680,
      -0.182960792910307650,  0.133276098407804970,  0.319301722105592490, -0.279367941897362470},

     {-0.181549339089542630,  0.181521472986787560, -0.452031509485095740, -0.354416592512279750,
      0.269668650347739460, -0.290122168604284520,  0.154267426114529370, -0.229729619808495040,
      0.164079598616808650,  0.020940280053764582,  0.303253818303346630,  0.385673990007489920,
      0.464372532442212100,  0.498360717669129370, -0.181645778473466630,  0.391125801485031840,
      -0.329503374639898540, -0.045494765974581242,  0.410006339661777020, -0.184630759060382840},

     {-0.334667717572301630, -0.448766007088124750,  0.440637572202831510,  0.136702730320394040,
      0.294250083155930040, -0.047869572415947914,  0.316780456807464360, -0.388710709288716320,
      -0.414593474008142950,  0.136082178913056850, -0.168078651186078790, -0.096142813097685575,
      -0.182396348100155590, -0.120110160205513240,  0.049440594390034676, -0.412727697752416130,
      0.089767671190202236, -0.296291979495435950, -0.142457317560911180, -0.246152730192989110},

     { 0.224648300558328630, -0.339203498791903260, -0.360478740185499190,  0.189020833000540730,
       -0.340842781122773890, -0.042124518193304539,  0.080146634485572577, -0.170346155297011140,
       0.412380715832114220, -0.009847025852650404,  0.145023085642606020, -0.422287001274526120,
       0.041386967524886131,  0.085660657845437527,  0.214415729045867920, -0.164362949319183830,
       -0.462208914570510390,  0.031196185853332281, -0.053073658607900143, -0.376802388578653340},

     {-0.332721635233610870,  0.278847690671682360,  0.027054798323661089, -0.015117983333766460,
      -0.341262469533830880, -0.423504606820642950,  0.072154318913817406,  0.248505201656371360,
      -0.219796586316078900,  0.429697001818567510, -0.497647528536617760, -0.495148285292088990,
      -0.409506496973335740, -0.358126268722116950,  0.193872547708451750, -0.250349278096109630,
      0.099749213084578514, -0.225980817340314390,  0.079304566606879234,  0.012129929382354021}},

    {{ 0.264172156807035210, -0.275672347750514750,  0.089842928107827902, -0.194440875668078660,
       0.309988310560584070, -0.195741342846304180,  0.141196175478398800,  0.347779395990073680,
       0.335454843007028100, -0.411877483129501340,  0.470977007877081630, -0.497266792226582770,
       0.366970207542181020, -0.001968193799257278, -0.012384775560349226, -0.474292261991649870,
       0.074527199380099773, -0.440230456646531820,  0.274212939664721490,  0.354730613529682160},

     { 0.489466545172035690,  0.276565411128103730,  0.359582328237593170, -0.420039951801300050,
       0.418439142871648070,  0.053454875946044922, -0.170389229431748390,  0.018188355956226587,
       0.327474058605730530,  0.408915337175130840, -0.469681714661419390,  0.091646215878427029,
       -0.366757010109722610,  0.120161213446408510,  0.397205340210348370,  0.443231300450861450,
       0.424419870600104330,  0.038401515688747168,  0.291010696440935130,  0.259874713607132430},

     { 0.126524033024907110,  0.261987704318016770,  0.262607921380549670, -0.006505759432911873,
       -0.239980489015579220, -0.249776854179799560,  0.019201979041099548,  0.334546710364520550,
       -0.190007310360670090, -0.206585081294178960,  0.189277323894202710, -0.200540765188634400,
       -0.430019669700413940,  0.048859652131795883, -0.120580716524273160,  0.488419473171234130,
       -0.397685471456497910,  0.209030054043978450,  0.006607829127460718,  0.429788587149232630},

     { 0.117945391219109300,  0.036926114931702614,  0.021434803027659655,  0.251188381109386680,
       -0.342912671621888880, -0.081359856296330690,  0.194419681560248140, -0.418492800556123260,
       0.457041659392416480, -0.014569621533155441,  0.341381913051009180,  0.083565692417323589,
       -0.252581917215138670,  0.103989834897220130, -0.422940066549927000,  0.007437593769282103,
       0.354212980717420580,  0.096261912491172552, -0.158015695400536060, -0.335794329643249510},

     { 0.389676831196993590, -0.468738371506333350, -0.036335094366222620,  0.459657161496579650,
       0.080121281091123819,  0.343084189109504220,  0.448076634667813780,  0.182435809634625910,
       0.052114243153482676, -0.045315535739064217,  0.112224396783858540, -0.329940365627408030,
       0.491610579192638400, -0.366340799722820520,  0.421248015947639940, -0.351302092429250480,
       0.052299343980848789,  0.115667697507888080, -0.269794892985373740,  0.009341003373265266},

     {-0.398901924025267360, -0.428412979468703270, -0.407093303743749860, -0.151483840774744750,
      0.175576855428516860, -0.330033370293676850,  0.355953752994537350,  0.029789836145937443,
      0.266228542197495700, -0.302061942405998710,  0.193995506968349220,  0.155905373394489290,
      -0.270800313446670770, -0.342339587397873400,  0.115562535356730220,  0.309320967644453050,
      -0.499255398288369180,  0.063639170024544001, -0.008243222720921040,  0.052858844865113497},

     {-0.481676365714520220, -0.396018825937062500,  0.222918479237705470, -0.490065786521881820,
      -0.262359625659883020,  0.144166495185345410, -0.341367878485471010,  0.289939718320965770,
      -0.240165806841105220, -0.111162771470844750, -0.200719277840107680, -0.139067730866372590,
      -0.039575750939548016, -0.107812581583857540,  0.209448428358882670, -0.363998895511031150,
      0.062154048122465611,  0.065402181819081306,  0.165790941100567580, -0.171617409680038690},

     { 0.263340239413082600, -0.140213551931083200,  0.484287963714450600,  0.492539925966411830,
       0.017446860671043396,  0.099850499071180820,  0.301860893610864880,  0.018191462382674217,
       -0.336510330438613890, -0.206382329110056160, -0.428949692752212290, -0.318186696153134110,
       -0.102401154581457380,  0.293968786485493180, -0.308252482209354640,  0.135239219758659600,
       -0.061864717863500118, -0.149620360694825650, -0.074821061454713345,  0.197969475295394660},

     { 0.239216867834329610,  0.224459660705178980, -0.441098255570977930, -0.300358882639557120,
       -0.383352920878678560,  0.268350173253566030, -0.164357778150588270,  0.178801127243787050,
       -0.166247644927352670, -0.498566837050020690, -0.492816282436251640, -0.402907405514270070,
       -0.138780388981103900,  0.491471681278198960, -0.410367479082196950,  0.378666471689939500,
       0.091322180815041065,  0.391493414528667930, -0.103142065927386280,  0.254811850376427170},

     {-0.314888914115726950, -0.032091758679598570,  0.436625154223293070,  0.082709931302815676,
      -0.238122971728444100, -0.371627327986061570, -0.282050848938524720,  0.200012310408055780,
      -0.021247688680887222,  0.143128089606761930, -0.102018214296549560, -0.282030820380896330,
      -0.132412249688059090, -0.043116469867527485, -0.082389703020453453, -0.015765170566737652,
      -0.274766296613961460,  0.253252518828958270, -0.336964043322950600,  0.058986058458685875},

     { 0.254685682244598870, -0.329780325759202240,  0.156078653410077100, -0.384094706736505030,
       -0.338308644015342000,  0.245711174327880140,  0.494571765419095750,  0.253013536799699070,
       0.137204588856548070, -0.108570300508290530,  0.007825387176126242,  0.322315674740821120,
       0.359337941277772190, -0.055549458600580692, -0.094974393956363201, -0.378785030450671910,
       0.072823213879019022,  0.122974757570773360,  0.321227279957383870, -0.448424474801868200},

     {-0.233897152822464700, -0.280790934339165690, -0.230455295182764530,  0.133690597955137490,
      0.176092595793306830,  0.187155001796782020, -0.382074572611600160,  0.401326299645006660,
      -0.059592478908598423, -0.219038615468889470, -0.039687641896307468, -0.304906796663999560,
      -0.048818941228091717, -0.383608988486230370, -0.189001503400504590,  0.112872414756566290,
      0.362102185841649770, -0.194429737981408830, -0.134114048443734650, -0.000693224836140871},

     { 0.196999961975961920,  0.373711338732391600, -0.178377550095319750,  0.056337903253734112,
       -0.181838119402527810,  0.226648056413978340,  0.177552872803062200,  0.390985094476491210,
       -0.150377186015248300, -0.001219847239553928,  0.442560619674623010,  0.115725661162287000,
       0.217989218421280380, -0.287894675042480230, -0.250583740882575510, -0.105918185785412790,
       0.399260326754301790, -0.132658313028514390, -0.204591886140406130, -0.160332152154296640},

     { 0.148303071502596140,  0.255720472428947690,  0.034761051181703806, -0.400515869725495580,
       0.372111483942717310,  0.345759548246860500,  0.212356545496732000,  0.234213670250028370,
       -0.348670189734548330, -0.421757502947002650, -0.266479554586112500,  0.348329772241413590,
       0.451953836251050230,  0.055142895318567753, -0.095332324504852295, -0.229884283151477580,
       -0.218209048267453910, -0.417779451701790090, -0.338899188674986360,  0.131413765717297790},

     { 0.081000701058655977, -0.396338569000363350, -0.252860572654753920, -0.201010080520063640,
       -0.184233244042843580, -0.003444313537329435,  0.193071734160184860, -0.284972916822880510,
       0.363897373434156180,  0.488479848019778730,  0.054694931022822857,  0.012200444936752319,
       0.244200320448726420, -0.410544017329812050,  0.111684575676918030,  0.116311804857105020,
       0.435215530917048450, -0.175958878826349970, -0.149474524892866610, -0.413454658817499880},

     {-0.097716381773352623,  0.084045920521020889,  0.434875113889575000, -0.145762545522302390,
      -0.360811184160411360, -0.160457210615277290,  0.124353171326220040, -0.079020231962203979,
      -0.078236661851406097,  0.285453982651233670, -0.447606466244906190, -0.497235960792750120,
      0.389115414116531610, -0.200467038899660110, -0.198246040847152470, -0.295117829926311970,
      0.296088648028671740,  0.494825693313032390, -0.080090746749192476,  0.159986021462827920},

     { 0.483305541332811120,  0.474604184739291670, -0.327813533134758470,  0.227505862247198820,
       -0.435939832590520380,  0.283871042542159560, -0.156182332895696160,  0.499275698326528070,
       -0.392087836284190420,  0.194343142211437230, -0.414178960490971800,  0.010195781942456961,
       -0.221610937267541890, -0.479303846601396800,  0.364433236885815860, -0.082422121427953243,
       -0.139761056751012800, -0.011213591787964106,  0.338557646609842780,  0.282002281397581100},

     {-0.225759608671069150,  0.390951180830597880,  0.284766320604830980, -0.336644194554537530,
      -0.309515858069062230, -0.413479720242321490, -0.131762024480849500,  0.486572789959609510,
      -0.418654026929289100,  0.288147229235619310,  0.146558811888098720, -0.435348485130816700,
      0.262751413974910970,  0.318745278753340240,  0.292157377116382120,  0.326811581384390590,
      0.102616321295499800, -0.364024955779314040,  0.326087279710918660,  0.210528485011309390},

     { 0.330318186432123180,  0.411908319219946860, -0.279275733046233650, -0.391292750835418700,
       0.432604473084211350, -0.414842496160417800,  0.026285127736628056, -0.207156583666801450,
       0.073943912517279387, -0.135157225187867880, -0.425154302269220350,  0.348184303846210240,
       -0.244206044357270000,  0.359612018335610630, -0.488459890708327290, -0.053721902426332235,
       0.446132298558950420, -0.120221915189176800, -0.067149112001061440, -0.472521728370338680},

     {-0.332074685953557490, -0.420590300112962720, -0.407870213501155380,  0.430676728021353480,
      0.398154978640377520,  0.384287163615226750,  0.257488309405744080,  0.000771299935877323,
      -0.479737792164087300,  0.083575589116662741, -0.288700215052813290,  0.350580394268035890,
      -0.004516091197729111, -0.067975948099046946,  0.459287643432617190, -0.071911618113517761,
      0.017181556206196547, -0.014427228365093470,  0.220931798219680790, -0.408874531276524070}},

    {{ 0.350415546447038650,  0.295777495950460430,  0.439309772569686170, -0.393790497910231350,
       0.155389514286071060,  0.450849881861358880,  0.052487599663436413,  0.101521812845021490,
       -0.169372033327817920,  0.485338487662374970,  0.129000084940344100, -0.001446718815714121,
       -0.435251812450587750,  0.221129871439188720, -0.070769990794360638,  0.462903166189789770,
       0.105417035520076750, -0.313281680922955270, -0.036325533874332905,  0.125679243355989460},

     { 0.270293908193707470,  0.174974251072853800, -0.023740361910313368, -0.234222183004021640,
       -0.393001696560531850, -0.064452718477696180,  0.193866198882460590,  0.124179859645664690,
       0.421120053157210350, -0.085202002897858620,  0.215305328369140620,  0.271535599604249000,
       -0.289424506947398190,  0.154615100938826800,  0.377745101694017650,  0.365965007804334160,
       0.105464982800185680, -0.069767298176884651, -0.032513179350644350,  0.436092949472367760},

     {-0.084428810514509678, -0.403513094410300250, -0.065353769343346357, -0.019680622499436140,
      0.317616777494549750,  0.363876240327954290, -0.056777456309646368, -0.076966186985373497,
      -0.449405440595000980,  0.406897010281682010, -0.451286943629384040,  0.320888467598706480,
      0.081871261354535818,  0.024972694460302591, -0.413333714939653870,  0.188869564794003960,
      0.460519976448267700,  0.280532483942806720, -0.186950575560331340,  0.381640029605478050},

     {-0.304669518489390610, -0.471645247191190720,  0.153175629675388340, -0.094094025436788797,
      0.182969853747636080,  0.030920731369405985, -0.228129017632454630, -0.211565163452178240,
      0.461153433192521330,  0.239357803482562300, -0.275472213514149190, -0.123275376856327060,
      0.335844709072262050,  0.159174017142504450,  0.357044000644236800,  0.153461486566811800,
      0.023050257470458746, -0.199733455665409560, -0.423504700418561700,  0.073644816875457764},

     {-0.292836445383727550, -0.374791643582284450, -0.105466715060174470,  0.289034816436469550,
      0.150181050878018140, -0.018800429999828339, -0.022095618769526482,  0.110701027326285840,
      -0.238267946057021620,  0.290953806135803460, -0.007658942602574825, -0.042937464546412230,
      0.319308558944612740, -0.354483312927186490,  0.362968510482460260,  0.002278413157910109,
      0.176437418442219500, -0.365160507149994370,  0.290713249705731870,  0.137590852100402120},

     { 0.374197296332567930, -0.484758963808417320, -0.485684524755924940,  0.210042005870491270,
       0.174415053799748420,  0.371359475888311860, -0.136496507562696930, -0.302534688729792830,
       -0.328373979777097700, -0.060001207515597343,  0.271110128611326220, -0.121210424695163970,
       0.065207148902118206, -0.334356586448848250, -0.332175608258694410, -0.284611800219863650,
       0.146842983551323410,  0.145728772971779110,  0.326089227572083470,  0.408575037494301800},

     {-0.063317420892417431, -0.181569715030491350, -0.134362426586449150, -0.244008861482143400,
      -0.036053027957677841, -0.271393916103988890,  0.258269551675766710, -0.359615609515458350,
      -0.136554423253983260,  0.048982801381498575,  0.277975242584943770, -0.262357126455754040,
      0.064223838038742542,  0.292290717829018830,  0.447684879414737220, -0.261361108161509040,
      0.163650193717330690, -0.188811628147959710, -0.063895796891301870,  0.335276214405894280},

     { 0.251187164336442950, -0.292785668279975650, -0.285934210289269690, -0.183605686761438850,
       -0.127142254728823900, -0.118109818547964100,  0.031782513484358788, -0.480299271177500490,
       -0.472381045576184990, -0.142128258943557740,  0.428275766782462600, -0.035698466002941132,
       0.176302026025950910, -0.206086659803986550,  0.220292672514915470, -0.359751001931726930,
       0.022519424092024565, -0.021437775809317827, -0.219366611447185280,  0.385965000838041310},

     {-0.472454974427819250, -0.441391368396580220, -0.376392125617712740,  0.091768863610923290,
      0.350899349432438610, -0.428707246202975510,  0.330407755449414250,  0.014549543615430593,
      -0.117518873885273930, -0.233488040976226330, -0.150174241978675130, -0.366331709548830990,
      -0.026273709256201982,  0.063891547732055187, -0.049937395844608545,  0.346584036480635400,
      0.445781729184091090,  0.481845117639750240,  0.366284765303134920,  0.473400683607906100},

     {-0.160283141303807500,  0.294560532085597520, -0.062297782395035028, -0.483981115277856590,
      -0.411526127718389030, -0.342005109880119560, -0.343732117209583520,  0.110993296373635530,
      0.136557114310562610, -0.063098728656768799, -0.003041702322661877,  0.164102140348404650,
      -0.004490097053349018,  0.120566172059625390, -0.244128996040672060, -0.153590747155249120,
      0.191858926322311160, -0.413721240125596520,  0.360958796460181470, -0.425659947562962770},

     {-0.147209281101822850, -0.289215445518493650, -0.291991657111793760,  0.326517009641975160,
      0.274676102213561530,  0.158070947043597700,  0.173101046122610570,  0.220457831397652630,
      0.139916064683347940,  0.039385811891406775,  0.193858515005558730,  0.479632923379540440,
      -0.166053656022995710, -0.368439266923815010,  0.495651808101683860, -0.077579783275723457,
      -0.210444376803934570, -0.348080309107899670, -0.466586486902087930,  0.426112737972289320},

     { 0.088820962700992823,  0.030371810775250196,  0.090214878320693970, -0.415669134352356200,
       -0.349062016699463130,  0.346085882280021910, -0.069259881507605314,  0.342796909622848030,
       0.432364642154425380, -0.208301085047423840,  0.417136962059885260, -0.214844638947397470,
       0.002483469434082508, -0.374854695051908490, -0.388327628839761020, -0.222840428352355960,
       0.283216252457350490,  0.284773417282849550,  0.497617403045296670, -0.076867682859301567},

     {-0.175840770825743680,  0.191475918516516690, -0.097234759014099836,  0.158105573616921900,
      0.323036651592701670, -0.101582950912415980, -0.419474209658801560, -0.387407725211232900,
      0.050336740445345640, -0.386060696560889480, -0.461294987238943580, -0.360842296853661540,
      0.144311114680022000,  0.128919891081750390, -0.276511431206017730,  0.295249097980558870,
      -0.024994226172566414,  0.154228687752038240,  0.138046007603406910, -0.092629584018141031},

     { 0.445927602704614400,  0.055182969663292170,  0.192525777500122790, -0.051588927395641804,
       0.180328274611383680,  0.304198148660361770,  0.225570644252002240, -0.036455472931265831,
       0.088971565943211317,  0.223188047762960200,  0.386676844675093890,  0.413130795583128930,
       -0.085336033720523119, -0.210557914339005950,  0.071236369200050831, -0.262299382127821450,
       0.187859134748578070,  0.151762159541249280, -0.149707107339054350, -0.261804124806076290},

     { 0.265701462980359790, -0.111002094112336640, -0.122646421659737830, -0.089987422339618206,
       -0.482082203030586240,  0.100842147599905730, -0.294738324359059330, -0.007076429203152657,
       -0.244929164648056030,  0.343307683244347570,  0.400293987244367600, -0.299001561943441630,
       -0.101509347092360260,  0.092819764744490385,  0.149409510660916570, -0.421181072015315290,
       -0.102982086595147850, -0.125019844621419910,  0.042363455053418875,  0.485989479348063470},

     {-0.401831796858459710, -0.070959700271487236,  0.399120274931192400,  0.012832169421017170,
      0.218482385389506820, -0.029643355868756771,  0.250532787293195720, -0.093658479396253824,
      -0.377881196327507500, -0.399174320045858620,  0.144537395797669890,  0.387820267118513580,
      -0.010176414158195257, -0.478109025396406650, -0.202167155221104620,  0.007741383276879787,
      0.122733122203499080,  0.003094520885497332, -0.499335045926272870,  0.377803957555443050},

     {-0.153597795870155100,  0.400958941318094730, -0.421197604387998580,  0.244892857503145930,
      -0.006221293937414885,  0.228211906738579270,  0.323711785487830640,  0.390796619467437270,
      -0.396807937882840630, -0.133924759458750490,  0.376786099281162020, -0.298639734741300340,
      0.295115540735423560,  0.275906374212354420,  0.214192434679716830,  0.013597926124930382,
      -0.253736981190741060, -0.035274778027087450,  0.419939446728676560, -0.131618177518248560},

     { 0.065550901927053928,  0.064476842992007732, -0.243797910399734970, -0.444625511765480040,
       0.086367817595601082,  0.054034934844821692,  0.063115871511399746, -0.290899060200899840,
       -0.442870544269680980,  0.063780825585126877, -0.413095102645456790, -0.096468340139836073,
       -0.035260232631117105, -0.334292707033455370, -0.351575482636690140,  0.458518473431468010,
       0.393919199705123900,  0.472136302851140500,  0.349315093364566560,  0.497111261822283270},

     {-0.161788456141948700,  0.226101192645728590, -0.301528472919017080, -0.366672915406525140,
      0.002007566858083010,  0.412663961760699750,  0.146925010718405250,  0.248270585667341950,
      -0.122610816266387700,  0.066864457912743092, -0.383347591385245320,  0.442940086126327510,
      -0.368658699095249180, -0.127145501784980300,  0.498314574360847470,  0.217709118500351910,
      0.426889433059841390,  0.061430445872247219,  0.426810058299452070,  0.484018888790160420},

     {-0.374788728542625900, -0.486285044346004720, -0.112449450884014370,  0.089951038826256990,
      -0.320577751379460100,  0.035975066479295492,  0.048469512723386288, -0.426658551208674910,
      0.008111369796097279, -0.102215393912047150, -0.429547289386391640,  0.346322913654148580,
      -0.376114201266318560, -0.231075761839747430,  0.479649998247623440,  0.125893365591764450,
      -0.318411800079047680,  0.126575008966028690, -0.125836048275232320,  0.058977384120225906}},

    {{-0.306560533121228220, -0.009183639660477638,  0.001917470246553421, -0.175219232216477390,
      0.363670858554542060,  0.000232044607400894, -0.457510113716125490,  0.290560292080044750,
      -0.438337509520351890,  0.469299944583326580,  0.274579180870205160, -0.313126238062977790,
      0.483014900237321850, -0.337870270013809200,  0.276824801228940490, -0.337562850676476960,
      0.198104796931147580, -0.174705686047673230, -0.264221401885151860, -0.293783833272755150},

     { 0.223078920040279630, -0.193768691271543500, -0.447460919618606570,  0.346964718773961070,
       0.075155546888709068, -0.467810921370983120, -0.027141915634274483,  0.256743747275322680,
       0.158764087595045570,  0.347022036090493200, -0.184278868604451420,  0.352203554939478640,
       -0.162161603569984440,  0.317638601642102000, -0.323015677276998760, -0.298490744549781080,
       -0.182129353750497100, -0.280525790527462960,  0.492069547530263660, -0.120466863270848990},

     {-0.311225845944136380,  0.266648728400468830,  0.066406898666173220, -0.328210945241153240,
      0.428778458852320910, -0.156768300104886290, -0.165773795917630200,  0.126883255783468480,
      0.168526013847440480,  0.070004802197217941,  0.333099422510713340, -0.108395066112279890,
      0.376236110925674440,  0.385638502892106770, -0.261430347338318820, -0.048608341719955206,
      0.417827581521123650,  0.211427737493067980, -0.291864594444632530,  0.076591669116169214},

     { 0.058449773583561182,  0.023856536950916052, -0.071204775944352150,  0.396288170479238030,
       -0.158504861406981950,  0.105779547244310380, -0.402202574070543050,  0.159365784842520950,
       0.325253756716847420, -0.410133026540279390, -0.461101078428328040, -0.485972089227288960,
       0.356515701860189440,  0.105305820237845180, -0.314183034468442200,  0.285294160712510350,
       0.448537520598620180,  0.020043169613927603, -0.087822583504021168,  0.117063534446060660},

     {-0.409952028188854460, -0.254723160993307830, -0.491331531200557950,  0.466284083202481270,
      -0.369084658101201060, -0.252761878538876770, -0.082324258517473936, -0.451257076580077410,
      0.458665858954191210,  0.125811147037893530,  0.125334593001753090,  0.017115633003413677,
      -0.350332316011190410, -0.445870182942599060, -0.086596196517348289, -0.008837177418172359,
      0.159909364301711320,  0.011201229412108660, -0.349471392575651410, -0.014836878981441259},

     { 0.101068202871829270, -0.310572471003979440, -0.000808967743068933, -0.042416095267981291,
       0.294733349233865740,  0.185007997788488860, -0.257121934089809660,  0.243270869832485910,
       -0.294948832131922250,  0.155055482406169180, -0.139665595255792140, -0.204900860320776700,
       0.400332321878522630, -0.130997126456350090, -0.238616777118295430, -0.468752336222678420,
       0.116240995004773140,  0.179058964364230630, -0.420009412337094550,  0.074906854424625635},

     {-0.195129888597875830,  0.205325180664658550, -0.407977512571960690, -0.045462204609066248,
      0.259454997722059490,  0.005426290910691023,  0.445700617972761390, -0.080635637510567904,
      -0.483372479677200320, -0.403770774602890010,  0.404527483507990840,  0.117695723194628950,
      -0.214343245606869460, -0.096281484235078096, -0.424720372073352340, -0.419609895907342430,
      -0.411273485980927940, -0.181842306163161990,  0.323660973925143480, -0.206222318112850190},

     { 0.473213176708668470, -0.316004621330648660,  0.088876821566373110,  0.373545498587191100,
       0.052998252213001251,  0.350260044913738970,  0.404793162364512680, -0.330760752316564320,
       0.029319009277969599,  0.484783750027418140,  0.244146102108061310,  0.334189121145755050,
       0.190108930692076680,  0.336168589536100630, -0.211273083463311200, -0.050436071120202541,
       -0.158405119553208350, -0.265572465024888520,  0.368928291369229560, -0.141777599230408670},

     {-0.169343239627778530,  0.273455774877220390,  0.475918123964220290,  0.116313515231013300,
      -0.322825708892196420, -0.448802248109132050,  0.196703619323670860, -0.234099194873124360,
      -0.130644553806632760,  0.020364593248814344,  0.059678487014025450, -0.157431377097964290,
      0.204359972383826970, -0.351444691419601440, -0.283885878510773180, -0.242641775403171780,
      0.498815353494137530, -0.379092716146260500, -0.073402527719736099,  0.028134363237768412},

     {-0.394308965653181080, -0.329256425611674790, -0.137676515616476540,  0.295799965038895610,
      -0.493087836075574160,  0.151050400920212270, -0.254636106081306930, -0.151492955628782510,
      0.385477935895323750, -0.385707814712077380,  0.206729445140808820, -0.283865303266793490,
      0.387747960630804300,  0.182647569105029110,  0.332448211964219810, -0.435077748261392120,
      0.233845321461558340,  0.029151831287890673, -0.169176943134516480, -0.396799232345074420},

     {-0.450483575463294980,  0.390501543879508970, -0.054230609443038702,  0.253876396920531990,
      -0.460943147540092470,  0.161883512046188120, -0.488765378016978500, -0.462127793580293660,
      0.282790795899927620, -0.062167905736714602,  0.066006569657474756,  0.388481830246746540,
      0.108575669117271900,  0.428330054040998220,  0.184281795751303430,  0.115487833041697740,
      0.079380454961210489,  0.429645689669996500,  0.463994877878576520, -0.035141608677804470},

     {-0.456062124576419590,  0.170724323019385340,  0.180993088055402040,  0.431685836054384710,
      -0.146628107409924270,  0.013441300019621849,  0.496608087792992590, -0.412782785948365930,
      -0.457406868692487480, -0.172568855341523890, -0.309582018293440340, -0.407890444155782460,
      -0.282067311462014910,  0.136187372263520960,  0.345985953230410810, -0.243010459002107380,
      -0.201929115690290930,  0.357220575213432310, -0.205138252582401040, -0.419138319790363310},

     {-0.204947330523282290,  0.360868317075073720,  0.469343510922044520,  0.403628338593989610,
      0.289198371116071940,  0.153625306673347950,  0.019116172101348639, -0.131421173457056280,
      0.083270996343344450, -0.016888950020074844,  0.333437217865139250,  0.127208871766924860,
      -0.346164627000689510,  0.014430305920541286,  0.058894707821309566,  0.007207265589386225,
      -0.472128394059836860,  0.055502795614302158,  0.094424479641020298, -0.429535262752324340},

     { 0.382933940272778270,  0.284842461347579960, -0.337425706908106800, -0.399133371189236640,
       -0.078970166388899088, -0.491439753677695990, -0.142143829725682740,  0.219100717920809980,
       0.365780821535736320,  0.152717917691916230,  0.299962398596107960, -0.339166508521884680,
       0.013586235232651234,  0.269305909518152480, -0.435538169927895070, -0.197215393651276830,
       -0.077068783808499575,  0.083578002173453569,  0.171363432891666890, -0.493797787465155120},

     {-0.433310947846621270,  0.004800650756806135,  0.133411084767431020, -0.279475574381649490,
      -0.480769043322652580, -0.307694207411259410,  0.227731691207736730, -0.452897437382489440,
      0.247808588668704030, -0.177843828685581680, -0.382432700134813790,  0.130742528941482310,
      -0.393001367338001730, -0.219858406577259300,  0.231609158217906950,  0.028028466738760471,
      -0.211298160254955290, -0.410534671507775780, -0.252870815340429540, -0.345517338253557680},

     { 0.242183246184140440, -0.452908416744321580, -0.184683846775442360, -0.244230518583208320,
       0.316397492773830890, -0.120222016703337430,  0.058554088231176138, -0.260671291034668680,
       0.463355985935777430, -0.270082478877156970, -0.254469078034162520, -0.469954961910843850,
       0.234718172345310450,  0.378942006733268500, -0.249430536292493340,  0.253949129022657870,
       -0.428752200677990910,  0.478301155380904670,  0.301051692105829720,  0.319056387990713120},

     {-0.199542673304677010,  0.418618991971015930, -0.050201082602143288, -0.092544040642678738,
      -0.301239414606243370, -0.318591924384236340,  0.435484426096081730, -0.012537574395537376,
      -0.229126595892012120, -0.317386388778686520,  0.141945087350904940, -0.486943349707871680,
      -0.270294805523008110,  0.457261240575462580, -0.231173867825418710, -0.453897312283515930,
      -0.162960776127874850,  0.327380220405757430, -0.214568603318184610, -0.199604790192097430},

     {-0.442702258471399550,  0.030962318647652864, -0.169559751637279990,  0.292015913873910900,
      -0.090095674619078636,  0.081009712070226669,  0.045965043362230062, -0.018847874831408262,
      0.059310867451131344, -0.152983264531940220, -0.199791486840695140,  0.359768194146454330,
      -0.234364272560924290,  0.250007430557161570, -0.232775846030563120, -0.035603686701506376,
      0.431415506172925230, -0.297291419934481380,  0.451858738902956250, -0.297711089719086890},

     {-0.114677808713167910,  0.093803826253861189, -0.284654438961297270,  0.115027386229485270,
      0.051065066829323769, -0.015828306786715984,  0.161130073945969340,  0.388104290701448920,
      -0.188448086380958560,  0.446561470627784730, -0.311500499024987220, -0.131150344852358100,
      -0.022476210258901119,  0.018939749337732792, -0.339134430512785910,  0.387428115122020240,
      -0.400050538592040540,  0.206830612849444150, -0.131419759709388020,  0.159260329324752090},

     {-0.446152651682496070,  0.168788753915578130,  0.019028523471206427, -0.180516924243420360,
      -0.081203815527260303,  0.286252677440643310,  0.283879389055073260, -0.149788308888673780,
      0.488961257971823220,  0.235738127958029510,  0.052500601392239332, -0.125716550741344690,
      -0.170458045788109300,  0.267846162430942060,  0.489310835488140580,  0.380607021041214470,
      -0.247982144355773930,  0.150440909434109930,  0.268711312208324670,  0.063569769263267517}},

    {{ 0.097002380527555943,  0.457210813183337450,  0.432419424876570700, -0.425473829731345180,
       -0.023849437478929758, -0.406715005636215210,  0.461954285390675070,  0.076100023929029703,
       0.300115607213228940, -0.169465473853051660, -0.264639646746218200,  0.353962955530732870,
       0.499323280062526460,  0.254388877190649510, -0.326553968712687490, -0.081880535464733839,
       0.040641554631292820,  0.457325420808047060,  0.268331155646592380,  0.029602812603116035},

     { 0.193063548766076560, -0.179168242495507000,  0.403886262327432630, -0.477394496556371450,
       -0.411322080064564940,  0.393197097815573220,  0.403212524484843020, -0.159304223954677580,
       0.043638007715344429,  0.171923836693167690,  0.404265545308589940, -0.359359611757099630,
       0.129134649876505140,  0.336684970185160640, -0.284833441488444810, -0.394714787602424620,
       0.429969964548945430, -0.322879156097769740,  0.181385236792266370,  0.230085571762174370},

     { 0.007655370049178600,  0.416745590046048160,  0.084048527292907238,  0.006978650111705065,
       0.171134467236697670,  0.257494559045881030,  0.425098115112632510, -0.288223977666348220,
       0.214819979853928090,  0.193429270759224890,  0.241378834936767820, -0.092116471379995346,
       -0.485738971736282110,  0.145265097264200450, -0.069510967936366796, -0.397061051335185770,
       0.038462195545434952, -0.166298442985862490, -0.056365275289863348, -0.417899796739220620},

     {-0.494374606292694810, -0.152099729981273410, -0.277259408496320250,  0.134760044049471620,
      -0.315414759330451490, -0.062092849984765053,  0.240045256447047000, -0.385444794781506060,
      0.115027993917465210, -0.078569506760686636,  0.344640777446329590, -0.377316635567694900,
      -0.161823916248977180, -0.071310695260763168,  0.129662014544010160, -0.490689449012279510,
      -0.313816136214882140,  0.054760129656642675, -0.278913426678627730,  0.401003843639045950},

     {-0.251810599118471150,  0.462465408723801370, -0.191112627275288110, -0.237549570854753260,
      0.107730505988001820,  0.239376404788345100, -0.134610622189939020, -0.353807298466563220,
      -0.426922038197517400,  0.309024102520197630, -0.271707095205783840, -0.421296644024550910,
      -0.343075626995414500, -0.048966503702104092,  0.213463400024920700, -0.158490386325865980,
      0.388940646313130860, -0.046491343528032303, -0.043935181107372046,  0.003968640696257353},

     { 0.374939150176942350, -0.199294403661042450,  0.126652005128562450, -0.286884766072034840,
       0.229394901543855670, -0.243685980327427390, -0.277574215084314350,  0.415578765328973530,
       0.311074149794876580, -0.056487641297280788,  0.316582609433680770, -0.440736449323594570,
       -0.094022232573479414, -0.374530017841607330, -0.178286020178347830, -0.486291726585477590,
       0.364846386946737770,  0.187103358097374440, -0.340099024586379530,  0.437924349214881660},

     {-0.003872539382427931, -0.111806119792163370, -0.483372294809669260,  0.153051833622157570,
      0.339227376971393820,  0.230091105215251450,  0.494561447296291590,  0.228168023284524680,
      -0.316400238312780860, -0.049373733345419168, -0.267863336019217970, -0.441461088135838510,
      0.251331862993538380,  0.358788669109344480, -0.228345854207873340, -0.019273235462605953,
      -0.384897310752421620, -0.005920068826526403, -0.103694469667971130,  0.426176839042454960},

     { 0.437592289876192810, -0.287111860234290360,  0.485440389718860390, -0.156429942697286610,
       -0.161641878075897690, -0.192845630459487440, -0.142721669282764200, -0.296795491129159930,
       0.494257727637887000,  0.017179306130856276, -0.358871141914278270, -0.009614811278879642,
       0.405373186804354190, -0.342243436723947530, -0.356562977656722070,  0.244600563775748010,
       0.387847668491303920, -0.362001529894769190, -0.027231412939727306, -0.428552569355815650},

     { 0.088624736759811640,  0.204905251506716010, -0.370013657491654160, -0.160043400246649980,
       0.063693920616060495, -0.098359511233866215,  0.320683364756405350,  0.178796609863638880,
       0.395720419939607380, -0.283011104911565780,  0.104973448906093840,  0.333312709815800190,
       -0.070122965145856142,  0.090413838624954224, -0.323117232881486420,  0.268235156778246160,
       0.397568208631128070,  0.034161097835749388,  0.471439665649086240,  0.391825936269015070},

     {-0.448659595567733050, -0.387431475799530740, -0.117788875009864570,  0.456713591236621140,
      -0.229674912523478270,  0.025648147799074650,  0.201314155012369160, -0.341827243566513060,
      0.163646617904305460, -0.325917257927358150, -0.270379812922328710, -0.247728645335882900,
      0.378987993579357860, -0.140393470413982870,  0.092227954417467117, -0.057318085338920355,
      0.261247018352150920, -0.087088680826127529, -0.378521475475281480,  0.156967438291758300},

     { 0.129900214262306690,  0.226451973896473650, -0.009719851892441511, -0.440222750883549450,
       -0.183134187478572130,  0.167162915226072070,  0.328012405894696710, -0.285565978847444060,
       -0.298675986472517250,  0.299452072009444240, -0.393740042112767700, -0.247335582040250300,
       0.412020596209913490, -0.011528917122632265, -0.290621990803629160, -0.317654316313564780,
       -0.485880769323557620,  0.410692164208740000, -0.159481559880077840,  0.177765848580747840},

     {-0.415225093718618150,  0.070138627197593451,  0.430037203244864940,  0.463762900326401000,
      0.429745157249271870,  0.022265158127993345, -0.093555185012519360,  0.190992175601422790,
      0.435176477301865820,  0.027923339512199163, -0.152040385641157630,  0.065076692029833794,
      -0.245624686591327190,  0.338239762466400860,  0.124853941146284340,  0.071241126395761967,
      0.005402678158134222, -0.047133652493357658,  0.285675147548317910,  0.206726691685616970},

     {-0.247681580483913420,  0.391935105435550210,  0.459391109645366670, -0.335660984273999930,
      -0.119593811221420760, -0.331230881158262490, -0.153315300587564710, -0.105474580544978380,
      -0.420538716949522500,  0.187203139998018740, -0.427708731498569250, -0.335763810668140650,
      -0.242658232804387810, -0.497671528253704310, -0.372000910341739650, -0.312913075555115940,
      0.024593629874289036,  0.034443904645740986,  0.378079100511968140, -0.040229892358183861},

     {-0.437632755376398560, -0.273961285129189490, -0.475153200328350070, -0.183257441967725750,
      -0.435721522662788630,  0.149700740817934270,  0.387983684428036210,  0.069681155495345592,
      -0.397432911675423380,  0.173658832442015410, -0.223592152819037440, -0.145114492159336810,
      0.065593937877565622, -0.264201043173670770,  0.019224523566663265,  0.446000126656144860,
      -0.095431924331933260,  0.365909223444759850, -0.159474453423172240, -0.015970641281455755},

     { 0.053112363442778587, -0.087183184921741486,  0.148265548516064880,  0.310454130638390780,
       -0.084854713175445795,  0.276264638174325230,  0.497541055548936130,  0.439738917164504530,
       -0.189291456714272500,  0.375620156060904260, -0.100490975193679330, -0.126924212090671060,
       -0.398341129068285230, -0.075644175522029400,  0.189818345941603180, -0.334062651731073860,
       -0.425943434704095130,  0.077802030835300684,  0.235618504229933020, -0.323376345913857220},

     {-0.248539136722683910, -0.487973648589104410,  0.031509161926805973,  0.317054801154881720,
      -0.252174691297113900, -0.449266314040869470,  0.263054928276687860,  0.152393384370952840,
      0.416642909403890370, -0.396419525146484380, -0.363577256444841620, -0.030244727153331041,
      0.016397289931774139,  0.284688292071223260, -0.219790596514940260,  0.431542576756328340,
      0.060952930245548487, -0.222249540966004130,  0.371281493920832870,  0.371661473531275990},

     {-0.346629384905099870, -0.229209481272846460, -0.255262738559395070, -0.244970513973385100,
      0.195146343205124140,  0.434555607847869400, -0.079033165238797665,  0.269202908966690300,
      0.012357638683170080, -0.343414661008864640,  0.445826563052833080,  0.263818501960486170,
      -0.331388309597969060, -0.022664275020360947,  0.080873303115367889, -0.083563000895082951,
      0.028069410938769579, -0.156071768607944250, -0.431169616058468820, -0.055287679657340050},

     {-0.052491293754428625, -0.294746872503310440,  0.414467593189328910,  0.463905996177345510,
      0.489941419567912820, -0.305323002859950070,  0.395448573399335150,  0.050894349813461304,
      -0.027572543825954199,  0.266730067320168020, -0.077444176189601421,  0.125798071734607220,
      -0.462479413487017150,  0.167293085251003500,  0.380827557761222120,  0.232666929718106990,
      0.101848693098872900, -0.198205607477575540,  0.001869838684797287, -0.385793668217957020},

     {-0.041620268486440182, -0.052303598262369633,  0.378024833742529150,  0.126991422381252050,
      0.425032127182930710, -0.041101862676441669, -0.456571578513830900, -0.046898461878299713,
      0.302826368715614080, -0.387741194572299720,  0.397813858930021520, -0.249664924573153260,
      -0.182488067075610160,  0.312281452119350430, -0.285758928395807740, -0.192546647507697340,
      -0.493041550740599630, -0.390310354996472600,  0.358347702771425250, -0.020614094100892544},

     { 0.376419712789356710, -0.219096473418176170, -0.394816022366285320,  0.413940299302339550,
       0.448196611832827330,  0.486011535394936800,  0.146607229020446540,  0.050045305397361517,
       -0.212194071616977450, -0.351522931829094890,  0.164251637179404500,  0.246185659896582370,
       0.096173469908535480,  0.042276471387594938, -0.126822917722165580,  0.021205597091466188,
       -0.498825391288846730, -0.083394495770335197,  0.474307135678827760,  0.304000977426767350}},

    {{ 0.028864309657365084,  0.372120994608849290, -0.445663947146385910,  0.346376243047416210,
       0.184402446728199720, -0.231422875076532360, -0.346170404460281130,  0.191360896453261380,
       -0.121733230073004960, -0.487822701688855890, -0.329253197647631170, -0.245313517283648250,
       -0.206919175107032060, -0.224069220013916490, -0.331373217981308700, -0.258722562808543440,
       -0.238057684618979690,  0.315234011504799130,  0.291322742588818070,  0.049748243764042854},

     { 0.463711079675704240, -0.044425620231777430, -0.204066095873713490,  0.059884549584239721,
       0.497850851155817510,  0.169110986404120920, -0.418909852858632800,  0.499025459866970780,
       -0.414283509366214280, -0.444602717179805040,  0.303026437759399410,  0.114580800756812100,
       0.427518277429044250,  0.357362490613013510, -0.039042956195771694,  0.111920724157243970,
       -0.374060384463518860,  0.114786639343947170, -0.196718379389494660,  0.004206385929137468},

     { 0.126963938120752570, -0.025971577037125826,  0.258892868645489220,  0.420044763013720510,
       0.249959202948957680,  0.427519651129841800, -0.338677799794822930, -0.488098481204360720,
       0.242753662634640930,  0.452644942793995140,  0.061649762559682131,  0.206464742310345170,
       -0.091780676972121000,  0.357583666685968640, -0.233650708105415110, -0.093929825816303492,
       0.026694653555750847, -0.152560560964047910, -0.094904365483671427,  0.112411144189536570},

     {-0.097163278143852949, -0.291877927724272010, -0.273008055053651330, -0.169645000714808700,
      -0.434515437111258510,  0.187948988750576970,  0.442275723908096550, -0.308575821109116080,
      -0.197264371439814570, -0.254442655481398110,  0.195630564820021390,  0.429699566680938010,
      0.219585767947137360, -0.045476566534489393,  0.349744329694658520, -0.030455029103904963,
      -0.117956915404647590, -0.488933469634503130, -0.018553510308265686, -0.375203252770006660},

     { 0.463711473159492020, -0.456903747282922270,  0.331261489540338520, -0.128069203812628980,
       0.400679919403046370, -0.402389218099415300,  0.278000970836728810, -0.072625427041202784,
       -0.054949779063463211, -0.316903394646942620, -0.460214282386004920,  0.347886943258345130,
       -0.108781322371214630, -0.233222337439656260, -0.321758057456463580, -0.043296759482473135,
       0.454726651776582000, -0.379482333548367020,  0.148127419408410790, -0.242537719663232560},

     {-0.133924988564103840, -0.156242015771567820, -0.312838152982294560, -0.414339220616966490,
      0.298281418159604070, -0.463093823287636040,  0.055205750279128551, -0.319675497245043520,
      -0.452027292922139170, -0.463347759563475850, -0.194878749549388890, -0.488315819296985860,
      -0.420251506846398120, -0.363617260009050370, -0.116385023109614850,  0.480428412556648250,
      -0.266006478108465670, -0.338384052272886040, -0.092197014018893242,  0.179043743293732400},

     {-0.155287446919828650, -0.052411296404898167,  0.026930686552077532,  0.235931230708956720,
      0.214366366155445580,  0.205172629095613960, -0.307365528307855130,  0.169093017932027580,
      0.325690296012908220,  0.340761891100555660,  0.426555298268795010, -0.308234692551195620,
      -0.315480124205350880, -0.386282854713499550, -0.222573913168162110,  0.482801293954253200,
      -0.349376677535474300,  0.332631837110966440, -0.336874203290790320, -0.301403970457613470},

     { 0.369284077547490600, -0.031752952840179205, -0.289719789754599330,  0.449032570701092480,
       0.104629787616431710,  0.093895187601447105,  0.429460983723402020,  0.338623309507966040,
       0.255511135328561070, -0.162736030295491220,  0.017667052801698446, -0.399776311125606300,
       0.284852673299610610, -0.455402260646224020,  0.336154919583350420, -0.000780960544943810,
       0.249770368915051220, -0.471210608724504710, -0.331687942147254940,  0.075460664927959442},

     { 0.369551282841712240, -0.405132643878459930,  0.267225972376763820, -0.445928841363638640,
       -0.291415498126298190, -0.455347940791398290, -0.463127547409385440, -0.140792175661772490,
       0.377283896319568160, -0.300001750700175760,  0.057803853880614042,  0.246567974332720040,
       0.168245296925306320,  0.268084064591676000,  0.195600545033812520, -0.227124915458261970,
       -0.138020747806876900,  0.125061528757214550, -0.388501605950295930, -0.382509612478315830},

     { 0.462325498461723330,  0.129165447317063810, -0.282285923603922130,  0.247178171761333940,
       0.173763186670839790, -0.446131003554910420, -0.253602788317948580, -0.076466444414108992,
       -0.417341612279415130, -0.085290730465203524,  0.498994220513850450,  0.452209670562297110,
       0.009576625656336546,  0.266220192890614270, -0.493719170801341530,  0.218161127530038360,
       0.310872252099215980, -0.456846718210726980, -0.422631048131734130,  0.188156148884445430},

     {-0.256848468445241450,  0.135172806214541200, -0.065275876782834530,  0.411396828480064870,
      -0.096743129193782806, -0.369675331749022010, -0.315728086978197100,  0.265236122999340300,
      0.255386197473853830, -0.204229692928493020,  0.382726510521024470,  0.217711695935577150,
      0.424935754388570790, -0.399559412617236380, -0.035110131837427616,  0.098698941525071859,
      -0.345690416172146800,  0.211287079844623800, -0.477767502889037130, -0.263032028451561930},

     {-0.374003650620579720, -0.478773281909525390, -0.310822357423603530,  0.135572975035756830,
      0.287446910981088880, -0.304541528224945070, -0.146265896968543530,  0.098319163545966148,
      -0.261388245970010760, -0.068896945100277662, -0.213524687569588420, -0.018236714415252209,
      -0.433724138885736470,  0.221199435647577050, -0.106839885935187340, -0.030467268079519272,
      0.351524103898555040,  0.077432027086615562, -0.265231145080178980,  0.106910301372408870},

     { 0.373202334158122540, -0.382504634093493220, -0.175378002226352690,  0.298138089012354610,
       -0.282064046710729600,  0.289511865936219690, -0.103162969462573530, -0.127754462882876400,
       0.000798945780843496, -0.080930472351610661,  0.109213508665561680,  0.126795295160263780,
       -0.059703754261136055,  0.298391151241958140, -0.237631729803979400, -0.272256842814385890,
       0.493849623482674360,  0.116102373227477070,  0.326062320731580260, -0.267538622487336400},

     {-0.452794571407139300, -0.387462366838008170,  0.214224663097411390, -0.386518710292875770,
      0.333737068809568880, -0.392615222837775950,  0.083014022093266249,  0.185261172708123920,
      0.184816804248839620,  0.317782877013087270, -0.207828525453805920,  0.058019138406962156,
      0.435278242919594050,  0.116793472319841380, -0.143842772580683230, -0.346785803791135550,
      -0.093694661743938923,  0.252994257956743240,  0.025459733325988054,  0.407104284036904570},

     {-0.327936213929206130, -0.365326757542788980,  0.033899579197168350,  0.112360031809657810,
      0.433064393699169160,  0.296267849393188950,  0.340103188995271920,  0.426914017181843520,
      -0.087629776913672686,  0.166165509726852180, -0.340624605305492880, -0.040424348320811987,
      0.278703142888844010,  0.373600057791918520,  0.073056941386312246,  0.112440211698412900,
      0.480984834954142570, -0.343929036520421500, -0.202298615127801900,  0.165801639202982190},

     { 0.473853840958327050,  0.089872859418392181, -0.276179221924394370,  0.409132083877921100,
       -0.293333668261766430,  0.079978005494922400, -0.437653719447553160,  0.112971669994294640,
       -0.167027736082673070,  0.087806013878434896,  0.020075954031199217,  0.005036049988120794,
       0.222479256335645910, -0.446024466771632430, -0.382603918202221390,  0.155543650500476360,
       0.350243382621556520,  0.457499271258711810,  0.082457667682319880, -0.237386394292116170},

     { 0.123664780985563990,  0.241833062842488290,  0.222189257387071850, -0.097632075659930706,
       0.115433120634406810, -0.204753800760954620, -0.485191863961517810,  0.096417956054210663,
       -0.048682837281376123, -0.187490479089319710, -0.237780404742807150, -0.074828996323049068,
       0.402382380329072480, -0.013959626667201519, -0.165696911979466680, -0.390951287932693960,
       -0.433981620706617830, -0.103350631427019830,  0.222020382061600690, -0.101009356789290900},

     { 0.484455382451415060, -0.257903663907200100,  0.404026693198829890,  0.206934639252722260,
       -0.203928130678832530, -0.478577225003391500, -0.137521710246801380, -0.353684747591614720,
       0.478922046255320310,  0.444935957435518500, -0.091071141883730888,  0.102586827706545590,
       0.186769020278006790, -0.368881884030997750, -0.495045247953385110, -0.197797858621925120,
       -0.073635684791952372, -0.480237111914902930,  0.398620097432285550,  0.377681477926671500},

     {-0.167727590538561340, -0.339160307310521600, -0.197147517930716280, -0.265345210209488870,
      0.146880066487938170,  0.137155570089817050, -0.156296497676521540,  0.212898445781320330,
      -0.466195061337202790, -0.434276115614920850, -0.388110911007970570, -0.481739678885787730,
      -0.192179779056459670, -0.484084217809140680,  0.225194960366934540,  0.103892090264707800,
      -0.462661442812532190, -0.412326749879866840,  0.250207342673093080, -0.483739396091550590},

     {-0.467390791978687050, -0.340863798744976520,  0.118847431614995000,  0.219378228299319740,
      -0.209745682775974270,  0.123802183661609890, -0.478419630322605370,  0.216618632432073350,
      0.143565071746706960,  0.420200467109680180,  0.094300110358744860,  0.475837481208145620,
      -0.418959839735180140,  0.397152592428028580, -0.289507728535681960,  0.227920226752758030,
      0.034308162517845631,  0.054195773787796497, -0.059181327465921640,  0.068113101180642843}},

    {{ 0.119919658172875640,  0.052707761526107788,  0.086373422760516405,  0.427739879116415980,
       0.068623543716967106, -0.188431616872549060,  0.031631969846785069,  0.105962100904434920,
       -0.100758366286754610, -0.218160687480121850,  0.122222704812884330, -0.068149158265441656,
       -0.059024486225098372, -0.258929863572120670, -0.348770929966121910,  0.231229830998927350,
       0.364872320089489220, -0.327190559823066000, -0.052151536568999290,  0.008437392301857471},

     {-0.406990092713385820, -0.457851425744593140, -0.015725126489996910, -0.325949932448565960,
      0.439301166683435440,  0.194767144974321130,  0.401970294304192070, -0.026390670333057642,
      -0.251037081237882380, -0.157211033161729570, -0.458277569152414800,  0.368882577400654550,
      0.395496728364378210,  0.128095853608101610,  0.296622456517070530, -0.035879727918654680,
      0.439664237201213840, -0.171745573636144400, -0.429917626548558470, -0.161094129085540770},

     { 0.110093739349395040,  0.192305078264325860,  0.270756712649017570, -0.448930746875703330,
       0.433375215157866480,  0.421985782682895660,  0.282299084588885310,  0.298247535247355700,
       -0.405204777140170340, -0.269852451980113980, -0.193315072450786830, -0.312194869387894870,
       -0.227703877724707130,  0.290959801524877550, -0.138144801836460830, -0.288402710575610400,
       -0.014273053500801325, -0.236174507066607480,  0.185206619091331960,  0.234689865726977590},

     { 0.106614459771662950,  0.226929049938917160,  0.103572443127632140,  0.002111188601702452,
       -0.144975095987319950, -0.099805100355297327,  0.466231460683047770, -0.205310858786106110,
       0.228449326474219560, -0.463686165865510700,  0.133595012128353120, -0.161456934176385400,
       0.228618912864476440, -0.095648275222629309, -0.110387681052088740,  0.161994128022342920,
       -0.173662492539733650, -0.328088596463203430, -0.039758336730301380, -0.078867269214242697},

     {-0.097941047977656126,  0.266926591284573080,  0.108937861397862430,  0.174355074297636750,
      0.057886392809450626,  0.470793059561401610,  0.385952363722026350, -0.456386660691350700,
      -0.265381447505205870,  0.071158982813358307,  0.278303205035626890,  0.341233012732118370,
      -0.201911966782063250, -0.118124351836740970, -0.156655798666179180,  0.153112937230616810,
      0.282070548273622990, -0.190424337983131410,  0.447802078444510700,  0.010519874747842550},

     {-0.154110503382980820,  0.081397090572863817,  0.349062940571457150, -0.425491590518504380,
      0.485748815350234510, -0.261324740480631590,  0.236502537503838540, -0.187913677189499140,
      -0.089413336478173733, -0.303255799226462840,  0.233219053596258160,  0.312645615544170140,
      0.463670792058110240, -0.157843085005879400, -0.012999310158193111,  0.021557184867560863,
      -0.187050024978816510, -0.127046945970505480,  0.065170524641871452,  0.047568527515977621},

     { 0.444112036842852830, -0.156526270322501660, -0.111198459751904010, -0.257799929939210410,
       0.225349378306418660,  0.232145741581916810,  0.395313007291406390,  0.007419926580041647,
       -0.458278595935553310,  0.343115085735917090, -0.482060198672115800, -0.112389099318534140,
       -0.075487823691219091,  0.367002741899341340, -0.037880689837038517, -0.089739008340984583,
       -0.394321998581290250, -0.301378152333199980,  0.222347314935177560,  0.016264664940536022},

     {-0.104633951559662820, -0.044433631468564272, -0.171089719515293840, -0.140963159035891290,
      0.297723283991217610,  0.315910970792174340,  0.380594025831669570, -0.389326740987598900,
      -0.311135975178331140, -0.054235449526458979,  0.158241786528378730, -0.367023938335478310,
      0.289238280616700650, -0.452956672757864000, -0.124823867809027430,  0.014587658923119307,
      0.279189068824052810, -0.229510860517621040, -0.477992414496839050,  0.320910472888499500},

     {-0.386395774316042660, -0.460052613168954850, -0.291478626430034640,  0.038116401992738247,
      0.406950128730386500,  0.170640683732926850,  0.448377394117414950, -0.487371869850903750,
      0.369262531399726870,  0.170724709052592520,  0.028892795555293560, -0.235371419694274660,
      -0.373708922415971760,  0.357803076039999720,  0.123665421269834040,  0.424014361575245860,
      0.173714046832174060,  0.004259447101503611, -0.465312379412353040,  0.362578071653842930},

     { 0.450023998040705920,  0.192929407581686970,  0.495554133784025910,  0.239262278657406570,
       0.239972734823822980, -0.129269734025001530, -0.246150062419474120,  0.019161803647875786,
       0.141219405457377430, -0.224142476916313170, -0.159927722997963430,  0.254823631141334770,
       -0.184195090085268020,  0.048593650572001934, -0.207059966400265690, -0.277244961354881530,
       -0.280765665229409930, -0.258682572282850740, -0.264616831205785270, -0.411503133829683070},

     { 0.412042136769741770,  0.264275964349508290, -0.146874553523957730, -0.461666785646229980,
       0.122079040855169300,  0.476790867745876310,  0.462347576394677160, -0.204206912312656640,
       -0.018949684686958790,  0.497035196982324120, -0.341628840193152430, -0.068925686646252871,
       0.189964604564011100, -0.346074706409126520, -0.329663407988846300, -0.070062660612165928,
       0.024655559565871954, -0.075813470408320427,  0.449099143501371150, -0.334125034976750610},

     { 0.200044052675366400, -0.210828579496592280,  0.420698596630245450, -0.484151037409901620,
       0.337765071075409650, -0.286361369770020250, -0.261395998764783140, -0.443000594154000280,
       -0.045043942052870989, -0.026012829970568419, -0.354503727518022060, -0.133001805283129220,
       -0.261736865155398850, -0.001378281041979790, -0.094668590929359198,  0.360342175699770450,
       -0.024587412830442190, -0.132321014534682040, -0.343864736612886190,  0.456462902482599020},

     {-0.135285817086696620, -0.185493576806038620, -0.112462784163653850, -0.445321212522685530,
      -0.031568283215165138,  0.057873807847499847, -0.015383872669190168,  0.493087276350706820,
      0.482060337439179420, -0.066284729167819023, -0.341037758160382510,  0.182104390114545820,
      0.222886691335588690, -0.420339161530137060,  0.197953352704644200,  0.060651762410998344,
      -0.206700531300157310,  0.436557353939861060,  0.117651168722659350,  0.248255526646971700},

     {-0.089455476030707359,  0.263147441204637290, -0.384746278636157510,  0.148807658813893800,
      -0.238230839837342500,  0.020585130434483290,  0.009149834513664246,  0.237181747332215310,
      0.388264116365462540,  0.165285098366439340,  0.193644649814814330, -0.247021700721234080,
      0.479791521560400720, -0.418818134348839520, -0.192342913243919610, -0.051776761189103127,
      0.139055673498660330,  0.292273214086890220, -0.058689484838396311,  0.121116010937839750},

     {-0.274011515080928800,  0.100272757001221180, -0.196779598947614430,  0.448875176254659890,
      0.179933595471084120, -0.498826246242970230,  0.009526939131319523,  0.473233064170926810,
      0.437731107696890830, -0.372821892146021130,  0.221488590817898510, -0.151724367868155240,
      0.390325549058616160,  0.336742312181741000,  0.497083290945738550, -0.347905290778726340,
      -0.142672556918114420,  0.006233125925064087,  0.389276457019150260, -0.254408440552651880},

     {-0.328481775708496570,  0.082921106833964586, -0.001430141273885965, -0.348690254148095850,
      0.164102972950786350,  0.306226945482194420,  0.099532984662801027, -0.196841353550553320,
      0.098500160034745932, -0.459156499709934000,  0.424274657852947710,  0.324488644953817130,
      0.141116257291287180, -0.272504941094666720,  0.273363821674138310, -0.178950146771967410,
      -0.271331186871975660, -0.217109239194542170, -0.205717082601040600, -0.333600079175084830},

     {-0.089931131340563297, -0.484228491317480800,  0.014675552956759930, -0.199605582281947140,
      0.352513820864260200,  0.011758844368159771, -0.047510873060673475, -0.290158736053854230,
      -0.482008029706776140, -0.158234416041523220, -0.044567176606506109, -0.310489805415272710,
      0.424686691258102660,  0.454002682119607930, -0.159180059563368560,  0.088789664208889008,
      0.260229628067463640,  0.440352925565093760,  0.391948310658335690, -0.141270211897790430},

     { 0.481196425855159760,  0.316222968511283400, -0.316781566943973300,  0.122312683146446940,
       -0.456281972117722030,  0.456582254730165000,  0.443362536374479530, -0.227613158989697690,
       -0.260526984464377160, -0.262354545760899780, -0.061213238164782524,  0.149541884195059540,
       -0.246583037078380580,  0.453462315257638690,  0.449936301913112400, -0.394069216214120390,
       -0.034778840374201536, -0.097574570681899786, -0.184227951802313330, -0.016786870080977678},

     { 0.244191013276577000,  0.271204871591180560,  0.172723324503749610,  0.168877704534679650,
       0.225207554176449780, -0.486456735059618950, -0.242332631256431340, -0.014562817756086588,
       0.453896190505474810, -0.350384320132434370,  0.344166970346122980,  0.435092616360634570,
       0.465838648378849030, -0.472614596597850320,  0.057405299972742796, -0.490443323738873000,
       0.483967658597975970,  0.000767836347222328, -0.218056482728570700, -0.276559325866401200},

     { 0.238413290586322550,  0.220730279572308060,  0.372982558794319630,  0.491830253507941960,
       0.174192594829946760,  0.322918860707432030, -0.402238962240517140, -0.360586245544254780,
       -0.274655709974467750, -0.086466914042830467,  0.122626884374767540,  0.469535303767770530,
       -0.315262042451649900, -0.204649791121482850,  0.138413008302450180,  0.409945511724799870,
       -0.191106526181101800,  0.396080377511680130, -0.104617306031286720, -0.237210335209965710}},

    {{-0.454303942620754240, -0.260450335685163740, -0.302117718849331140, -0.488465294241905210,
      -0.233064931817352770,  0.255287581123411660, -0.478908617515116930, -0.249097273219376800,
      -0.243944582063704730, -0.196965100243687630, -0.025656599085777998,  0.494468708522617820,
      -0.476234820671379570, -0.152674040291458370,  0.486298962496221070,  0.197957774158567190,
      -0.329755179118365050, -0.415939999744296070,  0.337371528614312410, -0.104410889092832800},

     {-0.002406913787126541, -0.040001587010920048, -0.134875585325062270,  0.182331043761223550,
      0.255348621867597100, -0.496462576556950810,  0.092276555951684713, -0.435757903847843410,
      0.399617800954729320,  0.487659249920398000, -0.172968239057809110,  0.445313858333975080,
      -0.272791085299104450,  0.024914042092859745,  0.456848564092069860, -0.005856017116457224,
      -0.219798376318067310,  0.477939946576952930,  0.245046709664165970,  0.036257041618227959},

     {-0.219025153201073410, -0.280609889421612020,  0.030725750140845776, -0.195259973872452970,
      0.066716070752590895,  0.017024712637066841, -0.497302199248224500,  0.236960891634225850,
      0.101084712892770770,  0.340069329366087910, -0.367449997458606960, -0.401322200894355770,
      -0.199932257179170850, -0.002325582318007946,  0.281008843332529070, -0.444583635311573740,
      0.001211841125041246, -0.126714600715786220, -0.380341539159417150, -0.099170357920229435},

     {-0.139055350795388220, -0.053309778217226267, -0.153856499586254360,  0.088153563905507326,
      0.471604264341294770, -0.197007935494184490, -0.417702453210949900, -0.248194111976772550,
      -0.219067988451570270,  0.327344256453216080,  0.288062929641455410,  0.061906858347356319,
      -0.453265632502734660, -0.181211320217698810,  0.366646884474903350,  0.113450438249856230,
      0.335813392885029320,  0.369344685226678850, -0.149588670115917920, -0.063101894222199917},

     { 0.209414015058428050, -0.017038667574524879,  0.035575905349105597, -0.490518242120742800,
       0.480635750107467170, -0.183415251318365340, -0.435101877432316540, -0.018152408767491579,
       0.189870147965848450, -0.315443416126072410,  0.382677233312278990, -0.449185202829539780,
       0.131246805656701330, -0.271179266273975370,  0.138968361541628840,  0.102851069997996090,
       0.031812798697501421,  0.221265908330678940,  0.354656958021223550,  0.312744810245931150},

     { 0.048610165249556303,  0.142719887662678960, -0.125348331406712530,  0.095344532746821642,
       0.461508567910641430, -0.258701446931809190, -0.291205029003322120,  0.297321960795670750,
       -0.389356761239469050,  0.059206300880759954, -0.265779933426529170,  0.320057253818959000,
       -0.457832366693764930,  0.269795971922576430,  0.329539011698216200, -0.477196616120636460,
       -0.413619279395788910,  0.394437134265899660,  0.004650975111871958,  0.276250868570059540},

     {-0.421006281860172750, -0.112671791110187770,  0.327065666206181050,  0.210240524262189870,
      0.116148942615836860, -0.033965972252190113, -0.186908405739814040, -0.352038258686661720,
      -0.312700063921511170, -0.332251447252929210,  0.460706551559269430,  0.235910101328045130,
      0.310468440409749750, -0.164641779847443100, -0.168745365925133230,  0.271977008320391180,
      0.076656773686408997,  0.040049605071544647,  0.069298969116061926,  0.187300012446939950},

     {-0.400744094047695400,  0.303519036155194040,  0.007357266265898943, -0.358576460275799040,
      0.073315008077770472, -0.163103722035884860, -0.335773076396435500,  0.159695729147642850,
      -0.268666587769985200,  0.168877898715436460, -0.064053402282297611, -0.189672869164496660,
      -0.443793892394751310, -0.236987736076116560, -0.479432344902306800,  0.172355050686746840,
      0.229046291671693330, -0.166340750642120840,  0.320316792000085120,  0.416346228215843440},

     { 0.001407802104949951,  0.281023344025015830,  0.152256329543888570, -0.188123757019639020,
       -0.383618435822427270,  0.483510964084416630, -0.416146748699247840,  0.193038337863981720,
       0.023560569155961275,  0.153152220882475380, -0.119661649689078330,  0.122816475573927160,
       -0.043328742962330580,  0.387695616576820610,  0.264240015298128130, -0.470013734884560110,
       -0.275408105459064250,  0.428466938901692630,  0.189681994263082740, -0.044074692763388157},

     { 0.097344837617129087, -0.374371407553553580,  0.266252438072115180,  0.153550945688039060,
       -0.111359143629670140,  0.286820093169808390, -0.174094003625214100, -0.382312851492315530,
       -0.379520657472312450, -0.353777211625128980, -0.465966623276472090,  0.121887145098298790,
       0.427246132399886850,  0.186289706267416480,  0.433763388078659770, -0.456372302956879140,
       0.169800670351833110, -0.482383360620588060,  0.236666034907102580, -0.306638760026544330},

     { 0.170768860261887310, -0.382995614316314460,  0.316177715547382830, -0.372559882700443270,
       -0.495299997739493850,  0.080417730845510960, -0.342573617119342090, -0.270708102732896800,
       0.008884669747203588,  0.347108377143740650,  0.185217204503715040, -0.393770492635667320,
       0.472736969590187070, -0.048530357424169779,  0.259780453052371740, -0.138622173573821780,
       -0.261710264254361390, -0.414313550572842360, -0.020935025066137314, -0.141230921726673840},

     {-0.268090761732310060,  0.013098351657390594,  0.480656223371624950, -0.340844629332423210,
      -0.300611942075192930,  0.414419611450284720, -0.297216932289302350,  0.369188728742301460,
      0.432036251295357940,  0.439449103083461520, -0.437450031284242870,  0.102805111557245250,
      -0.443546511232852940,  0.378727684263139960,  0.230245229322463270, -0.438846508972346780,
      -0.040854584891349077,  0.387671612203121190, -0.209554611705243590,  0.468030084855854510},

     { 0.234779989346861840,  0.475662592798471450, -0.425740407779812810,  0.207516959402710200,
       -0.072867764625698328,  0.334040045738220210, -0.431105214171111580,  0.165421971119940280,
       0.419726495165377860,  0.047959760762751102, -0.475808950141072270, -0.348364266566932200,
       -0.438941887579858300, -0.495152726769447330, -0.189208895433694120, -0.239553829655051230,
       0.419266885146498680,  0.013574172277003527, -0.370365100912749770,  0.351303136441856620},

     {-0.046976724639534950, -0.307815132196992640, -0.045891752000898123,  0.009476764127612114,
      -0.429087447933852670, -0.315646522678434850,  0.070630255620926619,  0.030057967174798250,
      -0.427974910475313660,  0.361075643915683030, -0.001911947969347239,  0.306805079337209460,
      0.336738237179815770,  0.072347644716501236,  0.014322038739919662, -0.236129527445882560,
      -0.093612309545278549,  0.083216824568808079,  0.429292444139719010, -0.173885814379900690},

     {-0.368823414668440820,  0.453483493998646740, -0.022250080481171608, -0.307765302248299120,
      0.458330767229199410,  0.288541024085134270, -0.047319131903350353,  0.377597652375698090,
      -0.197884803637862210,  0.082315767649561167,  0.228900788817554710,  0.255138472188264130,
      0.274500635452568530, -0.316990962717682120, -0.235384763684123750,  0.345413187984377150,
      -0.132637485396116970,  0.335245491936802860, -0.124528844840824600, -0.060612395405769348},

     { 0.196321136318147180,  0.373559207655489440, -0.253807316068559890,  0.033059373497962952,
       -0.054093147628009319,  0.260514722671359780,  0.296929846052080390,  0.352294542826712130,
       -0.156268452759832140,  0.226222290191799400, -0.321591271553188560, -0.025091867428272963,
       0.179705784190446140,  0.156158647965639830,  0.167142830323427920,  0.138036551885306840,
       -0.055300327949225903, -0.380176301579922440,  0.015634204261004925,  0.246814868878573180},

     { 0.202139466069638730, -0.255465006455779080,  0.001953341066837311, -0.023359898012131453,
       -0.072455969173461199,  0.266568577382713560, -0.177946710027754310,  0.294906545430421830,
       0.101814069785177710,  0.197524445131421090, -0.265705849975347520, -0.201864793896675110,
       0.071083652786910534, -0.019513166043907404,  0.331194579601287840, -0.483009494841098790,
       -0.258998443372547630,  0.128124425653368230,  0.369285047985613350,  0.084733103867620230},

     {-0.145653283689171080, -0.452306223101913930, -0.440358763560652730, -0.465947499498724940,
      0.203852424863725900,  0.226784066762775180,  0.172089052386581900, -0.351447902619838710,
      0.346607765648514030, -0.312276742886751890,  0.395366966258734460,  0.048747231718152761,
      -0.067741749342530966, -0.102679692674428220, -0.474612666293978690,  0.359802281484007840,
      -0.336111115291714670, -0.152559376321733000,  0.154708826914429660,  0.265702954493463040},

     {-0.455034930724650620,  0.389002977404743430, -0.436161839403212070,  0.116048722062259910,
      -0.130510188639163970,  0.395032740198075770,  0.133039227686822410,  0.110491368453949690,
      0.023157166317105293,  0.002324275672435760, -0.304775527678430080,  0.377503882627934220,
      0.050018052570521832, -0.245134290773421530,  0.411556383129209280, -0.246129522100090980,
      0.481649775989353660,  0.083645435981452465, -0.097577424719929695,  0.328257541637867690},

     { 0.271368693094700570, -0.202210458461195230, -0.122995226178318260, -0.296373056247830390,
       0.195109848864376540, -0.097607892472296953, -0.436570774763822560,  0.358998733572661880,
       0.249832731671631340,  0.218138052150607110,  0.124701688531786200,  0.294797800946980710,
       0.107141029555350540,  0.188539849128574130, -0.089153476990759373,  0.476630841381847860,
       0.083572589792311192, -0.456114249303936960,  0.087122209835797548, -0.393270243890583520}},

    {{ 0.046210026834160089,  0.282346682157367470,  0.484233638737350700, -0.403771920595318080,
       -0.462787608616054060,  0.395790021866559980, -0.149901442695409060, -0.481137832161039110,
       -0.020564542151987553,  0.252521132584661250,  0.347119709476828580, -0.249195849057286980,
       -0.449689325876533990, -0.275875516701489690, -0.045568905305117369,  0.245420522987842560,
       0.126516591291874650,  0.017860319931060076,  0.104419257026165720, -0.123650677036494020},

     {-0.264001627452671530, -0.270879054442048070, -0.328852876089513300,  0.343139402102679010,
      0.417660794686526060,  0.081993646919727325,  0.319770243484526870,  0.001233384478837252,
      0.125879398081451650, -0.093107546679675579,  0.107963140588253740, -0.327910575084388260,
      -0.310760864056646820,  0.092196779325604439, -0.231682495679706340, -0.273548472672700880,
      -0.012013198342174292,  0.118416062090545890, -0.254686304833740000,  0.467422259505838160},

     {-0.129062805324792860, -0.407566594891250130, -0.281773589085787530, -0.078752130735665560,
      -0.183442111592739820,  0.172657505609095100, -0.333331607747823000,  0.443074479699134830,
      -0.309482173994183540,  0.271087649278342720, -0.180576197337359190, -0.073483801446855068,
      -0.499791405163705350, -0.009429073426872492, -0.230344399344176050,  0.417869389988482000,
      -0.427435426041483880, -0.410574155393987890, -0.080897225532680750,  0.198443972039967780},

     {-0.003681702073663473, -0.472934084478765730,  0.370533396955579520,  0.185557433869689700,
      0.119262694846838710, -0.361149098724126820,  0.412008961662650110, -0.392750503495335580,
      0.257266963366419080, -0.342677343171089890, -0.425328243523836140, -0.371795841492712500,
      -0.250243938062340020, -0.207101832609623670,  0.049452027771621943,  0.066313950810581446,
      0.465555672999471430,  0.216120420023798940,  0.009388430509716272, -0.343926500994712110},

     {-0.012791930232197046,  0.328812233638018370,  0.082589697558432817, -0.012583335395902395,
      -0.180616839788854120,  0.352245298679918050, -0.094713945407420397, -0.108052265830338000,
      0.441671143285930160,  0.324388829525560140, -0.409608293790370230, -0.062010558787733316,
      0.351454745046794410,  0.460925103165209290, -0.376453124452382330, -0.029282560106366873,
      -0.400223995093256240, -0.464444162789732220,  0.077966936863958836,  0.357042968273162840},

     {-0.307121505960822110,  0.152638693340122700,  0.485247126780450340, -0.057365443557500839,
      0.445536860730499030,  0.034699154552072287, -0.491051492746919390,  0.411092533729970460,
      -0.249180424958467480,  0.018336937762796879, -0.432833966799080370,  0.238027644809335470,
      -0.152850828599184750,  0.149755730759352450, -0.274555690586566930,  0.166532332077622410,
      0.002001029439270496,  0.130730364471673970, -0.441519933752715590, -0.056327827274799347},

     {-0.044880806002765894, -0.351128227077424530,  0.381661614403128620, -0.193426060955971480,
      -0.390203123912215230, -0.494791510049253700,  0.277291378937661650, -0.290427119005471470,
      -0.459235672838985920, -0.144741684198379520, -0.433384150266647340, -0.266357178799808030,
      -0.492102990858256820, -0.448137023486196990,  0.176277377642691140,  0.453433869872242210,
      0.086562131531536579,  0.185225884895771740,  0.364526404067873950,  0.337381706573069100},

     {-0.296437176875770090,  0.431692437268793580,  0.075409351382404566,  0.050711994525045156,
      0.081448168028146029,  0.300853660795837640, -0.282755673397332430, -0.416550802066922190,
      -0.068415974732488394, -0.224275606684386730,  0.027121370658278465,  0.386703219264745710,
      -0.075403833761811256, -0.091217014938592911, -0.306722841691225770,  0.034393042325973511,
      -0.086008524987846613,  0.470568537712097170,  0.243965923786163330, -0.045244197826832533},

     {-0.174173146486282350,  0.310581773519515990,  0.188398623839020730, -0.166276136878877880,
      0.362444750033319000, -0.135323998518288140, -0.212842267006635670, -0.050993118435144424,
      -0.450098113156855110, -0.348315862938761710, -0.213611411862075330, -0.246535290032625200,
      -0.416623425669968130,  0.361797939520329240,  0.304176704492419960,  0.164824742823839190,
      0.162651600781828170, -0.478578968439251180,  0.248273940756917000, -0.405764373950660230},

     {-0.202854575123637910, -0.224604688584804530,  0.480938845779746770,  0.221741591114550830,
      0.184178296942263840, -0.325783995911479000, -0.243865366559475660, -0.401830228045582770,
      -0.355215458199381830, -0.499899442773312330,  0.052925574593245983, -0.029388604220002890,
      0.310682330746203660, -0.258675801567733290,  0.304335258901119230,  0.173127081245183940,
      0.106000199913978580, -0.408507008105516430, -0.377866037189960480,  0.155902086757123470},

     {-0.256822870578616860, -0.091477448586374521,  0.409366796724498270, -0.173446296248584990,
      -0.229679509066045280,  0.213543501682579520,  0.491378446575254200,  0.432972091715782880,
      0.234964533243328330,  0.239652387332171200, -0.472792281769216060, -0.467890041880309580,
      -0.484952300786972050, -0.491853435989469290,  0.253851549234241250,  0.199225996155291800,
      -0.317637431900948290, -0.490013817325234410,  0.297395768109709020, -0.172852889634668830},

     {-0.489913259632885460, -0.149678657297044990,  0.297758506145328280,  0.320769071113318200,
      0.091645541135221720,  0.102093765046447520, -0.006103847641497850, -0.302354258485138420,
      0.193586756940931080,  0.116030115634202960,  0.353547828271985050,  0.436763886362314220,
      -0.475447332952171560,  0.262914625462144610, -0.236682409420609470, -0.205126842018216850,
      -0.023541872855275869, -0.245303962845355270, -0.272154749836772680, -0.288577339611947540},

     { 0.494348424952477220, -0.244947031605988740, -0.256467381492257120, -0.490603875834494830,
       -0.236800467595458030,  0.497384167741984130,  0.208622120320796970, -0.054437899496406317,
       -0.492629649583250280,  0.006017888430505991,  0.272709210868924860, -0.482542909216135740,
       0.356339231599122290,  0.070467717014253139,  0.338226162362843750, -0.052015227265655994,
       -0.327438517939299350, -0.167877685278654100,  0.145630514249205590,  0.366148239467293020},

     { 0.448152430355548860, -0.000821657013148069,  0.302912125829607250,  0.472705097403377290,
       -0.237907031551003460, -0.433770283591002230, -0.232421744149178270,  0.238551095593720670,
       -0.179074245970696210, -0.004576493985950947,  0.449973755981773140, -0.184725821018218990,
       0.250476474408060310, -0.306493625510483980, -0.175329696852713820, -0.486323993187397720,
       -0.309109457768499850, -0.466707576531916860, -0.040761892683804035, -0.301739107351750140},

     { 0.039310311898589134, -0.268052681349217890, -0.284282016102224590, -0.104350456502288580,
       0.302415035665035250, -0.446055853739380840,  0.343634316697716710,  0.474976518191397190,
       -0.113933539018034930, -0.010735169053077698,  0.341124757658690210, -0.165781108196824790,
       0.488443173933774230,  0.144036883488297460, -0.193076010793447490, -0.249463857617229220,
       0.210266600362956520,  0.074502245057374239,  0.489087237976491450, -0.468807645607739690},

     {-0.430074248928576710,  0.439060993958264590, -0.153533466625958680,  0.320402225479483600,
      -0.367432631552219390,  0.171136836521327500,  0.334078232292085890, -0.176542089320719240,
      0.204429259989410640, -0.206683659926056860,  0.021718803793191910, -0.256260428112000230,
      0.025263658724725246,  0.237436787690967320,  0.139389115851372480, -0.172321305610239510,
      0.291380933951586480, -0.016976567450910807, -0.197344787418842320, -0.322552605066448450},

     { 0.472288263496011500, -0.356220029760152100,  0.011666286736726761,  0.460731437895447020,
       0.287816854193806650,  0.318590276408940550, -0.288732419721782210, -0.001916545443236828,
       -0.106907478533685210, -0.299645181279629470,  0.029275808949023485, -0.036981726996600628,
       -0.360584187321364880,  0.375742342323064800, -0.216579501517117020, -0.228016818407922980,
       0.046879178844392300, -0.382501268759369850,  0.095441092271357775, -0.248691561166197060},

     {-0.089184928685426712, -0.382840103935450320, -0.004951989278197289,  0.436078730039298530,
      0.354596683755517010, -0.365562873426824810, -0.236242575570940970,  0.145977617707103490,
      0.117460559122264390,  0.066412637475878000,  0.323425013106316330,  0.089748823083937168,
      0.210192607715725900, -0.164908700156956910,  0.050480260979384184, -0.001990538090467453,
      -0.346318423748016360,  0.261747841257601980,  0.496092916466295720,  0.046774098183959723},

     { 0.462102659977972510,  0.025368725415319204, -0.490207628812640910, -0.398481526877731080,
       -0.098888932261615992, -0.206787130329757930, -0.126498345285654070,  0.447990246582776310,
       -0.089288399089127779,  0.468942746985703710, -0.300701314583420750,  0.321526672225445510,
       -0.413897356484085320,  0.194346696604043250,  0.257605402264744040,  0.440699327271431680,
       0.328783823177218440, -0.478637172840535640,  0.086676945444196463, -0.053755617234855890},

     { 0.087775464635342360, -0.089898041449487209, -0.464006794150918720, -0.202031927648931740,
       0.245193258393555880,  0.086473466828465462,  0.295977534726262090,  0.398874835111200810,
       -0.151778691913932560,  0.292070451192557810, -0.054351066704839468, -0.189676031470298770,
       -0.182560822926461700, -0.044558695517480373, -0.088157558348029852,  0.218550244811922310,
       0.248654174152761700,  0.285344096366316080,  0.166540491860359910, -0.340634224470704790}}
};


/*
 * Local Variables:
 * mode: C
 * tab-width: 8
 * indent-tabs-mode: t
 * c-file-style: "stroustrup"
 * End:
 * ex: shiftwidth=4 tabstop=8
 */
