/*                 FaceBound.h
 * BRL-CAD
 *
 * Copyright (c) 1994-2021 United States Government as represented by
 * the U.S. Army Research Laboratory.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this file; see the file named COPYING for more
 * information.
 */
/** @file step/FaceBound.h
 *
 * Class definition used to convert STEP "FaceBound" to BRL-CAD BREP
 * structures.
 *
 */

#ifndef CONV_STEP_STEP_G_FACEBOUND_H
#define CONV_STEP_STEP_G_FACEBOUND_H

#include "TopologicalRepresentationItem.h"

// forward declaration of class
class Loop;
class ON_BoundingBox;
class ON_Brep;

class FaceBound : public TopologicalRepresentationItem
{
private:
    static string entityname;
    static EntityInstanceFunc GetInstance;

protected:
    Loop *bound;
    int ON_face_index;
    bool inner;
    Boolean orientation;


public:
    FaceBound();
    virtual ~FaceBound();
    FaceBound(STEPWrapper *sw, int step_id);
    void SetInner() {
	inner = true;
    };
    void SetOuter() {
	inner = false;
    };
    bool IsInner() {
	return inner;
    }
    bool IsOuter() {
	return !inner;
    }
    ON_BoundingBox *GetEdgeBounds(ON_Brep *brep);
    bool Load(STEPWrapper *sw, SDAI_Application_instance *sse);
    virtual bool LoadONBrep(ON_Brep *brep);
    virtual void Print(int level);
    bool Oriented();
    void SetFaceIndex(int index) {
	ON_face_index = index;
    };

    //static methods
    static STEPEntity *Create(STEPWrapper *sw, SDAI_Application_instance *sse);
};

#endif /* CONV_STEP_STEP_G_FACEBOUND_H */

/*
 * Local Variables:
 * tab-width: 8
 * mode: C
 * indent-tabs-mode: t
 * c-file-style: "stroustrup"
 * End:
 * ex: shiftwidth=4 tabstop=8
 */
