/*                           I C V . H
 * BRL-CAD
 *
 * Copyright (c) 2011-2021 United States Government as represented by
 * the U.S. Army Research Laboratory.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this file; see the file named COPYING for more
 * information.
 */
/** @addtogroup libicv
 *
 * Functions provided by the LIBICV image processing library.
 *
 */
/** @{ */
/** @file include/icv.h */
#ifndef ICV_H
#define ICV_H

#include "common.h"

__BEGIN_DECLS

#include "icv/defines.h"
#include "icv/colorspace.h"
#include "icv/crop.h"
#include "icv/filters.h"
#include "icv/io.h"
#include "icv/ops.h"
#include "icv/stat.h"

__END_DECLS

#endif /* ICV_H */
/** @} */
/*
 * Local Variables:
 * tab-width: 8
 * mode: C
 * indent-tabs-mode: t
 * c-file-style: "stroustrup"
 * End:
 * ex: shiftwidth=4 tabstop=8
 */
