macro_rules! hashmap {
    ($( $key: expr => $val: expr ),*) => {{
         let mut map = ::std::collections::HashMap::new();
         $( map.insert($key, $val); )*
         map
    }}
}

pub fn esri_wkt_from_epsg(code: u16) -> String {
    let hm = hashmap![
        3819=>"GEOGCS[\"GCS_HD1909\",DATUM[\"D_Hungarian_Datum_1909\",SPHEROID[\"Bessel_1841\",6377397.155,299.1528128]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",3819]]",
        3821=>"GEOGCS[\"GCS_TWD_1967\",DATUM[\"D_TWD_1967\",SPHEROID[\"GRS_1967_Truncated\",6378160.0,298.25]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",3821]]",
        3824=>"GEOGCS[\"GCS_TWD_1997\",DATUM[\"D_TWD_1997\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",3824]]",
        3889=>"GEOGCS[\"GCS_IGRS\",DATUM[\"D_Iraqi_Geospatial_Reference_System\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",3889]]",
        3906=>"GEOGCS[\"GCS_MGI_1901\",DATUM[\"D_MGI_1901\",SPHEROID[\"Bessel_1841\",6377397.155,299.1528128]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",3906]]",
        4001=>"GEOGCS[\"GCS_Airy_1830\",DATUM[\"D_Airy_1830\",SPHEROID[\"Airy_1830\",6377563.396,299.3249646]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4001]]",
        4002=>"GEOGCS[\"GCS_Airy_Modified\",DATUM[\"D_Airy_Modified\",SPHEROID[\"Airy_Modified\",6377340.189,299.3249646]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4002]]",
        4003=>"GEOGCS[\"GCS_Australian\",DATUM[\"D_Australian\",SPHEROID[\"Australian\",6378160.0,298.25]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4003]]",
        4004=>"GEOGCS[\"GCS_Bessel_1841\",DATUM[\"D_Bessel_1841\",SPHEROID[\"Bessel_1841\",6377397.155,299.1528128]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4004]]",
        4005=>"GEOGCS[\"GCS_Bessel_Modified\",DATUM[\"D_Bessel_Modified\",SPHEROID[\"Bessel_Modified\",6377492.018,299.1528128]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4005]]",
        4006=>"GEOGCS[\"GCS_Bessel_Namibia\",DATUM[\"D_Bessel_Namibia\",SPHEROID[\"Bessel_Namibia\",6377483.865280418,299.1528128]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4006]]",
        4007=>"GEOGCS[\"GCS_Clarke_1858\",DATUM[\"D_Clarke_1858\",SPHEROID[\"Clarke_1858\",6378293.645208759,294.260676369]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4007]]",
        4008=>"GEOGCS[\"GCS_Clarke_1866\",DATUM[\"D_Clarke_1866\",SPHEROID[\"Clarke_1866\",6378206.4,294.9786982]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4008]]",
        4009=>"GEOGCS[\"GCS_Clarke_1866_Michigan\",DATUM[\"D_Clarke_1866_Michigan\",SPHEROID[\"Clarke_1866_Michigan\",6378450.047,294.978684677]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4009]]",
        4010=>"GEOGCS[\"GCS_Clarke_1880_Benoit\",DATUM[\"D_Clarke_1880_Benoit\",SPHEROID[\"Clarke_1880_Benoit\",6378300.789,293.4663155389802]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4010]]",
        4011=>"GEOGCS[\"GCS_Clarke_1880_IGN\",DATUM[\"D_Clarke_1880_IGN\",SPHEROID[\"Clarke_1880_IGN\",6378249.2,293.4660212936265]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4011]]",
        4012=>"GEOGCS[\"GCS_Clarke_1880_RGS\",DATUM[\"D_Clarke_1880_RGS\",SPHEROID[\"Clarke_1880_RGS\",6378249.145,293.465]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4012]]",
        4013=>"GEOGCS[\"GCS_Clarke_1880_Arc\",DATUM[\"D_Clarke_1880_Arc\",SPHEROID[\"Clarke_1880_Arc\",6378249.145,293.466307656]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4013]]",
        4014=>"GEOGCS[\"GCS_Clarke_1880_SGA\",DATUM[\"D_Clarke_1880_SGA\",SPHEROID[\"Clarke_1880_SGA\",6378249.2,293.46598]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4014]]",
        4015=>"GEOGCS[\"GCS_Everest_Adj_1937\",DATUM[\"D_Everest_Adj_1937\",SPHEROID[\"Everest_Adjustment_1937\",6377276.345,300.8017]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4015]]",
        4016=>"GEOGCS[\"GCS_Everest_def_1967\",DATUM[\"D_Everest_Def_1967\",SPHEROID[\"Everest_Definition_1967\",6377298.556,300.8017]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4016]]",
        4018=>"GEOGCS[\"GCS_Everest_Modified\",DATUM[\"D_Everest_Modified\",SPHEROID[\"Everest_1830_Modified\",6377304.063,300.8017]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4018]]",
        4019=>"GEOGCS[\"GCS_GRS_1980\",DATUM[\"D_GRS_1980\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4019]]",
        4020=>"GEOGCS[\"GCS_Helmert_1906\",DATUM[\"D_Helmert_1906\",SPHEROID[\"Helmert_1906\",6378200.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4020]]",
        4021=>"GEOGCS[\"GCS_Indonesian\",DATUM[\"D_Indonesian\",SPHEROID[\"Indonesian\",6378160.0,298.247]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4021]]",
        4022=>"GEOGCS[\"GCS_International_1924\",DATUM[\"D_International_1924\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4022]]",
        4023=>"GEOGCS[\"GCS_MOLDREF99\",DATUM[\"D_MOLDREF99\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4023]]",
        4024=>"GEOGCS[\"GCS_Krasovsky_1940\",DATUM[\"D_Krasovsky_1940\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4024]]",
        4025=>"GEOGCS[\"GCS_NWL_9D\",DATUM[\"D_NWL_9D\",SPHEROID[\"NWL_9D\",6378145.0,298.25]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4025]]",
        4027=>"GEOGCS[\"GCS_Plessis_1817\",DATUM[\"D_Plessis_1817\",SPHEROID[\"Plessis_1817\",6376523.0,308.64]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4027]]",
        4028=>"GEOGCS[\"GCS_Struve_1860\",DATUM[\"D_Struve_1860\",SPHEROID[\"Struve_1860\",6378298.3,294.73]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4028]]",
        4029=>"GEOGCS[\"GCS_War_Office\",DATUM[\"D_War_Office\",SPHEROID[\"War_Office\",6378300.0,296.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4029]]",
        4031=>"GEOGCS[\"GCS_GEM_10C\",DATUM[\"D_GEM_10C\",SPHEROID[\"GEM_10C\",6378137.0,298.257223563]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4031]]",
        4032=>"GEOGCS[\"GCS_OSU_86F\",DATUM[\"D_OSU_86F\",SPHEROID[\"OSU_86F\",6378136.2,298.257223563]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4032]]",
        4033=>"GEOGCS[\"GCS_OSU_91A\",DATUM[\"D_OSU_91A\",SPHEROID[\"OSU_91A\",6378136.3,298.257223563]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4033]]",
        4034=>"GEOGCS[\"GCS_Clarke_1880\",DATUM[\"D_Clarke_1880\",SPHEROID[\"Clarke_1880\",6378249.144808011,293.4663076556253]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4034]]",
        4035=>"GEOGCS[\"GCS_Sphere\",DATUM[\"D_Sphere\",SPHEROID[\"Sphere\",6371000.0,0.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4035]]",
        4036=>"GEOGCS[\"GCS_GRS_1967\",DATUM[\"D_GRS_1967\",SPHEROID[\"GRS_1967\",6378160.0,298.247167427]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4036]]",
        4042=>"GEOGCS[\"GCS_Everest_1830\",DATUM[\"D_Everest_1830\",SPHEROID[\"Everest_1830\",6377299.36,300.8017]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4042]]",
        4044=>"GEOGCS[\"GCS_Everest_def_1962\",DATUM[\"D_Everest_Def_1962\",SPHEROID[\"Everest_Definition_1962\",6377301.243,300.8017255]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4044]]",
        4045=>"GEOGCS[\"GCS_Everest_def_1975\",DATUM[\"D_Everest_Def_1975\",SPHEROID[\"Everest_Definition_1975\",6377299.151,300.8017255]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4045]]",
        4046=>"GEOGCS[\"GCS_RGRDC_2005\",DATUM[\"D_Reseau_Geodesique_de_la_RDC_2005\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4046]]",
        4047=>"GEOGCS[\"GCS_Sphere_GRS_1980_Authalic\",DATUM[\"D_Sphere_GRS_1980_Authalic\",SPHEROID[\"Sphere_GRS_1980_Authalic\",6371007.0,0.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4047]]",
        4052=>"GEOGCS[\"GCS_Sphere_Clarke_1866_Authalic\",DATUM[\"D_Sphere_Clarke_1866_Authalic\",SPHEROID[\"Sphere_Clarke_1866_Authalic\",6370997.0,0.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4052]]",
        4053=>"GEOGCS[\"GCS_Sphere_International_1924_Authalic\",DATUM[\"D_Sphere_International_1924_Authalic\",SPHEROID[\"Sphere_International_1924_Authalic\",6371228.0,0.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4053]]",
        4054=>"GEOGCS[\"GCS_Hughes_1980\",DATUM[\"D_Hughes_1980\",SPHEROID[\"Hughes_1980\",6378273.0,298.279411123064]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4054]]",
        4055=>"GEOGCS[\"GCS_WGS_1984_Major_Auxiliary_Sphere\",DATUM[\"D_WGS_1984_Major_Auxiliary_Sphere\",SPHEROID[\"WGS_1984_Major_Auxiliary_Sphere\",6378137.0,0.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4055]]",
        4075=>"GEOGCS[\"GCS_SREF98\",DATUM[\"D_Serbian_Reference_Network_1998\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4075]]",
        4081=>"GEOGCS[\"GCS_REGCAN95\",DATUM[\"D_Red_Geodesica_de_Canarias_1995\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4081]]",
        4120=>"GEOGCS[\"GCS_Greek\",DATUM[\"D_Greek\",SPHEROID[\"Bessel_1841\",6377397.155,299.1528128]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4120]]",
        4121=>"GEOGCS[\"GCS_GGRS_1987\",DATUM[\"D_GGRS_1987\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4121]]",
        4122=>"GEOGCS[\"GCS_ATS_1977\",DATUM[\"D_ATS_1977\",SPHEROID[\"ATS_1977\",6378135.0,298.257]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4122]]",
        4123=>"GEOGCS[\"GCS_KKJ\",DATUM[\"D_KKJ\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4123]]",
        4124=>"GEOGCS[\"GCS_RT_1990\",DATUM[\"D_RT_1990\",SPHEROID[\"Bessel_1841\",6377397.155,299.1528128]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4124]]",
        4125=>"GEOGCS[\"GCS_Samboja\",DATUM[\"D_Samboja\",SPHEROID[\"Bessel_1841\",6377397.155,299.1528128]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4125]]",
        4126=>"GEOGCS[\"GCS_LKS_1994\",DATUM[\"D_Lithuania_1994\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4669]]",
        4127=>"GEOGCS[\"GCS_Tete\",DATUM[\"D_Tete\",SPHEROID[\"Clarke_1866\",6378206.4,294.9786982]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4127]]",
        4128=>"GEOGCS[\"GCS_Madzansua\",DATUM[\"D_Madzansua\",SPHEROID[\"Clarke_1866\",6378206.4,294.9786982]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4128]]",
        4129=>"GEOGCS[\"GCS_Observatario\",DATUM[\"D_Observatario\",SPHEROID[\"Clarke_1866\",6378206.4,294.9786982]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4129]]",
        4130=>"GEOGCS[\"GCS_Moznet\",DATUM[\"D_Moznet\",SPHEROID[\"WGS_1984\",6378137.0,298.257223563]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4130]]",
        4131=>"GEOGCS[\"GCS_Indian_1960\",DATUM[\"D_Indian_1960\",SPHEROID[\"Everest_Adjustment_1937\",6377276.345,300.8017]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4131]]",
        4132=>"GEOGCS[\"GCS_FD_1958\",DATUM[\"D_FD_1958\",SPHEROID[\"Clarke_1880_RGS\",6378249.145,293.465]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4132]]",
        4133=>"GEOGCS[\"GCS_Estonia_1992\",DATUM[\"D_Estonia_1992\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4133]]",
        4134=>"GEOGCS[\"GCS_PDO_1993\",DATUM[\"D_PDO_1993\",SPHEROID[\"Clarke_1880_RGS\",6378249.145,293.465]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4134]]",
        4135=>"GEOGCS[\"GCS_Old_Hawaiian\",DATUM[\"D_Old_Hawaiian\",SPHEROID[\"Clarke_1866\",6378206.4,294.9786982]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4135]]",
        4136=>"GEOGCS[\"GCS_St_Lawrence_Island\",DATUM[\"D_St_Lawrence_Island\",SPHEROID[\"Clarke_1866\",6378206.4,294.9786982]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4136]]",
        4137=>"GEOGCS[\"GCS_St_Paul_Island\",DATUM[\"D_St_Paul_Island\",SPHEROID[\"Clarke_1866\",6378206.4,294.9786982]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4137]]",
        4138=>"GEOGCS[\"GCS_St_George_Island\",DATUM[\"D_St_George_Island\",SPHEROID[\"Clarke_1866\",6378206.4,294.9786982]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4138]]",
        4139=>"GEOGCS[\"GCS_Puerto_Rico\",DATUM[\"D_Puerto_Rico\",SPHEROID[\"Clarke_1866\",6378206.4,294.9786982]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4139]]",
        4140=>"GEOGCS[\"GCS_North_American_1983_CSRS\",DATUM[\"D_North_American_1983_CSRS\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4617]]",
        4141=>"GEOGCS[\"GCS_Israel\",DATUM[\"D_Israel\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4141]]",
        4142=>"GEOGCS[\"GCS_Locodjo_1965\",DATUM[\"D_Locodjo_1965\",SPHEROID[\"Clarke_1880_RGS\",6378249.145,293.465]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4142]]",
        4143=>"GEOGCS[\"GCS_Abidjan_1987\",DATUM[\"D_Abidjan_1987\",SPHEROID[\"Clarke_1880_RGS\",6378249.145,293.465]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4143]]",
        4144=>"GEOGCS[\"GCS_Kalianpur_1937\",DATUM[\"D_Kalianpur_1937\",SPHEROID[\"Everest_Adjustment_1937\",6377276.345,300.8017]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4144]]",
        4145=>"GEOGCS[\"GCS_Kalianpur_1962\",DATUM[\"D_Kalianpur_1962\",SPHEROID[\"Everest_Definition_1962\",6377301.243,300.8017255]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4145]]",
        4146=>"GEOGCS[\"GCS_Kalianpur_1975\",DATUM[\"D_Kalianpur_1975\",SPHEROID[\"Everest_Definition_1975\",6377299.151,300.8017255]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4146]]",
        4147=>"GEOGCS[\"GCS_Hanoi_1972\",DATUM[\"D_Hanoi_1972\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4147]]",
        4148=>"GEOGCS[\"GCS_Hartebeesthoek_1994\",DATUM[\"D_Hartebeesthoek_1994\",SPHEROID[\"WGS_1984\",6378137.0,298.257223563]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4148]]",
        4149=>"GEOGCS[\"GCS_CH1903\",DATUM[\"D_CH1903\",SPHEROID[\"Bessel_1841\",6377397.155,299.1528128]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4149]]",
        4150=>"GEOGCS[\"GCS_CH1903+\",DATUM[\"D_CH1903+\",SPHEROID[\"Bessel_1841\",6377397.155,299.1528128]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4150]]",
        4151=>"GEOGCS[\"GCS_Swiss_TRF_1995\",DATUM[\"D_Swiss_TRF_1995\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4151]]",
        4152=>"GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4152]]",
        4153=>"GEOGCS[\"GCS_Rassadiran\",DATUM[\"D_Rassadiran\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4153]]",
        4154=>"GEOGCS[\"GCS_European_1950_ED77\",DATUM[\"D_European_1950_ED77\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4154]]",
        4155=>"GEOGCS[\"GCS_Dabola_1981\",DATUM[\"D_Dabola_1981\",SPHEROID[\"Clarke_1880_IGN\",6378249.2,293.4660212936265]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4155]]",
        4156=>"GEOGCS[\"GCS_S_JTSK\",DATUM[\"D_S_JTSK\",SPHEROID[\"Bessel_1841\",6377397.155,299.1528128]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4156]]",
        4157=>"GEOGCS[\"GCS_Mount_Dillon\",DATUM[\"D_Mount_Dillon\",SPHEROID[\"Clarke_1858\",6378293.645208759,294.260676369]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4157]]",
        4158=>"GEOGCS[\"GCS_Naparima_1955\",DATUM[\"D_Naparima_1955\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4158]]",
        4159=>"GEOGCS[\"GCS_European_Libyan_Datum_1979\",DATUM[\"D_European_Libyan_1979\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4159]]",
        4160=>"GEOGCS[\"GCS_Chos_Malal_1914\",DATUM[\"D_Chos_Malal_1914\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4160]]",
        4161=>"GEOGCS[\"GCS_Pampa_del_Castillo\",DATUM[\"D_Pampa_del_Castillo\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4161]]",
        4162=>"GEOGCS[\"GCS_Korean_Datum_1985\",DATUM[\"D_Korean_Datum_1985\",SPHEROID[\"Bessel_1841\",6377397.155,299.1528128]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4162]]",
        4163=>"GEOGCS[\"GCS_Yemen_NGN_1996\",DATUM[\"D_Yemen_NGN_1996\",SPHEROID[\"WGS_1984\",6378137.0,298.257223563]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4163]]",
        4164=>"GEOGCS[\"GCS_South_Yemen\",DATUM[\"D_South_Yemen\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4164]]",
        4165=>"GEOGCS[\"GCS_Bissau\",DATUM[\"D_Bissau\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4165]]",
        4166=>"GEOGCS[\"GCS_Korean_Datum_1995\",DATUM[\"D_Korean_Datum_1995\",SPHEROID[\"WGS_1984\",6378137.0,298.257223563]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4166]]",
        4167=>"GEOGCS[\"GCS_NZGD_2000\",DATUM[\"D_NZGD_2000\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4167]]",
        4168=>"GEOGCS[\"GCS_Accra\",DATUM[\"D_Accra\",SPHEROID[\"War_Office\",6378300.0,296.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4168]]",
        4169=>"GEOGCS[\"GCS_American_Samoa_1962\",DATUM[\"D_American_Samoa_1962\",SPHEROID[\"Clarke_1866\",6378206.4,294.9786982]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4169]]",
        4170=>"GEOGCS[\"GCS_SIRGAS\",DATUM[\"D_SIRGAS\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4170]]",
        4171=>"GEOGCS[\"GCS_RGF_1993\",DATUM[\"D_RGF_1993\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4171]]",
        4172=>"GEOGCS[\"GCS_POSGAR\",DATUM[\"D_POSGAR\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4172]]",
        4173=>"GEOGCS[\"GCS_IRENET95\",DATUM[\"D_IRENET95\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4173]]",
        4174=>"GEOGCS[\"GCS_Sierra_Leone_1924\",DATUM[\"D_Sierra_Leone_1924\",SPHEROID[\"War_Office\",6378300.0,296.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4174]]",
        4175=>"GEOGCS[\"GCS_Sierra_Leone_1968\",DATUM[\"D_Sierra_Leone_1968\",SPHEROID[\"Clarke_1880_RGS\",6378249.145,293.465]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4175]]",
        4176=>"GEOGCS[\"GCS_Australian_Antarctic_1998\",DATUM[\"D_Australian_Antarctic_1998\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4176]]",
        4178=>"GEOGCS[\"GCS_Pulkovo_1942_Adj_1983\",DATUM[\"D_Pulkovo_1942_Adj_1983\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4178]]",
        4179=>"GEOGCS[\"GCS_Pulkovo_1942_Adj_1958\",DATUM[\"D_Pulkovo_1942_Adj_1958\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4179]]",
        4180=>"GEOGCS[\"GCS_Estonia_1997\",DATUM[\"D_Estonia_1997\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4180]]",
        4181=>"GEOGCS[\"GCS_Luxembourg_1930\",DATUM[\"D_Luxembourg_1930\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4181]]",
        4182=>"GEOGCS[\"GCS_Azores_Occidental_1939\",DATUM[\"D_Azores_Occidental_Islands_1939\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4182]]",
        4183=>"GEOGCS[\"GCS_Azores_Central_1948\",DATUM[\"D_Azores_Central_Islands_1948\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4183]]",
        4184=>"GEOGCS[\"GCS_Azores_Oriental_1940\",DATUM[\"D_Azores_Oriental_Islands_1940\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4184]]",
        4185=>"GEOGCS[\"GCS_Madeira_1936\",DATUM[\"D_Madeira_1936\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4185]]",
        4188=>"GEOGCS[\"GCS_OSNI_1952\",DATUM[\"D_OSNI_1952\",SPHEROID[\"Airy_1830\",6377563.396,299.3249646]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4188]]",
        4189=>"GEOGCS[\"GCS_REGVEN\",DATUM[\"D_REGVEN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4189]]",
        4190=>"GEOGCS[\"GCS_POSGAR_1998\",DATUM[\"D_POSGAR_1998\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4190]]",
        4191=>"GEOGCS[\"GCS_Albanian_1987\",DATUM[\"D_Albanian_1987\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4191]]",
        4192=>"GEOGCS[\"GCS_Douala_1948\",DATUM[\"D_Douala_1948\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4192]]",
        4193=>"GEOGCS[\"GCS_Manoca_1962\",DATUM[\"D_Manoca_1962\",SPHEROID[\"Clarke_1880_IGN\",6378249.2,293.4660212936265]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4193]]",
        4194=>"GEOGCS[\"GCS_Qornoq_1927\",DATUM[\"D_Qornoq_1927\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4194]]",
        4195=>"GEOGCS[\"GCS_Scoresbysund_1952\",DATUM[\"D_Scoresbysund_1952\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4195]]",
        4196=>"GEOGCS[\"GCS_Ammassalik_1958\",DATUM[\"D_Ammassalik_1958\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4196]]",
        4197=>"GEOGCS[\"GCS_Garoua\",DATUM[\"D_Garoua\",SPHEROID[\"Clarke_1880_RGS\",6378249.145,293.465]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4197]]",
        4198=>"GEOGCS[\"GCS_Kousseri\",DATUM[\"D_Kousseri\",SPHEROID[\"Clarke_1880_RGS\",6378249.145,293.465]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4198]]",
        4199=>"GEOGCS[\"GCS_Egypt_1930\",DATUM[\"D_Egypt_1930\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4199]]",
        4200=>"GEOGCS[\"GCS_Pulkovo_1995\",DATUM[\"D_Pulkovo_1995\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4200]]",
        4201=>"GEOGCS[\"GCS_Adindan\",DATUM[\"D_Adindan\",SPHEROID[\"Clarke_1880_RGS\",6378249.145,293.465]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4201]]",
        4202=>"GEOGCS[\"GCS_Australian_1966\",DATUM[\"D_Australian_1966\",SPHEROID[\"Australian\",6378160.0,298.25]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4202]]",
        4203=>"GEOGCS[\"GCS_Australian_1984\",DATUM[\"D_Australian_1984\",SPHEROID[\"Australian\",6378160.0,298.25]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4203]]",
        4204=>"GEOGCS[\"GCS_Ain_el_Abd_1970\",DATUM[\"D_Ain_el_Abd_1970\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4204]]",
        4205=>"GEOGCS[\"GCS_Afgooye\",DATUM[\"D_Afgooye\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4205]]",
        4206=>"GEOGCS[\"GCS_Agadez\",DATUM[\"D_Agadez\",SPHEROID[\"Clarke_1880_IGN\",6378249.2,293.4660212936265]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4206]]",
        4207=>"GEOGCS[\"GCS_Lisbon\",DATUM[\"D_Lisbon\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4207]]",
        4208=>"GEOGCS[\"GCS_Aratu\",DATUM[\"D_Aratu\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4208]]",
        4209=>"GEOGCS[\"GCS_Arc_1950\",DATUM[\"D_Arc_1950\",SPHEROID[\"Clarke_1880_Arc\",6378249.145,293.466307656]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4209]]",
        4210=>"GEOGCS[\"GCS_Arc_1960\",DATUM[\"D_Arc_1960\",SPHEROID[\"Clarke_1880_RGS\",6378249.145,293.465]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4210]]",
        4211=>"GEOGCS[\"GCS_Batavia\",DATUM[\"D_Batavia\",SPHEROID[\"Bessel_1841\",6377397.155,299.1528128]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4211]]",
        4212=>"GEOGCS[\"GCS_Barbados_1938\",DATUM[\"D_Barbados_1938\",SPHEROID[\"Clarke_1880_RGS\",6378249.145,293.465]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4212]]",
        4213=>"GEOGCS[\"GCS_Beduaram\",DATUM[\"D_Beduaram\",SPHEROID[\"Clarke_1880_IGN\",6378249.2,293.4660212936265]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4213]]",
        4214=>"GEOGCS[\"GCS_Beijing_1954\",DATUM[\"D_Beijing_1954\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4214]]",
        4215=>"GEOGCS[\"GCS_Belge_1950\",DATUM[\"D_Belge_1950\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4215]]",
        4216=>"GEOGCS[\"GCS_Bermuda_1957\",DATUM[\"D_Bermuda_1957\",SPHEROID[\"Clarke_1866\",6378206.4,294.9786982]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4216]]",
        4218=>"GEOGCS[\"GCS_Bogota\",DATUM[\"D_Bogota\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4218]]",
        4219=>"GEOGCS[\"GCS_Bukit_Rimpah\",DATUM[\"D_Bukit_Rimpah\",SPHEROID[\"Bessel_1841\",6377397.155,299.1528128]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4219]]",
        4220=>"GEOGCS[\"GCS_Camacupa\",DATUM[\"D_Camacupa\",SPHEROID[\"Clarke_1880_RGS\",6378249.145,293.465]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4220]]",
        4221=>"GEOGCS[\"GCS_Campo_Inchauspe\",DATUM[\"D_Campo_Inchauspe\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4221]]",
        4222=>"GEOGCS[\"GCS_Cape\",DATUM[\"D_Cape\",SPHEROID[\"Clarke_1880_Arc\",6378249.145,293.466307656]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4222]]",
        4223=>"GEOGCS[\"GCS_Carthage\",DATUM[\"D_Carthage\",SPHEROID[\"Clarke_1880_IGN\",6378249.2,293.4660212936265]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4223]]",
        4224=>"GEOGCS[\"GCS_Chua\",DATUM[\"D_Chua\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4224]]",
        4225=>"GEOGCS[\"GCS_Corrego_Alegre\",DATUM[\"D_Corrego_Alegre\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4225]]",
        4226=>"GEOGCS[\"GCS_Cote_d_Ivoire\",DATUM[\"D_Cote_d_Ivoire\",SPHEROID[\"Clarke_1880_IGN\",6378249.2,293.4660212936265]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4226]]",
        4227=>"GEOGCS[\"GCS_Deir_ez_Zor\",DATUM[\"D_Deir_ez_Zor\",SPHEROID[\"Clarke_1880_IGN\",6378249.2,293.4660212936265]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4227]]",
        4228=>"GEOGCS[\"GCS_Douala\",DATUM[\"D_Douala\",SPHEROID[\"Clarke_1880_IGN\",6378249.2,293.4660212936265]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4228]]",
        4229=>"GEOGCS[\"GCS_Egypt_1907\",DATUM[\"D_Egypt_1907\",SPHEROID[\"Helmert_1906\",6378200.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4229]]",
        4230=>"GEOGCS[\"GCS_European_1950\",DATUM[\"D_European_1950\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4230]]",
        4231=>"GEOGCS[\"GCS_European_1987\",DATUM[\"D_European_1987\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4231]]",
        4232=>"GEOGCS[\"GCS_Fahud\",DATUM[\"D_Fahud\",SPHEROID[\"Clarke_1880_RGS\",6378249.145,293.465]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4232]]",
        4233=>"GEOGCS[\"GCS_Gandajika_1970\",DATUM[\"D_Gandajika_1970\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4233]]",
        4234=>"GEOGCS[\"GCS_Garoua\",DATUM[\"D_Garoua\",SPHEROID[\"Clarke_1880_RGS\",6378249.145,293.465]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4197]]",
        4235=>"GEOGCS[\"GCS_Guyane_Francaise\",DATUM[\"D_Guyane_Francaise\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4235]]",
        4236=>"GEOGCS[\"GCS_Hu_Tzu_Shan\",DATUM[\"D_Hu_Tzu_Shan\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4236]]",
        4237=>"GEOGCS[\"GCS_Hungarian_1972\",DATUM[\"D_Hungarian_1972\",SPHEROID[\"GRS_1967\",6378160.0,298.247167427]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4237]]",
        4238=>"GEOGCS[\"GCS_Indonesian_1974\",DATUM[\"D_Indonesian_1974\",SPHEROID[\"Indonesian\",6378160.0,298.247]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4238]]",
        4239=>"GEOGCS[\"GCS_Indian_1954\",DATUM[\"D_Indian_1954\",SPHEROID[\"Everest_Adjustment_1937\",6377276.345,300.8017]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4239]]",
        4240=>"GEOGCS[\"GCS_Indian_1975\",DATUM[\"D_Indian_1975\",SPHEROID[\"Everest_Adjustment_1937\",6377276.345,300.8017]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4240]]",
        4241=>"GEOGCS[\"GCS_Jamaica_1875\",DATUM[\"D_Jamaica_1875\",SPHEROID[\"Clarke_1880\",6378249.144808011,293.4663076556253]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4241]]",
        4242=>"GEOGCS[\"GCS_Jamaica_1969\",DATUM[\"D_Jamaica_1969\",SPHEROID[\"Clarke_1866\",6378206.4,294.9786982]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4242]]",
        4243=>"GEOGCS[\"GCS_Kalianpur_1880\",DATUM[\"D_Kalianpur_1880\",SPHEROID[\"Everest_1830\",6377299.36,300.8017]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4243]]",
        4244=>"GEOGCS[\"GCS_Kandawala\",DATUM[\"D_Kandawala\",SPHEROID[\"Everest_Adjustment_1937\",6377276.345,300.8017]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4244]]",
        4245=>"GEOGCS[\"GCS_Kertau\",DATUM[\"D_Kertau\",SPHEROID[\"Everest_1830_Modified\",6377304.063,300.8017]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4245]]",
        4246=>"GEOGCS[\"GCS_Kuwait_Oil_Company\",DATUM[\"D_Kuwait_Oil_Company\",SPHEROID[\"Clarke_1880_RGS\",6378249.145,293.465]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4246]]",
        4247=>"GEOGCS[\"GCS_La_Canoa\",DATUM[\"D_La_Canoa\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4247]]",
        4248=>"GEOGCS[\"GCS_Provisional_S_American_1956\",DATUM[\"D_Provisional_S_American_1956\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4248]]",
        4249=>"GEOGCS[\"GCS_Lake\",DATUM[\"D_Lake\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4249]]",
        4250=>"GEOGCS[\"GCS_Leigon\",DATUM[\"D_Leigon\",SPHEROID[\"Clarke_1880_RGS\",6378249.145,293.465]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4250]]",
        4251=>"GEOGCS[\"GCS_Liberia_1964\",DATUM[\"D_Liberia_1964\",SPHEROID[\"Clarke_1880_RGS\",6378249.145,293.465]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4251]]",
        4252=>"GEOGCS[\"GCS_Lome\",DATUM[\"D_Lome\",SPHEROID[\"Clarke_1880_IGN\",6378249.2,293.4660212936265]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4252]]",
        4253=>"GEOGCS[\"GCS_Luzon_1911\",DATUM[\"D_Luzon_1911\",SPHEROID[\"Clarke_1866\",6378206.4,294.9786982]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4253]]",
        4254=>"GEOGCS[\"GCS_Hito_XVIII_1963\",DATUM[\"D_Hito_XVIII_1963\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4254]]",
        4255=>"GEOGCS[\"GCS_Herat_North\",DATUM[\"D_Herat_North\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4255]]",
        4256=>"GEOGCS[\"GCS_Mahe_1971\",DATUM[\"D_Mahe_1971\",SPHEROID[\"Clarke_1880_RGS\",6378249.145,293.465]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4256]]",
        4257=>"GEOGCS[\"GCS_Makassar\",DATUM[\"D_Makassar\",SPHEROID[\"Bessel_1841\",6377397.155,299.1528128]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4257]]",
        4258=>"GEOGCS[\"GCS_ETRS_1989\",DATUM[\"D_ETRS_1989\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4258]]",
        4259=>"GEOGCS[\"GCS_Malongo_1987\",DATUM[\"D_Malongo_1987\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4259]]",
        4260=>"GEOGCS[\"GCS_Manoca\",DATUM[\"D_Manoca\",SPHEROID[\"Clarke_1880_RGS\",6378249.145,293.465]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4260]]",
        4261=>"GEOGCS[\"GCS_Merchich\",DATUM[\"D_Merchich\",SPHEROID[\"Clarke_1880_IGN\",6378249.2,293.4660212936265]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Grad\",0.01570796326794897],AUTHORITY[\"EPSG\",4261]]",
        4262=>"GEOGCS[\"GCS_Massawa\",DATUM[\"D_Massawa\",SPHEROID[\"Bessel_1841\",6377397.155,299.1528128]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4262]]",
        4263=>"GEOGCS[\"GCS_Minna\",DATUM[\"D_Minna\",SPHEROID[\"Clarke_1880_RGS\",6378249.145,293.465]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4263]]",
        4264=>"GEOGCS[\"GCS_Mhast\",DATUM[\"D_Mhast\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4264]]",
        4265=>"GEOGCS[\"GCS_Monte_Mario\",DATUM[\"D_Monte_Mario\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4265]]",
        4266=>"GEOGCS[\"GCS_Mporaloko\",DATUM[\"D_Mporaloko\",SPHEROID[\"Clarke_1880_IGN\",6378249.2,293.4660212936265]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4266]]",
        4267=>"GEOGCS[\"GCS_North_American_1927\",DATUM[\"D_North_American_1927\",SPHEROID[\"Clarke_1866\",6378206.4,294.9786982]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4267]]",
        4268=>"GEOGCS[\"GCS_North_American_Michigan\",DATUM[\"D_North_American_Michigan\",SPHEROID[\"Clarke_1866_Michigan\",6378450.047,294.978684677]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4268]]",
        4269=>"GEOGCS[\"GCS_North_American_1983\",DATUM[\"D_North_American_1983\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4269]]",
        4270=>"GEOGCS[\"GCS_Nahrwan_1967\",DATUM[\"D_Nahrwan_1967\",SPHEROID[\"Clarke_1880_RGS\",6378249.145,293.465]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4270]]",
        4271=>"GEOGCS[\"GCS_Naparima_1972\",DATUM[\"D_Naparima_1972\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4271]]",
        4272=>"GEOGCS[\"GCS_New_Zealand_1949\",DATUM[\"D_New_Zealand_1949\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4272]]",
        4273=>"GEOGCS[\"GCS_NGO_1948\",DATUM[\"D_NGO_1948\",SPHEROID[\"Bessel_Modified\",6377492.018,299.1528128]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4273]]",
        4274=>"GEOGCS[\"GCS_Datum_73\",DATUM[\"D_Datum_73\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4274]]",
        4275=>"GEOGCS[\"GCS_NTF\",DATUM[\"D_NTF\",SPHEROID[\"Clarke_1880_IGN\",6378249.2,293.4660212936265]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4275]]",
        4276=>"GEOGCS[\"GCS_NSWC_9Z_2\",DATUM[\"D_NSWC_9Z_2\",SPHEROID[\"NWL_9D\",6378145.0,298.25]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4276]]",
        4277=>"GEOGCS[\"GCS_OSGB_1936\",DATUM[\"D_OSGB_1936\",SPHEROID[\"Airy_1830\",6377563.396,299.3249646]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4277]]",
        4278=>"GEOGCS[\"GCS_OSGB_1970_SN\",DATUM[\"D_OSGB_1970_SN\",SPHEROID[\"Airy_1830\",6377563.396,299.3249646]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4278]]",
        4279=>"GEOGCS[\"GCS_OS_SN_1980\",DATUM[\"D_OS_SN_1980\",SPHEROID[\"Airy_1830\",6377563.396,299.3249646]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4279]]",
        4280=>"GEOGCS[\"GCS_Padang_1884\",DATUM[\"D_Padang_1884\",SPHEROID[\"Bessel_1841\",6377397.155,299.1528128]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4280]]",
        4281=>"GEOGCS[\"GCS_Palestine_1923\",DATUM[\"D_Palestine_1923\",SPHEROID[\"Clarke_1880_Benoit\",6378300.789,293.4663155389802]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4281]]",
        4282=>"GEOGCS[\"GCS_Pointe_Noire\",DATUM[\"D_Pointe_Noire\",SPHEROID[\"Clarke_1880_IGN\",6378249.2,293.4660212936265]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4282]]",
        4283=>"GEOGCS[\"GCS_GDA_1994\",DATUM[\"D_GDA_1994\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4283]]",
        4284=>"GEOGCS[\"GCS_Pulkovo_1942\",DATUM[\"D_Pulkovo_1942\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4284]]",
        4285=>"GEOGCS[\"GCS_Qatar_1974\",DATUM[\"D_Qatar\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4285]]",
        4286=>"GEOGCS[\"GCS_Qatar_1948\",DATUM[\"D_Qatar_1948\",SPHEROID[\"Helmert_1906\",6378200.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4286]]",
        4287=>"GEOGCS[\"GCS_Qornoq\",DATUM[\"D_Qornoq\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4287]]",
        4288=>"GEOGCS[\"GCS_Loma_Quintana\",DATUM[\"D_Loma_Quintana\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4288]]",
        4289=>"GEOGCS[\"GCS_Amersfoort\",DATUM[\"D_Amersfoort\",SPHEROID[\"Bessel_1841\",6377397.155,299.1528128]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4289]]",
        4291=>"GEOGCS[\"GCS_South_American_1969\",DATUM[\"D_South_American_1969\",SPHEROID[\"GRS_1967_Truncated\",6378160.0,298.25]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4618]]",
        4292=>"GEOGCS[\"GCS_Sapper_Hill_1943\",DATUM[\"D_Sapper_Hill_1943\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4292]]",
        4293=>"GEOGCS[\"GCS_Schwarzeck\",DATUM[\"D_Schwarzeck\",SPHEROID[\"Bessel_Namibia\",6377483.865280418,299.1528128]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4293]]",
        4294=>"GEOGCS[\"GCS_Segora\",DATUM[\"D_Segora\",SPHEROID[\"Bessel_1841\",6377397.155,299.1528128]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4294]]",
        4295=>"GEOGCS[\"GCS_Serindung\",DATUM[\"D_Serindung\",SPHEROID[\"Bessel_1841\",6377397.155,299.1528128]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4295]]",
        4296=>"GEOGCS[\"GCS_Sudan\",DATUM[\"D_Sudan\",SPHEROID[\"Clarke_1880_IGN\",6378249.2,293.4660212936265]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4296]]",
        4297=>"GEOGCS[\"GCS_Tananarive_1925\",DATUM[\"D_Tananarive_1925\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4297]]",
        4298=>"GEOGCS[\"GCS_Timbalai_1948\",DATUM[\"D_Timbalai_1948\",SPHEROID[\"Everest_Definition_1967\",6377298.556,300.8017]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4298]]",
        4299=>"GEOGCS[\"GCS_TM65\",DATUM[\"D_TM65\",SPHEROID[\"Airy_Modified\",6377340.189,299.3249646]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4299]]",
        4300=>"GEOGCS[\"GCS_TM75\",DATUM[\"D_TM75\",SPHEROID[\"Airy_Modified\",6377340.189,299.3249646]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4300]]",
        4301=>"GEOGCS[\"GCS_Tokyo\",DATUM[\"D_Tokyo\",SPHEROID[\"Bessel_1841\",6377397.155,299.1528128]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4301]]",
        4302=>"GEOGCS[\"GCS_Trinidad_1903\",DATUM[\"D_Trinidad_1903\",SPHEROID[\"Clarke_1858\",6378293.645208759,294.260676369]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4302]]",
        4303=>"GEOGCS[\"GCS_Trucial_Coast_1948\",DATUM[\"D_Trucial_Coast_1948\",SPHEROID[\"Helmert_1906\",6378200.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4303]]",
        4304=>"GEOGCS[\"GCS_Voirol_1875\",DATUM[\"D_Voirol_1875\",SPHEROID[\"Clarke_1880_IGN\",6378249.2,293.4660212936265]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4304]]",
        4306=>"GEOGCS[\"GCS_Bern_1938\",DATUM[\"D_Bern_1938\",SPHEROID[\"Bessel_1841\",6377397.155,299.1528128]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4306]]",
        4307=>"GEOGCS[\"GCS_Nord_Sahara_1959\",DATUM[\"D_Nord_Sahara_1959\",SPHEROID[\"Clarke_1880_RGS\",6378249.145,293.465]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4307]]",
        4308=>"GEOGCS[\"GCS_RT38\",DATUM[\"D_Stockholm_1938\",SPHEROID[\"Bessel_1841\",6377397.155,299.1528128]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4308]]",
        4309=>"GEOGCS[\"GCS_Yacare\",DATUM[\"D_Yacare\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4309]]",
        4310=>"GEOGCS[\"GCS_Yoff\",DATUM[\"D_Yoff\",SPHEROID[\"Clarke_1880_IGN\",6378249.2,293.4660212936265]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4310]]",
        4311=>"GEOGCS[\"GCS_Zanderij\",DATUM[\"D_Zanderij\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4311]]",
        4312=>"GEOGCS[\"GCS_MGI\",DATUM[\"D_MGI\",SPHEROID[\"Bessel_1841\",6377397.155,299.1528128]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4312]]",
        4313=>"GEOGCS[\"GCS_Belge_1972\",DATUM[\"D_Belge_1972\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4313]]",
        4314=>"GEOGCS[\"GCS_Deutsches_Hauptdreiecksnetz\",DATUM[\"D_Deutsches_Hauptdreiecksnetz\",SPHEROID[\"Bessel_1841\",6377397.155,299.1528128]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4314]]",
        4315=>"GEOGCS[\"GCS_Conakry_1905\",DATUM[\"D_Conakry_1905\",SPHEROID[\"Clarke_1880_IGN\",6378249.2,293.4660212936265]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4315]]",
        4316=>"GEOGCS[\"GCS_Dealul_Piscului_1933\",DATUM[\"D_Dealul_Piscului_1933\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4316]]",
        4317=>"GEOGCS[\"GCS_Dealul_Piscului_1970\",DATUM[\"D_Dealul_Piscului_1970\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4317]]",
        4318=>"GEOGCS[\"GCS_NGN\",DATUM[\"D_NGN\",SPHEROID[\"WGS_1984\",6378137.0,298.257223563]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4318]]",
        4319=>"GEOGCS[\"GCS_KUDAMS\",DATUM[\"D_Kuwait_Utility\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4319]]",
        4322=>"GEOGCS[\"GCS_WGS_1972\",DATUM[\"D_WGS_1972\",SPHEROID[\"WGS_1972\",6378135.0,298.26]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4322]]",
        4324=>"GEOGCS[\"GCS_WGS_1972_BE\",DATUM[\"D_WGS_1972_BE\",SPHEROID[\"WGS_1972\",6378135.0,298.26]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4324]]",
        4326=>"GEOGCS[\"GCS_WGS_1984\",DATUM[\"D_WGS_1984\",SPHEROID[\"WGS_1984\",6378137.0,298.257223563]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4326]]",
        4463=>"GEOGCS[\"GCS_RGSPM_2006\",DATUM[\"D_Reseau_Geodesique_de_St_Pierre_et_Miquelon_2006\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4463]]",
        4470=>"GEOGCS[\"GCS_RGM_2004\",DATUM[\"D_Reseau_Geodesique_de_Mayotte_2004\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4470]]",
        4475=>"GEOGCS[\"GCS_Cadastre_1997\",DATUM[\"D_Cadastre_1997\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4475]]",
        4483=>"GEOGCS[\"GCS_Mexican_Datum_of_1993\",DATUM[\"D_Mexican_Datum_of_1993\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4483]]",
        4490=>"GEOGCS[\"GCS_China_Geodetic_Coordinate_System_2000\",DATUM[\"D_China_2000\",SPHEROID[\"CGCS2000\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4490]]",
        4555=>"GEOGCS[\"GCS_New_Beijing\",DATUM[\"D_New_Beijing\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4555]]",
        4558=>"GEOGCS[\"GCS_RRAF_1991\",DATUM[\"D_RRAF_1991\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4558]]",
        4600=>"GEOGCS[\"GCS_Anguilla_1957\",DATUM[\"D_Anguilla_1957\",SPHEROID[\"Clarke_1880_RGS\",6378249.145,293.465]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4600]]",
        4601=>"GEOGCS[\"GCS_Antigua_1943\",DATUM[\"D_Antigua_1943\",SPHEROID[\"Clarke_1880_RGS\",6378249.145,293.465]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4601]]",
        4602=>"GEOGCS[\"GCS_Dominica_1945\",DATUM[\"D_Dominica_1945\",SPHEROID[\"Clarke_1880_RGS\",6378249.145,293.465]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4602]]",
        4603=>"GEOGCS[\"GCS_Grenada_1953\",DATUM[\"D_Grenada_1953\",SPHEROID[\"Clarke_1880_RGS\",6378249.145,293.465]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4603]]",
        4604=>"GEOGCS[\"GCS_Montserrat_1958\",DATUM[\"D_Montserrat_1958\",SPHEROID[\"Clarke_1880_RGS\",6378249.145,293.465]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4604]]",
        4605=>"GEOGCS[\"GCS_St_Kitts_1955\",DATUM[\"D_St_Kitts_1955\",SPHEROID[\"Clarke_1880_RGS\",6378249.145,293.465]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4605]]",
        4606=>"GEOGCS[\"GCS_St_Lucia_1955\",DATUM[\"D_St_Lucia_1955\",SPHEROID[\"Clarke_1880_RGS\",6378249.145,293.465]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4606]]",
        4607=>"GEOGCS[\"GCS_St_Vincent_1945\",DATUM[\"D_St_Vincent_1945\",SPHEROID[\"Clarke_1880_RGS\",6378249.145,293.465]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4607]]",
        4608=>"GEOGCS[\"GCS_NAD_1927_Definition_1976\",DATUM[\"D_NAD_1927_Definition_1976\",SPHEROID[\"Clarke_1866\",6378206.4,294.9786982]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4608]]",
        4609=>"GEOGCS[\"GCS_NAD_1927_CGQ77\",DATUM[\"D_NAD_1927_CGQ77\",SPHEROID[\"Clarke_1866\",6378206.4,294.9786982]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4609]]",
        4610=>"GEOGCS[\"GCS_Xian_1980\",DATUM[\"D_Xian_1980\",SPHEROID[\"Xian_1980\",6378140.0,298.257]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4610]]",
        4611=>"GEOGCS[\"GCS_Hong_Kong_1980\",DATUM[\"D_Hong_Kong_1980\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4611]]",
        4612=>"GEOGCS[\"GCS_JGD_2000\",DATUM[\"D_JGD_2000\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4612]]",
        4613=>"GEOGCS[\"GCS_Gunung_Segara\",DATUM[\"D_Gunung_Segara\",SPHEROID[\"Bessel_1841\",6377397.155,299.1528128]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4613]]",
        4614=>"GEOGCS[\"GCS_QND_1995\",DATUM[\"D_QND_1995\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4614]]",
        4615=>"GEOGCS[\"GCS_Porto_Santo_1936\",DATUM[\"D_Porto_Santo_1936\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4615]]",
        4616=>"GEOGCS[\"GCS_Selvagem_Grande_1938\",DATUM[\"D_Selvagem_Grande_1938\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4616]]",
        4617=>"GEOGCS[\"GCS_North_American_1983_CSRS\",DATUM[\"D_North_American_1983_CSRS\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4617]]",
        4618=>"GEOGCS[\"GCS_South_American_1969\",DATUM[\"D_South_American_1969\",SPHEROID[\"GRS_1967_Truncated\",6378160.0,298.25]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4618]]",
        4619=>"GEOGCS[\"GCS_SWEREF99\",DATUM[\"D_SWEREF99\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4619]]",
        4620=>"GEOGCS[\"GCS_Point_58\",DATUM[\"D_Point_58\",SPHEROID[\"Clarke_1880_RGS\",6378249.145,293.465]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4620]]",
        4621=>"GEOGCS[\"GCS_Fort_Marigot\",DATUM[\"D_Fort_Marigot\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4621]]",
        4622=>"GEOGCS[\"GCS_Sainte_Anne\",DATUM[\"D_Sainte_Anne\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4622]]",
        4623=>"GEOGCS[\"GCS_CSG_1967\",DATUM[\"D_CSG_1967\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4623]]",
        4624=>"GEOGCS[\"GCS_RGFG_1995\",DATUM[\"D_RGFG_1995\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4624]]",
        4625=>"GEOGCS[\"GCS_Fort_Desaix\",DATUM[\"D_Fort_Desaix\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4625]]",
        4626=>"GEOGCS[\"GCS_Reunion_1947\",DATUM[\"D_Reunion_1947\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4626]]",
        4627=>"GEOGCS[\"GCS_RGR_1992\",DATUM[\"D_RGR_1992\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4627]]",
        4628=>"GEOGCS[\"GCS_Tahiti_1952\",DATUM[\"D_Tahiti_1952\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4628]]",
        4629=>"GEOGCS[\"GCS_Tahaa_1954\",DATUM[\"D_Tahaa_1954\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4629]]",
        4630=>"GEOGCS[\"GCS_IGN72_Nuku_Hiva\",DATUM[\"D_IGN72_Nuku_Hiva\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4630]]",
        4631=>"GEOGCS[\"GCS_Kerguelen_Island_1949\",DATUM[\"D_Kerguelen_Island_1949\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4698]]",
        4632=>"GEOGCS[\"GCS_Combani_1950\",DATUM[\"D_Combani_1950\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4632]]",
        4633=>"GEOGCS[\"GCS_IGN56_Lifou\",DATUM[\"D_IGN56_Lifou\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4633]]",
        4636=>"GEOGCS[\"GCS_Petrels_1972\",DATUM[\"D_Petrels_1972\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4636]]",
        4637=>"GEOGCS[\"GCS_Pointe_Geologie_Perroud_1950\",DATUM[\"D_Pointe_Geologie_Perroud_1950\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4637]]",
        4638=>"GEOGCS[\"GCS_Saint_Pierre_et_Miquelon_1950\",DATUM[\"D_Saint_Pierre_et_Miquelon_1950\",SPHEROID[\"Clarke_1866\",6378206.4,294.9786982]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4638]]",
        4639=>"GEOGCS[\"GCS_MOP78\",DATUM[\"D_MOP78\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4639]]",
        4641=>"GEOGCS[\"GCS_IGN53_Mare\",DATUM[\"D_IGN53_Mare\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4641]]",
        4642=>"GEOGCS[\"GCS_ST84_Ile_des_Pins\",DATUM[\"D_ST84_Ile_des_Pins\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4642]]",
        4643=>"GEOGCS[\"GCS_ST71_Belep\",DATUM[\"D_ST71_Belep\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4643]]",
        4644=>"GEOGCS[\"GCS_NEA74_Noumea\",DATUM[\"D_NEA74_Noumea\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4644]]",
        4645=>"GEOGCS[\"GCS_RGNC_1991\",DATUM[\"D_RGNC_1991\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4645]]",
        4646=>"GEOGCS[\"GCS_Grand_Comoros\",DATUM[\"D_Grand_Comoros\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4646]]",
        4657=>"GEOGCS[\"GCS_Reykjavik_1900\",DATUM[\"D_Reykjavik_1900\",SPHEROID[\"Danish_1876\",6377019.27,300.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4657]]",
        4658=>"GEOGCS[\"GCS_Hjorsey_1955\",DATUM[\"D_Hjorsey_1955\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4658]]",
        4659=>"GEOGCS[\"GCS_ISN_1993\",DATUM[\"D_Islands_Network_1993\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4659]]",
        4660=>"GEOGCS[\"GCS_Helle_1954\",DATUM[\"D_Helle_1954\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4660]]",
        4661=>"GEOGCS[\"GCS_LKS_1992\",DATUM[\"D_Latvia_1992\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4661]]",
        4662=>"GEOGCS[\"GCS_IGN72_Grande_Terre\",DATUM[\"D_IGN72_Grande_Terre\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4662]]",
        4663=>"GEOGCS[\"GCS_Porto_Santo_1995\",DATUM[\"D_Porto_Santo_1995\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4663]]",
        4664=>"GEOGCS[\"GCS_Azores_Oriental_1995\",DATUM[\"D_Azores_Oriental_Islands_1995\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4664]]",
        4665=>"GEOGCS[\"GCS_Azores_Central_1995\",DATUM[\"D_Azores_Central_Islands_1995\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4665]]",
        4666=>"GEOGCS[\"GCS_Lisbon_1890\",DATUM[\"D_Lisbon_1890\",SPHEROID[\"Bessel_1841\",6377397.155,299.1528128]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4666]]",
        4667=>"GEOGCS[\"GCS_IKBD_1992\",DATUM[\"D_Iraq_Kuwait_Boundary_1992\",SPHEROID[\"WGS_1984\",6378137.0,298.257223563]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4667]]",
        4668=>"GEOGCS[\"GCS_European_1979\",DATUM[\"D_European_1979\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4668]]",
        4669=>"GEOGCS[\"GCS_LKS_1994\",DATUM[\"D_Lithuania_1994\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4669]]",
        4670=>"GEOGCS[\"GCS_IGM_1995\",DATUM[\"D_IGM_1995\",SPHEROID[\"WGS_1984\",6378137.0,298.257223563]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4670]]",
        4671=>"GEOGCS[\"GCS_Voirol_1879\",DATUM[\"D_Voirol_1879\",SPHEROID[\"Clarke_1880_IGN\",6378249.2,293.4660212936265]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4671]]",
        4672=>"GEOGCS[\"GCS_Chatham_Island_1971\",DATUM[\"D_Chatham_Island_1971\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4672]]",
        4673=>"GEOGCS[\"GCS_Chatham_Islands_1979\",DATUM[\"D_Chatham_Islands_1979\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4673]]",
        4674=>"GEOGCS[\"GCS_SIRGAS_2000\",DATUM[\"D_SIRGAS_2000\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4674]]",
        4675=>"GEOGCS[\"GCS_Guam_1963\",DATUM[\"D_Guam_1963\",SPHEROID[\"Clarke_1866\",6378206.4,294.9786982]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4675]]",
        4676=>"GEOGCS[\"GCS_Vientiane_1982\",DATUM[\"D_Vientiane_1982\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4676]]",
        4677=>"GEOGCS[\"GCS_Lao_1993\",DATUM[\"D_Lao_1993\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4677]]",
        4678=>"GEOGCS[\"GCS_Lao_1997\",DATUM[\"D_Lao_National_Datum_1997\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4678]]",
        4679=>"GEOGCS[\"GCS_Jouik_1961\",DATUM[\"D_Jouik_1961\",SPHEROID[\"Clarke_1880_RGS\",6378249.145,293.465]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4679]]",
        4680=>"GEOGCS[\"GCS_Nouakchott_1965\",DATUM[\"D_Nouakchott_1965\",SPHEROID[\"Clarke_1880_RGS\",6378249.145,293.465]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4680]]",
        4682=>"GEOGCS[\"GCS_Gulshan_303\",DATUM[\"D_Gulshan_303\",SPHEROID[\"Everest_Adjustment_1937\",6377276.345,300.8017]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4682]]",
        4683=>"GEOGCS[\"GCS_PRS_1992\",DATUM[\"D_Philippine_Reference_System_1992\",SPHEROID[\"Clarke_1866\",6378206.4,294.9786982]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4683]]",
        4684=>"GEOGCS[\"GCS_Gan_1970\",DATUM[\"D_Gan_1970\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4684]]",
        4686=>"GEOGCS[\"GCS_MAGNA\",DATUM[\"D_MAGNA\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4686]]",
        4687=>"GEOGCS[\"GCS_RGPF\",DATUM[\"D_Reseau_Geodesique_de_la_Polynesie_Francaise\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4687]]",
        4688=>"GEOGCS[\"GCS_Fatu_Iva_1972\",DATUM[\"D_Fatu_Iva_1972\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4688]]",
        4689=>"GEOGCS[\"GCS_IGN63_Hiva_Oa\",DATUM[\"D_IGN63_Hiva_Oa\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4689]]",
        4690=>"GEOGCS[\"GCS_Tahiti_1979\",DATUM[\"D_Tahiti_1979\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4690]]",
        4691=>"GEOGCS[\"GCS_Moorea_1987\",DATUM[\"D_Moorea_1987\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4691]]",
        4692=>"GEOGCS[\"GCS_Maupiti_1983\",DATUM[\"D_Maupiti_1983\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4692]]",
        4693=>"GEOGCS[\"GCS_Nakhl-e_Ghanem\",DATUM[\"D_Nakhl-e_Ghanem\",SPHEROID[\"WGS_1984\",6378137.0,298.257223563]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4693]]",
        4694=>"GEOGCS[\"GCS_POSGAR_1994\",DATUM[\"D_POSGAR_1994\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4694]]",
        4695=>"GEOGCS[\"GCS_Katanga_1955\",DATUM[\"D_Katanga_1955\",SPHEROID[\"Clarke_1866\",6378206.4,294.9786982]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4695]]",
        4696=>"GEOGCS[\"GCS_Kasai_1953\",DATUM[\"D_Kasai_1953\",SPHEROID[\"Clarke_1880_RGS\",6378249.145,293.465]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4696]]",
        4697=>"GEOGCS[\"GCS_IGC_1962_6th_Parallel_South\",DATUM[\"D_IGC_1962_Arc_of_the_6th_Parallel_South\",SPHEROID[\"Clarke_1880_RGS\",6378249.145,293.465]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4697]]",
        4698=>"GEOGCS[\"GCS_Kerguelen_Island_1949\",DATUM[\"D_Kerguelen_Island_1949\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4698]]",
        4699=>"GEOGCS[\"GCS_Le_Pouce_1934\",DATUM[\"D_Le_Pouce_1934\",SPHEROID[\"Clarke_1880_RGS\",6378249.145,293.465]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4699]]",
        4700=>"GEOGCS[\"GCS_IGN_Astro_1960\",DATUM[\"D_IGN_Astro_1960\",SPHEROID[\"Clarke_1880_RGS\",6378249.145,293.465]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4700]]",
        4701=>"GEOGCS[\"GCS_IGCB_1955\",DATUM[\"D_Institut_Geographique_du_Congo_Belge_1955\",SPHEROID[\"Clarke_1880_RGS\",6378249.145,293.465]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4701]]",
        4702=>"GEOGCS[\"GCS_Mauritania_1999\",DATUM[\"D_Mauritania_1999\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4702]]",
        4703=>"GEOGCS[\"GCS_Mhast_1951\",DATUM[\"D_Mhast_1951\",SPHEROID[\"Clarke_1880_RGS\",6378249.145,293.465]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4703]]",
        4704=>"GEOGCS[\"GCS_Mhast_Onshore\",DATUM[\"D_Mhast_Onshore\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4704]]",
        4705=>"GEOGCS[\"GCS_Mhast_Offshore\",DATUM[\"D_Mhast_Offshore\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4705]]",
        4706=>"GEOGCS[\"GCS_Egypt_Gulf_of_Suez_S-650_TL\",DATUM[\"D_Egypt_Gulf_of_Suez_S-650_TL\",SPHEROID[\"Helmert_1906\",6378200.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4706]]",
        4707=>"GEOGCS[\"GCS_Tern_Island_1961\",DATUM[\"D_Tern_Island_1961\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4707]]",
        4708=>"GEOGCS[\"GCS_Anna_1_1965\",DATUM[\"D_Anna_1_1965\",SPHEROID[\"Australian\",6378160.0,298.25]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4708]]",
        4709=>"GEOGCS[\"GCS_Beacon_E_1945\",DATUM[\"D_Beacon_E_1945\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4709]]",
        4710=>"GEOGCS[\"GCS_DOS_71_4\",DATUM[\"D_DOS_71_4\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4710]]",
        4711=>"GEOGCS[\"GCS_Astro_1952\",DATUM[\"D_Astro_1952\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4711]]",
        4712=>"GEOGCS[\"GCS_Ascension_Island_1958\",DATUM[\"D_Ascension_Island_1958\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4712]]",
        4713=>"GEOGCS[\"GCS_Ayabelle\",DATUM[\"D_Ayabelle\",SPHEROID[\"Clarke_1880_RGS\",6378249.145,293.465]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4713]]",
        4714=>"GEOGCS[\"GCS_Bellevue_IGN\",DATUM[\"D_Bellevue_IGN\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4714]]",
        4715=>"GEOGCS[\"GCS_Camp_Area\",DATUM[\"D_Camp_Area\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4715]]",
        4716=>"GEOGCS[\"GCS_Canton_1966\",DATUM[\"D_Canton_1966\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4716]]",
        4717=>"GEOGCS[\"GCS_Cape_Canaveral\",DATUM[\"D_Cape_Canaveral\",SPHEROID[\"Clarke_1866\",6378206.4,294.9786982]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4717]]",
        4718=>"GEOGCS[\"GCS_Solomon_1968\",DATUM[\"D_Solomon_1968\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4718]]",
        4719=>"GEOGCS[\"GCS_Easter_Island_1967\",DATUM[\"D_Easter_Island_1967\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4719]]",
        4720=>"GEOGCS[\"GCS_Fiji_1986\",DATUM[\"D_Fiji_1986\",SPHEROID[\"WGS_1972\",6378135.0,298.26]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4720]]",
        4721=>"GEOGCS[\"GCS_Fiji_1956\",DATUM[\"D_Fiji_1956\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4721]]",
        4722=>"GEOGCS[\"GCS_ISTS_061_1968\",DATUM[\"D_ISTS_061_1968\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4722]]",
        4723=>"GEOGCS[\"GCS_Grand_Cayman_1959\",DATUM[\"D_Grand_Cayman_1959\",SPHEROID[\"Clarke_1866\",6378206.4,294.9786982]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4723]]",
        4724=>"GEOGCS[\"GCS_ISTS_073_1969\",DATUM[\"D_ISTS_073_1969\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4724]]",
        4725=>"GEOGCS[\"GCS_Johnston_Island_1961\",DATUM[\"D_Johnston_Island_1961\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4725]]",
        4726=>"GEOGCS[\"GCS_Little_Cayman_1961\",DATUM[\"D_Little_Cayman_1961\",SPHEROID[\"Clarke_1866\",6378206.4,294.9786982]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4726]]",
        4727=>"GEOGCS[\"GCS_Midway_1961\",DATUM[\"D_Midway_1961\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4727]]",
        4728=>"GEOGCS[\"GCS_Pico_de_Las_Nieves\",DATUM[\"D_Pico_de_Las_Nieves\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4728]]",
        4729=>"GEOGCS[\"GCS_Pitcairn_1967\",DATUM[\"D_Pitcairn_1967\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4729]]",
        4730=>"GEOGCS[\"GCS_Santo_DOS_1965\",DATUM[\"D_Santo_DOS_1965\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4730]]",
        4731=>"GEOGCS[\"GCS_Viti_Levu_1916\",DATUM[\"D_Viti_Levu_1916\",SPHEROID[\"Clarke_1880_RGS\",6378249.145,293.465]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4731]]",
        4732=>"GEOGCS[\"GCS_Wake_Eniwetok_1960\",DATUM[\"D_Wake_Eniwetok_1960\",SPHEROID[\"Hough_1960\",6378270.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4732]]",
        4733=>"GEOGCS[\"GCS_Wake_Island_1952\",DATUM[\"D_Wake_Island_1952\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4733]]",
        4734=>"GEOGCS[\"GCS_Tristan_1968\",DATUM[\"D_Tristan_1968\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4734]]",
        4735=>"GEOGCS[\"GCS_Kusaie_1951\",DATUM[\"D_Kusaie_1951\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4735]]",
        4736=>"GEOGCS[\"GCS_Deception_Island\",DATUM[\"D_Deception_Island\",SPHEROID[\"Clarke_1880_RGS\",6378249.145,293.465]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4736]]",
        4737=>"GEOGCS[\"GCS_Korea_2000\",DATUM[\"D_Korea_2000\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4737]]",
        4738=>"GEOGCS[\"GCS_Hong_Kong_1963\",DATUM[\"D_Hong_Kong_1963\",SPHEROID[\"Clarke_1858\",6378293.645208759,294.260676369]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4738]]",
        4739=>"GEOGCS[\"GCS_Hong_Kong_1963_67\",DATUM[\"D_Hong_Kong_1963_67\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4739]]",
        4740=>"GEOGCS[\"GCS_PZ_1990\",DATUM[\"D_Parametrop_Zemp_1990\",SPHEROID[\"PZ_1990\",6378136.0,298.257839303]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4740]]",
        4741=>"GEOGCS[\"GCS_FD_1954\",DATUM[\"D_Faroe_Datum_1954\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4741]]",
        4742=>"GEOGCS[\"GCS_GDM_2000\",DATUM[\"D_GDM_2000\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4742]]",
        4743=>"GEOGCS[\"GCS_Karbala_1979_Polservice\",DATUM[\"D_Karbala_1979_Polservice\",SPHEROID[\"Clarke_1880_RGS\",6378249.145,293.465]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4743]]",
        4744=>"GEOGCS[\"GCS_Nahrwan_1934\",DATUM[\"D_Nahrwan_1934\",SPHEROID[\"Clarke_1880_RGS\",6378249.145,293.465]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4744]]",
        4745=>"GEOGCS[\"GCS_RD/83\",DATUM[\"D_Rauenberg_1983\",SPHEROID[\"Bessel_1841\",6377397.155,299.1528128]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4745]]",
        4746=>"GEOGCS[\"GCS_PD/83\",DATUM[\"D_Potsdam_1983\",SPHEROID[\"Bessel_1841\",6377397.155,299.1528128]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4746]]",
        4747=>"GEOGCS[\"GCS_Greenland_1996\",DATUM[\"D_Greenland_1996\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4747]]",
        4748=>"GEOGCS[\"GCS_Vanua_Levu_1915\",DATUM[\"D_Vanua_Levu_1915\",SPHEROID[\"Clarke_1880_Intl_Ft\",6378306.3696,293.4663076556299]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4748]]",
        4749=>"GEOGCS[\"GCS_RGNC_1991-93\",DATUM[\"D_Reseau_Geodesique_de_Nouvelle_Caledonie_1991-93\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4749]]",
        4750=>"GEOGCS[\"GCS_ST87_Ouvea\",DATUM[\"D_ST87_Ouvea\",SPHEROID[\"WGS_1984\",6378137.0,298.257223563]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4750]]",
        4751=>"GEOGCS[\"GCS_Kertau_RSO\",DATUM[\"D_Kertau_RSO\",SPHEROID[\"Everest_Modified_1969\",6377295.664,300.8017]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4751]]",
        4752=>"GEOGCS[\"GCS_Viti_Levu_1912\",DATUM[\"D_Viti_Levu_1912\",SPHEROID[\"Clarke_1880_Intl_Ft\",6378306.3696,293.4663076556299]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4752]]",
        4753=>"GEOGCS[\"GCS_fk89\",DATUM[\"D_fk89\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4753]]",
        4754=>"GEOGCS[\"GCS_LGD2006\",DATUM[\"D_Libyan_Geodetic_Datum_2006\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4754]]",
        4755=>"GEOGCS[\"GCS_DGN_1995\",DATUM[\"D_Datum_Geodesi_Nasional_1995\",SPHEROID[\"WGS_1984\",6378137.0,298.257223563]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4755]]",
        4756=>"GEOGCS[\"GCS_VN_2000\",DATUM[\"D_Vietnam_2000\",SPHEROID[\"WGS_1984\",6378137.0,298.257223563]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4756]]",
        4757=>"GEOGCS[\"GCS_SVY21\",DATUM[\"D_SVY21\",SPHEROID[\"WGS_1984\",6378137.0,298.257223563]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4757]]",
        4758=>"GEOGCS[\"GCS_JAD_2001\",DATUM[\"D_Jamaica_2001\",SPHEROID[\"WGS_1984\",6378137.0,298.257223563]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4758]]",
        4759=>"GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4759]]",
        4760=>"GEOGCS[\"GCS_WGS_1966\",DATUM[\"D_WGS_1966\",SPHEROID[\"WGS_1966\",6378145.0,298.25]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4760]]",
        4761=>"GEOGCS[\"GCS_HTRS96\",DATUM[\"D_Croatian_Terrestrial_Reference_System\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4761]]",
        4762=>"GEOGCS[\"GCS_Bermuda_2000\",DATUM[\"D_Bermuda_2000\",SPHEROID[\"WGS_1984\",6378137.0,298.257223563]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4762]]",
        4763=>"GEOGCS[\"GCS_Pitcairn_2006\",DATUM[\"D_Pitcairn_2006\",SPHEROID[\"WGS_1984\",6378137.0,298.257223563]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4763]]",
        4764=>"GEOGCS[\"GCS_RSRGD2000\",DATUM[\"D_Ross_Sea_Region_Geodetic_Datum_2000\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4764]]",
        4765=>"GEOGCS[\"GCS_Slovenia_1996\",DATUM[\"D_Slovenia_Geodetic_Datum_1996\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4765]]",
        4801=>"GEOGCS[\"GCS_Bern_1898_Bern\",DATUM[\"D_Bern_1898\",SPHEROID[\"Bessel_1841\",6377397.155,299.1528128]],PRIMEM[\"Bern\",7.439583333333333],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4801]]",
        4802=>"GEOGCS[\"GCS_Bogota_Bogota\",DATUM[\"D_Bogota\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Bogota\",-74.08091666666667],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4802]]",
        4803=>"GEOGCS[\"GCS_Lisbon_Lisbon\",DATUM[\"D_Lisbon\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Lisbon\",-9.131906111111112],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4803]]",
        4804=>"GEOGCS[\"GCS_Makassar_Jakarta\",DATUM[\"D_Makassar\",SPHEROID[\"Bessel_1841\",6377397.155,299.1528128]],PRIMEM[\"Jakarta\",106.8077194444444],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4804]]",
        4805=>"GEOGCS[\"GCS_MGI_Ferro\",DATUM[\"D_MGI\",SPHEROID[\"Bessel_1841\",6377397.155,299.1528128]],PRIMEM[\"Ferro\",-17.66666666666667],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4805]]",
        4806=>"GEOGCS[\"GCS_Monte_Mario_Rome\",DATUM[\"D_Monte_Mario\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Rome\",12.45233333333333],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4806]]",
        4807=>"GEOGCS[\"GCS_NTF_Paris\",DATUM[\"D_NTF\",SPHEROID[\"Clarke_1880_IGN\",6378249.2,293.4660212936265]],PRIMEM[\"Paris\",2.337229166666667],UNIT[\"Grad\",0.01570796326794897],AUTHORITY[\"EPSG\",4807]]",
        4808=>"GEOGCS[\"GCS_Padang_1884_Jakarta\",DATUM[\"D_Padang_1884\",SPHEROID[\"Bessel_1841\",6377397.155,299.1528128]],PRIMEM[\"Jakarta\",106.8077194444444],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4808]]",
        4809=>"GEOGCS[\"GCS_Belge_1950_Brussels\",DATUM[\"D_Belge_1950\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Brussels\",4.367975],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4809]]",
        4810=>"GEOGCS[\"GCS_Tananarive_1925_Paris\",DATUM[\"D_Tananarive_1925\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Paris\",2.337229166666667],UNIT[\"Grad\",0.01570796326794897],AUTHORITY[\"EPSG\",4810]]",
        4811=>"GEOGCS[\"GCS_Voirol_1875_Paris\",DATUM[\"D_Voirol_1875\",SPHEROID[\"Clarke_1880_IGN\",6378249.2,293.4660212936265]],PRIMEM[\"Paris\",2.337229166666667],UNIT[\"Grad\",0.01570796326794897],AUTHORITY[\"EPSG\",4811]]",
        4813=>"GEOGCS[\"GCS_Batavia_Jakarta\",DATUM[\"D_Batavia\",SPHEROID[\"Bessel_1841\",6377397.155,299.1528128]],PRIMEM[\"Jakarta\",106.8077194444444],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4813]]",
        4814=>"GEOGCS[\"GCS_RT38_Stockholm\",DATUM[\"D_Stockholm_1938\",SPHEROID[\"Bessel_1841\",6377397.155,299.1528128]],PRIMEM[\"Stockholm\",18.05827777777778],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4814]]",
        4815=>"GEOGCS[\"GCS_Greek_Athens\",DATUM[\"D_Greek\",SPHEROID[\"Bessel_1841\",6377397.155,299.1528128]],PRIMEM[\"Athens\",23.7163375],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4815]]",
        4816=>"GEOGCS[\"GCS_Carthage_Paris\",DATUM[\"D_Carthage\",SPHEROID[\"Clarke_1880_IGN\",6378249.2,293.4660212936265]],PRIMEM[\"Paris\",2.337229166666667],UNIT[\"Grad\",0.01570796326794897],AUTHORITY[\"EPSG\",4816]]",
        4817=>"GEOGCS[\"GCS_NGO_1948_Oslo\",DATUM[\"D_NGO_1948\",SPHEROID[\"Bessel_Modified\",6377492.018,299.1528128]],PRIMEM[\"Oslo\",10.72291666666667],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4817]]",
        4818=>"GEOGCS[\"GCS_S_JTSK_Ferro\",DATUM[\"D_S_JTSK\",SPHEROID[\"Bessel_1841\",6377397.155,299.1528128]],PRIMEM[\"Ferro\",-17.66666666666667],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4818]]",
        4819=>"GEOGCS[\"GCS_Nord_Sahara_1959_Paris\",DATUM[\"D_Nord_Sahara_1959\",SPHEROID[\"Clarke_1880_RGS\",6378249.145,293.465]],PRIMEM[\"Paris\",2.337229166666667],UNIT[\"Grad\",0.01570796326794897],AUTHORITY[\"EPSG\",4819]]",
        4820=>"GEOGCS[\"GCS_Gunung_Segara_Jakarta\",DATUM[\"D_Gunung_Segara\",SPHEROID[\"Bessel_1841\",6377397.155,299.1528128]],PRIMEM[\"Jakarta\",106.8077194444444],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4820]]",
        4821=>"GEOGCS[\"GCS_Voirol_1879_Paris\",DATUM[\"D_Voirol_1879\",SPHEROID[\"Clarke_1880_IGN\",6378249.2,293.4660212936265]],PRIMEM[\"Paris\",2.337229166666667],UNIT[\"Grad\",0.01570796326794897],AUTHORITY[\"EPSG\",4821]]",
        4823=>"GEOGCS[\"GCS_Sao_Tome\",DATUM[\"D_Sao_Tome\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4823]]",
        4824=>"GEOGCS[\"GCS_Principe\",DATUM[\"D_Principe\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4824]]",
        4901=>"GEOGCS[\"GCS_ATF_Paris\",DATUM[\"D_ATF\",SPHEROID[\"Plessis_1817\",6376523.0,308.64]],PRIMEM[\"Paris_RGS\",2.337208333333333],UNIT[\"Grad\",0.01570796326794897],AUTHORITY[\"EPSG\",4901]]",
        4902=>"GEOGCS[\"GCS_Nord_de_Guerre_Paris\",DATUM[\"D_Nord_de_Guerre\",SPHEROID[\"Plessis_1817\",6376523.0,308.64]],PRIMEM[\"Paris\",2.337229166666667],UNIT[\"Grad\",0.01570796326794897],AUTHORITY[\"EPSG\",4902]]",
        4903=>"GEOGCS[\"GCS_Madrid_1870_Madrid\",DATUM[\"D_Madrid_1870\",SPHEROID[\"Struve_1860\",6378298.3,294.73]],PRIMEM[\"Madrid\",-3.687938888888889],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4903]]",
        4904=>"GEOGCS[\"GCS_Lisbon_1890_Lisbon\",DATUM[\"D_Lisbon_1890\",SPHEROID[\"Bessel_1841\",6377397.155,299.1528128]],PRIMEM[\"Lisbon\",-9.131906111111112],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",4904]]",
        5013=>"GEOGCS[\"GCS_PTRA08\",DATUM[\"D_PTRA08\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",5013]]",
        5228=>"GEOGCS[\"GCS_S_JTSK/05\",DATUM[\"D_S_JTSK_05\",SPHEROID[\"Bessel_1841\",6377397.155,299.1528128]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",5228]]",
        5229=>"GEOGCS[\"GCS_S_JTSK/05_Ferro\",DATUM[\"D_S_JTSK_05\",SPHEROID[\"Bessel_1841\",6377397.155,299.1528128]],PRIMEM[\"Ferro\",-17.66666666666667],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",5229]]",
        5233=>"GEOGCS[\"GCS_SLD99\",DATUM[\"D_Sri_Lanka_Datum_1999\",SPHEROID[\"Everest_Adjustment_1937\",6377276.345,300.8017]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",5233]]",
        5246=>"GEOGCS[\"GCS_GDBD2009\",DATUM[\"D_GDBD2009\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",5246]]",
        5252=>"GEOGCS[\"GCS_TUREF\",DATUM[\"D_Turkish_National_Reference_Frame\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",5252]]",
        5264=>"GEOGCS[\"GCS_DRUKREF_03\",DATUM[\"D_Bhutan_National_Geodetic_Datum\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",5264]]",
        5324=>"GEOGCS[\"GCS_ISN_2004\",DATUM[\"D_Islands_Network_2004\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",5324]]",
        5340=>"GEOGCS[\"GCS_POSGAR_2007\",DATUM[\"D_POSGAR_2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",5340]]",
        5354=>"GEOGCS[\"GCS_MARGEN\",DATUM[\"D_Marco_Geodesico_Nacional\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",5354]]",
        5360=>"GEOGCS[\"GCS_SIRGAS-Chile\",DATUM[\"D_SIRGAS-Chile\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",5360]]",
        5365=>"GEOGCS[\"GCS_CR05\",DATUM[\"D_Costa_Rica_2005\",SPHEROID[\"WGS_1984\",6378137.0,298.257223563]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",5365]]",
        5371=>"GEOGCS[\"GCS_MARCARIO_SOLIS\",DATUM[\"D_SGNP_MARCARIO_SOLIS\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",5371]]",
        5373=>"GEOGCS[\"GCS_Peru96\",DATUM[\"D_Peru96\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",5373]]",
        5381=>"GEOGCS[\"GCS_SIRGAS-ROU98\",DATUM[\"D_SIRGAS-ROU98\",SPHEROID[\"WGS_1984\",6378137.0,298.257223563]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",5381]]",
        5393=>"GEOGCS[\"GCS_SIRGAS_ES2007.8\",DATUM[\"D_SIRGAS_ES2007.8\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",5393]]",
        5451=>"GEOGCS[\"GCS_Ocotepeque_1935\",DATUM[\"D_Ocotepeque_1935\",SPHEROID[\"Clarke_1866\",6378206.4,294.9786982]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",5451]]",
        5464=>"GEOGCS[\"GCS_Sibun_Gorge_1922\",DATUM[\"D_Sibun_Gorge_1922\",SPHEROID[\"Clarke_1858\",6378293.645208759,294.260676369]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",5464]]",
        5467=>"GEOGCS[\"GCS_Panama-Colon_1911\",DATUM[\"D_Panama-Colon-1911\",SPHEROID[\"Clarke_1866\",6378206.4,294.9786982]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",5467]]",
        5489=>"GEOGCS[\"GCS_RGAF09\",DATUM[\"Reseau_Geodesique_des_Antilles_Francaises_2009\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",5489]]",
        5524=>"GEOGCS[\"GCS_Corrego_Alegre_1961\",DATUM[\"D_Corrego_Alegre_1961\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",5524]]",
        5527=>"GEOGCS[\"GCS_SAD_1969_96\",DATUM[\"D_South_American_Datum_1969_96\",SPHEROID[\"GRS_1967_Truncated\",6378160.0,298.25]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",5527]]",
        5546=>"GEOGCS[\"GCS_PNG94\",DATUM[\"D_Papua_New_Guinea_Geodetic_Datum_1994\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",5546]]",
        5561=>"GEOGCS[\"GCS_Ukraine_2000\",DATUM[\"D_Ukraine_2000\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",5561]]",
        5593=>"GEOGCS[\"GCS_FEH2010\",DATUM[\"D_Fehmarnbelt_Datum_2010\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",5593]]",
        5681=>"GEOGCS[\"GCS_DB_REF\",DATUM[\"D_Deutsche_Bahn_Reference_System\",SPHEROID[\"Bessel_1841\",6377397.155,299.1528128]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",5681]]",
        5886=>"GEOGCS[\"GCS_TGD2005\",DATUM[\"D_Tonga_Geodetic_Datum_2005\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",5886]]",
        6135=>"GEOGCS[\"GCS_CIGD11\",DATUM[\"D_Cayman_Islands_Geodetic_Datum_2011\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",6135]]",
        6207=>"GEOGCS[\"GCS_Nepal_Nagarkot\",DATUM[\"D_Nepal_Nagarkot\",SPHEROID[\"Everest_Adjustment_1937\",6377276.345,300.8017]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",6207]]",
        6311=>"GEOGCS[\"GCS_CGRS_1993\",DATUM[\"D_Cyprus_Geodetic_Reference_System_1993\",SPHEROID[\"WGS_1984\",6378137.0,298.257223563]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",6311]]",
        6318=>"GEOGCS[\"GCS_NAD_1983_2011\",DATUM[\"D_NAD_1983_2011\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",6318]]",
        6322=>"GEOGCS[\"GCS_NAD_1983_PA11\",DATUM[\"D_NAD_1983_PA11\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",6322]]",
        6325=>"GEOGCS[\"GCS_NAD_1983_MA11\",DATUM[\"D_NAD_1983_MA11\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",6325]]",
        6365=>"GEOGCS[\"GCS_Mexico_ITRF2008\",DATUM[\"D_Mexico_ITRF2008\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",6365]]",
        6668=>"GEOGCS[\"GCS_JGD_2011\",DATUM[\"D_JGD_2011\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",6668]]",
        6706=>"GEOGCS[\"GCS_RDN2008\",DATUM[\"D_Rete_Dinamica_Nazionale_2008\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",6706]]",
        6783=>"GEOGCS[\"GCS_NAD_1983_CORS96\",DATUM[\"D_NAD_1983_CORS96\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",6783]]",
        6881=>"GEOGCS[\"GCS_Aden_1925\",DATUM[\"D_Aden_1925\",SPHEROID[\"Clarke_1880_RGS\",6378249.145,293.465]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",6881]]",
        6882=>"GEOGCS[\"GCS_Bekaa_Valley_1920\",DATUM[\"D_Bekaa_Valley_1920\",SPHEROID[\"Clarke_1880_RGS\",6378249.145,293.465]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",6882]]",
        6883=>"GEOGCS[\"GCS_Bioko\",DATUM[\"D_Bioko\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",6883]]",
        6892=>"GEOGCS[\"GCS_South_East_Island_1943\",DATUM[\"D_South_East_Island_1943\",SPHEROID[\"Clarke_1880_RGS\",6378249.145,293.465]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",6892]]",
        6894=>"GEOGCS[\"GCS_Gambia\",DATUM[\"D_Gambia\",SPHEROID[\"Clarke_1880_RGS\",6378249.145,293.465]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",6894]]",
        6980=>"GEOGCS[\"IGD05\",DATUM[\"Israel_Geodetic_Datum_2005\",SPHEROID[\"WGS_1984\",6378137.0,298.257223563]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",7136]]",
        6983=>"GEOGCS[\"IG05_Intermediate_CRS\",DATUM[\"IG05_Intermediate_Datum\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",6983]]",
        6987=>"GEOGCS[\"IGD05(2012)\",DATUM[\"Israeli_Geodetic_Datum_2005(2012)\",SPHEROID[\"WGS_1984\",6378137.0,298.257223563]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",7139]]",
        6990=>"GEOGCS[\"IG05(2012)_Intermediate_CRS\",DATUM[\"IG05(2012)_Intermediate_Datum\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",6990]]",
        7035=>"GEOGCS[\"RGSPM06_(lon-lat)\",DATUM[\"D_Reseau_Geodesique_de_St_Pierre_et_Miquelon_2006\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",7035]]",
        7037=>"GEOGCS[\"RGR92_(lon-lat)\",DATUM[\"D_RGR_1992\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",7037]]",
        7039=>"GEOGCS[\"RGM04_(lon-lat)\",DATUM[\"D_Reseau_Geodesique_de_Mayotte_2004\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",7039]]",
        7041=>"GEOGCS[\"RGFG95_(lon-lat)\",DATUM[\"D_RGFG_1995\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",7041]]",
        7073=>"GEOGCS[\"GCS_RGTAAF07\",DATUM[\"D_Reseau_Geodesique_des_Terres_Australes_et_Antarctiques_Francaises_2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",7073]]",
        7084=>"GEOGCS[\"RGF93_(lon-lat)\",DATUM[\"D_RGF_1993\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",7084]]",
        7086=>"GEOGCS[\"RGAF09_(lon-lat)\",DATUM[\"Reseau_Geodesique_des_Antilles_Francaises_2009\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",7086]]",
        7133=>"GEOGCS[\"RGTAAF07_(lon-lat)\",DATUM[\"D_Reseau_Geodesique_des_Terres_Australes_et_Antarctiques_Francaises_2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",7133]]",
        7136=>"GEOGCS[\"IGD05\",DATUM[\"Israel_Geodetic_Datum_2005\",SPHEROID[\"WGS_1984\",6378137.0,298.257223563]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",7136]]",
        7139=>"GEOGCS[\"IGD05(2012)\",DATUM[\"Israeli_Geodetic_Datum_2005(2012)\",SPHEROID[\"WGS_1984\",6378137.0,298.257223563]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",7139]]",
        7373=>"GEOGCS[\"ONGD14\",DATUM[\"Oman_National_Geodetic_Datum_2014\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",7373]]",
        7683=>"GEOGCS[\"GSK-2011\",DATUM[\"Geodezicheskaya_Sistema_Koordinat_2011\",SPHEROID[\"GSK-2011\",6378136.5,298.2564151]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",7683]]",
        7798=>"GEOGCS[\"BGS2005\",DATUM[\"Bulgaria_Geodetic_System_2005\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",7798]]",
        7844=>"GEOGCS[\"GDA2020\",DATUM[\"GDA2020\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",7844]]",
        7881=>"GEOGCS[\"St_Helena_Tritan\",DATUM[\"St_Helena_Tritan\",SPHEROID[\"WGS_1984\",6378137.0,298.257223563]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",7881]]",
        7886=>"GEOGCS[\"SHGD2015\",DATUM[\"St_Helena_Geodetic_Datum_2015\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",7886]]",
        8042=>"GEOGCS[\"Gusterberg(Ferro)\",DATUM[\"Gusterberg_(Ferro)\",SPHEROID[\"Zach_1812\",6376045.0,310.0]],PRIMEM[\"Ferro\",-17.66666666666667],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",8042]]",
        8043=>"GEOGCS[\"St._Stephen(Ferro)\",DATUM[\"St._Stephen_(Ferro)\",SPHEROID[\"Zach_1812\",6376045.0,310.0]],PRIMEM[\"Ferro\",-17.66666666666667],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",8043]]",
        8086=>"GEOGCS[\"ISN2016\",DATUM[\"Islands_Net_2016\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",8086]]",
        8232=>"GEOGCS[\"NAD83(CSRS96)\",DATUM[\"North_American_Datum_of_1983_(CSRS96)\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",8232]]",
        8237=>"GEOGCS[\"NAD83(CSRS)v2\",DATUM[\"North_American_Datum_of_1983_(CSRS)_version_2\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",8237]]",
        8240=>"GEOGCS[\"NAD83(CSRS)v3\",DATUM[\"North_American_Datum_of_1983_(CSRS)_version_3\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",8240]]",
        8246=>"GEOGCS[\"NAD83(CSRS)v4\",DATUM[\"North_American_Datum_of_1983_(CSRS)_version_4\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",8246]]",
        8249=>"GEOGCS[\"NAD83(CSRS)v5\",DATUM[\"North_American_Datum_of_1983_(CSRS)_version_5\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",8249]]",
        8252=>"GEOGCS[\"NAD83(CSRS)v6\",DATUM[\"North_American_Datum_of_1983_(CSRS)_version_6\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",8252]]",
        8255=>"GEOGCS[\"NAD83(CSRS)v7\",DATUM[\"North_American_Datum_of_1983_(CSRS)_version_7\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433],AUTHORITY[\"EPSG\",8255]]",
        2000=>"PROJCS[\"Anguilla_1957_British_West_Indies_Grid\",GEOGCS[\"GCS_Anguilla_1957\",DATUM[\"D_Anguilla_1957\",SPHEROID[\"Clarke_1880_RGS\",6378249.145,293.465]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",400000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-62.0],PARAMETER[\"Scale_Factor\",0.9995],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2000]]",
        2001=>"PROJCS[\"Antigua_1943_British_West_Indies_Grid\",GEOGCS[\"GCS_Antigua_1943\",DATUM[\"D_Antigua_1943\",SPHEROID[\"Clarke_1880_RGS\",6378249.145,293.465]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",400000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-62.0],PARAMETER[\"Scale_Factor\",0.9995],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2001]]",
        2002=>"PROJCS[\"Dominica_1945_British_West_Indies_Grid\",GEOGCS[\"GCS_Dominica_1945\",DATUM[\"D_Dominica_1945\",SPHEROID[\"Clarke_1880_RGS\",6378249.145,293.465]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",400000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-62.0],PARAMETER[\"Scale_Factor\",0.9995],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2002]]",
        2003=>"PROJCS[\"Grenada_1953_British_West_Indies_Grid\",GEOGCS[\"GCS_Grenada_1953\",DATUM[\"D_Grenada_1953\",SPHEROID[\"Clarke_1880_RGS\",6378249.145,293.465]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",400000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-62.0],PARAMETER[\"Scale_Factor\",0.9995],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2003]]",
        2004=>"PROJCS[\"Montserrat_1958_British_West_Indies_Grid\",GEOGCS[\"GCS_Montserrat_1958\",DATUM[\"D_Montserrat_1958\",SPHEROID[\"Clarke_1880_RGS\",6378249.145,293.465]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",400000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-62.0],PARAMETER[\"Scale_Factor\",0.9995],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2004]]",
        2005=>"PROJCS[\"St_Kitts_1955_British_West_Indies_Grid\",GEOGCS[\"GCS_St_Kitts_1955\",DATUM[\"D_St_Kitts_1955\",SPHEROID[\"Clarke_1880_RGS\",6378249.145,293.465]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",400000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-62.0],PARAMETER[\"Scale_Factor\",0.9995],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2005]]",
        2006=>"PROJCS[\"St_Lucia_1955_British_West_Indies_Grid\",GEOGCS[\"GCS_St_Lucia_1955\",DATUM[\"D_St_Lucia_1955\",SPHEROID[\"Clarke_1880_RGS\",6378249.145,293.465]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",400000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-62.0],PARAMETER[\"Scale_Factor\",0.9995],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2006]]",
        2007=>"PROJCS[\"St_Vincent_1945_British_West_Indies_Grid\",GEOGCS[\"GCS_St_Vincent_1945\",DATUM[\"D_St_Vincent_1945\",SPHEROID[\"Clarke_1880_RGS\",6378249.145,293.465]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",400000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-62.0],PARAMETER[\"Scale_Factor\",0.9995],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2007]]",
        2008=>"PROJCS[\"NAD_1927_CGQ77_MTM_2_SCoPQ\",GEOGCS[\"GCS_NAD_1927_CGQ77\",DATUM[\"D_NAD_1927_CGQ77\",SPHEROID[\"Clarke_1866\",6378206.4,294.9786982]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",304800.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-55.5],PARAMETER[\"Scale_Factor\",0.9999],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2008]]",
        2009=>"PROJCS[\"NAD_1927_CGQ77_MTM_3_SCoPQ\",GEOGCS[\"GCS_NAD_1927_CGQ77\",DATUM[\"D_NAD_1927_CGQ77\",SPHEROID[\"Clarke_1866\",6378206.4,294.9786982]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",304800.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-58.5],PARAMETER[\"Scale_Factor\",0.9999],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2009]]",
        2010=>"PROJCS[\"NAD_1927_CGQ77_MTM_4_SCoPQ\",GEOGCS[\"GCS_NAD_1927_CGQ77\",DATUM[\"D_NAD_1927_CGQ77\",SPHEROID[\"Clarke_1866\",6378206.4,294.9786982]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",304800.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-61.5],PARAMETER[\"Scale_Factor\",0.9999],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2010]]",
        2011=>"PROJCS[\"NAD_1927_CGQ77_MTM_5_SCoPQ\",GEOGCS[\"GCS_NAD_1927_CGQ77\",DATUM[\"D_NAD_1927_CGQ77\",SPHEROID[\"Clarke_1866\",6378206.4,294.9786982]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",304800.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-64.5],PARAMETER[\"Scale_Factor\",0.9999],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2011]]",
        2012=>"PROJCS[\"NAD_1927_CGQ77_MTM_6_SCoPQ\",GEOGCS[\"GCS_NAD_1927_CGQ77\",DATUM[\"D_NAD_1927_CGQ77\",SPHEROID[\"Clarke_1866\",6378206.4,294.9786982]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",304800.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-67.5],PARAMETER[\"Scale_Factor\",0.9999],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2012]]",
        2013=>"PROJCS[\"NAD_1927_CGQ77_MTM_7_SCoPQ\",GEOGCS[\"GCS_NAD_1927_CGQ77\",DATUM[\"D_NAD_1927_CGQ77\",SPHEROID[\"Clarke_1866\",6378206.4,294.9786982]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",304800.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-70.5],PARAMETER[\"Scale_Factor\",0.9999],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2013]]",
        2014=>"PROJCS[\"NAD_1927_CGQ77_MTM_8_SCoPQ\",GEOGCS[\"GCS_NAD_1927_CGQ77\",DATUM[\"D_NAD_1927_CGQ77\",SPHEROID[\"Clarke_1866\",6378206.4,294.9786982]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",304800.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-73.5],PARAMETER[\"Scale_Factor\",0.9999],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2014]]",
        2015=>"PROJCS[\"NAD_1927_CGQ77_MTM_9_SCoPQ\",GEOGCS[\"GCS_NAD_1927_CGQ77\",DATUM[\"D_NAD_1927_CGQ77\",SPHEROID[\"Clarke_1866\",6378206.4,294.9786982]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",304800.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-76.5],PARAMETER[\"Scale_Factor\",0.9999],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2015]]",
        2016=>"PROJCS[\"NAD_1927_CGQ77_MTM_10_SCoPQ\",GEOGCS[\"GCS_NAD_1927_CGQ77\",DATUM[\"D_NAD_1927_CGQ77\",SPHEROID[\"Clarke_1866\",6378206.4,294.9786982]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",304800.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-79.5],PARAMETER[\"Scale_Factor\",0.9999],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2016]]",
        2017=>"PROJCS[\"NAD_1927_DEF_1976_MTM_8\",GEOGCS[\"GCS_NAD_1927_Definition_1976\",DATUM[\"D_NAD_1927_Definition_1976\",SPHEROID[\"Clarke_1866\",6378206.4,294.9786982]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",304800.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-73.5],PARAMETER[\"Scale_Factor\",0.9999],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2017]]",
        2018=>"PROJCS[\"NAD_1927_DEF_1976_MTM_9\",GEOGCS[\"GCS_NAD_1927_Definition_1976\",DATUM[\"D_NAD_1927_Definition_1976\",SPHEROID[\"Clarke_1866\",6378206.4,294.9786982]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",304800.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-76.5],PARAMETER[\"Scale_Factor\",0.9999],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2018]]",
        2019=>"PROJCS[\"NAD_1927_DEF_1976_MTM_10\",GEOGCS[\"GCS_NAD_1927_Definition_1976\",DATUM[\"D_NAD_1927_Definition_1976\",SPHEROID[\"Clarke_1866\",6378206.4,294.9786982]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",304800.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-79.5],PARAMETER[\"Scale_Factor\",0.9999],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2019]]",
        2020=>"PROJCS[\"NAD_1927_DEF_1976_MTM_11\",GEOGCS[\"GCS_NAD_1927_Definition_1976\",DATUM[\"D_NAD_1927_Definition_1976\",SPHEROID[\"Clarke_1866\",6378206.4,294.9786982]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",304800.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-82.5],PARAMETER[\"Scale_Factor\",0.9999],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2020]]",
        2021=>"PROJCS[\"NAD_1927_DEF_1976_MTM_12\",GEOGCS[\"GCS_NAD_1927_Definition_1976\",DATUM[\"D_NAD_1927_Definition_1976\",SPHEROID[\"Clarke_1866\",6378206.4,294.9786982]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",304800.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-81.0],PARAMETER[\"Scale_Factor\",0.9999],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2021]]",
        2022=>"PROJCS[\"NAD_1927_DEF_1976_MTM_13\",GEOGCS[\"GCS_NAD_1927_Definition_1976\",DATUM[\"D_NAD_1927_Definition_1976\",SPHEROID[\"Clarke_1866\",6378206.4,294.9786982]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",304800.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-84.0],PARAMETER[\"Scale_Factor\",0.9999],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2022]]",
        2023=>"PROJCS[\"NAD_1927_DEF_1976_MTM_14\",GEOGCS[\"GCS_NAD_1927_Definition_1976\",DATUM[\"D_NAD_1927_Definition_1976\",SPHEROID[\"Clarke_1866\",6378206.4,294.9786982]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",304800.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-87.0],PARAMETER[\"Scale_Factor\",0.9999],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2023]]",
        2024=>"PROJCS[\"NAD_1927_DEF_1976_MTM_15\",GEOGCS[\"GCS_NAD_1927_Definition_1976\",DATUM[\"D_NAD_1927_Definition_1976\",SPHEROID[\"Clarke_1866\",6378206.4,294.9786982]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",304800.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-90.0],PARAMETER[\"Scale_Factor\",0.9999],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2024]]",
        2025=>"PROJCS[\"NAD_1927_DEF_1976_MTM_16\",GEOGCS[\"GCS_NAD_1927_Definition_1976\",DATUM[\"D_NAD_1927_Definition_1976\",SPHEROID[\"Clarke_1866\",6378206.4,294.9786982]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",304800.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-93.0],PARAMETER[\"Scale_Factor\",0.9999],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2025]]",
        2026=>"PROJCS[\"NAD_1927_DEF_1976_MTM_17\",GEOGCS[\"GCS_NAD_1927_Definition_1976\",DATUM[\"D_NAD_1927_Definition_1976\",SPHEROID[\"Clarke_1866\",6378206.4,294.9786982]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",304800.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-96.0],PARAMETER[\"Scale_Factor\",0.9999],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2026]]",
        2027=>"PROJCS[\"NAD_1927_DEF_1976_UTM_Zone_15N\",GEOGCS[\"GCS_NAD_1927_Definition_1976\",DATUM[\"D_NAD_1927_Definition_1976\",SPHEROID[\"Clarke_1866\",6378206.4,294.9786982]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-93.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2027]]",
        2028=>"PROJCS[\"NAD_1927_DEF_1976_UTM_Zone_16N\",GEOGCS[\"GCS_NAD_1927_Definition_1976\",DATUM[\"D_NAD_1927_Definition_1976\",SPHEROID[\"Clarke_1866\",6378206.4,294.9786982]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-87.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2028]]",
        2029=>"PROJCS[\"NAD_1927_DEF_1976_UTM_Zone_17N\",GEOGCS[\"GCS_NAD_1927_Definition_1976\",DATUM[\"D_NAD_1927_Definition_1976\",SPHEROID[\"Clarke_1866\",6378206.4,294.9786982]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-81.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2029]]",
        2030=>"PROJCS[\"NAD_1927_DEF_1976_UTM_Zone_18N\",GEOGCS[\"GCS_NAD_1927_Definition_1976\",DATUM[\"D_NAD_1927_Definition_1976\",SPHEROID[\"Clarke_1866\",6378206.4,294.9786982]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-75.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2030]]",
        2031=>"PROJCS[\"NAD_1927_CGQ77_UTM_Zone_17N\",GEOGCS[\"GCS_NAD_1927_CGQ77\",DATUM[\"D_NAD_1927_CGQ77\",SPHEROID[\"Clarke_1866\",6378206.4,294.9786982]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-81.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2031]]",
        2032=>"PROJCS[\"NAD_1927_CGQ77_UTM_Zone_18N\",GEOGCS[\"GCS_NAD_1927_CGQ77\",DATUM[\"D_NAD_1927_CGQ77\",SPHEROID[\"Clarke_1866\",6378206.4,294.9786982]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-75.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2032]]",
        2033=>"PROJCS[\"NAD_1927_CGQ77_UTM_Zone_19N\",GEOGCS[\"GCS_NAD_1927_CGQ77\",DATUM[\"D_NAD_1927_CGQ77\",SPHEROID[\"Clarke_1866\",6378206.4,294.9786982]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-69.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2033]]",
        2034=>"PROJCS[\"NAD_1927_CGQ77_UTM_Zone_20N\",GEOGCS[\"GCS_NAD_1927_CGQ77\",DATUM[\"D_NAD_1927_CGQ77\",SPHEROID[\"Clarke_1866\",6378206.4,294.9786982]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-63.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2034]]",
        2035=>"PROJCS[\"NAD_1927_CGQ77_UTM_Zone_21N\",GEOGCS[\"GCS_NAD_1927_CGQ77\",DATUM[\"D_NAD_1927_CGQ77\",SPHEROID[\"Clarke_1866\",6378206.4,294.9786982]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-57.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2035]]",
        2036=>"PROJCS[\"NAD_1983_CSRS_New_Brunswick_Stereographic\",GEOGCS[\"GCS_North_American_1983_CSRS\",DATUM[\"D_North_American_1983_CSRS\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Double_Stereographic\"],PARAMETER[\"False_Easting\",2500000.0],PARAMETER[\"False_Northing\",7500000.0],PARAMETER[\"Central_Meridian\",-66.5],PARAMETER[\"Scale_Factor\",0.999912],PARAMETER[\"Latitude_Of_Origin\",46.5],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2953]]",
        2037=>"PROJCS[\"NAD_1983_CSRS_UTM_Zone_19N\",GEOGCS[\"GCS_North_American_1983_CSRS\",DATUM[\"D_North_American_1983_CSRS\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-69.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2960]]",
        2038=>"PROJCS[\"NAD_1983_CSRS_UTM_Zone_20N\",GEOGCS[\"GCS_North_American_1983_CSRS\",DATUM[\"D_North_American_1983_CSRS\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-63.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2961]]",
        2039=>"PROJCS[\"Israel_TM_Grid\",GEOGCS[\"GCS_Israel\",DATUM[\"D_Israel\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",219529.584],PARAMETER[\"False_Northing\",626907.39],PARAMETER[\"Central_Meridian\",35.20451694444445],PARAMETER[\"Scale_Factor\",1.0000067],PARAMETER[\"Latitude_Of_Origin\",31.73439361111111],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2039]]",
        2040=>"PROJCS[\"Locodjo_1965_UTM_Zone_30N\",GEOGCS[\"GCS_Locodjo_1965\",DATUM[\"D_Locodjo_1965\",SPHEROID[\"Clarke_1880_RGS\",6378249.145,293.465]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-3.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2040]]",
        2041=>"PROJCS[\"Abidjan_1987_UTM_Zone_30N\",GEOGCS[\"GCS_Abidjan_1987\",DATUM[\"D_Abidjan_1987\",SPHEROID[\"Clarke_1880_RGS\",6378249.145,293.465]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-3.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2041]]",
        2042=>"PROJCS[\"Locodjo_1965_UTM_Zone_29N\",GEOGCS[\"GCS_Locodjo_1965\",DATUM[\"D_Locodjo_1965\",SPHEROID[\"Clarke_1880_RGS\",6378249.145,293.465]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-9.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2042]]",
        2043=>"PROJCS[\"Abidjan_1987_UTM_Zone_29N\",GEOGCS[\"GCS_Abidjan_1987\",DATUM[\"D_Abidjan_1987\",SPHEROID[\"Clarke_1880_RGS\",6378249.145,293.465]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-9.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2043]]",
        2044=>"PROJCS[\"Hanoi_1972_GK_Zone_18\",GEOGCS[\"GCS_Hanoi_1972\",DATUM[\"D_Hanoi_1972\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",18500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",105.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2044]]",
        2045=>"PROJCS[\"Hanoi_1972_GK_Zone_19\",GEOGCS[\"GCS_Hanoi_1972\",DATUM[\"D_Hanoi_1972\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",19500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",111.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2045]]",
        2056=>"PROJCS[\"CH1903+_LV95\",GEOGCS[\"GCS_CH1903+\",DATUM[\"D_CH1903+\",SPHEROID[\"Bessel_1841\",6377397.155,299.1528128]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Hotine_Oblique_Mercator_Azimuth_Center\"],PARAMETER[\"False_Easting\",2600000.0],PARAMETER[\"False_Northing\",1200000.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Azimuth\",90.0],PARAMETER[\"Longitude_Of_Center\",7.439583333333333],PARAMETER[\"Latitude_Of_Center\",46.95240555555556],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2056]]",
        2057=>"PROJCS[\"Rassadiran_Nakhl_e_Taqi\",GEOGCS[\"GCS_Rassadiran\",DATUM[\"D_Rassadiran\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Hotine_Oblique_Mercator_Azimuth_Center\"],PARAMETER[\"False_Easting\",658377.437],PARAMETER[\"False_Northing\",3044969.194],PARAMETER[\"Scale_Factor\",0.999895934],PARAMETER[\"Azimuth\",0.5716611944444444],PARAMETER[\"Longitude_Of_Center\",52.60353916666667],PARAMETER[\"Latitude_Of_Center\",27.51882880555555],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2057]]",
        2058=>"PROJCS[\"ED_1950_ED77_UTM_Zone_38N\",GEOGCS[\"GCS_European_1950_ED77\",DATUM[\"D_European_1950_ED77\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",45.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2058]]",
        2059=>"PROJCS[\"ED_1950_ED77_UTM_Zone_39N\",GEOGCS[\"GCS_European_1950_ED77\",DATUM[\"D_European_1950_ED77\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",51.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2059]]",
        2060=>"PROJCS[\"ED_1950_ED77_UTM_Zone_40N\",GEOGCS[\"GCS_European_1950_ED77\",DATUM[\"D_European_1950_ED77\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",57.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2060]]",
        2061=>"PROJCS[\"ED_1950_ED77_UTM_Zone_41N\",GEOGCS[\"GCS_European_1950_ED77\",DATUM[\"D_European_1950_ED77\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",63.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2061]]",
        2062=>"PROJCS[\"Madrid_1870_Madrid_Spain\",GEOGCS[\"GCS_Madrid_1870_Madrid\",DATUM[\"D_Madrid_1870\",SPHEROID[\"Struve_1860\",6378298.3,294.73]],PRIMEM[\"Madrid\",-3.687938888888889],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",600000.0],PARAMETER[\"False_Northing\",600000.0],PARAMETER[\"Central_Meridian\",0.0],PARAMETER[\"Standard_Parallel_1\",40.0],PARAMETER[\"Scale_Factor\",0.9988085293],PARAMETER[\"Latitude_Of_Origin\",40.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2062]]",
        2063=>"PROJCS[\"Dabola_1981_UTM_Zone_28N\",GEOGCS[\"GCS_Dabola_1981\",DATUM[\"D_Dabola_1981\",SPHEROID[\"Clarke_1880_IGN\",6378249.2,293.4660212936265]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-15.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3461]]",
        2064=>"PROJCS[\"Dabola_1981_UTM_Zone_29N\",GEOGCS[\"GCS_Dabola_1981\",DATUM[\"D_Dabola_1981\",SPHEROID[\"Clarke_1880_IGN\",6378249.2,293.4660212936265]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-9.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3462]]",
        2065=>"PROJCS[\"S-JTSK_Ferro_Krovak\",GEOGCS[\"GCS_S_JTSK_Ferro\",DATUM[\"D_S_JTSK\",SPHEROID[\"Bessel_1841\",6377397.155,299.1528128]],PRIMEM[\"Ferro\",-17.66666666666667],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Krovak\"],PARAMETER[\"False_Easting\",0.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Pseudo_Standard_Parallel_1\",78.5],PARAMETER[\"Scale_Factor\",0.9999],PARAMETER[\"Azimuth\",30.28813975277778],PARAMETER[\"Longitude_Of_Center\",42.5],PARAMETER[\"Latitude_Of_Center\",49.5],PARAMETER[\"X_Scale\",1.0],PARAMETER[\"Y_Scale\",1.0],PARAMETER[\"XY_Plane_Rotation\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2065]]",
        2066=>"PROJCS[\"Mount_Dillon_Tobago_Grid\",GEOGCS[\"GCS_Mount_Dillon\",DATUM[\"D_Mount_Dillon\",SPHEROID[\"Clarke_1858\",6378293.645208759,294.260676369]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Cassini\"],PARAMETER[\"False_Easting\",187500.0],PARAMETER[\"False_Northing\",180000.0],PARAMETER[\"Central_Meridian\",-60.68600888888889],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",11.25217861111111],UNIT[\"Link_Clarke\",0.201166195164],AUTHORITY[\"EPSG\",2066]]",
        2067=>"PROJCS[\"Naparima_1955_UTM_Zone_20N\",GEOGCS[\"GCS_Naparima_1955\",DATUM[\"D_Naparima_1955\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-63.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2067]]",
        2068=>"PROJCS[\"ELD_1979_Libya_5\",GEOGCS[\"GCS_European_Libyan_Datum_1979\",DATUM[\"D_European_Libyan_1979\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",200000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",9.0],PARAMETER[\"Scale_Factor\",0.9999],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2068]]",
        2069=>"PROJCS[\"ELD_1979_Libya_6\",GEOGCS[\"GCS_European_Libyan_Datum_1979\",DATUM[\"D_European_Libyan_1979\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",200000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",11.0],PARAMETER[\"Scale_Factor\",0.9999],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2069]]",
        2070=>"PROJCS[\"ELD_1979_Libya_7\",GEOGCS[\"GCS_European_Libyan_Datum_1979\",DATUM[\"D_European_Libyan_1979\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",200000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",13.0],PARAMETER[\"Scale_Factor\",0.9999],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2070]]",
        2071=>"PROJCS[\"ELD_1979_Libya_8\",GEOGCS[\"GCS_European_Libyan_Datum_1979\",DATUM[\"D_European_Libyan_1979\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",200000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",15.0],PARAMETER[\"Scale_Factor\",0.9999],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2071]]",
        2072=>"PROJCS[\"ELD_1979_Libya_9\",GEOGCS[\"GCS_European_Libyan_Datum_1979\",DATUM[\"D_European_Libyan_1979\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",200000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",17.0],PARAMETER[\"Scale_Factor\",0.9999],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2072]]",
        2073=>"PROJCS[\"ELD_1979_Libya_10\",GEOGCS[\"GCS_European_Libyan_Datum_1979\",DATUM[\"D_European_Libyan_1979\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",200000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",19.0],PARAMETER[\"Scale_Factor\",0.9999],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2073]]",
        2074=>"PROJCS[\"ELD_1979_Libya_11\",GEOGCS[\"GCS_European_Libyan_Datum_1979\",DATUM[\"D_European_Libyan_1979\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",200000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",21.0],PARAMETER[\"Scale_Factor\",0.9999],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2074]]",
        2075=>"PROJCS[\"ELD_1979_Libya_12\",GEOGCS[\"GCS_European_Libyan_Datum_1979\",DATUM[\"D_European_Libyan_1979\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",200000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",23.0],PARAMETER[\"Scale_Factor\",0.9999],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2075]]",
        2076=>"PROJCS[\"ELD_1979_Libya_13\",GEOGCS[\"GCS_European_Libyan_Datum_1979\",DATUM[\"D_European_Libyan_1979\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",200000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",25.0],PARAMETER[\"Scale_Factor\",0.9999],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2076]]",
        2077=>"PROJCS[\"ELD_1979_UTM_Zone_32N\",GEOGCS[\"GCS_European_Libyan_Datum_1979\",DATUM[\"D_European_Libyan_1979\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",9.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2077]]",
        2078=>"PROJCS[\"ELD_1979_UTM_Zone_33N\",GEOGCS[\"GCS_European_Libyan_Datum_1979\",DATUM[\"D_European_Libyan_1979\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",15.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2078]]",
        2079=>"PROJCS[\"ELD_1979_UTM_Zone_34N\",GEOGCS[\"GCS_European_Libyan_Datum_1979\",DATUM[\"D_European_Libyan_1979\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",21.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2079]]",
        2080=>"PROJCS[\"ELD_1979_UTM_Zone_35N\",GEOGCS[\"GCS_European_Libyan_Datum_1979\",DATUM[\"D_European_Libyan_1979\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",27.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2080]]",
        2081=>"PROJCS[\"Chos_Malal_1914_Argentina_2\",GEOGCS[\"GCS_Chos_Malal_1914\",DATUM[\"D_Chos_Malal_1914\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",2500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-69.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",-90.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2081]]",
        2082=>"PROJCS[\"Pampa_del_Castillo_Argentina_2\",GEOGCS[\"GCS_Pampa_del_Castillo\",DATUM[\"D_Pampa_del_Castillo\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",2500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-69.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",-90.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2082]]",
        2083=>"PROJCS[\"Hito_XVIII_1963_Argentina_2\",GEOGCS[\"GCS_Hito_XVIII_1963\",DATUM[\"D_Hito_XVIII_1963\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",2500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-69.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",-90.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2083]]",
        2084=>"PROJCS[\"Hito_XVIII_1963_UTM_19S\",GEOGCS[\"GCS_Hito_XVIII_1963\",DATUM[\"D_Hito_XVIII_1963\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",10000000.0],PARAMETER[\"Central_Meridian\",-69.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2084]]",
        2085=>"PROJCS[\"NAD_1927_Cuba_Norte\",GEOGCS[\"GCS_North_American_1927\",DATUM[\"D_North_American_1927\",SPHEROID[\"Clarke_1866\",6378206.4,294.9786982]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",280296.016],PARAMETER[\"Central_Meridian\",-81.0],PARAMETER[\"Standard_Parallel_1\",22.35],PARAMETER[\"Scale_Factor\",0.99993602],PARAMETER[\"Latitude_Of_Origin\",22.35],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2085]]",
        2086=>"PROJCS[\"NAD_1927_Cuba_Sur\",GEOGCS[\"GCS_North_American_1927\",DATUM[\"D_North_American_1927\",SPHEROID[\"Clarke_1866\",6378206.4,294.9786982]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",229126.939],PARAMETER[\"Central_Meridian\",-76.83333333333333],PARAMETER[\"Standard_Parallel_1\",20.71666666666667],PARAMETER[\"Scale_Factor\",0.99994848],PARAMETER[\"Latitude_Of_Origin\",20.71666666666667],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2086]]",
        2087=>"PROJCS[\"ELD_1979_TM_12_NE\",GEOGCS[\"GCS_European_Libyan_Datum_1979\",DATUM[\"D_European_Libyan_1979\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",12.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2087]]",
        2088=>"PROJCS[\"Carthage_TM_11_NE\",GEOGCS[\"GCS_Carthage\",DATUM[\"D_Carthage\",SPHEROID[\"Clarke_1880_IGN\",6378249.2,293.4660212936265]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",11.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2088]]",
        2089=>"PROJCS[\"Yemen_NGN_1996_UTM_Zone_38N\",GEOGCS[\"GCS_Yemen_NGN_1996\",DATUM[\"D_Yemen_NGN_1996\",SPHEROID[\"WGS_1984\",6378137.0,298.257223563]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",45.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2089]]",
        2090=>"PROJCS[\"Yemen_NGN_1996_UTM_Zone_39N\",GEOGCS[\"GCS_Yemen_NGN_1996\",DATUM[\"D_Yemen_NGN_1996\",SPHEROID[\"WGS_1984\",6378137.0,298.257223563]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",51.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2090]]",
        2091=>"PROJCS[\"South_Yemen_GK_Zone_8\",GEOGCS[\"GCS_South_Yemen\",DATUM[\"D_South_Yemen\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",8500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",45.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2395]]",
        2092=>"PROJCS[\"South_Yemen_GK_Zone_9\",GEOGCS[\"GCS_South_Yemen\",DATUM[\"D_South_Yemen\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",9500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",51.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2396]]",
        2093=>"PROJCS[\"Hanoi_1972_GK_106_NE\",GEOGCS[\"GCS_Hanoi_1972\",DATUM[\"D_Hanoi_1972\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",106.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2093]]",
        2094=>"PROJCS[\"WGS_1972_BE_TM_106_NE\",GEOGCS[\"GCS_WGS_1972_BE\",DATUM[\"D_WGS_1972_BE\",SPHEROID[\"WGS_1972\",6378135.0,298.26]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",106.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2094]]",
        2095=>"PROJCS[\"Bissau_UTM_Zone_28N\",GEOGCS[\"GCS_Bissau\",DATUM[\"D_Bissau\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-15.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2095]]",
        2096=>"PROJCS[\"Korean_1985_Korea_East_Belt\",GEOGCS[\"GCS_Korean_Datum_1985\",DATUM[\"D_Korean_Datum_1985\",SPHEROID[\"Bessel_1841\",6377397.155,299.1528128]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",200000.0],PARAMETER[\"False_Northing\",500000.0],PARAMETER[\"Central_Meridian\",129.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",38.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2096]]",
        2097=>"PROJCS[\"Korean_1985_Korea_Central_Belt\",GEOGCS[\"GCS_Korean_Datum_1985\",DATUM[\"D_Korean_Datum_1985\",SPHEROID[\"Bessel_1841\",6377397.155,299.1528128]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",200000.0],PARAMETER[\"False_Northing\",500000.0],PARAMETER[\"Central_Meridian\",127.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",38.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2097]]",
        2098=>"PROJCS[\"Korean_1985_Korea_West_Belt\",GEOGCS[\"GCS_Korean_Datum_1985\",DATUM[\"D_Korean_Datum_1985\",SPHEROID[\"Bessel_1841\",6377397.155,299.1528128]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",200000.0],PARAMETER[\"False_Northing\",500000.0],PARAMETER[\"Central_Meridian\",125.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",38.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2098]]",
        2099=>"PROJCS[\"Qatar_1948_Qatar_Grid\",GEOGCS[\"GCS_Qatar_1948\",DATUM[\"D_Qatar_1948\",SPHEROID[\"Helmert_1906\",6378200.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Cassini\"],PARAMETER[\"False_Easting\",100000.0],PARAMETER[\"False_Northing\",100000.0],PARAMETER[\"Central_Meridian\",50.76138888888889],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",25.38236111111111],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2099]]",
        2100=>"PROJCS[\"Greek_Grid\",GEOGCS[\"GCS_GGRS_1987\",DATUM[\"D_GGRS_1987\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",24.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2100]]",
        2101=>"PROJCS[\"Lake_Maracaibo_Grid_M1\",GEOGCS[\"GCS_Lake\",DATUM[\"D_Lake\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",0.0],PARAMETER[\"False_Northing\",-52684.972],PARAMETER[\"Central_Meridian\",-71.60561777777777],PARAMETER[\"Standard_Parallel_1\",10.16666666666667],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",10.16666666666667],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2101]]",
        2102=>"PROJCS[\"Lake_Maracaibo_Grid\",GEOGCS[\"GCS_Lake\",DATUM[\"D_Lake\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",200000.0],PARAMETER[\"False_Northing\",147315.028],PARAMETER[\"Central_Meridian\",-71.60561777777777],PARAMETER[\"Standard_Parallel_1\",10.16666666666667],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",10.16666666666667],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2102]]",
        2103=>"PROJCS[\"Lake_Maracaibo_Grid_M3\",GEOGCS[\"GCS_Lake\",DATUM[\"D_Lake\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",447315.028],PARAMETER[\"Central_Meridian\",-71.60561777777777],PARAMETER[\"Standard_Parallel_1\",10.16666666666667],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",10.16666666666667],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2103]]",
        2104=>"PROJCS[\"Lake_Maracaibo_La_Rosa_Grid\",GEOGCS[\"GCS_Lake\",DATUM[\"D_Lake\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",-17044.0],PARAMETER[\"False_Northing\",-23139.97],PARAMETER[\"Central_Meridian\",-71.60561777777777],PARAMETER[\"Standard_Parallel_1\",10.16666666666667],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",10.16666666666667],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2104]]",
        2105=>"PROJCS[\"NZGD_2000_Mount_Eden_Circuit\",GEOGCS[\"GCS_NZGD_2000\",DATUM[\"D_NZGD_2000\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",400000.0],PARAMETER[\"False_Northing\",800000.0],PARAMETER[\"Central_Meridian\",174.7641666666667],PARAMETER[\"Scale_Factor\",0.9999],PARAMETER[\"Latitude_Of_Origin\",-36.87972222222222],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2105]]",
        2106=>"PROJCS[\"NZGD_2000_Bay_of_Plenty_Circuit\",GEOGCS[\"GCS_NZGD_2000\",DATUM[\"D_NZGD_2000\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",400000.0],PARAMETER[\"False_Northing\",800000.0],PARAMETER[\"Central_Meridian\",176.4661111111111],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",-37.76111111111111],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2106]]",
        2107=>"PROJCS[\"NZGD_2000_Poverty_Bay_Circuit\",GEOGCS[\"GCS_NZGD_2000\",DATUM[\"D_NZGD_2000\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",400000.0],PARAMETER[\"False_Northing\",800000.0],PARAMETER[\"Central_Meridian\",177.8855555555556],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",-38.62444444444444],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2107]]",
        2108=>"PROJCS[\"NZGD_2000_Hawkes_Bay_Circuit\",GEOGCS[\"GCS_NZGD_2000\",DATUM[\"D_NZGD_2000\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",400000.0],PARAMETER[\"False_Northing\",800000.0],PARAMETER[\"Central_Meridian\",176.6736111111111],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",-39.65083333333333],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2108]]",
        2109=>"PROJCS[\"NZGD_2000_Taranaki_Circuit\",GEOGCS[\"GCS_NZGD_2000\",DATUM[\"D_NZGD_2000\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",400000.0],PARAMETER[\"False_Northing\",800000.0],PARAMETER[\"Central_Meridian\",174.2277777777778],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",-39.13555555555556],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2109]]",
        2110=>"PROJCS[\"NZGD_2000_Tuhirangi_Circuit\",GEOGCS[\"GCS_NZGD_2000\",DATUM[\"D_NZGD_2000\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",400000.0],PARAMETER[\"False_Northing\",800000.0],PARAMETER[\"Central_Meridian\",175.64],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",-39.51222222222222],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2110]]",
        2111=>"PROJCS[\"NZGD_2000_Wanganui_Circuit\",GEOGCS[\"GCS_NZGD_2000\",DATUM[\"D_NZGD_2000\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",400000.0],PARAMETER[\"False_Northing\",800000.0],PARAMETER[\"Central_Meridian\",175.4880555555555],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",-40.24194444444444],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2111]]",
        2112=>"PROJCS[\"NZGD_2000_Wairarapa_Circuit\",GEOGCS[\"GCS_NZGD_2000\",DATUM[\"D_NZGD_2000\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",400000.0],PARAMETER[\"False_Northing\",800000.0],PARAMETER[\"Central_Meridian\",175.6472222222222],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",-40.92527777777777],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2112]]",
        2113=>"PROJCS[\"NZGD_2000_Wellington_Circuit\",GEOGCS[\"GCS_NZGD_2000\",DATUM[\"D_NZGD_2000\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",400000.0],PARAMETER[\"False_Northing\",800000.0],PARAMETER[\"Central_Meridian\",174.7763888888889],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",-41.3011111111111],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2113]]",
        2114=>"PROJCS[\"NZGD_2000_Collingwood_Circuit\",GEOGCS[\"GCS_NZGD_2000\",DATUM[\"D_NZGD_2000\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",400000.0],PARAMETER[\"False_Northing\",800000.0],PARAMETER[\"Central_Meridian\",172.6719444444444],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",-40.71472222222223],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2114]]",
        2115=>"PROJCS[\"NZGD_2000_Nelson_Circuit\",GEOGCS[\"GCS_NZGD_2000\",DATUM[\"D_NZGD_2000\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",400000.0],PARAMETER[\"False_Northing\",800000.0],PARAMETER[\"Central_Meridian\",173.2991666666667],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",-41.27444444444444],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2115]]",
        2116=>"PROJCS[\"NZGD_2000_Karamea_Circuit\",GEOGCS[\"GCS_NZGD_2000\",DATUM[\"D_NZGD_2000\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",400000.0],PARAMETER[\"False_Northing\",800000.0],PARAMETER[\"Central_Meridian\",172.1088888888889],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",-41.28972222222222],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2116]]",
        2117=>"PROJCS[\"NZGD_2000_Buller_Circuit\",GEOGCS[\"GCS_NZGD_2000\",DATUM[\"D_NZGD_2000\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",400000.0],PARAMETER[\"False_Northing\",800000.0],PARAMETER[\"Central_Meridian\",171.5811111111111],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",-41.81055555555555],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2117]]",
        2118=>"PROJCS[\"NZGD_2000_Grey_Circuit\",GEOGCS[\"GCS_NZGD_2000\",DATUM[\"D_NZGD_2000\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",400000.0],PARAMETER[\"False_Northing\",800000.0],PARAMETER[\"Central_Meridian\",171.5497222222222],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",-42.33361111111111],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2118]]",
        2119=>"PROJCS[\"NZGD_2000_Amuri_Circuit\",GEOGCS[\"GCS_NZGD_2000\",DATUM[\"D_NZGD_2000\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",400000.0],PARAMETER[\"False_Northing\",800000.0],PARAMETER[\"Central_Meridian\",173.01],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",-42.68888888888888],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2119]]",
        2120=>"PROJCS[\"NZGD_2000_Marlborough_Circuit\",GEOGCS[\"GCS_NZGD_2000\",DATUM[\"D_NZGD_2000\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",400000.0],PARAMETER[\"False_Northing\",800000.0],PARAMETER[\"Central_Meridian\",173.8019444444444],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",-41.54444444444444],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2120]]",
        2121=>"PROJCS[\"NZGD_2000_Hokitika_Circuit\",GEOGCS[\"GCS_NZGD_2000\",DATUM[\"D_NZGD_2000\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",400000.0],PARAMETER[\"False_Northing\",800000.0],PARAMETER[\"Central_Meridian\",170.9797222222222],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",-42.88611111111111],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2121]]",
        2122=>"PROJCS[\"NZGD_2000_Okarito_Circuit\",GEOGCS[\"GCS_NZGD_2000\",DATUM[\"D_NZGD_2000\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",400000.0],PARAMETER[\"False_Northing\",800000.0],PARAMETER[\"Central_Meridian\",170.2608333333333],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",-43.11],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2122]]",
        2123=>"PROJCS[\"NZGD_2000_Jacksons_Bay_Circuit\",GEOGCS[\"GCS_NZGD_2000\",DATUM[\"D_NZGD_2000\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",400000.0],PARAMETER[\"False_Northing\",800000.0],PARAMETER[\"Central_Meridian\",168.6061111111111],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",-43.97777777777778],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2123]]",
        2124=>"PROJCS[\"NZGD_2000_Mount_Pleasant_Circuit\",GEOGCS[\"GCS_NZGD_2000\",DATUM[\"D_NZGD_2000\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",400000.0],PARAMETER[\"False_Northing\",800000.0],PARAMETER[\"Central_Meridian\",172.7269444444445],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",-43.59055555555556],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2124]]",
        2125=>"PROJCS[\"NZGD_2000_Gawler_Circuit\",GEOGCS[\"GCS_NZGD_2000\",DATUM[\"D_NZGD_2000\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",400000.0],PARAMETER[\"False_Northing\",800000.0],PARAMETER[\"Central_Meridian\",171.3605555555555],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",-43.74861111111111],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2125]]",
        2126=>"PROJCS[\"NZGD_2000_Timaru_Circuit\",GEOGCS[\"GCS_NZGD_2000\",DATUM[\"D_NZGD_2000\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",400000.0],PARAMETER[\"False_Northing\",800000.0],PARAMETER[\"Central_Meridian\",171.0572222222222],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",-44.40194444444445],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2126]]",
        2127=>"PROJCS[\"NZGD_2000_Lindis_Peak_Circuit\",GEOGCS[\"GCS_NZGD_2000\",DATUM[\"D_NZGD_2000\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",400000.0],PARAMETER[\"False_Northing\",800000.0],PARAMETER[\"Central_Meridian\",169.4675],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",-44.735],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2127]]",
        2128=>"PROJCS[\"NZGD_2000_Mount_Nicholas_Circuit\",GEOGCS[\"GCS_NZGD_2000\",DATUM[\"D_NZGD_2000\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",400000.0],PARAMETER[\"False_Northing\",800000.0],PARAMETER[\"Central_Meridian\",168.3986111111111],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",-45.13277777777778],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2128]]",
        2129=>"PROJCS[\"NZGD_2000_Mount_York_Circuit\",GEOGCS[\"GCS_NZGD_2000\",DATUM[\"D_NZGD_2000\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",400000.0],PARAMETER[\"False_Northing\",800000.0],PARAMETER[\"Central_Meridian\",167.7386111111111],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",-45.56361111111111],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2129]]",
        2130=>"PROJCS[\"NZGD_2000_Observation_Point_Circuit\",GEOGCS[\"GCS_NZGD_2000\",DATUM[\"D_NZGD_2000\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",400000.0],PARAMETER[\"False_Northing\",800000.0],PARAMETER[\"Central_Meridian\",170.6283333333333],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",-45.81611111111111],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2130]]",
        2131=>"PROJCS[\"NZGD_2000_North_Taieri_Circuit\",GEOGCS[\"GCS_NZGD_2000\",DATUM[\"D_NZGD_2000\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",400000.0],PARAMETER[\"False_Northing\",800000.0],PARAMETER[\"Central_Meridian\",170.2825],PARAMETER[\"Scale_Factor\",0.99996],PARAMETER[\"Latitude_Of_Origin\",-45.86138888888889],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2131]]",
        2132=>"PROJCS[\"NZGD_2000_Bluff_Circuit\",GEOGCS[\"GCS_NZGD_2000\",DATUM[\"D_NZGD_2000\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",400000.0],PARAMETER[\"False_Northing\",800000.0],PARAMETER[\"Central_Meridian\",168.3427777777778],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",-46.6],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2132]]",
        2133=>"PROJCS[\"NZGD_2000_UTM_Zone_58S\",GEOGCS[\"GCS_NZGD_2000\",DATUM[\"D_NZGD_2000\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",10000000.0],PARAMETER[\"Central_Meridian\",165.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2133]]",
        2134=>"PROJCS[\"NZGD_2000_UTM_Zone_59S\",GEOGCS[\"GCS_NZGD_2000\",DATUM[\"D_NZGD_2000\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",10000000.0],PARAMETER[\"Central_Meridian\",171.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2134]]",
        2135=>"PROJCS[\"NZGD_2000_UTM_Zone_60S\",GEOGCS[\"GCS_NZGD_2000\",DATUM[\"D_NZGD_2000\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",10000000.0],PARAMETER[\"Central_Meridian\",177.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2135]]",
        2136=>"PROJCS[\"Accra_Ghana_Grid\",GEOGCS[\"GCS_Accra\",DATUM[\"D_Accra\",SPHEROID[\"War_Office\",6378300.0,296.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",900000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-1.0],PARAMETER[\"Scale_Factor\",0.99975],PARAMETER[\"Latitude_Of_Origin\",4.666666666666667],UNIT[\"Foot_Gold_Coast\",0.3047997101815088],AUTHORITY[\"EPSG\",2136]]",
        2137=>"PROJCS[\"Accra_TM_1_NW\",GEOGCS[\"GCS_Accra\",DATUM[\"D_Accra\",SPHEROID[\"War_Office\",6378300.0,296.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-1.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2137]]",
        2138=>"PROJCS[\"NAD_1927_CGQ77_Quebec_Lambert\",GEOGCS[\"GCS_NAD_1927_CGQ77\",DATUM[\"D_NAD_1927_CGQ77\",SPHEROID[\"Clarke_1866\",6378206.4,294.9786982]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",0.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-68.5],PARAMETER[\"Standard_Parallel_1\",46.0],PARAMETER[\"Standard_Parallel_2\",60.0],PARAMETER[\"Latitude_Of_Origin\",44.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2138]]",
        2139=>"PROJCS[\"NAD_1983_CSRS_MTM_2_SCoPQ\",GEOGCS[\"GCS_North_American_1983_CSRS\",DATUM[\"D_North_American_1983_CSRS\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",304800.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-55.5],PARAMETER[\"Scale_Factor\",0.9999],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2944]]",
        2140=>"PROJCS[\"NAD_1983_CSRS_MTM_3\",GEOGCS[\"GCS_North_American_1983_CSRS\",DATUM[\"D_North_American_1983_CSRS\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",304800.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-58.5],PARAMETER[\"Scale_Factor\",0.9999],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2945]]",
        2141=>"PROJCS[\"NAD_1983_CSRS_MTM_4\",GEOGCS[\"GCS_North_American_1983_CSRS\",DATUM[\"D_North_American_1983_CSRS\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",304800.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-61.5],PARAMETER[\"Scale_Factor\",0.9999],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2946]]",
        2142=>"PROJCS[\"NAD_1983_CSRS_MTM_5\",GEOGCS[\"GCS_North_American_1983_CSRS\",DATUM[\"D_North_American_1983_CSRS\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",304800.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-64.5],PARAMETER[\"Scale_Factor\",0.9999],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2947]]",
        2143=>"PROJCS[\"NAD_1983_CSRS_MTM_6\",GEOGCS[\"GCS_North_American_1983_CSRS\",DATUM[\"D_North_American_1983_CSRS\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",304800.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-67.5],PARAMETER[\"Scale_Factor\",0.9999],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2948]]",
        2144=>"PROJCS[\"NAD_1983_CSRS_MTM_7\",GEOGCS[\"GCS_North_American_1983_CSRS\",DATUM[\"D_North_American_1983_CSRS\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",304800.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-70.5],PARAMETER[\"Scale_Factor\",0.9999],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2949]]",
        2145=>"PROJCS[\"NAD_1983_CSRS_MTM_8\",GEOGCS[\"GCS_North_American_1983_CSRS\",DATUM[\"D_North_American_1983_CSRS\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",304800.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-73.5],PARAMETER[\"Scale_Factor\",0.9999],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2950]]",
        2146=>"PROJCS[\"NAD_1983_CSRS_MTM_9\",GEOGCS[\"GCS_North_American_1983_CSRS\",DATUM[\"D_North_American_1983_CSRS\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",304800.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-76.5],PARAMETER[\"Scale_Factor\",0.9999],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2951]]",
        2147=>"PROJCS[\"NAD_1983_CSRS_MTM_10\",GEOGCS[\"GCS_North_American_1983_CSRS\",DATUM[\"D_North_American_1983_CSRS\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",304800.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-79.5],PARAMETER[\"Scale_Factor\",0.9999],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2952]]",
        2148=>"PROJCS[\"NAD_1983_CSRS_UTM_Zone_21N\",GEOGCS[\"GCS_North_American_1983_CSRS\",DATUM[\"D_North_American_1983_CSRS\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-57.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2962]]",
        2149=>"PROJCS[\"NAD_1983_CSRS_UTM_Zone_18N\",GEOGCS[\"GCS_North_American_1983_CSRS\",DATUM[\"D_North_American_1983_CSRS\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-75.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2959]]",
        2150=>"PROJCS[\"NAD_1983_CSRS_UTM_Zone_17N\",GEOGCS[\"GCS_North_American_1983_CSRS\",DATUM[\"D_North_American_1983_CSRS\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-81.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2958]]",
        2151=>"PROJCS[\"NAD_1983_CSRS_UTM_Zone_13N\",GEOGCS[\"GCS_North_American_1983_CSRS\",DATUM[\"D_North_American_1983_CSRS\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-105.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2957]]",
        2152=>"PROJCS[\"NAD_1983_CSRS_UTM_Zone_12N\",GEOGCS[\"GCS_North_American_1983_CSRS\",DATUM[\"D_North_American_1983_CSRS\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-111.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2956]]",
        2153=>"PROJCS[\"NAD_1983_CSRS_UTM_Zone_11N\",GEOGCS[\"GCS_North_American_1983_CSRS\",DATUM[\"D_North_American_1983_CSRS\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-117.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2955]]",
        2154=>"PROJCS[\"RGF_1993_Lambert_93\",GEOGCS[\"GCS_RGF_1993\",DATUM[\"D_RGF_1993\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",700000.0],PARAMETER[\"False_Northing\",6600000.0],PARAMETER[\"Central_Meridian\",3.0],PARAMETER[\"Standard_Parallel_1\",44.0],PARAMETER[\"Standard_Parallel_2\",49.0],PARAMETER[\"Latitude_Of_Origin\",46.5],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2154]]",
        2155=>"PROJCS[\"Samoa_1962_Samoa_Lambert\",GEOGCS[\"GCS_American_Samoa_1962\",DATUM[\"D_American_Samoa_1962\",SPHEROID[\"Clarke_1866\",6378206.4,294.9786982]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",312234.65],PARAMETER[\"Central_Meridian\",-170.0],PARAMETER[\"Standard_Parallel_1\",-14.26666666666667],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",-14.26666666666667],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",3102]]",
        2157=>"PROJCS[\"IRENET95_Irish_Transverse_Mercator\",GEOGCS[\"GCS_IRENET95\",DATUM[\"D_IRENET95\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",600000.0],PARAMETER[\"False_Northing\",750000.0],PARAMETER[\"Central_Meridian\",-8.0],PARAMETER[\"Scale_Factor\",0.99982],PARAMETER[\"Latitude_Of_Origin\",53.5],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2157]]",
        2158=>"PROJCS[\"IRENET95_UTM_Zone_29N\",GEOGCS[\"GCS_IRENET95\",DATUM[\"D_IRENET95\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-9.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2158]]",
        2159=>"PROJCS[\"Sierra_Leone_1924_New_Colony_Grid\",GEOGCS[\"GCS_Sierra_Leone_1924\",DATUM[\"D_Sierra_Leone_1924\",SPHEROID[\"War_Office\",6378300.0,296.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-12.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",6.666666666666667],UNIT[\"Foot_Gold_Coast\",0.3047997101815088],AUTHORITY[\"EPSG\",2159]]",
        2160=>"PROJCS[\"Sierra_Leone_1924_New_War_Office_Grid\",GEOGCS[\"GCS_Sierra_Leone_1924\",DATUM[\"D_Sierra_Leone_1924\",SPHEROID[\"War_Office\",6378300.0,296.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",800000.0],PARAMETER[\"False_Northing\",600000.0],PARAMETER[\"Central_Meridian\",-12.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",6.666666666666667],UNIT[\"Foot_Gold_Coast\",0.3047997101815088],AUTHORITY[\"EPSG\",2160]]",
        2161=>"PROJCS[\"Sierra_Leone_1968_UTM_Zone_28N\",GEOGCS[\"GCS_Sierra_Leone_1968\",DATUM[\"D_Sierra_Leone_1968\",SPHEROID[\"Clarke_1880_RGS\",6378249.145,293.465]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-15.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2161]]",
        2162=>"PROJCS[\"Sierra_Leone_1968_UTM_Zone_29N\",GEOGCS[\"GCS_Sierra_Leone_1968\",DATUM[\"D_Sierra_Leone_1968\",SPHEROID[\"Clarke_1880_RGS\",6378249.145,293.465]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-9.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2162]]",
        2163=>"PROJCS[\"US_National_Atlas_Equal_Area\",GEOGCS[\"GCS_Sphere_Clarke_1866_Authalic\",DATUM[\"D_Sphere_Clarke_1866_Authalic\",SPHEROID[\"Sphere_Clarke_1866_Authalic\",6370997.0,0.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Azimuthal_Equal_Area\"],PARAMETER[\"False_Easting\",0.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-100.0],PARAMETER[\"Latitude_Of_Origin\",45.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2163]]",
        2164=>"PROJCS[\"Locodjo_1965_TM_5_NW\",GEOGCS[\"GCS_Locodjo_1965\",DATUM[\"D_Locodjo_1965\",SPHEROID[\"Clarke_1880_RGS\",6378249.145,293.465]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-5.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2164]]",
        2165=>"PROJCS[\"Abidjan_1987_TM_5_NW\",GEOGCS[\"GCS_Abidjan_1987\",DATUM[\"D_Abidjan_1987\",SPHEROID[\"Clarke_1880_RGS\",6378249.145,293.465]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-5.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2165]]",
        2166=>"PROJCS[\"Pulkovo_1942_Adj_1983_3_Degree_GK_Zone_3\",GEOGCS[\"GCS_Pulkovo_1942_Adj_1983\",DATUM[\"D_Pulkovo_1942_Adj_1983\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",3500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",9.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2397]]",
        2167=>"PROJCS[\"Pulkovo_1942_Adj_1983_3_Degree_GK_Zone_4\",GEOGCS[\"GCS_Pulkovo_1942_Adj_1983\",DATUM[\"D_Pulkovo_1942_Adj_1983\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",4500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",12.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2398]]",
        2168=>"PROJCS[\"Pulkovo_1942_Adj_1983_3_Degree_GK_Zone_5\",GEOGCS[\"GCS_Pulkovo_1942_Adj_1983\",DATUM[\"D_Pulkovo_1942_Adj_1983\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",5500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",15.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2399]]",
        2169=>"PROJCS[\"Luxembourg_1930_Gauss\",GEOGCS[\"GCS_Luxembourg_1930\",DATUM[\"D_Luxembourg_1930\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",80000.0],PARAMETER[\"False_Northing\",100000.0],PARAMETER[\"Central_Meridian\",6.166666666666667],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",49.83333333333334],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2169]]",
        2170=>"PROJCS[\"MGI_Slovenia_Grid\",GEOGCS[\"GCS_MGI\",DATUM[\"D_MGI\",SPHEROID[\"Bessel_1841\",6377397.155,299.1528128]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",15.0],PARAMETER[\"Scale_Factor\",0.9999],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2170]]",
        2172=>"PROJCS[\"Pulkovo_1942_Adj_1958_Poland_Zone_II\",GEOGCS[\"GCS_Pulkovo_1942_Adj_1958\",DATUM[\"D_Pulkovo_1942_Adj_1958\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Double_Stereographic\"],PARAMETER[\"False_Easting\",4603000.0],PARAMETER[\"False_Northing\",5806000.0],PARAMETER[\"Central_Meridian\",21.50277777777778],PARAMETER[\"Scale_Factor\",0.9998],PARAMETER[\"Latitude_Of_Origin\",53.00194444444445],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2172]]",
        2173=>"PROJCS[\"Pulkovo_1942_Adj_1958_Poland_Zone_III\",GEOGCS[\"GCS_Pulkovo_1942_Adj_1958\",DATUM[\"D_Pulkovo_1942_Adj_1958\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Double_Stereographic\"],PARAMETER[\"False_Easting\",3501000.0],PARAMETER[\"False_Northing\",5999000.0],PARAMETER[\"Central_Meridian\",17.00833333333333],PARAMETER[\"Scale_Factor\",0.9998],PARAMETER[\"Latitude_Of_Origin\",53.58333333333334],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2173]]",
        2174=>"PROJCS[\"Pulkovo_1942_Adj_1958_Poland_Zone_IV\",GEOGCS[\"GCS_Pulkovo_1942_Adj_1958\",DATUM[\"D_Pulkovo_1942_Adj_1958\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Double_Stereographic\"],PARAMETER[\"False_Easting\",3703000.0],PARAMETER[\"False_Northing\",5627000.0],PARAMETER[\"Central_Meridian\",16.67222222222222],PARAMETER[\"Scale_Factor\",0.9998],PARAMETER[\"Latitude_Of_Origin\",51.67083333333333],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2174]]",
        2175=>"PROJCS[\"Pulkovo_1942_Adj_1958_Poland_Zone_V\",GEOGCS[\"GCS_Pulkovo_1942_Adj_1958\",DATUM[\"D_Pulkovo_1942_Adj_1958\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",237000.0],PARAMETER[\"False_Northing\",-4700000.0],PARAMETER[\"Central_Meridian\",18.95833333333333],PARAMETER[\"Scale_Factor\",0.999983],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2175]]",
        2176=>"PROJCS[\"ETRS_1989_Poland_CS2000_Zone_5\",GEOGCS[\"GCS_ETRS_1989\",DATUM[\"D_ETRS_1989\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",5500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",15.0],PARAMETER[\"Scale_Factor\",0.999923],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2176]]",
        2177=>"PROJCS[\"ETRS_1989_Poland_CS2000_Zone_6\",GEOGCS[\"GCS_ETRS_1989\",DATUM[\"D_ETRS_1989\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",6500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",18.0],PARAMETER[\"Scale_Factor\",0.999923],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2177]]",
        2178=>"PROJCS[\"ETRS_1989_Poland_CS2000_Zone_7\",GEOGCS[\"GCS_ETRS_1989\",DATUM[\"D_ETRS_1989\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",7500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",21.0],PARAMETER[\"Scale_Factor\",0.999923],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2178]]",
        2179=>"PROJCS[\"ETRS_1989_Poland_CS2000_Zone_8\",GEOGCS[\"GCS_ETRS_1989\",DATUM[\"D_ETRS_1989\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",8500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",24.0],PARAMETER[\"Scale_Factor\",0.999923],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2179]]",
        2180=>"PROJCS[\"ETRS_1989_Poland_CS92\",GEOGCS[\"GCS_ETRS_1989\",DATUM[\"D_ETRS_1989\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",-5300000.0],PARAMETER[\"Central_Meridian\",19.0],PARAMETER[\"Scale_Factor\",0.9993],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2180]]",
        2188=>"PROJCS[\"Azores_Occidental_1939_UTM_Zone_25N\",GEOGCS[\"GCS_Azores_Occidental_1939\",DATUM[\"D_Azores_Occidental_Islands_1939\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-33.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2188]]",
        2189=>"PROJCS[\"Azores_Central_1948_UTM_Zone_26N\",GEOGCS[\"GCS_Azores_Central_1948\",DATUM[\"D_Azores_Central_Islands_1948\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-27.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2189]]",
        2190=>"PROJCS[\"Azores_Oriental_1940_UTM_Zone_26N\",GEOGCS[\"GCS_Azores_Oriental_1940\",DATUM[\"D_Azores_Oriental_Islands_1940\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-27.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2190]]",
        2191=>"PROJCS[\"Madeira_1936_UTM_Zone_28N\",GEOGCS[\"GCS_Madeira_1936\",DATUM[\"D_Madeira_1936\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-15.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2191]]",
        2192=>"PROJCS[\"ED_1950_France_EuroLambert\",GEOGCS[\"GCS_European_1950\",DATUM[\"D_European_1950\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",600000.0],PARAMETER[\"False_Northing\",2200000.0],PARAMETER[\"Central_Meridian\",2.337229166666667],PARAMETER[\"Standard_Parallel_1\",46.8],PARAMETER[\"Scale_Factor\",0.99987742],PARAMETER[\"Latitude_Of_Origin\",46.8],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2192]]",
        2193=>"PROJCS[\"NZGD_2000_New_Zealand_Transverse_Mercator\",GEOGCS[\"GCS_NZGD_2000\",DATUM[\"D_NZGD_2000\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",1600000.0],PARAMETER[\"False_Northing\",10000000.0],PARAMETER[\"Central_Meridian\",173.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2193]]",
        2195=>"PROJCS[\"NAD_1983_HARN_UTM_Zone_2S\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",10000000.0],PARAMETER[\"Central_Meridian\",-171.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2195]]",
        2196=>"PROJCS[\"ETRS_1989_Kp2000_Jutland\",GEOGCS[\"GCS_ETRS_1989\",DATUM[\"D_ETRS_1989\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",200000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",9.5],PARAMETER[\"Scale_Factor\",0.99995],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2196]]",
        2197=>"PROJCS[\"ETRS_1989_Kp2000_Zealand\",GEOGCS[\"GCS_ETRS_1989\",DATUM[\"D_ETRS_1989\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",12.0],PARAMETER[\"Scale_Factor\",0.99995],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2197]]",
        2198=>"PROJCS[\"ETRS_1989_Kp2000_Bornholm\",GEOGCS[\"GCS_ETRS_1989\",DATUM[\"D_ETRS_1989\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",900000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",15.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2198]]",
        2200=>"PROJCS[\"ATS_1977_New_Brunswick_Stereographic\",GEOGCS[\"GCS_ATS_1977\",DATUM[\"D_ATS_1977\",SPHEROID[\"ATS_1977\",6378135.0,298.257]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Double_Stereographic\"],PARAMETER[\"False_Easting\",300000.0],PARAMETER[\"False_Northing\",800000.0],PARAMETER[\"Central_Meridian\",-66.5],PARAMETER[\"Scale_Factor\",0.999912],PARAMETER[\"Latitude_Of_Origin\",46.5],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2200]]",
        2201=>"PROJCS[\"REGVEN_UTM_Zone_18N\",GEOGCS[\"GCS_REGVEN\",DATUM[\"D_REGVEN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-75.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2201]]",
        2202=>"PROJCS[\"REGVEN_UTM_Zone_19N\",GEOGCS[\"GCS_REGVEN\",DATUM[\"D_REGVEN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-69.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2202]]",
        2203=>"PROJCS[\"REGVEN_UTM_Zone_20N\",GEOGCS[\"GCS_REGVEN\",DATUM[\"D_REGVEN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-63.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2203]]",
        2204=>"PROJCS[\"NAD_1927_StatePlane_Tennessee_FIPS_4100\",GEOGCS[\"GCS_North_American_1927\",DATUM[\"D_North_American_1927\",SPHEROID[\"Clarke_1866\",6378206.4,294.9786982]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",2000000.0],PARAMETER[\"False_Northing\",100000.0],PARAMETER[\"Central_Meridian\",-86.0],PARAMETER[\"Standard_Parallel_1\",35.25],PARAMETER[\"Standard_Parallel_2\",36.41666666666666],PARAMETER[\"Latitude_Of_Origin\",34.66666666666666],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",2204]]",
        2205=>"PROJCS[\"NAD_1983_StatePlane_Kentucky_North_FIPS_1601\",GEOGCS[\"GCS_North_American_1983\",DATUM[\"D_North_American_1983\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-84.25],PARAMETER[\"Standard_Parallel_1\",37.96666666666667],PARAMETER[\"Standard_Parallel_2\",38.96666666666667],PARAMETER[\"Latitude_Of_Origin\",37.5],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2205]]",
        2206=>"PROJCS[\"ED_1950_3_Degree_GK_Zone_9\",GEOGCS[\"GCS_European_1950\",DATUM[\"D_European_1950\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",9500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",27.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2206]]",
        2207=>"PROJCS[\"ED_1950_3_Degree_GK_Zone_10\",GEOGCS[\"GCS_European_1950\",DATUM[\"D_European_1950\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",10500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",30.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2207]]",
        2208=>"PROJCS[\"ED_1950_3_Degree_GK_Zone_11\",GEOGCS[\"GCS_European_1950\",DATUM[\"D_European_1950\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",11500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",33.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2208]]",
        2209=>"PROJCS[\"ED_1950_3_Degree_GK_Zone_12\",GEOGCS[\"GCS_European_1950\",DATUM[\"D_European_1950\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",12500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",36.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2209]]",
        2210=>"PROJCS[\"ED_1950_3_Degree_GK_Zone_13\",GEOGCS[\"GCS_European_1950\",DATUM[\"D_European_1950\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",13500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",39.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2210]]",
        2211=>"PROJCS[\"ED_1950_3_Degree_GK_Zone_14\",GEOGCS[\"GCS_European_1950\",DATUM[\"D_European_1950\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",14500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",42.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2211]]",
        2212=>"PROJCS[\"ED_1950_3_Degree_GK_Zone_15\",GEOGCS[\"GCS_European_1950\",DATUM[\"D_European_1950\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",15500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",45.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2212]]",
        2213=>"PROJCS[\"ETRS_1989_TM_30_NE\",GEOGCS[\"GCS_ETRS_1989\",DATUM[\"D_ETRS_1989\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",30.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2213]]",
        2214=>"PROJCS[\"Douala_1948_AEF_West\",GEOGCS[\"GCS_Douala_1948\",DATUM[\"D_Douala_1948\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",1000000.0],PARAMETER[\"False_Northing\",1000000.0],PARAMETER[\"Central_Meridian\",10.5],PARAMETER[\"Scale_Factor\",0.999],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3119]]",
        2215=>"PROJCS[\"Manoca_1962_UTM_Zone_32N\",GEOGCS[\"GCS_Manoca_1962\",DATUM[\"D_Manoca_1962\",SPHEROID[\"Clarke_1880_IGN\",6378249.2,293.4660212936265]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",9.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2215]]",
        2216=>"PROJCS[\"Qornoq_1927_UTM_Zone_22N\",GEOGCS[\"GCS_Qornoq_1927\",DATUM[\"D_Qornoq_1927\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-51.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2216]]",
        2217=>"PROJCS[\"Qornoq_1927_UTM_Zone_23N\",GEOGCS[\"GCS_Qornoq_1927\",DATUM[\"D_Qornoq_1927\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-45.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2217]]",
        2219=>"PROJCS[\"ATS_1977_UTM_Zone_19N\",GEOGCS[\"GCS_ATS_1977\",DATUM[\"D_ATS_1977\",SPHEROID[\"ATS_1977\",6378135.0,298.257]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-69.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2219]]",
        2220=>"PROJCS[\"ATS_1977_UTM_Zone_20N\",GEOGCS[\"GCS_ATS_1977\",DATUM[\"D_ATS_1977\",SPHEROID[\"ATS_1977\",6378135.0,298.257]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-63.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2220]]",
        2222=>"PROJCS[\"NAD_1983_StatePlane_Arizona_East_FIPS_0201_Feet_Intl\",GEOGCS[\"GCS_North_American_1983\",DATUM[\"D_North_American_1983\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",700000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-110.1666666666667],PARAMETER[\"Scale_Factor\",0.9999],PARAMETER[\"Latitude_Of_Origin\",31.0],UNIT[\"Foot\",0.3048],AUTHORITY[\"EPSG\",2222]]",
        2223=>"PROJCS[\"NAD_1983_StatePlane_Arizona_Central_FIPS_0202_Feet_Intl\",GEOGCS[\"GCS_North_American_1983\",DATUM[\"D_North_American_1983\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",700000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-111.9166666666667],PARAMETER[\"Scale_Factor\",0.9999],PARAMETER[\"Latitude_Of_Origin\",31.0],UNIT[\"Foot\",0.3048],AUTHORITY[\"EPSG\",2223]]",
        2224=>"PROJCS[\"NAD_1983_StatePlane_Arizona_West_FIPS_0203_Feet_Intl\",GEOGCS[\"GCS_North_American_1983\",DATUM[\"D_North_American_1983\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",700000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-113.75],PARAMETER[\"Scale_Factor\",0.9999333333333333],PARAMETER[\"Latitude_Of_Origin\",31.0],UNIT[\"Foot\",0.3048],AUTHORITY[\"EPSG\",2224]]",
        2225=>"PROJCS[\"NAD_1983_StatePlane_California_I_FIPS_0401_Feet\",GEOGCS[\"GCS_North_American_1983\",DATUM[\"D_North_American_1983\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",6561666.666666666],PARAMETER[\"False_Northing\",1640416.666666667],PARAMETER[\"Central_Meridian\",-122.0],PARAMETER[\"Standard_Parallel_1\",40.0],PARAMETER[\"Standard_Parallel_2\",41.66666666666666],PARAMETER[\"Latitude_Of_Origin\",39.33333333333334],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",2225]]",
        2226=>"PROJCS[\"NAD_1983_StatePlane_California_II_FIPS_0402_Feet\",GEOGCS[\"GCS_North_American_1983\",DATUM[\"D_North_American_1983\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",6561666.666666666],PARAMETER[\"False_Northing\",1640416.666666667],PARAMETER[\"Central_Meridian\",-122.0],PARAMETER[\"Standard_Parallel_1\",38.33333333333334],PARAMETER[\"Standard_Parallel_2\",39.83333333333334],PARAMETER[\"Latitude_Of_Origin\",37.66666666666666],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",2226]]",
        2227=>"PROJCS[\"NAD_1983_StatePlane_California_III_FIPS_0403_Feet\",GEOGCS[\"GCS_North_American_1983\",DATUM[\"D_North_American_1983\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",6561666.666666666],PARAMETER[\"False_Northing\",1640416.666666667],PARAMETER[\"Central_Meridian\",-120.5],PARAMETER[\"Standard_Parallel_1\",37.06666666666667],PARAMETER[\"Standard_Parallel_2\",38.43333333333333],PARAMETER[\"Latitude_Of_Origin\",36.5],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",2227]]",
        2228=>"PROJCS[\"NAD_1983_StatePlane_California_IV_FIPS_0404_Feet\",GEOGCS[\"GCS_North_American_1983\",DATUM[\"D_North_American_1983\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",6561666.666666666],PARAMETER[\"False_Northing\",1640416.666666667],PARAMETER[\"Central_Meridian\",-119.0],PARAMETER[\"Standard_Parallel_1\",36.0],PARAMETER[\"Standard_Parallel_2\",37.25],PARAMETER[\"Latitude_Of_Origin\",35.33333333333334],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",2228]]",
        2229=>"PROJCS[\"NAD_1983_StatePlane_California_V_FIPS_0405_Feet\",GEOGCS[\"GCS_North_American_1983\",DATUM[\"D_North_American_1983\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",6561666.666666666],PARAMETER[\"False_Northing\",1640416.666666667],PARAMETER[\"Central_Meridian\",-118.0],PARAMETER[\"Standard_Parallel_1\",34.03333333333333],PARAMETER[\"Standard_Parallel_2\",35.46666666666667],PARAMETER[\"Latitude_Of_Origin\",33.5],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",2229]]",
        2230=>"PROJCS[\"NAD_1983_StatePlane_California_VI_FIPS_0406_Feet\",GEOGCS[\"GCS_North_American_1983\",DATUM[\"D_North_American_1983\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",6561666.666666666],PARAMETER[\"False_Northing\",1640416.666666667],PARAMETER[\"Central_Meridian\",-116.25],PARAMETER[\"Standard_Parallel_1\",32.78333333333333],PARAMETER[\"Standard_Parallel_2\",33.88333333333333],PARAMETER[\"Latitude_Of_Origin\",32.16666666666666],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",2230]]",
        2231=>"PROJCS[\"NAD_1983_StatePlane_Colorado_North_FIPS_0501_Feet\",GEOGCS[\"GCS_North_American_1983\",DATUM[\"D_North_American_1983\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",3000000.000316083],PARAMETER[\"False_Northing\",999999.999996],PARAMETER[\"Central_Meridian\",-105.5],PARAMETER[\"Standard_Parallel_1\",39.71666666666667],PARAMETER[\"Standard_Parallel_2\",40.78333333333333],PARAMETER[\"Latitude_Of_Origin\",39.33333333333334],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",2231]]",
        2232=>"PROJCS[\"NAD_1983_StatePlane_Colorado_Central_FIPS_0502_Feet\",GEOGCS[\"GCS_North_American_1983\",DATUM[\"D_North_American_1983\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",3000000.000316083],PARAMETER[\"False_Northing\",999999.999996],PARAMETER[\"Central_Meridian\",-105.5],PARAMETER[\"Standard_Parallel_1\",38.45],PARAMETER[\"Standard_Parallel_2\",39.75],PARAMETER[\"Latitude_Of_Origin\",37.83333333333334],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",2232]]",
        2233=>"PROJCS[\"NAD_1983_StatePlane_Colorado_South_FIPS_0503_Feet\",GEOGCS[\"GCS_North_American_1983\",DATUM[\"D_North_American_1983\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",3000000.000316083],PARAMETER[\"False_Northing\",999999.999996],PARAMETER[\"Central_Meridian\",-105.5],PARAMETER[\"Standard_Parallel_1\",37.23333333333333],PARAMETER[\"Standard_Parallel_2\",38.43333333333333],PARAMETER[\"Latitude_Of_Origin\",36.66666666666666],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",2233]]",
        2234=>"PROJCS[\"NAD_1983_StatePlane_Connecticut_FIPS_0600_Feet\",GEOGCS[\"GCS_North_American_1983\",DATUM[\"D_North_American_1983\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",999999.999996],PARAMETER[\"False_Northing\",499999.999998],PARAMETER[\"Central_Meridian\",-72.75],PARAMETER[\"Standard_Parallel_1\",41.2],PARAMETER[\"Standard_Parallel_2\",41.86666666666667],PARAMETER[\"Latitude_Of_Origin\",40.83333333333334],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",2234]]",
        2235=>"PROJCS[\"NAD_1983_StatePlane_Delaware_FIPS_0700_Feet\",GEOGCS[\"GCS_North_American_1983\",DATUM[\"D_North_American_1983\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",656166.6666666665],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-75.41666666666667],PARAMETER[\"Scale_Factor\",0.999995],PARAMETER[\"Latitude_Of_Origin\",38.0],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",2235]]",
        2236=>"PROJCS[\"NAD_1983_StatePlane_Florida_East_FIPS_0901_Feet\",GEOGCS[\"GCS_North_American_1983\",DATUM[\"D_North_American_1983\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",656166.6666666665],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-81.0],PARAMETER[\"Scale_Factor\",0.9999411764705882],PARAMETER[\"Latitude_Of_Origin\",24.33333333333333],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",2236]]",
        2237=>"PROJCS[\"NAD_1983_StatePlane_Florida_West_FIPS_0902_Feet\",GEOGCS[\"GCS_North_American_1983\",DATUM[\"D_North_American_1983\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",656166.6666666665],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-82.0],PARAMETER[\"Scale_Factor\",0.9999411764705882],PARAMETER[\"Latitude_Of_Origin\",24.33333333333333],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",2237]]",
        2238=>"PROJCS[\"NAD_1983_StatePlane_Florida_North_FIPS_0903_Feet\",GEOGCS[\"GCS_North_American_1983\",DATUM[\"D_North_American_1983\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",1968500.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-84.5],PARAMETER[\"Standard_Parallel_1\",29.58333333333333],PARAMETER[\"Standard_Parallel_2\",30.75],PARAMETER[\"Latitude_Of_Origin\",29.0],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",2238]]",
        2239=>"PROJCS[\"NAD_1983_StatePlane_Georgia_East_FIPS_1001_Feet\",GEOGCS[\"GCS_North_American_1983\",DATUM[\"D_North_American_1983\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",656166.6666666665],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-82.16666666666667],PARAMETER[\"Scale_Factor\",0.9999],PARAMETER[\"Latitude_Of_Origin\",30.0],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",2239]]",
        2240=>"PROJCS[\"NAD_1983_StatePlane_Georgia_West_FIPS_1002_Feet\",GEOGCS[\"GCS_North_American_1983\",DATUM[\"D_North_American_1983\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",2296583.333333333],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-84.16666666666667],PARAMETER[\"Scale_Factor\",0.9999],PARAMETER[\"Latitude_Of_Origin\",30.0],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",2240]]",
        2241=>"PROJCS[\"NAD_1983_StatePlane_Idaho_East_FIPS_1101_Feet\",GEOGCS[\"GCS_North_American_1983\",DATUM[\"D_North_American_1983\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",656166.6666666665],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-112.1666666666667],PARAMETER[\"Scale_Factor\",0.9999473684210526],PARAMETER[\"Latitude_Of_Origin\",41.66666666666666],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",2241]]",
        2242=>"PROJCS[\"NAD_1983_StatePlane_Idaho_Central_FIPS_1102_Feet\",GEOGCS[\"GCS_North_American_1983\",DATUM[\"D_North_American_1983\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",1640416.666666667],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-114.0],PARAMETER[\"Scale_Factor\",0.9999473684210526],PARAMETER[\"Latitude_Of_Origin\",41.66666666666666],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",2242]]",
        2243=>"PROJCS[\"NAD_1983_StatePlane_Idaho_West_FIPS_1103_Feet\",GEOGCS[\"GCS_North_American_1983\",DATUM[\"D_North_American_1983\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",2624666.666666666],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-115.75],PARAMETER[\"Scale_Factor\",0.9999333333333333],PARAMETER[\"Latitude_Of_Origin\",41.66666666666666],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",2243]]",
        2244=>"PROJCS[\"NAD_1983_StatePlane_Indiana_East_FIPS_1301_Feet\",GEOGCS[\"GCS_North_American_1983\",DATUM[\"D_North_American_1983\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",328083.3333333333],PARAMETER[\"False_Northing\",820208.3333333333],PARAMETER[\"Central_Meridian\",-85.66666666666667],PARAMETER[\"Scale_Factor\",0.9999666666666667],PARAMETER[\"Latitude_Of_Origin\",37.5],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",2965]]",
        2245=>"PROJCS[\"NAD_1983_StatePlane_Indiana_West_FIPS_1302_Feet\",GEOGCS[\"GCS_North_American_1983\",DATUM[\"D_North_American_1983\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",2952750.0],PARAMETER[\"False_Northing\",820208.3333333333],PARAMETER[\"Central_Meridian\",-87.08333333333333],PARAMETER[\"Scale_Factor\",0.9999666666666667],PARAMETER[\"Latitude_Of_Origin\",37.5],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",2966]]",
        2246=>"PROJCS[\"NAD_1983_StatePlane_Kentucky_North_FIPS_1601_Feet\",GEOGCS[\"GCS_North_American_1983\",DATUM[\"D_North_American_1983\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",1640416.666666667],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-84.25],PARAMETER[\"Standard_Parallel_1\",37.96666666666667],PARAMETER[\"Standard_Parallel_2\",38.96666666666667],PARAMETER[\"Latitude_Of_Origin\",37.5],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",2246]]",
        2247=>"PROJCS[\"NAD_1983_StatePlane_Kentucky_South_FIPS_1602_Feet\",GEOGCS[\"GCS_North_American_1983\",DATUM[\"D_North_American_1983\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",1640416.666666667],PARAMETER[\"False_Northing\",1640416.666666667],PARAMETER[\"Central_Meridian\",-85.75],PARAMETER[\"Standard_Parallel_1\",36.73333333333333],PARAMETER[\"Standard_Parallel_2\",37.93333333333333],PARAMETER[\"Latitude_Of_Origin\",36.33333333333334],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",2247]]",
        2248=>"PROJCS[\"NAD_1983_StatePlane_Maryland_FIPS_1900_Feet\",GEOGCS[\"GCS_North_American_1983\",DATUM[\"D_North_American_1983\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",1312333.333333333],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-77.0],PARAMETER[\"Standard_Parallel_1\",38.3],PARAMETER[\"Standard_Parallel_2\",39.45],PARAMETER[\"Latitude_Of_Origin\",37.66666666666666],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",2248]]",
        2249=>"PROJCS[\"NAD_1983_StatePlane_Massachusetts_Mainland_FIPS_2001_Feet\",GEOGCS[\"GCS_North_American_1983\",DATUM[\"D_North_American_1983\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",656166.6666666665],PARAMETER[\"False_Northing\",2460625.0],PARAMETER[\"Central_Meridian\",-71.5],PARAMETER[\"Standard_Parallel_1\",41.71666666666667],PARAMETER[\"Standard_Parallel_2\",42.68333333333333],PARAMETER[\"Latitude_Of_Origin\",41.0],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",2249]]",
        2250=>"PROJCS[\"NAD_1983_StatePlane_Massachusetts_Island_FIPS_2002_Feet\",GEOGCS[\"GCS_North_American_1983\",DATUM[\"D_North_American_1983\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",1640416.666666667],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-70.5],PARAMETER[\"Standard_Parallel_1\",41.28333333333333],PARAMETER[\"Standard_Parallel_2\",41.48333333333333],PARAMETER[\"Latitude_Of_Origin\",41.0],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",2250]]",
        2251=>"PROJCS[\"NAD_1983_StatePlane_Michigan_North_FIPS_2111_Feet_Intl\",GEOGCS[\"GCS_North_American_1983\",DATUM[\"D_North_American_1983\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",26246719.16010498],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-87.0],PARAMETER[\"Standard_Parallel_1\",45.48333333333333],PARAMETER[\"Standard_Parallel_2\",47.08333333333334],PARAMETER[\"Latitude_Of_Origin\",44.78333333333333],UNIT[\"Foot\",0.3048],AUTHORITY[\"EPSG\",2251]]",
        2252=>"PROJCS[\"NAD_1983_StatePlane_Michigan_Central_FIPS_2112_Feet_Intl\",GEOGCS[\"GCS_North_American_1983\",DATUM[\"D_North_American_1983\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",19685039.37007874],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-84.36666666666666],PARAMETER[\"Standard_Parallel_1\",44.18333333333333],PARAMETER[\"Standard_Parallel_2\",45.7],PARAMETER[\"Latitude_Of_Origin\",43.31666666666667],UNIT[\"Foot\",0.3048],AUTHORITY[\"EPSG\",2252]]",
        2253=>"PROJCS[\"NAD_1983_StatePlane_Michigan_South_FIPS_2113_Feet_Intl\",GEOGCS[\"GCS_North_American_1983\",DATUM[\"D_North_American_1983\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",13123359.58005249],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-84.36666666666666],PARAMETER[\"Standard_Parallel_1\",42.1],PARAMETER[\"Standard_Parallel_2\",43.66666666666666],PARAMETER[\"Latitude_Of_Origin\",41.5],UNIT[\"Foot\",0.3048],AUTHORITY[\"EPSG\",2253]]",
        2254=>"PROJCS[\"NAD_1983_StatePlane_Mississippi_East_FIPS_2301_Feet\",GEOGCS[\"GCS_North_American_1983\",DATUM[\"D_North_American_1983\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",984250.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-88.83333333333333],PARAMETER[\"Scale_Factor\",0.99995],PARAMETER[\"Latitude_Of_Origin\",29.5],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",2254]]",
        2255=>"PROJCS[\"NAD_1983_StatePlane_Mississippi_West_FIPS_2302_Feet\",GEOGCS[\"GCS_North_American_1983\",DATUM[\"D_North_American_1983\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",2296583.333333333],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-90.33333333333333],PARAMETER[\"Scale_Factor\",0.99995],PARAMETER[\"Latitude_Of_Origin\",29.5],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",2255]]",
        2256=>"PROJCS[\"NAD_1983_StatePlane_Montana_FIPS_2500_Feet_Intl\",GEOGCS[\"GCS_North_American_1983\",DATUM[\"D_North_American_1983\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",1968503.937007874],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-109.5],PARAMETER[\"Standard_Parallel_1\",45.0],PARAMETER[\"Standard_Parallel_2\",49.0],PARAMETER[\"Latitude_Of_Origin\",44.25],UNIT[\"Foot\",0.3048],AUTHORITY[\"EPSG\",2256]]",
        2257=>"PROJCS[\"NAD_1983_StatePlane_New_Mexico_East_FIPS_3001_Feet\",GEOGCS[\"GCS_North_American_1983\",DATUM[\"D_North_American_1983\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",541337.5],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-104.3333333333333],PARAMETER[\"Scale_Factor\",0.9999090909090909],PARAMETER[\"Latitude_Of_Origin\",31.0],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",2257]]",
        2258=>"PROJCS[\"NAD_1983_StatePlane_New_Mexico_Central_FIPS_3002_Feet\",GEOGCS[\"GCS_North_American_1983\",DATUM[\"D_North_American_1983\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",1640416.666666667],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-106.25],PARAMETER[\"Scale_Factor\",0.9999],PARAMETER[\"Latitude_Of_Origin\",31.0],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",2258]]",
        2259=>"PROJCS[\"NAD_1983_StatePlane_New_Mexico_West_FIPS_3003_Feet\",GEOGCS[\"GCS_North_American_1983\",DATUM[\"D_North_American_1983\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",2723091.666666666],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-107.8333333333333],PARAMETER[\"Scale_Factor\",0.9999166666666667],PARAMETER[\"Latitude_Of_Origin\",31.0],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",2259]]",
        2260=>"PROJCS[\"NAD_1983_StatePlane_New_York_East_FIPS_3101_Feet\",GEOGCS[\"GCS_North_American_1983\",DATUM[\"D_North_American_1983\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",492125.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-74.5],PARAMETER[\"Scale_Factor\",0.9999],PARAMETER[\"Latitude_Of_Origin\",38.83333333333334],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",2260]]",
        2261=>"PROJCS[\"NAD_1983_StatePlane_New_York_Central_FIPS_3102_Feet\",GEOGCS[\"GCS_North_American_1983\",DATUM[\"D_North_American_1983\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",820208.3333333333],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-76.58333333333333],PARAMETER[\"Scale_Factor\",0.9999375],PARAMETER[\"Latitude_Of_Origin\",40.0],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",2261]]",
        2262=>"PROJCS[\"NAD_1983_StatePlane_New_York_West_FIPS_3103_Feet\",GEOGCS[\"GCS_North_American_1983\",DATUM[\"D_North_American_1983\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",1148291.666666667],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-78.58333333333333],PARAMETER[\"Scale_Factor\",0.9999375],PARAMETER[\"Latitude_Of_Origin\",40.0],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",2262]]",
        2263=>"PROJCS[\"NAD_1983_StatePlane_New_York_Long_Island_FIPS_3104_Feet\",GEOGCS[\"GCS_North_American_1983\",DATUM[\"D_North_American_1983\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",984250.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-74.0],PARAMETER[\"Standard_Parallel_1\",40.66666666666666],PARAMETER[\"Standard_Parallel_2\",41.03333333333333],PARAMETER[\"Latitude_Of_Origin\",40.16666666666666],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",2263]]",
        2264=>"PROJCS[\"NAD_1983_StatePlane_North_Carolina_FIPS_3200_Feet\",GEOGCS[\"GCS_North_American_1983\",DATUM[\"D_North_American_1983\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",2000000.002616666],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-79.0],PARAMETER[\"Standard_Parallel_1\",34.33333333333334],PARAMETER[\"Standard_Parallel_2\",36.16666666666666],PARAMETER[\"Latitude_Of_Origin\",33.75],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",2264]]",
        2265=>"PROJCS[\"NAD_1983_StatePlane_North_Dakota_North_FIPS_3301_Feet_Intl\",GEOGCS[\"GCS_North_American_1983\",DATUM[\"D_North_American_1983\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",1968503.937007874],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-100.5],PARAMETER[\"Standard_Parallel_1\",47.43333333333333],PARAMETER[\"Standard_Parallel_2\",48.73333333333333],PARAMETER[\"Latitude_Of_Origin\",47.0],UNIT[\"Foot\",0.3048],AUTHORITY[\"EPSG\",2265]]",
        2266=>"PROJCS[\"NAD_1983_StatePlane_North_Dakota_South_FIPS_3302_Feet_Intl\",GEOGCS[\"GCS_North_American_1983\",DATUM[\"D_North_American_1983\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",1968503.937007874],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-100.5],PARAMETER[\"Standard_Parallel_1\",46.18333333333333],PARAMETER[\"Standard_Parallel_2\",47.48333333333333],PARAMETER[\"Latitude_Of_Origin\",45.66666666666666],UNIT[\"Foot\",0.3048],AUTHORITY[\"EPSG\",2266]]",
        2267=>"PROJCS[\"NAD_1983_StatePlane_Oklahoma_North_FIPS_3501_Feet\",GEOGCS[\"GCS_North_American_1983\",DATUM[\"D_North_American_1983\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",1968500.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-98.0],PARAMETER[\"Standard_Parallel_1\",35.56666666666667],PARAMETER[\"Standard_Parallel_2\",36.76666666666667],PARAMETER[\"Latitude_Of_Origin\",35.0],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",2267]]",
        2268=>"PROJCS[\"NAD_1983_StatePlane_Oklahoma_South_FIPS_3502_Feet\",GEOGCS[\"GCS_North_American_1983\",DATUM[\"D_North_American_1983\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",1968500.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-98.0],PARAMETER[\"Standard_Parallel_1\",33.93333333333333],PARAMETER[\"Standard_Parallel_2\",35.23333333333333],PARAMETER[\"Latitude_Of_Origin\",33.33333333333334],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",2268]]",
        2269=>"PROJCS[\"NAD_1983_StatePlane_Oregon_North_FIPS_3601_Feet_Intl\",GEOGCS[\"GCS_North_American_1983\",DATUM[\"D_North_American_1983\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",8202099.737532808],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-120.5],PARAMETER[\"Standard_Parallel_1\",44.33333333333334],PARAMETER[\"Standard_Parallel_2\",46.0],PARAMETER[\"Latitude_Of_Origin\",43.66666666666666],UNIT[\"Foot\",0.3048],AUTHORITY[\"EPSG\",2269]]",
        2270=>"PROJCS[\"NAD_1983_StatePlane_Oregon_South_FIPS_3602_Feet_Intl\",GEOGCS[\"GCS_North_American_1983\",DATUM[\"D_North_American_1983\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",4921259.842519685],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-120.5],PARAMETER[\"Standard_Parallel_1\",42.33333333333334],PARAMETER[\"Standard_Parallel_2\",44.0],PARAMETER[\"Latitude_Of_Origin\",41.66666666666666],UNIT[\"Foot\",0.3048],AUTHORITY[\"EPSG\",2270]]",
        2271=>"PROJCS[\"NAD_1983_StatePlane_Pennsylvania_North_FIPS_3701_Feet\",GEOGCS[\"GCS_North_American_1983\",DATUM[\"D_North_American_1983\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",1968500.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-77.75],PARAMETER[\"Standard_Parallel_1\",40.88333333333333],PARAMETER[\"Standard_Parallel_2\",41.95],PARAMETER[\"Latitude_Of_Origin\",40.16666666666666],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",2271]]",
        2272=>"PROJCS[\"NAD_1983_StatePlane_Pennsylvania_South_FIPS_3702_Feet\",GEOGCS[\"GCS_North_American_1983\",DATUM[\"D_North_American_1983\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",1968500.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-77.75],PARAMETER[\"Standard_Parallel_1\",39.93333333333333],PARAMETER[\"Standard_Parallel_2\",40.96666666666667],PARAMETER[\"Latitude_Of_Origin\",39.33333333333334],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",2272]]",
        2273=>"PROJCS[\"NAD_1983_StatePlane_South_Carolina_FIPS_3900_Feet_Intl\",GEOGCS[\"GCS_North_American_1983\",DATUM[\"D_North_American_1983\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",2000000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-81.0],PARAMETER[\"Standard_Parallel_1\",32.5],PARAMETER[\"Standard_Parallel_2\",34.83333333333334],PARAMETER[\"Latitude_Of_Origin\",31.83333333333333],UNIT[\"Foot\",0.3048],AUTHORITY[\"EPSG\",2273]]",
        2274=>"PROJCS[\"NAD_1983_StatePlane_Tennessee_FIPS_4100_Feet\",GEOGCS[\"GCS_North_American_1983\",DATUM[\"D_North_American_1983\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",1968500.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-86.0],PARAMETER[\"Standard_Parallel_1\",35.25],PARAMETER[\"Standard_Parallel_2\",36.41666666666666],PARAMETER[\"Latitude_Of_Origin\",34.33333333333334],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",2274]]",
        2275=>"PROJCS[\"NAD_1983_StatePlane_Texas_North_FIPS_4201_Feet\",GEOGCS[\"GCS_North_American_1983\",DATUM[\"D_North_American_1983\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",656166.6666666665],PARAMETER[\"False_Northing\",3280833.333333333],PARAMETER[\"Central_Meridian\",-101.5],PARAMETER[\"Standard_Parallel_1\",34.65],PARAMETER[\"Standard_Parallel_2\",36.18333333333333],PARAMETER[\"Latitude_Of_Origin\",34.0],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",2275]]",
        2276=>"PROJCS[\"NAD_1983_StatePlane_Texas_North_Central_FIPS_4202_Feet\",GEOGCS[\"GCS_North_American_1983\",DATUM[\"D_North_American_1983\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",1968500.0],PARAMETER[\"False_Northing\",6561666.666666666],PARAMETER[\"Central_Meridian\",-98.5],PARAMETER[\"Standard_Parallel_1\",32.13333333333333],PARAMETER[\"Standard_Parallel_2\",33.96666666666667],PARAMETER[\"Latitude_Of_Origin\",31.66666666666667],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",2276]]",
        2277=>"PROJCS[\"NAD_1983_StatePlane_Texas_Central_FIPS_4203_Feet\",GEOGCS[\"GCS_North_American_1983\",DATUM[\"D_North_American_1983\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",2296583.333333333],PARAMETER[\"False_Northing\",9842500.0],PARAMETER[\"Central_Meridian\",-100.3333333333333],PARAMETER[\"Standard_Parallel_1\",30.11666666666667],PARAMETER[\"Standard_Parallel_2\",31.88333333333333],PARAMETER[\"Latitude_Of_Origin\",29.66666666666667],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",2277]]",
        2278=>"PROJCS[\"NAD_1983_StatePlane_Texas_South_Central_FIPS_4204_Feet\",GEOGCS[\"GCS_North_American_1983\",DATUM[\"D_North_American_1983\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",1968500.0],PARAMETER[\"False_Northing\",13123333.33333333],PARAMETER[\"Central_Meridian\",-99.0],PARAMETER[\"Standard_Parallel_1\",28.38333333333333],PARAMETER[\"Standard_Parallel_2\",30.28333333333333],PARAMETER[\"Latitude_Of_Origin\",27.83333333333333],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",2278]]",
        2279=>"PROJCS[\"NAD_1983_StatePlane_Texas_South_FIPS_4205_Feet\",GEOGCS[\"GCS_North_American_1983\",DATUM[\"D_North_American_1983\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",984250.0],PARAMETER[\"False_Northing\",16404166.66666666],PARAMETER[\"Central_Meridian\",-98.5],PARAMETER[\"Standard_Parallel_1\",26.16666666666667],PARAMETER[\"Standard_Parallel_2\",27.83333333333333],PARAMETER[\"Latitude_Of_Origin\",25.66666666666667],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",2279]]",
        2280=>"PROJCS[\"NAD_1983_StatePlane_Utah_North_FIPS_4301_Feet_Intl\",GEOGCS[\"GCS_North_American_1983\",DATUM[\"D_North_American_1983\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",1640419.947506561],PARAMETER[\"False_Northing\",3280839.895013123],PARAMETER[\"Central_Meridian\",-111.5],PARAMETER[\"Standard_Parallel_1\",40.71666666666667],PARAMETER[\"Standard_Parallel_2\",41.78333333333333],PARAMETER[\"Latitude_Of_Origin\",40.33333333333334],UNIT[\"Foot\",0.3048],AUTHORITY[\"EPSG\",2280]]",
        2281=>"PROJCS[\"NAD_1983_StatePlane_Utah_Central_FIPS_4302_Feet_Intl\",GEOGCS[\"GCS_North_American_1983\",DATUM[\"D_North_American_1983\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",1640419.947506561],PARAMETER[\"False_Northing\",6561679.790026246],PARAMETER[\"Central_Meridian\",-111.5],PARAMETER[\"Standard_Parallel_1\",39.01666666666667],PARAMETER[\"Standard_Parallel_2\",40.65],PARAMETER[\"Latitude_Of_Origin\",38.33333333333334],UNIT[\"Foot\",0.3048],AUTHORITY[\"EPSG\",2281]]",
        2282=>"PROJCS[\"NAD_1983_StatePlane_Utah_South_FIPS_4303_Feet_Intl\",GEOGCS[\"GCS_North_American_1983\",DATUM[\"D_North_American_1983\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",1640419.947506561],PARAMETER[\"False_Northing\",9842519.685039369],PARAMETER[\"Central_Meridian\",-111.5],PARAMETER[\"Standard_Parallel_1\",37.21666666666667],PARAMETER[\"Standard_Parallel_2\",38.35],PARAMETER[\"Latitude_Of_Origin\",36.66666666666666],UNIT[\"Foot\",0.3048],AUTHORITY[\"EPSG\",2282]]",
        2283=>"PROJCS[\"NAD_1983_StatePlane_Virginia_North_FIPS_4501_Feet\",GEOGCS[\"GCS_North_American_1983\",DATUM[\"D_North_American_1983\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",11482916.66666666],PARAMETER[\"False_Northing\",6561666.666666666],PARAMETER[\"Central_Meridian\",-78.5],PARAMETER[\"Standard_Parallel_1\",38.03333333333333],PARAMETER[\"Standard_Parallel_2\",39.2],PARAMETER[\"Latitude_Of_Origin\",37.66666666666666],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",2283]]",
        2284=>"PROJCS[\"NAD_1983_StatePlane_Virginia_South_FIPS_4502_Feet\",GEOGCS[\"GCS_North_American_1983\",DATUM[\"D_North_American_1983\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",11482916.66666666],PARAMETER[\"False_Northing\",3280833.333333333],PARAMETER[\"Central_Meridian\",-78.5],PARAMETER[\"Standard_Parallel_1\",36.76666666666667],PARAMETER[\"Standard_Parallel_2\",37.96666666666667],PARAMETER[\"Latitude_Of_Origin\",36.33333333333334],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",2284]]",
        2285=>"PROJCS[\"NAD_1983_StatePlane_Washington_North_FIPS_4601_Feet\",GEOGCS[\"GCS_North_American_1983\",DATUM[\"D_North_American_1983\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",1640416.666666667],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-120.8333333333333],PARAMETER[\"Standard_Parallel_1\",47.5],PARAMETER[\"Standard_Parallel_2\",48.73333333333333],PARAMETER[\"Latitude_Of_Origin\",47.0],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",2285]]",
        2286=>"PROJCS[\"NAD_1983_StatePlane_Washington_South_FIPS_4602_Feet\",GEOGCS[\"GCS_North_American_1983\",DATUM[\"D_North_American_1983\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",1640416.666666667],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-120.5],PARAMETER[\"Standard_Parallel_1\",45.83333333333334],PARAMETER[\"Standard_Parallel_2\",47.33333333333334],PARAMETER[\"Latitude_Of_Origin\",45.33333333333334],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",2286]]",
        2287=>"PROJCS[\"NAD_1983_StatePlane_Wisconsin_North_FIPS_4801_Feet\",GEOGCS[\"GCS_North_American_1983\",DATUM[\"D_North_American_1983\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",1968500.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-90.0],PARAMETER[\"Standard_Parallel_1\",45.56666666666667],PARAMETER[\"Standard_Parallel_2\",46.76666666666667],PARAMETER[\"Latitude_Of_Origin\",45.16666666666666],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",2287]]",
        2288=>"PROJCS[\"NAD_1983_StatePlane_Wisconsin_Central_FIPS_4802_Feet\",GEOGCS[\"GCS_North_American_1983\",DATUM[\"D_North_American_1983\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",1968500.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-90.0],PARAMETER[\"Standard_Parallel_1\",44.25],PARAMETER[\"Standard_Parallel_2\",45.5],PARAMETER[\"Latitude_Of_Origin\",43.83333333333334],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",2288]]",
        2289=>"PROJCS[\"NAD_1983_StatePlane_Wisconsin_South_FIPS_4803_Feet\",GEOGCS[\"GCS_North_American_1983\",DATUM[\"D_North_American_1983\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",1968500.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-90.0],PARAMETER[\"Standard_Parallel_1\",42.73333333333333],PARAMETER[\"Standard_Parallel_2\",44.06666666666667],PARAMETER[\"Latitude_Of_Origin\",42.0],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",2289]]",
        2290=>"PROJCS[\"Prince_Edward_Island_Stereographic\",GEOGCS[\"GCS_ATS_1977\",DATUM[\"D_ATS_1977\",SPHEROID[\"ATS_1977\",6378135.0,298.257]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Double_Stereographic\"],PARAMETER[\"False_Easting\",700000.0],PARAMETER[\"False_Northing\",400000.0],PARAMETER[\"Central_Meridian\",-63.0],PARAMETER[\"Scale_Factor\",0.999912],PARAMETER[\"Latitude_Of_Origin\",47.25],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2290]]",
        2291=>"PROJCS[\"NAD_1983_CSRS_Prince_Edward_Island\",GEOGCS[\"GCS_North_American_1983_CSRS\",DATUM[\"D_North_American_1983_CSRS\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Double_Stereographic\"],PARAMETER[\"False_Easting\",400000.0],PARAMETER[\"False_Northing\",800000.0],PARAMETER[\"Central_Meridian\",-63.0],PARAMETER[\"Scale_Factor\",0.999912],PARAMETER[\"Latitude_Of_Origin\",47.25],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2954]]",
        2292=>"PROJCS[\"NAD_1983_CSRS_Prince_Edward_Island\",GEOGCS[\"GCS_North_American_1983_CSRS\",DATUM[\"D_North_American_1983_CSRS\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Double_Stereographic\"],PARAMETER[\"False_Easting\",400000.0],PARAMETER[\"False_Northing\",800000.0],PARAMETER[\"Central_Meridian\",-63.0],PARAMETER[\"Scale_Factor\",0.999912],PARAMETER[\"Latitude_Of_Origin\",47.25],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2954]]",
        2294=>"PROJCS[\"ATS_1977_MTM_4_Nova_Scotia\",GEOGCS[\"GCS_ATS_1977\",DATUM[\"D_ATS_1977\",SPHEROID[\"ATS_1977\",6378135.0,298.257]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",4500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-61.5],PARAMETER[\"Scale_Factor\",0.9999],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2294]]",
        2295=>"PROJCS[\"ATS_1977_MTM_5_Nova_Scotia\",GEOGCS[\"GCS_ATS_1977\",DATUM[\"D_ATS_1977\",SPHEROID[\"ATS_1977\",6378135.0,298.257]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",5500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-64.5],PARAMETER[\"Scale_Factor\",0.9999],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2295]]",
        2308=>"PROJCS[\"Batavia_TM_109_SE\",GEOGCS[\"GCS_Batavia\",DATUM[\"D_Batavia\",SPHEROID[\"Bessel_1841\",6377397.155,299.1528128]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",10000000.0],PARAMETER[\"Central_Meridian\",109.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2308]]",
        2309=>"PROJCS[\"WGS_1984_TM_116_SE\",GEOGCS[\"GCS_WGS_1984\",DATUM[\"D_WGS_1984\",SPHEROID[\"WGS_1984\",6378137.0,298.257223563]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",10000000.0],PARAMETER[\"Central_Meridian\",116.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2309]]",
        2310=>"PROJCS[\"WGS_1984_TM_132_SE\",GEOGCS[\"GCS_WGS_1984\",DATUM[\"D_WGS_1984\",SPHEROID[\"WGS_1984\",6378137.0,298.257223563]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",10000000.0],PARAMETER[\"Central_Meridian\",132.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2310]]",
        2311=>"PROJCS[\"WGS_1984_TM_6_NE\",GEOGCS[\"GCS_WGS_1984\",DATUM[\"D_WGS_1984\",SPHEROID[\"WGS_1984\",6378137.0,298.257223563]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",6.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2311]]",
        2312=>"PROJCS[\"Garoua_UTM_Zone_33N\",GEOGCS[\"GCS_Garoua\",DATUM[\"D_Garoua\",SPHEROID[\"Clarke_1880_RGS\",6378249.145,293.465]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",15.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2312]]",
        2313=>"PROJCS[\"Kousseri_UTM_Zone_33N\",GEOGCS[\"GCS_Kousseri\",DATUM[\"D_Kousseri\",SPHEROID[\"Clarke_1880_RGS\",6378249.145,293.465]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",15.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2313]]",
        2314=>"PROJCS[\"Trinidad_1903_Trinidad_Grid_Feet_Clarke\",GEOGCS[\"GCS_Trinidad_1903\",DATUM[\"D_Trinidad_1903\",SPHEROID[\"Clarke_1858\",6378293.645208759,294.260676369]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Cassini\"],PARAMETER[\"False_Easting\",283800.0],PARAMETER[\"False_Northing\",214500.0],PARAMETER[\"Central_Meridian\",-61.33333333333334],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",10.44166666666667],UNIT[\"Foot_Clarke\",0.3047972654],AUTHORITY[\"EPSG\",2314]]",
        2315=>"PROJCS[\"Campo_Inchauspe_UTM_19S\",GEOGCS[\"GCS_Campo_Inchauspe\",DATUM[\"D_Campo_Inchauspe\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",10000000.0],PARAMETER[\"Central_Meridian\",-69.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2315]]",
        2316=>"PROJCS[\"Campo_Inchauspe_UTM_20S\",GEOGCS[\"GCS_Campo_Inchauspe\",DATUM[\"D_Campo_Inchauspe\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",10000000.0],PARAMETER[\"Central_Meridian\",-63.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2316]]",
        2317=>"PROJCS[\"PSAD_1956_ICN_Regional\",GEOGCS[\"GCS_Provisional_S_American_1956\",DATUM[\"D_Provisional_S_American_1956\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",1000000.0],PARAMETER[\"False_Northing\",1000000.0],PARAMETER[\"Central_Meridian\",-66.0],PARAMETER[\"Standard_Parallel_1\",3.0],PARAMETER[\"Standard_Parallel_2\",9.0],PARAMETER[\"Latitude_Of_Origin\",6.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2317]]",
        2318=>"PROJCS[\"Ain_el_Abd_Aramco_Lambert\",GEOGCS[\"GCS_Ain_el_Abd_1970\",DATUM[\"D_Ain_el_Abd_1970\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",0.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",48.0],PARAMETER[\"Standard_Parallel_1\",17.0],PARAMETER[\"Standard_Parallel_2\",33.0],PARAMETER[\"Latitude_Of_Origin\",25.08951],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2318]]",
        2319=>"PROJCS[\"ED_1950_TM27\",GEOGCS[\"GCS_European_1950\",DATUM[\"D_European_1950\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",27.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2319]]",
        2320=>"PROJCS[\"ED_1950_TM30\",GEOGCS[\"GCS_European_1950\",DATUM[\"D_European_1950\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",30.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2320]]",
        2321=>"PROJCS[\"ED_1950_TM33\",GEOGCS[\"GCS_European_1950\",DATUM[\"D_European_1950\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",33.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2321]]",
        2322=>"PROJCS[\"ED_1950_TM36\",GEOGCS[\"GCS_European_1950\",DATUM[\"D_European_1950\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",36.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2322]]",
        2323=>"PROJCS[\"ED_1950_TM39\",GEOGCS[\"GCS_European_1950\",DATUM[\"D_European_1950\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",39.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2323]]",
        2324=>"PROJCS[\"ED_1950_TM42\",GEOGCS[\"GCS_European_1950\",DATUM[\"D_European_1950\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",42.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2324]]",
        2325=>"PROJCS[\"ED_1950_TM45\",GEOGCS[\"GCS_European_1950\",DATUM[\"D_European_1950\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",45.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2325]]",
        2326=>"PROJCS[\"Hong_Kong_1980_Grid\",GEOGCS[\"GCS_Hong_Kong_1980\",DATUM[\"D_Hong_Kong_1980\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",836694.05],PARAMETER[\"False_Northing\",819069.8],PARAMETER[\"Central_Meridian\",114.1785555555556],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",22.31213333333334],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2326]]",
        2327=>"PROJCS[\"Xian_1980_GK_Zone_13\",GEOGCS[\"GCS_Xian_1980\",DATUM[\"D_Xian_1980\",SPHEROID[\"Xian_1980\",6378140.0,298.257]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",13500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",75.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2327]]",
        2328=>"PROJCS[\"Xian_1980_GK_Zone_14\",GEOGCS[\"GCS_Xian_1980\",DATUM[\"D_Xian_1980\",SPHEROID[\"Xian_1980\",6378140.0,298.257]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",14500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",81.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2328]]",
        2329=>"PROJCS[\"Xian_1980_GK_Zone_15\",GEOGCS[\"GCS_Xian_1980\",DATUM[\"D_Xian_1980\",SPHEROID[\"Xian_1980\",6378140.0,298.257]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",15500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",87.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2329]]",
        2330=>"PROJCS[\"Xian_1980_GK_Zone_16\",GEOGCS[\"GCS_Xian_1980\",DATUM[\"D_Xian_1980\",SPHEROID[\"Xian_1980\",6378140.0,298.257]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",16500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",93.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2330]]",
        2331=>"PROJCS[\"Xian_1980_GK_Zone_17\",GEOGCS[\"GCS_Xian_1980\",DATUM[\"D_Xian_1980\",SPHEROID[\"Xian_1980\",6378140.0,298.257]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",17500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",99.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2331]]",
        2332=>"PROJCS[\"Xian_1980_GK_Zone_18\",GEOGCS[\"GCS_Xian_1980\",DATUM[\"D_Xian_1980\",SPHEROID[\"Xian_1980\",6378140.0,298.257]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",18500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",105.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2332]]",
        2333=>"PROJCS[\"Xian_1980_GK_Zone_19\",GEOGCS[\"GCS_Xian_1980\",DATUM[\"D_Xian_1980\",SPHEROID[\"Xian_1980\",6378140.0,298.257]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",19500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",111.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2333]]",
        2334=>"PROJCS[\"Xian_1980_GK_Zone_20\",GEOGCS[\"GCS_Xian_1980\",DATUM[\"D_Xian_1980\",SPHEROID[\"Xian_1980\",6378140.0,298.257]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",20500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",117.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2334]]",
        2335=>"PROJCS[\"Xian_1980_GK_Zone_21\",GEOGCS[\"GCS_Xian_1980\",DATUM[\"D_Xian_1980\",SPHEROID[\"Xian_1980\",6378140.0,298.257]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",21500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",123.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2335]]",
        2336=>"PROJCS[\"Xian_1980_GK_Zone_22\",GEOGCS[\"GCS_Xian_1980\",DATUM[\"D_Xian_1980\",SPHEROID[\"Xian_1980\",6378140.0,298.257]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",22500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",129.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2336]]",
        2337=>"PROJCS[\"Xian_1980_GK_Zone_23\",GEOGCS[\"GCS_Xian_1980\",DATUM[\"D_Xian_1980\",SPHEROID[\"Xian_1980\",6378140.0,298.257]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",23500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",135.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2337]]",
        2338=>"PROJCS[\"Xian_1980_GK_CM_75E\",GEOGCS[\"GCS_Xian_1980\",DATUM[\"D_Xian_1980\",SPHEROID[\"Xian_1980\",6378140.0,298.257]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",75.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2338]]",
        2339=>"PROJCS[\"Xian_1980_GK_CM_81E\",GEOGCS[\"GCS_Xian_1980\",DATUM[\"D_Xian_1980\",SPHEROID[\"Xian_1980\",6378140.0,298.257]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",81.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2339]]",
        2340=>"PROJCS[\"Xian_1980_GK_CM_87E\",GEOGCS[\"GCS_Xian_1980\",DATUM[\"D_Xian_1980\",SPHEROID[\"Xian_1980\",6378140.0,298.257]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",87.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2340]]",
        2341=>"PROJCS[\"Xian_1980_GK_CM_93E\",GEOGCS[\"GCS_Xian_1980\",DATUM[\"D_Xian_1980\",SPHEROID[\"Xian_1980\",6378140.0,298.257]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",93.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2341]]",
        2342=>"PROJCS[\"Xian_1980_GK_CM_99E\",GEOGCS[\"GCS_Xian_1980\",DATUM[\"D_Xian_1980\",SPHEROID[\"Xian_1980\",6378140.0,298.257]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",99.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2342]]",
        2343=>"PROJCS[\"Xian_1980_GK_CM_105E\",GEOGCS[\"GCS_Xian_1980\",DATUM[\"D_Xian_1980\",SPHEROID[\"Xian_1980\",6378140.0,298.257]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",105.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2343]]",
        2344=>"PROJCS[\"Xian_1980_GK_CM_111E\",GEOGCS[\"GCS_Xian_1980\",DATUM[\"D_Xian_1980\",SPHEROID[\"Xian_1980\",6378140.0,298.257]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",111.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2344]]",
        2345=>"PROJCS[\"Xian_1980_GK_CM_117E\",GEOGCS[\"GCS_Xian_1980\",DATUM[\"D_Xian_1980\",SPHEROID[\"Xian_1980\",6378140.0,298.257]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",117.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2345]]",
        2346=>"PROJCS[\"Xian_1980_GK_CM_123E\",GEOGCS[\"GCS_Xian_1980\",DATUM[\"D_Xian_1980\",SPHEROID[\"Xian_1980\",6378140.0,298.257]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",123.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2346]]",
        2347=>"PROJCS[\"Xian_1980_GK_CM_129E\",GEOGCS[\"GCS_Xian_1980\",DATUM[\"D_Xian_1980\",SPHEROID[\"Xian_1980\",6378140.0,298.257]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",129.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2347]]",
        2348=>"PROJCS[\"Xian_1980_GK_CM_135E\",GEOGCS[\"GCS_Xian_1980\",DATUM[\"D_Xian_1980\",SPHEROID[\"Xian_1980\",6378140.0,298.257]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",135.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2348]]",
        2349=>"PROJCS[\"Xian_1980_3_Degree_GK_Zone_25\",GEOGCS[\"GCS_Xian_1980\",DATUM[\"D_Xian_1980\",SPHEROID[\"Xian_1980\",6378140.0,298.257]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",25500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",75.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2349]]",
        2350=>"PROJCS[\"Xian_1980_3_Degree_GK_Zone_26\",GEOGCS[\"GCS_Xian_1980\",DATUM[\"D_Xian_1980\",SPHEROID[\"Xian_1980\",6378140.0,298.257]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",26500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",78.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2350]]",
        2351=>"PROJCS[\"Xian_1980_3_Degree_GK_Zone_27\",GEOGCS[\"GCS_Xian_1980\",DATUM[\"D_Xian_1980\",SPHEROID[\"Xian_1980\",6378140.0,298.257]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",27500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",81.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2351]]",
        2352=>"PROJCS[\"Xian_1980_3_Degree_GK_Zone_28\",GEOGCS[\"GCS_Xian_1980\",DATUM[\"D_Xian_1980\",SPHEROID[\"Xian_1980\",6378140.0,298.257]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",28500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",84.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2352]]",
        2353=>"PROJCS[\"Xian_1980_3_Degree_GK_Zone_29\",GEOGCS[\"GCS_Xian_1980\",DATUM[\"D_Xian_1980\",SPHEROID[\"Xian_1980\",6378140.0,298.257]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",29500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",87.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2353]]",
        2354=>"PROJCS[\"Xian_1980_3_Degree_GK_Zone_30\",GEOGCS[\"GCS_Xian_1980\",DATUM[\"D_Xian_1980\",SPHEROID[\"Xian_1980\",6378140.0,298.257]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",30500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",90.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2354]]",
        2355=>"PROJCS[\"Xian_1980_3_Degree_GK_Zone_31\",GEOGCS[\"GCS_Xian_1980\",DATUM[\"D_Xian_1980\",SPHEROID[\"Xian_1980\",6378140.0,298.257]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",31500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",93.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2355]]",
        2356=>"PROJCS[\"Xian_1980_3_Degree_GK_Zone_32\",GEOGCS[\"GCS_Xian_1980\",DATUM[\"D_Xian_1980\",SPHEROID[\"Xian_1980\",6378140.0,298.257]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",32500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",96.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2356]]",
        2357=>"PROJCS[\"Xian_1980_3_Degree_GK_Zone_33\",GEOGCS[\"GCS_Xian_1980\",DATUM[\"D_Xian_1980\",SPHEROID[\"Xian_1980\",6378140.0,298.257]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",33500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",99.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2357]]",
        2358=>"PROJCS[\"Xian_1980_3_Degree_GK_Zone_34\",GEOGCS[\"GCS_Xian_1980\",DATUM[\"D_Xian_1980\",SPHEROID[\"Xian_1980\",6378140.0,298.257]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",34500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",102.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2358]]",
        2359=>"PROJCS[\"Xian_1980_3_Degree_GK_Zone_35\",GEOGCS[\"GCS_Xian_1980\",DATUM[\"D_Xian_1980\",SPHEROID[\"Xian_1980\",6378140.0,298.257]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",35500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",105.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2359]]",
        2360=>"PROJCS[\"Xian_1980_3_Degree_GK_Zone_36\",GEOGCS[\"GCS_Xian_1980\",DATUM[\"D_Xian_1980\",SPHEROID[\"Xian_1980\",6378140.0,298.257]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",36500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",108.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2360]]",
        2361=>"PROJCS[\"Xian_1980_3_Degree_GK_Zone_37\",GEOGCS[\"GCS_Xian_1980\",DATUM[\"D_Xian_1980\",SPHEROID[\"Xian_1980\",6378140.0,298.257]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",37500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",111.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2361]]",
        2362=>"PROJCS[\"Xian_1980_3_Degree_GK_Zone_38\",GEOGCS[\"GCS_Xian_1980\",DATUM[\"D_Xian_1980\",SPHEROID[\"Xian_1980\",6378140.0,298.257]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",38500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",114.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2362]]",
        2363=>"PROJCS[\"Xian_1980_3_Degree_GK_Zone_39\",GEOGCS[\"GCS_Xian_1980\",DATUM[\"D_Xian_1980\",SPHEROID[\"Xian_1980\",6378140.0,298.257]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",39500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",117.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2363]]",
        2364=>"PROJCS[\"Xian_1980_3_Degree_GK_Zone_40\",GEOGCS[\"GCS_Xian_1980\",DATUM[\"D_Xian_1980\",SPHEROID[\"Xian_1980\",6378140.0,298.257]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",40500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",120.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2364]]",
        2365=>"PROJCS[\"Xian_1980_3_Degree_GK_Zone_41\",GEOGCS[\"GCS_Xian_1980\",DATUM[\"D_Xian_1980\",SPHEROID[\"Xian_1980\",6378140.0,298.257]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",41500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",123.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2365]]",
        2366=>"PROJCS[\"Xian_1980_3_Degree_GK_Zone_42\",GEOGCS[\"GCS_Xian_1980\",DATUM[\"D_Xian_1980\",SPHEROID[\"Xian_1980\",6378140.0,298.257]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",42500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",126.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2366]]",
        2367=>"PROJCS[\"Xian_1980_3_Degree_GK_Zone_43\",GEOGCS[\"GCS_Xian_1980\",DATUM[\"D_Xian_1980\",SPHEROID[\"Xian_1980\",6378140.0,298.257]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",43500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",129.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2367]]",
        2368=>"PROJCS[\"Xian_1980_3_Degree_GK_Zone_44\",GEOGCS[\"GCS_Xian_1980\",DATUM[\"D_Xian_1980\",SPHEROID[\"Xian_1980\",6378140.0,298.257]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",44500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",132.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2368]]",
        2369=>"PROJCS[\"Xian_1980_3_Degree_GK_Zone_45\",GEOGCS[\"GCS_Xian_1980\",DATUM[\"D_Xian_1980\",SPHEROID[\"Xian_1980\",6378140.0,298.257]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",45500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",135.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2369]]",
        2370=>"PROJCS[\"Xian_1980_3_Degree_GK_CM_75E\",GEOGCS[\"GCS_Xian_1980\",DATUM[\"D_Xian_1980\",SPHEROID[\"Xian_1980\",6378140.0,298.257]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",75.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2370]]",
        2371=>"PROJCS[\"Xian_1980_3_Degree_GK_CM_78E\",GEOGCS[\"GCS_Xian_1980\",DATUM[\"D_Xian_1980\",SPHEROID[\"Xian_1980\",6378140.0,298.257]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",78.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2371]]",
        2372=>"PROJCS[\"Xian_1980_3_Degree_GK_CM_81E\",GEOGCS[\"GCS_Xian_1980\",DATUM[\"D_Xian_1980\",SPHEROID[\"Xian_1980\",6378140.0,298.257]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",81.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2372]]",
        2373=>"PROJCS[\"Xian_1980_3_Degree_GK_CM_84E\",GEOGCS[\"GCS_Xian_1980\",DATUM[\"D_Xian_1980\",SPHEROID[\"Xian_1980\",6378140.0,298.257]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",84.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2373]]",
        2374=>"PROJCS[\"Xian_1980_3_Degree_GK_CM_87E\",GEOGCS[\"GCS_Xian_1980\",DATUM[\"D_Xian_1980\",SPHEROID[\"Xian_1980\",6378140.0,298.257]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",87.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2374]]",
        2375=>"PROJCS[\"Xian_1980_3_Degree_GK_CM_90E\",GEOGCS[\"GCS_Xian_1980\",DATUM[\"D_Xian_1980\",SPHEROID[\"Xian_1980\",6378140.0,298.257]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",90.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2375]]",
        2376=>"PROJCS[\"Xian_1980_3_Degree_GK_CM_93E\",GEOGCS[\"GCS_Xian_1980\",DATUM[\"D_Xian_1980\",SPHEROID[\"Xian_1980\",6378140.0,298.257]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",93.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2376]]",
        2377=>"PROJCS[\"Xian_1980_3_Degree_GK_CM_96E\",GEOGCS[\"GCS_Xian_1980\",DATUM[\"D_Xian_1980\",SPHEROID[\"Xian_1980\",6378140.0,298.257]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",96.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2377]]",
        2378=>"PROJCS[\"Xian_1980_3_Degree_GK_CM_99E\",GEOGCS[\"GCS_Xian_1980\",DATUM[\"D_Xian_1980\",SPHEROID[\"Xian_1980\",6378140.0,298.257]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",99.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2378]]",
        2379=>"PROJCS[\"Xian_1980_3_Degree_GK_CM_102E\",GEOGCS[\"GCS_Xian_1980\",DATUM[\"D_Xian_1980\",SPHEROID[\"Xian_1980\",6378140.0,298.257]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",102.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2379]]",
        2380=>"PROJCS[\"Xian_1980_3_Degree_GK_CM_105E\",GEOGCS[\"GCS_Xian_1980\",DATUM[\"D_Xian_1980\",SPHEROID[\"Xian_1980\",6378140.0,298.257]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",105.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2380]]",
        2381=>"PROJCS[\"Xian_1980_3_Degree_GK_CM_108E\",GEOGCS[\"GCS_Xian_1980\",DATUM[\"D_Xian_1980\",SPHEROID[\"Xian_1980\",6378140.0,298.257]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",108.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2381]]",
        2382=>"PROJCS[\"Xian_1980_3_Degree_GK_CM_111E\",GEOGCS[\"GCS_Xian_1980\",DATUM[\"D_Xian_1980\",SPHEROID[\"Xian_1980\",6378140.0,298.257]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",111.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2382]]",
        2383=>"PROJCS[\"Xian_1980_3_Degree_GK_CM_114E\",GEOGCS[\"GCS_Xian_1980\",DATUM[\"D_Xian_1980\",SPHEROID[\"Xian_1980\",6378140.0,298.257]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",114.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2383]]",
        2384=>"PROJCS[\"Xian_1980_3_Degree_GK_CM_117E\",GEOGCS[\"GCS_Xian_1980\",DATUM[\"D_Xian_1980\",SPHEROID[\"Xian_1980\",6378140.0,298.257]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",117.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2384]]",
        2385=>"PROJCS[\"Xian_1980_3_Degree_GK_CM_120E\",GEOGCS[\"GCS_Xian_1980\",DATUM[\"D_Xian_1980\",SPHEROID[\"Xian_1980\",6378140.0,298.257]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",120.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2385]]",
        2386=>"PROJCS[\"Xian_1980_3_Degree_GK_CM_123E\",GEOGCS[\"GCS_Xian_1980\",DATUM[\"D_Xian_1980\",SPHEROID[\"Xian_1980\",6378140.0,298.257]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",123.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2386]]",
        2387=>"PROJCS[\"Xian_1980_3_Degree_GK_CM_126E\",GEOGCS[\"GCS_Xian_1980\",DATUM[\"D_Xian_1980\",SPHEROID[\"Xian_1980\",6378140.0,298.257]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",126.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2387]]",
        2388=>"PROJCS[\"Xian_1980_3_Degree_GK_CM_129E\",GEOGCS[\"GCS_Xian_1980\",DATUM[\"D_Xian_1980\",SPHEROID[\"Xian_1980\",6378140.0,298.257]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",129.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2388]]",
        2389=>"PROJCS[\"Xian_1980_3_Degree_GK_CM_132E\",GEOGCS[\"GCS_Xian_1980\",DATUM[\"D_Xian_1980\",SPHEROID[\"Xian_1980\",6378140.0,298.257]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",132.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2389]]",
        2390=>"PROJCS[\"Xian_1980_3_Degree_GK_CM_135E\",GEOGCS[\"GCS_Xian_1980\",DATUM[\"D_Xian_1980\",SPHEROID[\"Xian_1980\",6378140.0,298.257]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",135.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2390]]",
        2391=>"PROJCS[\"Finland_Zone_1\",GEOGCS[\"GCS_KKJ\",DATUM[\"D_KKJ\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",1500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",21.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2391]]",
        2392=>"PROJCS[\"Finland_Zone_2\",GEOGCS[\"GCS_KKJ\",DATUM[\"D_KKJ\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",2500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",24.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2392]]",
        2393=>"PROJCS[\"Finland_Zone_3\",GEOGCS[\"GCS_KKJ\",DATUM[\"D_KKJ\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",3500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",27.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2393]]",
        2394=>"PROJCS[\"Finland_Zone_4\",GEOGCS[\"GCS_KKJ\",DATUM[\"D_KKJ\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",4500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",30.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2394]]",
        2395=>"PROJCS[\"South_Yemen_GK_Zone_8\",GEOGCS[\"GCS_South_Yemen\",DATUM[\"D_South_Yemen\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",8500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",45.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2395]]",
        2396=>"PROJCS[\"South_Yemen_GK_Zone_9\",GEOGCS[\"GCS_South_Yemen\",DATUM[\"D_South_Yemen\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",9500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",51.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2396]]",
        2397=>"PROJCS[\"Pulkovo_1942_Adj_1983_3_Degree_GK_Zone_3\",GEOGCS[\"GCS_Pulkovo_1942_Adj_1983\",DATUM[\"D_Pulkovo_1942_Adj_1983\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",3500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",9.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2397]]",
        2398=>"PROJCS[\"Pulkovo_1942_Adj_1983_3_Degree_GK_Zone_4\",GEOGCS[\"GCS_Pulkovo_1942_Adj_1983\",DATUM[\"D_Pulkovo_1942_Adj_1983\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",4500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",12.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2398]]",
        2399=>"PROJCS[\"Pulkovo_1942_Adj_1983_3_Degree_GK_Zone_5\",GEOGCS[\"GCS_Pulkovo_1942_Adj_1983\",DATUM[\"D_Pulkovo_1942_Adj_1983\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",5500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",15.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2399]]",
        2400=>"PROJCS[\"RT90_25_gon_W\",GEOGCS[\"GCS_RT_1990\",DATUM[\"D_RT_1990\",SPHEROID[\"Bessel_1841\",6377397.155,299.1528128]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",1500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",15.80827777777778],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2400]]",
        2401=>"PROJCS[\"Beijing_1954_3_Degree_GK_Zone_25\",GEOGCS[\"GCS_Beijing_1954\",DATUM[\"D_Beijing_1954\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",25500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",75.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2401]]",
        2402=>"PROJCS[\"Beijing_1954_3_Degree_GK_Zone_26\",GEOGCS[\"GCS_Beijing_1954\",DATUM[\"D_Beijing_1954\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",26500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",78.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2402]]",
        2403=>"PROJCS[\"Beijing_1954_3_Degree_GK_Zone_27\",GEOGCS[\"GCS_Beijing_1954\",DATUM[\"D_Beijing_1954\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",27500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",81.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2403]]",
        2404=>"PROJCS[\"Beijing_1954_3_Degree_GK_Zone_28\",GEOGCS[\"GCS_Beijing_1954\",DATUM[\"D_Beijing_1954\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",28500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",84.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2404]]",
        2405=>"PROJCS[\"Beijing_1954_3_Degree_GK_Zone_29\",GEOGCS[\"GCS_Beijing_1954\",DATUM[\"D_Beijing_1954\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",29500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",87.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2405]]",
        2406=>"PROJCS[\"Beijing_1954_3_Degree_GK_Zone_30\",GEOGCS[\"GCS_Beijing_1954\",DATUM[\"D_Beijing_1954\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",30500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",90.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2406]]",
        2407=>"PROJCS[\"Beijing_1954_3_Degree_GK_Zone_31\",GEOGCS[\"GCS_Beijing_1954\",DATUM[\"D_Beijing_1954\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",31500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",93.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2407]]",
        2408=>"PROJCS[\"Beijing_1954_3_Degree_GK_Zone_32\",GEOGCS[\"GCS_Beijing_1954\",DATUM[\"D_Beijing_1954\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",32500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",96.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2408]]",
        2409=>"PROJCS[\"Beijing_1954_3_Degree_GK_Zone_33\",GEOGCS[\"GCS_Beijing_1954\",DATUM[\"D_Beijing_1954\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",33500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",99.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2409]]",
        2410=>"PROJCS[\"Beijing_1954_3_Degree_GK_Zone_34\",GEOGCS[\"GCS_Beijing_1954\",DATUM[\"D_Beijing_1954\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",34500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",102.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2410]]",
        2411=>"PROJCS[\"Beijing_1954_3_Degree_GK_Zone_35\",GEOGCS[\"GCS_Beijing_1954\",DATUM[\"D_Beijing_1954\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",35500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",105.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2411]]",
        2412=>"PROJCS[\"Beijing_1954_3_Degree_GK_Zone_36\",GEOGCS[\"GCS_Beijing_1954\",DATUM[\"D_Beijing_1954\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",36500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",108.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2412]]",
        2413=>"PROJCS[\"Beijing_1954_3_Degree_GK_Zone_37\",GEOGCS[\"GCS_Beijing_1954\",DATUM[\"D_Beijing_1954\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",37500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",111.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2413]]",
        2414=>"PROJCS[\"Beijing_1954_3_Degree_GK_Zone_38\",GEOGCS[\"GCS_Beijing_1954\",DATUM[\"D_Beijing_1954\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",38500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",114.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2414]]",
        2415=>"PROJCS[\"Beijing_1954_3_Degree_GK_Zone_39\",GEOGCS[\"GCS_Beijing_1954\",DATUM[\"D_Beijing_1954\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",39500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",117.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2415]]",
        2416=>"PROJCS[\"Beijing_1954_3_Degree_GK_Zone_40\",GEOGCS[\"GCS_Beijing_1954\",DATUM[\"D_Beijing_1954\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",40500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",120.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2416]]",
        2417=>"PROJCS[\"Beijing_1954_3_Degree_GK_Zone_41\",GEOGCS[\"GCS_Beijing_1954\",DATUM[\"D_Beijing_1954\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",41500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",123.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2417]]",
        2418=>"PROJCS[\"Beijing_1954_3_Degree_GK_Zone_42\",GEOGCS[\"GCS_Beijing_1954\",DATUM[\"D_Beijing_1954\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",42500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",126.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2418]]",
        2419=>"PROJCS[\"Beijing_1954_3_Degree_GK_Zone_43\",GEOGCS[\"GCS_Beijing_1954\",DATUM[\"D_Beijing_1954\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",43500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",129.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2419]]",
        2420=>"PROJCS[\"Beijing_1954_3_Degree_GK_Zone_44\",GEOGCS[\"GCS_Beijing_1954\",DATUM[\"D_Beijing_1954\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",44500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",132.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2420]]",
        2421=>"PROJCS[\"Beijing_1954_3_Degree_GK_Zone_45\",GEOGCS[\"GCS_Beijing_1954\",DATUM[\"D_Beijing_1954\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",45500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",135.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2421]]",
        2422=>"PROJCS[\"Beijing_1954_3_Degree_GK_CM_75E\",GEOGCS[\"GCS_Beijing_1954\",DATUM[\"D_Beijing_1954\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",75.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2422]]",
        2423=>"PROJCS[\"Beijing_1954_3_Degree_GK_CM_78E\",GEOGCS[\"GCS_Beijing_1954\",DATUM[\"D_Beijing_1954\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",78.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2423]]",
        2424=>"PROJCS[\"Beijing_1954_3_Degree_GK_CM_81E\",GEOGCS[\"GCS_Beijing_1954\",DATUM[\"D_Beijing_1954\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",81.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2424]]",
        2425=>"PROJCS[\"Beijing_1954_3_Degree_GK_CM_84E\",GEOGCS[\"GCS_Beijing_1954\",DATUM[\"D_Beijing_1954\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",84.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2425]]",
        2426=>"PROJCS[\"Beijing_1954_3_Degree_GK_CM_87E\",GEOGCS[\"GCS_Beijing_1954\",DATUM[\"D_Beijing_1954\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",87.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2426]]",
        2427=>"PROJCS[\"Beijing_1954_3_Degree_GK_CM_90E\",GEOGCS[\"GCS_Beijing_1954\",DATUM[\"D_Beijing_1954\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",90.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2427]]",
        2428=>"PROJCS[\"Beijing_1954_3_Degree_GK_CM_93E\",GEOGCS[\"GCS_Beijing_1954\",DATUM[\"D_Beijing_1954\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",93.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2428]]",
        2429=>"PROJCS[\"Beijing_1954_3_Degree_GK_CM_96E\",GEOGCS[\"GCS_Beijing_1954\",DATUM[\"D_Beijing_1954\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",96.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2429]]",
        2430=>"PROJCS[\"Beijing_1954_3_Degree_GK_CM_99E\",GEOGCS[\"GCS_Beijing_1954\",DATUM[\"D_Beijing_1954\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",99.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2430]]",
        2431=>"PROJCS[\"Beijing_1954_3_Degree_GK_CM_102E\",GEOGCS[\"GCS_Beijing_1954\",DATUM[\"D_Beijing_1954\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",102.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2431]]",
        2432=>"PROJCS[\"Beijing_1954_3_Degree_GK_CM_105E\",GEOGCS[\"GCS_Beijing_1954\",DATUM[\"D_Beijing_1954\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",105.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2432]]",
        2433=>"PROJCS[\"Beijing_1954_3_Degree_GK_CM_108E\",GEOGCS[\"GCS_Beijing_1954\",DATUM[\"D_Beijing_1954\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",108.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2433]]",
        2434=>"PROJCS[\"Beijing_1954_3_Degree_GK_CM_111E\",GEOGCS[\"GCS_Beijing_1954\",DATUM[\"D_Beijing_1954\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",111.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2434]]",
        2435=>"PROJCS[\"Beijing_1954_3_Degree_GK_CM_114E\",GEOGCS[\"GCS_Beijing_1954\",DATUM[\"D_Beijing_1954\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",114.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2435]]",
        2436=>"PROJCS[\"Beijing_1954_3_Degree_GK_CM_117E\",GEOGCS[\"GCS_Beijing_1954\",DATUM[\"D_Beijing_1954\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",117.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2436]]",
        2437=>"PROJCS[\"Beijing_1954_3_Degree_GK_CM_120E\",GEOGCS[\"GCS_Beijing_1954\",DATUM[\"D_Beijing_1954\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",120.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2437]]",
        2438=>"PROJCS[\"Beijing_1954_3_Degree_GK_CM_123E\",GEOGCS[\"GCS_Beijing_1954\",DATUM[\"D_Beijing_1954\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",123.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2438]]",
        2439=>"PROJCS[\"Beijing_1954_3_Degree_GK_CM_126E\",GEOGCS[\"GCS_Beijing_1954\",DATUM[\"D_Beijing_1954\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",126.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2439]]",
        2440=>"PROJCS[\"Beijing_1954_3_Degree_GK_CM_129E\",GEOGCS[\"GCS_Beijing_1954\",DATUM[\"D_Beijing_1954\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",129.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2440]]",
        2441=>"PROJCS[\"Beijing_1954_3_Degree_GK_CM_132E\",GEOGCS[\"GCS_Beijing_1954\",DATUM[\"D_Beijing_1954\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",132.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2441]]",
        2442=>"PROJCS[\"Beijing_1954_3_Degree_GK_CM_135E\",GEOGCS[\"GCS_Beijing_1954\",DATUM[\"D_Beijing_1954\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",135.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2442]]",
        2443=>"PROJCS[\"JGD_2000_Japan_Zone_1\",GEOGCS[\"GCS_JGD_2000\",DATUM[\"D_JGD_2000\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",0.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",129.5],PARAMETER[\"Scale_Factor\",0.9999],PARAMETER[\"Latitude_Of_Origin\",33.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2443]]",
        2444=>"PROJCS[\"JGD_2000_Japan_Zone_2\",GEOGCS[\"GCS_JGD_2000\",DATUM[\"D_JGD_2000\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",0.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",131.0],PARAMETER[\"Scale_Factor\",0.9999],PARAMETER[\"Latitude_Of_Origin\",33.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2444]]",
        2445=>"PROJCS[\"JGD_2000_Japan_Zone_3\",GEOGCS[\"GCS_JGD_2000\",DATUM[\"D_JGD_2000\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",0.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",132.1666666666667],PARAMETER[\"Scale_Factor\",0.9999],PARAMETER[\"Latitude_Of_Origin\",36.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2445]]",
        2446=>"PROJCS[\"JGD_2000_Japan_Zone_4\",GEOGCS[\"GCS_JGD_2000\",DATUM[\"D_JGD_2000\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",0.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",133.5],PARAMETER[\"Scale_Factor\",0.9999],PARAMETER[\"Latitude_Of_Origin\",33.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2446]]",
        2447=>"PROJCS[\"JGD_2000_Japan_Zone_5\",GEOGCS[\"GCS_JGD_2000\",DATUM[\"D_JGD_2000\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",0.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",134.3333333333333],PARAMETER[\"Scale_Factor\",0.9999],PARAMETER[\"Latitude_Of_Origin\",36.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2447]]",
        2448=>"PROJCS[\"JGD_2000_Japan_Zone_6\",GEOGCS[\"GCS_JGD_2000\",DATUM[\"D_JGD_2000\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",0.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",136.0],PARAMETER[\"Scale_Factor\",0.9999],PARAMETER[\"Latitude_Of_Origin\",36.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2448]]",
        2449=>"PROJCS[\"JGD_2000_Japan_Zone_7\",GEOGCS[\"GCS_JGD_2000\",DATUM[\"D_JGD_2000\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",0.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",137.1666666666667],PARAMETER[\"Scale_Factor\",0.9999],PARAMETER[\"Latitude_Of_Origin\",36.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2449]]",
        2450=>"PROJCS[\"JGD_2000_Japan_Zone_8\",GEOGCS[\"GCS_JGD_2000\",DATUM[\"D_JGD_2000\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",0.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",138.5],PARAMETER[\"Scale_Factor\",0.9999],PARAMETER[\"Latitude_Of_Origin\",36.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2450]]",
        2451=>"PROJCS[\"JGD_2000_Japan_Zone_9\",GEOGCS[\"GCS_JGD_2000\",DATUM[\"D_JGD_2000\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",0.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",139.8333333333333],PARAMETER[\"Scale_Factor\",0.9999],PARAMETER[\"Latitude_Of_Origin\",36.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2451]]",
        2452=>"PROJCS[\"JGD_2000_Japan_Zone_10\",GEOGCS[\"GCS_JGD_2000\",DATUM[\"D_JGD_2000\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",0.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",140.8333333333333],PARAMETER[\"Scale_Factor\",0.9999],PARAMETER[\"Latitude_Of_Origin\",40.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2452]]",
        2453=>"PROJCS[\"JGD_2000_Japan_Zone_11\",GEOGCS[\"GCS_JGD_2000\",DATUM[\"D_JGD_2000\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",0.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",140.25],PARAMETER[\"Scale_Factor\",0.9999],PARAMETER[\"Latitude_Of_Origin\",44.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2453]]",
        2454=>"PROJCS[\"JGD_2000_Japan_Zone_12\",GEOGCS[\"GCS_JGD_2000\",DATUM[\"D_JGD_2000\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",0.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",142.25],PARAMETER[\"Scale_Factor\",0.9999],PARAMETER[\"Latitude_Of_Origin\",44.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2454]]",
        2455=>"PROJCS[\"JGD_2000_Japan_Zone_13\",GEOGCS[\"GCS_JGD_2000\",DATUM[\"D_JGD_2000\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",0.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",144.25],PARAMETER[\"Scale_Factor\",0.9999],PARAMETER[\"Latitude_Of_Origin\",44.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2455]]",
        2456=>"PROJCS[\"JGD_2000_Japan_Zone_14\",GEOGCS[\"GCS_JGD_2000\",DATUM[\"D_JGD_2000\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",0.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",142.0],PARAMETER[\"Scale_Factor\",0.9999],PARAMETER[\"Latitude_Of_Origin\",26.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2456]]",
        2457=>"PROJCS[\"JGD_2000_Japan_Zone_15\",GEOGCS[\"GCS_JGD_2000\",DATUM[\"D_JGD_2000\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",0.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",127.5],PARAMETER[\"Scale_Factor\",0.9999],PARAMETER[\"Latitude_Of_Origin\",26.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2457]]",
        2458=>"PROJCS[\"JGD_2000_Japan_Zone_16\",GEOGCS[\"GCS_JGD_2000\",DATUM[\"D_JGD_2000\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",0.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",124.0],PARAMETER[\"Scale_Factor\",0.9999],PARAMETER[\"Latitude_Of_Origin\",26.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2458]]",
        2459=>"PROJCS[\"JGD_2000_Japan_Zone_17\",GEOGCS[\"GCS_JGD_2000\",DATUM[\"D_JGD_2000\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",0.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",131.0],PARAMETER[\"Scale_Factor\",0.9999],PARAMETER[\"Latitude_Of_Origin\",26.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2459]]",
        2460=>"PROJCS[\"JGD_2000_Japan_Zone_18\",GEOGCS[\"GCS_JGD_2000\",DATUM[\"D_JGD_2000\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",0.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",136.0],PARAMETER[\"Scale_Factor\",0.9999],PARAMETER[\"Latitude_Of_Origin\",20.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2460]]",
        2461=>"PROJCS[\"JGD_2000_Japan_Zone_19\",GEOGCS[\"GCS_JGD_2000\",DATUM[\"D_JGD_2000\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",0.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",154.0],PARAMETER[\"Scale_Factor\",0.9999],PARAMETER[\"Latitude_Of_Origin\",26.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2461]]",
        2462=>"PROJCS[\"Albanian_1987_GK_Zone_4\",GEOGCS[\"GCS_Albanian_1987\",DATUM[\"D_Albanian_1987\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",4500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",21.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2462]]",
        2463=>"PROJCS[\"Pulkovo_1995_Gauss-Kruger_CM_21E\",GEOGCS[\"GCS_Pulkovo_1995\",DATUM[\"D_Pulkovo_1995\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",21.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2463]]",
        2464=>"PROJCS[\"Pulkovo_1995_Gauss-Kruger_CM_27E\",GEOGCS[\"GCS_Pulkovo_1995\",DATUM[\"D_Pulkovo_1995\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",27.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2464]]",
        2465=>"PROJCS[\"Pulkovo_1995_Gauss-Kruger_CM_33E\",GEOGCS[\"GCS_Pulkovo_1995\",DATUM[\"D_Pulkovo_1995\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",33.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2465]]",
        2466=>"PROJCS[\"Pulkovo_1995_Gauss-Kruger_CM_39E\",GEOGCS[\"GCS_Pulkovo_1995\",DATUM[\"D_Pulkovo_1995\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",39.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2466]]",
        2467=>"PROJCS[\"Pulkovo_1995_Gauss-Kruger_CM_45E\",GEOGCS[\"GCS_Pulkovo_1995\",DATUM[\"D_Pulkovo_1995\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",45.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2467]]",
        2468=>"PROJCS[\"Pulkovo_1995_Gauss-Kruger_CM_51E\",GEOGCS[\"GCS_Pulkovo_1995\",DATUM[\"D_Pulkovo_1995\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",51.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2468]]",
        2469=>"PROJCS[\"Pulkovo_1995_Gauss-Kruger_CM_57E\",GEOGCS[\"GCS_Pulkovo_1995\",DATUM[\"D_Pulkovo_1995\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",57.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2469]]",
        2470=>"PROJCS[\"Pulkovo_1995_Gauss-Kruger_CM_63E\",GEOGCS[\"GCS_Pulkovo_1995\",DATUM[\"D_Pulkovo_1995\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",63.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2470]]",
        2471=>"PROJCS[\"Pulkovo_1995_Gauss-Kruger_CM_69E\",GEOGCS[\"GCS_Pulkovo_1995\",DATUM[\"D_Pulkovo_1995\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",69.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2471]]",
        2472=>"PROJCS[\"Pulkovo_1995_Gauss-Kruger_CM_75E\",GEOGCS[\"GCS_Pulkovo_1995\",DATUM[\"D_Pulkovo_1995\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",75.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2472]]",
        2473=>"PROJCS[\"Pulkovo_1995_Gauss-Kruger_CM_81E\",GEOGCS[\"GCS_Pulkovo_1995\",DATUM[\"D_Pulkovo_1995\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",81.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2473]]",
        2474=>"PROJCS[\"Pulkovo_1995_Gauss-Kruger_CM_87E\",GEOGCS[\"GCS_Pulkovo_1995\",DATUM[\"D_Pulkovo_1995\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",87.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2474]]",
        2475=>"PROJCS[\"Pulkovo_1995_Gauss-Kruger_CM_93E\",GEOGCS[\"GCS_Pulkovo_1995\",DATUM[\"D_Pulkovo_1995\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",93.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2475]]",
        2476=>"PROJCS[\"Pulkovo_1995_Gauss-Kruger_CM_99E\",GEOGCS[\"GCS_Pulkovo_1995\",DATUM[\"D_Pulkovo_1995\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",99.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2476]]",
        2477=>"PROJCS[\"Pulkovo_1995_Gauss-Kruger_CM_105E\",GEOGCS[\"GCS_Pulkovo_1995\",DATUM[\"D_Pulkovo_1995\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",105.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2477]]",
        2478=>"PROJCS[\"Pulkovo_1995_Gauss-Kruger_CM_111E\",GEOGCS[\"GCS_Pulkovo_1995\",DATUM[\"D_Pulkovo_1995\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",111.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2478]]",
        2479=>"PROJCS[\"Pulkovo_1995_Gauss-Kruger_CM_117E\",GEOGCS[\"GCS_Pulkovo_1995\",DATUM[\"D_Pulkovo_1995\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",117.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2479]]",
        2480=>"PROJCS[\"Pulkovo_1995_Gauss-Kruger_CM_123E\",GEOGCS[\"GCS_Pulkovo_1995\",DATUM[\"D_Pulkovo_1995\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",123.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2480]]",
        2481=>"PROJCS[\"Pulkovo_1995_Gauss-Kruger_CM_129E\",GEOGCS[\"GCS_Pulkovo_1995\",DATUM[\"D_Pulkovo_1995\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",129.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2481]]",
        2482=>"PROJCS[\"Pulkovo_1995_Gauss-Kruger_CM_135E\",GEOGCS[\"GCS_Pulkovo_1995\",DATUM[\"D_Pulkovo_1995\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",135.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2482]]",
        2483=>"PROJCS[\"Pulkovo_1995_Gauss-Kruger_CM_141E\",GEOGCS[\"GCS_Pulkovo_1995\",DATUM[\"D_Pulkovo_1995\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",141.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2483]]",
        2484=>"PROJCS[\"Pulkovo_1995_Gauss-Kruger_CM_147E\",GEOGCS[\"GCS_Pulkovo_1995\",DATUM[\"D_Pulkovo_1995\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",147.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2484]]",
        2485=>"PROJCS[\"Pulkovo_1995_Gauss-Kruger_CM_153E\",GEOGCS[\"GCS_Pulkovo_1995\",DATUM[\"D_Pulkovo_1995\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",153.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2485]]",
        2486=>"PROJCS[\"Pulkovo_1995_Gauss-Kruger_CM_159E\",GEOGCS[\"GCS_Pulkovo_1995\",DATUM[\"D_Pulkovo_1995\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",159.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2486]]",
        2487=>"PROJCS[\"Pulkovo_1995_Gauss-Kruger_CM_165E\",GEOGCS[\"GCS_Pulkovo_1995\",DATUM[\"D_Pulkovo_1995\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",165.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2487]]",
        2488=>"PROJCS[\"Pulkovo_1995_Gauss-Kruger_CM_171E\",GEOGCS[\"GCS_Pulkovo_1995\",DATUM[\"D_Pulkovo_1995\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",171.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2488]]",
        2489=>"PROJCS[\"Pulkovo_1995_Gauss-Kruger_CM_177E\",GEOGCS[\"GCS_Pulkovo_1995\",DATUM[\"D_Pulkovo_1995\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",177.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2489]]",
        2490=>"PROJCS[\"Pulkovo_1995_Gauss-Kruger_CM_177W\",GEOGCS[\"GCS_Pulkovo_1995\",DATUM[\"D_Pulkovo_1995\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-177.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2490]]",
        2491=>"PROJCS[\"Pulkovo_1995_Gauss-Kruger_CM_171W\",GEOGCS[\"GCS_Pulkovo_1995\",DATUM[\"D_Pulkovo_1995\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-171.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2491]]",
        2494=>"PROJCS[\"Pulkovo_1942_Gauss-Kruger_CM_21E\",GEOGCS[\"GCS_Pulkovo_1942\",DATUM[\"D_Pulkovo_1942\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",21.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2494]]",
        2495=>"PROJCS[\"Pulkovo_1942_Gauss-Kruger_CM_27E\",GEOGCS[\"GCS_Pulkovo_1942\",DATUM[\"D_Pulkovo_1942\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",27.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2495]]",
        2496=>"PROJCS[\"Pulkovo_1942_Gauss-Kruger_CM_33E\",GEOGCS[\"GCS_Pulkovo_1942\",DATUM[\"D_Pulkovo_1942\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",33.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2496]]",
        2497=>"PROJCS[\"Pulkovo_1942_Gauss-Kruger_CM_39E\",GEOGCS[\"GCS_Pulkovo_1942\",DATUM[\"D_Pulkovo_1942\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",39.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2497]]",
        2498=>"PROJCS[\"Pulkovo_1942_Gauss-Kruger_CM_45E\",GEOGCS[\"GCS_Pulkovo_1942\",DATUM[\"D_Pulkovo_1942\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",45.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2498]]",
        2499=>"PROJCS[\"Pulkovo_1942_Gauss-Kruger_CM_51E\",GEOGCS[\"GCS_Pulkovo_1942\",DATUM[\"D_Pulkovo_1942\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",51.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2499]]",
        2500=>"PROJCS[\"Pulkovo_1942_Gauss-Kruger_CM_57E\",GEOGCS[\"GCS_Pulkovo_1942\",DATUM[\"D_Pulkovo_1942\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",57.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2500]]",
        2501=>"PROJCS[\"Pulkovo_1942_Gauss-Kruger_CM_63E\",GEOGCS[\"GCS_Pulkovo_1942\",DATUM[\"D_Pulkovo_1942\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",63.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2501]]",
        2502=>"PROJCS[\"Pulkovo_1942_Gauss-Kruger_CM_69E\",GEOGCS[\"GCS_Pulkovo_1942\",DATUM[\"D_Pulkovo_1942\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",69.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2502]]",
        2503=>"PROJCS[\"Pulkovo_1942_Gauss-Kruger_CM_75E\",GEOGCS[\"GCS_Pulkovo_1942\",DATUM[\"D_Pulkovo_1942\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",75.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2503]]",
        2504=>"PROJCS[\"Pulkovo_1942_Gauss-Kruger_CM_81E\",GEOGCS[\"GCS_Pulkovo_1942\",DATUM[\"D_Pulkovo_1942\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",81.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2504]]",
        2505=>"PROJCS[\"Pulkovo_1942_Gauss-Kruger_CM_87E\",GEOGCS[\"GCS_Pulkovo_1942\",DATUM[\"D_Pulkovo_1942\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",87.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2505]]",
        2506=>"PROJCS[\"Pulkovo_1942_Gauss-Kruger_CM_93E\",GEOGCS[\"GCS_Pulkovo_1942\",DATUM[\"D_Pulkovo_1942\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",93.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2506]]",
        2507=>"PROJCS[\"Pulkovo_1942_Gauss-Kruger_CM_99E\",GEOGCS[\"GCS_Pulkovo_1942\",DATUM[\"D_Pulkovo_1942\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",99.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2507]]",
        2508=>"PROJCS[\"Pulkovo_1942_Gauss-Kruger_CM_105E\",GEOGCS[\"GCS_Pulkovo_1942\",DATUM[\"D_Pulkovo_1942\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",105.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2508]]",
        2509=>"PROJCS[\"Pulkovo_1942_Gauss-Kruger_CM_111E\",GEOGCS[\"GCS_Pulkovo_1942\",DATUM[\"D_Pulkovo_1942\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",111.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2509]]",
        2510=>"PROJCS[\"Pulkovo_1942_Gauss-Kruger_CM_117E\",GEOGCS[\"GCS_Pulkovo_1942\",DATUM[\"D_Pulkovo_1942\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",117.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2510]]",
        2511=>"PROJCS[\"Pulkovo_1942_Gauss-Kruger_CM_123E\",GEOGCS[\"GCS_Pulkovo_1942\",DATUM[\"D_Pulkovo_1942\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",123.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2511]]",
        2512=>"PROJCS[\"Pulkovo_1942_Gauss-Kruger_CM_129E\",GEOGCS[\"GCS_Pulkovo_1942\",DATUM[\"D_Pulkovo_1942\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",129.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2512]]",
        2513=>"PROJCS[\"Pulkovo_1942_Gauss-Kruger_CM_135E\",GEOGCS[\"GCS_Pulkovo_1942\",DATUM[\"D_Pulkovo_1942\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",135.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2513]]",
        2514=>"PROJCS[\"Pulkovo_1942_Gauss-Kruger_CM_141E\",GEOGCS[\"GCS_Pulkovo_1942\",DATUM[\"D_Pulkovo_1942\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",141.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2514]]",
        2515=>"PROJCS[\"Pulkovo_1942_Gauss-Kruger_CM_147E\",GEOGCS[\"GCS_Pulkovo_1942\",DATUM[\"D_Pulkovo_1942\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",147.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2515]]",
        2516=>"PROJCS[\"Pulkovo_1942_Gauss-Kruger_CM_153E\",GEOGCS[\"GCS_Pulkovo_1942\",DATUM[\"D_Pulkovo_1942\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",153.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2516]]",
        2517=>"PROJCS[\"Pulkovo_1942_Gauss-Kruger_CM_159E\",GEOGCS[\"GCS_Pulkovo_1942\",DATUM[\"D_Pulkovo_1942\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",159.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2517]]",
        2518=>"PROJCS[\"Pulkovo_1942_Gauss-Kruger_CM_165E\",GEOGCS[\"GCS_Pulkovo_1942\",DATUM[\"D_Pulkovo_1942\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",165.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2518]]",
        2519=>"PROJCS[\"Pulkovo_1942_Gauss-Kruger_CM_171E\",GEOGCS[\"GCS_Pulkovo_1942\",DATUM[\"D_Pulkovo_1942\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",171.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2519]]",
        2520=>"PROJCS[\"Pulkovo_1942_Gauss-Kruger_CM_177E\",GEOGCS[\"GCS_Pulkovo_1942\",DATUM[\"D_Pulkovo_1942\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",177.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2520]]",
        2521=>"PROJCS[\"Pulkovo_1942_Gauss-Kruger_CM_177W\",GEOGCS[\"GCS_Pulkovo_1942\",DATUM[\"D_Pulkovo_1942\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-177.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2521]]",
        2522=>"PROJCS[\"Pulkovo_1942_Gauss-Kruger_CM_171W\",GEOGCS[\"GCS_Pulkovo_1942\",DATUM[\"D_Pulkovo_1942\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-171.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2522]]",
        2523=>"PROJCS[\"Pulkovo_1942_3_Degree_GK_Zone_7\",GEOGCS[\"GCS_Pulkovo_1942\",DATUM[\"D_Pulkovo_1942\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",7500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",21.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2523]]",
        2524=>"PROJCS[\"Pulkovo_1942_3_Degree_GK_Zone_8\",GEOGCS[\"GCS_Pulkovo_1942\",DATUM[\"D_Pulkovo_1942\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",8500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",24.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2524]]",
        2525=>"PROJCS[\"Pulkovo_1942_3_Degree_GK_Zone_9\",GEOGCS[\"GCS_Pulkovo_1942\",DATUM[\"D_Pulkovo_1942\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",9500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",27.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2525]]",
        2526=>"PROJCS[\"Pulkovo_1942_3_Degree_GK_Zone_10\",GEOGCS[\"GCS_Pulkovo_1942\",DATUM[\"D_Pulkovo_1942\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",10500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",30.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2526]]",
        2527=>"PROJCS[\"Pulkovo_1942_3_Degree_GK_Zone_11\",GEOGCS[\"GCS_Pulkovo_1942\",DATUM[\"D_Pulkovo_1942\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",11500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",33.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2527]]",
        2528=>"PROJCS[\"Pulkovo_1942_3_Degree_GK_Zone_12\",GEOGCS[\"GCS_Pulkovo_1942\",DATUM[\"D_Pulkovo_1942\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",12500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",36.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2528]]",
        2529=>"PROJCS[\"Pulkovo_1942_3_Degree_GK_Zone_13\",GEOGCS[\"GCS_Pulkovo_1942\",DATUM[\"D_Pulkovo_1942\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",13500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",39.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2529]]",
        2530=>"PROJCS[\"Pulkovo_1942_3_Degree_GK_Zone_14\",GEOGCS[\"GCS_Pulkovo_1942\",DATUM[\"D_Pulkovo_1942\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",14500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",42.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2530]]",
        2531=>"PROJCS[\"Pulkovo_1942_3_Degree_GK_Zone_15\",GEOGCS[\"GCS_Pulkovo_1942\",DATUM[\"D_Pulkovo_1942\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",15500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",45.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2531]]",
        2532=>"PROJCS[\"Pulkovo_1942_3_Degree_GK_Zone_16\",GEOGCS[\"GCS_Pulkovo_1942\",DATUM[\"D_Pulkovo_1942\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",16500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",48.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2532]]",
        2533=>"PROJCS[\"Pulkovo_1942_3_Degree_GK_Zone_17\",GEOGCS[\"GCS_Pulkovo_1942\",DATUM[\"D_Pulkovo_1942\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",17500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",51.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2533]]",
        2534=>"PROJCS[\"Pulkovo_1942_3_Degree_GK_Zone_18\",GEOGCS[\"GCS_Pulkovo_1942\",DATUM[\"D_Pulkovo_1942\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",18500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",54.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2534]]",
        2535=>"PROJCS[\"Pulkovo_1942_3_Degree_GK_Zone_19\",GEOGCS[\"GCS_Pulkovo_1942\",DATUM[\"D_Pulkovo_1942\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",19500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",57.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2535]]",
        2536=>"PROJCS[\"Pulkovo_1942_3_Degree_GK_Zone_20\",GEOGCS[\"GCS_Pulkovo_1942\",DATUM[\"D_Pulkovo_1942\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",20500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",60.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2536]]",
        2537=>"PROJCS[\"Pulkovo_1942_3_Degree_GK_Zone_21\",GEOGCS[\"GCS_Pulkovo_1942\",DATUM[\"D_Pulkovo_1942\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",21500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",63.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2537]]",
        2538=>"PROJCS[\"Pulkovo_1942_3_Degree_GK_Zone_22\",GEOGCS[\"GCS_Pulkovo_1942\",DATUM[\"D_Pulkovo_1942\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",22500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",66.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2538]]",
        2539=>"PROJCS[\"Pulkovo_1942_3_Degree_GK_Zone_23\",GEOGCS[\"GCS_Pulkovo_1942\",DATUM[\"D_Pulkovo_1942\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",23500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",69.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2539]]",
        2540=>"PROJCS[\"Pulkovo_1942_3_Degree_GK_Zone_24\",GEOGCS[\"GCS_Pulkovo_1942\",DATUM[\"D_Pulkovo_1942\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",24500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",72.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2540]]",
        2541=>"PROJCS[\"Pulkovo_1942_3_Degree_GK_Zone_25\",GEOGCS[\"GCS_Pulkovo_1942\",DATUM[\"D_Pulkovo_1942\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",25500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",75.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2541]]",
        2542=>"PROJCS[\"Pulkovo_1942_3_Degree_GK_Zone_26\",GEOGCS[\"GCS_Pulkovo_1942\",DATUM[\"D_Pulkovo_1942\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",26500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",78.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2542]]",
        2543=>"PROJCS[\"Pulkovo_1942_3_Degree_GK_Zone_27\",GEOGCS[\"GCS_Pulkovo_1942\",DATUM[\"D_Pulkovo_1942\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",27500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",81.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2543]]",
        2544=>"PROJCS[\"Pulkovo_1942_3_Degree_GK_Zone_28\",GEOGCS[\"GCS_Pulkovo_1942\",DATUM[\"D_Pulkovo_1942\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",28500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",84.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2544]]",
        2545=>"PROJCS[\"Pulkovo_1942_3_Degree_GK_Zone_29\",GEOGCS[\"GCS_Pulkovo_1942\",DATUM[\"D_Pulkovo_1942\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",29500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",87.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2545]]",
        2546=>"PROJCS[\"Pulkovo_1942_3_Degree_GK_Zone_30\",GEOGCS[\"GCS_Pulkovo_1942\",DATUM[\"D_Pulkovo_1942\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",30500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",90.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2546]]",
        2547=>"PROJCS[\"Pulkovo_1942_3_Degree_GK_Zone_31\",GEOGCS[\"GCS_Pulkovo_1942\",DATUM[\"D_Pulkovo_1942\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",31500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",93.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2547]]",
        2548=>"PROJCS[\"Pulkovo_1942_3_Degree_GK_Zone_32\",GEOGCS[\"GCS_Pulkovo_1942\",DATUM[\"D_Pulkovo_1942\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",32500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",96.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2548]]",
        2549=>"PROJCS[\"Pulkovo_1942_3_Degree_GK_Zone_33\",GEOGCS[\"GCS_Pulkovo_1942\",DATUM[\"D_Pulkovo_1942\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",33500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",99.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2549]]",
        2550=>"PROJCS[\"Samboja_UTM_Zone_50S\",GEOGCS[\"GCS_Samboja\",DATUM[\"D_Samboja\",SPHEROID[\"Bessel_1841\",6377397.155,299.1528128]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",10000000.0],PARAMETER[\"Central_Meridian\",117.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2550]]",
        2551=>"PROJCS[\"Pulkovo_1942_3_Degree_GK_Zone_34\",GEOGCS[\"GCS_Pulkovo_1942\",DATUM[\"D_Pulkovo_1942\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",34500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",102.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2551]]",
        2552=>"PROJCS[\"Pulkovo_1942_3_Degree_GK_Zone_35\",GEOGCS[\"GCS_Pulkovo_1942\",DATUM[\"D_Pulkovo_1942\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",35500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",105.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2552]]",
        2553=>"PROJCS[\"Pulkovo_1942_3_Degree_GK_Zone_36\",GEOGCS[\"GCS_Pulkovo_1942\",DATUM[\"D_Pulkovo_1942\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",36500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",108.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2553]]",
        2554=>"PROJCS[\"Pulkovo_1942_3_Degree_GK_Zone_37\",GEOGCS[\"GCS_Pulkovo_1942\",DATUM[\"D_Pulkovo_1942\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",37500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",111.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2554]]",
        2555=>"PROJCS[\"Pulkovo_1942_3_Degree_GK_Zone_38\",GEOGCS[\"GCS_Pulkovo_1942\",DATUM[\"D_Pulkovo_1942\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",38500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",114.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2555]]",
        2556=>"PROJCS[\"Pulkovo_1942_3_Degree_GK_Zone_39\",GEOGCS[\"GCS_Pulkovo_1942\",DATUM[\"D_Pulkovo_1942\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",39500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",117.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2556]]",
        2557=>"PROJCS[\"Pulkovo_1942_3_Degree_GK_Zone_40\",GEOGCS[\"GCS_Pulkovo_1942\",DATUM[\"D_Pulkovo_1942\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",40500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",120.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2557]]",
        2558=>"PROJCS[\"Pulkovo_1942_3_Degree_GK_Zone_41\",GEOGCS[\"GCS_Pulkovo_1942\",DATUM[\"D_Pulkovo_1942\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",41500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",123.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2558]]",
        2559=>"PROJCS[\"Pulkovo_1942_3_Degree_GK_Zone_42\",GEOGCS[\"GCS_Pulkovo_1942\",DATUM[\"D_Pulkovo_1942\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",42500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",126.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2559]]",
        2560=>"PROJCS[\"Pulkovo_1942_3_Degree_GK_Zone_43\",GEOGCS[\"GCS_Pulkovo_1942\",DATUM[\"D_Pulkovo_1942\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",43500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",129.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2560]]",
        2561=>"PROJCS[\"Pulkovo_1942_3_Degree_GK_Zone_44\",GEOGCS[\"GCS_Pulkovo_1942\",DATUM[\"D_Pulkovo_1942\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",44500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",132.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2561]]",
        2562=>"PROJCS[\"Pulkovo_1942_3_Degree_GK_Zone_45\",GEOGCS[\"GCS_Pulkovo_1942\",DATUM[\"D_Pulkovo_1942\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",45500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",135.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2562]]",
        2563=>"PROJCS[\"Pulkovo_1942_3_Degree_GK_Zone_46\",GEOGCS[\"GCS_Pulkovo_1942\",DATUM[\"D_Pulkovo_1942\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",46500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",138.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2563]]",
        2564=>"PROJCS[\"Pulkovo_1942_3_Degree_GK_Zone_47\",GEOGCS[\"GCS_Pulkovo_1942\",DATUM[\"D_Pulkovo_1942\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",47500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",141.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2564]]",
        2565=>"PROJCS[\"Pulkovo_1942_3_Degree_GK_Zone_48\",GEOGCS[\"GCS_Pulkovo_1942\",DATUM[\"D_Pulkovo_1942\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",48500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",144.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2565]]",
        2566=>"PROJCS[\"Pulkovo_1942_3_Degree_GK_Zone_49\",GEOGCS[\"GCS_Pulkovo_1942\",DATUM[\"D_Pulkovo_1942\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",49500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",147.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2566]]",
        2567=>"PROJCS[\"Pulkovo_1942_3_Degree_GK_Zone_50\",GEOGCS[\"GCS_Pulkovo_1942\",DATUM[\"D_Pulkovo_1942\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",50500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",150.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2567]]",
        2568=>"PROJCS[\"Pulkovo_1942_3_Degree_GK_Zone_51\",GEOGCS[\"GCS_Pulkovo_1942\",DATUM[\"D_Pulkovo_1942\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",51500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",153.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2568]]",
        2569=>"PROJCS[\"Pulkovo_1942_3_Degree_GK_Zone_52\",GEOGCS[\"GCS_Pulkovo_1942\",DATUM[\"D_Pulkovo_1942\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",52500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",156.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2569]]",
        2570=>"PROJCS[\"Pulkovo_1942_3_Degree_GK_Zone_53\",GEOGCS[\"GCS_Pulkovo_1942\",DATUM[\"D_Pulkovo_1942\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",53500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",159.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2570]]",
        2571=>"PROJCS[\"Pulkovo_1942_3_Degree_GK_Zone_54\",GEOGCS[\"GCS_Pulkovo_1942\",DATUM[\"D_Pulkovo_1942\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",54500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",162.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2571]]",
        2572=>"PROJCS[\"Pulkovo_1942_3_Degree_GK_Zone_55\",GEOGCS[\"GCS_Pulkovo_1942\",DATUM[\"D_Pulkovo_1942\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",55500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",165.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2572]]",
        2573=>"PROJCS[\"Pulkovo_1942_3_Degree_GK_Zone_56\",GEOGCS[\"GCS_Pulkovo_1942\",DATUM[\"D_Pulkovo_1942\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",56500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",168.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2573]]",
        2574=>"PROJCS[\"Pulkovo_1942_3_Degree_GK_Zone_57\",GEOGCS[\"GCS_Pulkovo_1942\",DATUM[\"D_Pulkovo_1942\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",57500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",171.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2574]]",
        2575=>"PROJCS[\"Pulkovo_1942_3_Degree_GK_Zone_58\",GEOGCS[\"GCS_Pulkovo_1942\",DATUM[\"D_Pulkovo_1942\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",58500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",174.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2575]]",
        2576=>"PROJCS[\"Pulkovo_1942_3_Degree_GK_Zone_59\",GEOGCS[\"GCS_Pulkovo_1942\",DATUM[\"D_Pulkovo_1942\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",59500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",177.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2576]]",
        2577=>"PROJCS[\"Pulkovo_1942_3_Degree_GK_Zone_60\",GEOGCS[\"GCS_Pulkovo_1942\",DATUM[\"D_Pulkovo_1942\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",60500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",180.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3389]]",
        2578=>"PROJCS[\"Pulkovo_1942_3_Degree_GK_Zone_61\",GEOGCS[\"GCS_Pulkovo_1942\",DATUM[\"D_Pulkovo_1942\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",61500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-177.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2578]]",
        2579=>"PROJCS[\"Pulkovo_1942_3_Degree_GK_Zone_62\",GEOGCS[\"GCS_Pulkovo_1942\",DATUM[\"D_Pulkovo_1942\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",62500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-174.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2579]]",
        2580=>"PROJCS[\"Pulkovo_1942_3_Degree_GK_Zone_63\",GEOGCS[\"GCS_Pulkovo_1942\",DATUM[\"D_Pulkovo_1942\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",63500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-171.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2580]]",
        2581=>"PROJCS[\"Pulkovo_1942_3_Degree_GK_Zone_64\",GEOGCS[\"GCS_Pulkovo_1942\",DATUM[\"D_Pulkovo_1942\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",64500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-168.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2581]]",
        2582=>"PROJCS[\"Pulkovo_1942_3_Degree_GK_CM_21E\",GEOGCS[\"GCS_Pulkovo_1942\",DATUM[\"D_Pulkovo_1942\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",21.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2582]]",
        2583=>"PROJCS[\"Pulkovo_1942_3_Degree_GK_CM_24E\",GEOGCS[\"GCS_Pulkovo_1942\",DATUM[\"D_Pulkovo_1942\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",24.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2583]]",
        2584=>"PROJCS[\"Pulkovo_1942_3_Degree_GK_CM_27E\",GEOGCS[\"GCS_Pulkovo_1942\",DATUM[\"D_Pulkovo_1942\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",27.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2584]]",
        2585=>"PROJCS[\"Pulkovo_1942_3_Degree_GK_CM_30E\",GEOGCS[\"GCS_Pulkovo_1942\",DATUM[\"D_Pulkovo_1942\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",30.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2585]]",
        2586=>"PROJCS[\"Pulkovo_1942_3_Degree_GK_CM_33E\",GEOGCS[\"GCS_Pulkovo_1942\",DATUM[\"D_Pulkovo_1942\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",33.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2586]]",
        2587=>"PROJCS[\"Pulkovo_1942_3_Degree_GK_CM_36E\",GEOGCS[\"GCS_Pulkovo_1942\",DATUM[\"D_Pulkovo_1942\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",36.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2587]]",
        2588=>"PROJCS[\"Pulkovo_1942_3_Degree_GK_CM_39E\",GEOGCS[\"GCS_Pulkovo_1942\",DATUM[\"D_Pulkovo_1942\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",39.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2588]]",
        2589=>"PROJCS[\"Pulkovo_1942_3_Degree_GK_CM_42E\",GEOGCS[\"GCS_Pulkovo_1942\",DATUM[\"D_Pulkovo_1942\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",42.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2589]]",
        2590=>"PROJCS[\"Pulkovo_1942_3_Degree_GK_CM_45E\",GEOGCS[\"GCS_Pulkovo_1942\",DATUM[\"D_Pulkovo_1942\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",45.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2590]]",
        2591=>"PROJCS[\"Pulkovo_1942_3_Degree_GK_CM_48E\",GEOGCS[\"GCS_Pulkovo_1942\",DATUM[\"D_Pulkovo_1942\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",48.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2591]]",
        2592=>"PROJCS[\"Pulkovo_1942_3_Degree_GK_CM_51E\",GEOGCS[\"GCS_Pulkovo_1942\",DATUM[\"D_Pulkovo_1942\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",51.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2592]]",
        2593=>"PROJCS[\"Pulkovo_1942_3_Degree_GK_CM_54E\",GEOGCS[\"GCS_Pulkovo_1942\",DATUM[\"D_Pulkovo_1942\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",54.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2593]]",
        2594=>"PROJCS[\"Pulkovo_1942_3_Degree_GK_CM_57E\",GEOGCS[\"GCS_Pulkovo_1942\",DATUM[\"D_Pulkovo_1942\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",57.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2594]]",
        2595=>"PROJCS[\"Pulkovo_1942_3_Degree_GK_CM_60E\",GEOGCS[\"GCS_Pulkovo_1942\",DATUM[\"D_Pulkovo_1942\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",60.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2595]]",
        2596=>"PROJCS[\"Pulkovo_1942_3_Degree_GK_CM_63E\",GEOGCS[\"GCS_Pulkovo_1942\",DATUM[\"D_Pulkovo_1942\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",63.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2596]]",
        2597=>"PROJCS[\"Pulkovo_1942_3_Degree_GK_CM_66E\",GEOGCS[\"GCS_Pulkovo_1942\",DATUM[\"D_Pulkovo_1942\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",66.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2597]]",
        2598=>"PROJCS[\"Pulkovo_1942_3_Degree_GK_CM_69E\",GEOGCS[\"GCS_Pulkovo_1942\",DATUM[\"D_Pulkovo_1942\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",69.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2598]]",
        2599=>"PROJCS[\"Pulkovo_1942_3_Degree_GK_CM_72E\",GEOGCS[\"GCS_Pulkovo_1942\",DATUM[\"D_Pulkovo_1942\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",72.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2599]]",
        2600=>"PROJCS[\"LKS_1994_Lithuania_TM\",GEOGCS[\"GCS_LKS_1994\",DATUM[\"D_Lithuania_1994\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",24.0],PARAMETER[\"Scale_Factor\",0.9998],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3346]]",
        2601=>"PROJCS[\"Pulkovo_1942_3_Degree_GK_CM_75E\",GEOGCS[\"GCS_Pulkovo_1942\",DATUM[\"D_Pulkovo_1942\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",75.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2601]]",
        2602=>"PROJCS[\"Pulkovo_1942_3_Degree_GK_CM_78E\",GEOGCS[\"GCS_Pulkovo_1942\",DATUM[\"D_Pulkovo_1942\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",78.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2602]]",
        2603=>"PROJCS[\"Pulkovo_1942_3_Degree_GK_CM_81E\",GEOGCS[\"GCS_Pulkovo_1942\",DATUM[\"D_Pulkovo_1942\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",81.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2603]]",
        2604=>"PROJCS[\"Pulkovo_1942_3_Degree_GK_CM_84E\",GEOGCS[\"GCS_Pulkovo_1942\",DATUM[\"D_Pulkovo_1942\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",84.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2604]]",
        2605=>"PROJCS[\"Pulkovo_1942_3_Degree_GK_CM_87E\",GEOGCS[\"GCS_Pulkovo_1942\",DATUM[\"D_Pulkovo_1942\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",87.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2605]]",
        2606=>"PROJCS[\"Pulkovo_1942_3_Degree_GK_CM_90E\",GEOGCS[\"GCS_Pulkovo_1942\",DATUM[\"D_Pulkovo_1942\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",90.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2606]]",
        2607=>"PROJCS[\"Pulkovo_1942_3_Degree_GK_CM_93E\",GEOGCS[\"GCS_Pulkovo_1942\",DATUM[\"D_Pulkovo_1942\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",93.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2607]]",
        2608=>"PROJCS[\"Pulkovo_1942_3_Degree_GK_CM_96E\",GEOGCS[\"GCS_Pulkovo_1942\",DATUM[\"D_Pulkovo_1942\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",96.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2608]]",
        2609=>"PROJCS[\"Pulkovo_1942_3_Degree_GK_CM_99E\",GEOGCS[\"GCS_Pulkovo_1942\",DATUM[\"D_Pulkovo_1942\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",99.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2609]]",
        2610=>"PROJCS[\"Pulkovo_1942_3_Degree_GK_CM_102E\",GEOGCS[\"GCS_Pulkovo_1942\",DATUM[\"D_Pulkovo_1942\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",102.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2610]]",
        2611=>"PROJCS[\"Pulkovo_1942_3_Degree_GK_CM_105E\",GEOGCS[\"GCS_Pulkovo_1942\",DATUM[\"D_Pulkovo_1942\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",105.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2611]]",
        2612=>"PROJCS[\"Pulkovo_1942_3_Degree_GK_CM_108E\",GEOGCS[\"GCS_Pulkovo_1942\",DATUM[\"D_Pulkovo_1942\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",108.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2612]]",
        2613=>"PROJCS[\"Pulkovo_1942_3_Degree_GK_CM_111E\",GEOGCS[\"GCS_Pulkovo_1942\",DATUM[\"D_Pulkovo_1942\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",111.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2613]]",
        2614=>"PROJCS[\"Pulkovo_1942_3_Degree_GK_CM_114E\",GEOGCS[\"GCS_Pulkovo_1942\",DATUM[\"D_Pulkovo_1942\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",114.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2614]]",
        2615=>"PROJCS[\"Pulkovo_1942_3_Degree_GK_CM_117E\",GEOGCS[\"GCS_Pulkovo_1942\",DATUM[\"D_Pulkovo_1942\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",117.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2615]]",
        2616=>"PROJCS[\"Pulkovo_1942_3_Degree_GK_CM_120E\",GEOGCS[\"GCS_Pulkovo_1942\",DATUM[\"D_Pulkovo_1942\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",120.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2616]]",
        2617=>"PROJCS[\"Pulkovo_1942_3_Degree_GK_CM_123E\",GEOGCS[\"GCS_Pulkovo_1942\",DATUM[\"D_Pulkovo_1942\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",123.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2617]]",
        2618=>"PROJCS[\"Pulkovo_1942_3_Degree_GK_CM_126E\",GEOGCS[\"GCS_Pulkovo_1942\",DATUM[\"D_Pulkovo_1942\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",126.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2618]]",
        2619=>"PROJCS[\"Pulkovo_1942_3_Degree_GK_CM_129E\",GEOGCS[\"GCS_Pulkovo_1942\",DATUM[\"D_Pulkovo_1942\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",129.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2619]]",
        2620=>"PROJCS[\"Pulkovo_1942_3_Degree_GK_CM_132E\",GEOGCS[\"GCS_Pulkovo_1942\",DATUM[\"D_Pulkovo_1942\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",132.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2620]]",
        2621=>"PROJCS[\"Pulkovo_1942_3_Degree_GK_CM_135E\",GEOGCS[\"GCS_Pulkovo_1942\",DATUM[\"D_Pulkovo_1942\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",135.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2621]]",
        2622=>"PROJCS[\"Pulkovo_1942_3_Degree_GK_CM_138E\",GEOGCS[\"GCS_Pulkovo_1942\",DATUM[\"D_Pulkovo_1942\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",138.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2622]]",
        2623=>"PROJCS[\"Pulkovo_1942_3_Degree_GK_CM_141E\",GEOGCS[\"GCS_Pulkovo_1942\",DATUM[\"D_Pulkovo_1942\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",141.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2623]]",
        2624=>"PROJCS[\"Pulkovo_1942_3_Degree_GK_CM_144E\",GEOGCS[\"GCS_Pulkovo_1942\",DATUM[\"D_Pulkovo_1942\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",144.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2624]]",
        2625=>"PROJCS[\"Pulkovo_1942_3_Degree_GK_CM_147E\",GEOGCS[\"GCS_Pulkovo_1942\",DATUM[\"D_Pulkovo_1942\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",147.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2625]]",
        2626=>"PROJCS[\"Pulkovo_1942_3_Degree_GK_CM_150E\",GEOGCS[\"GCS_Pulkovo_1942\",DATUM[\"D_Pulkovo_1942\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",150.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2626]]",
        2627=>"PROJCS[\"Pulkovo_1942_3_Degree_GK_CM_153E\",GEOGCS[\"GCS_Pulkovo_1942\",DATUM[\"D_Pulkovo_1942\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",153.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2627]]",
        2628=>"PROJCS[\"Pulkovo_1942_3_Degree_GK_CM_156E\",GEOGCS[\"GCS_Pulkovo_1942\",DATUM[\"D_Pulkovo_1942\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",156.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2628]]",
        2629=>"PROJCS[\"Pulkovo_1942_3_Degree_GK_CM_159E\",GEOGCS[\"GCS_Pulkovo_1942\",DATUM[\"D_Pulkovo_1942\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",159.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2629]]",
        2630=>"PROJCS[\"Pulkovo_1942_3_Degree_GK_CM_162E\",GEOGCS[\"GCS_Pulkovo_1942\",DATUM[\"D_Pulkovo_1942\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",162.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2630]]",
        2631=>"PROJCS[\"Pulkovo_1942_3_Degree_GK_CM_165E\",GEOGCS[\"GCS_Pulkovo_1942\",DATUM[\"D_Pulkovo_1942\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",165.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2631]]",
        2632=>"PROJCS[\"Pulkovo_1942_3_Degree_GK_CM_168E\",GEOGCS[\"GCS_Pulkovo_1942\",DATUM[\"D_Pulkovo_1942\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",168.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2632]]",
        2633=>"PROJCS[\"Pulkovo_1942_3_Degree_GK_CM_171E\",GEOGCS[\"GCS_Pulkovo_1942\",DATUM[\"D_Pulkovo_1942\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",171.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2633]]",
        2634=>"PROJCS[\"Pulkovo_1942_3_Degree_GK_CM_174E\",GEOGCS[\"GCS_Pulkovo_1942\",DATUM[\"D_Pulkovo_1942\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",174.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2634]]",
        2635=>"PROJCS[\"Pulkovo_1942_3_Degree_GK_CM_177E\",GEOGCS[\"GCS_Pulkovo_1942\",DATUM[\"D_Pulkovo_1942\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",177.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2635]]",
        2636=>"PROJCS[\"Pulkovo_1942_3_Degree_GK_CM_180E\",GEOGCS[\"GCS_Pulkovo_1942\",DATUM[\"D_Pulkovo_1942\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",180.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2636]]",
        2637=>"PROJCS[\"Pulkovo_1942_3_Degree_GK_CM_177W\",GEOGCS[\"GCS_Pulkovo_1942\",DATUM[\"D_Pulkovo_1942\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-177.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2637]]",
        2638=>"PROJCS[\"Pulkovo_1942_3_Degree_GK_CM_174W\",GEOGCS[\"GCS_Pulkovo_1942\",DATUM[\"D_Pulkovo_1942\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-174.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2638]]",
        2639=>"PROJCS[\"Pulkovo_1942_3_Degree_GK_CM_171W\",GEOGCS[\"GCS_Pulkovo_1942\",DATUM[\"D_Pulkovo_1942\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-171.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2639]]",
        2640=>"PROJCS[\"Pulkovo_1942_3_Degree_GK_CM_168W\",GEOGCS[\"GCS_Pulkovo_1942\",DATUM[\"D_Pulkovo_1942\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-168.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2640]]",
        2641=>"PROJCS[\"Pulkovo_1995_3_Degree_GK_Zone_7\",GEOGCS[\"GCS_Pulkovo_1995\",DATUM[\"D_Pulkovo_1995\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",7500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",21.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2641]]",
        2642=>"PROJCS[\"Pulkovo_1995_3_Degree_GK_Zone_8\",GEOGCS[\"GCS_Pulkovo_1995\",DATUM[\"D_Pulkovo_1995\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",8500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",24.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2642]]",
        2643=>"PROJCS[\"Pulkovo_1995_3_Degree_GK_Zone_9\",GEOGCS[\"GCS_Pulkovo_1995\",DATUM[\"D_Pulkovo_1995\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",9500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",27.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2643]]",
        2644=>"PROJCS[\"Pulkovo_1995_3_Degree_GK_Zone_10\",GEOGCS[\"GCS_Pulkovo_1995\",DATUM[\"D_Pulkovo_1995\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",10500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",30.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2644]]",
        2645=>"PROJCS[\"Pulkovo_1995_3_Degree_GK_Zone_11\",GEOGCS[\"GCS_Pulkovo_1995\",DATUM[\"D_Pulkovo_1995\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",11500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",33.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2645]]",
        2646=>"PROJCS[\"Pulkovo_1995_3_Degree_GK_Zone_12\",GEOGCS[\"GCS_Pulkovo_1995\",DATUM[\"D_Pulkovo_1995\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",12500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",36.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2646]]",
        2647=>"PROJCS[\"Pulkovo_1995_3_Degree_GK_Zone_13\",GEOGCS[\"GCS_Pulkovo_1995\",DATUM[\"D_Pulkovo_1995\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",13500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",39.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2647]]",
        2648=>"PROJCS[\"Pulkovo_1995_3_Degree_GK_Zone_14\",GEOGCS[\"GCS_Pulkovo_1995\",DATUM[\"D_Pulkovo_1995\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",14500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",42.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2648]]",
        2649=>"PROJCS[\"Pulkovo_1995_3_Degree_GK_Zone_15\",GEOGCS[\"GCS_Pulkovo_1995\",DATUM[\"D_Pulkovo_1995\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",15500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",45.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2649]]",
        2650=>"PROJCS[\"Pulkovo_1995_3_Degree_GK_Zone_16\",GEOGCS[\"GCS_Pulkovo_1995\",DATUM[\"D_Pulkovo_1995\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",16500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",48.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2650]]",
        2651=>"PROJCS[\"Pulkovo_1995_3_Degree_GK_Zone_17\",GEOGCS[\"GCS_Pulkovo_1995\",DATUM[\"D_Pulkovo_1995\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",17500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",51.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2651]]",
        2652=>"PROJCS[\"Pulkovo_1995_3_Degree_GK_Zone_18\",GEOGCS[\"GCS_Pulkovo_1995\",DATUM[\"D_Pulkovo_1995\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",18500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",54.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2652]]",
        2653=>"PROJCS[\"Pulkovo_1995_3_Degree_GK_Zone_19\",GEOGCS[\"GCS_Pulkovo_1995\",DATUM[\"D_Pulkovo_1995\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",19500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",57.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2653]]",
        2654=>"PROJCS[\"Pulkovo_1995_3_Degree_GK_Zone_20\",GEOGCS[\"GCS_Pulkovo_1995\",DATUM[\"D_Pulkovo_1995\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",20500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",60.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2654]]",
        2655=>"PROJCS[\"Pulkovo_1995_3_Degree_GK_Zone_21\",GEOGCS[\"GCS_Pulkovo_1995\",DATUM[\"D_Pulkovo_1995\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",21500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",63.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2655]]",
        2656=>"PROJCS[\"Pulkovo_1995_3_Degree_GK_Zone_22\",GEOGCS[\"GCS_Pulkovo_1995\",DATUM[\"D_Pulkovo_1995\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",22500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",66.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2656]]",
        2657=>"PROJCS[\"Pulkovo_1995_3_Degree_GK_Zone_23\",GEOGCS[\"GCS_Pulkovo_1995\",DATUM[\"D_Pulkovo_1995\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",23500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",69.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2657]]",
        2658=>"PROJCS[\"Pulkovo_1995_3_Degree_GK_Zone_24\",GEOGCS[\"GCS_Pulkovo_1995\",DATUM[\"D_Pulkovo_1995\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",24500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",72.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2658]]",
        2659=>"PROJCS[\"Pulkovo_1995_3_Degree_GK_Zone_25\",GEOGCS[\"GCS_Pulkovo_1995\",DATUM[\"D_Pulkovo_1995\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",25500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",75.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2659]]",
        2660=>"PROJCS[\"Pulkovo_1995_3_Degree_GK_Zone_26\",GEOGCS[\"GCS_Pulkovo_1995\",DATUM[\"D_Pulkovo_1995\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",26500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",78.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2660]]",
        2661=>"PROJCS[\"Pulkovo_1995_3_Degree_GK_Zone_27\",GEOGCS[\"GCS_Pulkovo_1995\",DATUM[\"D_Pulkovo_1995\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",27500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",81.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2661]]",
        2662=>"PROJCS[\"Pulkovo_1995_3_Degree_GK_Zone_28\",GEOGCS[\"GCS_Pulkovo_1995\",DATUM[\"D_Pulkovo_1995\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",28500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",84.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2662]]",
        2663=>"PROJCS[\"Pulkovo_1995_3_Degree_GK_Zone_29\",GEOGCS[\"GCS_Pulkovo_1995\",DATUM[\"D_Pulkovo_1995\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",29500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",87.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2663]]",
        2664=>"PROJCS[\"Pulkovo_1995_3_Degree_GK_Zone_30\",GEOGCS[\"GCS_Pulkovo_1995\",DATUM[\"D_Pulkovo_1995\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",30500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",90.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2664]]",
        2665=>"PROJCS[\"Pulkovo_1995_3_Degree_GK_Zone_31\",GEOGCS[\"GCS_Pulkovo_1995\",DATUM[\"D_Pulkovo_1995\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",31500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",93.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2665]]",
        2666=>"PROJCS[\"Pulkovo_1995_3_Degree_GK_Zone_32\",GEOGCS[\"GCS_Pulkovo_1995\",DATUM[\"D_Pulkovo_1995\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",32500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",96.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2666]]",
        2667=>"PROJCS[\"Pulkovo_1995_3_Degree_GK_Zone_33\",GEOGCS[\"GCS_Pulkovo_1995\",DATUM[\"D_Pulkovo_1995\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",33500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",99.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2667]]",
        2668=>"PROJCS[\"Pulkovo_1995_3_Degree_GK_Zone_34\",GEOGCS[\"GCS_Pulkovo_1995\",DATUM[\"D_Pulkovo_1995\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",34500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",102.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2668]]",
        2669=>"PROJCS[\"Pulkovo_1995_3_Degree_GK_Zone_35\",GEOGCS[\"GCS_Pulkovo_1995\",DATUM[\"D_Pulkovo_1995\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",35500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",105.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2669]]",
        2670=>"PROJCS[\"Pulkovo_1995_3_Degree_GK_Zone_36\",GEOGCS[\"GCS_Pulkovo_1995\",DATUM[\"D_Pulkovo_1995\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",36500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",108.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2670]]",
        2671=>"PROJCS[\"Pulkovo_1995_3_Degree_GK_Zone_37\",GEOGCS[\"GCS_Pulkovo_1995\",DATUM[\"D_Pulkovo_1995\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",37500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",111.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2671]]",
        2672=>"PROJCS[\"Pulkovo_1995_3_Degree_GK_Zone_38\",GEOGCS[\"GCS_Pulkovo_1995\",DATUM[\"D_Pulkovo_1995\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",38500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",114.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2672]]",
        2673=>"PROJCS[\"Pulkovo_1995_3_Degree_GK_Zone_39\",GEOGCS[\"GCS_Pulkovo_1995\",DATUM[\"D_Pulkovo_1995\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",39500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",117.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2673]]",
        2674=>"PROJCS[\"Pulkovo_1995_3_Degree_GK_Zone_40\",GEOGCS[\"GCS_Pulkovo_1995\",DATUM[\"D_Pulkovo_1995\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",40500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",120.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2674]]",
        2675=>"PROJCS[\"Pulkovo_1995_3_Degree_GK_Zone_41\",GEOGCS[\"GCS_Pulkovo_1995\",DATUM[\"D_Pulkovo_1995\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",41500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",123.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2675]]",
        2676=>"PROJCS[\"Pulkovo_1995_3_Degree_GK_Zone_42\",GEOGCS[\"GCS_Pulkovo_1995\",DATUM[\"D_Pulkovo_1995\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",42500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",126.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2676]]",
        2677=>"PROJCS[\"Pulkovo_1995_3_Degree_GK_Zone_43\",GEOGCS[\"GCS_Pulkovo_1995\",DATUM[\"D_Pulkovo_1995\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",43500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",129.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2677]]",
        2678=>"PROJCS[\"Pulkovo_1995_3_Degree_GK_Zone_44\",GEOGCS[\"GCS_Pulkovo_1995\",DATUM[\"D_Pulkovo_1995\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",44500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",132.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2678]]",
        2679=>"PROJCS[\"Pulkovo_1995_3_Degree_GK_Zone_45\",GEOGCS[\"GCS_Pulkovo_1995\",DATUM[\"D_Pulkovo_1995\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",45500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",135.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2679]]",
        2680=>"PROJCS[\"Pulkovo_1995_3_Degree_GK_Zone_46\",GEOGCS[\"GCS_Pulkovo_1995\",DATUM[\"D_Pulkovo_1995\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",46500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",138.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2680]]",
        2681=>"PROJCS[\"Pulkovo_1995_3_Degree_GK_Zone_47\",GEOGCS[\"GCS_Pulkovo_1995\",DATUM[\"D_Pulkovo_1995\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",47500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",141.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2681]]",
        2682=>"PROJCS[\"Pulkovo_1995_3_Degree_GK_Zone_48\",GEOGCS[\"GCS_Pulkovo_1995\",DATUM[\"D_Pulkovo_1995\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",48500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",144.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2682]]",
        2683=>"PROJCS[\"Pulkovo_1995_3_Degree_GK_Zone_49\",GEOGCS[\"GCS_Pulkovo_1995\",DATUM[\"D_Pulkovo_1995\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",49500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",147.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2683]]",
        2684=>"PROJCS[\"Pulkovo_1995_3_Degree_GK_Zone_50\",GEOGCS[\"GCS_Pulkovo_1995\",DATUM[\"D_Pulkovo_1995\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",50500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",150.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2684]]",
        2685=>"PROJCS[\"Pulkovo_1995_3_Degree_GK_Zone_51\",GEOGCS[\"GCS_Pulkovo_1995\",DATUM[\"D_Pulkovo_1995\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",51500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",153.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2685]]",
        2686=>"PROJCS[\"Pulkovo_1995_3_Degree_GK_Zone_52\",GEOGCS[\"GCS_Pulkovo_1995\",DATUM[\"D_Pulkovo_1995\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",52500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",156.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2686]]",
        2687=>"PROJCS[\"Pulkovo_1995_3_Degree_GK_Zone_53\",GEOGCS[\"GCS_Pulkovo_1995\",DATUM[\"D_Pulkovo_1995\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",53500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",159.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2687]]",
        2688=>"PROJCS[\"Pulkovo_1995_3_Degree_GK_Zone_54\",GEOGCS[\"GCS_Pulkovo_1995\",DATUM[\"D_Pulkovo_1995\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",54500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",162.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2688]]",
        2689=>"PROJCS[\"Pulkovo_1995_3_Degree_GK_Zone_55\",GEOGCS[\"GCS_Pulkovo_1995\",DATUM[\"D_Pulkovo_1995\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",55500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",165.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2689]]",
        2690=>"PROJCS[\"Pulkovo_1995_3_Degree_GK_Zone_56\",GEOGCS[\"GCS_Pulkovo_1995\",DATUM[\"D_Pulkovo_1995\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",56500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",168.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2690]]",
        2691=>"PROJCS[\"Pulkovo_1995_3_Degree_GK_Zone_57\",GEOGCS[\"GCS_Pulkovo_1995\",DATUM[\"D_Pulkovo_1995\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",57500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",171.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2691]]",
        2692=>"PROJCS[\"Pulkovo_1995_3_Degree_GK_Zone_58\",GEOGCS[\"GCS_Pulkovo_1995\",DATUM[\"D_Pulkovo_1995\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",58500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",174.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2692]]",
        2693=>"PROJCS[\"Pulkovo_1995_3_Degree_GK_Zone_59\",GEOGCS[\"GCS_Pulkovo_1995\",DATUM[\"D_Pulkovo_1995\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",59500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",177.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2693]]",
        2694=>"PROJCS[\"Pulkovo_1995_3_Degree_GK_Zone_60\",GEOGCS[\"GCS_Pulkovo_1995\",DATUM[\"D_Pulkovo_1995\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",60500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",180.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3390]]",
        2695=>"PROJCS[\"Pulkovo_1995_3_Degree_GK_Zone_61\",GEOGCS[\"GCS_Pulkovo_1995\",DATUM[\"D_Pulkovo_1995\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",61500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-177.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2695]]",
        2696=>"PROJCS[\"Pulkovo_1995_3_Degree_GK_Zone_62\",GEOGCS[\"GCS_Pulkovo_1995\",DATUM[\"D_Pulkovo_1995\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",62500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-174.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2696]]",
        2697=>"PROJCS[\"Pulkovo_1995_3_Degree_GK_Zone_63\",GEOGCS[\"GCS_Pulkovo_1995\",DATUM[\"D_Pulkovo_1995\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",63500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-171.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2697]]",
        2698=>"PROJCS[\"Pulkovo_1995_3_Degree_GK_Zone_64\",GEOGCS[\"GCS_Pulkovo_1995\",DATUM[\"D_Pulkovo_1995\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",64500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-168.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2698]]",
        2699=>"PROJCS[\"Pulkovo_1995_3_Degree_GK_CM_21E\",GEOGCS[\"GCS_Pulkovo_1995\",DATUM[\"D_Pulkovo_1995\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",21.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2699]]",
        2700=>"PROJCS[\"Pulkovo_1995_3_Degree_GK_CM_24E\",GEOGCS[\"GCS_Pulkovo_1995\",DATUM[\"D_Pulkovo_1995\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",24.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2700]]",
        2701=>"PROJCS[\"Pulkovo_1995_3_Degree_GK_CM_27E\",GEOGCS[\"GCS_Pulkovo_1995\",DATUM[\"D_Pulkovo_1995\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",27.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2701]]",
        2702=>"PROJCS[\"Pulkovo_1995_3_Degree_GK_CM_30E\",GEOGCS[\"GCS_Pulkovo_1995\",DATUM[\"D_Pulkovo_1995\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",30.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2702]]",
        2703=>"PROJCS[\"Pulkovo_1995_3_Degree_GK_CM_33E\",GEOGCS[\"GCS_Pulkovo_1995\",DATUM[\"D_Pulkovo_1995\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",33.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2703]]",
        2704=>"PROJCS[\"Pulkovo_1995_3_Degree_GK_CM_36E\",GEOGCS[\"GCS_Pulkovo_1995\",DATUM[\"D_Pulkovo_1995\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",36.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2704]]",
        2705=>"PROJCS[\"Pulkovo_1995_3_Degree_GK_CM_39E\",GEOGCS[\"GCS_Pulkovo_1995\",DATUM[\"D_Pulkovo_1995\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",39.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2705]]",
        2706=>"PROJCS[\"Pulkovo_1995_3_Degree_GK_CM_42E\",GEOGCS[\"GCS_Pulkovo_1995\",DATUM[\"D_Pulkovo_1995\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",42.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2706]]",
        2707=>"PROJCS[\"Pulkovo_1995_3_Degree_GK_CM_45E\",GEOGCS[\"GCS_Pulkovo_1995\",DATUM[\"D_Pulkovo_1995\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",45.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2707]]",
        2708=>"PROJCS[\"Pulkovo_1995_3_Degree_GK_CM_48E\",GEOGCS[\"GCS_Pulkovo_1995\",DATUM[\"D_Pulkovo_1995\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",48.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2708]]",
        2709=>"PROJCS[\"Pulkovo_1995_3_Degree_GK_CM_51E\",GEOGCS[\"GCS_Pulkovo_1995\",DATUM[\"D_Pulkovo_1995\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",51.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2709]]",
        2710=>"PROJCS[\"Pulkovo_1995_3_Degree_GK_CM_54E\",GEOGCS[\"GCS_Pulkovo_1995\",DATUM[\"D_Pulkovo_1995\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",54.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2710]]",
        2711=>"PROJCS[\"Pulkovo_1995_3_Degree_GK_CM_57E\",GEOGCS[\"GCS_Pulkovo_1995\",DATUM[\"D_Pulkovo_1995\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",57.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2711]]",
        2712=>"PROJCS[\"Pulkovo_1995_3_Degree_GK_CM_60E\",GEOGCS[\"GCS_Pulkovo_1995\",DATUM[\"D_Pulkovo_1995\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",60.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2712]]",
        2713=>"PROJCS[\"Pulkovo_1995_3_Degree_GK_CM_63E\",GEOGCS[\"GCS_Pulkovo_1995\",DATUM[\"D_Pulkovo_1995\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",63.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2713]]",
        2714=>"PROJCS[\"Pulkovo_1995_3_Degree_GK_CM_66E\",GEOGCS[\"GCS_Pulkovo_1995\",DATUM[\"D_Pulkovo_1995\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",66.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2714]]",
        2715=>"PROJCS[\"Pulkovo_1995_3_Degree_GK_CM_69E\",GEOGCS[\"GCS_Pulkovo_1995\",DATUM[\"D_Pulkovo_1995\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",69.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2715]]",
        2716=>"PROJCS[\"Pulkovo_1995_3_Degree_GK_CM_72E\",GEOGCS[\"GCS_Pulkovo_1995\",DATUM[\"D_Pulkovo_1995\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",72.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2716]]",
        2717=>"PROJCS[\"Pulkovo_1995_3_Degree_GK_CM_75E\",GEOGCS[\"GCS_Pulkovo_1995\",DATUM[\"D_Pulkovo_1995\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",75.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2717]]",
        2718=>"PROJCS[\"Pulkovo_1995_3_Degree_GK_CM_78E\",GEOGCS[\"GCS_Pulkovo_1995\",DATUM[\"D_Pulkovo_1995\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",78.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2718]]",
        2719=>"PROJCS[\"Pulkovo_1995_3_Degree_GK_CM_81E\",GEOGCS[\"GCS_Pulkovo_1995\",DATUM[\"D_Pulkovo_1995\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",81.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2719]]",
        2720=>"PROJCS[\"Pulkovo_1995_3_Degree_GK_CM_84E\",GEOGCS[\"GCS_Pulkovo_1995\",DATUM[\"D_Pulkovo_1995\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",84.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2720]]",
        2721=>"PROJCS[\"Pulkovo_1995_3_Degree_GK_CM_87E\",GEOGCS[\"GCS_Pulkovo_1995\",DATUM[\"D_Pulkovo_1995\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",87.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2721]]",
        2722=>"PROJCS[\"Pulkovo_1995_3_Degree_GK_CM_90E\",GEOGCS[\"GCS_Pulkovo_1995\",DATUM[\"D_Pulkovo_1995\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",90.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2722]]",
        2723=>"PROJCS[\"Pulkovo_1995_3_Degree_GK_CM_93E\",GEOGCS[\"GCS_Pulkovo_1995\",DATUM[\"D_Pulkovo_1995\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",93.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2723]]",
        2724=>"PROJCS[\"Pulkovo_1995_3_Degree_GK_CM_96E\",GEOGCS[\"GCS_Pulkovo_1995\",DATUM[\"D_Pulkovo_1995\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",96.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2724]]",
        2725=>"PROJCS[\"Pulkovo_1995_3_Degree_GK_CM_99E\",GEOGCS[\"GCS_Pulkovo_1995\",DATUM[\"D_Pulkovo_1995\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",99.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2725]]",
        2726=>"PROJCS[\"Pulkovo_1995_3_Degree_GK_CM_102E\",GEOGCS[\"GCS_Pulkovo_1995\",DATUM[\"D_Pulkovo_1995\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",102.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2726]]",
        2727=>"PROJCS[\"Pulkovo_1995_3_Degree_GK_CM_105E\",GEOGCS[\"GCS_Pulkovo_1995\",DATUM[\"D_Pulkovo_1995\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",105.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2727]]",
        2728=>"PROJCS[\"Pulkovo_1995_3_Degree_GK_CM_108E\",GEOGCS[\"GCS_Pulkovo_1995\",DATUM[\"D_Pulkovo_1995\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",108.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2728]]",
        2729=>"PROJCS[\"Pulkovo_1995_3_Degree_GK_CM_111E\",GEOGCS[\"GCS_Pulkovo_1995\",DATUM[\"D_Pulkovo_1995\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",111.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2729]]",
        2730=>"PROJCS[\"Pulkovo_1995_3_Degree_GK_CM_114E\",GEOGCS[\"GCS_Pulkovo_1995\",DATUM[\"D_Pulkovo_1995\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",114.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2730]]",
        2731=>"PROJCS[\"Pulkovo_1995_3_Degree_GK_CM_117E\",GEOGCS[\"GCS_Pulkovo_1995\",DATUM[\"D_Pulkovo_1995\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",117.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2731]]",
        2732=>"PROJCS[\"Pulkovo_1995_3_Degree_GK_CM_120E\",GEOGCS[\"GCS_Pulkovo_1995\",DATUM[\"D_Pulkovo_1995\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",120.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2732]]",
        2733=>"PROJCS[\"Pulkovo_1995_3_Degree_GK_CM_123E\",GEOGCS[\"GCS_Pulkovo_1995\",DATUM[\"D_Pulkovo_1995\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",123.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2733]]",
        2734=>"PROJCS[\"Pulkovo_1995_3_Degree_GK_CM_126E\",GEOGCS[\"GCS_Pulkovo_1995\",DATUM[\"D_Pulkovo_1995\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",126.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2734]]",
        2735=>"PROJCS[\"Pulkovo_1995_3_Degree_GK_CM_129E\",GEOGCS[\"GCS_Pulkovo_1995\",DATUM[\"D_Pulkovo_1995\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",129.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2735]]",
        2736=>"PROJCS[\"Tete_UTM_Zone_36S\",GEOGCS[\"GCS_Tete\",DATUM[\"D_Tete\",SPHEROID[\"Clarke_1866\",6378206.4,294.9786982]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",10000000.0],PARAMETER[\"Central_Meridian\",33.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2736]]",
        2737=>"PROJCS[\"Tete_UTM_Zone_37S\",GEOGCS[\"GCS_Tete\",DATUM[\"D_Tete\",SPHEROID[\"Clarke_1866\",6378206.4,294.9786982]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",10000000.0],PARAMETER[\"Central_Meridian\",39.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2737]]",
        2738=>"PROJCS[\"Pulkovo_1995_3_Degree_GK_CM_132E\",GEOGCS[\"GCS_Pulkovo_1995\",DATUM[\"D_Pulkovo_1995\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",132.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2738]]",
        2739=>"PROJCS[\"Pulkovo_1995_3_Degree_GK_CM_135E\",GEOGCS[\"GCS_Pulkovo_1995\",DATUM[\"D_Pulkovo_1995\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",135.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2739]]",
        2740=>"PROJCS[\"Pulkovo_1995_3_Degree_GK_CM_138E\",GEOGCS[\"GCS_Pulkovo_1995\",DATUM[\"D_Pulkovo_1995\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",138.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2740]]",
        2741=>"PROJCS[\"Pulkovo_1995_3_Degree_GK_CM_141E\",GEOGCS[\"GCS_Pulkovo_1995\",DATUM[\"D_Pulkovo_1995\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",141.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2741]]",
        2742=>"PROJCS[\"Pulkovo_1995_3_Degree_GK_CM_144E\",GEOGCS[\"GCS_Pulkovo_1995\",DATUM[\"D_Pulkovo_1995\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",144.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2742]]",
        2743=>"PROJCS[\"Pulkovo_1995_3_Degree_GK_CM_147E\",GEOGCS[\"GCS_Pulkovo_1995\",DATUM[\"D_Pulkovo_1995\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",147.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2743]]",
        2744=>"PROJCS[\"Pulkovo_1995_3_Degree_GK_CM_150E\",GEOGCS[\"GCS_Pulkovo_1995\",DATUM[\"D_Pulkovo_1995\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",150.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2744]]",
        2745=>"PROJCS[\"Pulkovo_1995_3_Degree_GK_CM_153E\",GEOGCS[\"GCS_Pulkovo_1995\",DATUM[\"D_Pulkovo_1995\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",153.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2745]]",
        2746=>"PROJCS[\"Pulkovo_1995_3_Degree_GK_CM_156E\",GEOGCS[\"GCS_Pulkovo_1995\",DATUM[\"D_Pulkovo_1995\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",156.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2746]]",
        2747=>"PROJCS[\"Pulkovo_1995_3_Degree_GK_CM_159E\",GEOGCS[\"GCS_Pulkovo_1995\",DATUM[\"D_Pulkovo_1995\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",159.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2747]]",
        2748=>"PROJCS[\"Pulkovo_1995_3_Degree_GK_CM_162E\",GEOGCS[\"GCS_Pulkovo_1995\",DATUM[\"D_Pulkovo_1995\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",162.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2748]]",
        2749=>"PROJCS[\"Pulkovo_1995_3_Degree_GK_CM_165E\",GEOGCS[\"GCS_Pulkovo_1995\",DATUM[\"D_Pulkovo_1995\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",165.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2749]]",
        2750=>"PROJCS[\"Pulkovo_1995_3_Degree_GK_CM_168E\",GEOGCS[\"GCS_Pulkovo_1995\",DATUM[\"D_Pulkovo_1995\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",168.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2750]]",
        2751=>"PROJCS[\"Pulkovo_1995_3_Degree_GK_CM_171E\",GEOGCS[\"GCS_Pulkovo_1995\",DATUM[\"D_Pulkovo_1995\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",171.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2751]]",
        2752=>"PROJCS[\"Pulkovo_1995_3_Degree_GK_CM_174E\",GEOGCS[\"GCS_Pulkovo_1995\",DATUM[\"D_Pulkovo_1995\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",174.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2752]]",
        2753=>"PROJCS[\"Pulkovo_1995_3_Degree_GK_CM_177E\",GEOGCS[\"GCS_Pulkovo_1995\",DATUM[\"D_Pulkovo_1995\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",177.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2753]]",
        2754=>"PROJCS[\"Pulkovo_1995_3_Degree_GK_CM_180E\",GEOGCS[\"GCS_Pulkovo_1995\",DATUM[\"D_Pulkovo_1995\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",180.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2754]]",
        2755=>"PROJCS[\"Pulkovo_1995_3_Degree_GK_CM_177W\",GEOGCS[\"GCS_Pulkovo_1995\",DATUM[\"D_Pulkovo_1995\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-177.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2755]]",
        2756=>"PROJCS[\"Pulkovo_1995_3_Degree_GK_CM_174W\",GEOGCS[\"GCS_Pulkovo_1995\",DATUM[\"D_Pulkovo_1995\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-174.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2756]]",
        2757=>"PROJCS[\"Pulkovo_1995_3_Degree_GK_CM_171W\",GEOGCS[\"GCS_Pulkovo_1995\",DATUM[\"D_Pulkovo_1995\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-171.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2757]]",
        2758=>"PROJCS[\"Pulkovo_1995_3_Degree_GK_CM_168W\",GEOGCS[\"GCS_Pulkovo_1995\",DATUM[\"D_Pulkovo_1995\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-168.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2758]]",
        2759=>"PROJCS[\"NAD_1983_HARN_StatePlane_Alabama_East_FIPS_0101\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",200000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-85.83333333333333],PARAMETER[\"Scale_Factor\",0.99996],PARAMETER[\"Latitude_Of_Origin\",30.5],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2759]]",
        2760=>"PROJCS[\"NAD_1983_HARN_StatePlane_Alabama_West_FIPS_0102\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",600000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-87.5],PARAMETER[\"Scale_Factor\",0.9999333333333333],PARAMETER[\"Latitude_Of_Origin\",30.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2760]]",
        2761=>"PROJCS[\"NAD_1983_HARN_StatePlane_Arizona_East_FIPS_0201\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",213360.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-110.1666666666667],PARAMETER[\"Scale_Factor\",0.9999],PARAMETER[\"Latitude_Of_Origin\",31.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2761]]",
        2762=>"PROJCS[\"NAD_1983_HARN_StatePlane_Arizona_Central_FIPS_0202\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",213360.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-111.9166666666667],PARAMETER[\"Scale_Factor\",0.9999],PARAMETER[\"Latitude_Of_Origin\",31.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2762]]",
        2763=>"PROJCS[\"NAD_1983_HARN_StatePlane_Arizona_West_FIPS_0203\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",213360.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-113.75],PARAMETER[\"Scale_Factor\",0.9999333333333333],PARAMETER[\"Latitude_Of_Origin\",31.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2763]]",
        2764=>"PROJCS[\"NAD_1983_HARN_StatePlane_Arkansas_North_FIPS_0301\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",400000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-92.0],PARAMETER[\"Standard_Parallel_1\",34.93333333333333],PARAMETER[\"Standard_Parallel_2\",36.23333333333333],PARAMETER[\"Latitude_Of_Origin\",34.33333333333334],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2764]]",
        2765=>"PROJCS[\"NAD_1983_HARN_StatePlane_Arkansas_South_FIPS_0302\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",400000.0],PARAMETER[\"False_Northing\",400000.0],PARAMETER[\"Central_Meridian\",-92.0],PARAMETER[\"Standard_Parallel_1\",33.3],PARAMETER[\"Standard_Parallel_2\",34.76666666666667],PARAMETER[\"Latitude_Of_Origin\",32.66666666666666],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2765]]",
        2766=>"PROJCS[\"NAD_1983_HARN_StatePlane_California_I_FIPS_0401\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",2000000.0],PARAMETER[\"False_Northing\",500000.0],PARAMETER[\"Central_Meridian\",-122.0],PARAMETER[\"Standard_Parallel_1\",40.0],PARAMETER[\"Standard_Parallel_2\",41.66666666666666],PARAMETER[\"Latitude_Of_Origin\",39.33333333333334],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2766]]",
        2767=>"PROJCS[\"NAD_1983_HARN_StatePlane_California_II_FIPS_0402\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",2000000.0],PARAMETER[\"False_Northing\",500000.0],PARAMETER[\"Central_Meridian\",-122.0],PARAMETER[\"Standard_Parallel_1\",38.33333333333334],PARAMETER[\"Standard_Parallel_2\",39.83333333333334],PARAMETER[\"Latitude_Of_Origin\",37.66666666666666],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2767]]",
        2768=>"PROJCS[\"NAD_1983_HARN_StatePlane_California_III_FIPS_0403\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",2000000.0],PARAMETER[\"False_Northing\",500000.0],PARAMETER[\"Central_Meridian\",-120.5],PARAMETER[\"Standard_Parallel_1\",37.06666666666667],PARAMETER[\"Standard_Parallel_2\",38.43333333333333],PARAMETER[\"Latitude_Of_Origin\",36.5],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2768]]",
        2769=>"PROJCS[\"NAD_1983_HARN_StatePlane_California_IV_FIPS_0404\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",2000000.0],PARAMETER[\"False_Northing\",500000.0],PARAMETER[\"Central_Meridian\",-119.0],PARAMETER[\"Standard_Parallel_1\",36.0],PARAMETER[\"Standard_Parallel_2\",37.25],PARAMETER[\"Latitude_Of_Origin\",35.33333333333334],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2769]]",
        2770=>"PROJCS[\"NAD_1983_HARN_StatePlane_California_V_FIPS_0405\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",2000000.0],PARAMETER[\"False_Northing\",500000.0],PARAMETER[\"Central_Meridian\",-118.0],PARAMETER[\"Standard_Parallel_1\",34.03333333333333],PARAMETER[\"Standard_Parallel_2\",35.46666666666667],PARAMETER[\"Latitude_Of_Origin\",33.5],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2770]]",
        2771=>"PROJCS[\"NAD_1983_HARN_StatePlane_California_VI_FIPS_0406\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",2000000.0],PARAMETER[\"False_Northing\",500000.0],PARAMETER[\"Central_Meridian\",-116.25],PARAMETER[\"Standard_Parallel_1\",32.78333333333333],PARAMETER[\"Standard_Parallel_2\",33.88333333333333],PARAMETER[\"Latitude_Of_Origin\",32.16666666666666],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2771]]",
        2772=>"PROJCS[\"NAD_1983_HARN_StatePlane_Colorado_North_FIPS_0501\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",914401.8289],PARAMETER[\"False_Northing\",304800.6096],PARAMETER[\"Central_Meridian\",-105.5],PARAMETER[\"Standard_Parallel_1\",39.71666666666667],PARAMETER[\"Standard_Parallel_2\",40.78333333333333],PARAMETER[\"Latitude_Of_Origin\",39.33333333333334],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2772]]",
        2773=>"PROJCS[\"NAD_1983_HARN_StatePlane_Colorado_Central_FIPS_0502\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",914401.8289],PARAMETER[\"False_Northing\",304800.6096],PARAMETER[\"Central_Meridian\",-105.5],PARAMETER[\"Standard_Parallel_1\",38.45],PARAMETER[\"Standard_Parallel_2\",39.75],PARAMETER[\"Latitude_Of_Origin\",37.83333333333334],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2773]]",
        2774=>"PROJCS[\"NAD_1983_HARN_StatePlane_Colorado_South_FIPS_0503\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",914401.8289],PARAMETER[\"False_Northing\",304800.6096],PARAMETER[\"Central_Meridian\",-105.5],PARAMETER[\"Standard_Parallel_1\",37.23333333333333],PARAMETER[\"Standard_Parallel_2\",38.43333333333333],PARAMETER[\"Latitude_Of_Origin\",36.66666666666666],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2774]]",
        2775=>"PROJCS[\"NAD_1983_HARN_StatePlane_Connecticut_FIPS_0600\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",304800.6096],PARAMETER[\"False_Northing\",152400.3048],PARAMETER[\"Central_Meridian\",-72.75],PARAMETER[\"Standard_Parallel_1\",41.2],PARAMETER[\"Standard_Parallel_2\",41.86666666666667],PARAMETER[\"Latitude_Of_Origin\",40.83333333333334],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2775]]",
        2776=>"PROJCS[\"NAD_1983_HARN_StatePlane_Delaware_FIPS_0700\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",200000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-75.41666666666667],PARAMETER[\"Scale_Factor\",0.999995],PARAMETER[\"Latitude_Of_Origin\",38.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2776]]",
        2777=>"PROJCS[\"NAD_1983_HARN_StatePlane_Florida_East_FIPS_0901\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",200000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-81.0],PARAMETER[\"Scale_Factor\",0.9999411764705882],PARAMETER[\"Latitude_Of_Origin\",24.33333333333333],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2777]]",
        2778=>"PROJCS[\"NAD_1983_HARN_StatePlane_Florida_West_FIPS_0902\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",200000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-82.0],PARAMETER[\"Scale_Factor\",0.9999411764705882],PARAMETER[\"Latitude_Of_Origin\",24.33333333333333],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2778]]",
        2779=>"PROJCS[\"NAD_1983_HARN_StatePlane_Florida_North_FIPS_0903\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",600000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-84.5],PARAMETER[\"Standard_Parallel_1\",29.58333333333333],PARAMETER[\"Standard_Parallel_2\",30.75],PARAMETER[\"Latitude_Of_Origin\",29.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2779]]",
        2780=>"PROJCS[\"NAD_1983_HARN_StatePlane_Georgia_East_FIPS_1001\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",200000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-82.16666666666667],PARAMETER[\"Scale_Factor\",0.9999],PARAMETER[\"Latitude_Of_Origin\",30.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2780]]",
        2781=>"PROJCS[\"NAD_1983_HARN_StatePlane_Georgia_West_FIPS_1002\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",700000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-84.16666666666667],PARAMETER[\"Scale_Factor\",0.9999],PARAMETER[\"Latitude_Of_Origin\",30.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2781]]",
        2782=>"PROJCS[\"NAD_1983_HARN_StatePlane_Hawaii_1_FIPS_5101\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-155.5],PARAMETER[\"Scale_Factor\",0.9999666666666667],PARAMETER[\"Latitude_Of_Origin\",18.83333333333333],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2782]]",
        2783=>"PROJCS[\"NAD_1983_HARN_StatePlane_Hawaii_2_FIPS_5102\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-156.6666666666667],PARAMETER[\"Scale_Factor\",0.9999666666666667],PARAMETER[\"Latitude_Of_Origin\",20.33333333333333],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2783]]",
        2784=>"PROJCS[\"NAD_1983_HARN_StatePlane_Hawaii_3_FIPS_5103\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-158.0],PARAMETER[\"Scale_Factor\",0.99999],PARAMETER[\"Latitude_Of_Origin\",21.16666666666667],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2784]]",
        2785=>"PROJCS[\"NAD_1983_HARN_StatePlane_Hawaii_4_FIPS_5104\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-159.5],PARAMETER[\"Scale_Factor\",0.99999],PARAMETER[\"Latitude_Of_Origin\",21.83333333333333],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2785]]",
        2786=>"PROJCS[\"NAD_1983_HARN_StatePlane_Hawaii_5_FIPS_5105\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-160.1666666666667],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",21.66666666666667],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2786]]",
        2787=>"PROJCS[\"NAD_1983_HARN_StatePlane_Idaho_East_FIPS_1101\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",200000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-112.1666666666667],PARAMETER[\"Scale_Factor\",0.9999473684210526],PARAMETER[\"Latitude_Of_Origin\",41.66666666666666],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2787]]",
        2788=>"PROJCS[\"NAD_1983_HARN_StatePlane_Idaho_Central_FIPS_1102\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-114.0],PARAMETER[\"Scale_Factor\",0.9999473684210526],PARAMETER[\"Latitude_Of_Origin\",41.66666666666666],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2788]]",
        2789=>"PROJCS[\"NAD_1983_HARN_StatePlane_Idaho_West_FIPS_1103\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",800000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-115.75],PARAMETER[\"Scale_Factor\",0.9999333333333333],PARAMETER[\"Latitude_Of_Origin\",41.66666666666666],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2789]]",
        2790=>"PROJCS[\"NAD_1983_HARN_StatePlane_Illinois_East_FIPS_1201\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",300000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-88.33333333333333],PARAMETER[\"Scale_Factor\",0.999975],PARAMETER[\"Latitude_Of_Origin\",36.66666666666666],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2790]]",
        2791=>"PROJCS[\"NAD_1983_HARN_StatePlane_Illinois_West_FIPS_1202\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",700000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-90.16666666666667],PARAMETER[\"Scale_Factor\",0.9999411764705882],PARAMETER[\"Latitude_Of_Origin\",36.66666666666666],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2791]]",
        2792=>"PROJCS[\"NAD_1983_HARN_StatePlane_Indiana_East_FIPS_1301\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",100000.0],PARAMETER[\"False_Northing\",250000.0],PARAMETER[\"Central_Meridian\",-85.66666666666667],PARAMETER[\"Scale_Factor\",0.9999666666666667],PARAMETER[\"Latitude_Of_Origin\",37.5],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2792]]",
        2793=>"PROJCS[\"NAD_1983_HARN_StatePlane_Indiana_West_FIPS_1302\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",900000.0],PARAMETER[\"False_Northing\",250000.0],PARAMETER[\"Central_Meridian\",-87.08333333333333],PARAMETER[\"Scale_Factor\",0.9999666666666667],PARAMETER[\"Latitude_Of_Origin\",37.5],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2793]]",
        2794=>"PROJCS[\"NAD_1983_HARN_StatePlane_Iowa_North_FIPS_1401\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",1500000.0],PARAMETER[\"False_Northing\",1000000.0],PARAMETER[\"Central_Meridian\",-93.5],PARAMETER[\"Standard_Parallel_1\",42.06666666666667],PARAMETER[\"Standard_Parallel_2\",43.26666666666667],PARAMETER[\"Latitude_Of_Origin\",41.5],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2794]]",
        2795=>"PROJCS[\"NAD_1983_HARN_StatePlane_Iowa_South_FIPS_1402\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-93.5],PARAMETER[\"Standard_Parallel_1\",40.61666666666667],PARAMETER[\"Standard_Parallel_2\",41.78333333333333],PARAMETER[\"Latitude_Of_Origin\",40.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2795]]",
        2796=>"PROJCS[\"NAD_1983_HARN_StatePlane_Kansas_North_FIPS_1501\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",400000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-98.0],PARAMETER[\"Standard_Parallel_1\",38.71666666666667],PARAMETER[\"Standard_Parallel_2\",39.78333333333333],PARAMETER[\"Latitude_Of_Origin\",38.33333333333334],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2796]]",
        2797=>"PROJCS[\"NAD_1983_HARN_StatePlane_Kansas_South_FIPS_1502\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",400000.0],PARAMETER[\"False_Northing\",400000.0],PARAMETER[\"Central_Meridian\",-98.5],PARAMETER[\"Standard_Parallel_1\",37.26666666666667],PARAMETER[\"Standard_Parallel_2\",38.56666666666667],PARAMETER[\"Latitude_Of_Origin\",36.66666666666666],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2797]]",
        2798=>"PROJCS[\"NAD_1983_HARN_StatePlane_Kentucky_North_FIPS_1601\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-84.25],PARAMETER[\"Standard_Parallel_1\",37.96666666666667],PARAMETER[\"Standard_Parallel_2\",38.96666666666667],PARAMETER[\"Latitude_Of_Origin\",37.5],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2798]]",
        2799=>"PROJCS[\"NAD_1983_HARN_StatePlane_Kentucky_South_FIPS_1602\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",500000.0],PARAMETER[\"Central_Meridian\",-85.75],PARAMETER[\"Standard_Parallel_1\",36.73333333333333],PARAMETER[\"Standard_Parallel_2\",37.93333333333333],PARAMETER[\"Latitude_Of_Origin\",36.33333333333334],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2799]]",
        2800=>"PROJCS[\"NAD_1983_HARN_StatePlane_Louisiana_North_FIPS_1701\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",1000000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-92.5],PARAMETER[\"Standard_Parallel_1\",31.16666666666667],PARAMETER[\"Standard_Parallel_2\",32.66666666666666],PARAMETER[\"Latitude_Of_Origin\",30.5],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2800]]",
        2801=>"PROJCS[\"NAD_1983_HARN_StatePlane_Louisiana_South_FIPS_1702\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",1000000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-91.33333333333333],PARAMETER[\"Standard_Parallel_1\",29.3],PARAMETER[\"Standard_Parallel_2\",30.7],PARAMETER[\"Latitude_Of_Origin\",28.5],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2801]]",
        2802=>"PROJCS[\"NAD_1983_HARN_StatePlane_Maine_East_FIPS_1801\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",300000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-68.5],PARAMETER[\"Scale_Factor\",0.9999],PARAMETER[\"Latitude_Of_Origin\",43.66666666666666],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2802]]",
        2803=>"PROJCS[\"NAD_1983_HARN_StatePlane_Maine_West_FIPS_1802\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",900000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-70.16666666666667],PARAMETER[\"Scale_Factor\",0.9999666666666667],PARAMETER[\"Latitude_Of_Origin\",42.83333333333334],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2803]]",
        2804=>"PROJCS[\"NAD_1983_HARN_StatePlane_Maryland_FIPS_1900\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",400000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-77.0],PARAMETER[\"Standard_Parallel_1\",38.3],PARAMETER[\"Standard_Parallel_2\",39.45],PARAMETER[\"Latitude_Of_Origin\",37.66666666666666],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2804]]",
        2805=>"PROJCS[\"NAD_1983_HARN_StatePlane_Massachusetts_Mainland_FIPS_2001\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",200000.0],PARAMETER[\"False_Northing\",750000.0],PARAMETER[\"Central_Meridian\",-71.5],PARAMETER[\"Standard_Parallel_1\",41.71666666666667],PARAMETER[\"Standard_Parallel_2\",42.68333333333333],PARAMETER[\"Latitude_Of_Origin\",41.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2805]]",
        2806=>"PROJCS[\"NAD_1983_HARN_StatePlane_Massachusetts_Island_FIPS_2002\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-70.5],PARAMETER[\"Standard_Parallel_1\",41.28333333333333],PARAMETER[\"Standard_Parallel_2\",41.48333333333333],PARAMETER[\"Latitude_Of_Origin\",41.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2806]]",
        2807=>"PROJCS[\"NAD_1983_HARN_StatePlane_Michigan_North_FIPS_2111\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",8000000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-87.0],PARAMETER[\"Standard_Parallel_1\",45.48333333333333],PARAMETER[\"Standard_Parallel_2\",47.08333333333334],PARAMETER[\"Latitude_Of_Origin\",44.78333333333333],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2807]]",
        2808=>"PROJCS[\"NAD_1983_HARN_StatePlane_Michigan_Central_FIPS_2112\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",6000000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-84.36666666666666],PARAMETER[\"Standard_Parallel_1\",44.18333333333333],PARAMETER[\"Standard_Parallel_2\",45.7],PARAMETER[\"Latitude_Of_Origin\",43.31666666666667],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2808]]",
        2809=>"PROJCS[\"NAD_1983_HARN_StatePlane_Michigan_South_FIPS_2113\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",4000000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-84.36666666666666],PARAMETER[\"Standard_Parallel_1\",42.1],PARAMETER[\"Standard_Parallel_2\",43.66666666666666],PARAMETER[\"Latitude_Of_Origin\",41.5],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2809]]",
        2810=>"PROJCS[\"NAD_1983_HARN_StatePlane_Minnesota_North_FIPS_2201\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",800000.0],PARAMETER[\"False_Northing\",100000.0],PARAMETER[\"Central_Meridian\",-93.1],PARAMETER[\"Standard_Parallel_1\",47.03333333333333],PARAMETER[\"Standard_Parallel_2\",48.63333333333333],PARAMETER[\"Latitude_Of_Origin\",46.5],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2810]]",
        2811=>"PROJCS[\"NAD_1983_HARN_StatePlane_Minnesota_Central_FIPS_2202\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",800000.0],PARAMETER[\"False_Northing\",100000.0],PARAMETER[\"Central_Meridian\",-94.25],PARAMETER[\"Standard_Parallel_1\",45.61666666666667],PARAMETER[\"Standard_Parallel_2\",47.05],PARAMETER[\"Latitude_Of_Origin\",45.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2811]]",
        2812=>"PROJCS[\"NAD_1983_HARN_StatePlane_Minnesota_South_FIPS_2203\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",800000.0],PARAMETER[\"False_Northing\",100000.0],PARAMETER[\"Central_Meridian\",-94.0],PARAMETER[\"Standard_Parallel_1\",43.78333333333333],PARAMETER[\"Standard_Parallel_2\",45.21666666666667],PARAMETER[\"Latitude_Of_Origin\",43.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2812]]",
        2813=>"PROJCS[\"NAD_1983_HARN_StatePlane_Mississippi_East_FIPS_2301\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",300000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-88.83333333333333],PARAMETER[\"Scale_Factor\",0.99995],PARAMETER[\"Latitude_Of_Origin\",29.5],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2813]]",
        2814=>"PROJCS[\"NAD_1983_HARN_StatePlane_Mississippi_West_FIPS_2302\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",700000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-90.33333333333333],PARAMETER[\"Scale_Factor\",0.99995],PARAMETER[\"Latitude_Of_Origin\",29.5],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2814]]",
        2815=>"PROJCS[\"NAD_1983_HARN_StatePlane_Missouri_East_FIPS_2401\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",250000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-90.5],PARAMETER[\"Scale_Factor\",0.9999333333333333],PARAMETER[\"Latitude_Of_Origin\",35.83333333333334],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2815]]",
        2816=>"PROJCS[\"NAD_1983_HARN_StatePlane_Missouri_Central_FIPS_2402\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-92.5],PARAMETER[\"Scale_Factor\",0.9999333333333333],PARAMETER[\"Latitude_Of_Origin\",35.83333333333334],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2816]]",
        2817=>"PROJCS[\"NAD_1983_HARN_StatePlane_Missouri_West_FIPS_2403\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",850000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-94.5],PARAMETER[\"Scale_Factor\",0.9999411764705882],PARAMETER[\"Latitude_Of_Origin\",36.16666666666666],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2817]]",
        2818=>"PROJCS[\"NAD_1983_HARN_StatePlane_Montana_FIPS_2500\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",600000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-109.5],PARAMETER[\"Standard_Parallel_1\",45.0],PARAMETER[\"Standard_Parallel_2\",49.0],PARAMETER[\"Latitude_Of_Origin\",44.25],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2818]]",
        2819=>"PROJCS[\"NAD_1983_HARN_StatePlane_Nebraska_FIPS_2600\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-100.0],PARAMETER[\"Standard_Parallel_1\",40.0],PARAMETER[\"Standard_Parallel_2\",43.0],PARAMETER[\"Latitude_Of_Origin\",39.83333333333334],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2819]]",
        2820=>"PROJCS[\"NAD_1983_HARN_StatePlane_Nevada_East_FIPS_2701\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",200000.0],PARAMETER[\"False_Northing\",8000000.0],PARAMETER[\"Central_Meridian\",-115.5833333333333],PARAMETER[\"Scale_Factor\",0.9999],PARAMETER[\"Latitude_Of_Origin\",34.75],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2820]]",
        2821=>"PROJCS[\"NAD_1983_HARN_StatePlane_Nevada_Central_FIPS_2702\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",6000000.0],PARAMETER[\"Central_Meridian\",-116.6666666666667],PARAMETER[\"Scale_Factor\",0.9999],PARAMETER[\"Latitude_Of_Origin\",34.75],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2821]]",
        2822=>"PROJCS[\"NAD_1983_HARN_StatePlane_Nevada_West_FIPS_2703\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",800000.0],PARAMETER[\"False_Northing\",4000000.0],PARAMETER[\"Central_Meridian\",-118.5833333333333],PARAMETER[\"Scale_Factor\",0.9999],PARAMETER[\"Latitude_Of_Origin\",34.75],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2822]]",
        2823=>"PROJCS[\"NAD_1983_HARN_StatePlane_New_Hampshire_FIPS_2800\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",300000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-71.66666666666667],PARAMETER[\"Scale_Factor\",0.9999666666666667],PARAMETER[\"Latitude_Of_Origin\",42.5],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2823]]",
        2824=>"PROJCS[\"NAD_1983_HARN_StatePlane_New_Jersey_FIPS_2900\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",150000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-74.5],PARAMETER[\"Scale_Factor\",0.9999],PARAMETER[\"Latitude_Of_Origin\",38.83333333333334],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2824]]",
        2825=>"PROJCS[\"NAD_1983_HARN_StatePlane_New_Mexico_East_FIPS_3001\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",165000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-104.3333333333333],PARAMETER[\"Scale_Factor\",0.9999090909090909],PARAMETER[\"Latitude_Of_Origin\",31.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2825]]",
        2826=>"PROJCS[\"NAD_1983_HARN_StatePlane_New_Mexico_Central_FIPS_3002\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-106.25],PARAMETER[\"Scale_Factor\",0.9999],PARAMETER[\"Latitude_Of_Origin\",31.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2826]]",
        2827=>"PROJCS[\"NAD_1983_HARN_StatePlane_New_Mexico_West_FIPS_3003\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",830000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-107.8333333333333],PARAMETER[\"Scale_Factor\",0.9999166666666667],PARAMETER[\"Latitude_Of_Origin\",31.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2827]]",
        2828=>"PROJCS[\"NAD_1983_HARN_StatePlane_New_York_East_FIPS_3101\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",150000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-74.5],PARAMETER[\"Scale_Factor\",0.9999],PARAMETER[\"Latitude_Of_Origin\",38.83333333333334],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2828]]",
        2829=>"PROJCS[\"NAD_1983_HARN_StatePlane_New_York_Central_FIPS_3102\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",250000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-76.58333333333333],PARAMETER[\"Scale_Factor\",0.9999375],PARAMETER[\"Latitude_Of_Origin\",40.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2829]]",
        2830=>"PROJCS[\"NAD_1983_HARN_StatePlane_New_York_West_FIPS_3103\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",350000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-78.58333333333333],PARAMETER[\"Scale_Factor\",0.9999375],PARAMETER[\"Latitude_Of_Origin\",40.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2830]]",
        2831=>"PROJCS[\"NAD_1983_HARN_StatePlane_New_York_Long_Island_FIPS_3104\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",300000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-74.0],PARAMETER[\"Standard_Parallel_1\",40.66666666666666],PARAMETER[\"Standard_Parallel_2\",41.03333333333333],PARAMETER[\"Latitude_Of_Origin\",40.16666666666666],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2831]]",
        2832=>"PROJCS[\"NAD_1983_HARN_StatePlane_North_Dakota_North_FIPS_3301\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",600000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-100.5],PARAMETER[\"Standard_Parallel_1\",47.43333333333333],PARAMETER[\"Standard_Parallel_2\",48.73333333333333],PARAMETER[\"Latitude_Of_Origin\",47.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2832]]",
        2833=>"PROJCS[\"NAD_1983_HARN_StatePlane_North_Dakota_South_FIPS_3302\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",600000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-100.5],PARAMETER[\"Standard_Parallel_1\",46.18333333333333],PARAMETER[\"Standard_Parallel_2\",47.48333333333333],PARAMETER[\"Latitude_Of_Origin\",45.66666666666666],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2833]]",
        2834=>"PROJCS[\"NAD_1983_HARN_StatePlane_Ohio_North_FIPS_3401\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",600000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-82.5],PARAMETER[\"Standard_Parallel_1\",40.43333333333333],PARAMETER[\"Standard_Parallel_2\",41.7],PARAMETER[\"Latitude_Of_Origin\",39.66666666666666],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2834]]",
        2835=>"PROJCS[\"NAD_1983_HARN_StatePlane_Ohio_South_FIPS_3402\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",600000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-82.5],PARAMETER[\"Standard_Parallel_1\",38.73333333333333],PARAMETER[\"Standard_Parallel_2\",40.03333333333333],PARAMETER[\"Latitude_Of_Origin\",38.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2835]]",
        2836=>"PROJCS[\"NAD_1983_HARN_StatePlane_Oklahoma_North_FIPS_3501\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",600000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-98.0],PARAMETER[\"Standard_Parallel_1\",35.56666666666667],PARAMETER[\"Standard_Parallel_2\",36.76666666666667],PARAMETER[\"Latitude_Of_Origin\",35.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2836]]",
        2837=>"PROJCS[\"NAD_1983_HARN_StatePlane_Oklahoma_South_FIPS_3502\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",600000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-98.0],PARAMETER[\"Standard_Parallel_1\",33.93333333333333],PARAMETER[\"Standard_Parallel_2\",35.23333333333333],PARAMETER[\"Latitude_Of_Origin\",33.33333333333334],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2837]]",
        2838=>"PROJCS[\"NAD_1983_HARN_StatePlane_Oregon_North_FIPS_3601\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",2500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-120.5],PARAMETER[\"Standard_Parallel_1\",44.33333333333334],PARAMETER[\"Standard_Parallel_2\",46.0],PARAMETER[\"Latitude_Of_Origin\",43.66666666666666],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2838]]",
        2839=>"PROJCS[\"NAD_1983_HARN_StatePlane_Oregon_South_FIPS_3602\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",1500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-120.5],PARAMETER[\"Standard_Parallel_1\",42.33333333333334],PARAMETER[\"Standard_Parallel_2\",44.0],PARAMETER[\"Latitude_Of_Origin\",41.66666666666666],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2839]]",
        2840=>"PROJCS[\"NAD_1983_HARN_StatePlane_Rhode_Island_FIPS_3800\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",100000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-71.5],PARAMETER[\"Scale_Factor\",0.99999375],PARAMETER[\"Latitude_Of_Origin\",41.08333333333334],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2840]]",
        2841=>"PROJCS[\"NAD_1983_HARN_StatePlane_South_Dakota_North_FIPS_4001\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",600000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-100.0],PARAMETER[\"Standard_Parallel_1\",44.41666666666666],PARAMETER[\"Standard_Parallel_2\",45.68333333333333],PARAMETER[\"Latitude_Of_Origin\",43.83333333333334],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2841]]",
        2842=>"PROJCS[\"NAD_1983_HARN_StatePlane_South_Dakota_South_FIPS_4002\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",600000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-100.3333333333333],PARAMETER[\"Standard_Parallel_1\",42.83333333333334],PARAMETER[\"Standard_Parallel_2\",44.4],PARAMETER[\"Latitude_Of_Origin\",42.33333333333334],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2842]]",
        2843=>"PROJCS[\"NAD_1983_HARN_StatePlane_Tennessee_FIPS_4100\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",600000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-86.0],PARAMETER[\"Standard_Parallel_1\",35.25],PARAMETER[\"Standard_Parallel_2\",36.41666666666666],PARAMETER[\"Latitude_Of_Origin\",34.33333333333334],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2843]]",
        2844=>"PROJCS[\"NAD_1983_HARN_StatePlane_Texas_North_FIPS_4201\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",200000.0],PARAMETER[\"False_Northing\",1000000.0],PARAMETER[\"Central_Meridian\",-101.5],PARAMETER[\"Standard_Parallel_1\",34.65],PARAMETER[\"Standard_Parallel_2\",36.18333333333333],PARAMETER[\"Latitude_Of_Origin\",34.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2844]]",
        2845=>"PROJCS[\"NAD_1983_HARN_StatePlane_Texas_North_Central_FIPS_4202\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",600000.0],PARAMETER[\"False_Northing\",2000000.0],PARAMETER[\"Central_Meridian\",-98.5],PARAMETER[\"Standard_Parallel_1\",32.13333333333333],PARAMETER[\"Standard_Parallel_2\",33.96666666666667],PARAMETER[\"Latitude_Of_Origin\",31.66666666666667],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2845]]",
        2846=>"PROJCS[\"NAD_1983_HARN_StatePlane_Texas_Central_FIPS_4203\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",700000.0],PARAMETER[\"False_Northing\",3000000.0],PARAMETER[\"Central_Meridian\",-100.3333333333333],PARAMETER[\"Standard_Parallel_1\",30.11666666666667],PARAMETER[\"Standard_Parallel_2\",31.88333333333333],PARAMETER[\"Latitude_Of_Origin\",29.66666666666667],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2846]]",
        2847=>"PROJCS[\"NAD_1983_HARN_StatePlane_Texas_South_Central_FIPS_4204\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",600000.0],PARAMETER[\"False_Northing\",4000000.0],PARAMETER[\"Central_Meridian\",-99.0],PARAMETER[\"Standard_Parallel_1\",28.38333333333333],PARAMETER[\"Standard_Parallel_2\",30.28333333333333],PARAMETER[\"Latitude_Of_Origin\",27.83333333333333],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2847]]",
        2848=>"PROJCS[\"NAD_1983_HARN_StatePlane_Texas_South_FIPS_4205\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",300000.0],PARAMETER[\"False_Northing\",5000000.0],PARAMETER[\"Central_Meridian\",-98.5],PARAMETER[\"Standard_Parallel_1\",26.16666666666667],PARAMETER[\"Standard_Parallel_2\",27.83333333333333],PARAMETER[\"Latitude_Of_Origin\",25.66666666666667],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2848]]",
        2849=>"PROJCS[\"NAD_1983_HARN_StatePlane_Utah_North_FIPS_4301\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",1000000.0],PARAMETER[\"Central_Meridian\",-111.5],PARAMETER[\"Standard_Parallel_1\",40.71666666666667],PARAMETER[\"Standard_Parallel_2\",41.78333333333333],PARAMETER[\"Latitude_Of_Origin\",40.33333333333334],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2849]]",
        2850=>"PROJCS[\"NAD_1983_HARN_StatePlane_Utah_Central_FIPS_4302\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",2000000.0],PARAMETER[\"Central_Meridian\",-111.5],PARAMETER[\"Standard_Parallel_1\",39.01666666666667],PARAMETER[\"Standard_Parallel_2\",40.65],PARAMETER[\"Latitude_Of_Origin\",38.33333333333334],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2850]]",
        2851=>"PROJCS[\"NAD_1983_HARN_StatePlane_Utah_South_FIPS_4303\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",3000000.0],PARAMETER[\"Central_Meridian\",-111.5],PARAMETER[\"Standard_Parallel_1\",37.21666666666667],PARAMETER[\"Standard_Parallel_2\",38.35],PARAMETER[\"Latitude_Of_Origin\",36.66666666666666],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2851]]",
        2852=>"PROJCS[\"NAD_1983_HARN_StatePlane_Vermont_FIPS_4400\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-72.5],PARAMETER[\"Scale_Factor\",0.9999642857142857],PARAMETER[\"Latitude_Of_Origin\",42.5],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2852]]",
        2853=>"PROJCS[\"NAD_1983_HARN_StatePlane_Virginia_North_FIPS_4501\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",3500000.0],PARAMETER[\"False_Northing\",2000000.0],PARAMETER[\"Central_Meridian\",-78.5],PARAMETER[\"Standard_Parallel_1\",38.03333333333333],PARAMETER[\"Standard_Parallel_2\",39.2],PARAMETER[\"Latitude_Of_Origin\",37.66666666666666],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2853]]",
        2854=>"PROJCS[\"NAD_1983_HARN_StatePlane_Virginia_South_FIPS_4502\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",3500000.0],PARAMETER[\"False_Northing\",1000000.0],PARAMETER[\"Central_Meridian\",-78.5],PARAMETER[\"Standard_Parallel_1\",36.76666666666667],PARAMETER[\"Standard_Parallel_2\",37.96666666666667],PARAMETER[\"Latitude_Of_Origin\",36.33333333333334],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2854]]",
        2855=>"PROJCS[\"NAD_1983_HARN_StatePlane_Washington_North_FIPS_4601\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-120.8333333333333],PARAMETER[\"Standard_Parallel_1\",47.5],PARAMETER[\"Standard_Parallel_2\",48.73333333333333],PARAMETER[\"Latitude_Of_Origin\",47.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2855]]",
        2856=>"PROJCS[\"NAD_1983_HARN_StatePlane_Washington_South_FIPS_4602\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-120.5],PARAMETER[\"Standard_Parallel_1\",45.83333333333334],PARAMETER[\"Standard_Parallel_2\",47.33333333333334],PARAMETER[\"Latitude_Of_Origin\",45.33333333333334],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2856]]",
        2857=>"PROJCS[\"NAD_1983_HARN_StatePlane_West_Virginia_North_FIPS_4701\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",600000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-79.5],PARAMETER[\"Standard_Parallel_1\",39.0],PARAMETER[\"Standard_Parallel_2\",40.25],PARAMETER[\"Latitude_Of_Origin\",38.5],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2857]]",
        2858=>"PROJCS[\"NAD_1983_HARN_StatePlane_West_Virginia_South_FIPS_4702\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",600000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-81.0],PARAMETER[\"Standard_Parallel_1\",37.48333333333333],PARAMETER[\"Standard_Parallel_2\",38.88333333333333],PARAMETER[\"Latitude_Of_Origin\",37.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2858]]",
        2859=>"PROJCS[\"NAD_1983_HARN_StatePlane_Wisconsin_North_FIPS_4801\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",600000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-90.0],PARAMETER[\"Standard_Parallel_1\",45.56666666666667],PARAMETER[\"Standard_Parallel_2\",46.76666666666667],PARAMETER[\"Latitude_Of_Origin\",45.16666666666666],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2859]]",
        2860=>"PROJCS[\"NAD_1983_HARN_StatePlane_Wisconsin_Central_FIPS_4802\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",600000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-90.0],PARAMETER[\"Standard_Parallel_1\",44.25],PARAMETER[\"Standard_Parallel_2\",45.5],PARAMETER[\"Latitude_Of_Origin\",43.83333333333334],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2860]]",
        2861=>"PROJCS[\"NAD_1983_HARN_StatePlane_Wisconsin_South_FIPS_4803\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",600000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-90.0],PARAMETER[\"Standard_Parallel_1\",42.73333333333333],PARAMETER[\"Standard_Parallel_2\",44.06666666666667],PARAMETER[\"Latitude_Of_Origin\",42.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2861]]",
        2862=>"PROJCS[\"NAD_1983_HARN_StatePlane_Wyoming_East_FIPS_4901\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",200000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-105.1666666666667],PARAMETER[\"Scale_Factor\",0.9999375],PARAMETER[\"Latitude_Of_Origin\",40.5],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2862]]",
        2863=>"PROJCS[\"NAD_1983_HARN_StatePlane_Wyoming_East_Central_FIPS_4902\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",400000.0],PARAMETER[\"False_Northing\",100000.0],PARAMETER[\"Central_Meridian\",-107.3333333333333],PARAMETER[\"Scale_Factor\",0.9999375],PARAMETER[\"Latitude_Of_Origin\",40.5],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2863]]",
        2864=>"PROJCS[\"NAD_1983_HARN_StatePlane_Wyoming_West_Central_FIPS_4903\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",600000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-108.75],PARAMETER[\"Scale_Factor\",0.9999375],PARAMETER[\"Latitude_Of_Origin\",40.5],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2864]]",
        2865=>"PROJCS[\"NAD_1983_HARN_StatePlane_Wyoming_West_FIPS_4904\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",800000.0],PARAMETER[\"False_Northing\",100000.0],PARAMETER[\"Central_Meridian\",-110.0833333333333],PARAMETER[\"Scale_Factor\",0.9999375],PARAMETER[\"Latitude_Of_Origin\",40.5],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2865]]",
        2866=>"PROJCS[\"NAD_1983_HARN_StatePlane_Puerto_Rico_Virgin_Islands_FIPS_5200\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",200000.0],PARAMETER[\"False_Northing\",200000.0],PARAMETER[\"Central_Meridian\",-66.43333333333334],PARAMETER[\"Standard_Parallel_1\",18.03333333333333],PARAMETER[\"Standard_Parallel_2\",18.43333333333333],PARAMETER[\"Latitude_Of_Origin\",17.83333333333333],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2866]]",
        2867=>"PROJCS[\"NAD_1983_HARN_StatePlane_Arizona_East_FIPS_0201_Feet_Intl\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",700000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-110.1666666666667],PARAMETER[\"Scale_Factor\",0.9999],PARAMETER[\"Latitude_Of_Origin\",31.0],UNIT[\"Foot\",0.3048],AUTHORITY[\"EPSG\",2867]]",
        2868=>"PROJCS[\"NAD_1983_HARN_StatePlane_Arizona_Central_FIPS_0202_Feet_Intl\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",700000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-111.9166666666667],PARAMETER[\"Scale_Factor\",0.9999],PARAMETER[\"Latitude_Of_Origin\",31.0],UNIT[\"Foot\",0.3048],AUTHORITY[\"EPSG\",2868]]",
        2869=>"PROJCS[\"NAD_1983_HARN_StatePlane_Arizona_West_FIPS_0203_Feet_Intl\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",700000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-113.75],PARAMETER[\"Scale_Factor\",0.9999333333333333],PARAMETER[\"Latitude_Of_Origin\",31.0],UNIT[\"Foot\",0.3048],AUTHORITY[\"EPSG\",2869]]",
        2870=>"PROJCS[\"NAD_1983_HARN_StatePlane_California_I_FIPS_0401_Feet\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",6561666.666666666],PARAMETER[\"False_Northing\",1640416.666666667],PARAMETER[\"Central_Meridian\",-122.0],PARAMETER[\"Standard_Parallel_1\",40.0],PARAMETER[\"Standard_Parallel_2\",41.66666666666666],PARAMETER[\"Latitude_Of_Origin\",39.33333333333334],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",2870]]",
        2871=>"PROJCS[\"NAD_1983_HARN_StatePlane_California_II_FIPS_0402_Feet\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",6561666.666666666],PARAMETER[\"False_Northing\",1640416.666666667],PARAMETER[\"Central_Meridian\",-122.0],PARAMETER[\"Standard_Parallel_1\",38.33333333333334],PARAMETER[\"Standard_Parallel_2\",39.83333333333334],PARAMETER[\"Latitude_Of_Origin\",37.66666666666666],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",2871]]",
        2872=>"PROJCS[\"NAD_1983_HARN_StatePlane_California_III_FIPS_0403_Feet\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",6561666.666666666],PARAMETER[\"False_Northing\",1640416.666666667],PARAMETER[\"Central_Meridian\",-120.5],PARAMETER[\"Standard_Parallel_1\",37.06666666666667],PARAMETER[\"Standard_Parallel_2\",38.43333333333333],PARAMETER[\"Latitude_Of_Origin\",36.5],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",2872]]",
        2873=>"PROJCS[\"NAD_1983_HARN_StatePlane_California_IV_FIPS_0404_Feet\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",6561666.666666666],PARAMETER[\"False_Northing\",1640416.666666667],PARAMETER[\"Central_Meridian\",-119.0],PARAMETER[\"Standard_Parallel_1\",36.0],PARAMETER[\"Standard_Parallel_2\",37.25],PARAMETER[\"Latitude_Of_Origin\",35.33333333333334],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",2873]]",
        2874=>"PROJCS[\"NAD_1983_HARN_StatePlane_California_V_FIPS_0405_Feet\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",6561666.666666666],PARAMETER[\"False_Northing\",1640416.666666667],PARAMETER[\"Central_Meridian\",-118.0],PARAMETER[\"Standard_Parallel_1\",34.03333333333333],PARAMETER[\"Standard_Parallel_2\",35.46666666666667],PARAMETER[\"Latitude_Of_Origin\",33.5],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",2874]]",
        2875=>"PROJCS[\"NAD_1983_HARN_StatePlane_California_VI_FIPS_0406_Feet\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",6561666.666666666],PARAMETER[\"False_Northing\",1640416.666666667],PARAMETER[\"Central_Meridian\",-116.25],PARAMETER[\"Standard_Parallel_1\",32.78333333333333],PARAMETER[\"Standard_Parallel_2\",33.88333333333333],PARAMETER[\"Latitude_Of_Origin\",32.16666666666666],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",2875]]",
        2876=>"PROJCS[\"NAD_1983_HARN_StatePlane_Colorado_North_FIPS_0501_Feet\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",3000000.000316083],PARAMETER[\"False_Northing\",999999.999996],PARAMETER[\"Central_Meridian\",-105.5],PARAMETER[\"Standard_Parallel_1\",39.71666666666667],PARAMETER[\"Standard_Parallel_2\",40.78333333333333],PARAMETER[\"Latitude_Of_Origin\",39.33333333333334],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",2876]]",
        2877=>"PROJCS[\"NAD_1983_HARN_StatePlane_Colorado_Central_FIPS_0502_Feet\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",3000000.000316083],PARAMETER[\"False_Northing\",999999.999996],PARAMETER[\"Central_Meridian\",-105.5],PARAMETER[\"Standard_Parallel_1\",38.45],PARAMETER[\"Standard_Parallel_2\",39.75],PARAMETER[\"Latitude_Of_Origin\",37.83333333333334],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",2877]]",
        2878=>"PROJCS[\"NAD_1983_HARN_StatePlane_Colorado_South_FIPS_0503_Feet\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",3000000.000316083],PARAMETER[\"False_Northing\",999999.999996],PARAMETER[\"Central_Meridian\",-105.5],PARAMETER[\"Standard_Parallel_1\",37.23333333333333],PARAMETER[\"Standard_Parallel_2\",38.43333333333333],PARAMETER[\"Latitude_Of_Origin\",36.66666666666666],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",2878]]",
        2879=>"PROJCS[\"NAD_1983_HARN_StatePlane_Connecticut_FIPS_0600_Feet\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",999999.999996],PARAMETER[\"False_Northing\",499999.999998],PARAMETER[\"Central_Meridian\",-72.75],PARAMETER[\"Standard_Parallel_1\",41.2],PARAMETER[\"Standard_Parallel_2\",41.86666666666667],PARAMETER[\"Latitude_Of_Origin\",40.83333333333334],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",2879]]",
        2880=>"PROJCS[\"NAD_1983_HARN_StatePlane_Delaware_FIPS_0700_Feet\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",656166.6666666665],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-75.41666666666667],PARAMETER[\"Scale_Factor\",0.999995],PARAMETER[\"Latitude_Of_Origin\",38.0],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",2880]]",
        2881=>"PROJCS[\"NAD_1983_HARN_StatePlane_Florida_East_FIPS_0901_Feet\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",656166.6666666665],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-81.0],PARAMETER[\"Scale_Factor\",0.9999411764705882],PARAMETER[\"Latitude_Of_Origin\",24.33333333333333],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",2881]]",
        2882=>"PROJCS[\"NAD_1983_HARN_StatePlane_Florida_West_FIPS_0902_Feet\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",656166.6666666665],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-82.0],PARAMETER[\"Scale_Factor\",0.9999411764705882],PARAMETER[\"Latitude_Of_Origin\",24.33333333333333],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",2882]]",
        2883=>"PROJCS[\"NAD_1983_HARN_StatePlane_Florida_North_FIPS_0903_Feet\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",1968500.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-84.5],PARAMETER[\"Standard_Parallel_1\",29.58333333333333],PARAMETER[\"Standard_Parallel_2\",30.75],PARAMETER[\"Latitude_Of_Origin\",29.0],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",2883]]",
        2884=>"PROJCS[\"NAD_1983_HARN_StatePlane_Georgia_East_FIPS_1001_Feet\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",656166.6666666665],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-82.16666666666667],PARAMETER[\"Scale_Factor\",0.9999],PARAMETER[\"Latitude_Of_Origin\",30.0],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",2884]]",
        2885=>"PROJCS[\"NAD_1983_HARN_StatePlane_Georgia_West_FIPS_1002_Feet\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",2296583.333333333],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-84.16666666666667],PARAMETER[\"Scale_Factor\",0.9999],PARAMETER[\"Latitude_Of_Origin\",30.0],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",2885]]",
        2886=>"PROJCS[\"NAD_1983_HARN_StatePlane_Idaho_East_FIPS_1101_Feet\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",656166.6666666665],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-112.1666666666667],PARAMETER[\"Scale_Factor\",0.9999473684210526],PARAMETER[\"Latitude_Of_Origin\",41.66666666666666],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",2886]]",
        2887=>"PROJCS[\"NAD_1983_HARN_StatePlane_Idaho_Central_FIPS_1102_Feet\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",1640416.666666667],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-114.0],PARAMETER[\"Scale_Factor\",0.9999473684210526],PARAMETER[\"Latitude_Of_Origin\",41.66666666666666],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",2887]]",
        2888=>"PROJCS[\"NAD_1983_HARN_StatePlane_Idaho_West_FIPS_1103_Feet\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",2624666.666666666],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-115.75],PARAMETER[\"Scale_Factor\",0.9999333333333333],PARAMETER[\"Latitude_Of_Origin\",41.66666666666666],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",2888]]",
        2891=>"PROJCS[\"NAD_1983_HARN_StatePlane_Kentucky_North_FIPS_1601_Feet\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",1640416.666666667],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-84.25],PARAMETER[\"Standard_Parallel_1\",37.96666666666667],PARAMETER[\"Standard_Parallel_2\",38.96666666666667],PARAMETER[\"Latitude_Of_Origin\",37.5],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",2891]]",
        2892=>"PROJCS[\"NAD_1983_HARN_StatePlane_Kentucky_South_FIPS_1602_Feet\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",1640416.666666667],PARAMETER[\"False_Northing\",1640416.666666667],PARAMETER[\"Central_Meridian\",-85.75],PARAMETER[\"Standard_Parallel_1\",36.73333333333333],PARAMETER[\"Standard_Parallel_2\",37.93333333333333],PARAMETER[\"Latitude_Of_Origin\",36.33333333333334],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",2892]]",
        2893=>"PROJCS[\"NAD_1983_HARN_StatePlane_Maryland_FIPS_1900_Feet\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",1312333.333333333],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-77.0],PARAMETER[\"Standard_Parallel_1\",38.3],PARAMETER[\"Standard_Parallel_2\",39.45],PARAMETER[\"Latitude_Of_Origin\",37.66666666666666],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",2893]]",
        2894=>"PROJCS[\"NAD_1983_HARN_StatePlane_Massachusetts_Mainland_FIPS_2001_Feet\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",656166.6666666665],PARAMETER[\"False_Northing\",2460625.0],PARAMETER[\"Central_Meridian\",-71.5],PARAMETER[\"Standard_Parallel_1\",41.71666666666667],PARAMETER[\"Standard_Parallel_2\",42.68333333333333],PARAMETER[\"Latitude_Of_Origin\",41.0],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",2894]]",
        2895=>"PROJCS[\"NAD_1983_HARN_StatePlane_Massachusetts_Island_FIPS_2002_Feet\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",1640416.666666667],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-70.5],PARAMETER[\"Standard_Parallel_1\",41.28333333333333],PARAMETER[\"Standard_Parallel_2\",41.48333333333333],PARAMETER[\"Latitude_Of_Origin\",41.0],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",2895]]",
        2896=>"PROJCS[\"NAD_1983_HARN_StatePlane_Michigan_North_FIPS_2111_Feet_Intl\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",26246719.16010498],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-87.0],PARAMETER[\"Standard_Parallel_1\",45.48333333333333],PARAMETER[\"Standard_Parallel_2\",47.08333333333334],PARAMETER[\"Latitude_Of_Origin\",44.78333333333333],UNIT[\"Foot\",0.3048],AUTHORITY[\"EPSG\",2896]]",
        2897=>"PROJCS[\"NAD_1983_HARN_StatePlane_Michigan_Central_FIPS_2112_Feet_Intl\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",19685039.37007874],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-84.36666666666666],PARAMETER[\"Standard_Parallel_1\",44.18333333333333],PARAMETER[\"Standard_Parallel_2\",45.7],PARAMETER[\"Latitude_Of_Origin\",43.31666666666667],UNIT[\"Foot\",0.3048],AUTHORITY[\"EPSG\",2897]]",
        2898=>"PROJCS[\"NAD_1983_HARN_StatePlane_Michigan_South_FIPS_2113_Feet_Intl\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",13123359.58005249],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-84.36666666666666],PARAMETER[\"Standard_Parallel_1\",42.1],PARAMETER[\"Standard_Parallel_2\",43.66666666666666],PARAMETER[\"Latitude_Of_Origin\",41.5],UNIT[\"Foot\",0.3048],AUTHORITY[\"EPSG\",2898]]",
        2899=>"PROJCS[\"NAD_1983_HARN_StatePlane_Mississippi_East_FIPS_2301_Feet\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",984250.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-88.83333333333333],PARAMETER[\"Scale_Factor\",0.99995],PARAMETER[\"Latitude_Of_Origin\",29.5],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",2899]]",
        2900=>"PROJCS[\"NAD_1983_HARN_StatePlane_Mississippi_West_FIPS_2302_Feet\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",2296583.333333333],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-90.33333333333333],PARAMETER[\"Scale_Factor\",0.99995],PARAMETER[\"Latitude_Of_Origin\",29.5],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",2900]]",
        2901=>"PROJCS[\"NAD_1983_HARN_StatePlane_Montana_FIPS_2500_Feet_Intl\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",1968503.937007874],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-109.5],PARAMETER[\"Standard_Parallel_1\",45.0],PARAMETER[\"Standard_Parallel_2\",49.0],PARAMETER[\"Latitude_Of_Origin\",44.25],UNIT[\"Foot\",0.3048],AUTHORITY[\"EPSG\",2901]]",
        2902=>"PROJCS[\"NAD_1983_HARN_StatePlane_New_Mexico_East_FIPS_3001_Feet\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",541337.5],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-104.3333333333333],PARAMETER[\"Scale_Factor\",0.9999090909090909],PARAMETER[\"Latitude_Of_Origin\",31.0],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",2902]]",
        2903=>"PROJCS[\"NAD_1983_HARN_StatePlane_New_Mexico_Central_FIPS_3002_Feet\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",1640416.666666667],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-106.25],PARAMETER[\"Scale_Factor\",0.9999],PARAMETER[\"Latitude_Of_Origin\",31.0],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",2903]]",
        2904=>"PROJCS[\"NAD_1983_HARN_StatePlane_New_Mexico_West_FIPS_3003_Feet\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",2723091.666666666],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-107.8333333333333],PARAMETER[\"Scale_Factor\",0.9999166666666667],PARAMETER[\"Latitude_Of_Origin\",31.0],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",2904]]",
        2905=>"PROJCS[\"NAD_1983_HARN_StatePlane_New_York_East_FIPS_3101_Feet\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",492125.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-74.5],PARAMETER[\"Scale_Factor\",0.9999],PARAMETER[\"Latitude_Of_Origin\",38.83333333333334],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",2905]]",
        2906=>"PROJCS[\"NAD_1983_HARN_StatePlane_New_York_Central_FIPS_3102_Feet\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",820208.3333333333],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-76.58333333333333],PARAMETER[\"Scale_Factor\",0.9999375],PARAMETER[\"Latitude_Of_Origin\",40.0],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",2906]]",
        2907=>"PROJCS[\"NAD_1983_HARN_StatePlane_New_York_West_FIPS_3103_Feet\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",1148291.666666667],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-78.58333333333333],PARAMETER[\"Scale_Factor\",0.9999375],PARAMETER[\"Latitude_Of_Origin\",40.0],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",2907]]",
        2908=>"PROJCS[\"NAD_1983_HARN_StatePlane_New_York_Long_Island_FIPS_3104_Feet\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",984250.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-74.0],PARAMETER[\"Standard_Parallel_1\",40.66666666666666],PARAMETER[\"Standard_Parallel_2\",41.03333333333333],PARAMETER[\"Latitude_Of_Origin\",40.16666666666666],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",2908]]",
        2909=>"PROJCS[\"NAD_1983_HARN_StatePlane_North_Dakota_North_FIPS_3301_Feet_Intl\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",1968503.937007874],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-100.5],PARAMETER[\"Standard_Parallel_1\",47.43333333333333],PARAMETER[\"Standard_Parallel_2\",48.73333333333333],PARAMETER[\"Latitude_Of_Origin\",47.0],UNIT[\"Foot\",0.3048],AUTHORITY[\"EPSG\",2909]]",
        2910=>"PROJCS[\"NAD_1983_HARN_StatePlane_North_Dakota_South_FIPS_3302_Feet_Intl\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",1968503.937007874],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-100.5],PARAMETER[\"Standard_Parallel_1\",46.18333333333333],PARAMETER[\"Standard_Parallel_2\",47.48333333333333],PARAMETER[\"Latitude_Of_Origin\",45.66666666666666],UNIT[\"Foot\",0.3048],AUTHORITY[\"EPSG\",2910]]",
        2911=>"PROJCS[\"NAD_1983_HARN_StatePlane_Oklahoma_North_FIPS_3501_Feet\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",1968500.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-98.0],PARAMETER[\"Standard_Parallel_1\",35.56666666666667],PARAMETER[\"Standard_Parallel_2\",36.76666666666667],PARAMETER[\"Latitude_Of_Origin\",35.0],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",2911]]",
        2912=>"PROJCS[\"NAD_1983_HARN_StatePlane_Oklahoma_South_FIPS_3502_Feet\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",1968500.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-98.0],PARAMETER[\"Standard_Parallel_1\",33.93333333333333],PARAMETER[\"Standard_Parallel_2\",35.23333333333333],PARAMETER[\"Latitude_Of_Origin\",33.33333333333334],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",2912]]",
        2913=>"PROJCS[\"NAD_1983_HARN_StatePlane_Oregon_North_FIPS_3601_Feet_Intl\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",8202099.737532808],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-120.5],PARAMETER[\"Standard_Parallel_1\",44.33333333333334],PARAMETER[\"Standard_Parallel_2\",46.0],PARAMETER[\"Latitude_Of_Origin\",43.66666666666666],UNIT[\"Foot\",0.3048],AUTHORITY[\"EPSG\",2913]]",
        2914=>"PROJCS[\"NAD_1983_HARN_StatePlane_Oregon_South_FIPS_3602_Feet_Intl\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",4921259.842519685],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-120.5],PARAMETER[\"Standard_Parallel_1\",42.33333333333334],PARAMETER[\"Standard_Parallel_2\",44.0],PARAMETER[\"Latitude_Of_Origin\",41.66666666666666],UNIT[\"Foot\",0.3048],AUTHORITY[\"EPSG\",2914]]",
        2915=>"PROJCS[\"NAD_1983_HARN_StatePlane_Tennessee_FIPS_4100_Feet\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",1968500.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-86.0],PARAMETER[\"Standard_Parallel_1\",35.25],PARAMETER[\"Standard_Parallel_2\",36.41666666666666],PARAMETER[\"Latitude_Of_Origin\",34.33333333333334],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",2915]]",
        2916=>"PROJCS[\"NAD_1983_HARN_StatePlane_Texas_North_FIPS_4201_Feet\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",656166.6666666665],PARAMETER[\"False_Northing\",3280833.333333333],PARAMETER[\"Central_Meridian\",-101.5],PARAMETER[\"Standard_Parallel_1\",34.65],PARAMETER[\"Standard_Parallel_2\",36.18333333333333],PARAMETER[\"Latitude_Of_Origin\",34.0],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",2916]]",
        2917=>"PROJCS[\"NAD_1983_HARN_StatePlane_Texas_North_Central_FIPS_4202_Feet\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",1968500.0],PARAMETER[\"False_Northing\",6561666.666666666],PARAMETER[\"Central_Meridian\",-98.5],PARAMETER[\"Standard_Parallel_1\",32.13333333333333],PARAMETER[\"Standard_Parallel_2\",33.96666666666667],PARAMETER[\"Latitude_Of_Origin\",31.66666666666667],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",2917]]",
        2918=>"PROJCS[\"NAD_1983_HARN_StatePlane_Texas_Central_FIPS_4203_Feet\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",2296583.333333333],PARAMETER[\"False_Northing\",9842500.0],PARAMETER[\"Central_Meridian\",-100.3333333333333],PARAMETER[\"Standard_Parallel_1\",30.11666666666667],PARAMETER[\"Standard_Parallel_2\",31.88333333333333],PARAMETER[\"Latitude_Of_Origin\",29.66666666666667],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",2918]]",
        2919=>"PROJCS[\"NAD_1983_HARN_StatePlane_Texas_South_Central_FIPS_4204_Feet\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",1968500.0],PARAMETER[\"False_Northing\",13123333.33333333],PARAMETER[\"Central_Meridian\",-99.0],PARAMETER[\"Standard_Parallel_1\",28.38333333333333],PARAMETER[\"Standard_Parallel_2\",30.28333333333333],PARAMETER[\"Latitude_Of_Origin\",27.83333333333333],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",2919]]",
        2920=>"PROJCS[\"NAD_1983_HARN_StatePlane_Texas_South_FIPS_4205_Feet\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",984250.0],PARAMETER[\"False_Northing\",16404166.66666666],PARAMETER[\"Central_Meridian\",-98.5],PARAMETER[\"Standard_Parallel_1\",26.16666666666667],PARAMETER[\"Standard_Parallel_2\",27.83333333333333],PARAMETER[\"Latitude_Of_Origin\",25.66666666666667],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",2920]]",
        2921=>"PROJCS[\"NAD_1983_HARN_StatePlane_Utah_North_FIPS_4301_Feet_Intl\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",1640419.947506561],PARAMETER[\"False_Northing\",3280839.895013123],PARAMETER[\"Central_Meridian\",-111.5],PARAMETER[\"Standard_Parallel_1\",40.71666666666667],PARAMETER[\"Standard_Parallel_2\",41.78333333333333],PARAMETER[\"Latitude_Of_Origin\",40.33333333333334],UNIT[\"Foot\",0.3048],AUTHORITY[\"EPSG\",2921]]",
        2922=>"PROJCS[\"NAD_1983_HARN_StatePlane_Utah_Central_FIPS_4302_Feet_Intl\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",1640419.947506561],PARAMETER[\"False_Northing\",6561679.790026246],PARAMETER[\"Central_Meridian\",-111.5],PARAMETER[\"Standard_Parallel_1\",39.01666666666667],PARAMETER[\"Standard_Parallel_2\",40.65],PARAMETER[\"Latitude_Of_Origin\",38.33333333333334],UNIT[\"Foot\",0.3048],AUTHORITY[\"EPSG\",2922]]",
        2923=>"PROJCS[\"NAD_1983_HARN_StatePlane_Utah_South_FIPS_4303_Feet_Intl\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",1640419.947506561],PARAMETER[\"False_Northing\",9842519.685039369],PARAMETER[\"Central_Meridian\",-111.5],PARAMETER[\"Standard_Parallel_1\",37.21666666666667],PARAMETER[\"Standard_Parallel_2\",38.35],PARAMETER[\"Latitude_Of_Origin\",36.66666666666666],UNIT[\"Foot\",0.3048],AUTHORITY[\"EPSG\",2923]]",
        2924=>"PROJCS[\"NAD_1983_HARN_StatePlane_Virginia_North_FIPS_4501_Feet\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",11482916.66666666],PARAMETER[\"False_Northing\",6561666.666666666],PARAMETER[\"Central_Meridian\",-78.5],PARAMETER[\"Standard_Parallel_1\",38.03333333333333],PARAMETER[\"Standard_Parallel_2\",39.2],PARAMETER[\"Latitude_Of_Origin\",37.66666666666666],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",2924]]",
        2925=>"PROJCS[\"NAD_1983_HARN_StatePlane_Virginia_South_FIPS_4502_Feet\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",11482916.66666666],PARAMETER[\"False_Northing\",3280833.333333333],PARAMETER[\"Central_Meridian\",-78.5],PARAMETER[\"Standard_Parallel_1\",36.76666666666667],PARAMETER[\"Standard_Parallel_2\",37.96666666666667],PARAMETER[\"Latitude_Of_Origin\",36.33333333333334],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",2925]]",
        2926=>"PROJCS[\"NAD_1983_HARN_StatePlane_Washington_North_FIPS_4601_Feet\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",1640416.666666667],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-120.8333333333333],PARAMETER[\"Standard_Parallel_1\",47.5],PARAMETER[\"Standard_Parallel_2\",48.73333333333333],PARAMETER[\"Latitude_Of_Origin\",47.0],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",2926]]",
        2927=>"PROJCS[\"NAD_1983_HARN_StatePlane_Washington_South_FIPS_4602_Feet\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",1640416.666666667],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-120.5],PARAMETER[\"Standard_Parallel_1\",45.83333333333334],PARAMETER[\"Standard_Parallel_2\",47.33333333333334],PARAMETER[\"Latitude_Of_Origin\",45.33333333333334],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",2927]]",
        2928=>"PROJCS[\"NAD_1983_HARN_StatePlane_Wisconsin_North_FIPS_4801_Feet\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",1968500.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-90.0],PARAMETER[\"Standard_Parallel_1\",45.56666666666667],PARAMETER[\"Standard_Parallel_2\",46.76666666666667],PARAMETER[\"Latitude_Of_Origin\",45.16666666666666],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",2928]]",
        2929=>"PROJCS[\"NAD_1983_HARN_StatePlane_Wisconsin_Central_FIPS_4802_Feet\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",1968500.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-90.0],PARAMETER[\"Standard_Parallel_1\",44.25],PARAMETER[\"Standard_Parallel_2\",45.5],PARAMETER[\"Latitude_Of_Origin\",43.83333333333334],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",2929]]",
        2930=>"PROJCS[\"NAD_1983_HARN_StatePlane_Wisconsin_South_FIPS_4803_Feet\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",1968500.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-90.0],PARAMETER[\"Standard_Parallel_1\",42.73333333333333],PARAMETER[\"Standard_Parallel_2\",44.06666666666667],PARAMETER[\"Latitude_Of_Origin\",42.0],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",2930]]",
        2931=>"PROJCS[\"Beduaram_TM_13_NE\",GEOGCS[\"GCS_Beduaram\",DATUM[\"D_Beduaram\",SPHEROID[\"Clarke_1880_IGN\",6378249.2,293.4660212936265]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",13.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2931]]",
        2932=>"PROJCS[\"QND_1995_Qatar_National_Grid\",GEOGCS[\"GCS_QND_1995\",DATUM[\"D_QND_1995\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",200000.0],PARAMETER[\"False_Northing\",300000.0],PARAMETER[\"Central_Meridian\",51.21666666666667],PARAMETER[\"Scale_Factor\",0.99999],PARAMETER[\"Latitude_Of_Origin\",24.45],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2932]]",
        2933=>"PROJCS[\"Gunung_Segara_UTM_Zone_50S\",GEOGCS[\"GCS_Gunung_Segara\",DATUM[\"D_Gunung_Segara\",SPHEROID[\"Bessel_1841\",6377397.155,299.1528128]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",10000000.0],PARAMETER[\"Central_Meridian\",117.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2933]]",
        2934=>"PROJCS[\"Gunung_Segara_Jakarta_NEIEZ\",GEOGCS[\"GCS_Gunung_Segara_Jakarta\",DATUM[\"D_Gunung_Segara\",SPHEROID[\"Bessel_1841\",6377397.155,299.1528128]],PRIMEM[\"Jakarta\",106.8077194444444],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Mercator\"],PARAMETER[\"False_Easting\",3900000.0],PARAMETER[\"False_Northing\",900000.0],PARAMETER[\"Central_Meridian\",3.192280555555556],PARAMETER[\"Standard_Parallel_1\",4.45405154589751],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",5329]]",
        2935=>"PROJCS[\"Pulkovo_1942_CS63_Zone_A1\",GEOGCS[\"GCS_Pulkovo_1942\",DATUM[\"D_Pulkovo_1942\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",1300000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",41.53333333333333],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.1166666666666667],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2935]]",
        2936=>"PROJCS[\"Pulkovo_1942_CS63_Zone_A2\",GEOGCS[\"GCS_Pulkovo_1942\",DATUM[\"D_Pulkovo_1942\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",2300000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",44.53333333333333],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.1166666666666667],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2936]]",
        2937=>"PROJCS[\"Pulkovo_1942_CS63_Zone_A3\",GEOGCS[\"GCS_Pulkovo_1942\",DATUM[\"D_Pulkovo_1942\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",3300000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",47.53333333333333],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.1166666666666667],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2937]]",
        2938=>"PROJCS[\"Pulkovo_1942_CS63_Zone_A4\",GEOGCS[\"GCS_Pulkovo_1942\",DATUM[\"D_Pulkovo_1942\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",4300000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",50.53333333333333],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.1166666666666667],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2938]]",
        2939=>"PROJCS[\"Pulkovo_1942_CS63_Zone_K2\",GEOGCS[\"GCS_Pulkovo_1942\",DATUM[\"D_Pulkovo_1942\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",2300000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",50.76666666666667],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.1333333333333333],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2939]]",
        2940=>"PROJCS[\"Pulkovo_1942_CS63_Zone_K3\",GEOGCS[\"GCS_Pulkovo_1942\",DATUM[\"D_Pulkovo_1942\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",3300000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",53.76666666666667],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.1333333333333333],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2940]]",
        2941=>"PROJCS[\"Pulkovo_1942_CS63_Zone_K4\",GEOGCS[\"GCS_Pulkovo_1942\",DATUM[\"D_Pulkovo_1942\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",4300000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",56.76666666666667],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.1333333333333333],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2941]]",
        2942=>"PROJCS[\"Porto_Santo_1936_UTM_Zone_28N\",GEOGCS[\"GCS_Porto_Santo_1936\",DATUM[\"D_Porto_Santo_1936\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-15.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2942]]",
        2943=>"PROJCS[\"Selvagem_Grande_1938_UTM_Zone_28N\",GEOGCS[\"GCS_Selvagem_Grande_1938\",DATUM[\"D_Selvagem_Grande_1938\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-15.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2943]]",
        2944=>"PROJCS[\"NAD_1983_CSRS_MTM_2_SCoPQ\",GEOGCS[\"GCS_North_American_1983_CSRS\",DATUM[\"D_North_American_1983_CSRS\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",304800.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-55.5],PARAMETER[\"Scale_Factor\",0.9999],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2944]]",
        2945=>"PROJCS[\"NAD_1983_CSRS_MTM_3\",GEOGCS[\"GCS_North_American_1983_CSRS\",DATUM[\"D_North_American_1983_CSRS\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",304800.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-58.5],PARAMETER[\"Scale_Factor\",0.9999],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2945]]",
        2946=>"PROJCS[\"NAD_1983_CSRS_MTM_4\",GEOGCS[\"GCS_North_American_1983_CSRS\",DATUM[\"D_North_American_1983_CSRS\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",304800.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-61.5],PARAMETER[\"Scale_Factor\",0.9999],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2946]]",
        2947=>"PROJCS[\"NAD_1983_CSRS_MTM_5\",GEOGCS[\"GCS_North_American_1983_CSRS\",DATUM[\"D_North_American_1983_CSRS\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",304800.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-64.5],PARAMETER[\"Scale_Factor\",0.9999],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2947]]",
        2948=>"PROJCS[\"NAD_1983_CSRS_MTM_6\",GEOGCS[\"GCS_North_American_1983_CSRS\",DATUM[\"D_North_American_1983_CSRS\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",304800.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-67.5],PARAMETER[\"Scale_Factor\",0.9999],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2948]]",
        2949=>"PROJCS[\"NAD_1983_CSRS_MTM_7\",GEOGCS[\"GCS_North_American_1983_CSRS\",DATUM[\"D_North_American_1983_CSRS\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",304800.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-70.5],PARAMETER[\"Scale_Factor\",0.9999],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2949]]",
        2950=>"PROJCS[\"NAD_1983_CSRS_MTM_8\",GEOGCS[\"GCS_North_American_1983_CSRS\",DATUM[\"D_North_American_1983_CSRS\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",304800.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-73.5],PARAMETER[\"Scale_Factor\",0.9999],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2950]]",
        2951=>"PROJCS[\"NAD_1983_CSRS_MTM_9\",GEOGCS[\"GCS_North_American_1983_CSRS\",DATUM[\"D_North_American_1983_CSRS\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",304800.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-76.5],PARAMETER[\"Scale_Factor\",0.9999],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2951]]",
        2952=>"PROJCS[\"NAD_1983_CSRS_MTM_10\",GEOGCS[\"GCS_North_American_1983_CSRS\",DATUM[\"D_North_American_1983_CSRS\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",304800.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-79.5],PARAMETER[\"Scale_Factor\",0.9999],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2952]]",
        2953=>"PROJCS[\"NAD_1983_CSRS_New_Brunswick_Stereographic\",GEOGCS[\"GCS_North_American_1983_CSRS\",DATUM[\"D_North_American_1983_CSRS\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Double_Stereographic\"],PARAMETER[\"False_Easting\",2500000.0],PARAMETER[\"False_Northing\",7500000.0],PARAMETER[\"Central_Meridian\",-66.5],PARAMETER[\"Scale_Factor\",0.999912],PARAMETER[\"Latitude_Of_Origin\",46.5],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2953]]",
        2954=>"PROJCS[\"NAD_1983_CSRS_Prince_Edward_Island\",GEOGCS[\"GCS_North_American_1983_CSRS\",DATUM[\"D_North_American_1983_CSRS\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Double_Stereographic\"],PARAMETER[\"False_Easting\",400000.0],PARAMETER[\"False_Northing\",800000.0],PARAMETER[\"Central_Meridian\",-63.0],PARAMETER[\"Scale_Factor\",0.999912],PARAMETER[\"Latitude_Of_Origin\",47.25],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2954]]",
        2955=>"PROJCS[\"NAD_1983_CSRS_UTM_Zone_11N\",GEOGCS[\"GCS_North_American_1983_CSRS\",DATUM[\"D_North_American_1983_CSRS\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-117.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2955]]",
        2956=>"PROJCS[\"NAD_1983_CSRS_UTM_Zone_12N\",GEOGCS[\"GCS_North_American_1983_CSRS\",DATUM[\"D_North_American_1983_CSRS\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-111.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2956]]",
        2957=>"PROJCS[\"NAD_1983_CSRS_UTM_Zone_13N\",GEOGCS[\"GCS_North_American_1983_CSRS\",DATUM[\"D_North_American_1983_CSRS\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-105.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2957]]",
        2958=>"PROJCS[\"NAD_1983_CSRS_UTM_Zone_17N\",GEOGCS[\"GCS_North_American_1983_CSRS\",DATUM[\"D_North_American_1983_CSRS\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-81.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2958]]",
        2959=>"PROJCS[\"NAD_1983_CSRS_UTM_Zone_18N\",GEOGCS[\"GCS_North_American_1983_CSRS\",DATUM[\"D_North_American_1983_CSRS\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-75.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2959]]",
        2960=>"PROJCS[\"NAD_1983_CSRS_UTM_Zone_19N\",GEOGCS[\"GCS_North_American_1983_CSRS\",DATUM[\"D_North_American_1983_CSRS\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-69.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2960]]",
        2961=>"PROJCS[\"NAD_1983_CSRS_UTM_Zone_20N\",GEOGCS[\"GCS_North_American_1983_CSRS\",DATUM[\"D_North_American_1983_CSRS\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-63.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2961]]",
        2962=>"PROJCS[\"NAD_1983_CSRS_UTM_Zone_21N\",GEOGCS[\"GCS_North_American_1983_CSRS\",DATUM[\"D_North_American_1983_CSRS\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-57.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2962]]",
        2964=>"PROJCS[\"NAD_1927_Alaska_Albers_Feet\",GEOGCS[\"GCS_North_American_1927\",DATUM[\"D_North_American_1927\",SPHEROID[\"Clarke_1866\",6378206.4,294.9786982]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Albers\"],PARAMETER[\"False_Easting\",0.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-154.0],PARAMETER[\"Standard_Parallel_1\",55.0],PARAMETER[\"Standard_Parallel_2\",65.0],PARAMETER[\"Latitude_Of_Origin\",50.0],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",2964]]",
        2965=>"PROJCS[\"NAD_1983_StatePlane_Indiana_East_FIPS_1301_Feet\",GEOGCS[\"GCS_North_American_1983\",DATUM[\"D_North_American_1983\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",328083.3333333333],PARAMETER[\"False_Northing\",820208.3333333333],PARAMETER[\"Central_Meridian\",-85.66666666666667],PARAMETER[\"Scale_Factor\",0.9999666666666667],PARAMETER[\"Latitude_Of_Origin\",37.5],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",2965]]",
        2966=>"PROJCS[\"NAD_1983_StatePlane_Indiana_West_FIPS_1302_Feet\",GEOGCS[\"GCS_North_American_1983\",DATUM[\"D_North_American_1983\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",2952750.0],PARAMETER[\"False_Northing\",820208.3333333333],PARAMETER[\"Central_Meridian\",-87.08333333333333],PARAMETER[\"Scale_Factor\",0.9999666666666667],PARAMETER[\"Latitude_Of_Origin\",37.5],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",2966]]",
        2967=>"PROJCS[\"NAD_1983_HARN_StatePlane_Indiana_East_FIPS_1301_Feet\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",328083.3333333333],PARAMETER[\"False_Northing\",820208.3333333333],PARAMETER[\"Central_Meridian\",-85.66666666666667],PARAMETER[\"Scale_Factor\",0.9999666666666667],PARAMETER[\"Latitude_Of_Origin\",37.5],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",2967]]",
        2968=>"PROJCS[\"NAD_1983_HARN_StatePlane_Indiana_West_FIPS_1302_Feet\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",2952750.0],PARAMETER[\"False_Northing\",820208.3333333333],PARAMETER[\"Central_Meridian\",-87.08333333333333],PARAMETER[\"Scale_Factor\",0.9999666666666667],PARAMETER[\"Latitude_Of_Origin\",37.5],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",2968]]",
        2969=>"PROJCS[\"Fort_Marigot_UTM_20N\",GEOGCS[\"GCS_Fort_Marigot\",DATUM[\"D_Fort_Marigot\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-63.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2969]]",
        2970=>"PROJCS[\"Sainte_Anne_UTM_20N\",GEOGCS[\"GCS_Sainte_Anne\",DATUM[\"D_Sainte_Anne\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-63.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2970]]",
        2971=>"PROJCS[\"CSG_1967_UTM_22N\",GEOGCS[\"GCS_CSG_1967\",DATUM[\"D_CSG_1967\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-51.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2971]]",
        2972=>"PROJCS[\"RGFG_1995_UTM_22N\",GEOGCS[\"GCS_RGFG_1995\",DATUM[\"D_RGFG_1995\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-51.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2972]]",
        2973=>"PROJCS[\"Fort_Desaix_UTM_20N\",GEOGCS[\"GCS_Fort_Desaix\",DATUM[\"D_Fort_Desaix\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-63.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2973]]",
        2975=>"PROJCS[\"RGR_1992_UTM_40S\",GEOGCS[\"GCS_RGR_1992\",DATUM[\"D_RGR_1992\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",10000000.0],PARAMETER[\"Central_Meridian\",57.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2975]]",
        2976=>"PROJCS[\"Tahiti_1952_UTM_6S\",GEOGCS[\"GCS_Tahiti_1952\",DATUM[\"D_Tahiti_1952\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",10000000.0],PARAMETER[\"Central_Meridian\",-147.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2976]]",
        2977=>"PROJCS[\"Tahaa_1954_UTM_5S\",GEOGCS[\"GCS_Tahaa_1954\",DATUM[\"D_Tahaa_1954\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",10000000.0],PARAMETER[\"Central_Meridian\",-153.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2977]]",
        2978=>"PROJCS[\"IGN72_Nuku_Hiva_UTM_7S\",GEOGCS[\"GCS_IGN72_Nuku_Hiva\",DATUM[\"D_IGN72_Nuku_Hiva\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",10000000.0],PARAMETER[\"Central_Meridian\",-141.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2978]]",
        2979=>"PROJCS[\"Kerguelen_Island_1949_UTM_42S\",GEOGCS[\"GCS_Kerguelen_Island_1949\",DATUM[\"D_Kerguelen_Island_1949\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",10000000.0],PARAMETER[\"Central_Meridian\",69.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3336]]",
        2980=>"PROJCS[\"Combani_1950_UTM_38S\",GEOGCS[\"GCS_Combani_1950\",DATUM[\"D_Combani_1950\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",10000000.0],PARAMETER[\"Central_Meridian\",45.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2980]]",
        2981=>"PROJCS[\"IGN56_Lifou_UTM_58S\",GEOGCS[\"GCS_IGN56_Lifou\",DATUM[\"D_IGN56_Lifou\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",10000000.0],PARAMETER[\"Central_Meridian\",165.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2981]]",
        2982=>"PROJCS[\"IGN72_Grande_Terre_UTM_58S\",GEOGCS[\"GCS_IGN72_Grande_Terre\",DATUM[\"D_IGN72_Grande_Terre\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",10000000.0],PARAMETER[\"Central_Meridian\",165.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3060]]",
        2984=>"PROJCS[\"RGNC_1991_Lambert_New_Caledonia\",GEOGCS[\"GCS_RGNC_1991\",DATUM[\"D_RGNC_1991\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",400000.0],PARAMETER[\"False_Northing\",300000.0],PARAMETER[\"Central_Meridian\",166.0],PARAMETER[\"Standard_Parallel_1\",-20.66666666666667],PARAMETER[\"Standard_Parallel_2\",-22.33333333333333],PARAMETER[\"Latitude_Of_Origin\",-21.5],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2984]]",
        2985=>"PROJCS[\"Petrels_1972_Terre_Adelie_Polar_Stereographic\",GEOGCS[\"GCS_Petrels_1972\",DATUM[\"D_Petrels_1972\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Stereographic_South_Pole\"],PARAMETER[\"False_Easting\",300000.0],PARAMETER[\"False_Northing\",-2299363.487823496],PARAMETER[\"Central_Meridian\",140.0],PARAMETER[\"Standard_Parallel_1\",-67.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2985]]",
        2986=>"PROJCS[\"Perroud_1950_Terre_Adelie_Polar_Stereographic\",GEOGCS[\"GCS_Pointe_Geologie_Perroud_1950\",DATUM[\"D_Pointe_Geologie_Perroud_1950\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Stereographic_South_Pole\"],PARAMETER[\"False_Easting\",300000.0],PARAMETER[\"False_Northing\",-2299363.487823496],PARAMETER[\"Central_Meridian\",140.0],PARAMETER[\"Standard_Parallel_1\",-67.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2986]]",
        2987=>"PROJCS[\"Saint_Pierre_et_Miquelon_1950_UTM_21N\",GEOGCS[\"GCS_Saint_Pierre_et_Miquelon_1950\",DATUM[\"D_Saint_Pierre_et_Miquelon_1950\",SPHEROID[\"Clarke_1866\",6378206.4,294.9786982]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-57.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2987]]",
        2988=>"PROJCS[\"MOP78_UTM_1S\",GEOGCS[\"GCS_MOP78\",DATUM[\"D_MOP78\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",10000000.0],PARAMETER[\"Central_Meridian\",-177.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2988]]",
        2991=>"PROJCS[\"NAD_1983_Oregon_Statewide_Lambert\",GEOGCS[\"GCS_North_American_1983\",DATUM[\"D_North_American_1983\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",400000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-120.5],PARAMETER[\"Standard_Parallel_1\",43.0],PARAMETER[\"Standard_Parallel_2\",45.5],PARAMETER[\"Latitude_Of_Origin\",41.75],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2991]]",
        2992=>"PROJCS[\"NAD_1983_Oregon_Statewide_Lambert_Feet_Intl\",GEOGCS[\"GCS_North_American_1983\",DATUM[\"D_North_American_1983\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",1312335.958005249],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-120.5],PARAMETER[\"Standard_Parallel_1\",43.0],PARAMETER[\"Standard_Parallel_2\",45.5],PARAMETER[\"Latitude_Of_Origin\",41.75],UNIT[\"Foot\",0.3048],AUTHORITY[\"EPSG\",2992]]",
        2993=>"PROJCS[\"NAD_1983_HARN_Oregon_Statewide_Lambert\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",400000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-120.5],PARAMETER[\"Standard_Parallel_1\",43.0],PARAMETER[\"Standard_Parallel_2\",45.5],PARAMETER[\"Latitude_Of_Origin\",41.75],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2993]]",
        2994=>"PROJCS[\"NAD_1983_HARN_Oregon_Statewide_Lambert_Feet_Intl\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",1312335.958005249],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-120.5],PARAMETER[\"Standard_Parallel_1\",43.0],PARAMETER[\"Standard_Parallel_2\",45.5],PARAMETER[\"Latitude_Of_Origin\",41.75],UNIT[\"Foot\",0.3048],AUTHORITY[\"EPSG\",2994]]",
        2995=>"PROJCS[\"IGN53_Mare_UTM_58S\",GEOGCS[\"GCS_IGN53_Mare\",DATUM[\"D_IGN53_Mare\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",10000000.0],PARAMETER[\"Central_Meridian\",165.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2995]]",
        2996=>"PROJCS[\"ST84_Ile_des_Pins_UTM_58S\",GEOGCS[\"GCS_ST84_Ile_des_Pins\",DATUM[\"D_ST84_Ile_des_Pins\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",10000000.0],PARAMETER[\"Central_Meridian\",165.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2996]]",
        2997=>"PROJCS[\"ST71_Belep_UTM_58S\",GEOGCS[\"GCS_ST71_Belep\",DATUM[\"D_ST71_Belep\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",10000000.0],PARAMETER[\"Central_Meridian\",165.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2997]]",
        2998=>"PROJCS[\"NEA74_Noumea_UTM_58S\",GEOGCS[\"GCS_NEA74_Noumea\",DATUM[\"D_NEA74_Noumea\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",10000000.0],PARAMETER[\"Central_Meridian\",165.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2998]]",
        2999=>"PROJCS[\"Grand_Comoros_UTM_38S\",GEOGCS[\"GCS_Grand_Comoros\",DATUM[\"D_Grand_Comoros\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",10000000.0],PARAMETER[\"Central_Meridian\",45.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",2999]]",
        3000=>"PROJCS[\"Gunung_Segara_NEIEZ\",GEOGCS[\"GCS_Gunung_Segara\",DATUM[\"D_Gunung_Segara\",SPHEROID[\"Bessel_1841\",6377397.155,299.1528128]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Mercator\"],PARAMETER[\"False_Easting\",3900000.0],PARAMETER[\"False_Northing\",900000.0],PARAMETER[\"Central_Meridian\",110.0],PARAMETER[\"Standard_Parallel_1\",4.45405154589751],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3000]]",
        3001=>"PROJCS[\"Batavia_NEIEZ\",GEOGCS[\"GCS_Batavia\",DATUM[\"D_Batavia\",SPHEROID[\"Bessel_1841\",6377397.155,299.1528128]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Mercator\"],PARAMETER[\"False_Easting\",3900000.0],PARAMETER[\"False_Northing\",900000.0],PARAMETER[\"Central_Meridian\",110.0],PARAMETER[\"Standard_Parallel_1\",4.45405154589751],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3001]]",
        3002=>"PROJCS[\"Makassar_NEIEZ\",GEOGCS[\"GCS_Makassar\",DATUM[\"D_Makassar\",SPHEROID[\"Bessel_1841\",6377397.155,299.1528128]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Mercator\"],PARAMETER[\"False_Easting\",3900000.0],PARAMETER[\"False_Northing\",900000.0],PARAMETER[\"Central_Meridian\",110.0],PARAMETER[\"Standard_Parallel_1\",4.45405154589751],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3002]]",
        3003=>"PROJCS[\"Monte_Mario_Italy_1\",GEOGCS[\"GCS_Monte_Mario\",DATUM[\"D_Monte_Mario\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",1500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",9.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3003]]",
        3004=>"PROJCS[\"Monte_Mario_Italy_2\",GEOGCS[\"GCS_Monte_Mario\",DATUM[\"D_Monte_Mario\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",2520000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",15.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3004]]",
        3005=>"PROJCS[\"NAD_1983_BC_Environment_Albers\",GEOGCS[\"GCS_North_American_1983\",DATUM[\"D_North_American_1983\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Albers\"],PARAMETER[\"False_Easting\",1000000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-126.0],PARAMETER[\"Standard_Parallel_1\",50.0],PARAMETER[\"Standard_Parallel_2\",58.5],PARAMETER[\"Latitude_Of_Origin\",45.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3005]]",
        3006=>"PROJCS[\"SWEREF99_TM\",GEOGCS[\"GCS_SWEREF99\",DATUM[\"D_SWEREF99\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",15.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3006]]",
        3007=>"PROJCS[\"SWEREF99_12_00\",GEOGCS[\"GCS_SWEREF99\",DATUM[\"D_SWEREF99\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",150000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",12.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3007]]",
        3008=>"PROJCS[\"SWEREF99_13_30\",GEOGCS[\"GCS_SWEREF99\",DATUM[\"D_SWEREF99\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",150000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",13.5],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3008]]",
        3009=>"PROJCS[\"SWEREF99_15_00\",GEOGCS[\"GCS_SWEREF99\",DATUM[\"D_SWEREF99\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",150000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",15.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3009]]",
        3010=>"PROJCS[\"SWEREF99_16_30\",GEOGCS[\"GCS_SWEREF99\",DATUM[\"D_SWEREF99\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",150000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",16.5],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3010]]",
        3011=>"PROJCS[\"SWEREF99_18_00\",GEOGCS[\"GCS_SWEREF99\",DATUM[\"D_SWEREF99\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",150000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",18.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3011]]",
        3012=>"PROJCS[\"SWEREF99_14_15\",GEOGCS[\"GCS_SWEREF99\",DATUM[\"D_SWEREF99\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",150000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",14.25],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3012]]",
        3013=>"PROJCS[\"SWEREF99_15_45\",GEOGCS[\"GCS_SWEREF99\",DATUM[\"D_SWEREF99\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",150000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",15.75],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3013]]",
        3014=>"PROJCS[\"SWEREF99_17_15\",GEOGCS[\"GCS_SWEREF99\",DATUM[\"D_SWEREF99\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",150000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",17.25],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3014]]",
        3015=>"PROJCS[\"SWEREF99_18_45\",GEOGCS[\"GCS_SWEREF99\",DATUM[\"D_SWEREF99\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",150000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",18.75],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3015]]",
        3016=>"PROJCS[\"SWEREF99_20_15\",GEOGCS[\"GCS_SWEREF99\",DATUM[\"D_SWEREF99\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",150000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",20.25],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3016]]",
        3017=>"PROJCS[\"SWEREF99_21_45\",GEOGCS[\"GCS_SWEREF99\",DATUM[\"D_SWEREF99\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",150000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",21.75],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3017]]",
        3018=>"PROJCS[\"SWEREF99_23_15\",GEOGCS[\"GCS_SWEREF99\",DATUM[\"D_SWEREF99\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",150000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",23.25],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3018]]",
        3019=>"PROJCS[\"RT90_75_gon_V\",GEOGCS[\"GCS_RT_1990\",DATUM[\"D_RT_1990\",SPHEROID[\"Bessel_1841\",6377397.155,299.1528128]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",1500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",11.30827777777778],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3019]]",
        3020=>"PROJCS[\"RT90_5_gon_V\",GEOGCS[\"GCS_RT_1990\",DATUM[\"D_RT_1990\",SPHEROID[\"Bessel_1841\",6377397.155,299.1528128]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",1500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",13.55827777777778],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3020]]",
        3021=>"PROJCS[\"RT90_25_gon_V\",GEOGCS[\"GCS_RT_1990\",DATUM[\"D_RT_1990\",SPHEROID[\"Bessel_1841\",6377397.155,299.1528128]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",1500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",15.80827777777778],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3021]]",
        3022=>"PROJCS[\"RT90_0_gon\",GEOGCS[\"GCS_RT_1990\",DATUM[\"D_RT_1990\",SPHEROID[\"Bessel_1841\",6377397.155,299.1528128]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",1500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",18.05827777777778],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3022]]",
        3023=>"PROJCS[\"RT90_25_gon_O\",GEOGCS[\"GCS_RT_1990\",DATUM[\"D_RT_1990\",SPHEROID[\"Bessel_1841\",6377397.155,299.1528128]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",1500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",20.30827777777778],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3023]]",
        3024=>"PROJCS[\"RT90_5_gon_O\",GEOGCS[\"GCS_RT_1990\",DATUM[\"D_RT_1990\",SPHEROID[\"Bessel_1841\",6377397.155,299.1528128]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",1500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",22.55827777777778],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3024]]",
        3025=>"PROJCS[\"RT38_75_gon_V\",GEOGCS[\"GCS_RT38\",DATUM[\"D_Stockholm_1938\",SPHEROID[\"Bessel_1841\",6377397.155,299.1528128]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",1500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",11.30827777777778],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3025]]",
        3026=>"PROJCS[\"RT38_5_gon_V\",GEOGCS[\"GCS_RT38\",DATUM[\"D_Stockholm_1938\",SPHEROID[\"Bessel_1841\",6377397.155,299.1528128]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",1500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",13.55827777777778],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3026]]",
        3027=>"PROJCS[\"RT38_25_gon_V\",GEOGCS[\"GCS_RT38\",DATUM[\"D_Stockholm_1938\",SPHEROID[\"Bessel_1841\",6377397.155,299.1528128]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",1500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",15.80827777777778],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3027]]",
        3028=>"PROJCS[\"RT38_0_gon\",GEOGCS[\"GCS_RT38\",DATUM[\"D_Stockholm_1938\",SPHEROID[\"Bessel_1841\",6377397.155,299.1528128]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",1500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",18.05827777777778],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3028]]",
        3029=>"PROJCS[\"RT38_25_gon_O\",GEOGCS[\"GCS_RT38\",DATUM[\"D_Stockholm_1938\",SPHEROID[\"Bessel_1841\",6377397.155,299.1528128]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",1500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",20.30827777777778],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3029]]",
        3030=>"PROJCS[\"RT38_5_gon_O\",GEOGCS[\"GCS_RT38\",DATUM[\"D_Stockholm_1938\",SPHEROID[\"Bessel_1841\",6377397.155,299.1528128]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",1500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",22.55827777777778],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3030]]",
        3031=>"PROJCS[\"WGS_1984_Antarctic_Polar_Stereographic\",GEOGCS[\"GCS_WGS_1984\",DATUM[\"D_WGS_1984\",SPHEROID[\"WGS_1984\",6378137.0,298.257223563]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Stereographic_South_Pole\"],PARAMETER[\"False_Easting\",0.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",0.0],PARAMETER[\"Standard_Parallel_1\",-71.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3031]]",
        3032=>"PROJCS[\"WGS_1984_Australian_Antarctic_Polar_Stereographic\",GEOGCS[\"GCS_WGS_1984\",DATUM[\"D_WGS_1984\",SPHEROID[\"WGS_1984\",6378137.0,298.257223563]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Stereographic_South_Pole\"],PARAMETER[\"False_Easting\",6000000.0],PARAMETER[\"False_Northing\",6000000.0],PARAMETER[\"Central_Meridian\",70.0],PARAMETER[\"Standard_Parallel_1\",-71.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3032]]",
        3033=>"PROJCS[\"WGS_1984_Australian_Antarctic_Lambert\",GEOGCS[\"GCS_WGS_1984\",DATUM[\"D_WGS_1984\",SPHEROID[\"WGS_1984\",6378137.0,298.257223563]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",6000000.0],PARAMETER[\"False_Northing\",6000000.0],PARAMETER[\"Central_Meridian\",70.0],PARAMETER[\"Standard_Parallel_1\",-68.5],PARAMETER[\"Standard_Parallel_2\",-74.5],PARAMETER[\"Latitude_Of_Origin\",-50.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3033]]",
        3034=>"PROJCS[\"ETRS_1989_LCC\",GEOGCS[\"GCS_ETRS_1989\",DATUM[\"D_ETRS_1989\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",4000000.0],PARAMETER[\"False_Northing\",2800000.0],PARAMETER[\"Central_Meridian\",10.0],PARAMETER[\"Standard_Parallel_1\",35.0],PARAMETER[\"Standard_Parallel_2\",65.0],PARAMETER[\"Latitude_Of_Origin\",52.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3034]]",
        3035=>"PROJCS[\"ETRS_1989_LAEA\",GEOGCS[\"GCS_ETRS_1989\",DATUM[\"D_ETRS_1989\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Azimuthal_Equal_Area\"],PARAMETER[\"False_Easting\",4321000.0],PARAMETER[\"False_Northing\",3210000.0],PARAMETER[\"Central_Meridian\",10.0],PARAMETER[\"Latitude_Of_Origin\",52.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3035]]",
        3036=>"PROJCS[\"Moznet_UTM_Zone_36S\",GEOGCS[\"GCS_Moznet\",DATUM[\"D_Moznet\",SPHEROID[\"WGS_1984\",6378137.0,298.257223563]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",10000000.0],PARAMETER[\"Central_Meridian\",33.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3036]]",
        3037=>"PROJCS[\"Moznet_UTM_Zone_37S\",GEOGCS[\"GCS_Moznet\",DATUM[\"D_Moznet\",SPHEROID[\"WGS_1984\",6378137.0,298.257223563]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",10000000.0],PARAMETER[\"Central_Meridian\",39.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3037]]",
        3038=>"PROJCS[\"ETRS_1989_ETRS-TM26\",GEOGCS[\"GCS_ETRS_1989\",DATUM[\"D_ETRS_1989\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-27.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3038]]",
        3039=>"PROJCS[\"ETRS_1989_ETRS-TM27\",GEOGCS[\"GCS_ETRS_1989\",DATUM[\"D_ETRS_1989\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-21.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3039]]",
        3040=>"PROJCS[\"ETRS_1989_ETRS-TM28\",GEOGCS[\"GCS_ETRS_1989\",DATUM[\"D_ETRS_1989\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-15.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3040]]",
        3041=>"PROJCS[\"ETRS_1989_ETRS-TM29\",GEOGCS[\"GCS_ETRS_1989\",DATUM[\"D_ETRS_1989\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-9.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3041]]",
        3042=>"PROJCS[\"ETRS_1989_ETRS-TM30\",GEOGCS[\"GCS_ETRS_1989\",DATUM[\"D_ETRS_1989\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-3.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3042]]",
        3043=>"PROJCS[\"ETRS_1989_ETRS-TM31\",GEOGCS[\"GCS_ETRS_1989\",DATUM[\"D_ETRS_1989\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",3.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3043]]",
        3044=>"PROJCS[\"ETRS_1989_ETRS-TM32\",GEOGCS[\"GCS_ETRS_1989\",DATUM[\"D_ETRS_1989\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",9.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3044]]",
        3045=>"PROJCS[\"ETRS_1989_ETRS-TM33\",GEOGCS[\"GCS_ETRS_1989\",DATUM[\"D_ETRS_1989\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",15.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3045]]",
        3046=>"PROJCS[\"ETRS_1989_ETRS-TM34\",GEOGCS[\"GCS_ETRS_1989\",DATUM[\"D_ETRS_1989\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",21.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3046]]",
        3047=>"PROJCS[\"ETRS_1989_ETRS-TM35\",GEOGCS[\"GCS_ETRS_1989\",DATUM[\"D_ETRS_1989\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",27.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3047]]",
        3048=>"PROJCS[\"ETRS_1989_ETRS-TM36\",GEOGCS[\"GCS_ETRS_1989\",DATUM[\"D_ETRS_1989\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",33.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3048]]",
        3049=>"PROJCS[\"ETRS_1989_ETRS-TM37\",GEOGCS[\"GCS_ETRS_1989\",DATUM[\"D_ETRS_1989\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",39.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3049]]",
        3050=>"PROJCS[\"ETRS_1989_ETRS-TM38\",GEOGCS[\"GCS_ETRS_1989\",DATUM[\"D_ETRS_1989\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",45.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3050]]",
        3051=>"PROJCS[\"ETRS_1989_ETRS-TM39\",GEOGCS[\"GCS_ETRS_1989\",DATUM[\"D_ETRS_1989\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",51.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3051]]",
        3054=>"PROJCS[\"Hjorsey_1955_UTM_Zone_26N\",GEOGCS[\"GCS_Hjorsey_1955\",DATUM[\"D_Hjorsey_1955\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-27.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3054]]",
        3055=>"PROJCS[\"Hjorsey_1955_UTM_Zone_27N\",GEOGCS[\"GCS_Hjorsey_1955\",DATUM[\"D_Hjorsey_1955\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-21.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3055]]",
        3056=>"PROJCS[\"Hjorsey_1955_UTM_Zone_28N\",GEOGCS[\"GCS_Hjorsey_1955\",DATUM[\"D_Hjorsey_1955\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-15.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3056]]",
        3057=>"PROJCS[\"ISN_1993_Lambert_1993\",GEOGCS[\"GCS_ISN_1993\",DATUM[\"D_Islands_Network_1993\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",500000.0],PARAMETER[\"Central_Meridian\",-19.0],PARAMETER[\"Standard_Parallel_1\",64.25],PARAMETER[\"Standard_Parallel_2\",65.75],PARAMETER[\"Latitude_Of_Origin\",65.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3057]]",
        3058=>"PROJCS[\"Helle_1954_Jan_Mayen_Grid\",GEOGCS[\"GCS_Helle_1954\",DATUM[\"D_Helle_1954\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",50000.0],PARAMETER[\"False_Northing\",-7800000.0],PARAMETER[\"Central_Meridian\",-8.5],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3058]]",
        3059=>"PROJCS[\"LKS_1992_Latvia_TM\",GEOGCS[\"GCS_LKS_1992\",DATUM[\"D_Latvia_1992\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",-6000000.0],PARAMETER[\"Central_Meridian\",24.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3059]]",
        3060=>"PROJCS[\"IGN72_Grande_Terre_UTM_58S\",GEOGCS[\"GCS_IGN72_Grande_Terre\",DATUM[\"D_IGN72_Grande_Terre\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",10000000.0],PARAMETER[\"Central_Meridian\",165.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3060]]",
        3061=>"PROJCS[\"Porto_Santo_1995_UTM_Zone_28N\",GEOGCS[\"GCS_Porto_Santo_1995\",DATUM[\"D_Porto_Santo_1995\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-15.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3061]]",
        3062=>"PROJCS[\"Azores_Oriental_1995_UTM_Zone_26N\",GEOGCS[\"GCS_Azores_Oriental_1995\",DATUM[\"D_Azores_Oriental_Islands_1995\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-27.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3062]]",
        3063=>"PROJCS[\"Azores_Central_1995_UTM_Zone_26N\",GEOGCS[\"GCS_Azores_Central_1995\",DATUM[\"D_Azores_Central_Islands_1995\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-27.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3063]]",
        3064=>"PROJCS[\"IGM_1995_UTM_Zone_32N\",GEOGCS[\"GCS_IGM_1995\",DATUM[\"D_IGM_1995\",SPHEROID[\"WGS_1984\",6378137.0,298.257223563]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",9.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3064]]",
        3065=>"PROJCS[\"IGM_1995_UTM_Zone_33N\",GEOGCS[\"GCS_IGM_1995\",DATUM[\"D_IGM_1995\",SPHEROID[\"WGS_1984\",6378137.0,298.257223563]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",15.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3065]]",
        3066=>"PROJCS[\"ED_1950_Jordan_TM\",GEOGCS[\"GCS_European_1950\",DATUM[\"D_European_1950\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",-3000000.0],PARAMETER[\"Central_Meridian\",37.0],PARAMETER[\"Scale_Factor\",0.9998],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3066]]",
        3067=>"PROJCS[\"EUREF_FIN_TM35FIN\",GEOGCS[\"GCS_EUREF_FIN\",DATUM[\"D_ETRS_1989\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",27.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3067]]",
        3068=>"PROJCS[\"DHDN_Soldner_Berlin\",GEOGCS[\"GCS_Deutsches_Hauptdreiecksnetz\",DATUM[\"D_Deutsches_Hauptdreiecksnetz\",SPHEROID[\"Bessel_1841\",6377397.155,299.1528128]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Cassini\"],PARAMETER[\"False_Easting\",40000.0],PARAMETER[\"False_Northing\",10000.0],PARAMETER[\"Central_Meridian\",13.62720366666667],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",52.41864827777778],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3068]]",
        3069=>"PROJCS[\"NAD_1927_Wisconsin_TM\",GEOGCS[\"GCS_North_American_1927\",DATUM[\"D_North_American_1927\",SPHEROID[\"Clarke_1866\",6378206.4,294.9786982]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",-4500000.0],PARAMETER[\"Central_Meridian\",-90.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3069]]",
        3070=>"PROJCS[\"NAD_1983_Wisconsin_TM\",GEOGCS[\"GCS_North_American_1983\",DATUM[\"D_North_American_1983\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",520000.0],PARAMETER[\"False_Northing\",-4480000.0],PARAMETER[\"Central_Meridian\",-90.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3070]]",
        3071=>"PROJCS[\"NAD_1983_HARN_Wisconsin_TM\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",520000.0],PARAMETER[\"False_Northing\",-4480000.0],PARAMETER[\"Central_Meridian\",-90.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3071]]",
        3072=>"PROJCS[\"NAD_1983_Maine_2000_East_Zone\",GEOGCS[\"GCS_North_American_1983\",DATUM[\"D_North_American_1983\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",700000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-67.875],PARAMETER[\"Scale_Factor\",0.99998],PARAMETER[\"Latitude_Of_Origin\",43.83333333333334],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3072]]",
        3073=>"PROJCS[\"NAD_1983_Maine_2000_Central_Zone\",GEOGCS[\"GCS_North_American_1983\",DATUM[\"D_North_American_1983\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-69.125],PARAMETER[\"Scale_Factor\",0.99998],PARAMETER[\"Latitude_Of_Origin\",43.5],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3463]]",
        3074=>"PROJCS[\"NAD_1983_Maine_2000_West_Zone\",GEOGCS[\"GCS_North_American_1983\",DATUM[\"D_North_American_1983\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",300000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-70.375],PARAMETER[\"Scale_Factor\",0.99998],PARAMETER[\"Latitude_Of_Origin\",42.83333333333334],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3074]]",
        3075=>"PROJCS[\"NAD_1983_HARN_Maine_2000_East_Zone\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",700000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-67.875],PARAMETER[\"Scale_Factor\",0.99998],PARAMETER[\"Latitude_Of_Origin\",43.83333333333334],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3075]]",
        3076=>"PROJCS[\"NAD_1983_HARN_Maine_2000_Central_Zone\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-69.125],PARAMETER[\"Scale_Factor\",0.99998],PARAMETER[\"Latitude_Of_Origin\",43.5],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3464]]",
        3077=>"PROJCS[\"NAD_1983_HARN_Maine_2000_West_Zone\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",300000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-70.375],PARAMETER[\"Scale_Factor\",0.99998],PARAMETER[\"Latitude_Of_Origin\",42.83333333333334],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3077]]",
        3078=>"PROJCS[\"NAD_1983_Michigan_GeoRef_Meters\",GEOGCS[\"GCS_North_American_1983\",DATUM[\"D_North_American_1983\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Hotine_Oblique_Mercator_Azimuth_Natural_Origin\"],PARAMETER[\"False_Easting\",2546731.496],PARAMETER[\"False_Northing\",-4354009.816],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Azimuth\",337.25556],PARAMETER[\"Longitude_Of_Center\",-86.0],PARAMETER[\"Latitude_Of_Center\",45.30916666666666],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3078]]",
        3079=>"PROJCS[\"NAD_1983_HARN_Michigan_GeoRef_Meters\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Hotine_Oblique_Mercator_Azimuth_Natural_Origin\"],PARAMETER[\"False_Easting\",2546731.496],PARAMETER[\"False_Northing\",-4354009.816],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Azimuth\",337.25556],PARAMETER[\"Longitude_Of_Center\",-86.0],PARAMETER[\"Latitude_Of_Center\",45.30916666666666],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3079]]",
        3080=>"PROJCS[\"NAD_1927_Texas_Statewide_Mapping_System\",GEOGCS[\"GCS_North_American_1927\",DATUM[\"D_North_American_1927\",SPHEROID[\"Clarke_1866\",6378206.4,294.9786982]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",3000000.0],PARAMETER[\"False_Northing\",3000000.0],PARAMETER[\"Central_Meridian\",-100.0],PARAMETER[\"Standard_Parallel_1\",27.41666666666667],PARAMETER[\"Standard_Parallel_2\",34.91666666666666],PARAMETER[\"Latitude_Of_Origin\",31.16666666666667],UNIT[\"Foot\",0.3048],AUTHORITY[\"EPSG\",3080]]",
        3081=>"PROJCS[\"NAD_1983_Texas_Statewide_Mapping_System\",GEOGCS[\"GCS_North_American_1983\",DATUM[\"D_North_American_1983\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",1000000.0],PARAMETER[\"False_Northing\",1000000.0],PARAMETER[\"Central_Meridian\",-100.0],PARAMETER[\"Standard_Parallel_1\",27.41666666666667],PARAMETER[\"Standard_Parallel_2\",34.91666666666666],PARAMETER[\"Latitude_Of_Origin\",31.16666666666667],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3081]]",
        3082=>"PROJCS[\"NAD_1983_Texas_Centric_Mapping_System_Lambert\",GEOGCS[\"GCS_North_American_1983\",DATUM[\"D_North_American_1983\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",1500000.0],PARAMETER[\"False_Northing\",5000000.0],PARAMETER[\"Central_Meridian\",-100.0],PARAMETER[\"Standard_Parallel_1\",27.5],PARAMETER[\"Standard_Parallel_2\",35.0],PARAMETER[\"Latitude_Of_Origin\",18.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3082]]",
        3083=>"PROJCS[\"NAD_1983_Texas_Centric_Mapping_System_Albers\",GEOGCS[\"GCS_North_American_1983\",DATUM[\"D_North_American_1983\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Albers\"],PARAMETER[\"False_Easting\",1500000.0],PARAMETER[\"False_Northing\",6000000.0],PARAMETER[\"Central_Meridian\",-100.0],PARAMETER[\"Standard_Parallel_1\",27.5],PARAMETER[\"Standard_Parallel_2\",35.0],PARAMETER[\"Latitude_Of_Origin\",18.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3083]]",
        3084=>"PROJCS[\"NAD_1983_HARN_Texas_Centric_Mapping_System_Lambert\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",1500000.0],PARAMETER[\"False_Northing\",5000000.0],PARAMETER[\"Central_Meridian\",-100.0],PARAMETER[\"Standard_Parallel_1\",27.5],PARAMETER[\"Standard_Parallel_2\",35.0],PARAMETER[\"Latitude_Of_Origin\",18.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3084]]",
        3085=>"PROJCS[\"NAD_1983_HARN_Texas_Centric_Mapping_System_Albers\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Albers\"],PARAMETER[\"False_Easting\",1500000.0],PARAMETER[\"False_Northing\",6000000.0],PARAMETER[\"Central_Meridian\",-100.0],PARAMETER[\"Standard_Parallel_1\",27.5],PARAMETER[\"Standard_Parallel_2\",35.0],PARAMETER[\"Latitude_Of_Origin\",18.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3085]]",
        3086=>"PROJCS[\"NAD_1983_Florida_GDL_Albers\",GEOGCS[\"GCS_North_American_1983\",DATUM[\"D_North_American_1983\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Albers\"],PARAMETER[\"False_Easting\",400000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-84.0],PARAMETER[\"Standard_Parallel_1\",24.0],PARAMETER[\"Standard_Parallel_2\",31.5],PARAMETER[\"Latitude_Of_Origin\",24.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3086]]",
        3087=>"PROJCS[\"NAD_1983_HARN_Florida_GDL_Albers\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Albers\"],PARAMETER[\"False_Easting\",400000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-84.0],PARAMETER[\"Standard_Parallel_1\",24.0],PARAMETER[\"Standard_Parallel_2\",31.5],PARAMETER[\"Latitude_Of_Origin\",24.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3087]]",
        3088=>"PROJCS[\"NAD_1983_StatePlane_Kentucky_FIPS_1600\",GEOGCS[\"GCS_North_American_1983\",DATUM[\"D_North_American_1983\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",1500000.0],PARAMETER[\"False_Northing\",1000000.0],PARAMETER[\"Central_Meridian\",-85.75],PARAMETER[\"Standard_Parallel_1\",37.08333333333334],PARAMETER[\"Standard_Parallel_2\",38.66666666666666],PARAMETER[\"Latitude_Of_Origin\",36.33333333333334],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3088]]",
        3089=>"PROJCS[\"NAD_1983_StatePlane_Kentucky_FIPS_1600_Feet\",GEOGCS[\"GCS_North_American_1983\",DATUM[\"D_North_American_1983\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",4921250.0],PARAMETER[\"False_Northing\",3280833.333333333],PARAMETER[\"Central_Meridian\",-85.75],PARAMETER[\"Standard_Parallel_1\",37.08333333333334],PARAMETER[\"Standard_Parallel_2\",38.66666666666666],PARAMETER[\"Latitude_Of_Origin\",36.33333333333334],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",3089]]",
        3090=>"PROJCS[\"NAD_1983_HARN_StatePlane_Kentucky_FIPS_1600\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",1500000.0],PARAMETER[\"False_Northing\",1000000.0],PARAMETER[\"Central_Meridian\",-85.75],PARAMETER[\"Standard_Parallel_1\",37.08333333333334],PARAMETER[\"Standard_Parallel_2\",38.66666666666666],PARAMETER[\"Latitude_Of_Origin\",36.33333333333334],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3090]]",
        3091=>"PROJCS[\"NAD_1983_HARN_StatePlane_Kentucky_FIPS_1600_Feet\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",4921250.0],PARAMETER[\"False_Northing\",3280833.333333333],PARAMETER[\"Central_Meridian\",-85.75],PARAMETER[\"Standard_Parallel_1\",37.08333333333334],PARAMETER[\"Standard_Parallel_2\",38.66666666666666],PARAMETER[\"Latitude_Of_Origin\",36.33333333333334],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",3091]]",
        3092=>"PROJCS[\"Tokyo_UTM_Zone_51N\",GEOGCS[\"GCS_Tokyo\",DATUM[\"D_Tokyo\",SPHEROID[\"Bessel_1841\",6377397.155,299.1528128]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",123.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3092]]",
        3093=>"PROJCS[\"Tokyo_UTM_Zone_52N\",GEOGCS[\"GCS_Tokyo\",DATUM[\"D_Tokyo\",SPHEROID[\"Bessel_1841\",6377397.155,299.1528128]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",129.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3093]]",
        3094=>"PROJCS[\"Tokyo_UTM_Zone_53N\",GEOGCS[\"GCS_Tokyo\",DATUM[\"D_Tokyo\",SPHEROID[\"Bessel_1841\",6377397.155,299.1528128]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",135.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3094]]",
        3095=>"PROJCS[\"Tokyo_UTM_Zone_54N\",GEOGCS[\"GCS_Tokyo\",DATUM[\"D_Tokyo\",SPHEROID[\"Bessel_1841\",6377397.155,299.1528128]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",141.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3095]]",
        3096=>"PROJCS[\"Tokyo_UTM_Zone_55N\",GEOGCS[\"GCS_Tokyo\",DATUM[\"D_Tokyo\",SPHEROID[\"Bessel_1841\",6377397.155,299.1528128]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",147.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3096]]",
        3097=>"PROJCS[\"JGD_2000_UTM_Zone_51N\",GEOGCS[\"GCS_JGD_2000\",DATUM[\"D_JGD_2000\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",123.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3097]]",
        3098=>"PROJCS[\"JGD_2000_UTM_Zone_52N\",GEOGCS[\"GCS_JGD_2000\",DATUM[\"D_JGD_2000\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",129.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3098]]",
        3099=>"PROJCS[\"JGD_2000_UTM_Zone_53N\",GEOGCS[\"GCS_JGD_2000\",DATUM[\"D_JGD_2000\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",135.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3099]]",
        3100=>"PROJCS[\"JGD_2000_UTM_Zone_54N\",GEOGCS[\"GCS_JGD_2000\",DATUM[\"D_JGD_2000\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",141.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3100]]",
        3101=>"PROJCS[\"JGD_2000_UTM_Zone_55N\",GEOGCS[\"GCS_JGD_2000\",DATUM[\"D_JGD_2000\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",147.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3101]]",
        3102=>"PROJCS[\"Samoa_1962_Samoa_Lambert\",GEOGCS[\"GCS_American_Samoa_1962\",DATUM[\"D_American_Samoa_1962\",SPHEROID[\"Clarke_1866\",6378206.4,294.9786982]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",312234.65],PARAMETER[\"Central_Meridian\",-170.0],PARAMETER[\"Standard_Parallel_1\",-14.26666666666667],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",-14.26666666666667],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",3102]]",
        3106=>"PROJCS[\"Gulshan_303_Bangladesh_TM\",GEOGCS[\"GCS_Gulshan_303\",DATUM[\"D_Gulshan_303\",SPHEROID[\"Everest_Adjustment_1937\",6377276.345,300.8017]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",90.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3106]]",
        3107=>"PROJCS[\"GDA_1994_South_Australia_Lambert\",GEOGCS[\"GCS_GDA_1994\",DATUM[\"D_GDA_1994\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",1000000.0],PARAMETER[\"False_Northing\",2000000.0],PARAMETER[\"Central_Meridian\",135.0],PARAMETER[\"Standard_Parallel_1\",-28.0],PARAMETER[\"Standard_Parallel_2\",-36.0],PARAMETER[\"Latitude_Of_Origin\",-32.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3107]]",
        3108=>"PROJCS[\"ETRS_1989_Guernsey_Grid\",GEOGCS[\"GCS_ETRS_1989\",DATUM[\"D_ETRS_1989\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",47000.0],PARAMETER[\"False_Northing\",50000.0],PARAMETER[\"Central_Meridian\",-2.416666666666667],PARAMETER[\"Scale_Factor\",0.999997],PARAMETER[\"Latitude_Of_Origin\",49.5],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3108]]",
        3109=>"PROJCS[\"ETRS_1989_Jersey_Transverse_Mercator\",GEOGCS[\"GCS_ETRS_1989\",DATUM[\"D_ETRS_1989\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",40000.0],PARAMETER[\"False_Northing\",70000.0],PARAMETER[\"Central_Meridian\",-2.135],PARAMETER[\"Scale_Factor\",0.9999999],PARAMETER[\"Latitude_Of_Origin\",49.225],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3109]]",
        3110=>"PROJCS[\"AGD_1966_VICGRID\",GEOGCS[\"GCS_Australian_1966\",DATUM[\"D_Australian_1966\",SPHEROID[\"Australian\",6378160.0,298.25]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",2500000.0],PARAMETER[\"False_Northing\",4500000.0],PARAMETER[\"Central_Meridian\",145.0],PARAMETER[\"Standard_Parallel_1\",-36.0],PARAMETER[\"Standard_Parallel_2\",-38.0],PARAMETER[\"Latitude_Of_Origin\",-37.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3110]]",
        3111=>"PROJCS[\"GDA_1994_VICGRID94\",GEOGCS[\"GCS_GDA_1994\",DATUM[\"D_GDA_1994\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",2500000.0],PARAMETER[\"False_Northing\",2500000.0],PARAMETER[\"Central_Meridian\",145.0],PARAMETER[\"Standard_Parallel_1\",-36.0],PARAMETER[\"Standard_Parallel_2\",-38.0],PARAMETER[\"Latitude_Of_Origin\",-37.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3111]]",
        3112=>"PROJCS[\"GDA_1994_Geoscience_Australia_Lambert\",GEOGCS[\"GCS_GDA_1994\",DATUM[\"D_GDA_1994\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",0.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",134.0],PARAMETER[\"Standard_Parallel_1\",-18.0],PARAMETER[\"Standard_Parallel_2\",-36.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3112]]",
        3113=>"PROJCS[\"GDA_1994_BCSG02\",GEOGCS[\"GCS_GDA_1994\",DATUM[\"D_GDA_1994\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",50000.0],PARAMETER[\"False_Northing\",100000.0],PARAMETER[\"Central_Meridian\",153.0],PARAMETER[\"Scale_Factor\",0.99999],PARAMETER[\"Latitude_Of_Origin\",-28.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3113]]",
        3114=>"PROJCS[\"MAGNA_Colombia_Oeste_Oeste\",GEOGCS[\"GCS_MAGNA\",DATUM[\"D_MAGNA\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",1000000.0],PARAMETER[\"False_Northing\",1000000.0],PARAMETER[\"Central_Meridian\",-80.07750791666666],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",4.596200416666666],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3114]]",
        3115=>"PROJCS[\"MAGNA_Colombia_Oeste\",GEOGCS[\"GCS_MAGNA\",DATUM[\"D_MAGNA\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",1000000.0],PARAMETER[\"False_Northing\",1000000.0],PARAMETER[\"Central_Meridian\",-77.07750791666666],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",4.596200416666666],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3115]]",
        3116=>"PROJCS[\"MAGNA_Colombia_Bogota\",GEOGCS[\"GCS_MAGNA\",DATUM[\"D_MAGNA\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",1000000.0],PARAMETER[\"False_Northing\",1000000.0],PARAMETER[\"Central_Meridian\",-74.07750791666666],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",4.596200416666666],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3116]]",
        3117=>"PROJCS[\"MAGNA_Colombia_Este\",GEOGCS[\"GCS_MAGNA\",DATUM[\"D_MAGNA\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",1000000.0],PARAMETER[\"False_Northing\",1000000.0],PARAMETER[\"Central_Meridian\",-71.07750791666666],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",4.596200416666666],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3117]]",
        3118=>"PROJCS[\"MAGNA_Colombia_Este_Este\",GEOGCS[\"GCS_MAGNA\",DATUM[\"D_MAGNA\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",1000000.0],PARAMETER[\"False_Northing\",1000000.0],PARAMETER[\"Central_Meridian\",-68.07750791666666],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",4.596200416666666],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3118]]",
        3119=>"PROJCS[\"Douala_1948_AEF_West\",GEOGCS[\"GCS_Douala_1948\",DATUM[\"D_Douala_1948\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",1000000.0],PARAMETER[\"False_Northing\",1000000.0],PARAMETER[\"Central_Meridian\",10.5],PARAMETER[\"Scale_Factor\",0.999],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3119]]",
        3120=>"PROJCS[\"Pulkovo_1942_Adj_1958_Poland_Zone_I\",GEOGCS[\"GCS_Pulkovo_1942_Adj_1958\",DATUM[\"D_Pulkovo_1942_Adj_1958\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Double_Stereographic\"],PARAMETER[\"False_Easting\",4637000.0],PARAMETER[\"False_Northing\",5467000.0],PARAMETER[\"Central_Meridian\",21.08333333333333],PARAMETER[\"Scale_Factor\",0.9998],PARAMETER[\"Latitude_Of_Origin\",50.625],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3120]]",
        3121=>"PROJCS[\"PRS_1992_Philippines_Zone_I\",GEOGCS[\"GCS_PRS_1992\",DATUM[\"D_Philippine_Reference_System_1992\",SPHEROID[\"Clarke_1866\",6378206.4,294.9786982]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",117.0],PARAMETER[\"Scale_Factor\",0.99995],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3121]]",
        3122=>"PROJCS[\"PRS_1992_Philippines_Zone_II\",GEOGCS[\"GCS_PRS_1992\",DATUM[\"D_Philippine_Reference_System_1992\",SPHEROID[\"Clarke_1866\",6378206.4,294.9786982]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",119.0],PARAMETER[\"Scale_Factor\",0.99995],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3122]]",
        3123=>"PROJCS[\"PRS_1992_Philippines_Zone_III\",GEOGCS[\"GCS_PRS_1992\",DATUM[\"D_Philippine_Reference_System_1992\",SPHEROID[\"Clarke_1866\",6378206.4,294.9786982]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",121.0],PARAMETER[\"Scale_Factor\",0.99995],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3123]]",
        3124=>"PROJCS[\"PRS_1992_Philippines_Zone_IV\",GEOGCS[\"GCS_PRS_1992\",DATUM[\"D_Philippine_Reference_System_1992\",SPHEROID[\"Clarke_1866\",6378206.4,294.9786982]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",123.0],PARAMETER[\"Scale_Factor\",0.99995],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3124]]",
        3125=>"PROJCS[\"PRS_1992_Philippines_Zone_V\",GEOGCS[\"GCS_PRS_1992\",DATUM[\"D_Philippine_Reference_System_1992\",SPHEROID[\"Clarke_1866\",6378206.4,294.9786982]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",125.0],PARAMETER[\"Scale_Factor\",0.99995],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3125]]",
        3126=>"PROJCS[\"ETRS_1989_ETRS-GK19FIN\",GEOGCS[\"GCS_ETRS_1989\",DATUM[\"D_ETRS_1989\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",19.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3126]]",
        3127=>"PROJCS[\"ETRS_1989_ETRS-GK20FIN\",GEOGCS[\"GCS_ETRS_1989\",DATUM[\"D_ETRS_1989\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",20.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3127]]",
        3128=>"PROJCS[\"ETRS_1989_ETRS-GK21FIN\",GEOGCS[\"GCS_ETRS_1989\",DATUM[\"D_ETRS_1989\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",21.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3128]]",
        3129=>"PROJCS[\"ETRS_1989_ETRS-GK22FIN\",GEOGCS[\"GCS_ETRS_1989\",DATUM[\"D_ETRS_1989\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",22.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3129]]",
        3130=>"PROJCS[\"ETRS_1989_ETRS-GK23FIN\",GEOGCS[\"GCS_ETRS_1989\",DATUM[\"D_ETRS_1989\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",23.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3130]]",
        3131=>"PROJCS[\"ETRS_1989_ETRS-GK24FIN\",GEOGCS[\"GCS_ETRS_1989\",DATUM[\"D_ETRS_1989\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",24.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3131]]",
        3132=>"PROJCS[\"ETRS_1989_ETRS-GK25FIN\",GEOGCS[\"GCS_ETRS_1989\",DATUM[\"D_ETRS_1989\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",25.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3132]]",
        3133=>"PROJCS[\"ETRS_1989_ETRS-GK26FIN\",GEOGCS[\"GCS_ETRS_1989\",DATUM[\"D_ETRS_1989\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",26.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3133]]",
        3134=>"PROJCS[\"ETRS_1989_ETRS-GK27FIN\",GEOGCS[\"GCS_ETRS_1989\",DATUM[\"D_ETRS_1989\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",27.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3134]]",
        3135=>"PROJCS[\"ETRS_1989_ETRS-GK28FIN\",GEOGCS[\"GCS_ETRS_1989\",DATUM[\"D_ETRS_1989\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",28.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3135]]",
        3136=>"PROJCS[\"ETRS_1989_ETRS-GK29FIN\",GEOGCS[\"GCS_ETRS_1989\",DATUM[\"D_ETRS_1989\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",29.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3136]]",
        3137=>"PROJCS[\"ETRS_1989_ETRS-GK30FIN\",GEOGCS[\"GCS_ETRS_1989\",DATUM[\"D_ETRS_1989\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",30.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3137]]",
        3138=>"PROJCS[\"ETRS_1989_ETRS-GK31FIN\",GEOGCS[\"GCS_ETRS_1989\",DATUM[\"D_ETRS_1989\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",31.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3138]]",
        3141=>"PROJCS[\"Fiji_1956_UTM_Zone_60S\",GEOGCS[\"GCS_Fiji_1956\",DATUM[\"D_Fiji_1956\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",10000000.0],PARAMETER[\"Central_Meridian\",177.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3141]]",
        3142=>"PROJCS[\"Fiji_1956_UTM_Zone_1S\",GEOGCS[\"GCS_Fiji_1956\",DATUM[\"D_Fiji_1956\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",10000000.0],PARAMETER[\"Central_Meridian\",-177.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3142]]",
        3146=>"PROJCS[\"Pulkovo_1942_3_Degree_GK_Zone_6\",GEOGCS[\"GCS_Pulkovo_1942\",DATUM[\"D_Pulkovo_1942\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",6500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",18.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3146]]",
        3147=>"PROJCS[\"Pulkovo_1942_3_Degree_GK_CM_18E\",GEOGCS[\"GCS_Pulkovo_1942\",DATUM[\"D_Pulkovo_1942\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",18.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3147]]",
        3148=>"PROJCS[\"Indian_1960_UTM_Zone_48N\",GEOGCS[\"GCS_Indian_1960\",DATUM[\"D_Indian_1960\",SPHEROID[\"Everest_Adjustment_1937\",6377276.345,300.8017]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",105.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3148]]",
        3149=>"PROJCS[\"Indian_1960_UTM_Zone_49N\",GEOGCS[\"GCS_Indian_1960\",DATUM[\"D_Indian_1960\",SPHEROID[\"Everest_Adjustment_1937\",6377276.345,300.8017]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",111.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3149]]",
        3150=>"PROJCS[\"Pulkovo_1995_3_Degree_GK_Zone_6\",GEOGCS[\"GCS_Pulkovo_1995\",DATUM[\"D_Pulkovo_1995\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",6500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",18.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3150]]",
        3151=>"PROJCS[\"Pulkovo_1995_3_Degree_GK_CM_18E\",GEOGCS[\"GCS_Pulkovo_1995\",DATUM[\"D_Pulkovo_1995\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",18.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3151]]",
        3153=>"PROJCS[\"NAD_1983_CSRS_BC_Environment_Albers\",GEOGCS[\"GCS_North_American_1983_CSRS\",DATUM[\"D_North_American_1983_CSRS\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Albers\"],PARAMETER[\"False_Easting\",1000000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-126.0],PARAMETER[\"Standard_Parallel_1\",50.0],PARAMETER[\"Standard_Parallel_2\",58.5],PARAMETER[\"Latitude_Of_Origin\",45.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3153]]",
        3154=>"PROJCS[\"NAD_1983_CSRS_UTM_Zone_7N\",GEOGCS[\"GCS_North_American_1983_CSRS\",DATUM[\"D_North_American_1983_CSRS\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-141.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3154]]",
        3155=>"PROJCS[\"NAD_1983_CSRS_UTM_Zone_8N\",GEOGCS[\"GCS_North_American_1983_CSRS\",DATUM[\"D_North_American_1983_CSRS\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-135.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3155]]",
        3156=>"PROJCS[\"NAD_1983_CSRS_UTM_Zone_9N\",GEOGCS[\"GCS_North_American_1983_CSRS\",DATUM[\"D_North_American_1983_CSRS\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-129.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3156]]",
        3157=>"PROJCS[\"NAD_1983_CSRS_UTM_Zone_10N\",GEOGCS[\"GCS_North_American_1983_CSRS\",DATUM[\"D_North_American_1983_CSRS\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-123.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3157]]",
        3158=>"PROJCS[\"NAD_1983_CSRS_UTM_Zone_14N\",GEOGCS[\"GCS_North_American_1983_CSRS\",DATUM[\"D_North_American_1983_CSRS\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-99.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3158]]",
        3159=>"PROJCS[\"NAD_1983_CSRS_UTM_Zone_15N\",GEOGCS[\"GCS_North_American_1983_CSRS\",DATUM[\"D_North_American_1983_CSRS\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-93.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3159]]",
        3160=>"PROJCS[\"NAD_1983_CSRS_UTM_Zone_16N\",GEOGCS[\"GCS_North_American_1983_CSRS\",DATUM[\"D_North_American_1983_CSRS\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-87.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3160]]",
        3161=>"PROJCS[\"NAD_1983_Ontario_MNR_Lambert\",GEOGCS[\"GCS_North_American_1983\",DATUM[\"D_North_American_1983\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",930000.0],PARAMETER[\"False_Northing\",6430000.0],PARAMETER[\"Central_Meridian\",-85.0],PARAMETER[\"Standard_Parallel_1\",44.5],PARAMETER[\"Standard_Parallel_2\",53.5],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3161]]",
        3162=>"PROJCS[\"NAD_1983_CSRS_Ontario_MNR_Lambert\",GEOGCS[\"GCS_North_American_1983_CSRS\",DATUM[\"D_North_American_1983_CSRS\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",930000.0],PARAMETER[\"False_Northing\",6430000.0],PARAMETER[\"Central_Meridian\",-85.0],PARAMETER[\"Standard_Parallel_1\",44.5],PARAMETER[\"Standard_Parallel_2\",53.5],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3162]]",
        3163=>"PROJCS[\"RGNC_1991_93_Lambert_New_Caledonia\",GEOGCS[\"GCS_RGNC_1991-93\",DATUM[\"D_Reseau_Geodesique_de_Nouvelle_Caledonie_1991-93\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",400000.0],PARAMETER[\"False_Northing\",300000.0],PARAMETER[\"Central_Meridian\",166.0],PARAMETER[\"Standard_Parallel_1\",-20.66666666666667],PARAMETER[\"Standard_Parallel_2\",-22.33333333333333],PARAMETER[\"Latitude_Of_Origin\",-21.5],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3163]]",
        3164=>"PROJCS[\"ST87_Ouvea_UTM_58S\",GEOGCS[\"GCS_ST87_Ouvea\",DATUM[\"D_ST87_Ouvea\",SPHEROID[\"WGS_1984\",6378137.0,298.257223563]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",10000000.0],PARAMETER[\"Central_Meridian\",165.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3164]]",
        3165=>"PROJCS[\"NEA74_Noumea_Lambert\",GEOGCS[\"GCS_NEA74_Noumea\",DATUM[\"D_NEA74_Noumea\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",0.66],PARAMETER[\"False_Northing\",1.02],PARAMETER[\"Central_Meridian\",166.44242575],PARAMETER[\"Standard_Parallel_1\",-22.24469175],PARAMETER[\"Standard_Parallel_2\",-22.29469175],PARAMETER[\"Latitude_Of_Origin\",-22.26969175],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3165]]",
        3166=>"PROJCS[\"NEA74_Noumea_Lambert_2\",GEOGCS[\"GCS_NEA74_Noumea\",DATUM[\"D_NEA74_Noumea\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",8.313],PARAMETER[\"False_Northing\",-2.354],PARAMETER[\"Central_Meridian\",166.4425],PARAMETER[\"Standard_Parallel_1\",-22.24472222222222],PARAMETER[\"Standard_Parallel_2\",-22.29472222222222],PARAMETER[\"Latitude_Of_Origin\",-22.26972222222222],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3166]]",
        3167=>"PROJCS[\"Kertau_RSO_RSO_Malaya_ChSears1922trunc\",GEOGCS[\"GCS_Kertau_RSO\",DATUM[\"D_Kertau_RSO\",SPHEROID[\"Everest_Modified_1969\",6377295.664,300.8017]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Rectified_Skew_Orthomorphic_Natural_Origin\"],PARAMETER[\"False_Easting\",40000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Scale_Factor\",0.99984],PARAMETER[\"Azimuth\",323.0257905],PARAMETER[\"Longitude_Of_Center\",102.25],PARAMETER[\"Latitude_Of_Center\",4.0],PARAMETER[\"XY_Plane_Rotation\",323.1301023611111],UNIT[\"Chain_Sears_1922_Truncated\",20.116756],AUTHORITY[\"EPSG\",3167]]",
        3168=>"PROJCS[\"Kertau_RSO_RSO_Malaya\",GEOGCS[\"GCS_Kertau_RSO\",DATUM[\"D_Kertau_RSO\",SPHEROID[\"Everest_Modified_1969\",6377295.664,300.8017]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Rectified_Skew_Orthomorphic_Natural_Origin\"],PARAMETER[\"False_Easting\",804670.24],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Scale_Factor\",0.99984],PARAMETER[\"Azimuth\",323.0257905],PARAMETER[\"Longitude_Of_Center\",102.25],PARAMETER[\"Latitude_Of_Center\",4.0],PARAMETER[\"XY_Plane_Rotation\",323.1301023611111],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3168]]",
        3169=>"PROJCS[\"RGNC_1991-93_UTM_Zone_57S\",GEOGCS[\"GCS_RGNC_1991-93\",DATUM[\"D_Reseau_Geodesique_de_Nouvelle_Caledonie_1991-93\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",10000000.0],PARAMETER[\"Central_Meridian\",159.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3169]]",
        3170=>"PROJCS[\"RGNC_1991-93_UTM_Zone_58S\",GEOGCS[\"GCS_RGNC_1991-93\",DATUM[\"D_Reseau_Geodesique_de_Nouvelle_Caledonie_1991-93\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",10000000.0],PARAMETER[\"Central_Meridian\",165.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3170]]",
        3171=>"PROJCS[\"RGNC_1991-93_UTM_Zone_59S\",GEOGCS[\"GCS_RGNC_1991-93\",DATUM[\"D_Reseau_Geodesique_de_Nouvelle_Caledonie_1991-93\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",10000000.0],PARAMETER[\"Central_Meridian\",171.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3171]]",
        3172=>"PROJCS[\"IGN53_Mare_UTM_Zone_59S\",GEOGCS[\"GCS_IGN53_Mare\",DATUM[\"D_IGN53_Mare\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",10000000.0],PARAMETER[\"Central_Meridian\",171.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3172]]",
        3174=>"PROJCS[\"NAD_1983_Great_Lakes_Basin_Albers\",GEOGCS[\"GCS_North_American_1983\",DATUM[\"D_North_American_1983\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Albers\"],PARAMETER[\"False_Easting\",1000000.0],PARAMETER[\"False_Northing\",1000000.0],PARAMETER[\"Central_Meridian\",-84.455955],PARAMETER[\"Standard_Parallel_1\",42.122774],PARAMETER[\"Standard_Parallel_2\",49.01518],PARAMETER[\"Latitude_Of_Origin\",45.568977],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3174]]",
        3175=>"PROJCS[\"NAD_1983_Great_Lakes_and_St_Lawrence_Albers\",GEOGCS[\"GCS_North_American_1983\",DATUM[\"D_North_American_1983\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Albers\"],PARAMETER[\"False_Easting\",1000000.0],PARAMETER[\"False_Northing\",1000000.0],PARAMETER[\"Central_Meridian\",-83.248627],PARAMETER[\"Standard_Parallel_1\",42.122774],PARAMETER[\"Standard_Parallel_2\",49.01518],PARAMETER[\"Latitude_Of_Origin\",45.568977],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3175]]",
        3176=>"PROJCS[\"Indian_1960_TM_106NE\",GEOGCS[\"GCS_Indian_1960\",DATUM[\"D_Indian_1960\",SPHEROID[\"Everest_Adjustment_1937\",6377276.345,300.8017]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",106.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3176]]",
        3177=>"PROJCS[\"LGD2006_Libya_TM\",GEOGCS[\"GCS_LGD2006\",DATUM[\"D_Libyan_Geodetic_Datum_2006\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",1000000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",17.0],PARAMETER[\"Scale_Factor\",0.9965],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3177]]",
        3178=>"PROJCS[\"Greenland_1996_UTM_Zone_18N\",GEOGCS[\"GCS_Greenland_1996\",DATUM[\"D_Greenland_1996\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-75.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3178]]",
        3179=>"PROJCS[\"Greenland_1996_UTM_Zone_19N\",GEOGCS[\"GCS_Greenland_1996\",DATUM[\"D_Greenland_1996\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-69.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3179]]",
        3180=>"PROJCS[\"Greenland_1996_UTM_Zone_20N\",GEOGCS[\"GCS_Greenland_1996\",DATUM[\"D_Greenland_1996\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-63.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3180]]",
        3181=>"PROJCS[\"Greenland_1996_UTM_Zone_21N\",GEOGCS[\"GCS_Greenland_1996\",DATUM[\"D_Greenland_1996\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-57.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3181]]",
        3182=>"PROJCS[\"Greenland_1996_UTM_Zone_22N\",GEOGCS[\"GCS_Greenland_1996\",DATUM[\"D_Greenland_1996\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-51.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3182]]",
        3183=>"PROJCS[\"Greenland_1996_UTM_Zone_23N\",GEOGCS[\"GCS_Greenland_1996\",DATUM[\"D_Greenland_1996\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-45.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3183]]",
        3184=>"PROJCS[\"Greenland_1996_UTM_Zone_24N\",GEOGCS[\"GCS_Greenland_1996\",DATUM[\"D_Greenland_1996\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-39.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3184]]",
        3185=>"PROJCS[\"Greenland_1996_UTM_Zone_25N\",GEOGCS[\"GCS_Greenland_1996\",DATUM[\"D_Greenland_1996\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-33.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3185]]",
        3186=>"PROJCS[\"Greenland_1996_UTM_Zone_26N\",GEOGCS[\"GCS_Greenland_1996\",DATUM[\"D_Greenland_1996\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-27.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3186]]",
        3187=>"PROJCS[\"Greenland_1996_UTM_Zone_27N\",GEOGCS[\"GCS_Greenland_1996\",DATUM[\"D_Greenland_1996\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-21.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3187]]",
        3188=>"PROJCS[\"Greenland_1996_UTM_Zone_28N\",GEOGCS[\"GCS_Greenland_1996\",DATUM[\"D_Greenland_1996\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-15.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3188]]",
        3189=>"PROJCS[\"Greenland_1996_UTM_Zone_29N\",GEOGCS[\"GCS_Greenland_1996\",DATUM[\"D_Greenland_1996\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-9.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3189]]",
        3190=>"PROJCS[\"LGD2006_Libya_TM_Zone_5\",GEOGCS[\"GCS_LGD2006\",DATUM[\"D_Libyan_Geodetic_Datum_2006\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",200000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",9.0],PARAMETER[\"Scale_Factor\",0.99995],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3190]]",
        3191=>"PROJCS[\"LGD2006_Libya_TM_Zone_6\",GEOGCS[\"GCS_LGD2006\",DATUM[\"D_Libyan_Geodetic_Datum_2006\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",200000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",11.0],PARAMETER[\"Scale_Factor\",0.99995],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3191]]",
        3192=>"PROJCS[\"LGD2006_Libya_TM_Zone_7\",GEOGCS[\"GCS_LGD2006\",DATUM[\"D_Libyan_Geodetic_Datum_2006\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",200000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",13.0],PARAMETER[\"Scale_Factor\",0.99995],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3192]]",
        3193=>"PROJCS[\"LGD2006_Libya_TM_Zone_8\",GEOGCS[\"GCS_LGD2006\",DATUM[\"D_Libyan_Geodetic_Datum_2006\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",200000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",15.0],PARAMETER[\"Scale_Factor\",0.99995],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3193]]",
        3194=>"PROJCS[\"LGD2006_Libya_TM_Zone_9\",GEOGCS[\"GCS_LGD2006\",DATUM[\"D_Libyan_Geodetic_Datum_2006\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",200000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",17.0],PARAMETER[\"Scale_Factor\",0.99995],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3194]]",
        3195=>"PROJCS[\"LGD2006_Libya_TM_Zone_10\",GEOGCS[\"GCS_LGD2006\",DATUM[\"D_Libyan_Geodetic_Datum_2006\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",200000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",19.0],PARAMETER[\"Scale_Factor\",0.99995],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3195]]",
        3196=>"PROJCS[\"LGD2006_Libya_TM_Zone_11\",GEOGCS[\"GCS_LGD2006\",DATUM[\"D_Libyan_Geodetic_Datum_2006\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",200000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",21.0],PARAMETER[\"Scale_Factor\",0.99995],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3196]]",
        3197=>"PROJCS[\"LGD2006_Libya_TM_Zone_12\",GEOGCS[\"GCS_LGD2006\",DATUM[\"D_Libyan_Geodetic_Datum_2006\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",200000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",23.0],PARAMETER[\"Scale_Factor\",0.99995],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3197]]",
        3198=>"PROJCS[\"LGD2006_Libya_TM_Zone_13\",GEOGCS[\"GCS_LGD2006\",DATUM[\"D_Libyan_Geodetic_Datum_2006\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",200000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",25.0],PARAMETER[\"Scale_Factor\",0.99995],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3198]]",
        3199=>"PROJCS[\"LGD2006_UTM_Zone_32N\",GEOGCS[\"GCS_LGD2006\",DATUM[\"D_Libyan_Geodetic_Datum_2006\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",9.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3199]]",
        3200=>"PROJCS[\"FD_1958_Iraq\",GEOGCS[\"GCS_FD_1958\",DATUM[\"D_FD_1958\",SPHEROID[\"Clarke_1880_RGS\",6378249.145,293.465]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",1500000.0],PARAMETER[\"False_Northing\",1166200.0],PARAMETER[\"Central_Meridian\",45.0],PARAMETER[\"Standard_Parallel_1\",32.5],PARAMETER[\"Scale_Factor\",0.99878640777],PARAMETER[\"Latitude_Of_Origin\",32.5],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3200]]",
        3201=>"PROJCS[\"LGD2006_UTM_Zone_33N\",GEOGCS[\"GCS_LGD2006\",DATUM[\"D_Libyan_Geodetic_Datum_2006\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",15.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3201]]",
        3202=>"PROJCS[\"LGD2006_UTM_Zone_34N\",GEOGCS[\"GCS_LGD2006\",DATUM[\"D_Libyan_Geodetic_Datum_2006\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",21.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3202]]",
        3203=>"PROJCS[\"LGD2006_UTM_Zone_35N\",GEOGCS[\"GCS_LGD2006\",DATUM[\"D_Libyan_Geodetic_Datum_2006\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",27.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3203]]",
        3294=>"PROJCS[\"WGS_1984_USGS_Transantarctic_Mountains\",GEOGCS[\"GCS_WGS_1984\",DATUM[\"D_WGS_1984\",SPHEROID[\"WGS_1984\",6378137.0,298.257223563]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",0.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",162.0],PARAMETER[\"Standard_Parallel_1\",-76.66666666666667],PARAMETER[\"Standard_Parallel_2\",-79.33333333333333],PARAMETER[\"Latitude_Of_Origin\",-78.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3294]]",
        3295=>"PROJCS[\"Guam_1963_Yap_Islands\",GEOGCS[\"GCS_Guam_1963\",DATUM[\"D_Guam_1963\",SPHEROID[\"Clarke_1866\",6378206.4,294.9786982]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Azimuthal_Equidistant\"],PARAMETER[\"False_Easting\",40000.0],PARAMETER[\"False_Northing\",60000.0],PARAMETER[\"Central_Meridian\",138.1687444444444],PARAMETER[\"Latitude_Of_Origin\",9.546708333333333],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3295]]",
        3296=>"PROJCS[\"RGPF_UTM_Zone_5S\",GEOGCS[\"GCS_RGPF\",DATUM[\"D_Reseau_Geodesique_de_la_Polynesie_Francaise\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",10000000.0],PARAMETER[\"Central_Meridian\",-153.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3296]]",
        3297=>"PROJCS[\"RGPF_UTM_Zone_6S\",GEOGCS[\"GCS_RGPF\",DATUM[\"D_Reseau_Geodesique_de_la_Polynesie_Francaise\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",10000000.0],PARAMETER[\"Central_Meridian\",-147.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3297]]",
        3298=>"PROJCS[\"RGPF_UTM_Zone_7S\",GEOGCS[\"GCS_RGPF\",DATUM[\"D_Reseau_Geodesique_de_la_Polynesie_Francaise\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",10000000.0],PARAMETER[\"Central_Meridian\",-141.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3298]]",
        3299=>"PROJCS[\"RGPF_UTM_Zone_8S\",GEOGCS[\"GCS_RGPF\",DATUM[\"D_Reseau_Geodesique_de_la_Polynesie_Francaise\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",10000000.0],PARAMETER[\"Central_Meridian\",-135.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3299]]",
        3300=>"PROJCS[\"Estonian_Coordinate_System_of_1992\",GEOGCS[\"GCS_Estonia_1992\",DATUM[\"D_Estonia_1992\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",6375000.0],PARAMETER[\"Central_Meridian\",24.0],PARAMETER[\"Standard_Parallel_1\",58.0],PARAMETER[\"Standard_Parallel_2\",59.33333333333334],PARAMETER[\"Latitude_Of_Origin\",57.51755393055556],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3300]]",
        3301=>"PROJCS[\"Estonia_1997_Estonia_National_Grid\",GEOGCS[\"GCS_Estonia_1997\",DATUM[\"D_Estonia_1997\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",6375000.0],PARAMETER[\"Central_Meridian\",24.0],PARAMETER[\"Standard_Parallel_1\",58.0],PARAMETER[\"Standard_Parallel_2\",59.33333333333334],PARAMETER[\"Latitude_Of_Origin\",57.51755393055556],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3301]]",
        3302=>"PROJCS[\"IGN63_Hiva_Oa_UTM_Zone_7S\",GEOGCS[\"GCS_IGN63_Hiva_Oa\",DATUM[\"D_IGN63_Hiva_Oa\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",10000000.0],PARAMETER[\"Central_Meridian\",-141.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3302]]",
        3303=>"PROJCS[\"Fatu_Iva_1972_UTM_Zone_7S\",GEOGCS[\"GCS_Fatu_Iva_1972\",DATUM[\"D_Fatu_Iva_1972\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",10000000.0],PARAMETER[\"Central_Meridian\",-141.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3303]]",
        3304=>"PROJCS[\"Tahiti_1979_UTM_Zone_6S\",GEOGCS[\"GCS_Tahiti_1979\",DATUM[\"D_Tahiti_1979\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",10000000.0],PARAMETER[\"Central_Meridian\",-147.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3304]]",
        3305=>"PROJCS[\"Moorea_1987_UTM_Zone_6S\",GEOGCS[\"GCS_Moorea_1987\",DATUM[\"D_Moorea_1987\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",10000000.0],PARAMETER[\"Central_Meridian\",-147.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3305]]",
        3306=>"PROJCS[\"Maupiti_1983_UTM_Zone_5S\",GEOGCS[\"GCS_Maupiti_1983\",DATUM[\"D_Maupiti_1983\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",10000000.0],PARAMETER[\"Central_Meridian\",-153.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3306]]",
        3307=>"PROJCS[\"Nakhl-e_Ghanem_UTM_Zone_39N\",GEOGCS[\"GCS_Nakhl-e_Ghanem\",DATUM[\"D_Nakhl-e_Ghanem\",SPHEROID[\"WGS_1984\",6378137.0,298.257223563]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",51.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3307]]",
        3308=>"PROJCS[\"GDA_1994_NSW_Lambert\",GEOGCS[\"GCS_GDA_1994\",DATUM[\"D_GDA_1994\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",9300000.0],PARAMETER[\"False_Northing\",4500000.0],PARAMETER[\"Central_Meridian\",147.0],PARAMETER[\"Standard_Parallel_1\",-30.75],PARAMETER[\"Standard_Parallel_2\",-35.75],PARAMETER[\"Latitude_Of_Origin\",-33.25],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3308]]",
        3309=>"PROJCS[\"NAD_1927_California_Teale_Albers\",GEOGCS[\"GCS_North_American_1927\",DATUM[\"D_North_American_1927\",SPHEROID[\"Clarke_1866\",6378206.4,294.9786982]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Albers\"],PARAMETER[\"False_Easting\",0.0],PARAMETER[\"False_Northing\",-4000000.0],PARAMETER[\"Central_Meridian\",-120.0],PARAMETER[\"Standard_Parallel_1\",34.0],PARAMETER[\"Standard_Parallel_2\",40.5],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3309]]",
        3310=>"PROJCS[\"NAD_1983_California_Teale_Albers\",GEOGCS[\"GCS_North_American_1983\",DATUM[\"D_North_American_1983\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Albers\"],PARAMETER[\"False_Easting\",0.0],PARAMETER[\"False_Northing\",-4000000.0],PARAMETER[\"Central_Meridian\",-120.0],PARAMETER[\"Standard_Parallel_1\",34.0],PARAMETER[\"Standard_Parallel_2\",40.5],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3310]]",
        3311=>"PROJCS[\"NAD_1983_HARN_California_Teale_Albers\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Albers\"],PARAMETER[\"False_Easting\",0.0],PARAMETER[\"False_Northing\",-4000000.0],PARAMETER[\"Central_Meridian\",-120.0],PARAMETER[\"Standard_Parallel_1\",34.0],PARAMETER[\"Standard_Parallel_2\",40.5],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3311]]",
        3312=>"PROJCS[\"CSG_1967_UTM_Zone_21N\",GEOGCS[\"GCS_CSG_1967\",DATUM[\"D_CSG_1967\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-57.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3312]]",
        3313=>"PROJCS[\"RGFG_1995_UTM_Zone_21N\",GEOGCS[\"GCS_RGFG_1995\",DATUM[\"D_RGFG_1995\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-57.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3313]]",
        3315=>"PROJCS[\"Katanga_1955_Katanga_TM\",GEOGCS[\"GCS_Katanga_1955\",DATUM[\"D_Katanga_1955\",SPHEROID[\"Clarke_1866\",6378206.4,294.9786982]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",0.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",26.0],PARAMETER[\"Scale_Factor\",0.9998],PARAMETER[\"Latitude_Of_Origin\",-9.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3315]]",
        3316=>"PROJCS[\"Kasai_1953_Congo_TM_Zone_22\",GEOGCS[\"GCS_Kasai_1953\",DATUM[\"D_Kasai_1953\",SPHEROID[\"Clarke_1880_RGS\",6378249.145,293.465]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",10000000.0],PARAMETER[\"Central_Meridian\",22.0],PARAMETER[\"Scale_Factor\",0.9999],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3316]]",
        3317=>"PROJCS[\"Kasai_1953_Congo_TM_Zone_24\",GEOGCS[\"GCS_Kasai_1953\",DATUM[\"D_Kasai_1953\",SPHEROID[\"Clarke_1880_RGS\",6378249.145,293.465]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",10000000.0],PARAMETER[\"Central_Meridian\",24.0],PARAMETER[\"Scale_Factor\",0.9999],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3317]]",
        3318=>"PROJCS[\"IGC_1962_Congo_TM_Zone_12\",GEOGCS[\"GCS_IGC_1962_6th_Parallel_South\",DATUM[\"D_IGC_1962_Arc_of_the_6th_Parallel_South\",SPHEROID[\"Clarke_1880_RGS\",6378249.145,293.465]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",10000000.0],PARAMETER[\"Central_Meridian\",12.0],PARAMETER[\"Scale_Factor\",0.9999],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3318]]",
        3319=>"PROJCS[\"IGC_1962_Congo_TM_Zone_14\",GEOGCS[\"GCS_IGC_1962_6th_Parallel_South\",DATUM[\"D_IGC_1962_Arc_of_the_6th_Parallel_South\",SPHEROID[\"Clarke_1880_RGS\",6378249.145,293.465]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",10000000.0],PARAMETER[\"Central_Meridian\",14.0],PARAMETER[\"Scale_Factor\",0.9999],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3319]]",
        3320=>"PROJCS[\"IGC_1962_Congo_TM_Zone_16\",GEOGCS[\"GCS_IGC_1962_6th_Parallel_South\",DATUM[\"D_IGC_1962_Arc_of_the_6th_Parallel_South\",SPHEROID[\"Clarke_1880_RGS\",6378249.145,293.465]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",10000000.0],PARAMETER[\"Central_Meridian\",16.0],PARAMETER[\"Scale_Factor\",0.9999],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3320]]",
        3321=>"PROJCS[\"IGC_1962_Congo_TM_Zone_18\",GEOGCS[\"GCS_IGC_1962_6th_Parallel_South\",DATUM[\"D_IGC_1962_Arc_of_the_6th_Parallel_South\",SPHEROID[\"Clarke_1880_RGS\",6378249.145,293.465]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",10000000.0],PARAMETER[\"Central_Meridian\",18.0],PARAMETER[\"Scale_Factor\",0.9999],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3321]]",
        3322=>"PROJCS[\"IGC_1962_Congo_TM_Zone_20\",GEOGCS[\"GCS_IGC_1962_6th_Parallel_South\",DATUM[\"D_IGC_1962_Arc_of_the_6th_Parallel_South\",SPHEROID[\"Clarke_1880_RGS\",6378249.145,293.465]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",10000000.0],PARAMETER[\"Central_Meridian\",20.0],PARAMETER[\"Scale_Factor\",0.9999],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3322]]",
        3323=>"PROJCS[\"IGC_1962_Congo_TM_Zone_22\",GEOGCS[\"GCS_IGC_1962_6th_Parallel_South\",DATUM[\"D_IGC_1962_Arc_of_the_6th_Parallel_South\",SPHEROID[\"Clarke_1880_RGS\",6378249.145,293.465]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",10000000.0],PARAMETER[\"Central_Meridian\",22.0],PARAMETER[\"Scale_Factor\",0.9999],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3323]]",
        3324=>"PROJCS[\"IGC_1962_Congo_TM_Zone_24\",GEOGCS[\"GCS_IGC_1962_6th_Parallel_South\",DATUM[\"D_IGC_1962_Arc_of_the_6th_Parallel_South\",SPHEROID[\"Clarke_1880_RGS\",6378249.145,293.465]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",10000000.0],PARAMETER[\"Central_Meridian\",24.0],PARAMETER[\"Scale_Factor\",0.9999],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3324]]",
        3325=>"PROJCS[\"IGC_1962_Congo_TM_Zone_26\",GEOGCS[\"GCS_IGC_1962_6th_Parallel_South\",DATUM[\"D_IGC_1962_Arc_of_the_6th_Parallel_South\",SPHEROID[\"Clarke_1880_RGS\",6378249.145,293.465]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",10000000.0],PARAMETER[\"Central_Meridian\",26.0],PARAMETER[\"Scale_Factor\",0.9999],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3325]]",
        3326=>"PROJCS[\"IGC_1962_Congo_TM_Zone_28\",GEOGCS[\"GCS_IGC_1962_6th_Parallel_South\",DATUM[\"D_IGC_1962_Arc_of_the_6th_Parallel_South\",SPHEROID[\"Clarke_1880_RGS\",6378249.145,293.465]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",10000000.0],PARAMETER[\"Central_Meridian\",28.0],PARAMETER[\"Scale_Factor\",0.9999],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3326]]",
        3327=>"PROJCS[\"IGC_1962_Congo_TM_Zone_30\",GEOGCS[\"GCS_IGC_1962_6th_Parallel_South\",DATUM[\"D_IGC_1962_Arc_of_the_6th_Parallel_South\",SPHEROID[\"Clarke_1880_RGS\",6378249.145,293.465]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",10000000.0],PARAMETER[\"Central_Meridian\",30.0],PARAMETER[\"Scale_Factor\",0.9999],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3327]]",
        3328=>"PROJCS[\"Pulkovo_1942_Adj_1958_GUGiK-80\",GEOGCS[\"GCS_Pulkovo_1942_Adj_1958\",DATUM[\"D_Pulkovo_1942_Adj_1958\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Double_Stereographic\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",500000.0],PARAMETER[\"Central_Meridian\",19.16666666666667],PARAMETER[\"Scale_Factor\",0.9997143],PARAMETER[\"Latitude_Of_Origin\",52.16666666666666],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3328]]",
        3329=>"PROJCS[\"Pulkovo_1942_Adj_1958_3_Degree_GK_Zone_5\",GEOGCS[\"GCS_Pulkovo_1942_Adj_1958\",DATUM[\"D_Pulkovo_1942_Adj_1958\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",5500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",15.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3329]]",
        3330=>"PROJCS[\"Pulkovo_1942_Adj_1958_3_Degree_GK_Zone_6\",GEOGCS[\"GCS_Pulkovo_1942_Adj_1958\",DATUM[\"D_Pulkovo_1942_Adj_1958\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",6500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",18.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3330]]",
        3331=>"PROJCS[\"Pulkovo_1942_Adj_1958_3_Degree_GK_Zone_7\",GEOGCS[\"GCS_Pulkovo_1942_Adj_1958\",DATUM[\"D_Pulkovo_1942_Adj_1958\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",7500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",21.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3331]]",
        3332=>"PROJCS[\"Pulkovo_1942_Adj_1958_3_Degree_GK_Zone_8\",GEOGCS[\"GCS_Pulkovo_1942_Adj_1958\",DATUM[\"D_Pulkovo_1942_Adj_1958\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",8500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",24.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3332]]",
        3333=>"PROJCS[\"Pulkovo_1942_Adj_1958_GK_Zone_3\",GEOGCS[\"GCS_Pulkovo_1942_Adj_1958\",DATUM[\"D_Pulkovo_1942_Adj_1958\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",3500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",15.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3333]]",
        3334=>"PROJCS[\"Pulkovo_1942_Adj_1958_GK_Zone_4\",GEOGCS[\"GCS_Pulkovo_1942_Adj_1958\",DATUM[\"D_Pulkovo_1942_Adj_1958\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",4500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",21.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3334]]",
        3335=>"PROJCS[\"Pulkovo_1942_Adj_1958_GK_Zone_5\",GEOGCS[\"GCS_Pulkovo_1942_Adj_1958\",DATUM[\"D_Pulkovo_1942_Adj_1958\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",5500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",27.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3335]]",
        3336=>"PROJCS[\"Kerguelen_Island_1949_UTM_42S\",GEOGCS[\"GCS_Kerguelen_Island_1949\",DATUM[\"D_Kerguelen_Island_1949\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",10000000.0],PARAMETER[\"Central_Meridian\",69.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3336]]",
        3337=>"PROJCS[\"Le_Pouce_1934_Mauritius_Grid\",GEOGCS[\"GCS_Le_Pouce_1934\",DATUM[\"D_Le_Pouce_1934\",SPHEROID[\"Clarke_1880_RGS\",6378249.145,293.465]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",1000000.0],PARAMETER[\"False_Northing\",1000000.0],PARAMETER[\"Central_Meridian\",57.52182777777778],PARAMETER[\"Standard_Parallel_1\",-20.19506944444445],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",-20.19506944444445],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3337]]",
        3338=>"PROJCS[\"NAD_1983_Alaska_Albers\",GEOGCS[\"GCS_North_American_1983\",DATUM[\"D_North_American_1983\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Albers\"],PARAMETER[\"False_Easting\",0.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-154.0],PARAMETER[\"Standard_Parallel_1\",55.0],PARAMETER[\"Standard_Parallel_2\",65.0],PARAMETER[\"Latitude_Of_Origin\",50.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3338]]",
        3339=>"PROJCS[\"IGCB_1955_Congo_TM_Zone_12\",GEOGCS[\"GCS_IGCB_1955\",DATUM[\"D_Institut_Geographique_du_Congo_Belge_1955\",SPHEROID[\"Clarke_1880_RGS\",6378249.145,293.465]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",10000000.0],PARAMETER[\"Central_Meridian\",12.0],PARAMETER[\"Scale_Factor\",0.9999],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3339]]",
        3340=>"PROJCS[\"IGCB_1955_Congo_TM_Zone_14\",GEOGCS[\"GCS_IGCB_1955\",DATUM[\"D_Institut_Geographique_du_Congo_Belge_1955\",SPHEROID[\"Clarke_1880_RGS\",6378249.145,293.465]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",10000000.0],PARAMETER[\"Central_Meridian\",14.0],PARAMETER[\"Scale_Factor\",0.9999],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3340]]",
        3341=>"PROJCS[\"IGCB_1955_Congo_TM_Zone_16\",GEOGCS[\"GCS_IGCB_1955\",DATUM[\"D_Institut_Geographique_du_Congo_Belge_1955\",SPHEROID[\"Clarke_1880_RGS\",6378249.145,293.465]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",10000000.0],PARAMETER[\"Central_Meridian\",16.0],PARAMETER[\"Scale_Factor\",0.9999],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3341]]",
        3342=>"PROJCS[\"IGCB_1955_UTM_Zone_33S\",GEOGCS[\"GCS_IGCB_1955\",DATUM[\"D_Institut_Geographique_du_Congo_Belge_1955\",SPHEROID[\"Clarke_1880_RGS\",6378249.145,293.465]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",10000000.0],PARAMETER[\"Central_Meridian\",15.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3342]]",
        3343=>"PROJCS[\"Mauritania_1999_UTM_Zone_28N\",GEOGCS[\"GCS_Mauritania_1999\",DATUM[\"D_Mauritania_1999\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-15.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3343]]",
        3344=>"PROJCS[\"Mauritania_1999_UTM_Zone_29N\",GEOGCS[\"GCS_Mauritania_1999\",DATUM[\"D_Mauritania_1999\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-9.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3344]]",
        3345=>"PROJCS[\"Mauritania_1999_UTM_Zone_30N\",GEOGCS[\"GCS_Mauritania_1999\",DATUM[\"D_Mauritania_1999\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-3.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3345]]",
        3346=>"PROJCS[\"LKS_1994_Lithuania_TM\",GEOGCS[\"GCS_LKS_1994\",DATUM[\"D_Lithuania_1994\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",24.0],PARAMETER[\"Scale_Factor\",0.9998],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3346]]",
        3347=>"PROJCS[\"NAD_1983_Statistics_Canada_Lambert\",GEOGCS[\"GCS_North_American_1983\",DATUM[\"D_North_American_1983\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",6200000.0],PARAMETER[\"False_Northing\",3000000.0],PARAMETER[\"Central_Meridian\",-91.86666666666666],PARAMETER[\"Standard_Parallel_1\",49.0],PARAMETER[\"Standard_Parallel_2\",77.0],PARAMETER[\"Latitude_Of_Origin\",63.390675],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3347]]",
        3348=>"PROJCS[\"NAD_1983_CSRS_Statistics_Canada_Lambert\",GEOGCS[\"GCS_North_American_1983_CSRS\",DATUM[\"D_North_American_1983_CSRS\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",6200000.0],PARAMETER[\"False_Northing\",3000000.0],PARAMETER[\"Central_Meridian\",-91.86666666666666],PARAMETER[\"Standard_Parallel_1\",49.0],PARAMETER[\"Standard_Parallel_2\",77.0],PARAMETER[\"Latitude_Of_Origin\",63.390675],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3348]]",
        3350=>"PROJCS[\"Pulkovo_1942_CS63_Zone_C0\",GEOGCS[\"GCS_Pulkovo_1942\",DATUM[\"D_Pulkovo_1942\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",250000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",21.95],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.1],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3350]]",
        3351=>"PROJCS[\"Pulkovo_1942_CS63_Zone_C1\",GEOGCS[\"GCS_Pulkovo_1942\",DATUM[\"D_Pulkovo_1942\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",1250000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",24.95],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.1],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3351]]",
        3352=>"PROJCS[\"Pulkovo_1942_CS63_Zone_C2\",GEOGCS[\"GCS_Pulkovo_1942\",DATUM[\"D_Pulkovo_1942\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",2250000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",27.95],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.1],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3352]]",
        3353=>"PROJCS[\"Mhast_Onshore_UTM_Zone_32S\",GEOGCS[\"GCS_Mhast_Onshore\",DATUM[\"D_Mhast_Onshore\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",10000000.0],PARAMETER[\"Central_Meridian\",9.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3353]]",
        3354=>"PROJCS[\"Mhast_Offshore_UTM_Zone_32S\",GEOGCS[\"GCS_Mhast_Offshore\",DATUM[\"D_Mhast_Offshore\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",10000000.0],PARAMETER[\"Central_Meridian\",9.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3354]]",
        3355=>"PROJCS[\"Egypt_Gulf_of_Suez_S-650_TL_Red_Belt\",GEOGCS[\"GCS_Egypt_Gulf_of_Suez_S-650_TL\",DATUM[\"D_Egypt_Gulf_of_Suez_S-650_TL\",SPHEROID[\"Helmert_1906\",6378200.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",615000.0],PARAMETER[\"False_Northing\",810000.0],PARAMETER[\"Central_Meridian\",31.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",30.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3355]]",
        3356=>"PROJCS[\"Grand_Cayman_1959_UTM_Zone_17N\",GEOGCS[\"GCS_Grand_Cayman_1959\",DATUM[\"D_Grand_Cayman_1959\",SPHEROID[\"Clarke_1866\",6378206.4,294.9786982]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-81.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3356]]",
        3357=>"PROJCS[\"Little_Cayman_1961_UTM_Zone_17N\",GEOGCS[\"GCS_Little_Cayman_1961\",DATUM[\"D_Little_Cayman_1961\",SPHEROID[\"Clarke_1866\",6378206.4,294.9786982]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-81.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3357]]",
        3358=>"PROJCS[\"NAD_1983_HARN_StatePlane_North_Carolina_FIPS_3200\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",609601.2192024384],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-79.0],PARAMETER[\"Standard_Parallel_1\",34.33333333333334],PARAMETER[\"Standard_Parallel_2\",36.16666666666666],PARAMETER[\"Latitude_Of_Origin\",33.75],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3358]]",
        3359=>"PROJCS[\"NAD_1983_HARN_StatePlane_North_Carolina_FIPS_3200_Feet\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",2000000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-79.0],PARAMETER[\"Standard_Parallel_1\",34.33333333333334],PARAMETER[\"Standard_Parallel_2\",36.16666666666666],PARAMETER[\"Latitude_Of_Origin\",33.75],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",3404]]",
        3360=>"PROJCS[\"NAD_1983_HARN_StatePlane_South_Carolina_FIPS_3900\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",609600.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-81.0],PARAMETER[\"Standard_Parallel_1\",32.5],PARAMETER[\"Standard_Parallel_2\",34.83333333333334],PARAMETER[\"Latitude_Of_Origin\",31.83333333333333],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3360]]",
        3361=>"PROJCS[\"NAD_1983_HARN_StatePlane_South_Carolina_FIPS_3900_Feet_Intl\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",2000000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-81.0],PARAMETER[\"Standard_Parallel_1\",32.5],PARAMETER[\"Standard_Parallel_2\",34.83333333333334],PARAMETER[\"Latitude_Of_Origin\",31.83333333333333],UNIT[\"Foot\",0.3048],AUTHORITY[\"EPSG\",3361]]",
        3362=>"PROJCS[\"NAD_1983_HARN_StatePlane_Pennsylvania_North_FIPS_3701\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",600000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-77.75],PARAMETER[\"Standard_Parallel_1\",40.88333333333333],PARAMETER[\"Standard_Parallel_2\",41.95],PARAMETER[\"Latitude_Of_Origin\",40.16666666666666],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3362]]",
        3363=>"PROJCS[\"NAD_1983_HARN_StatePlane_Pennsylvania_North_FIPS_3701_Feet\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",1968500.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-77.75],PARAMETER[\"Standard_Parallel_1\",40.88333333333333],PARAMETER[\"Standard_Parallel_2\",41.95],PARAMETER[\"Latitude_Of_Origin\",40.16666666666666],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",3363]]",
        3364=>"PROJCS[\"NAD_1983_HARN_StatePlane_Pennsylvania_South_FIPS_3702\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",600000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-77.75],PARAMETER[\"Standard_Parallel_1\",39.93333333333333],PARAMETER[\"Standard_Parallel_2\",40.96666666666667],PARAMETER[\"Latitude_Of_Origin\",39.33333333333334],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3364]]",
        3365=>"PROJCS[\"NAD_1983_HARN_StatePlane_Pennsylvania_South_FIPS_3702_Feet\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",1968500.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-77.75],PARAMETER[\"Standard_Parallel_1\",39.93333333333333],PARAMETER[\"Standard_Parallel_2\",40.96666666666667],PARAMETER[\"Latitude_Of_Origin\",39.33333333333334],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",3365]]",
        3366=>"PROJCS[\"Hong_Kong_1963_Grid_System\",GEOGCS[\"GCS_Hong_Kong_1963\",DATUM[\"D_Hong_Kong_1963\",SPHEROID[\"Clarke_1858\",6378293.645208759,294.260676369]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Cassini\"],PARAMETER[\"False_Easting\",132033.92],PARAMETER[\"False_Northing\",62565.96],PARAMETER[\"Central_Meridian\",114.1785555555556],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",22.31213333333334],UNIT[\"Foot_Clarke\",0.3047972654],AUTHORITY[\"EPSG\",3407]]",
        3367=>"PROJCS[\"IGN_Astro_1960_UTM_Zone_28N\",GEOGCS[\"GCS_IGN_Astro_1960\",DATUM[\"D_IGN_Astro_1960\",SPHEROID[\"Clarke_1880_RGS\",6378249.145,293.465]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-15.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3367]]",
        3368=>"PROJCS[\"IGN_Astro_1960_UTM_Zone_29N\",GEOGCS[\"GCS_IGN_Astro_1960\",DATUM[\"D_IGN_Astro_1960\",SPHEROID[\"Clarke_1880_RGS\",6378249.145,293.465]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-9.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3368]]",
        3369=>"PROJCS[\"IGN_Astro_1960_UTM_Zone_30N\",GEOGCS[\"GCS_IGN_Astro_1960\",DATUM[\"D_IGN_Astro_1960\",SPHEROID[\"Clarke_1880_RGS\",6378249.145,293.465]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-3.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3369]]",
        3370=>"PROJCS[\"NAD_1927_UTM_Zone_59N\",GEOGCS[\"GCS_North_American_1927\",DATUM[\"D_North_American_1927\",SPHEROID[\"Clarke_1866\",6378206.4,294.9786982]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",171.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3370]]",
        3371=>"PROJCS[\"NAD_1927_UTM_Zone_60N\",GEOGCS[\"GCS_North_American_1927\",DATUM[\"D_North_American_1927\",SPHEROID[\"Clarke_1866\",6378206.4,294.9786982]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",177.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3371]]",
        3372=>"PROJCS[\"NAD_1983_UTM_Zone_59N\",GEOGCS[\"GCS_North_American_1983\",DATUM[\"D_North_American_1983\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",171.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3372]]",
        3373=>"PROJCS[\"NAD_1983_UTM_Zone_60N\",GEOGCS[\"GCS_North_American_1983\",DATUM[\"D_North_American_1983\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",177.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3373]]",
        3374=>"PROJCS[\"FD_1954_UTM_Zone_29N\",GEOGCS[\"GCS_FD_1954\",DATUM[\"D_Faroe_Datum_1954\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-9.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3374]]",
        3375=>"PROJCS[\"GDM_2000_MRSO_Peninsular_Malaysia\",GEOGCS[\"GCS_GDM_2000\",DATUM[\"D_GDM_2000\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Rectified_Skew_Orthomorphic_Natural_Origin\"],PARAMETER[\"False_Easting\",804671.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Scale_Factor\",0.99984],PARAMETER[\"Azimuth\",323.0257964666666],PARAMETER[\"Longitude_Of_Center\",102.25],PARAMETER[\"Latitude_Of_Center\",4.0],PARAMETER[\"XY_Plane_Rotation\",-36.86989764584402],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3375]]",
        3376=>"PROJCS[\"GDM_2000_BRSO_East_Malaysia\",GEOGCS[\"GCS_GDM_2000\",DATUM[\"D_GDM_2000\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Rectified_Skew_Orthomorphic_Natural_Origin\"],PARAMETER[\"False_Easting\",0.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Scale_Factor\",0.99984],PARAMETER[\"Azimuth\",53.31580995],PARAMETER[\"Longitude_Of_Center\",115.0],PARAMETER[\"Latitude_Of_Center\",4.0],PARAMETER[\"XY_Plane_Rotation\",53.13010235415598],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3376]]",
        3377=>"PROJCS[\"GDM_2000_State_Cassini_Johor\",GEOGCS[\"GCS_GDM_2000\",DATUM[\"D_GDM_2000\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Cassini\"],PARAMETER[\"False_Easting\",-14810.562],PARAMETER[\"False_Northing\",8758.32],PARAMETER[\"Central_Meridian\",103.4279362361111],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",2.121679744444445],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3377]]",
        3378=>"PROJCS[\"GDM_2000_State_Cassini_Negeri_Sembilan_and_Melaka\",GEOGCS[\"GCS_GDM_2000\",DATUM[\"D_GDM_2000\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Cassini\"],PARAMETER[\"False_Easting\",3673.785],PARAMETER[\"False_Northing\",-4240.573],PARAMETER[\"Central_Meridian\",101.9749050416667],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",2.682347636111111],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3378]]",
        3379=>"PROJCS[\"GDM_2000_State_Cassini_Pahang\",GEOGCS[\"GCS_GDM_2000\",DATUM[\"D_GDM_2000\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Cassini\"],PARAMETER[\"False_Easting\",-7368.228],PARAMETER[\"False_Northing\",6485.858],PARAMETER[\"Central_Meridian\",102.3682989833333],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",3.769388088888889],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3379]]",
        3380=>"PROJCS[\"GDM_2000_State_Cassini_Selangor\",GEOGCS[\"GCS_GDM_2000\",DATUM[\"D_GDM_2000\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Cassini\"],PARAMETER[\"False_Easting\",-34836.161],PARAMETER[\"False_Northing\",56464.049],PARAMETER[\"Central_Meridian\",101.3891079138889],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",3.68464905],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3380]]",
        3381=>"PROJCS[\"GDM_2000_State_Cassini_Terengganu\",GEOGCS[\"GCS_GDM_2000\",DATUM[\"D_GDM_2000\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Cassini\"],PARAMETER[\"False_Easting\",19594.245],PARAMETER[\"False_Northing\",3371.895],PARAMETER[\"Central_Meridian\",103.070275625],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",4.9762852],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3381]]",
        3382=>"PROJCS[\"GDM_2000_State_Cassini_Pulau_Pinang_and_Seberang_Perai\",GEOGCS[\"GCS_GDM_2000\",DATUM[\"D_GDM_2000\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Cassini\"],PARAMETER[\"False_Easting\",-23.414],PARAMETER[\"False_Northing\",62.283],PARAMETER[\"Central_Meridian\",100.3443769638889],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",5.421517541666667],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3382]]",
        3383=>"PROJCS[\"GDM_2000_State_Cassini_Perlis\",GEOGCS[\"GCS_GDM_2000\",DATUM[\"D_GDM_2000\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Cassini\"],PARAMETER[\"False_Easting\",0.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",100.6363711111111],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",5.964672713888889],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3383]]",
        3384=>"PROJCS[\"GDM_2000_State_Cassini_Perak\",GEOGCS[\"GCS_GDM_2000\",DATUM[\"D_GDM_2000\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Cassini\"],PARAMETER[\"False_Easting\",-1.769],PARAMETER[\"False_Northing\",133454.779],PARAMETER[\"Central_Meridian\",100.8154105861111],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",4.859063022222222],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3384]]",
        3385=>"PROJCS[\"GDM_2000_State_Cassini_Kelantan\",GEOGCS[\"GCS_GDM_2000\",DATUM[\"D_GDM_2000\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Cassini\"],PARAMETER[\"False_Easting\",13227.851],PARAMETER[\"False_Northing\",8739.894],PARAMETER[\"Central_Meridian\",102.2952416694444],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",5.972543658333334],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3385]]",
        3386=>"PROJCS[\"KKJ_Finland_Zone_0\",GEOGCS[\"GCS_KKJ\",DATUM[\"D_KKJ\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",18.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3386]]",
        3387=>"PROJCS[\"KKJ_Finland_Zone_5\",GEOGCS[\"GCS_KKJ\",DATUM[\"D_KKJ\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",5500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",33.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3387]]",
        3388=>"PROJCS[\"Pulkovo_1942_Caspian_Sea_Mercator\",GEOGCS[\"GCS_Pulkovo_1942\",DATUM[\"D_Pulkovo_1942\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Mercator\"],PARAMETER[\"False_Easting\",0.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",51.0],PARAMETER[\"Standard_Parallel_1\",42.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3388]]",
        3389=>"PROJCS[\"Pulkovo_1942_3_Degree_GK_Zone_60\",GEOGCS[\"GCS_Pulkovo_1942\",DATUM[\"D_Pulkovo_1942\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",60500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",180.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3389]]",
        3390=>"PROJCS[\"Pulkovo_1995_3_Degree_GK_Zone_60\",GEOGCS[\"GCS_Pulkovo_1995\",DATUM[\"D_Pulkovo_1995\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",60500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",180.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3390]]",
        3391=>"PROJCS[\"Karbala_1979_Polservice_UTM_Zone_37N\",GEOGCS[\"GCS_Karbala_1979_Polservice\",DATUM[\"D_Karbala_1979_Polservice\",SPHEROID[\"Clarke_1880_RGS\",6378249.145,293.465]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",39.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3391]]",
        3392=>"PROJCS[\"Karbala_1979_Polservice_UTM_Zone_38N\",GEOGCS[\"GCS_Karbala_1979_Polservice\",DATUM[\"D_Karbala_1979_Polservice\",SPHEROID[\"Clarke_1880_RGS\",6378249.145,293.465]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",45.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3392]]",
        3393=>"PROJCS[\"Karbala_1979_Polservice_UTM_Zone_39N\",GEOGCS[\"GCS_Karbala_1979_Polservice\",DATUM[\"D_Karbala_1979_Polservice\",SPHEROID[\"Clarke_1880_RGS\",6378249.145,293.465]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",51.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3393]]",
        3394=>"PROJCS[\"Nahrwan_1934_Iraq_Zone\",GEOGCS[\"GCS_Nahrwan_1934\",DATUM[\"D_Nahrwan_1934\",SPHEROID[\"Clarke_1880_RGS\",6378249.145,293.465]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",1500000.0],PARAMETER[\"False_Northing\",1166200.0],PARAMETER[\"Central_Meridian\",45.0],PARAMETER[\"Standard_Parallel_1\",32.5],PARAMETER[\"Scale_Factor\",0.9987864078],PARAMETER[\"Latitude_Of_Origin\",32.5],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3394]]",
        3395=>"PROJCS[\"WGS_1984_World_Mercator\",GEOGCS[\"GCS_WGS_1984\",DATUM[\"D_WGS_1984\",SPHEROID[\"WGS_1984\",6378137.0,298.257223563]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Mercator\"],PARAMETER[\"False_Easting\",0.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",0.0],PARAMETER[\"Standard_Parallel_1\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3395]]",
        3396=>"PROJCS[\"PD/83_GK_Zone_3\",GEOGCS[\"GCS_PD/83\",DATUM[\"D_Potsdam_1983\",SPHEROID[\"Bessel_1841\",6377397.155,299.1528128]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",3500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",9.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3396]]",
        3397=>"PROJCS[\"PD/83_GK_Zone_4\",GEOGCS[\"GCS_PD/83\",DATUM[\"D_Potsdam_1983\",SPHEROID[\"Bessel_1841\",6377397.155,299.1528128]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",4500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",12.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3397]]",
        3398=>"PROJCS[\"RD/83_GK_Zone_4\",GEOGCS[\"GCS_RD/83\",DATUM[\"D_Rauenberg_1983\",SPHEROID[\"Bessel_1841\",6377397.155,299.1528128]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",4500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",12.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3398]]",
        3399=>"PROJCS[\"RD/83_GK_Zone_5\",GEOGCS[\"GCS_RD/83\",DATUM[\"D_Rauenberg_1983\",SPHEROID[\"Bessel_1841\",6377397.155,299.1528128]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",5500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",15.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3399]]",
        3400=>"PROJCS[\"NAD_1983_10TM_AEP_Forest\",GEOGCS[\"GCS_North_American_1983\",DATUM[\"D_North_American_1983\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-115.0],PARAMETER[\"Scale_Factor\",0.9992],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3400]]",
        3401=>"PROJCS[\"NAD_1983_10TM_AEP_Resource\",GEOGCS[\"GCS_North_American_1983\",DATUM[\"D_North_American_1983\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",0.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-115.0],PARAMETER[\"Scale_Factor\",0.9992],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3401]]",
        3402=>"PROJCS[\"NAD_1983_CSRS_10TM_AEP_Forest\",GEOGCS[\"GCS_North_American_1983_CSRS\",DATUM[\"D_North_American_1983_CSRS\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-115.0],PARAMETER[\"Scale_Factor\",0.9992],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3402]]",
        3403=>"PROJCS[\"NAD_1983_CSRS_10TM_AEP_Resource\",GEOGCS[\"GCS_North_American_1983_CSRS\",DATUM[\"D_North_American_1983_CSRS\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",0.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-115.0],PARAMETER[\"Scale_Factor\",0.9992],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3403]]",
        3404=>"PROJCS[\"NAD_1983_HARN_StatePlane_North_Carolina_FIPS_3200_Feet\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",2000000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-79.0],PARAMETER[\"Standard_Parallel_1\",34.33333333333334],PARAMETER[\"Standard_Parallel_2\",36.16666666666666],PARAMETER[\"Latitude_Of_Origin\",33.75],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",3404]]",
        3405=>"PROJCS[\"VN_2000_UTM_Zone_48N\",GEOGCS[\"GCS_VN_2000\",DATUM[\"D_Vietnam_2000\",SPHEROID[\"WGS_1984\",6378137.0,298.257223563]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",105.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3405]]",
        3406=>"PROJCS[\"VN_2000_UTM_Zone_49N\",GEOGCS[\"GCS_VN_2000\",DATUM[\"D_Vietnam_2000\",SPHEROID[\"WGS_1984\",6378137.0,298.257223563]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",111.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3406]]",
        3407=>"PROJCS[\"Hong_Kong_1963_Grid_System\",GEOGCS[\"GCS_Hong_Kong_1963\",DATUM[\"D_Hong_Kong_1963\",SPHEROID[\"Clarke_1858\",6378293.645208759,294.260676369]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Cassini\"],PARAMETER[\"False_Easting\",132033.92],PARAMETER[\"False_Northing\",62565.96],PARAMETER[\"Central_Meridian\",114.1785555555556],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",22.31213333333334],UNIT[\"Foot_Clarke\",0.3047972654],AUTHORITY[\"EPSG\",3407]]",
        3408=>"PROJCS[\"NSIDC_EASE_Grid_North\",GEOGCS[\"GCS_Sphere_International_1924_Authalic\",DATUM[\"D_Sphere_International_1924_Authalic\",SPHEROID[\"Sphere_International_1924_Authalic\",6371228.0,0.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Azimuthal_Equal_Area\"],PARAMETER[\"False_Easting\",0.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",0.0],PARAMETER[\"Latitude_Of_Origin\",90.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3408]]",
        3409=>"PROJCS[\"NSIDC_EASE_Grid_South\",GEOGCS[\"GCS_Sphere_International_1924_Authalic\",DATUM[\"D_Sphere_International_1924_Authalic\",SPHEROID[\"Sphere_International_1924_Authalic\",6371228.0,0.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Azimuthal_Equal_Area\"],PARAMETER[\"False_Easting\",0.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",0.0],PARAMETER[\"Latitude_Of_Origin\",-90.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3409]]",
        3410=>"PROJCS[\"NSIDC_EASE_Grid_Global\",GEOGCS[\"GCS_Sphere_International_1924_Authalic\",DATUM[\"D_Sphere_International_1924_Authalic\",SPHEROID[\"Sphere_International_1924_Authalic\",6371228.0,0.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Cylindrical_Equal_Area\"],PARAMETER[\"False_Easting\",0.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",0.0],PARAMETER[\"Standard_Parallel_1\",30.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3410]]",
        3411=>"PROJCS[\"NSIDC_Sea_Ice_Polar_Stereographic_North\",GEOGCS[\"GCS_Hughes_1980\",DATUM[\"D_Hughes_1980\",SPHEROID[\"Hughes_1980\",6378273.0,298.279411123064]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Stereographic_North_Pole\"],PARAMETER[\"False_Easting\",0.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-45.0],PARAMETER[\"Standard_Parallel_1\",70.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3411]]",
        3412=>"PROJCS[\"NSIDC_Sea_Ice_Polar_Stereographic_South\",GEOGCS[\"GCS_Hughes_1980\",DATUM[\"D_Hughes_1980\",SPHEROID[\"Hughes_1980\",6378273.0,298.279411123064]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Stereographic_South_Pole\"],PARAMETER[\"False_Easting\",0.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",0.0],PARAMETER[\"Standard_Parallel_1\",-70.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3412]]",
        3413=>"PROJCS[\"WGS_1984_NSIDC_Sea_Ice_Polar_Stereographic_North\",GEOGCS[\"GCS_WGS_1984\",DATUM[\"D_WGS_1984\",SPHEROID[\"WGS_1984\",6378137.0,298.257223563]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Stereographic_North_Pole\"],PARAMETER[\"False_Easting\",0.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-45.0],PARAMETER[\"Standard_Parallel_1\",70.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3413]]",
        3414=>"PROJCS[\"SVY21_Singapore_TM\",GEOGCS[\"GCS_SVY21\",DATUM[\"D_SVY21\",SPHEROID[\"WGS_1984\",6378137.0,298.257223563]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",28001.642],PARAMETER[\"False_Northing\",38744.572],PARAMETER[\"Central_Meridian\",103.8333333333333],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",1.366666666666667],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3414]]",
        3415=>"PROJCS[\"WGS_1972_BE_South_China_Sea_Lambert\",GEOGCS[\"GCS_WGS_1972_BE\",DATUM[\"D_WGS_1972_BE\",SPHEROID[\"WGS_1972\",6378135.0,298.26]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",500000.0],PARAMETER[\"Central_Meridian\",114.0],PARAMETER[\"Standard_Parallel_1\",18.0],PARAMETER[\"Standard_Parallel_2\",24.0],PARAMETER[\"Latitude_Of_Origin\",21.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3415]]",
        3416=>"PROJCS[\"ETRS_1989_Austria_Lambert\",GEOGCS[\"GCS_ETRS_1989\",DATUM[\"D_ETRS_1989\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",400000.0],PARAMETER[\"False_Northing\",400000.0],PARAMETER[\"Central_Meridian\",13.33333333333333],PARAMETER[\"Standard_Parallel_1\",46.0],PARAMETER[\"Standard_Parallel_2\",49.0],PARAMETER[\"Latitude_Of_Origin\",47.5],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3416]]",
        3417=>"PROJCS[\"NAD_1983_StatePlane_Iowa_North_FIPS_1401_Feet\",GEOGCS[\"GCS_North_American_1983\",DATUM[\"D_North_American_1983\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",4921250.0],PARAMETER[\"False_Northing\",3280833.333333333],PARAMETER[\"Central_Meridian\",-93.5],PARAMETER[\"Standard_Parallel_1\",42.06666666666667],PARAMETER[\"Standard_Parallel_2\",43.26666666666667],PARAMETER[\"Latitude_Of_Origin\",41.5],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",3417]]",
        3418=>"PROJCS[\"NAD_1983_StatePlane_Iowa_South_FIPS_1402_Feet\",GEOGCS[\"GCS_North_American_1983\",DATUM[\"D_North_American_1983\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",1640416.666666667],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-93.5],PARAMETER[\"Standard_Parallel_1\",40.61666666666667],PARAMETER[\"Standard_Parallel_2\",41.78333333333333],PARAMETER[\"Latitude_Of_Origin\",40.0],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",3418]]",
        3419=>"PROJCS[\"NAD_1983_StatePlane_Kansas_North_FIPS_1501_Feet\",GEOGCS[\"GCS_North_American_1983\",DATUM[\"D_North_American_1983\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",1312333.333333333],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-98.0],PARAMETER[\"Standard_Parallel_1\",38.71666666666667],PARAMETER[\"Standard_Parallel_2\",39.78333333333333],PARAMETER[\"Latitude_Of_Origin\",38.33333333333334],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",3419]]",
        3420=>"PROJCS[\"NAD_1983_StatePlane_Kansas_South_FIPS_1502_Feet\",GEOGCS[\"GCS_North_American_1983\",DATUM[\"D_North_American_1983\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",1312333.333333333],PARAMETER[\"False_Northing\",1312333.333333333],PARAMETER[\"Central_Meridian\",-98.5],PARAMETER[\"Standard_Parallel_1\",37.26666666666667],PARAMETER[\"Standard_Parallel_2\",38.56666666666667],PARAMETER[\"Latitude_Of_Origin\",36.66666666666666],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",3420]]",
        3421=>"PROJCS[\"NAD_1983_StatePlane_Nevada_East_FIPS_2701_Feet\",GEOGCS[\"GCS_North_American_1983\",DATUM[\"D_North_American_1983\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",656166.6666666665],PARAMETER[\"False_Northing\",26246666.66666666],PARAMETER[\"Central_Meridian\",-115.5833333333333],PARAMETER[\"Scale_Factor\",0.9999],PARAMETER[\"Latitude_Of_Origin\",34.75],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",3421]]",
        3422=>"PROJCS[\"NAD_1983_StatePlane_Nevada_Central_FIPS_2702_Feet\",GEOGCS[\"GCS_North_American_1983\",DATUM[\"D_North_American_1983\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",1640416.666666667],PARAMETER[\"False_Northing\",19685000.0],PARAMETER[\"Central_Meridian\",-116.6666666666667],PARAMETER[\"Scale_Factor\",0.9999],PARAMETER[\"Latitude_Of_Origin\",34.75],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",3422]]",
        3423=>"PROJCS[\"NAD_1983_StatePlane_Nevada_West_FIPS_2703_Feet\",GEOGCS[\"GCS_North_American_1983\",DATUM[\"D_North_American_1983\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",2624666.666666666],PARAMETER[\"False_Northing\",13123333.33333333],PARAMETER[\"Central_Meridian\",-118.5833333333333],PARAMETER[\"Scale_Factor\",0.9999],PARAMETER[\"Latitude_Of_Origin\",34.75],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",3423]]",
        3424=>"PROJCS[\"NAD_1983_StatePlane_New_Jersey_FIPS_2900_Feet\",GEOGCS[\"GCS_North_American_1983\",DATUM[\"D_North_American_1983\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",492125.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-74.5],PARAMETER[\"Scale_Factor\",0.9999],PARAMETER[\"Latitude_Of_Origin\",38.83333333333334],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",3424]]",
        3425=>"PROJCS[\"NAD_1983_HARN_StatePlane_Iowa_North_FIPS_1401_Feet\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",4921250.0],PARAMETER[\"False_Northing\",3280833.333333333],PARAMETER[\"Central_Meridian\",-93.5],PARAMETER[\"Standard_Parallel_1\",42.06666666666667],PARAMETER[\"Standard_Parallel_2\",43.26666666666667],PARAMETER[\"Latitude_Of_Origin\",41.5],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",3425]]",
        3426=>"PROJCS[\"NAD_1983_HARN_StatePlane_Iowa_South_FIPS_1402_Feet\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",1640416.666666667],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-93.5],PARAMETER[\"Standard_Parallel_1\",40.61666666666667],PARAMETER[\"Standard_Parallel_2\",41.78333333333333],PARAMETER[\"Latitude_Of_Origin\",40.0],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",3426]]",
        3427=>"PROJCS[\"NAD_1983_HARN_StatePlane_Kansas_North_FIPS_1501_Feet\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",1312333.333333333],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-98.0],PARAMETER[\"Standard_Parallel_1\",38.71666666666667],PARAMETER[\"Standard_Parallel_2\",39.78333333333333],PARAMETER[\"Latitude_Of_Origin\",38.33333333333334],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",3427]]",
        3428=>"PROJCS[\"NAD_1983_HARN_StatePlane_Kansas_South_FIPS_1502_Feet\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",1312333.333333333],PARAMETER[\"False_Northing\",1312333.333333333],PARAMETER[\"Central_Meridian\",-98.5],PARAMETER[\"Standard_Parallel_1\",37.26666666666667],PARAMETER[\"Standard_Parallel_2\",38.56666666666667],PARAMETER[\"Latitude_Of_Origin\",36.66666666666666],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",3428]]",
        3429=>"PROJCS[\"NAD_1983_HARN_StatePlane_Nevada_East_FIPS_2701_Feet\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",656166.6666666665],PARAMETER[\"False_Northing\",26246666.66666666],PARAMETER[\"Central_Meridian\",-115.5833333333333],PARAMETER[\"Scale_Factor\",0.9999],PARAMETER[\"Latitude_Of_Origin\",34.75],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",3429]]",
        3430=>"PROJCS[\"NAD_1983_HARN_StatePlane_Nevada_Central_FIPS_2702_Feet\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",1640416.666666667],PARAMETER[\"False_Northing\",19685000.0],PARAMETER[\"Central_Meridian\",-116.6666666666667],PARAMETER[\"Scale_Factor\",0.9999],PARAMETER[\"Latitude_Of_Origin\",34.75],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",3430]]",
        3431=>"PROJCS[\"NAD_1983_HARN_StatePlane_Nevada_West_FIPS_2703_Feet\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",2624666.666666666],PARAMETER[\"False_Northing\",13123333.33333333],PARAMETER[\"Central_Meridian\",-118.5833333333333],PARAMETER[\"Scale_Factor\",0.9999],PARAMETER[\"Latitude_Of_Origin\",34.75],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",3431]]",
        3432=>"PROJCS[\"NAD_1983_HARN_StatePlane_New_Jersey_FIPS_2900_Feet\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",492125.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-74.5],PARAMETER[\"Scale_Factor\",0.9999],PARAMETER[\"Latitude_Of_Origin\",38.83333333333334],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",3432]]",
        3433=>"PROJCS[\"NAD_1983_StatePlane_Arkansas_North_FIPS_0301_Feet\",GEOGCS[\"GCS_North_American_1983\",DATUM[\"D_North_American_1983\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",1312333.333333333],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-92.0],PARAMETER[\"Standard_Parallel_1\",34.93333333333333],PARAMETER[\"Standard_Parallel_2\",36.23333333333333],PARAMETER[\"Latitude_Of_Origin\",34.33333333333334],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",3433]]",
        3434=>"PROJCS[\"NAD_1983_StatePlane_Arkansas_South_FIPS_0302_Feet\",GEOGCS[\"GCS_North_American_1983\",DATUM[\"D_North_American_1983\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",1312333.333333333],PARAMETER[\"False_Northing\",1312333.333333333],PARAMETER[\"Central_Meridian\",-92.0],PARAMETER[\"Standard_Parallel_1\",33.3],PARAMETER[\"Standard_Parallel_2\",34.76666666666667],PARAMETER[\"Latitude_Of_Origin\",32.66666666666666],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",3434]]",
        3435=>"PROJCS[\"NAD_1983_StatePlane_Illinois_East_FIPS_1201_Feet\",GEOGCS[\"GCS_North_American_1983\",DATUM[\"D_North_American_1983\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",984250.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-88.33333333333333],PARAMETER[\"Scale_Factor\",0.999975],PARAMETER[\"Latitude_Of_Origin\",36.66666666666666],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",3435]]",
        3436=>"PROJCS[\"NAD_1983_StatePlane_Illinois_West_FIPS_1202_Feet\",GEOGCS[\"GCS_North_American_1983\",DATUM[\"D_North_American_1983\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",2296583.333333333],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-90.16666666666667],PARAMETER[\"Scale_Factor\",0.9999411764705882],PARAMETER[\"Latitude_Of_Origin\",36.66666666666666],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",3436]]",
        3437=>"PROJCS[\"NAD_1983_StatePlane_New_Hampshire_FIPS_2800_Feet\",GEOGCS[\"GCS_North_American_1983\",DATUM[\"D_North_American_1983\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",984250.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-71.66666666666667],PARAMETER[\"Scale_Factor\",0.9999666666666667],PARAMETER[\"Latitude_Of_Origin\",42.5],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",3437]]",
        3438=>"PROJCS[\"NAD_1983_StatePlane_Rhode_Island_FIPS_3800_Feet\",GEOGCS[\"GCS_North_American_1983\",DATUM[\"D_North_American_1983\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",328083.3333333333],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-71.5],PARAMETER[\"Scale_Factor\",0.99999375],PARAMETER[\"Latitude_Of_Origin\",41.08333333333334],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",3438]]",
        3439=>"PROJCS[\"PDO_1993_UTM_Zone_39N\",GEOGCS[\"GCS_PDO_1993\",DATUM[\"D_PDO_1993\",SPHEROID[\"Clarke_1880_RGS\",6378249.145,293.465]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",51.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3439]]",
        3440=>"PROJCS[\"PDO_1993_UTM_Zone_40N\",GEOGCS[\"GCS_PDO_1993\",DATUM[\"D_PDO_1993\",SPHEROID[\"Clarke_1880_RGS\",6378249.145,293.465]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",57.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3440]]",
        3441=>"PROJCS[\"NAD_1983_HARN_StatePlane_Arkansas_North_FIPS_0301_Feet\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",1312333.333333333],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-92.0],PARAMETER[\"Standard_Parallel_1\",34.93333333333333],PARAMETER[\"Standard_Parallel_2\",36.23333333333333],PARAMETER[\"Latitude_Of_Origin\",34.33333333333334],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",3441]]",
        3442=>"PROJCS[\"NAD_1983_HARN_StatePlane_Arkansas_South_FIPS_0302_Feet\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",1312333.333333333],PARAMETER[\"False_Northing\",1312333.333333333],PARAMETER[\"Central_Meridian\",-92.0],PARAMETER[\"Standard_Parallel_1\",33.3],PARAMETER[\"Standard_Parallel_2\",34.76666666666667],PARAMETER[\"Latitude_Of_Origin\",32.66666666666666],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",3442]]",
        3443=>"PROJCS[\"NAD_1983_HARN_StatePlane_Illinois_East_FIPS_1201_Feet\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",984250.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-88.33333333333333],PARAMETER[\"Scale_Factor\",0.999975],PARAMETER[\"Latitude_Of_Origin\",36.66666666666666],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",3443]]",
        3444=>"PROJCS[\"NAD_1983_HARN_StatePlane_Illinois_West_FIPS_1202_Feet\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",2296583.333333333],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-90.16666666666667],PARAMETER[\"Scale_Factor\",0.9999411764705882],PARAMETER[\"Latitude_Of_Origin\",36.66666666666666],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",3444]]",
        3445=>"PROJCS[\"NAD_1983_HARN_StatePlane_New_Hampshire_FIPS_2800_Feet\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",984250.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-71.66666666666667],PARAMETER[\"Scale_Factor\",0.9999666666666667],PARAMETER[\"Latitude_Of_Origin\",42.5],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",3445]]",
        3446=>"PROJCS[\"NAD_1983_HARN_StatePlane_Rhode_Island_FIPS_3800_Feet\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",328083.3333333333],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-71.5],PARAMETER[\"Scale_Factor\",0.99999375],PARAMETER[\"Latitude_Of_Origin\",41.08333333333334],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",3446]]",
        3447=>"PROJCS[\"Belge_Lambert_2005\",GEOGCS[\"GCS_ETRS_1989\",DATUM[\"D_ETRS_1989\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",150328.0],PARAMETER[\"False_Northing\",166262.0],PARAMETER[\"Central_Meridian\",4.359215833333333],PARAMETER[\"Standard_Parallel_1\",49.83333333333334],PARAMETER[\"Standard_Parallel_2\",51.16666666666666],PARAMETER[\"Latitude_Of_Origin\",50.797815],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3447]]",
        3448=>"PROJCS[\"JAD_2001_Jamaica_Grid\",GEOGCS[\"GCS_JAD_2001\",DATUM[\"D_Jamaica_2001\",SPHEROID[\"WGS_1984\",6378137.0,298.257223563]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",750000.0],PARAMETER[\"False_Northing\",650000.0],PARAMETER[\"Central_Meridian\",-77.0],PARAMETER[\"Standard_Parallel_1\",18.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",18.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3448]]",
        3449=>"PROJCS[\"JAD_2001_UTM_Zone_17N\",GEOGCS[\"GCS_JAD_2001\",DATUM[\"D_Jamaica_2001\",SPHEROID[\"WGS_1984\",6378137.0,298.257223563]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-81.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3449]]",
        3450=>"PROJCS[\"JAD_2001_UTM_Zone_18N\",GEOGCS[\"GCS_JAD_2001\",DATUM[\"D_Jamaica_2001\",SPHEROID[\"WGS_1984\",6378137.0,298.257223563]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-75.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3450]]",
        3451=>"PROJCS[\"NAD_1983_StatePlane_Louisiana_North_FIPS_1701_Feet\",GEOGCS[\"GCS_North_American_1983\",DATUM[\"D_North_American_1983\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",3280833.333333333],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-92.5],PARAMETER[\"Standard_Parallel_1\",31.16666666666667],PARAMETER[\"Standard_Parallel_2\",32.66666666666666],PARAMETER[\"Latitude_Of_Origin\",30.5],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",3451]]",
        3452=>"PROJCS[\"NAD_1983_StatePlane_Louisiana_South_FIPS_1702_Feet\",GEOGCS[\"GCS_North_American_1983\",DATUM[\"D_North_American_1983\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",3280833.333333333],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-91.33333333333333],PARAMETER[\"Standard_Parallel_1\",29.3],PARAMETER[\"Standard_Parallel_2\",30.7],PARAMETER[\"Latitude_Of_Origin\",28.5],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",3452]]",
        3453=>"PROJCS[\"NAD_1983_StatePlane_Louisiana_Offshore_FIPS_1703_Feet\",GEOGCS[\"GCS_North_American_1983\",DATUM[\"D_North_American_1983\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",3280833.333333333],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-91.33333333333333],PARAMETER[\"Standard_Parallel_1\",26.16666666666667],PARAMETER[\"Standard_Parallel_2\",27.83333333333333],PARAMETER[\"Latitude_Of_Origin\",25.5],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",3453]]",
        3454=>"PROJCS[\"NAD_1983_StatePlane_South_Dakota_North_FIPS_4001_Feet\",GEOGCS[\"GCS_North_American_1983\",DATUM[\"D_North_American_1983\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",1968500.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-100.0],PARAMETER[\"Standard_Parallel_1\",44.41666666666666],PARAMETER[\"Standard_Parallel_2\",45.68333333333333],PARAMETER[\"Latitude_Of_Origin\",43.83333333333334],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",4457]]",
        3455=>"PROJCS[\"NAD_1983_StatePlane_South_Dakota_South_FIPS_4002_Feet\",GEOGCS[\"GCS_North_American_1983\",DATUM[\"D_North_American_1983\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",1968500.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-100.3333333333333],PARAMETER[\"Standard_Parallel_1\",42.83333333333334],PARAMETER[\"Standard_Parallel_2\",44.4],PARAMETER[\"Latitude_Of_Origin\",42.33333333333334],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",3455]]",
        3456=>"PROJCS[\"NAD_1983_HARN_StatePlane_Louisiana_North_FIPS_1701_Feet\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",3280833.333333333],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-92.5],PARAMETER[\"Standard_Parallel_1\",31.16666666666667],PARAMETER[\"Standard_Parallel_2\",32.66666666666666],PARAMETER[\"Latitude_Of_Origin\",30.5],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",3456]]",
        3457=>"PROJCS[\"NAD_1983_HARN_StatePlane_Louisiana_South_FIPS_1702_Feet\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",3280833.333333333],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-91.33333333333333],PARAMETER[\"Standard_Parallel_1\",29.3],PARAMETER[\"Standard_Parallel_2\",30.7],PARAMETER[\"Latitude_Of_Origin\",28.5],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",3457]]",
        3458=>"PROJCS[\"NAD_1983_HARN_StatePlane_South_Dakota_North_FIPS_4001_Feet\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",1968500.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-100.0],PARAMETER[\"Standard_Parallel_1\",44.41666666666666],PARAMETER[\"Standard_Parallel_2\",45.68333333333333],PARAMETER[\"Latitude_Of_Origin\",43.83333333333334],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",3458]]",
        3459=>"PROJCS[\"NAD_1983_HARN_StatePlane_South_Dakota_South_FIPS_4002_Feet\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",1968500.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-100.3333333333333],PARAMETER[\"Standard_Parallel_1\",42.83333333333334],PARAMETER[\"Standard_Parallel_2\",44.4],PARAMETER[\"Latitude_Of_Origin\",42.33333333333334],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",3459]]",
        3460=>"PROJCS[\"Fiji_1986_Fiji_Map_Grid\",GEOGCS[\"GCS_Fiji_1986\",DATUM[\"D_Fiji_1986\",SPHEROID[\"WGS_1972\",6378135.0,298.26]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",2000000.0],PARAMETER[\"False_Northing\",4000000.0],PARAMETER[\"Central_Meridian\",178.75],PARAMETER[\"Scale_Factor\",0.99985],PARAMETER[\"Latitude_Of_Origin\",-17.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3460]]",
        3461=>"PROJCS[\"Dabola_1981_UTM_Zone_28N\",GEOGCS[\"GCS_Dabola_1981\",DATUM[\"D_Dabola_1981\",SPHEROID[\"Clarke_1880_IGN\",6378249.2,293.4660212936265]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-15.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3461]]",
        3462=>"PROJCS[\"Dabola_1981_UTM_Zone_29N\",GEOGCS[\"GCS_Dabola_1981\",DATUM[\"D_Dabola_1981\",SPHEROID[\"Clarke_1880_IGN\",6378249.2,293.4660212936265]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-9.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3462]]",
        3463=>"PROJCS[\"NAD_1983_Maine_2000_Central_Zone\",GEOGCS[\"GCS_North_American_1983\",DATUM[\"D_North_American_1983\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-69.125],PARAMETER[\"Scale_Factor\",0.99998],PARAMETER[\"Latitude_Of_Origin\",43.5],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3463]]",
        3464=>"PROJCS[\"NAD_1983_HARN_Maine_2000_Central_Zone\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-69.125],PARAMETER[\"Scale_Factor\",0.99998],PARAMETER[\"Latitude_Of_Origin\",43.5],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3464]]",
        3465=>"PROJCS[\"NAD_1983_NSRS2007_StatePlane_Alabama_East_FIPS_0101\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",200000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-85.83333333333333],PARAMETER[\"Scale_Factor\",0.99996],PARAMETER[\"Latitude_Of_Origin\",30.5],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3465]]",
        3466=>"PROJCS[\"NAD_1983_NSRS2007_StatePlane_Alabama_West_FIPS_0102\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",600000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-87.5],PARAMETER[\"Scale_Factor\",0.9999333333333333],PARAMETER[\"Latitude_Of_Origin\",30.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3466]]",
        3467=>"PROJCS[\"NAD_1983_NSRS2007_Alaska_Albers\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Albers\"],PARAMETER[\"False_Easting\",0.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-154.0],PARAMETER[\"Standard_Parallel_1\",55.0],PARAMETER[\"Standard_Parallel_2\",65.0],PARAMETER[\"Latitude_Of_Origin\",50.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3467]]",
        3468=>"PROJCS[\"NAD_1983_NSRS2007_StatePlane_Alaska_1_FIPS_5001\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Hotine_Oblique_Mercator_Azimuth_Natural_Origin\"],PARAMETER[\"False_Easting\",5000000.0],PARAMETER[\"False_Northing\",-5000000.0],PARAMETER[\"Scale_Factor\",0.9999],PARAMETER[\"Azimuth\",-36.86989764583333],PARAMETER[\"Longitude_Of_Center\",-133.6666666666667],PARAMETER[\"Latitude_Of_Center\",57.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3468]]",
        3469=>"PROJCS[\"NAD_1983_NSRS2007_StatePlane_Alaska_2_FIPS_5002\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-142.0],PARAMETER[\"Scale_Factor\",0.9999],PARAMETER[\"Latitude_Of_Origin\",54.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3469]]",
        3470=>"PROJCS[\"NAD_1983_NSRS2007_StatePlane_Alaska_3_FIPS_5003\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-146.0],PARAMETER[\"Scale_Factor\",0.9999],PARAMETER[\"Latitude_Of_Origin\",54.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3470]]",
        3471=>"PROJCS[\"NAD_1983_NSRS2007_StatePlane_Alaska_4_FIPS_5004\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-150.0],PARAMETER[\"Scale_Factor\",0.9999],PARAMETER[\"Latitude_Of_Origin\",54.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3471]]",
        3472=>"PROJCS[\"NAD_1983_NSRS2007_StatePlane_Alaska_5_FIPS_5005\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-154.0],PARAMETER[\"Scale_Factor\",0.9999],PARAMETER[\"Latitude_Of_Origin\",54.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3472]]",
        3473=>"PROJCS[\"NAD_1983_NSRS2007_StatePlane_Alaska_6_FIPS_5006\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-158.0],PARAMETER[\"Scale_Factor\",0.9999],PARAMETER[\"Latitude_Of_Origin\",54.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3473]]",
        3474=>"PROJCS[\"NAD_1983_NSRS2007_StatePlane_Alaska_7_FIPS_5007\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-162.0],PARAMETER[\"Scale_Factor\",0.9999],PARAMETER[\"Latitude_Of_Origin\",54.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3474]]",
        3475=>"PROJCS[\"NAD_1983_NSRS2007_StatePlane_Alaska_8_FIPS_5008\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-166.0],PARAMETER[\"Scale_Factor\",0.9999],PARAMETER[\"Latitude_Of_Origin\",54.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3475]]",
        3476=>"PROJCS[\"NAD_1983_NSRS2007_StatePlane_Alaska_9_FIPS_5009\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-170.0],PARAMETER[\"Scale_Factor\",0.9999],PARAMETER[\"Latitude_Of_Origin\",54.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3476]]",
        3477=>"PROJCS[\"NAD_1983_NSRS2007_StatePlane_Alaska_10_FIPS_5010\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",1000000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-176.0],PARAMETER[\"Standard_Parallel_1\",51.83333333333334],PARAMETER[\"Standard_Parallel_2\",53.83333333333334],PARAMETER[\"Latitude_Of_Origin\",51.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3477]]",
        3478=>"PROJCS[\"NAD_1983_NSRS2007_StatePlane_Arizona_Central_FIPS_0202\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",213360.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-111.9166666666667],PARAMETER[\"Scale_Factor\",0.9999],PARAMETER[\"Latitude_Of_Origin\",31.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3478]]",
        3479=>"PROJCS[\"NAD_1983_NSRS2007_StatePlane_Arizona_Central_FIPS_0202_Ft_Intl\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",700000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-111.9166666666667],PARAMETER[\"Scale_Factor\",0.9999],PARAMETER[\"Latitude_Of_Origin\",31.0],UNIT[\"Foot\",0.3048],AUTHORITY[\"EPSG\",3479]]",
        3480=>"PROJCS[\"NAD_1983_NSRS2007_StatePlane_Arizona_East_FIPS_0201\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",213360.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-110.1666666666667],PARAMETER[\"Scale_Factor\",0.9999],PARAMETER[\"Latitude_Of_Origin\",31.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3480]]",
        3481=>"PROJCS[\"NAD_1983_NSRS2007_StatePlane_Arizona_East_FIPS_0201_Ft_Intl\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",700000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-110.1666666666667],PARAMETER[\"Scale_Factor\",0.9999],PARAMETER[\"Latitude_Of_Origin\",31.0],UNIT[\"Foot\",0.3048],AUTHORITY[\"EPSG\",3481]]",
        3482=>"PROJCS[\"NAD_1983_NSRS2007_StatePlane_Arizona_West_FIPS_0203\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",213360.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-113.75],PARAMETER[\"Scale_Factor\",0.9999333333333333],PARAMETER[\"Latitude_Of_Origin\",31.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3482]]",
        3483=>"PROJCS[\"NAD_1983_NSRS2007_StatePlane_Arizona_West_FIPS_0203_Ft_Intl\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",700000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-113.75],PARAMETER[\"Scale_Factor\",0.9999333333333333],PARAMETER[\"Latitude_Of_Origin\",31.0],UNIT[\"Foot\",0.3048],AUTHORITY[\"EPSG\",3483]]",
        3484=>"PROJCS[\"NAD_1983_NSRS2007_StatePlane_Arkansas_North_FIPS_0301\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",400000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-92.0],PARAMETER[\"Standard_Parallel_1\",34.93333333333333],PARAMETER[\"Standard_Parallel_2\",36.23333333333333],PARAMETER[\"Latitude_Of_Origin\",34.33333333333334],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3484]]",
        3485=>"PROJCS[\"NAD_1983_NSRS2007_StatePlane_Arkansas_North_FIPS_0301_Ft_US\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",1312333.333333333],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-92.0],PARAMETER[\"Standard_Parallel_1\",34.93333333333333],PARAMETER[\"Standard_Parallel_2\",36.23333333333333],PARAMETER[\"Latitude_Of_Origin\",34.33333333333334],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",3485]]",
        3486=>"PROJCS[\"NAD_1983_NSRS2007_StatePlane_Arkansas_South_FIPS_0302\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",400000.0],PARAMETER[\"False_Northing\",400000.0],PARAMETER[\"Central_Meridian\",-92.0],PARAMETER[\"Standard_Parallel_1\",33.3],PARAMETER[\"Standard_Parallel_2\",34.76666666666667],PARAMETER[\"Latitude_Of_Origin\",32.66666666666666],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3486]]",
        3487=>"PROJCS[\"NAD_1983_NSRS2007_StatePlane_Arkansas_South_FIPS_0302_Ft_US\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",1312333.333333333],PARAMETER[\"False_Northing\",1312333.333333333],PARAMETER[\"Central_Meridian\",-92.0],PARAMETER[\"Standard_Parallel_1\",33.3],PARAMETER[\"Standard_Parallel_2\",34.76666666666667],PARAMETER[\"Latitude_Of_Origin\",32.66666666666666],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",3487]]",
        3488=>"PROJCS[\"NAD_1983_NSRS2007_California_Teale_Albers\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Albers\"],PARAMETER[\"False_Easting\",0.0],PARAMETER[\"False_Northing\",-4000000.0],PARAMETER[\"Central_Meridian\",-120.0],PARAMETER[\"Standard_Parallel_1\",34.0],PARAMETER[\"Standard_Parallel_2\",40.5],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3488]]",
        3489=>"PROJCS[\"NAD_1983_NSRS2007_StatePlane_California_I_FIPS_0401\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",2000000.0],PARAMETER[\"False_Northing\",500000.0],PARAMETER[\"Central_Meridian\",-122.0],PARAMETER[\"Standard_Parallel_1\",40.0],PARAMETER[\"Standard_Parallel_2\",41.66666666666666],PARAMETER[\"Latitude_Of_Origin\",39.33333333333334],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3489]]",
        3490=>"PROJCS[\"NAD_1983_NSRS2007_StatePlane_California_I_FIPS_0401_Ft_US\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",6561666.666666666],PARAMETER[\"False_Northing\",1640416.666666667],PARAMETER[\"Central_Meridian\",-122.0],PARAMETER[\"Standard_Parallel_1\",40.0],PARAMETER[\"Standard_Parallel_2\",41.66666666666666],PARAMETER[\"Latitude_Of_Origin\",39.33333333333334],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",3490]]",
        3491=>"PROJCS[\"NAD_1983_NSRS2007_StatePlane_California_II_FIPS_0402\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",2000000.0],PARAMETER[\"False_Northing\",500000.0],PARAMETER[\"Central_Meridian\",-122.0],PARAMETER[\"Standard_Parallel_1\",38.33333333333334],PARAMETER[\"Standard_Parallel_2\",39.83333333333334],PARAMETER[\"Latitude_Of_Origin\",37.66666666666666],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3491]]",
        3492=>"PROJCS[\"NAD_1983_NSRS2007_StatePlane_California_II_FIPS_0402_Ft_US\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",6561666.666666666],PARAMETER[\"False_Northing\",1640416.666666667],PARAMETER[\"Central_Meridian\",-122.0],PARAMETER[\"Standard_Parallel_1\",38.33333333333334],PARAMETER[\"Standard_Parallel_2\",39.83333333333334],PARAMETER[\"Latitude_Of_Origin\",37.66666666666666],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",3492]]",
        3493=>"PROJCS[\"NAD_1983_NSRS2007_StatePlane_California_III_FIPS_0403\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",2000000.0],PARAMETER[\"False_Northing\",500000.0],PARAMETER[\"Central_Meridian\",-120.5],PARAMETER[\"Standard_Parallel_1\",37.06666666666667],PARAMETER[\"Standard_Parallel_2\",38.43333333333333],PARAMETER[\"Latitude_Of_Origin\",36.5],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3493]]",
        3494=>"PROJCS[\"NAD_1983_NSRS2007_StatePlane_California_III_FIPS_0403_Ft_US\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",6561666.666666666],PARAMETER[\"False_Northing\",1640416.666666667],PARAMETER[\"Central_Meridian\",-120.5],PARAMETER[\"Standard_Parallel_1\",37.06666666666667],PARAMETER[\"Standard_Parallel_2\",38.43333333333333],PARAMETER[\"Latitude_Of_Origin\",36.5],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",3494]]",
        3495=>"PROJCS[\"NAD_1983_NSRS2007_StatePlane_California_IV_FIPS_0404\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",2000000.0],PARAMETER[\"False_Northing\",500000.0],PARAMETER[\"Central_Meridian\",-119.0],PARAMETER[\"Standard_Parallel_1\",36.0],PARAMETER[\"Standard_Parallel_2\",37.25],PARAMETER[\"Latitude_Of_Origin\",35.33333333333334],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3495]]",
        3496=>"PROJCS[\"NAD_1983_NSRS2007_StatePlane_California_IV_FIPS_0404_Ft_US\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",6561666.666666666],PARAMETER[\"False_Northing\",1640416.666666667],PARAMETER[\"Central_Meridian\",-119.0],PARAMETER[\"Standard_Parallel_1\",36.0],PARAMETER[\"Standard_Parallel_2\",37.25],PARAMETER[\"Latitude_Of_Origin\",35.33333333333334],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",3496]]",
        3497=>"PROJCS[\"NAD_1983_NSRS2007_StatePlane_California_V_FIPS_0405\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",2000000.0],PARAMETER[\"False_Northing\",500000.0],PARAMETER[\"Central_Meridian\",-118.0],PARAMETER[\"Standard_Parallel_1\",34.03333333333333],PARAMETER[\"Standard_Parallel_2\",35.46666666666667],PARAMETER[\"Latitude_Of_Origin\",33.5],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3497]]",
        3498=>"PROJCS[\"NAD_1983_NSRS2007_StatePlane_California_V_FIPS_0405_Ft_US\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",6561666.666666666],PARAMETER[\"False_Northing\",1640416.666666667],PARAMETER[\"Central_Meridian\",-118.0],PARAMETER[\"Standard_Parallel_1\",34.03333333333333],PARAMETER[\"Standard_Parallel_2\",35.46666666666667],PARAMETER[\"Latitude_Of_Origin\",33.5],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",3498]]",
        3499=>"PROJCS[\"NAD_1983_NSRS2007_StatePlane_California_VI_FIPS_0406\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",2000000.0],PARAMETER[\"False_Northing\",500000.0],PARAMETER[\"Central_Meridian\",-116.25],PARAMETER[\"Standard_Parallel_1\",32.78333333333333],PARAMETER[\"Standard_Parallel_2\",33.88333333333333],PARAMETER[\"Latitude_Of_Origin\",32.16666666666666],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3499]]",
        3500=>"PROJCS[\"NAD_1983_NSRS2007_StatePlane_California_VI_FIPS_0406_Ft_US\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",6561666.666666666],PARAMETER[\"False_Northing\",1640416.666666667],PARAMETER[\"Central_Meridian\",-116.25],PARAMETER[\"Standard_Parallel_1\",32.78333333333333],PARAMETER[\"Standard_Parallel_2\",33.88333333333333],PARAMETER[\"Latitude_Of_Origin\",32.16666666666666],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",3500]]",
        3501=>"PROJCS[\"NAD_1983_NSRS2007_StatePlane_Colorado_Central_FIPS_0502\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",914401.8289],PARAMETER[\"False_Northing\",304800.6096],PARAMETER[\"Central_Meridian\",-105.5],PARAMETER[\"Standard_Parallel_1\",38.45],PARAMETER[\"Standard_Parallel_2\",39.75],PARAMETER[\"Latitude_Of_Origin\",37.83333333333334],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3501]]",
        3502=>"PROJCS[\"NAD_1983_NSRS2007_StatePlane_Colorado_Central_FIPS_0502_Ft_US\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",3000000.000316083],PARAMETER[\"False_Northing\",999999.999996],PARAMETER[\"Central_Meridian\",-105.5],PARAMETER[\"Standard_Parallel_1\",38.45],PARAMETER[\"Standard_Parallel_2\",39.75],PARAMETER[\"Latitude_Of_Origin\",37.83333333333334],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",3502]]",
        3503=>"PROJCS[\"NAD_1983_NSRS2007_StatePlane_Colorado_North_FIPS_0501\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",914401.8289],PARAMETER[\"False_Northing\",304800.6096],PARAMETER[\"Central_Meridian\",-105.5],PARAMETER[\"Standard_Parallel_1\",39.71666666666667],PARAMETER[\"Standard_Parallel_2\",40.78333333333333],PARAMETER[\"Latitude_Of_Origin\",39.33333333333334],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3503]]",
        3504=>"PROJCS[\"NAD_1983_NSRS2007_StatePlane_Colorado_North_FIPS_0501_Ft_US\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",3000000.000316083],PARAMETER[\"False_Northing\",999999.999996],PARAMETER[\"Central_Meridian\",-105.5],PARAMETER[\"Standard_Parallel_1\",39.71666666666667],PARAMETER[\"Standard_Parallel_2\",40.78333333333333],PARAMETER[\"Latitude_Of_Origin\",39.33333333333334],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",3504]]",
        3505=>"PROJCS[\"NAD_1983_NSRS2007_StatePlane_Colorado_South_FIPS_0503\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",914401.8289],PARAMETER[\"False_Northing\",304800.6096],PARAMETER[\"Central_Meridian\",-105.5],PARAMETER[\"Standard_Parallel_1\",37.23333333333333],PARAMETER[\"Standard_Parallel_2\",38.43333333333333],PARAMETER[\"Latitude_Of_Origin\",36.66666666666666],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3505]]",
        3506=>"PROJCS[\"NAD_1983_NSRS2007_StatePlane_Colorado_South_FIPS_0503_Ft_US\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",3000000.000316083],PARAMETER[\"False_Northing\",999999.999996],PARAMETER[\"Central_Meridian\",-105.5],PARAMETER[\"Standard_Parallel_1\",37.23333333333333],PARAMETER[\"Standard_Parallel_2\",38.43333333333333],PARAMETER[\"Latitude_Of_Origin\",36.66666666666666],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",3506]]",
        3507=>"PROJCS[\"NAD_1983_NSRS2007_StatePlane_Connecticut_FIPS_0600\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",304800.6096],PARAMETER[\"False_Northing\",152400.3048],PARAMETER[\"Central_Meridian\",-72.75],PARAMETER[\"Standard_Parallel_1\",41.2],PARAMETER[\"Standard_Parallel_2\",41.86666666666667],PARAMETER[\"Latitude_Of_Origin\",40.83333333333334],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3507]]",
        3508=>"PROJCS[\"NAD_1983_NSRS2007_StatePlane_Connecticut_FIPS_0600_Ft_US\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",999999.999996],PARAMETER[\"False_Northing\",499999.999998],PARAMETER[\"Central_Meridian\",-72.75],PARAMETER[\"Standard_Parallel_1\",41.2],PARAMETER[\"Standard_Parallel_2\",41.86666666666667],PARAMETER[\"Latitude_Of_Origin\",40.83333333333334],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",3508]]",
        3509=>"PROJCS[\"NAD_1983_NSRS2007_StatePlane_Delaware_FIPS_0700\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",200000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-75.41666666666667],PARAMETER[\"Scale_Factor\",0.999995],PARAMETER[\"Latitude_Of_Origin\",38.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3509]]",
        3510=>"PROJCS[\"NAD_1983_NSRS2007_StatePlane_Delaware_FIPS_0700_Ft_US\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",656166.6666666665],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-75.41666666666667],PARAMETER[\"Scale_Factor\",0.999995],PARAMETER[\"Latitude_Of_Origin\",38.0],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",3510]]",
        3511=>"PROJCS[\"NAD_1983_NSRS2007_StatePlane_Florida_East_FIPS_0901\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",200000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-81.0],PARAMETER[\"Scale_Factor\",0.9999411764705882],PARAMETER[\"Latitude_Of_Origin\",24.33333333333333],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3511]]",
        3512=>"PROJCS[\"NAD_1983_NSRS2007_StatePlane_Florida_East_FIPS_0901_Ft_US\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",656166.6666666665],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-81.0],PARAMETER[\"Scale_Factor\",0.9999411764705882],PARAMETER[\"Latitude_Of_Origin\",24.33333333333333],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",3512]]",
        3513=>"PROJCS[\"NAD_1983_NSRS2007_Florida_GDL_Albers\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Albers\"],PARAMETER[\"False_Easting\",400000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-84.0],PARAMETER[\"Standard_Parallel_1\",24.0],PARAMETER[\"Standard_Parallel_2\",31.5],PARAMETER[\"Latitude_Of_Origin\",24.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3513]]",
        3514=>"PROJCS[\"NAD_1983_NSRS2007_StatePlane_Florida_North_FIPS_0903\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",600000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-84.5],PARAMETER[\"Standard_Parallel_1\",29.58333333333333],PARAMETER[\"Standard_Parallel_2\",30.75],PARAMETER[\"Latitude_Of_Origin\",29.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3514]]",
        3515=>"PROJCS[\"NAD_1983_NSRS2007_StatePlane_Florida_North_FIPS_0903_Ft_US\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",1968500.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-84.5],PARAMETER[\"Standard_Parallel_1\",29.58333333333333],PARAMETER[\"Standard_Parallel_2\",30.75],PARAMETER[\"Latitude_Of_Origin\",29.0],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",3515]]",
        3516=>"PROJCS[\"NAD_1983_NSRS2007_StatePlane_Florida_West_FIPS_0902\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",200000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-82.0],PARAMETER[\"Scale_Factor\",0.9999411764705882],PARAMETER[\"Latitude_Of_Origin\",24.33333333333333],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3516]]",
        3517=>"PROJCS[\"NAD_1983_NSRS2007_StatePlane_Florida_West_FIPS_0902_Ft_US\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",656166.6666666665],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-82.0],PARAMETER[\"Scale_Factor\",0.9999411764705882],PARAMETER[\"Latitude_Of_Origin\",24.33333333333333],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",3517]]",
        3518=>"PROJCS[\"NAD_1983_NSRS2007_StatePlane_Georgia_East_FIPS_1001\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",200000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-82.16666666666667],PARAMETER[\"Scale_Factor\",0.9999],PARAMETER[\"Latitude_Of_Origin\",30.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3518]]",
        3519=>"PROJCS[\"NAD_1983_NSRS2007_StatePlane_Georgia_East_FIPS_1001_Ft_US\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",656166.6666666665],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-82.16666666666667],PARAMETER[\"Scale_Factor\",0.9999],PARAMETER[\"Latitude_Of_Origin\",30.0],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",3519]]",
        3520=>"PROJCS[\"NAD_1983_NSRS2007_StatePlane_Georgia_West_FIPS_1002\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",700000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-84.16666666666667],PARAMETER[\"Scale_Factor\",0.9999],PARAMETER[\"Latitude_Of_Origin\",30.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3520]]",
        3521=>"PROJCS[\"NAD_1983_NSRS2007_StatePlane_Georgia_West_FIPS_1002_Ft_US\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",2296583.333333333],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-84.16666666666667],PARAMETER[\"Scale_Factor\",0.9999],PARAMETER[\"Latitude_Of_Origin\",30.0],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",3521]]",
        3522=>"PROJCS[\"NAD_1983_NSRS2007_StatePlane_Idaho_Central_FIPS_1102\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-114.0],PARAMETER[\"Scale_Factor\",0.9999473684210526],PARAMETER[\"Latitude_Of_Origin\",41.66666666666666],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3522]]",
        3523=>"PROJCS[\"NAD_1983_NSRS2007_StatePlane_Idaho_Central_FIPS_1102_Ft_US\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",1640416.666666667],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-114.0],PARAMETER[\"Scale_Factor\",0.9999473684210526],PARAMETER[\"Latitude_Of_Origin\",41.66666666666666],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",3523]]",
        3524=>"PROJCS[\"NAD_1983_NSRS2007_StatePlane_Idaho_East_FIPS_1101\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",200000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-112.1666666666667],PARAMETER[\"Scale_Factor\",0.9999473684210526],PARAMETER[\"Latitude_Of_Origin\",41.66666666666666],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3524]]",
        3525=>"PROJCS[\"NAD_1983_NSRS2007_StatePlane_Idaho_East_FIPS_1101_Ft_US\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",656166.6666666665],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-112.1666666666667],PARAMETER[\"Scale_Factor\",0.9999473684210526],PARAMETER[\"Latitude_Of_Origin\",41.66666666666666],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",3525]]",
        3526=>"PROJCS[\"NAD_1983_NSRS2007_StatePlane_Idaho_West_FIPS_1103\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",800000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-115.75],PARAMETER[\"Scale_Factor\",0.9999333333333333],PARAMETER[\"Latitude_Of_Origin\",41.66666666666666],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3526]]",
        3527=>"PROJCS[\"NAD_1983_NSRS2007_StatePlane_Idaho_West_FIPS_1103_Ft_US\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",2624666.666666666],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-115.75],PARAMETER[\"Scale_Factor\",0.9999333333333333],PARAMETER[\"Latitude_Of_Origin\",41.66666666666666],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",3527]]",
        3528=>"PROJCS[\"NAD_1983_NSRS2007_StatePlane_Illinois_East_FIPS_1201\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",300000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-88.33333333333333],PARAMETER[\"Scale_Factor\",0.999975],PARAMETER[\"Latitude_Of_Origin\",36.66666666666666],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3528]]",
        3529=>"PROJCS[\"NAD_1983_NSRS2007_StatePlane_Illinois_East_FIPS_1201_Ft_US\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",984250.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-88.33333333333333],PARAMETER[\"Scale_Factor\",0.999975],PARAMETER[\"Latitude_Of_Origin\",36.66666666666666],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",3529]]",
        3530=>"PROJCS[\"NAD_1983_NSRS2007_StatePlane_Illinois_West_FIPS_1202\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",700000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-90.16666666666667],PARAMETER[\"Scale_Factor\",0.9999411764705882],PARAMETER[\"Latitude_Of_Origin\",36.66666666666666],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3530]]",
        3531=>"PROJCS[\"NAD_1983_NSRS2007_StatePlane_Illinois_West_FIPS_1202_Ft_US\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",2296583.333333333],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-90.16666666666667],PARAMETER[\"Scale_Factor\",0.9999411764705882],PARAMETER[\"Latitude_Of_Origin\",36.66666666666666],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",3531]]",
        3532=>"PROJCS[\"NAD_1983_NSRS2007_StatePlane_Indiana_East_FIPS_1301\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",100000.0],PARAMETER[\"False_Northing\",250000.0],PARAMETER[\"Central_Meridian\",-85.66666666666667],PARAMETER[\"Scale_Factor\",0.9999666666666667],PARAMETER[\"Latitude_Of_Origin\",37.5],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3532]]",
        3533=>"PROJCS[\"NAD_1983_NSRS2007_StatePlane_Indiana_East_FIPS_1301_Ft_US\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",328083.3333333333],PARAMETER[\"False_Northing\",820208.3333333333],PARAMETER[\"Central_Meridian\",-85.66666666666667],PARAMETER[\"Scale_Factor\",0.9999666666666667],PARAMETER[\"Latitude_Of_Origin\",37.5],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",3533]]",
        3534=>"PROJCS[\"NAD_1983_NSRS2007_StatePlane_Indiana_West_FIPS_1302\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",900000.0],PARAMETER[\"False_Northing\",250000.0],PARAMETER[\"Central_Meridian\",-87.08333333333333],PARAMETER[\"Scale_Factor\",0.9999666666666667],PARAMETER[\"Latitude_Of_Origin\",37.5],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3534]]",
        3535=>"PROJCS[\"NAD_1983_NSRS2007_StatePlane_Indiana_West_FIPS_1302_Ft_US\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",2952750.0],PARAMETER[\"False_Northing\",820208.3333333333],PARAMETER[\"Central_Meridian\",-87.08333333333333],PARAMETER[\"Scale_Factor\",0.9999666666666667],PARAMETER[\"Latitude_Of_Origin\",37.5],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",3535]]",
        3536=>"PROJCS[\"NAD_1983_NSRS2007_StatePlane_Iowa_North_FIPS_1401\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",1500000.0],PARAMETER[\"False_Northing\",1000000.0],PARAMETER[\"Central_Meridian\",-93.5],PARAMETER[\"Standard_Parallel_1\",42.06666666666667],PARAMETER[\"Standard_Parallel_2\",43.26666666666667],PARAMETER[\"Latitude_Of_Origin\",41.5],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3536]]",
        3537=>"PROJCS[\"NAD_1983_NSRS2007_StatePlane_Iowa_North_FIPS_1401_Ft_US\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",4921250.0],PARAMETER[\"False_Northing\",3280833.333333333],PARAMETER[\"Central_Meridian\",-93.5],PARAMETER[\"Standard_Parallel_1\",42.06666666666667],PARAMETER[\"Standard_Parallel_2\",43.26666666666667],PARAMETER[\"Latitude_Of_Origin\",41.5],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",3537]]",
        3538=>"PROJCS[\"NAD_1983_NSRS2007_StatePlane_Iowa_South_FIPS_1402\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-93.5],PARAMETER[\"Standard_Parallel_1\",40.61666666666667],PARAMETER[\"Standard_Parallel_2\",41.78333333333333],PARAMETER[\"Latitude_Of_Origin\",40.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3538]]",
        3539=>"PROJCS[\"NAD_1983_NSRS2007_StatePlane_Iowa_South_FIPS_1402_Ft_US\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",1640416.666666667],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-93.5],PARAMETER[\"Standard_Parallel_1\",40.61666666666667],PARAMETER[\"Standard_Parallel_2\",41.78333333333333],PARAMETER[\"Latitude_Of_Origin\",40.0],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",3539]]",
        3540=>"PROJCS[\"NAD_1983_NSRS2007_StatePlane_Kansas_North_FIPS_1501\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",400000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-98.0],PARAMETER[\"Standard_Parallel_1\",38.71666666666667],PARAMETER[\"Standard_Parallel_2\",39.78333333333333],PARAMETER[\"Latitude_Of_Origin\",38.33333333333334],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3540]]",
        3541=>"PROJCS[\"NAD_1983_NSRS2007_StatePlane_Kansas_North_FIPS_1501_Ft_US\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",1312333.333333333],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-98.0],PARAMETER[\"Standard_Parallel_1\",38.71666666666667],PARAMETER[\"Standard_Parallel_2\",39.78333333333333],PARAMETER[\"Latitude_Of_Origin\",38.33333333333334],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",3541]]",
        3542=>"PROJCS[\"NAD_1983_NSRS2007_StatePlane_Kansas_South_FIPS_1502\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",400000.0],PARAMETER[\"False_Northing\",400000.0],PARAMETER[\"Central_Meridian\",-98.5],PARAMETER[\"Standard_Parallel_1\",37.26666666666667],PARAMETER[\"Standard_Parallel_2\",38.56666666666667],PARAMETER[\"Latitude_Of_Origin\",36.66666666666666],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3542]]",
        3543=>"PROJCS[\"NAD_1983_NSRS2007_StatePlane_Kansas_South_FIPS_1502_Ft_US\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",1312333.333333333],PARAMETER[\"False_Northing\",1312333.333333333],PARAMETER[\"Central_Meridian\",-98.5],PARAMETER[\"Standard_Parallel_1\",37.26666666666667],PARAMETER[\"Standard_Parallel_2\",38.56666666666667],PARAMETER[\"Latitude_Of_Origin\",36.66666666666666],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",3543]]",
        3544=>"PROJCS[\"NAD_1983_NSRS2007_StatePlane_Kentucky_North_FIPS_1601\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-84.25],PARAMETER[\"Standard_Parallel_1\",37.96666666666667],PARAMETER[\"Standard_Parallel_2\",38.96666666666667],PARAMETER[\"Latitude_Of_Origin\",37.5],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3544]]",
        3545=>"PROJCS[\"NAD_1983_NSRS2007_StatePlane_Kentucky_North_FIPS_1601_Ft_US\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",1640416.666666667],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-84.25],PARAMETER[\"Standard_Parallel_1\",37.96666666666667],PARAMETER[\"Standard_Parallel_2\",38.96666666666667],PARAMETER[\"Latitude_Of_Origin\",37.5],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",3545]]",
        3546=>"PROJCS[\"NAD_1983_NSRS2007_StatePlane_Kentucky_FIPS_1600\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",1500000.0],PARAMETER[\"False_Northing\",1000000.0],PARAMETER[\"Central_Meridian\",-85.75],PARAMETER[\"Standard_Parallel_1\",37.08333333333334],PARAMETER[\"Standard_Parallel_2\",38.66666666666666],PARAMETER[\"Latitude_Of_Origin\",36.33333333333334],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3546]]",
        3547=>"PROJCS[\"NAD_1983_NSRS2007_StatePlane_Kentucky_FIPS_1600_Ft_US\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",4921250.0],PARAMETER[\"False_Northing\",3280833.333333333],PARAMETER[\"Central_Meridian\",-85.75],PARAMETER[\"Standard_Parallel_1\",37.08333333333334],PARAMETER[\"Standard_Parallel_2\",38.66666666666666],PARAMETER[\"Latitude_Of_Origin\",36.33333333333334],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",3547]]",
        3548=>"PROJCS[\"NAD_1983_NSRS2007_StatePlane_Kentucky_South_FIPS_1602\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",500000.0],PARAMETER[\"Central_Meridian\",-85.75],PARAMETER[\"Standard_Parallel_1\",36.73333333333333],PARAMETER[\"Standard_Parallel_2\",37.93333333333333],PARAMETER[\"Latitude_Of_Origin\",36.33333333333334],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3548]]",
        3549=>"PROJCS[\"NAD_1983_NSRS2007_StatePlane_Kentucky_South_FIPS_1602_Ft_US\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",1640416.666666667],PARAMETER[\"False_Northing\",1640416.666666667],PARAMETER[\"Central_Meridian\",-85.75],PARAMETER[\"Standard_Parallel_1\",36.73333333333333],PARAMETER[\"Standard_Parallel_2\",37.93333333333333],PARAMETER[\"Latitude_Of_Origin\",36.33333333333334],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",3549]]",
        3550=>"PROJCS[\"NAD_1983_NSRS2007_StatePlane_Louisiana_North_FIPS_1701\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",1000000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-92.5],PARAMETER[\"Standard_Parallel_1\",31.16666666666667],PARAMETER[\"Standard_Parallel_2\",32.66666666666666],PARAMETER[\"Latitude_Of_Origin\",30.5],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3550]]",
        3551=>"PROJCS[\"NAD_1983_NSRS2007_StatePlane_Louisiana_North_FIPS_1701_Ft_US\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",3280833.333333333],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-92.5],PARAMETER[\"Standard_Parallel_1\",31.16666666666667],PARAMETER[\"Standard_Parallel_2\",32.66666666666666],PARAMETER[\"Latitude_Of_Origin\",30.5],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",3551]]",
        3552=>"PROJCS[\"NAD_1983_NSRS2007_StatePlane_Louisiana_South_FIPS_1702\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",1000000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-91.33333333333333],PARAMETER[\"Standard_Parallel_1\",29.3],PARAMETER[\"Standard_Parallel_2\",30.7],PARAMETER[\"Latitude_Of_Origin\",28.5],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3552]]",
        3553=>"PROJCS[\"NAD_1983_NSRS2007_StatePlane_Louisiana_South_FIPS_1702_Ft_US\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",3280833.333333333],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-91.33333333333333],PARAMETER[\"Standard_Parallel_1\",29.3],PARAMETER[\"Standard_Parallel_2\",30.7],PARAMETER[\"Latitude_Of_Origin\",28.5],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",3553]]",
        3554=>"PROJCS[\"NAD_1983_NSRS2007_Maine_2000_Central_Zone\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-69.125],PARAMETER[\"Scale_Factor\",0.99998],PARAMETER[\"Latitude_Of_Origin\",43.5],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3554]]",
        3555=>"PROJCS[\"NAD_1983_NSRS2007_Maine_2000_East_Zone\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",700000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-67.875],PARAMETER[\"Scale_Factor\",0.99998],PARAMETER[\"Latitude_Of_Origin\",43.83333333333334],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3555]]",
        3556=>"PROJCS[\"NAD_1983_NSRS2007_Maine_2000_West_Zone\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",300000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-70.375],PARAMETER[\"Scale_Factor\",0.99998],PARAMETER[\"Latitude_Of_Origin\",42.83333333333334],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3556]]",
        3557=>"PROJCS[\"NAD_1983_NSRS2007_StatePlane_Maine_East_FIPS_1801\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",300000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-68.5],PARAMETER[\"Scale_Factor\",0.9999],PARAMETER[\"Latitude_Of_Origin\",43.66666666666666],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3557]]",
        3558=>"PROJCS[\"NAD_1983_NSRS2007_StatePlane_Maine_West_FIPS_1802\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",900000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-70.16666666666667],PARAMETER[\"Scale_Factor\",0.9999666666666667],PARAMETER[\"Latitude_Of_Origin\",42.83333333333334],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3558]]",
        3559=>"PROJCS[\"NAD_1983_NSRS2007_StatePlane_Maryland_FIPS_1900\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",400000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-77.0],PARAMETER[\"Standard_Parallel_1\",38.3],PARAMETER[\"Standard_Parallel_2\",39.45],PARAMETER[\"Latitude_Of_Origin\",37.66666666666666],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3559]]",
        3560=>"PROJCS[\"NAD_1983_StatePlane_Utah_North_FIPS_4301_Feet\",GEOGCS[\"GCS_North_American_1983\",DATUM[\"D_North_American_1983\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",1640416.666666667],PARAMETER[\"False_Northing\",3280833.333333333],PARAMETER[\"Central_Meridian\",-111.5],PARAMETER[\"Standard_Parallel_1\",40.71666666666667],PARAMETER[\"Standard_Parallel_2\",41.78333333333333],PARAMETER[\"Latitude_Of_Origin\",40.33333333333334],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",3560]]",
        3561=>"PROJCS[\"Old_Hawaiian_StatePlane_Hawaii_1_FIPS_5101\",GEOGCS[\"GCS_Old_Hawaiian\",DATUM[\"D_Old_Hawaiian\",SPHEROID[\"Clarke_1866\",6378206.4,294.9786982]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-155.5],PARAMETER[\"Scale_Factor\",0.9999666666666667],PARAMETER[\"Latitude_Of_Origin\",18.83333333333333],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",3561]]",
        3562=>"PROJCS[\"Old_Hawaiian_StatePlane_Hawaii_2_FIPS_5102\",GEOGCS[\"GCS_Old_Hawaiian\",DATUM[\"D_Old_Hawaiian\",SPHEROID[\"Clarke_1866\",6378206.4,294.9786982]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-156.6666666666667],PARAMETER[\"Scale_Factor\",0.9999666666666667],PARAMETER[\"Latitude_Of_Origin\",20.33333333333333],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",3562]]",
        3563=>"PROJCS[\"Old_Hawaiian_StatePlane_Hawaii_3_FIPS_5103\",GEOGCS[\"GCS_Old_Hawaiian\",DATUM[\"D_Old_Hawaiian\",SPHEROID[\"Clarke_1866\",6378206.4,294.9786982]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-158.0],PARAMETER[\"Scale_Factor\",0.99999],PARAMETER[\"Latitude_Of_Origin\",21.16666666666667],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",3563]]",
        3564=>"PROJCS[\"Old_Hawaiian_StatePlane_Hawaii_4_FIPS_5104\",GEOGCS[\"GCS_Old_Hawaiian\",DATUM[\"D_Old_Hawaiian\",SPHEROID[\"Clarke_1866\",6378206.4,294.9786982]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-159.5],PARAMETER[\"Scale_Factor\",0.99999],PARAMETER[\"Latitude_Of_Origin\",21.83333333333333],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",3564]]",
        3565=>"PROJCS[\"Old_Hawaiian_StatePlane_Hawaii_5_FIPS_5105\",GEOGCS[\"GCS_Old_Hawaiian\",DATUM[\"D_Old_Hawaiian\",SPHEROID[\"Clarke_1866\",6378206.4,294.9786982]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-160.1666666666667],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",21.66666666666667],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",3565]]",
        3566=>"PROJCS[\"NAD_1983_StatePlane_Utah_Central_FIPS_4302_Feet\",GEOGCS[\"GCS_North_American_1983\",DATUM[\"D_North_American_1983\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",1640416.666666667],PARAMETER[\"False_Northing\",6561666.666666666],PARAMETER[\"Central_Meridian\",-111.5],PARAMETER[\"Standard_Parallel_1\",39.01666666666667],PARAMETER[\"Standard_Parallel_2\",40.65],PARAMETER[\"Latitude_Of_Origin\",38.33333333333334],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",3566]]",
        3567=>"PROJCS[\"NAD_1983_StatePlane_Utah_South_FIPS_4303_Feet\",GEOGCS[\"GCS_North_American_1983\",DATUM[\"D_North_American_1983\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",1640416.666666667],PARAMETER[\"False_Northing\",9842500.0],PARAMETER[\"Central_Meridian\",-111.5],PARAMETER[\"Standard_Parallel_1\",37.21666666666667],PARAMETER[\"Standard_Parallel_2\",38.35],PARAMETER[\"Latitude_Of_Origin\",36.66666666666666],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",3567]]",
        3568=>"PROJCS[\"NAD_1983_HARN_StatePlane_Utah_North_FIPS_4301_Feet\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",1640416.666666667],PARAMETER[\"False_Northing\",3280833.333333333],PARAMETER[\"Central_Meridian\",-111.5],PARAMETER[\"Standard_Parallel_1\",40.71666666666667],PARAMETER[\"Standard_Parallel_2\",41.78333333333333],PARAMETER[\"Latitude_Of_Origin\",40.33333333333334],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",3568]]",
        3569=>"PROJCS[\"NAD_1983_HARN_StatePlane_Utah_Central_FIPS_4302_Feet\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",1640416.666666667],PARAMETER[\"False_Northing\",6561666.666666666],PARAMETER[\"Central_Meridian\",-111.5],PARAMETER[\"Standard_Parallel_1\",39.01666666666667],PARAMETER[\"Standard_Parallel_2\",40.65],PARAMETER[\"Latitude_Of_Origin\",38.33333333333334],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",3569]]",
        3570=>"PROJCS[\"NAD_1983_HARN_StatePlane_Utah_South_FIPS_4303_Feet\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",1640416.666666667],PARAMETER[\"False_Northing\",9842500.0],PARAMETER[\"Central_Meridian\",-111.5],PARAMETER[\"Standard_Parallel_1\",37.21666666666667],PARAMETER[\"Standard_Parallel_2\",38.35],PARAMETER[\"Latitude_Of_Origin\",36.66666666666666],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",3570]]",
        3571=>"PROJCS[\"WGS_1984_North_Pole_LAEA_Bering_Sea\",GEOGCS[\"GCS_WGS_1984\",DATUM[\"D_WGS_1984\",SPHEROID[\"WGS_1984\",6378137.0,298.257223563]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Azimuthal_Equal_Area\"],PARAMETER[\"False_Easting\",0.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",180.0],PARAMETER[\"Latitude_Of_Origin\",90.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3571]]",
        3572=>"PROJCS[\"WGS_1984_North_Pole_LAEA_Alaska\",GEOGCS[\"GCS_WGS_1984\",DATUM[\"D_WGS_1984\",SPHEROID[\"WGS_1984\",6378137.0,298.257223563]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Azimuthal_Equal_Area\"],PARAMETER[\"False_Easting\",0.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-150.0],PARAMETER[\"Latitude_Of_Origin\",90.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3572]]",
        3573=>"PROJCS[\"WGS_1984_North_Pole_LAEA_Canada\",GEOGCS[\"GCS_WGS_1984\",DATUM[\"D_WGS_1984\",SPHEROID[\"WGS_1984\",6378137.0,298.257223563]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Azimuthal_Equal_Area\"],PARAMETER[\"False_Easting\",0.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-100.0],PARAMETER[\"Latitude_Of_Origin\",90.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3573]]",
        3574=>"PROJCS[\"WGS_1984_North_Pole_LAEA_Atlantic\",GEOGCS[\"GCS_WGS_1984\",DATUM[\"D_WGS_1984\",SPHEROID[\"WGS_1984\",6378137.0,298.257223563]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Azimuthal_Equal_Area\"],PARAMETER[\"False_Easting\",0.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-40.0],PARAMETER[\"Latitude_Of_Origin\",90.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3574]]",
        3575=>"PROJCS[\"WGS_1984_North_Pole_LAEA_Europe\",GEOGCS[\"GCS_WGS_1984\",DATUM[\"D_WGS_1984\",SPHEROID[\"WGS_1984\",6378137.0,298.257223563]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Azimuthal_Equal_Area\"],PARAMETER[\"False_Easting\",0.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",10.0],PARAMETER[\"Latitude_Of_Origin\",90.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3575]]",
        3576=>"PROJCS[\"WGS_1984_North_Pole_LAEA_Russia\",GEOGCS[\"GCS_WGS_1984\",DATUM[\"D_WGS_1984\",SPHEROID[\"WGS_1984\",6378137.0,298.257223563]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Azimuthal_Equal_Area\"],PARAMETER[\"False_Easting\",0.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",90.0],PARAMETER[\"Latitude_Of_Origin\",90.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3576]]",
        3577=>"PROJCS[\"GDA_1994_Australia_Albers\",GEOGCS[\"GCS_GDA_1994\",DATUM[\"D_GDA_1994\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Albers\"],PARAMETER[\"False_Easting\",0.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",132.0],PARAMETER[\"Standard_Parallel_1\",-18.0],PARAMETER[\"Standard_Parallel_2\",-36.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3577]]",
        3578=>"PROJCS[\"NAD_1983_Yukon_Albers\",GEOGCS[\"GCS_North_American_1983\",DATUM[\"D_North_American_1983\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Albers\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",500000.0],PARAMETER[\"Central_Meridian\",-132.5],PARAMETER[\"Standard_Parallel_1\",61.66666666666666],PARAMETER[\"Standard_Parallel_2\",68.0],PARAMETER[\"Latitude_Of_Origin\",59.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3578]]",
        3579=>"PROJCS[\"NAD_1983_CSRS_Yukon_Albers\",GEOGCS[\"GCS_North_American_1983_CSRS\",DATUM[\"D_North_American_1983_CSRS\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Albers\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",500000.0],PARAMETER[\"Central_Meridian\",-132.5],PARAMETER[\"Standard_Parallel_1\",61.66666666666666],PARAMETER[\"Standard_Parallel_2\",68.0],PARAMETER[\"Latitude_Of_Origin\",59.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3579]]",
        3580=>"PROJCS[\"NAD_1983_Northwest_Territories_Lambert\",GEOGCS[\"GCS_North_American_1983\",DATUM[\"D_North_American_1983\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",0.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-112.0],PARAMETER[\"Standard_Parallel_1\",62.0],PARAMETER[\"Standard_Parallel_2\",70.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3580]]",
        3581=>"PROJCS[\"NAD_1983_CSRS_Northwest_Territories_Lambert\",GEOGCS[\"GCS_North_American_1983_CSRS\",DATUM[\"D_North_American_1983_CSRS\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",0.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-112.0],PARAMETER[\"Standard_Parallel_1\",62.0],PARAMETER[\"Standard_Parallel_2\",70.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3581]]",
        3582=>"PROJCS[\"NAD_1983_NSRS2007_StatePlane_Maryland_FIPS_1900_Ft_US\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",1312333.333333333],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-77.0],PARAMETER[\"Standard_Parallel_1\",38.3],PARAMETER[\"Standard_Parallel_2\",39.45],PARAMETER[\"Latitude_Of_Origin\",37.66666666666666],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",3582]]",
        3583=>"PROJCS[\"NAD_1983_NSRS2007_StatePlane_Massachusetts_Island_FIPS_2002\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-70.5],PARAMETER[\"Standard_Parallel_1\",41.28333333333333],PARAMETER[\"Standard_Parallel_2\",41.48333333333333],PARAMETER[\"Latitude_Of_Origin\",41.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3583]]",
        3584=>"PROJCS[\"NAD_1983_NSRS2007_StatePlane_Massachusetts_Isl_FIPS_2002_FtUS\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",1640416.666666667],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-70.5],PARAMETER[\"Standard_Parallel_1\",41.28333333333333],PARAMETER[\"Standard_Parallel_2\",41.48333333333333],PARAMETER[\"Latitude_Of_Origin\",41.0],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",3584]]",
        3585=>"PROJCS[\"NAD_1983_NSRS2007_StatePlane_Massachusetts_Mainland_FIPS_2001\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",200000.0],PARAMETER[\"False_Northing\",750000.0],PARAMETER[\"Central_Meridian\",-71.5],PARAMETER[\"Standard_Parallel_1\",41.71666666666667],PARAMETER[\"Standard_Parallel_2\",42.68333333333333],PARAMETER[\"Latitude_Of_Origin\",41.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3585]]",
        3586=>"PROJCS[\"NAD_1983_NSRS2007_StatePlane_Massachusetts_Mnld_FIPS_2001_FtUS\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",656166.6666666665],PARAMETER[\"False_Northing\",2460625.0],PARAMETER[\"Central_Meridian\",-71.5],PARAMETER[\"Standard_Parallel_1\",41.71666666666667],PARAMETER[\"Standard_Parallel_2\",42.68333333333333],PARAMETER[\"Latitude_Of_Origin\",41.0],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",3586]]",
        3587=>"PROJCS[\"NAD_1983_NSRS2007_StatePlane_Michigan_Central_FIPS_2112\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",6000000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-84.36666666666666],PARAMETER[\"Standard_Parallel_1\",44.18333333333333],PARAMETER[\"Standard_Parallel_2\",45.7],PARAMETER[\"Latitude_Of_Origin\",43.31666666666667],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3587]]",
        3588=>"PROJCS[\"NAD_1983_NSRS2007_StatePlane_Michigan_Central_FIPS_2112_Ft_Intl\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",19685039.37007874],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-84.36666666666666],PARAMETER[\"Standard_Parallel_1\",44.18333333333333],PARAMETER[\"Standard_Parallel_2\",45.7],PARAMETER[\"Latitude_Of_Origin\",43.31666666666667],UNIT[\"Foot\",0.3048],AUTHORITY[\"EPSG\",3588]]",
        3589=>"PROJCS[\"NAD_1983_NSRS2007_StatePlane_Michigan_North_FIPS_2111\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",8000000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-87.0],PARAMETER[\"Standard_Parallel_1\",45.48333333333333],PARAMETER[\"Standard_Parallel_2\",47.08333333333334],PARAMETER[\"Latitude_Of_Origin\",44.78333333333333],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3589]]",
        3590=>"PROJCS[\"NAD_1983_NSRS2007_StatePlane_Michigan_North_FIPS_2111_Ft_Intl\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",26246719.16010498],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-87.0],PARAMETER[\"Standard_Parallel_1\",45.48333333333333],PARAMETER[\"Standard_Parallel_2\",47.08333333333334],PARAMETER[\"Latitude_Of_Origin\",44.78333333333333],UNIT[\"Foot\",0.3048],AUTHORITY[\"EPSG\",3590]]",
        3591=>"PROJCS[\"NAD_1983_NSRS2007_Michigan_GeoRef_Meters\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Hotine_Oblique_Mercator_Azimuth_Natural_Origin\"],PARAMETER[\"False_Easting\",2546731.496],PARAMETER[\"False_Northing\",-4354009.816],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Azimuth\",337.25556],PARAMETER[\"Longitude_Of_Center\",-86.0],PARAMETER[\"Latitude_Of_Center\",45.30916666666666],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3591]]",
        3592=>"PROJCS[\"NAD_1983_NSRS2007_StatePlane_Michigan_South_FIPS_2113\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",4000000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-84.36666666666666],PARAMETER[\"Standard_Parallel_1\",42.1],PARAMETER[\"Standard_Parallel_2\",43.66666666666666],PARAMETER[\"Latitude_Of_Origin\",41.5],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3592]]",
        3593=>"PROJCS[\"NAD_1983_NSRS2007_StatePlane_Michigan_South_FIPS_2113_Ft_Intl\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",13123359.58005249],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-84.36666666666666],PARAMETER[\"Standard_Parallel_1\",42.1],PARAMETER[\"Standard_Parallel_2\",43.66666666666666],PARAMETER[\"Latitude_Of_Origin\",41.5],UNIT[\"Foot\",0.3048],AUTHORITY[\"EPSG\",3593]]",
        3594=>"PROJCS[\"NAD_1983_NSRS2007_StatePlane_Minnesota_Central_FIPS_2202\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",800000.0],PARAMETER[\"False_Northing\",100000.0],PARAMETER[\"Central_Meridian\",-94.25],PARAMETER[\"Standard_Parallel_1\",45.61666666666667],PARAMETER[\"Standard_Parallel_2\",47.05],PARAMETER[\"Latitude_Of_Origin\",45.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3594]]",
        3595=>"PROJCS[\"NAD_1983_NSRS2007_StatePlane_Minnesota_North_FIPS_2201\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",800000.0],PARAMETER[\"False_Northing\",100000.0],PARAMETER[\"Central_Meridian\",-93.1],PARAMETER[\"Standard_Parallel_1\",47.03333333333333],PARAMETER[\"Standard_Parallel_2\",48.63333333333333],PARAMETER[\"Latitude_Of_Origin\",46.5],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3595]]",
        3596=>"PROJCS[\"NAD_1983_NSRS2007_StatePlane_Minnesota_South_FIPS_2203\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",800000.0],PARAMETER[\"False_Northing\",100000.0],PARAMETER[\"Central_Meridian\",-94.0],PARAMETER[\"Standard_Parallel_1\",43.78333333333333],PARAMETER[\"Standard_Parallel_2\",45.21666666666667],PARAMETER[\"Latitude_Of_Origin\",43.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3596]]",
        3597=>"PROJCS[\"NAD_1983_NSRS2007_StatePlane_Mississippi_East_FIPS_2301\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",300000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-88.83333333333333],PARAMETER[\"Scale_Factor\",0.99995],PARAMETER[\"Latitude_Of_Origin\",29.5],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3597]]",
        3598=>"PROJCS[\"NAD_1983_NSRS2007_StatePlane_Mississippi_East_FIPS_2301_Ft_US\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",984250.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-88.83333333333333],PARAMETER[\"Scale_Factor\",0.99995],PARAMETER[\"Latitude_Of_Origin\",29.5],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",3598]]",
        3599=>"PROJCS[\"NAD_1983_NSRS2007_StatePlane_Mississippi_West_FIPS_2302\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",700000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-90.33333333333333],PARAMETER[\"Scale_Factor\",0.99995],PARAMETER[\"Latitude_Of_Origin\",29.5],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3599]]",
        3600=>"PROJCS[\"NAD_1983_NSRS2007_StatePlane_Mississippi_West_FIPS_2302_Ft_US\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",2296583.333333333],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-90.33333333333333],PARAMETER[\"Scale_Factor\",0.99995],PARAMETER[\"Latitude_Of_Origin\",29.5],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",3600]]",
        3601=>"PROJCS[\"NAD_1983_NSRS2007_StatePlane_Missouri_Central_FIPS_2402\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-92.5],PARAMETER[\"Scale_Factor\",0.9999333333333333],PARAMETER[\"Latitude_Of_Origin\",35.83333333333334],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3601]]",
        3602=>"PROJCS[\"NAD_1983_NSRS2007_StatePlane_Missouri_East_FIPS_2401\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",250000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-90.5],PARAMETER[\"Scale_Factor\",0.9999333333333333],PARAMETER[\"Latitude_Of_Origin\",35.83333333333334],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3602]]",
        3603=>"PROJCS[\"NAD_1983_NSRS2007_StatePlane_Missouri_West_FIPS_2403\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",850000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-94.5],PARAMETER[\"Scale_Factor\",0.9999411764705882],PARAMETER[\"Latitude_Of_Origin\",36.16666666666666],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3603]]",
        3604=>"PROJCS[\"NAD_1983_NSRS2007_StatePlane_Montana_FIPS_2500\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",600000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-109.5],PARAMETER[\"Standard_Parallel_1\",45.0],PARAMETER[\"Standard_Parallel_2\",49.0],PARAMETER[\"Latitude_Of_Origin\",44.25],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3604]]",
        3605=>"PROJCS[\"NAD_1983_NSRS2007_StatePlane_Montana_FIPS_2500_Ft_Intl\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",1968503.937007874],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-109.5],PARAMETER[\"Standard_Parallel_1\",45.0],PARAMETER[\"Standard_Parallel_2\",49.0],PARAMETER[\"Latitude_Of_Origin\",44.25],UNIT[\"Foot\",0.3048],AUTHORITY[\"EPSG\",3605]]",
        3606=>"PROJCS[\"NAD_1983_NSRS2007_StatePlane_Nebraska_FIPS_2600\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-100.0],PARAMETER[\"Standard_Parallel_1\",40.0],PARAMETER[\"Standard_Parallel_2\",43.0],PARAMETER[\"Latitude_Of_Origin\",39.83333333333334],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3606]]",
        3607=>"PROJCS[\"NAD_1983_NSRS2007_StatePlane_Nevada_Central_FIPS_2702\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",6000000.0],PARAMETER[\"Central_Meridian\",-116.6666666666667],PARAMETER[\"Scale_Factor\",0.9999],PARAMETER[\"Latitude_Of_Origin\",34.75],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3607]]",
        3608=>"PROJCS[\"NAD_1983_NSRS2007_StatePlane_Nevada_Central_FIPS_2702_Ft_US\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",1640416.666666667],PARAMETER[\"False_Northing\",19685000.0],PARAMETER[\"Central_Meridian\",-116.6666666666667],PARAMETER[\"Scale_Factor\",0.9999],PARAMETER[\"Latitude_Of_Origin\",34.75],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",3608]]",
        3609=>"PROJCS[\"NAD_1983_NSRS2007_StatePlane_Nevada_East_FIPS_2701\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",200000.0],PARAMETER[\"False_Northing\",8000000.0],PARAMETER[\"Central_Meridian\",-115.5833333333333],PARAMETER[\"Scale_Factor\",0.9999],PARAMETER[\"Latitude_Of_Origin\",34.75],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3609]]",
        3610=>"PROJCS[\"NAD_1983_NSRS2007_StatePlane_Nevada_East_FIPS_2701_Ft_US\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",656166.6666666665],PARAMETER[\"False_Northing\",26246666.66666666],PARAMETER[\"Central_Meridian\",-115.5833333333333],PARAMETER[\"Scale_Factor\",0.9999],PARAMETER[\"Latitude_Of_Origin\",34.75],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",3610]]",
        3611=>"PROJCS[\"NAD_1983_NSRS2007_StatePlane_Nevada_West_FIPS_2703\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",800000.0],PARAMETER[\"False_Northing\",4000000.0],PARAMETER[\"Central_Meridian\",-118.5833333333333],PARAMETER[\"Scale_Factor\",0.9999],PARAMETER[\"Latitude_Of_Origin\",34.75],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3611]]",
        3612=>"PROJCS[\"NAD_1983_NSRS2007_StatePlane_Nevada_West_FIPS_2703_Ft_US\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",2624666.666666666],PARAMETER[\"False_Northing\",13123333.33333333],PARAMETER[\"Central_Meridian\",-118.5833333333333],PARAMETER[\"Scale_Factor\",0.9999],PARAMETER[\"Latitude_Of_Origin\",34.75],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",3612]]",
        3613=>"PROJCS[\"NAD_1983_NSRS2007_StatePlane_New_Hampshire_FIPS_2800\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",300000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-71.66666666666667],PARAMETER[\"Scale_Factor\",0.9999666666666667],PARAMETER[\"Latitude_Of_Origin\",42.5],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3613]]",
        3614=>"PROJCS[\"NAD_1983_NSRS2007_StatePlane_New_Hampshire_FIPS_2800_Ft_US\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",984250.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-71.66666666666667],PARAMETER[\"Scale_Factor\",0.9999666666666667],PARAMETER[\"Latitude_Of_Origin\",42.5],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",3614]]",
        3615=>"PROJCS[\"NAD_1983_NSRS2007_StatePlane_New_Jersey_FIPS_2900\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",150000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-74.5],PARAMETER[\"Scale_Factor\",0.9999],PARAMETER[\"Latitude_Of_Origin\",38.83333333333334],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3615]]",
        3616=>"PROJCS[\"NAD_1983_NSRS2007_StatePlane_New_Jersey_FIPS_2900_Ft_US\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",492125.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-74.5],PARAMETER[\"Scale_Factor\",0.9999],PARAMETER[\"Latitude_Of_Origin\",38.83333333333334],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",3616]]",
        3617=>"PROJCS[\"NAD_1983_NSRS2007_StatePlane_New_Mexico_Central_FIPS_3002\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-106.25],PARAMETER[\"Scale_Factor\",0.9999],PARAMETER[\"Latitude_Of_Origin\",31.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3617]]",
        3618=>"PROJCS[\"NAD_1983_NSRS2007_StatePlane_New_Mexico_Central_FIPS_3002_Ft_US\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",1640416.666666667],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-106.25],PARAMETER[\"Scale_Factor\",0.9999],PARAMETER[\"Latitude_Of_Origin\",31.0],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",3618]]",
        3619=>"PROJCS[\"NAD_1983_NSRS2007_StatePlane_New_Mexico_East_FIPS_3001\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",165000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-104.3333333333333],PARAMETER[\"Scale_Factor\",0.9999090909090909],PARAMETER[\"Latitude_Of_Origin\",31.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3619]]",
        3620=>"PROJCS[\"NAD_1983_NSRS2007_StatePlane_New_Mexico_East_FIPS_3001_Ft_US\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",541337.5],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-104.3333333333333],PARAMETER[\"Scale_Factor\",0.9999090909090909],PARAMETER[\"Latitude_Of_Origin\",31.0],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",3620]]",
        3621=>"PROJCS[\"NAD_1983_NSRS2007_StatePlane_New_Mexico_West_FIPS_3003\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",830000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-107.8333333333333],PARAMETER[\"Scale_Factor\",0.9999166666666667],PARAMETER[\"Latitude_Of_Origin\",31.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3621]]",
        3622=>"PROJCS[\"NAD_1983_NSRS2007_StatePlane_New_Mexico_West_FIPS_3003_Ft_US\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",2723091.666666666],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-107.8333333333333],PARAMETER[\"Scale_Factor\",0.9999166666666667],PARAMETER[\"Latitude_Of_Origin\",31.0],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",3622]]",
        3623=>"PROJCS[\"NAD_1983_NSRS2007_StatePlane_New_York_Central_FIPS_3102\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",250000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-76.58333333333333],PARAMETER[\"Scale_Factor\",0.9999375],PARAMETER[\"Latitude_Of_Origin\",40.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3623]]",
        3624=>"PROJCS[\"NAD_1983_NSRS2007_StatePlane_New_York_Central_FIPS_3102_Ft_US\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",820208.3333333333],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-76.58333333333333],PARAMETER[\"Scale_Factor\",0.9999375],PARAMETER[\"Latitude_Of_Origin\",40.0],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",3624]]",
        3625=>"PROJCS[\"NAD_1983_NSRS2007_StatePlane_New_York_East_FIPS_3101\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",150000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-74.5],PARAMETER[\"Scale_Factor\",0.9999],PARAMETER[\"Latitude_Of_Origin\",38.83333333333334],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3625]]",
        3626=>"PROJCS[\"NAD_1983_NSRS2007_StatePlane_New_York_East_FIPS_3101_Ft_US\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",492125.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-74.5],PARAMETER[\"Scale_Factor\",0.9999],PARAMETER[\"Latitude_Of_Origin\",38.83333333333334],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",3626]]",
        3627=>"PROJCS[\"NAD_1983_NSRS2007_StatePlane_New_York_Long_Island_FIPS_3104\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",300000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-74.0],PARAMETER[\"Standard_Parallel_1\",40.66666666666666],PARAMETER[\"Standard_Parallel_2\",41.03333333333333],PARAMETER[\"Latitude_Of_Origin\",40.16666666666666],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3627]]",
        3628=>"PROJCS[\"NAD_1983_NSRS2007_StatePlane_New_York_Long_Isl_FIPS_3104_Ft_US\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",984250.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-74.0],PARAMETER[\"Standard_Parallel_1\",40.66666666666666],PARAMETER[\"Standard_Parallel_2\",41.03333333333333],PARAMETER[\"Latitude_Of_Origin\",40.16666666666666],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",3628]]",
        3629=>"PROJCS[\"NAD_1983_NSRS2007_StatePlane_New_York_West_FIPS_3103\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",350000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-78.58333333333333],PARAMETER[\"Scale_Factor\",0.9999375],PARAMETER[\"Latitude_Of_Origin\",40.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3629]]",
        3630=>"PROJCS[\"NAD_1983_NSRS2007_StatePlane_New_York_West_FIPS_3103_Ft_US\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",1148291.666666667],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-78.58333333333333],PARAMETER[\"Scale_Factor\",0.9999375],PARAMETER[\"Latitude_Of_Origin\",40.0],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",3630]]",
        3631=>"PROJCS[\"NAD_1983_NSRS2007_StatePlane_North_Carolina_FIPS_3200\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",609601.2192024384],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-79.0],PARAMETER[\"Standard_Parallel_1\",34.33333333333334],PARAMETER[\"Standard_Parallel_2\",36.16666666666666],PARAMETER[\"Latitude_Of_Origin\",33.75],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3631]]",
        3632=>"PROJCS[\"NAD_1983_NSRS2007_StatePlane_North_Carolina_FIPS_3200_Ft_US\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",2000000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-79.0],PARAMETER[\"Standard_Parallel_1\",34.33333333333334],PARAMETER[\"Standard_Parallel_2\",36.16666666666666],PARAMETER[\"Latitude_Of_Origin\",33.75],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",3632]]",
        3633=>"PROJCS[\"NAD_1983_NSRS2007_StatePlane_North_Dakota_North_FIPS_3301\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",600000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-100.5],PARAMETER[\"Standard_Parallel_1\",47.43333333333333],PARAMETER[\"Standard_Parallel_2\",48.73333333333333],PARAMETER[\"Latitude_Of_Origin\",47.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3633]]",
        3634=>"PROJCS[\"NAD_1983_NSRS2007_StatePlane_North_Dakota_North_FIPS_3301_FtI\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",1968503.937007874],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-100.5],PARAMETER[\"Standard_Parallel_1\",47.43333333333333],PARAMETER[\"Standard_Parallel_2\",48.73333333333333],PARAMETER[\"Latitude_Of_Origin\",47.0],UNIT[\"Foot\",0.3048],AUTHORITY[\"EPSG\",3634]]",
        3635=>"PROJCS[\"NAD_1983_NSRS2007_StatePlane_North_Dakota_South_FIPS_3302\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",600000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-100.5],PARAMETER[\"Standard_Parallel_1\",46.18333333333333],PARAMETER[\"Standard_Parallel_2\",47.48333333333333],PARAMETER[\"Latitude_Of_Origin\",45.66666666666666],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3635]]",
        3636=>"PROJCS[\"NAD_1983_NSRS2007_StatePlane_North_Dakota_South_FIPS_3302_FtI\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",1968503.937007874],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-100.5],PARAMETER[\"Standard_Parallel_1\",46.18333333333333],PARAMETER[\"Standard_Parallel_2\",47.48333333333333],PARAMETER[\"Latitude_Of_Origin\",45.66666666666666],UNIT[\"Foot\",0.3048],AUTHORITY[\"EPSG\",3636]]",
        3637=>"PROJCS[\"NAD_1983_NSRS2007_StatePlane_Ohio_North_FIPS_3401\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",600000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-82.5],PARAMETER[\"Standard_Parallel_1\",40.43333333333333],PARAMETER[\"Standard_Parallel_2\",41.7],PARAMETER[\"Latitude_Of_Origin\",39.66666666666666],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3637]]",
        3638=>"PROJCS[\"NAD_1983_NSRS2007_StatePlane_Ohio_South_FIPS_3402\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",600000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-82.5],PARAMETER[\"Standard_Parallel_1\",38.73333333333333],PARAMETER[\"Standard_Parallel_2\",40.03333333333333],PARAMETER[\"Latitude_Of_Origin\",38.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3638]]",
        3639=>"PROJCS[\"NAD_1983_NSRS2007_StatePlane_Oklahoma_North_FIPS_3501\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",600000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-98.0],PARAMETER[\"Standard_Parallel_1\",35.56666666666667],PARAMETER[\"Standard_Parallel_2\",36.76666666666667],PARAMETER[\"Latitude_Of_Origin\",35.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3639]]",
        3640=>"PROJCS[\"NAD_1983_NSRS2007_StatePlane_Oklahoma_North_FIPS_3501_Ft_US\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",1968500.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-98.0],PARAMETER[\"Standard_Parallel_1\",35.56666666666667],PARAMETER[\"Standard_Parallel_2\",36.76666666666667],PARAMETER[\"Latitude_Of_Origin\",35.0],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",3640]]",
        3641=>"PROJCS[\"NAD_1983_NSRS2007_StatePlane_Oklahoma_South_FIPS_3502\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",600000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-98.0],PARAMETER[\"Standard_Parallel_1\",33.93333333333333],PARAMETER[\"Standard_Parallel_2\",35.23333333333333],PARAMETER[\"Latitude_Of_Origin\",33.33333333333334],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3641]]",
        3642=>"PROJCS[\"NAD_1983_NSRS2007_StatePlane_Oklahoma_South_FIPS_3502_Ft_US\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",1968500.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-98.0],PARAMETER[\"Standard_Parallel_1\",33.93333333333333],PARAMETER[\"Standard_Parallel_2\",35.23333333333333],PARAMETER[\"Latitude_Of_Origin\",33.33333333333334],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",3642]]",
        3643=>"PROJCS[\"NAD_1983_NSRS2007_Oregon_Statewide_Lambert\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",400000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-120.5],PARAMETER[\"Standard_Parallel_1\",43.0],PARAMETER[\"Standard_Parallel_2\",45.5],PARAMETER[\"Latitude_Of_Origin\",41.75],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3643]]",
        3644=>"PROJCS[\"NAD_1983_NSRS2007_Oregon_Statewide_Lambert_Ft_Intl\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",1312335.958005249],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-120.5],PARAMETER[\"Standard_Parallel_1\",43.0],PARAMETER[\"Standard_Parallel_2\",45.5],PARAMETER[\"Latitude_Of_Origin\",41.75],UNIT[\"Foot\",0.3048],AUTHORITY[\"EPSG\",3644]]",
        3645=>"PROJCS[\"NAD_1983_NSRS2007_StatePlane_Oregon_North_FIPS_3601\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",2500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-120.5],PARAMETER[\"Standard_Parallel_1\",44.33333333333334],PARAMETER[\"Standard_Parallel_2\",46.0],PARAMETER[\"Latitude_Of_Origin\",43.66666666666666],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3645]]",
        3646=>"PROJCS[\"NAD_1983_NSRS2007_StatePlane_Oregon_North_FIPS_3601_Ft_Intl\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",8202099.737532808],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-120.5],PARAMETER[\"Standard_Parallel_1\",44.33333333333334],PARAMETER[\"Standard_Parallel_2\",46.0],PARAMETER[\"Latitude_Of_Origin\",43.66666666666666],UNIT[\"Foot\",0.3048],AUTHORITY[\"EPSG\",3646]]",
        3647=>"PROJCS[\"NAD_1983_NSRS2007_StatePlane_Oregon_South_FIPS_3602\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",1500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-120.5],PARAMETER[\"Standard_Parallel_1\",42.33333333333334],PARAMETER[\"Standard_Parallel_2\",44.0],PARAMETER[\"Latitude_Of_Origin\",41.66666666666666],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3647]]",
        3648=>"PROJCS[\"NAD_1983_NSRS2007_StatePlane_Oregon_South_FIPS_3602_Ft_Intl\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",4921259.842519685],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-120.5],PARAMETER[\"Standard_Parallel_1\",42.33333333333334],PARAMETER[\"Standard_Parallel_2\",44.0],PARAMETER[\"Latitude_Of_Origin\",41.66666666666666],UNIT[\"Foot\",0.3048],AUTHORITY[\"EPSG\",3648]]",
        3649=>"PROJCS[\"NAD_1983_NSRS2007_StatePlane_Pennsylvania_North_FIPS_3701\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",600000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-77.75],PARAMETER[\"Standard_Parallel_1\",40.88333333333333],PARAMETER[\"Standard_Parallel_2\",41.95],PARAMETER[\"Latitude_Of_Origin\",40.16666666666666],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3649]]",
        3650=>"PROJCS[\"NAD_1983_NSRS2007_StatePlane_Pennsylvania_North_FIPS_3701_Ft_US\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",1968500.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-77.75],PARAMETER[\"Standard_Parallel_1\",40.88333333333333],PARAMETER[\"Standard_Parallel_2\",41.95],PARAMETER[\"Latitude_Of_Origin\",40.16666666666666],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",3650]]",
        3651=>"PROJCS[\"NAD_1983_NSRS2007_StatePlane_Pennsylvania_South_FIPS_3702\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",600000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-77.75],PARAMETER[\"Standard_Parallel_1\",39.93333333333333],PARAMETER[\"Standard_Parallel_2\",40.96666666666667],PARAMETER[\"Latitude_Of_Origin\",39.33333333333334],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3651]]",
        3652=>"PROJCS[\"NAD_1983_NSRS2007_StatePlane_Pennsylvania_South_FIPS_3702_Ft_US\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",1968500.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-77.75],PARAMETER[\"Standard_Parallel_1\",39.93333333333333],PARAMETER[\"Standard_Parallel_2\",40.96666666666667],PARAMETER[\"Latitude_Of_Origin\",39.33333333333334],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",3652]]",
        3653=>"PROJCS[\"NAD_1983_NSRS2007_StatePlane_Rhode_Island_FIPS_3800\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",100000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-71.5],PARAMETER[\"Scale_Factor\",0.99999375],PARAMETER[\"Latitude_Of_Origin\",41.08333333333334],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3653]]",
        3654=>"PROJCS[\"NAD_1983_NSRS2007_StatePlane_Rhode_Island_FIPS_3800_Ft_US\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",328083.3333333333],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-71.5],PARAMETER[\"Scale_Factor\",0.99999375],PARAMETER[\"Latitude_Of_Origin\",41.08333333333334],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",3654]]",
        3655=>"PROJCS[\"NAD_1983_NSRS2007_StatePlane_South_Carolina_FIPS_3900\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",609600.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-81.0],PARAMETER[\"Standard_Parallel_1\",32.5],PARAMETER[\"Standard_Parallel_2\",34.83333333333334],PARAMETER[\"Latitude_Of_Origin\",31.83333333333333],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3655]]",
        3656=>"PROJCS[\"NAD_1983_NSRS2007_StatePlane_South_Carolina_FIPS_3900_Ft_Intl\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",2000000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-81.0],PARAMETER[\"Standard_Parallel_1\",32.5],PARAMETER[\"Standard_Parallel_2\",34.83333333333334],PARAMETER[\"Latitude_Of_Origin\",31.83333333333333],UNIT[\"Foot\",0.3048],AUTHORITY[\"EPSG\",3656]]",
        3657=>"PROJCS[\"NAD_1983_NSRS2007_StatePlane_South_Dakota_North_FIPS_4001\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",600000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-100.0],PARAMETER[\"Standard_Parallel_1\",44.41666666666666],PARAMETER[\"Standard_Parallel_2\",45.68333333333333],PARAMETER[\"Latitude_Of_Origin\",43.83333333333334],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3657]]",
        3658=>"PROJCS[\"NAD_1983_NSRS2007_StatePlane_South_Dakota_North_FIPS_4001_Ft_US\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",1968500.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-100.0],PARAMETER[\"Standard_Parallel_1\",44.41666666666666],PARAMETER[\"Standard_Parallel_2\",45.68333333333333],PARAMETER[\"Latitude_Of_Origin\",43.83333333333334],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",3658]]",
        3659=>"PROJCS[\"NAD_1983_NSRS2007_StatePlane_South_Dakota_South_FIPS_4002\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",600000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-100.3333333333333],PARAMETER[\"Standard_Parallel_1\",42.83333333333334],PARAMETER[\"Standard_Parallel_2\",44.4],PARAMETER[\"Latitude_Of_Origin\",42.33333333333334],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3659]]",
        3660=>"PROJCS[\"NAD_1983_NSRS2007_StatePlane_South_Dakota_South_FIPS_4002_Ft_US\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",1968500.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-100.3333333333333],PARAMETER[\"Standard_Parallel_1\",42.83333333333334],PARAMETER[\"Standard_Parallel_2\",44.4],PARAMETER[\"Latitude_Of_Origin\",42.33333333333334],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",3660]]",
        3661=>"PROJCS[\"NAD_1983_NSRS2007_StatePlane_Tennessee_FIPS_4100\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",600000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-86.0],PARAMETER[\"Standard_Parallel_1\",35.25],PARAMETER[\"Standard_Parallel_2\",36.41666666666666],PARAMETER[\"Latitude_Of_Origin\",34.33333333333334],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3661]]",
        3662=>"PROJCS[\"NAD_1983_NSRS2007_StatePlane_Tennessee_FIPS_4100_Ft_US\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",1968500.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-86.0],PARAMETER[\"Standard_Parallel_1\",35.25],PARAMETER[\"Standard_Parallel_2\",36.41666666666666],PARAMETER[\"Latitude_Of_Origin\",34.33333333333334],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",3662]]",
        3663=>"PROJCS[\"NAD_1983_NSRS2007_StatePlane_Texas_Central_FIPS_4203\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",700000.0],PARAMETER[\"False_Northing\",3000000.0],PARAMETER[\"Central_Meridian\",-100.3333333333333],PARAMETER[\"Standard_Parallel_1\",30.11666666666667],PARAMETER[\"Standard_Parallel_2\",31.88333333333333],PARAMETER[\"Latitude_Of_Origin\",29.66666666666667],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3663]]",
        3664=>"PROJCS[\"NAD_1983_NSRS2007_StatePlane_Texas_Central_FIPS_4203_Ft_US\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",2296583.333333333],PARAMETER[\"False_Northing\",9842500.0],PARAMETER[\"Central_Meridian\",-100.3333333333333],PARAMETER[\"Standard_Parallel_1\",30.11666666666667],PARAMETER[\"Standard_Parallel_2\",31.88333333333333],PARAMETER[\"Latitude_Of_Origin\",29.66666666666667],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",3664]]",
        3665=>"PROJCS[\"NAD_1983_NSRS2007_Texas_Centric_Mapping_System_Albers\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Albers\"],PARAMETER[\"False_Easting\",1500000.0],PARAMETER[\"False_Northing\",6000000.0],PARAMETER[\"Central_Meridian\",-100.0],PARAMETER[\"Standard_Parallel_1\",27.5],PARAMETER[\"Standard_Parallel_2\",35.0],PARAMETER[\"Latitude_Of_Origin\",18.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3665]]",
        3666=>"PROJCS[\"NAD_1983_NSRS2007_Texas_Centric_Mapping_System_Lambert\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",1500000.0],PARAMETER[\"False_Northing\",5000000.0],PARAMETER[\"Central_Meridian\",-100.0],PARAMETER[\"Standard_Parallel_1\",27.5],PARAMETER[\"Standard_Parallel_2\",35.0],PARAMETER[\"Latitude_Of_Origin\",18.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3666]]",
        3667=>"PROJCS[\"NAD_1983_NSRS2007_StatePlane_Texas_North_FIPS_4201\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",200000.0],PARAMETER[\"False_Northing\",1000000.0],PARAMETER[\"Central_Meridian\",-101.5],PARAMETER[\"Standard_Parallel_1\",34.65],PARAMETER[\"Standard_Parallel_2\",36.18333333333333],PARAMETER[\"Latitude_Of_Origin\",34.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3667]]",
        3668=>"PROJCS[\"NAD_1983_NSRS2007_StatePlane_Texas_North_FIPS_4201_Ft_US\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",656166.6666666665],PARAMETER[\"False_Northing\",3280833.333333333],PARAMETER[\"Central_Meridian\",-101.5],PARAMETER[\"Standard_Parallel_1\",34.65],PARAMETER[\"Standard_Parallel_2\",36.18333333333333],PARAMETER[\"Latitude_Of_Origin\",34.0],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",3668]]",
        3669=>"PROJCS[\"NAD_1983_NSRS2007_StatePlane_Texas_North_Central_FIPS_4202\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",600000.0],PARAMETER[\"False_Northing\",2000000.0],PARAMETER[\"Central_Meridian\",-98.5],PARAMETER[\"Standard_Parallel_1\",32.13333333333333],PARAMETER[\"Standard_Parallel_2\",33.96666666666667],PARAMETER[\"Latitude_Of_Origin\",31.66666666666667],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3669]]",
        3670=>"PROJCS[\"NAD_1983_NSRS2007_StatePlane_Texas_North_Central_FIPS_4202_FtUS\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",1968500.0],PARAMETER[\"False_Northing\",6561666.666666666],PARAMETER[\"Central_Meridian\",-98.5],PARAMETER[\"Standard_Parallel_1\",32.13333333333333],PARAMETER[\"Standard_Parallel_2\",33.96666666666667],PARAMETER[\"Latitude_Of_Origin\",31.66666666666667],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",3670]]",
        3671=>"PROJCS[\"NAD_1983_NSRS2007_StatePlane_Texas_South_FIPS_4205\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",300000.0],PARAMETER[\"False_Northing\",5000000.0],PARAMETER[\"Central_Meridian\",-98.5],PARAMETER[\"Standard_Parallel_1\",26.16666666666667],PARAMETER[\"Standard_Parallel_2\",27.83333333333333],PARAMETER[\"Latitude_Of_Origin\",25.66666666666667],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3671]]",
        3672=>"PROJCS[\"NAD_1983_NSRS2007_StatePlane_Texas_South_FIPS_4205_Ft_US\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",984250.0],PARAMETER[\"False_Northing\",16404166.66666666],PARAMETER[\"Central_Meridian\",-98.5],PARAMETER[\"Standard_Parallel_1\",26.16666666666667],PARAMETER[\"Standard_Parallel_2\",27.83333333333333],PARAMETER[\"Latitude_Of_Origin\",25.66666666666667],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",3672]]",
        3673=>"PROJCS[\"NAD_1983_NSRS2007_StatePlane_Texas_South_Central_FIPS_4204\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",600000.0],PARAMETER[\"False_Northing\",4000000.0],PARAMETER[\"Central_Meridian\",-99.0],PARAMETER[\"Standard_Parallel_1\",28.38333333333333],PARAMETER[\"Standard_Parallel_2\",30.28333333333333],PARAMETER[\"Latitude_Of_Origin\",27.83333333333333],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3673]]",
        3674=>"PROJCS[\"NAD_1983_NSRS2007_StatePlane_Texas_South_Central_FIPS_4204_FtUS\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",1968500.0],PARAMETER[\"False_Northing\",13123333.33333333],PARAMETER[\"Central_Meridian\",-99.0],PARAMETER[\"Standard_Parallel_1\",28.38333333333333],PARAMETER[\"Standard_Parallel_2\",30.28333333333333],PARAMETER[\"Latitude_Of_Origin\",27.83333333333333],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",3674]]",
        3675=>"PROJCS[\"NAD_1983_NSRS2007_StatePlane_Utah_Central_FIPS_4302\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",2000000.0],PARAMETER[\"Central_Meridian\",-111.5],PARAMETER[\"Standard_Parallel_1\",39.01666666666667],PARAMETER[\"Standard_Parallel_2\",40.65],PARAMETER[\"Latitude_Of_Origin\",38.33333333333334],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3675]]",
        3676=>"PROJCS[\"NAD_1983_NSRS2007_StatePlane_Utah_Central_FIPS_4302_Ft_Intl\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",1640419.947506561],PARAMETER[\"False_Northing\",6561679.790026246],PARAMETER[\"Central_Meridian\",-111.5],PARAMETER[\"Standard_Parallel_1\",39.01666666666667],PARAMETER[\"Standard_Parallel_2\",40.65],PARAMETER[\"Latitude_Of_Origin\",38.33333333333334],UNIT[\"Foot\",0.3048],AUTHORITY[\"EPSG\",3676]]",
        3677=>"PROJCS[\"NAD_1983_NSRS2007_StatePlane_Utah_Central_FIPS_4302_Ft_US\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",1640416.666666667],PARAMETER[\"False_Northing\",6561666.666666666],PARAMETER[\"Central_Meridian\",-111.5],PARAMETER[\"Standard_Parallel_1\",39.01666666666667],PARAMETER[\"Standard_Parallel_2\",40.65],PARAMETER[\"Latitude_Of_Origin\",38.33333333333334],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",3677]]",
        3678=>"PROJCS[\"NAD_1983_NSRS2007_StatePlane_Utah_North_FIPS_4301\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",1000000.0],PARAMETER[\"Central_Meridian\",-111.5],PARAMETER[\"Standard_Parallel_1\",40.71666666666667],PARAMETER[\"Standard_Parallel_2\",41.78333333333333],PARAMETER[\"Latitude_Of_Origin\",40.33333333333334],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3678]]",
        3679=>"PROJCS[\"NAD_1983_NSRS2007_StatePlane_Utah_North_FIPS_4301_Ft_Intl\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",1640419.947506561],PARAMETER[\"False_Northing\",3280839.895013123],PARAMETER[\"Central_Meridian\",-111.5],PARAMETER[\"Standard_Parallel_1\",40.71666666666667],PARAMETER[\"Standard_Parallel_2\",41.78333333333333],PARAMETER[\"Latitude_Of_Origin\",40.33333333333334],UNIT[\"Foot\",0.3048],AUTHORITY[\"EPSG\",3679]]",
        3680=>"PROJCS[\"NAD_1983_NSRS2007_StatePlane_Utah_North_FIPS_4301_Ft_US\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",1640416.666666667],PARAMETER[\"False_Northing\",3280833.333333333],PARAMETER[\"Central_Meridian\",-111.5],PARAMETER[\"Standard_Parallel_1\",40.71666666666667],PARAMETER[\"Standard_Parallel_2\",41.78333333333333],PARAMETER[\"Latitude_Of_Origin\",40.33333333333334],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",3680]]",
        3681=>"PROJCS[\"NAD_1983_NSRS2007_StatePlane_Utah_South_FIPS_4303\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",3000000.0],PARAMETER[\"Central_Meridian\",-111.5],PARAMETER[\"Standard_Parallel_1\",37.21666666666667],PARAMETER[\"Standard_Parallel_2\",38.35],PARAMETER[\"Latitude_Of_Origin\",36.66666666666666],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3681]]",
        3682=>"PROJCS[\"NAD_1983_NSRS2007_StatePlane_Utah_South_FIPS_4303_Ft_Intl\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",1640419.947506561],PARAMETER[\"False_Northing\",9842519.685039369],PARAMETER[\"Central_Meridian\",-111.5],PARAMETER[\"Standard_Parallel_1\",37.21666666666667],PARAMETER[\"Standard_Parallel_2\",38.35],PARAMETER[\"Latitude_Of_Origin\",36.66666666666666],UNIT[\"Foot\",0.3048],AUTHORITY[\"EPSG\",3682]]",
        3683=>"PROJCS[\"NAD_1983_NSRS2007_StatePlane_Utah_South_FIPS_4303_Ft_US\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",1640416.666666667],PARAMETER[\"False_Northing\",9842500.0],PARAMETER[\"Central_Meridian\",-111.5],PARAMETER[\"Standard_Parallel_1\",37.21666666666667],PARAMETER[\"Standard_Parallel_2\",38.35],PARAMETER[\"Latitude_Of_Origin\",36.66666666666666],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",3683]]",
        3684=>"PROJCS[\"NAD_1983_NSRS2007_StatePlane_Vermont_FIPS_4400\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-72.5],PARAMETER[\"Scale_Factor\",0.9999642857142857],PARAMETER[\"Latitude_Of_Origin\",42.5],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3684]]",
        3685=>"PROJCS[\"NAD_1983_NSRS2007_StatePlane_Virginia_North_FIPS_4501\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",3500000.0],PARAMETER[\"False_Northing\",2000000.0],PARAMETER[\"Central_Meridian\",-78.5],PARAMETER[\"Standard_Parallel_1\",38.03333333333333],PARAMETER[\"Standard_Parallel_2\",39.2],PARAMETER[\"Latitude_Of_Origin\",37.66666666666666],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3685]]",
        3686=>"PROJCS[\"NAD_1983_NSRS2007_StatePlane_Virginia_North_FIPS_4501_Ft_US\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",11482916.66666666],PARAMETER[\"False_Northing\",6561666.666666666],PARAMETER[\"Central_Meridian\",-78.5],PARAMETER[\"Standard_Parallel_1\",38.03333333333333],PARAMETER[\"Standard_Parallel_2\",39.2],PARAMETER[\"Latitude_Of_Origin\",37.66666666666666],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",3686]]",
        3687=>"PROJCS[\"NAD_1983_NSRS2007_StatePlane_Virginia_South_FIPS_4502\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",3500000.0],PARAMETER[\"False_Northing\",1000000.0],PARAMETER[\"Central_Meridian\",-78.5],PARAMETER[\"Standard_Parallel_1\",36.76666666666667],PARAMETER[\"Standard_Parallel_2\",37.96666666666667],PARAMETER[\"Latitude_Of_Origin\",36.33333333333334],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3687]]",
        3688=>"PROJCS[\"NAD_1983_NSRS2007_StatePlane_Virginia_South_FIPS_4502_Ft_US\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",11482916.66666666],PARAMETER[\"False_Northing\",3280833.333333333],PARAMETER[\"Central_Meridian\",-78.5],PARAMETER[\"Standard_Parallel_1\",36.76666666666667],PARAMETER[\"Standard_Parallel_2\",37.96666666666667],PARAMETER[\"Latitude_Of_Origin\",36.33333333333334],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",3688]]",
        3689=>"PROJCS[\"NAD_1983_NSRS2007_StatePlane_Washington_North_FIPS_4601\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-120.8333333333333],PARAMETER[\"Standard_Parallel_1\",47.5],PARAMETER[\"Standard_Parallel_2\",48.73333333333333],PARAMETER[\"Latitude_Of_Origin\",47.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3689]]",
        3690=>"PROJCS[\"NAD_1983_NSRS2007_StatePlane_Washington_North_FIPS_4601_Ft_US\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",1640416.666666667],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-120.8333333333333],PARAMETER[\"Standard_Parallel_1\",47.5],PARAMETER[\"Standard_Parallel_2\",48.73333333333333],PARAMETER[\"Latitude_Of_Origin\",47.0],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",3690]]",
        3691=>"PROJCS[\"NAD_1983_NSRS2007_StatePlane_Washington_South_FIPS_4602\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-120.5],PARAMETER[\"Standard_Parallel_1\",45.83333333333334],PARAMETER[\"Standard_Parallel_2\",47.33333333333334],PARAMETER[\"Latitude_Of_Origin\",45.33333333333334],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3691]]",
        3692=>"PROJCS[\"NAD_1983_NSRS2007_StatePlane_Washington_South_FIPS_4602_Ft_US\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",1640416.666666667],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-120.5],PARAMETER[\"Standard_Parallel_1\",45.83333333333334],PARAMETER[\"Standard_Parallel_2\",47.33333333333334],PARAMETER[\"Latitude_Of_Origin\",45.33333333333334],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",3692]]",
        3693=>"PROJCS[\"NAD_1983_NSRS2007_StatePlane_West_Virginia_North_FIPS_4701\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",600000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-79.5],PARAMETER[\"Standard_Parallel_1\",39.0],PARAMETER[\"Standard_Parallel_2\",40.25],PARAMETER[\"Latitude_Of_Origin\",38.5],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3693]]",
        3694=>"PROJCS[\"NAD_1983_NSRS2007_StatePlane_West_Virginia_South_FIPS_4702\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",600000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-81.0],PARAMETER[\"Standard_Parallel_1\",37.48333333333333],PARAMETER[\"Standard_Parallel_2\",38.88333333333333],PARAMETER[\"Latitude_Of_Origin\",37.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3694]]",
        3695=>"PROJCS[\"NAD_1983_NSRS2007_StatePlane_Wisconsin_Central_FIPS_4802\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",600000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-90.0],PARAMETER[\"Standard_Parallel_1\",44.25],PARAMETER[\"Standard_Parallel_2\",45.5],PARAMETER[\"Latitude_Of_Origin\",43.83333333333334],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3695]]",
        3696=>"PROJCS[\"NAD_1983_NSRS2007_StatePlane_Wisconsin_Central_FIPS_4802_Ft_US\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",1968500.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-90.0],PARAMETER[\"Standard_Parallel_1\",44.25],PARAMETER[\"Standard_Parallel_2\",45.5],PARAMETER[\"Latitude_Of_Origin\",43.83333333333334],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",3696]]",
        3697=>"PROJCS[\"NAD_1983_NSRS2007_StatePlane_Wisconsin_North_FIPS_4801\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",600000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-90.0],PARAMETER[\"Standard_Parallel_1\",45.56666666666667],PARAMETER[\"Standard_Parallel_2\",46.76666666666667],PARAMETER[\"Latitude_Of_Origin\",45.16666666666666],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3697]]",
        3698=>"PROJCS[\"NAD_1983_NSRS2007_StatePlane_Wisconsin_North_FIPS_4801_Ft_US\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",1968500.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-90.0],PARAMETER[\"Standard_Parallel_1\",45.56666666666667],PARAMETER[\"Standard_Parallel_2\",46.76666666666667],PARAMETER[\"Latitude_Of_Origin\",45.16666666666666],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",3698]]",
        3699=>"PROJCS[\"NAD_1983_NSRS2007_StatePlane_Wisconsin_South_FIPS_4803\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",600000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-90.0],PARAMETER[\"Standard_Parallel_1\",42.73333333333333],PARAMETER[\"Standard_Parallel_2\",44.06666666666667],PARAMETER[\"Latitude_Of_Origin\",42.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3699]]",
        3700=>"PROJCS[\"NAD_1983_NSRS2007_StatePlane_Wisconsin_South_FIPS_4803_Ft_US\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",1968500.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-90.0],PARAMETER[\"Standard_Parallel_1\",42.73333333333333],PARAMETER[\"Standard_Parallel_2\",44.06666666666667],PARAMETER[\"Latitude_Of_Origin\",42.0],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",3700]]",
        3701=>"PROJCS[\"NAD_1983_NSRS2007_Wisconsin_TM\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",520000.0],PARAMETER[\"False_Northing\",-4480000.0],PARAMETER[\"Central_Meridian\",-90.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3701]]",
        3702=>"PROJCS[\"NAD_1983_NSRS2007_StatePlane_Wyoming_East_FIPS_4901\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",200000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-105.1666666666667],PARAMETER[\"Scale_Factor\",0.9999375],PARAMETER[\"Latitude_Of_Origin\",40.5],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3702]]",
        3703=>"PROJCS[\"NAD_1983_NSRS2007_StatePlane_Wyoming_East_Central_FIPS_4902\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",400000.0],PARAMETER[\"False_Northing\",100000.0],PARAMETER[\"Central_Meridian\",-107.3333333333333],PARAMETER[\"Scale_Factor\",0.9999375],PARAMETER[\"Latitude_Of_Origin\",40.5],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3703]]",
        3704=>"PROJCS[\"NAD_1983_NSRS2007_StatePlane_Wyoming_West_Central_FIPS_4903\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",600000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-108.75],PARAMETER[\"Scale_Factor\",0.9999375],PARAMETER[\"Latitude_Of_Origin\",40.5],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3704]]",
        3705=>"PROJCS[\"NAD_1983_NSRS2007_StatePlane_Wyoming_West_FIPS_4904\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",800000.0],PARAMETER[\"False_Northing\",100000.0],PARAMETER[\"Central_Meridian\",-110.0833333333333],PARAMETER[\"Scale_Factor\",0.9999375],PARAMETER[\"Latitude_Of_Origin\",40.5],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3705]]",
        3706=>"PROJCS[\"NAD_1983_NSRS2007_UTM_Zone_59N\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",171.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3706]]",
        3707=>"PROJCS[\"NAD_1983_NSRS2007_UTM_Zone_60N\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",177.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3707]]",
        3708=>"PROJCS[\"NAD_1983_NSRS2007_UTM_Zone_1N\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-177.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3708]]",
        3709=>"PROJCS[\"NAD_1983_NSRS2007_UTM_Zone_2N\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-171.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3709]]",
        3710=>"PROJCS[\"NAD_1983_NSRS2007_UTM_Zone_3N\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-165.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3710]]",
        3711=>"PROJCS[\"NAD_1983_NSRS2007_UTM_Zone_4N\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-159.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3711]]",
        3712=>"PROJCS[\"NAD_1983_NSRS2007_UTM_Zone_5N\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-153.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3712]]",
        3713=>"PROJCS[\"NAD_1983_NSRS2007_UTM_Zone_6N\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-147.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3713]]",
        3714=>"PROJCS[\"NAD_1983_NSRS2007_UTM_Zone_7N\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-141.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3714]]",
        3715=>"PROJCS[\"NAD_1983_NSRS2007_UTM_Zone_8N\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-135.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3715]]",
        3716=>"PROJCS[\"NAD_1983_NSRS2007_UTM_Zone_9N\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-129.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3716]]",
        3717=>"PROJCS[\"NAD_1983_NSRS2007_UTM_Zone_10N\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-123.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3717]]",
        3718=>"PROJCS[\"NAD_1983_NSRS2007_UTM_Zone_11N\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-117.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3718]]",
        3719=>"PROJCS[\"NAD_1983_NSRS2007_UTM_Zone_12N\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-111.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3719]]",
        3720=>"PROJCS[\"NAD_1983_NSRS2007_UTM_Zone_13N\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-105.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3720]]",
        3721=>"PROJCS[\"NAD_1983_NSRS2007_UTM_Zone_14N\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-99.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3721]]",
        3722=>"PROJCS[\"NAD_1983_NSRS2007_UTM_Zone_15N\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-93.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3722]]",
        3723=>"PROJCS[\"NAD_1983_NSRS2007_UTM_Zone_16N\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-87.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3723]]",
        3724=>"PROJCS[\"NAD_1983_NSRS2007_UTM_Zone_17N\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-81.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3724]]",
        3725=>"PROJCS[\"NAD_1983_NSRS2007_UTM_Zone_18N\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-75.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3725]]",
        3726=>"PROJCS[\"NAD_1983_NSRS2007_UTM_Zone_19N\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-69.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3726]]",
        3727=>"PROJCS[\"Reunion_1947_TM_Reunion\",GEOGCS[\"GCS_Reunion_1947\",DATUM[\"D_Reunion_1947\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",160000.0],PARAMETER[\"False_Northing\",50000.0],PARAMETER[\"Central_Meridian\",55.53333333333333],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",-21.11666666666667],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3727]]",
        3728=>"PROJCS[\"NAD_1983_NSRS2007_StatePlane_Ohio_North_FIPS_3401_Ft_US\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",1968500.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-82.5],PARAMETER[\"Standard_Parallel_1\",40.43333333333333],PARAMETER[\"Standard_Parallel_2\",41.7],PARAMETER[\"Latitude_Of_Origin\",39.66666666666666],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",3728]]",
        3729=>"PROJCS[\"NAD_1983_NSRS2007_StatePlane_Ohio_South_FIPS_3402_Ft_US\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",1968500.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-82.5],PARAMETER[\"Standard_Parallel_1\",38.73333333333333],PARAMETER[\"Standard_Parallel_2\",40.03333333333333],PARAMETER[\"Latitude_Of_Origin\",38.0],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",3729]]",
        3730=>"PROJCS[\"NAD_1983_NSRS2007_StatePlane_Wyoming_East_FIPS_4901_Ft_US\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",656166.6666666665],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-105.1666666666667],PARAMETER[\"Scale_Factor\",0.9999375],PARAMETER[\"Latitude_Of_Origin\",40.5],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",3730]]",
        3731=>"PROJCS[\"NAD_1983_NSRS2007_StatePlane_Wyoming_E_Central_FIPS_4902_Ft_US\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",1312333.333333333],PARAMETER[\"False_Northing\",328083.3333333333],PARAMETER[\"Central_Meridian\",-107.3333333333333],PARAMETER[\"Scale_Factor\",0.9999375],PARAMETER[\"Latitude_Of_Origin\",40.5],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",3731]]",
        3732=>"PROJCS[\"NAD_1983_NSRS2007_StatePlane_Wyoming_W_Central_FIPS_4903_Ft_US\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",1968500.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-108.75],PARAMETER[\"Scale_Factor\",0.9999375],PARAMETER[\"Latitude_Of_Origin\",40.5],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",3732]]",
        3733=>"PROJCS[\"NAD_1983_NSRS2007_StatePlane_Wyoming_West_FIPS_4904_Ft_US\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",2624666.666666666],PARAMETER[\"False_Northing\",328083.3333333333],PARAMETER[\"Central_Meridian\",-110.0833333333333],PARAMETER[\"Scale_Factor\",0.9999375],PARAMETER[\"Latitude_Of_Origin\",40.5],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",3733]]",
        3734=>"PROJCS[\"NAD_1983_StatePlane_Ohio_North_FIPS_3401_Feet\",GEOGCS[\"GCS_North_American_1983\",DATUM[\"D_North_American_1983\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",1968500.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-82.5],PARAMETER[\"Standard_Parallel_1\",40.43333333333333],PARAMETER[\"Standard_Parallel_2\",41.7],PARAMETER[\"Latitude_Of_Origin\",39.66666666666666],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",3734]]",
        3735=>"PROJCS[\"NAD_1983_StatePlane_Ohio_South_FIPS_3402_Feet\",GEOGCS[\"GCS_North_American_1983\",DATUM[\"D_North_American_1983\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",1968500.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-82.5],PARAMETER[\"Standard_Parallel_1\",38.73333333333333],PARAMETER[\"Standard_Parallel_2\",40.03333333333333],PARAMETER[\"Latitude_Of_Origin\",38.0],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",3735]]",
        3736=>"PROJCS[\"NAD_1983_StatePlane_Wyoming_East_FIPS_4901_Feet\",GEOGCS[\"GCS_North_American_1983\",DATUM[\"D_North_American_1983\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",656166.6666666665],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-105.1666666666667],PARAMETER[\"Scale_Factor\",0.9999375],PARAMETER[\"Latitude_Of_Origin\",40.5],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",3736]]",
        3737=>"PROJCS[\"NAD_1983_StatePlane_Wyoming_East_Central_FIPS_4902_Feet\",GEOGCS[\"GCS_North_American_1983\",DATUM[\"D_North_American_1983\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",1312333.333333333],PARAMETER[\"False_Northing\",328083.3333333333],PARAMETER[\"Central_Meridian\",-107.3333333333333],PARAMETER[\"Scale_Factor\",0.9999375],PARAMETER[\"Latitude_Of_Origin\",40.5],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",3737]]",
        3738=>"PROJCS[\"NAD_1983_StatePlane_Wyoming_West_Central_FIPS_4903_Feet\",GEOGCS[\"GCS_North_American_1983\",DATUM[\"D_North_American_1983\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",1968500.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-108.75],PARAMETER[\"Scale_Factor\",0.9999375],PARAMETER[\"Latitude_Of_Origin\",40.5],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",3738]]",
        3739=>"PROJCS[\"NAD_1983_StatePlane_Wyoming_West_FIPS_4904_Feet\",GEOGCS[\"GCS_North_American_1983\",DATUM[\"D_North_American_1983\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",2624666.666666666],PARAMETER[\"False_Northing\",328083.3333333333],PARAMETER[\"Central_Meridian\",-110.0833333333333],PARAMETER[\"Scale_Factor\",0.9999375],PARAMETER[\"Latitude_Of_Origin\",40.5],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",3739]]",
        3740=>"PROJCS[\"NAD_1983_HARN_UTM_Zone_10N\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-123.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3740]]",
        3741=>"PROJCS[\"NAD_1983_HARN_UTM_Zone_11N\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-117.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3741]]",
        3742=>"PROJCS[\"NAD_1983_HARN_UTM_Zone_12N\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-111.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3742]]",
        3743=>"PROJCS[\"NAD_1983_HARN_UTM_Zone_13N\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-105.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3743]]",
        3744=>"PROJCS[\"NAD_1983_HARN_UTM_Zone_14N\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-99.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3744]]",
        3745=>"PROJCS[\"NAD_1983_HARN_UTM_Zone_15N\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-93.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3745]]",
        3746=>"PROJCS[\"NAD_1983_HARN_UTM_Zone_16N\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-87.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3746]]",
        3747=>"PROJCS[\"NAD_1983_HARN_UTM_Zone_17N\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-81.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3747]]",
        3748=>"PROJCS[\"NAD_1983_HARN_UTM_Zone_18N\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-75.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3748]]",
        3749=>"PROJCS[\"NAD_1983_HARN_UTM_Zone_19N\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-69.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3749]]",
        3750=>"PROJCS[\"NAD_1983_HARN_UTM_Zone_4N\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-159.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3750]]",
        3751=>"PROJCS[\"NAD_1983_HARN_UTM_Zone_5N\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-153.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3751]]",
        3753=>"PROJCS[\"NAD_1983_HARN_StatePlane_Ohio_North_FIPS_3401_Feet\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",1968500.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-82.5],PARAMETER[\"Standard_Parallel_1\",40.43333333333333],PARAMETER[\"Standard_Parallel_2\",41.7],PARAMETER[\"Latitude_Of_Origin\",39.66666666666666],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",3753]]",
        3754=>"PROJCS[\"NAD_1983_HARN_StatePlane_Ohio_South_FIPS_3402_Feet\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",1968500.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-82.5],PARAMETER[\"Standard_Parallel_1\",38.73333333333333],PARAMETER[\"Standard_Parallel_2\",40.03333333333333],PARAMETER[\"Latitude_Of_Origin\",38.0],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",3754]]",
        3755=>"PROJCS[\"NAD_1983_HARN_StatePlane_Wyoming_East_FIPS_4901_Feet\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",656166.6666666665],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-105.1666666666667],PARAMETER[\"Scale_Factor\",0.9999375],PARAMETER[\"Latitude_Of_Origin\",40.5],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",3755]]",
        3756=>"PROJCS[\"NAD_1983_HARN_StatePlane_Wyoming_East_Central_FIPS_4902_Feet\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",1312333.333333333],PARAMETER[\"False_Northing\",328083.3333333333],PARAMETER[\"Central_Meridian\",-107.3333333333333],PARAMETER[\"Scale_Factor\",0.9999375],PARAMETER[\"Latitude_Of_Origin\",40.5],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",3756]]",
        3757=>"PROJCS[\"NAD_1983_HARN_StatePlane_Wyoming_West_Central_FIPS_4903_Feet\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",1968500.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-108.75],PARAMETER[\"Scale_Factor\",0.9999375],PARAMETER[\"Latitude_Of_Origin\",40.5],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",3757]]",
        3758=>"PROJCS[\"NAD_1983_HARN_StatePlane_Wyoming_West_FIPS_4904_Feet\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",2624666.666666666],PARAMETER[\"False_Northing\",328083.3333333333],PARAMETER[\"Central_Meridian\",-110.0833333333333],PARAMETER[\"Scale_Factor\",0.9999375],PARAMETER[\"Latitude_Of_Origin\",40.5],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",3758]]",
        3759=>"PROJCS[\"NAD_1983_StatePlane_Hawaii_3_FIPS_5103_Feet\",GEOGCS[\"GCS_North_American_1983\",DATUM[\"D_North_American_1983\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",1640416.666666667],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-158.0],PARAMETER[\"Scale_Factor\",0.99999],PARAMETER[\"Latitude_Of_Origin\",21.16666666666667],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",3759]]",
        3760=>"PROJCS[\"NAD_1983_HARN_StatePlane_Hawaii_3_FIPS_5103_Feet\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",1640416.666666667],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-158.0],PARAMETER[\"Scale_Factor\",0.99999],PARAMETER[\"Latitude_Of_Origin\",21.16666666666667],UNIT[\"Foot_US\",0.3048006096012192],AUTHORITY[\"EPSG\",3760]]",
        3761=>"PROJCS[\"NAD_1983_CSRS_UTM_Zone_22N\",GEOGCS[\"GCS_North_American_1983_CSRS\",DATUM[\"D_North_American_1983_CSRS\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-51.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3761]]",
        3762=>"PROJCS[\"WGS_1984_South_Georgia_Lambert\",GEOGCS[\"GCS_WGS_1984\",DATUM[\"D_WGS_1984\",SPHEROID[\"WGS_1984\",6378137.0,298.257223563]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",0.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-37.0],PARAMETER[\"Standard_Parallel_1\",-54.0],PARAMETER[\"Standard_Parallel_2\",-54.75],PARAMETER[\"Latitude_Of_Origin\",-55.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3762]]",
        3763=>"PROJCS[\"ETRS_1989_Portugal_TM06\",GEOGCS[\"GCS_ETRS_1989\",DATUM[\"D_ETRS_1989\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",0.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-8.133108333333334],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",39.66825833333333],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3763]]",
        3764=>"PROJCS[\"NZGD_2000_Chatham_Island_Circuit\",GEOGCS[\"GCS_NZGD_2000\",DATUM[\"D_NZGD_2000\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",400000.0],PARAMETER[\"False_Northing\",800000.0],PARAMETER[\"Central_Meridian\",-176.5],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",-44.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3764]]",
        3765=>"PROJCS[\"HTRS96_Croatia_TM\",GEOGCS[\"GCS_HTRS96\",DATUM[\"D_Croatian_Terrestrial_Reference_System\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",16.5],PARAMETER[\"Scale_Factor\",0.9999],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3765]]",
        3766=>"PROJCS[\"HTRS96_Croatia_LCC\",GEOGCS[\"GCS_HTRS96\",DATUM[\"D_Croatian_Terrestrial_Reference_System\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",0.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",16.5],PARAMETER[\"Standard_Parallel_1\",43.08333333333334],PARAMETER[\"Standard_Parallel_2\",45.91666666666666],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3766]]",
        3767=>"PROJCS[\"HTRS96_UTM_Zone_33N\",GEOGCS[\"GCS_HTRS96\",DATUM[\"D_Croatian_Terrestrial_Reference_System\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",15.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3767]]",
        3768=>"PROJCS[\"HTRS96_UTM_Zone_34N\",GEOGCS[\"GCS_HTRS96\",DATUM[\"D_Croatian_Terrestrial_Reference_System\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",21.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3768]]",
        3769=>"PROJCS[\"Bermuda_1957_UTM_Zone_20N\",GEOGCS[\"GCS_Bermuda_1957\",DATUM[\"D_Bermuda_1957\",SPHEROID[\"Clarke_1866\",6378206.4,294.9786982]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-63.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3769]]",
        3770=>"PROJCS[\"Bermuda_2000_National_Grid\",GEOGCS[\"GCS_Bermuda_2000\",DATUM[\"D_Bermuda_2000\",SPHEROID[\"WGS_1984\",6378137.0,298.257223563]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",550000.0],PARAMETER[\"False_Northing\",100000.0],PARAMETER[\"Central_Meridian\",-64.75],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",32.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3770]]",
        3771=>"PROJCS[\"NAD_1927_3TM_111\",GEOGCS[\"GCS_North_American_1927\",DATUM[\"D_North_American_1927\",SPHEROID[\"Clarke_1866\",6378206.4,294.9786982]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",0.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-111.0],PARAMETER[\"Scale_Factor\",0.9999],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3771]]",
        3772=>"PROJCS[\"NAD_1927_3TM_114\",GEOGCS[\"GCS_North_American_1927\",DATUM[\"D_North_American_1927\",SPHEROID[\"Clarke_1866\",6378206.4,294.9786982]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",0.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-114.0],PARAMETER[\"Scale_Factor\",0.9999],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3772]]",
        3773=>"PROJCS[\"NAD_1927_3TM_117\",GEOGCS[\"GCS_North_American_1927\",DATUM[\"D_North_American_1927\",SPHEROID[\"Clarke_1866\",6378206.4,294.9786982]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",0.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-117.0],PARAMETER[\"Scale_Factor\",0.9999],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3773]]",
        3775=>"PROJCS[\"NAD_1983_3TM_111\",GEOGCS[\"GCS_North_American_1983\",DATUM[\"D_North_American_1983\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",0.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-111.0],PARAMETER[\"Scale_Factor\",0.9999],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3775]]",
        3776=>"PROJCS[\"NAD_1983_3TM_114\",GEOGCS[\"GCS_North_American_1983\",DATUM[\"D_North_American_1983\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",0.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-114.0],PARAMETER[\"Scale_Factor\",0.9999],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3776]]",
        3777=>"PROJCS[\"NAD_1983_3TM_117\",GEOGCS[\"GCS_North_American_1983\",DATUM[\"D_North_American_1983\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",0.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-117.0],PARAMETER[\"Scale_Factor\",0.9999],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3777]]",
        3779=>"PROJCS[\"NAD_1983_CSRS_3TM_111\",GEOGCS[\"GCS_North_American_1983_CSRS\",DATUM[\"D_North_American_1983_CSRS\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",0.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-111.0],PARAMETER[\"Scale_Factor\",0.9999],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3779]]",
        3780=>"PROJCS[\"NAD_1983_CSRS_3TM_114\",GEOGCS[\"GCS_North_American_1983_CSRS\",DATUM[\"D_North_American_1983_CSRS\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",0.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-114.0],PARAMETER[\"Scale_Factor\",0.9999],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3780]]",
        3781=>"PROJCS[\"NAD_1983_CSRS_3TM_117\",GEOGCS[\"GCS_North_American_1983_CSRS\",DATUM[\"D_North_American_1983_CSRS\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",0.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-117.0],PARAMETER[\"Scale_Factor\",0.9999],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3781]]",
        3783=>"PROJCS[\"Pitcairn_2006_Pitcairn_TM_2006\",GEOGCS[\"GCS_Pitcairn_2006\",DATUM[\"D_Pitcairn_2006\",SPHEROID[\"WGS_1984\",6378137.0,298.257223563]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",14200.0],PARAMETER[\"False_Northing\",15500.0],PARAMETER[\"Central_Meridian\",-130.1129671111111],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",-25.06855261111111],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3783]]",
        3784=>"PROJCS[\"Pitcairn_1967_UTM_Zone_9S\",GEOGCS[\"GCS_Pitcairn_1967\",DATUM[\"D_Pitcairn_1967\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",10000000.0],PARAMETER[\"Central_Meridian\",-129.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3784]]",
        3785=>"PROJCS[\"WGS_1984_Web_Mercator\",GEOGCS[\"GCS_WGS_1984_Major_Auxiliary_Sphere\",DATUM[\"D_WGS_1984_Major_Auxiliary_Sphere\",SPHEROID[\"WGS_1984_Major_Auxiliary_Sphere\",6378137.0,0.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Mercator\"],PARAMETER[\"False_Easting\",0.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",0.0],PARAMETER[\"Standard_Parallel_1\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3785]]",
        3788=>"PROJCS[\"NZGD_2000_Auckland_Islands_TM_2000\",GEOGCS[\"GCS_NZGD_2000\",DATUM[\"D_NZGD_2000\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",3500000.0],PARAMETER[\"False_Northing\",10000000.0],PARAMETER[\"Central_Meridian\",166.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3788]]",
        3789=>"PROJCS[\"NZGD_2000_Campbell_Island_TM_2000\",GEOGCS[\"GCS_NZGD_2000\",DATUM[\"D_NZGD_2000\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",3500000.0],PARAMETER[\"False_Northing\",10000000.0],PARAMETER[\"Central_Meridian\",169.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3789]]",
        3790=>"PROJCS[\"NZGD_2000_Antipodes_Islands_TM_2000\",GEOGCS[\"GCS_NZGD_2000\",DATUM[\"D_NZGD_2000\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",3500000.0],PARAMETER[\"False_Northing\",10000000.0],PARAMETER[\"Central_Meridian\",179.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3790]]",
        3791=>"PROJCS[\"NZGD_2000_Raoul_Island_TM_2000\",GEOGCS[\"GCS_NZGD_2000\",DATUM[\"D_NZGD_2000\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",3500000.0],PARAMETER[\"False_Northing\",10000000.0],PARAMETER[\"Central_Meridian\",-178.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3791]]",
        3793=>"PROJCS[\"NZGD_2000_Chatham_Islands_TM_2000\",GEOGCS[\"GCS_NZGD_2000\",DATUM[\"D_NZGD_2000\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",3500000.0],PARAMETER[\"False_Northing\",10000000.0],PARAMETER[\"Central_Meridian\",-176.5],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3793]]",
        3794=>"PROJCS[\"Slovenia_1996_Slovene_National_Grid\",GEOGCS[\"GCS_Slovenia_1996\",DATUM[\"D_Slovenia_Geodetic_Datum_1996\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",-5000000.0],PARAMETER[\"Central_Meridian\",15.0],PARAMETER[\"Scale_Factor\",0.9999],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3794]]",
        3797=>"PROJCS[\"NAD_1927_MTQ_Lambert\",GEOGCS[\"GCS_North_American_1927\",DATUM[\"D_North_American_1927\",SPHEROID[\"Clarke_1866\",6378206.4,294.9786982]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",800000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-70.0],PARAMETER[\"Standard_Parallel_1\",46.0],PARAMETER[\"Standard_Parallel_2\",50.0],PARAMETER[\"Latitude_Of_Origin\",44.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3797]]",
        3798=>"PROJCS[\"NAD_1983_MTQ_Lambert\",GEOGCS[\"GCS_North_American_1983\",DATUM[\"D_North_American_1983\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",800000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-70.0],PARAMETER[\"Standard_Parallel_1\",46.0],PARAMETER[\"Standard_Parallel_2\",50.0],PARAMETER[\"Latitude_Of_Origin\",44.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3798]]",
        3799=>"PROJCS[\"NAD_1983_CSRS_MTQ_Lambert\",GEOGCS[\"GCS_North_American_1983_CSRS\",DATUM[\"D_North_American_1983_CSRS\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",800000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-70.0],PARAMETER[\"Standard_Parallel_1\",46.0],PARAMETER[\"Standard_Parallel_2\",50.0],PARAMETER[\"Latitude_Of_Origin\",44.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3799]]",
        3800=>"PROJCS[\"NAD_1927_3TM_120\",GEOGCS[\"GCS_North_American_1927\",DATUM[\"D_North_American_1927\",SPHEROID[\"Clarke_1866\",6378206.4,294.9786982]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",0.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-120.0],PARAMETER[\"Scale_Factor\",0.9999],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3800]]",
        3801=>"PROJCS[\"NAD_1983_3TM_120\",GEOGCS[\"GCS_North_American_1983\",DATUM[\"D_North_American_1983\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",0.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-120.0],PARAMETER[\"Scale_Factor\",0.9999],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3801]]",
        3802=>"PROJCS[\"NAD_1983_CSRS_3TM_120\",GEOGCS[\"GCS_North_American_1983_CSRS\",DATUM[\"D_North_American_1983_CSRS\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",0.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-120.0],PARAMETER[\"Scale_Factor\",0.9999],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3802]]",
        3812=>"PROJCS[\"Belge_Lambert_2008\",GEOGCS[\"GCS_ETRS_1989\",DATUM[\"D_ETRS_1989\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",649328.0],PARAMETER[\"False_Northing\",665262.0],PARAMETER[\"Central_Meridian\",4.359215833333333],PARAMETER[\"Standard_Parallel_1\",49.83333333333334],PARAMETER[\"Standard_Parallel_2\",51.16666666666666],PARAMETER[\"Latitude_Of_Origin\",50.797815],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3812]]",
        3814=>"PROJCS[\"NAD_1983_Mississippi_TM\",GEOGCS[\"GCS_North_American_1983\",DATUM[\"D_North_American_1983\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",1300000.0],PARAMETER[\"Central_Meridian\",-89.75],PARAMETER[\"Scale_Factor\",0.9998335],PARAMETER[\"Latitude_Of_Origin\",32.5],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3814]]",
        3815=>"PROJCS[\"NAD_1983_HARN_Mississippi_TM\",GEOGCS[\"GCS_North_American_1983_HARN\",DATUM[\"D_North_American_1983_HARN\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",1300000.0],PARAMETER[\"Central_Meridian\",-89.75],PARAMETER[\"Scale_Factor\",0.9998335],PARAMETER[\"Latitude_Of_Origin\",32.5],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3815]]",
        3816=>"PROJCS[\"NAD_1983_NSRS2007_Mississippi_TM\",GEOGCS[\"GCS_NAD_1983_NSRS2007\",DATUM[\"D_NAD_1983_NSRS2007\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",1300000.0],PARAMETER[\"Central_Meridian\",-89.75],PARAMETER[\"Scale_Factor\",0.9998335],PARAMETER[\"Latitude_Of_Origin\",32.5],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3816]]",
        3825=>"PROJCS[\"TWD_1997_TM_Penghu\",GEOGCS[\"GCS_TWD_1997\",DATUM[\"D_TWD_1997\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",250000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",119.0],PARAMETER[\"Scale_Factor\",0.9999],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3825]]",
        3826=>"PROJCS[\"TWD_1997_TM_Taiwan\",GEOGCS[\"GCS_TWD_1997\",DATUM[\"D_TWD_1997\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",250000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",121.0],PARAMETER[\"Scale_Factor\",0.9999],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3826]]",
        3827=>"PROJCS[\"TWD_1967_TM_Penghu\",GEOGCS[\"GCS_TWD_1967\",DATUM[\"D_TWD_1967\",SPHEROID[\"GRS_1967_Truncated\",6378160.0,298.25]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",250000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",119.0],PARAMETER[\"Scale_Factor\",0.9999],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3827]]",
        3828=>"PROJCS[\"TWD_1967_TM_Taiwan\",GEOGCS[\"GCS_TWD_1967\",DATUM[\"D_TWD_1967\",SPHEROID[\"GRS_1967_Truncated\",6378160.0,298.25]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",250000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",121.0],PARAMETER[\"Scale_Factor\",0.9999],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3828]]",
        3829=>"PROJCS[\"Hu_Tzu_Shan_UTM_Zone_51N\",GEOGCS[\"GCS_Hu_Tzu_Shan\",DATUM[\"D_Hu_Tzu_Shan\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",123.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3829]]",
        3832=>"PROJCS[\"WGS_1984_PDC_Mercator\",GEOGCS[\"GCS_WGS_1984\",DATUM[\"D_WGS_1984\",SPHEROID[\"WGS_1984\",6378137.0,298.257223563]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Mercator\"],PARAMETER[\"False_Easting\",0.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",150.0],PARAMETER[\"Standard_Parallel_1\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3832]]",
        3833=>"PROJCS[\"Pulkovo_1942_Adj_1958_GK_Zone_2\",GEOGCS[\"GCS_Pulkovo_1942_Adj_1958\",DATUM[\"D_Pulkovo_1942_Adj_1958\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",2500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",9.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3833]]",
        3834=>"PROJCS[\"Pulkovo_1942_Adj_1983_GK_Zone_2\",GEOGCS[\"GCS_Pulkovo_1942_Adj_1983\",DATUM[\"D_Pulkovo_1942_Adj_1983\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",2500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",9.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3834]]",
        3835=>"PROJCS[\"Pulkovo_1942_Adj_1983_GK_Zone_3\",GEOGCS[\"GCS_Pulkovo_1942_Adj_1983\",DATUM[\"D_Pulkovo_1942_Adj_1983\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",3500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",15.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3835]]",
        3836=>"PROJCS[\"Pulkovo_1942_Adj_1983_GK_Zone_4\",GEOGCS[\"GCS_Pulkovo_1942_Adj_1983\",DATUM[\"D_Pulkovo_1942_Adj_1983\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",4500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",21.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3836]]",
        3837=>"PROJCS[\"Pulkovo_1942_Adj_1958_3_Degree_GK_Zone_3\",GEOGCS[\"GCS_Pulkovo_1942_Adj_1958\",DATUM[\"D_Pulkovo_1942_Adj_1958\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",3500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",9.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3837]]",
        3838=>"PROJCS[\"Pulkovo_1942_Adj_1958_3_Degree_GK_Zone_4\",GEOGCS[\"GCS_Pulkovo_1942_Adj_1958\",DATUM[\"D_Pulkovo_1942_Adj_1958\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",4500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",12.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3838]]",
        3839=>"PROJCS[\"Pulkovo_1942_Adj_1958_3_Degree_GK_Zone_9\",GEOGCS[\"GCS_Pulkovo_1942_Adj_1958\",DATUM[\"D_Pulkovo_1942_Adj_1958\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",9500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",27.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3839]]",
        3840=>"PROJCS[\"Pulkovo_1942_Adj_1958_3_Degree_GK_Zone_10\",GEOGCS[\"GCS_Pulkovo_1942_Adj_1958\",DATUM[\"D_Pulkovo_1942_Adj_1958\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",10500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",30.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3840]]",
        3841=>"PROJCS[\"Pulkovo_1942_Adj_1983_3_Degree_GK_Zone_6\",GEOGCS[\"GCS_Pulkovo_1942_Adj_1983\",DATUM[\"D_Pulkovo_1942_Adj_1983\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",6500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",18.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3841]]",
        3844=>"PROJCS[\"Pulkovo_1942_Adj_58_Stereo_70\",GEOGCS[\"GCS_Pulkovo_1942_Adj_1958\",DATUM[\"D_Pulkovo_1942_Adj_1958\",SPHEROID[\"Krasovsky_1940\",6378245.0,298.3]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Double_Stereographic\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",500000.0],PARAMETER[\"Central_Meridian\",25.0],PARAMETER[\"Scale_Factor\",0.99975],PARAMETER[\"Latitude_Of_Origin\",46.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3844]]",
        3845=>"PROJCS[\"SWEREF99_RT90_7.5_gon_V_emulation\",GEOGCS[\"GCS_SWEREF99\",DATUM[\"D_SWEREF99\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",1500025.141],PARAMETER[\"False_Northing\",-667.282],PARAMETER[\"Central_Meridian\",11.30625],PARAMETER[\"Scale_Factor\",1.000006],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3845]]",
        3846=>"PROJCS[\"SWEREF99_RT90_5_gon_V_emulation\",GEOGCS[\"GCS_SWEREF99\",DATUM[\"D_SWEREF99\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",1500044.695],PARAMETER[\"False_Northing\",-667.13],PARAMETER[\"Central_Meridian\",13.55626666666667],PARAMETER[\"Scale_Factor\",1.0000058],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3846]]",
        3847=>"PROJCS[\"SWEREF99_RT90_2.5_gon_V_emulation\",GEOGCS[\"GCS_SWEREF99\",DATUM[\"D_SWEREF99\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",1500064.274],PARAMETER[\"False_Northing\",-667.711],PARAMETER[\"Central_Meridian\",15.80628452944445],PARAMETER[\"Scale_Factor\",1.00000561024],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3847]]",
        3848=>"PROJCS[\"SWEREF99_RT90_0_gon_emulation\",GEOGCS[\"GCS_SWEREF99\",DATUM[\"D_SWEREF99\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",1500083.521],PARAMETER[\"False_Northing\",-668.844],PARAMETER[\"Central_Meridian\",18.0563],PARAMETER[\"Scale_Factor\",1.0000054],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3848]]",
        3849=>"PROJCS[\"SWEREF99_RT90_2.5_gon_O_emulation\",GEOGCS[\"GCS_SWEREF99\",DATUM[\"D_SWEREF99\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",1500102.765],PARAMETER[\"False_Northing\",-670.706],PARAMETER[\"Central_Meridian\",20.30631666666667],PARAMETER[\"Scale_Factor\",1.0000052],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3849]]",
        3850=>"PROJCS[\"SWEREF99_RT90_5_gon_O_emulation\",GEOGCS[\"GCS_SWEREF99\",DATUM[\"D_SWEREF99\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",1500121.846],PARAMETER[\"False_Northing\",-672.557],PARAMETER[\"Central_Meridian\",22.55633333333333],PARAMETER[\"Scale_Factor\",1.0000049],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3850]]",
        3851=>"PROJCS[\"NZGD_2000_NZ_Continental_Shelf_2000\",GEOGCS[\"GCS_NZGD_2000\",DATUM[\"D_NZGD_2000\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",3000000.0],PARAMETER[\"False_Northing\",7000000.0],PARAMETER[\"Central_Meridian\",173.0],PARAMETER[\"Standard_Parallel_1\",-37.5],PARAMETER[\"Standard_Parallel_2\",-44.5],PARAMETER[\"Latitude_Of_Origin\",-41.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3851]]",
        3852=>"PROJCS[\"RSRGD2000_DGLC2000\",GEOGCS[\"GCS_RSRGD2000\",DATUM[\"D_Ross_Sea_Region_Geodetic_Datum_2000\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",157.0],PARAMETER[\"Standard_Parallel_1\",-76.66666666666667],PARAMETER[\"Standard_Parallel_2\",-79.33333333333333],PARAMETER[\"Latitude_Of_Origin\",-90.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3852]]",
        3854=>"PROJCS[\"SWEREF99_County_ST74\",GEOGCS[\"GCS_SWEREF99\",DATUM[\"D_SWEREF99\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",100182.7406],PARAMETER[\"False_Northing\",-6500620.1207],PARAMETER[\"Central_Meridian\",18.05787],PARAMETER[\"Scale_Factor\",0.99999506],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3854]]",
        3857=>"PROJCS[\"WGS_1984_Web_Mercator_Auxiliary_Sphere\",GEOGCS[\"GCS_WGS_1984\",DATUM[\"D_WGS_1984\",SPHEROID[\"WGS_1984\",6378137.0,298.257223563]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Mercator_Auxiliary_Sphere\"],PARAMETER[\"False_Easting\",0.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",0.0],PARAMETER[\"Standard_Parallel_1\",0.0],PARAMETER[\"Auxiliary_Sphere_Type\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3857]]",
        3873=>"PROJCS[\"ETRS_1989_GK19FIN\",GEOGCS[\"GCS_ETRS_1989\",DATUM[\"D_ETRS_1989\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",19500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",19.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3873]]",
        3874=>"PROJCS[\"ETRS_1989_GK20FIN\",GEOGCS[\"GCS_ETRS_1989\",DATUM[\"D_ETRS_1989\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",20500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",20.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3874]]",
        3875=>"PROJCS[\"ETRS_1989_GK21FIN\",GEOGCS[\"GCS_ETRS_1989\",DATUM[\"D_ETRS_1989\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",21500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",21.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3875]]",
        3876=>"PROJCS[\"ETRS_1989_GK22FIN\",GEOGCS[\"GCS_ETRS_1989\",DATUM[\"D_ETRS_1989\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",22500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",22.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3876]]",
        3877=>"PROJCS[\"ETRS_1989_GK23FIN\",GEOGCS[\"GCS_ETRS_1989\",DATUM[\"D_ETRS_1989\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",23500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",23.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3877]]",
        3878=>"PROJCS[\"ETRS_1989_GK24FIN\",GEOGCS[\"GCS_ETRS_1989\",DATUM[\"D_ETRS_1989\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",24500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",24.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3878]]",
        3879=>"PROJCS[\"ETRS_1989_GK25FIN\",GEOGCS[\"GCS_ETRS_1989\",DATUM[\"D_ETRS_1989\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",25500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",25.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3879]]",
        3880=>"PROJCS[\"ETRS_1989_GK26FIN\",GEOGCS[\"GCS_ETRS_1989\",DATUM[\"D_ETRS_1989\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",26500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",26.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3880]]",
        3881=>"PROJCS[\"ETRS_1989_GK27FIN\",GEOGCS[\"GCS_ETRS_1989\",DATUM[\"D_ETRS_1989\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",27500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",27.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3881]]",
        3882=>"PROJCS[\"ETRS_1989_GK28FIN\",GEOGCS[\"GCS_ETRS_1989\",DATUM[\"D_ETRS_1989\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",28500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",28.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3882]]",
        3883=>"PROJCS[\"ETRS_1989_GK29FIN\",GEOGCS[\"GCS_ETRS_1989\",DATUM[\"D_ETRS_1989\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",29500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",29.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3883]]",
        3884=>"PROJCS[\"ETRS_1989_GK30FIN\",GEOGCS[\"GCS_ETRS_1989\",DATUM[\"D_ETRS_1989\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",30500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",30.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3884]]",
        3885=>"PROJCS[\"ETRS_1989_GK31FIN\",GEOGCS[\"GCS_ETRS_1989\",DATUM[\"D_ETRS_1989\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Gauss_Kruger\"],PARAMETER[\"False_Easting\",31500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",31.0],PARAMETER[\"Scale_Factor\",1.0],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3885]]",
        3890=>"PROJCS[\"IGRS_UTM_Zone_37N\",GEOGCS[\"GCS_IGRS\",DATUM[\"D_Iraqi_Geospatial_Reference_System\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",39.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3890]]",
        3891=>"PROJCS[\"IGRS_UTM_Zone_38N\",GEOGCS[\"GCS_IGRS\",DATUM[\"D_Iraqi_Geospatial_Reference_System\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",45.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3891]]",
        3892=>"PROJCS[\"IGRS_UTM_Zone_39N\",GEOGCS[\"GCS_IGRS\",DATUM[\"D_Iraqi_Geospatial_Reference_System\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",51.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3892]]",
        3893=>"PROJCS[\"ED_1950_Iraq_National_Grid\",GEOGCS[\"GCS_European_1950\",DATUM[\"D_European_1950\",SPHEROID[\"International_1924\",6378388.0,297.0]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",800000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",46.5],PARAMETER[\"Scale_Factor\",0.9994],PARAMETER[\"Latitude_Of_Origin\",29.02626833333333],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3893]]",
        3907=>"PROJCS[\"MGI_1901_Balkans_5\",GEOGCS[\"GCS_MGI_1901\",DATUM[\"D_MGI_1901\",SPHEROID[\"Bessel_1841\",6377397.155,299.1528128]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",5500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",15.0],PARAMETER[\"Scale_Factor\",0.9999],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3907]]",
        3908=>"PROJCS[\"MGI_1901_Balkans_6\",GEOGCS[\"GCS_MGI_1901\",DATUM[\"D_MGI_1901\",SPHEROID[\"Bessel_1841\",6377397.155,299.1528128]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",6500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",18.0],PARAMETER[\"Scale_Factor\",0.9999],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3908]]",
        3909=>"PROJCS[\"MGI_1901_Balkans_7\",GEOGCS[\"GCS_MGI_1901\",DATUM[\"D_MGI_1901\",SPHEROID[\"Bessel_1841\",6377397.155,299.1528128]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",7500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",21.0],PARAMETER[\"Scale_Factor\",0.9999],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3909]]",
        3910=>"PROJCS[\"MGI_1901_Balkans_8\",GEOGCS[\"GCS_MGI_1901\",DATUM[\"D_MGI_1901\",SPHEROID[\"Bessel_1841\",6377397.155,299.1528128]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",8500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",24.0],PARAMETER[\"Scale_Factor\",0.9999],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3910]]",
        3911=>"PROJCS[\"MGI_1901_Slovenia_Grid\",GEOGCS[\"GCS_MGI_1901\",DATUM[\"D_MGI_1901\",SPHEROID[\"Bessel_1841\",6377397.155,299.1528128]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",15.0],PARAMETER[\"Scale_Factor\",0.9999],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3911]]",
        3912=>"PROJCS[\"MGI_1901_Slovene_National_Grid\",GEOGCS[\"GCS_MGI_1901\",DATUM[\"D_MGI_1901\",SPHEROID[\"Bessel_1841\",6377397.155,299.1528128]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",-5000000.0],PARAMETER[\"Central_Meridian\",15.0],PARAMETER[\"Scale_Factor\",0.9999],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3912]]",
        3920=>"PROJCS[\"Puerto_Rico_UTM_Zone_20N\",GEOGCS[\"GCS_Puerto_Rico\",DATUM[\"D_Puerto_Rico\",SPHEROID[\"Clarke_1866\",6378206.4,294.9786982]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",-63.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3920]]",
        3942=>"PROJCS[\"RGF_1993_CC42\",GEOGCS[\"GCS_RGF_1993\",DATUM[\"D_RGF_1993\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",1700000.0],PARAMETER[\"False_Northing\",1200000.0],PARAMETER[\"Central_Meridian\",3.0],PARAMETER[\"Standard_Parallel_1\",41.25],PARAMETER[\"Standard_Parallel_2\",42.75],PARAMETER[\"Latitude_Of_Origin\",42.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3942]]",
        3943=>"PROJCS[\"RGF_1993_CC43\",GEOGCS[\"GCS_RGF_1993\",DATUM[\"D_RGF_1993\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",1700000.0],PARAMETER[\"False_Northing\",2200000.0],PARAMETER[\"Central_Meridian\",3.0],PARAMETER[\"Standard_Parallel_1\",42.25],PARAMETER[\"Standard_Parallel_2\",43.75],PARAMETER[\"Latitude_Of_Origin\",43.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3943]]",
        3944=>"PROJCS[\"RGF_1993_CC44\",GEOGCS[\"GCS_RGF_1993\",DATUM[\"D_RGF_1993\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",1700000.0],PARAMETER[\"False_Northing\",3200000.0],PARAMETER[\"Central_Meridian\",3.0],PARAMETER[\"Standard_Parallel_1\",43.25],PARAMETER[\"Standard_Parallel_2\",44.75],PARAMETER[\"Latitude_Of_Origin\",44.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",3944]]",
        3945=>"PROJCS[\"RGF_1993_CC45\",GEOGCS[\"GCS_RGF_1993\",DATUM[\"D_RGF_1993\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Lambert_Conformal_Conic\"],PARAMETER[\"False_Easting\",1700000.0],PARAMETER[\"False_Northing\",4200000.0],PARAMETER[\"Central_Meridian\",3.0],PARAMETER[\"Standard_Parallel_1\",44.25],PARAMETER[\"Standard_Parallel_2\",45.75],PARAMETER[\"Latitude_Of_Origin\",45.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG