#!/usr/bin/perl

# generated by dev/build_opcodes.pl, do not edit

use Modern::Perl;
use t::TestZ80asm;

z80asm(
    options => "-l -b",
    asm1 => <<'END_ASM',
        public ZERO
        defc ZERO    = 0
END_ASM
    asm  => <<'END_ASM',
;------------------------------------------------------------------------------
; Z88DK Z80 Macro Assembler
;
; Input data for tests, to be parsed by build_opcodes.pl
;
; Copyright (C) Gunther Strube, InterLogic 1993-99
; Copyright (C) Paulo Custodio, 2011-2015
; License: The Artistic License 2.0, http://www.perlfoundation.org/artistic_license_2_0
; Repository: https://github.com/pauloscustodio/z88dk-z80asm
;------------------------------------------------------------------------------

        org  0100h

        extern ZERO

        defc N   = 20h
        defc NN  =  30h
        defc DIS = 40h

;------------------------------------------------------------------------------
; Value ranges
; z80pack is less permissive than z80asm in out of range
;------------------------------------------------------------------------------


; Byte
        ld   a,-128                     ;; 3E 80
        ld   a,-1                       ;; 3E FF
        ld   a,0                        ;; 3E 00
        ld   a,1                        ;; 3E 01
        ld   a,127                      ;; 3E 7F
        ld   a,255                      ;; 3E FF
        ld   a,-129                     ;; warn 2: integer '-129' out of range
                                        ;; 3E 7F
        ld   a,256                      ;; warn 2: integer '256' out of range
                                        ;; 3E 00

; SignedByte
        ld   a,(ix-129)                 ;; warn 2: integer '-129' out of range
                                        ;; DD 7E 7F
        ld   a,(iy-129)                 ;; warn 2: integer '-129' out of range
                                        ;; FD 7E 7F
        ld   a,(ix+128)                 ;; warn 2: integer '128' out of range
                                        ;; DD 7E 80
        ld   a,(iy+128)                 ;; warn 2: integer '128' out of range
                                        ;; FD 7E 80
        ld   a,(ix-128)                 ;; DD 7E 80
        ld   a,(iy-128)                 ;; FD 7E 80
        ld   a,(ix)                     ;; DD 7E 00
        ld   a,(iy)                     ;; FD 7E 00
        ld   a,(ix+0)                   ;; DD 7E 00
        ld   a,(iy+0)                   ;; FD 7E 00
        ld   a,(ix+127)                 ;; DD 7E 7F
        ld   a,(iy+127)                 ;; FD 7E 7F

; Word
        ld   bc,-32768                  ;; 01 00 80
        ld   bc,-1                      ;; 01 FF FF
        ld   bc,0                       ;; 01 00 00
        ld   bc,1                       ;; 01 01 00
        ld   bc,32767                   ;; 01 FF 7F
        ld   bc,65535                   ;; 01 FF FF
        ld   bc,-32769                  ;; warn 2: integer '-32769' out of range
                                        ;; 01 FF 7F
        ld   bc,65536                   ;; warn 2: integer '65536' out of range
                                        ;; 01 00 00

; 32-bit arithmetic, long range is not tested on a 32bit long
        defq 0xFFFFFFFF                 ;; FF FF FF FF
        defq 0xFFFFFFFF+1               ;; 00 00 00 00

; call out of range
        call -32768                     ;; CD 00 80
        call -1                         ;; CD FF FF
        call 0                          ;; CD 00 00
        call 1                          ;; CD 01 00
        call 65535                      ;; CD FF FF
        call -32769                     ;; warn 2: integer '-32769' out of range
                                        ;; CD FF 7F
        call 65536                      ;; warn 2: integer '65536' out of range
                                        ;; CD 00 00

;------------------------------------------------------------------------------
; Expressions
;------------------------------------------------------------------------------
        ld   a,1                        ;; 3E 01
        ld   a,'a'                      ;; 3E 61

.label_1 ld   a,2                       ;; 3E 02
label_2: ld   a,3                       ;; 3E 03

        defw label_1, label_2           ;; 6D 01 6F 01
        defw ZERO+label_1               ;; 6D 01
        defb #label_2-label_1           ;; 02
        defb #ZERO+label_2-label_1      ;; 02

        defb 255,128,0,-128             ;; FF 80 00 80
        defb ZERO+255,ZERO-128          ;; FF 80

        defw 01234h,0FFFFh              ;; 34 12 FF FF
        defw 0,-8000h                   ;; 00 00 00 80
        defw ZERO+0FFFFh,ZERO-8000h     ;; FF FF 00 80

        defq 012345678h,0FFFFFFFFh      ;; 78 56 34 12 FF FF FF FF
        defq 0,-80000000h               ;; 00 00 00 00 00 00 00 80
        defq ZERO+0FFFFFFFFh            ;; FF FF FF FF
        defq ZERO-80000000h             ;; 00 00 00 80

        defb $FF,0xFE,0BEH,0ebh         ;; FF FE BE EB
        defb ZERO+$FF                   ;; FF

        defb @1010,1010B,1010b,0b1010   ;; 0A 0A 0A 0A
        defb ZERO+@1010                 ;; 0A

; example 'A' letter
        defb %00000000                  ;; 00
        defb %00111100                  ;; 3C
        defb %01000010                  ;; 42
        defb %01000010                  ;; 42
        defb %01111110                  ;; 7E
        defb %01000010                  ;; 42
        defb %01000010                  ;; 42
        defb %00000000                  ;; 00

        defb %"--------"                ;; 00
        defb %"--####--"                ;; 3C
        defb %"-#----#-"                ;; 42
        defb %"-#----#-"                ;; 42
        defb %"-######-"                ;; 7E
        defb %"-#----#-"                ;; 42
        defb %"-#----#-"                ;; 42
        defb %"--------"                ;; 00

        defb @00000000                  ;; 00
        defb @00111100                  ;; 3C
        defb @01000010                  ;; 42
        defb @01000010                  ;; 42
        defb @01111110                  ;; 7E
        defb @01000010                  ;; 42
        defb @01000010                  ;; 42
        defb @00000000                  ;; 00

        defb @"--------"                ;; 00
        defb @"--####--"                ;; 3C
        defb @"-#----#-"                ;; 42
        defb @"-#----#-"                ;; 42
        defb @"-######-"                ;; 7E
        defb @"-#----#-"                ;; 42
        defb @"-#----#-"                ;; 42
        defb @"--------"                ;; 00

; BUG_0044: binary constants with more than 8 bits not accepted
        defw %"####---###--##-#"        ;; CD F1
        defw %01111000111001101         ;; CD F1
        defq %"#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-"
                                        ;; AA AA AA AA

        defb 1<0,1<1,1<2                ;; 00 00 01
        defb ZERO+1<0,ZERO+1<1,ZERO+1<2 ;; 00 00 01

        defb 1<=0,1<=1,1<=2             ;; 00 01 01
        defb ZERO+1<=0,ZERO+1<=1,ZERO+1<=2
                                        ;; 00 01 01

        defb 1=0,1=1,1=2                ;; 00 01 00
        defb ZERO+1=0,ZERO+1=1,ZERO+1=2 ;; 00 01 00

        defb 1==0,1==1,1==2             ;; 00 01 00
        defb ZERO+1==0,ZERO+1==1,ZERO+1==2
                                        ;; 00 01 00

        defb 1!=0,1!=1,1!=2             ;; 01 00 01
        defb ZERO+1!=0,ZERO+1!=1,ZERO+1!=2
                                        ;; 01 00 01

        defb 1<>0,1<>1,1<>2             ;; 01 00 01
        defb ZERO+1<>0,ZERO+1<>1,ZERO+1<>2
                                        ;; 01 00 01

        defb 1>0,1>1,1>2                ;; 01 00 00
        defb ZERO+1>0,ZERO+1>1,ZERO+1>2 ;; 01 00 00
        defb 1>=0,1>=1,1>=2             ;; 01 01 00
        defb ZERO+1>=0,ZERO+1>=1,ZERO+1>=2
                                        ;; 01 01 00
        defb +1,-1                      ;; 01 FF
        defb ZERO++1,ZERO+-1            ;; 01 FF


        defb 1+1,3-1                    ;; 02 02
        defb ZERO+1+1,ZERO+3-1          ;; 02 02

        defb 3&2,2|0,0^2                ;; 02 02 02
        defb ZERO+3&2,ZERO+2|0,ZERO+0^2 ;; 02 02 02

        defb (~0xAA)&0xFF               ;; 55
        defb ZERO+(~0xAA)&0xFF          ;; 55

        defb 5*2,100/10,10%3            ;; 0A 0A 01
        defb ZERO+5*2,ZERO+100/10,ZERO+10%3
                                        ;; 0A 0A 01

; BUG_0040: Detect and report division by zero instead of crashing

        defb 2**7,2**6                  ;; 80 40
        defb ZERO+2**7,ZERO+2**6        ;; 80 40

        defb 2**1,2**0                  ;; 02 01
        defb ZERO+2**1,ZERO+2**0        ;; 02 01

; BUG_0041: truncate negative powers to zero, i.e. pow(2,-1) == 0
        defb 2**-1                      ;; 00
        defb ZERO+2**-1                 ;; 00

        defb 2*[1+2*(1+2)]              ;; 0E
        defb ZERO+2*[1+2*(1+2)]         ;; 0E

        defb 2*1+2*1+2                  ;; 06
        defb ZERO+2*1+2*1+2             ;; 06

        defb !0,!1                      ;; 01 00
        defb ZERO+!0,ZERO+!1            ;; 01 00

        defb 0&&0,0&&1,1&&0,1&&1        ;; 00 00 00 01
        defb ZERO+0&&0,ZERO+0&&1,ZERO+1&&0,ZERO+1&&1
                                        ;; 00 00 00 01

        defb 0||0,0||1,1||0,1||1        ;; 00 01 01 01
        defb ZERO+0||0,ZERO+0||1,ZERO+1||0,ZERO+1||1
                                        ;; 00 01 01 01

        defb 0||0||1,0||0||0            ;; 01 00
        defb ZERO+0||0||1,ZERO+0||0||0  ;; 01 00

        defb ' '                        ;; 20
        defb ZERO+' '                   ;; 20

        defb 1<<7,128>>7                ;; 80 01
        defb ZERO+1<<7,ZERO+128>>7      ;; 80 01

        defb 1?2:3,0?4:5                ;; 02 05
        defb ZERO+1?2:3,ZERO+0?4:5      ;; 02 05


; EACH was interpreted as 0x0EAC - fixed
EACH:   djnz EACH                       ;; 10 FE

; check priorities
        defb 1 || 0 && 0                ;; 01
        defb 0 && 0 |  1                ;; 00
        defb 0 && 0 ^  1                ;; 00
        defb 0 |  1 &  1                ;; 01
        defb 1 ^  0 &  0                ;; 01
        defb 0 &  1 == 0                ;; 00
        defb 0 &  0 != 1                ;; 00
        defb 2 == 1 << 1                ;; 01
        defb 1 << 1 +  3                ;; 10
        defb 1 +  2 *  3                ;; 07
        defb 2 *  3 ** 4                ;; A2
        defw 2 ** 3 ** 2                ;; 00 02
        defb 2 ** -3                    ;; 00
        defb ---+--+-2                  ;; 02
        defb 1 ? 2 : 3, 0 ? 4 : 5       ;; 02 05
        defb 0 ? 0 ? 2 : 3 : 0 ? 4 : 5  ;; 05
        defb 0 ? 0 ? 2 : 3 : 1 ? 4 : 5  ;; 04
        defb 1 ? 0 ? 2 : 3 : 1 ? 4 : 5  ;; 03
        defb 1 ? 1 ? 2 : 3 : 1 ? 4 : 5  ;; 02
        defb ~~2                        ;; 02

; BUG_0043: buffer overflow on constants longer than 128 chars in object file
        defw ZERO+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1
                                        ;; E8 03

;------------------------------------------------------------------------------
; DEFB, DEFW, DEFQ
;------------------------------------------------------------------------------

        defb 1,2,3,4,5,6,7,8,10,11,12,13,14,15,16,17,18,19,20,'!'
                                        ;; 01 02 03 04 05 06 07 08 0A 0B 0C 0D 0E 0F 10 11 12 13 14 21
        defw 1,2,3,4,5,6,7,8,10,11,12,13,14,15,16,17,18,19,20,'!'
                                        ;; 01 00 02 00 03 00 04 00 05 00 06 00 07 00 08 00 0A 00 0B 00 0C 00 0D 00 0E 00 0F 00 10 00 11 00 12 00 13 00 14 00 21 00
        defb "ABCDEFGHIJKLMNOPQRSTUVWXYZ"
                                        ;; 41 42 43 44 45 46 47 48 49 4A 4B 4C 4D 4E 4F 50 51 52 53 54 55 56 57 58 59 5A
        defw 0,102h,203h,304h           ;; 00 00 02 01 03 02 04 03
        defq 0,1020304h,5060708h        ;; 00 00 00 00 04 03 02 01 08 07 06 05

        defm "hello",32,"","world"      ;; 68 65 6C 6C 6F 20 77 6F 72 6C 64
        defm "hello",ZERO+32,"","world" ;; 68 65 6C 6C 6F 20 77 6F 72 6C 64
        defm 32,"world"                 ;; 20 77 6F 72 6C 64


;------------------------------------------------------------------------------
; 8 bit load group
;------------------------------------------------------------------------------

        ld   b,b                        ;; 40
        ld   c,b                        ;; 48
        ld   d,b                        ;; 50
        ld   e,b                        ;; 58
        ld   h,b                        ;; 60
        ld   l,b                        ;; 68
        ld   a,b                        ;; 78
        ld   b,c                        ;; 41
        ld   c,c                        ;; 49
        ld   d,c                        ;; 51
        ld   e,c                        ;; 59
        ld   h,c                        ;; 61
        ld   l,c                        ;; 69
        ld   a,c                        ;; 79
        ld   b,d                        ;; 42
        ld   c,d                        ;; 4A
        ld   d,d                        ;; 52
        ld   e,d                        ;; 5A
        ld   h,d                        ;; 62
        ld   l,d                        ;; 6A
        ld   a,d                        ;; 7A
        ld   b,e                        ;; 43
        ld   c,e                        ;; 4B
        ld   d,e                        ;; 53
        ld   e,e                        ;; 5B
        ld   h,e                        ;; 63
        ld   l,e                        ;; 6B
        ld   a,e                        ;; 7B
        ld   b,h                        ;; 44
        ld   c,h                        ;; 4C
        ld   d,h                        ;; 54
        ld   e,h                        ;; 5C
        ld   h,h                        ;; 64
        ld   l,h                        ;; 6C
        ld   a,h                        ;; 7C
        ld   b,l                        ;; 45
        ld   c,l                        ;; 4D
        ld   d,l                        ;; 55
        ld   e,l                        ;; 5D
        ld   h,l                        ;; 65
        ld   l,l                        ;; 6D
        ld   a,l                        ;; 7D
        ld   b,a                        ;; 47
        ld   c,a                        ;; 4F
        ld   d,a                        ;; 57
        ld   e,a                        ;; 5F
        ld   h,a                        ;; 67
        ld   l,a                        ;; 6F
        ld   a,a                        ;; 7F
        ld   b,N                        ;; 06 20
        ld   c,N                        ;; 0E 20
        ld   d,N                        ;; 16 20
        ld   e,N                        ;; 1E 20
        ld   h,N                        ;; 26 20
        ld   l,N                        ;; 2E 20
        ld   a,N                        ;; 3E 20

IF      !RABBIT
        ld   b,ixh                      ;; DD 44
        ld   c,ixh                      ;; DD 4C
        ld   d,ixh                      ;; DD 54
        ld   e,ixh                      ;; DD 5C
        ld   ixh,ixh                    ;; DD 64
        ld   ixl,ixh                    ;; DD 6C
        ld   a,ixh                      ;; DD 7C
        ld   b,ixl                      ;; DD 45
        ld   c,ixl                      ;; DD 4D
        ld   d,ixl                      ;; DD 55
        ld   e,ixl                      ;; DD 5D
        ld   ixh,ixl                    ;; DD 65
        ld   ixl,ixl                    ;; DD 6D
        ld   a,ixl                      ;; DD 7D
        ld   ixh,b                      ;; DD 60
        ld   ixl,b                      ;; DD 68
        ld   ixh,c                      ;; DD 61
        ld   ixl,c                      ;; DD 69
        ld   ixh,d                      ;; DD 62
        ld   ixl,d                      ;; DD 6A
        ld   ixh,e                      ;; DD 63
        ld   ixl,e                      ;; DD 6B
        ld   ixh,ixh                    ;; DD 64
        ld   ixl,ixh                    ;; DD 6C
        ld   ixh,ixl                    ;; DD 65
        ld   ixl,ixl                    ;; DD 6D
        ld   ixh,a                      ;; DD 67
        ld   ixl,a                      ;; DD 6F
        ld   ixh,N                      ;; DD 26 20
        ld   ixl,N                      ;; DD 2E 20

        ld   b,iyh                      ;; FD 44
        ld   c,iyh                      ;; FD 4C
        ld   d,iyh                      ;; FD 54
        ld   e,iyh                      ;; FD 5C
        ld   iyh,iyh                    ;; FD 64
        ld   iyl,iyh                    ;; FD 6C
        ld   a,iyh                      ;; FD 7C
        ld   b,iyl                      ;; FD 45
        ld   c,iyl                      ;; FD 4D
        ld   d,iyl                      ;; FD 55
        ld   e,iyl                      ;; FD 5D
        ld   iyh,iyl                    ;; FD 65
        ld   iyl,iyl                    ;; FD 6D
        ld   a,iyl                      ;; FD 7D
        ld   iyh,b                      ;; FD 60
        ld   iyl,b                      ;; FD 68
        ld   iyh,c                      ;; FD 61
        ld   iyl,c                      ;; FD 69
        ld   iyh,d                      ;; FD 62
        ld   iyl,d                      ;; FD 6A
        ld   iyh,e                      ;; FD 63
        ld   iyl,e                      ;; FD 6B
        ld   iyh,iyh                    ;; FD 64
        ld   iyl,iyh                    ;; FD 6C
        ld   iyh,iyl                    ;; FD 65
        ld   iyl,iyl                    ;; FD 6D
        ld   iyh,a                      ;; FD 67
        ld   iyl,a                      ;; FD 6F
        ld   iyh,N                      ;; FD 26 20
        ld   iyl,N                      ;; FD 2E 20
ELSE    
        ld   b,ixh
        ld   c,ixh
        ld   d,ixh
        ld   e,ixh
        ld   ixh,ixh
        ld   ixl,ixh
        ld   a,ixh
        ld   b,ixl
        ld   c,ixl
        ld   d,ixl
        ld   e,ixl
        ld   ixh,ixl
        ld   ixl,ixl
        ld   a,ixl
        ld   ixh,b
        ld   ixl,b
        ld   ixh,c
        ld   ixl,c
        ld   ixh,d
        ld   ixl,d
        ld   ixh,e
        ld   ixl,e
        ld   ixh,ixh
        ld   ixl,ixh
        ld   ixh,ixl
        ld   ixl,ixl
        ld   ixh,a
        ld   ixl,a
        ld   ixh,1
        ld   ixl,1

        ld   b,iyh
        ld   c,iyh
        ld   d,iyh
        ld   e,iyh
        ld   iyh,iyh
        ld   iyl,iyh
        ld   a,iyh
        ld   b,iyl
        ld   c,iyl
        ld   d,iyl
        ld   e,iyl
        ld   iyh,iyl
        ld   iyl,iyl
        ld   a,iyl
        ld   iyh,b
        ld   iyl,b
        ld   iyh,c
        ld   iyl,c
        ld   iyh,d
        ld   iyl,d
        ld   iyh,e
        ld   iyl,e
        ld   iyh,iyh
        ld   iyl,iyh
        ld   iyh,iyl
        ld   iyl,iyl
        ld   iyh,a
        ld   iyl,a
        ld   iyh,1
        ld   iyl,1
ENDIF   

        ld   b,(hl)                     ;; 46
        ld   c,(hl)                     ;; 4E
        ld   d,(hl)                     ;; 56
        ld   e,(hl)                     ;; 5E
        ld   h,(hl)                     ;; 66
        ld   l,(hl)                     ;; 6E
        ld   a,(hl)                     ;; 7E
; ldi b,(hl)   ;;  ld b,(hl) ;; inc hl
; ldi c,(hl)   ;;  ld c,(hl) ;; inc hl
; ldi d,(hl)   ;;  ld d,(hl) ;; inc hl
; ldi e,(hl)   ;;  ld e,(hl) ;; inc hl
; ldi h,(hl)   ;;  ld h,(hl) ;; inc hl
; ldi l,(hl)   ;;  ld l,(hl) ;; inc hl
; ldi a,(hl)   ;;  ld a,(hl) ;; inc hl
; ldd b,(hl)   ;;  ld b,(hl) ;; dec hl
; ldd c,(hl)   ;;  ld c,(hl) ;; dec hl
; ldd d,(hl)   ;;  ld d,(hl) ;; dec hl
; ldd e,(hl)   ;;  ld e,(hl) ;; dec hl
; ldd h,(hl)   ;;  ld h,(hl) ;; dec hl
; ldd l,(hl)   ;;  ld l,(hl) ;; dec hl
; ldd a,(hl)   ;;  ld a,(hl) ;; dec hl

        ld   b,(ix+DIS)                 ;; DD 46 40
        ld   c,(ix+DIS)                 ;; DD 4E 40
        ld   d,(ix+DIS)                 ;; DD 56 40
        ld   e,(ix+DIS)                 ;; DD 5E 40
        ld   h,(ix+DIS)                 ;; DD 66 40
        ld   l,(ix+DIS)                 ;; DD 6E 40
        ld   a,(ix+DIS)                 ;; DD 7E 40
        ld   b,(iy+DIS)                 ;; FD 46 40
        ld   c,(iy+DIS)                 ;; FD 4E 40
        ld   d,(iy+DIS)                 ;; FD 56 40
        ld   e,(iy+DIS)                 ;; FD 5E 40
        ld   h,(iy+DIS)                 ;; FD 66 40
        ld   l,(iy+DIS)                 ;; FD 6E 40
        ld   a,(iy+DIS)                 ;; FD 7E 40
; ldi b,(ix+DIS) ;; ld b,(ix+DIS) ;; inc ix
; ldi c,(ix+DIS) ;; ld c,(ix+DIS) ;; inc ix
; ldi d,(ix+DIS) ;; ld d,(ix+DIS) ;; inc ix
; ldi e,(ix+DIS) ;; ld e,(ix+DIS) ;; inc ix
; ldi h,(ix+DIS) ;; ld h,(ix+DIS) ;; inc ix
; ldi l,(ix+DIS) ;; ld l,(ix+DIS) ;; inc ix
; ldi a,(ix+DIS) ;; ld a,(ix+DIS) ;; inc ix
; ldi b,(iy+DIS) ;; ld b,(iy+DIS) ;; inc iy
; ldi c,(iy+DIS) ;; ld c,(iy+DIS) ;; inc iy
; ldi d,(iy+DIS) ;; ld d,(iy+DIS) ;; inc iy
; ldi e,(iy+DIS) ;; ld e,(iy+DIS) ;; inc iy
; ldi h,(iy+DIS) ;; ld h,(iy+DIS) ;; inc iy
; ldi l,(iy+DIS) ;; ld l,(iy+DIS) ;; inc iy
; ldi a,(iy+DIS) ;; ld a,(iy+DIS) ;; inc iy
; ldd b,(ix+DIS) ;; ld b,(ix+DIS) ;; dec ix
; ldd c,(ix+DIS) ;; ld c,(ix+DIS) ;; dec ix
; ldd d,(ix+DIS) ;; ld d,(ix+DIS) ;; dec ix
; ldd e,(ix+DIS) ;; ld e,(ix+DIS) ;; dec ix
; ldd h,(ix+DIS) ;; ld h,(ix+DIS) ;; dec ix
; ldd l,(ix+DIS) ;; ld l,(ix+DIS) ;; dec ix
; ldd a,(ix+DIS) ;; ld a,(ix+DIS) ;; dec ix
; ldd b,(iy+DIS) ;; ld b,(iy+DIS) ;; dec iy
; ldd c,(iy+DIS) ;; ld c,(iy+DIS) ;; dec iy
; ldd d,(iy+DIS) ;; ld d,(iy+DIS) ;; dec iy
; ldd e,(iy+DIS) ;; ld e,(iy+DIS) ;; dec iy
; ldd h,(iy+DIS) ;; ld h,(iy+DIS) ;; dec iy
; ldd l,(iy+DIS) ;; ld l,(iy+DIS) ;; dec iy
; ldd a,(iy+DIS) ;; ld a,(iy+DIS) ;; dec iy

        ld   (hl),b                     ;; 70
        ld   (hl),c                     ;; 71
        ld   (hl),d                     ;; 72
        ld   (hl),e                     ;; 73
        ld   (hl),h                     ;; 74
        ld   (hl),l                     ;; 75
        ld   (hl),a                     ;; 77
; ldi (hl),b   ;;  ld (hl),b ;; inc hl
; ldi (hl),c   ;;  ld (hl),c ;; inc hl
; ldi (hl),d   ;;  ld (hl),d ;; inc hl
; ldi (hl),e   ;;  ld (hl),e ;; inc hl
; ldi (hl),h   ;;  ld (hl),h ;; inc hl
; ldi (hl),l   ;;  ld (hl),l ;; inc hl
; ldi (hl),a   ;;  ld (hl),a ;; inc hl
; ldd (hl),b   ;;  ld (hl),b ;; dec hl
; ldd (hl),c   ;;  ld (hl),c ;; dec hl
; ldd (hl),d   ;;  ld (hl),d ;; dec hl
; ldd (hl),e   ;;  ld (hl),e ;; dec hl
; ldd (hl),h   ;;  ld (hl),h ;; dec hl
; ldd (hl),l   ;;  ld (hl),l ;; dec hl
; ldd (hl),a   ;;  ld (hl),a ;; dec hl

        ld   (ix+DIS),b                 ;; DD 70 40
        ld   (iy+DIS),b                 ;; FD 70 40
        ld   (ix+DIS),c                 ;; DD 71 40
        ld   (iy+DIS),c                 ;; FD 71 40
        ld   (ix+DIS),d                 ;; DD 72 40
        ld   (iy+DIS),d                 ;; FD 72 40
        ld   (ix+DIS),e                 ;; DD 73 40
        ld   (iy+DIS),e                 ;; FD 73 40
        ld   (ix+DIS),h                 ;; DD 74 40
        ld   (iy+DIS),h                 ;; FD 74 40
        ld   (ix+DIS),l                 ;; DD 75 40
        ld   (iy+DIS),l                 ;; FD 75 40
        ld   (ix+DIS),a                 ;; DD 77 40
        ld   (iy+DIS),a                 ;; FD 77 40
; ldi (ix+DIS),b ;; ld (ix+DIS),b ;; inc ix
; ldi (iy+DIS),b ;; ld (iy+DIS),b ;; inc iy
; ldi (ix+DIS),c ;; ld (ix+DIS),c ;; inc ix
; ldi (iy+DIS),c ;; ld (iy+DIS),c ;; inc iy
; ldi (ix+DIS),d ;; ld (ix+DIS),d ;; inc ix
; ldi (iy+DIS),d ;; ld (iy+DIS),d ;; inc iy
; ldi (ix+DIS),e ;; ld (ix+DIS),e ;; inc ix
; ldi (iy+DIS),e ;; ld (iy+DIS),e ;; inc iy
; ldi (ix+DIS),h ;; ld (ix+DIS),h ;; inc ix
; ldi (iy+DIS),h ;; ld (iy+DIS),h ;; inc iy
; ldi (ix+DIS),l ;; ld (ix+DIS),l ;; inc ix
; ldi (iy+DIS),l ;; ld (iy+DIS),l ;; inc iy
; ldi (ix+DIS),a ;; ld (ix+DIS),a ;; inc ix
; ldi (iy+DIS),a ;; ld (iy+DIS),a ;; inc iy
; ldd (ix+DIS),b ;; ld (ix+DIS),b ;; dec ix
; ldd (iy+DIS),b ;; ld (iy+DIS),b ;; dec iy
; ldd (ix+DIS),c ;; ld (ix+DIS),c ;; dec ix
; ldd (iy+DIS),c ;; ld (iy+DIS),c ;; dec iy
; ldd (ix+DIS),d ;; ld (ix+DIS),d ;; dec ix
; ldd (iy+DIS),d ;; ld (iy+DIS),d ;; dec iy
; ldd (ix+DIS),e ;; ld (ix+DIS),e ;; dec ix
; ldd (iy+DIS),e ;; ld (iy+DIS),e ;; dec iy
; ldd (ix+DIS),h ;; ld (ix+DIS),h ;; dec ix
; ldd (iy+DIS),h ;; ld (iy+DIS),h ;; dec iy
; ldd (ix+DIS),l ;; ld (ix+DIS),l ;; dec ix
; ldd (iy+DIS),l ;; ld (iy+DIS),l ;; dec iy
; ldd (ix+DIS),a ;; ld (ix+DIS),a ;; dec ix
; ldd (iy+DIS),a ;; ld (iy+DIS),a ;; dec iy

        ld   (hl),N                     ;; 36 20
; ldi (hl),N       ;; ld (hl),N ;; inc hl
; ldd (hl),N       ;; ld (hl),N ;; dec hl

        ld   (ix+DIS),N                 ;; DD 36 40 20
        ld   (iy+DIS),N                 ;; FD 36 40 20
; ldi (ix+DIS),N     ;; ld (ix+DIS),N ;; inc ix
; ldi (iy+DIS),N     ;; ld (iy+DIS),N ;; inc iy
; ldd (ix+DIS),N     ;; ld (ix+DIS),N ;; dec ix
; ldd (iy+DIS),N     ;; ld (iy+DIS),N ;; dec iy

        ld   a,(bc)                     ;; 0A
        ld   a,(de)                     ;; 1A
; ldi a,(bc)      ;; ld a,(bc) ;; inc bc
; ldi a,(de)      ;; ld a,(de) ;; inc de
; ldd a,(bc)      ;; ld a,(bc) ;; dec bc
; ldd a,(de)      ;; ld a,(de) ;; dec de

        ld   (bc),a                     ;; 02
        ld   (de),a                     ;; 12
; ldi (bc),a      ;; ld (bc),a ;; inc bc
; ldi (de),a      ;; ld (de),a ;; inc de
; ldd (bc),a      ;; ld (bc),a ;; dec bc
; ldd (de),a      ;; ld (de),a ;; dec de

        ld   a,(NN)                     ;; 3A 30 00
        ld   (NN),a                     ;; 32 30 00


IF      !RABBIT
        ld   i,a                        ;; ED 47
        ld   r,a                        ;; ED 4F
        ld   a,i                        ;; ED 57
        ld   a,r                        ;; ED 5F
ELSE    
        ld   iir,a
        ld   eir,a
        ld   a,iir
        ld   a,eir
ENDIF   

;------------------------------------------------------------------------------
; 16 bit load group
;------------------------------------------------------------------------------

        ld   bc,NN                      ;; 01 30 00
        ld   de,NN                      ;; 11 30 00
        ld   hl,NN                      ;; 21 30 00
        ld   ix,NN                      ;; DD 21 30 00
        ld   iy,NN                      ;; FD 21 30 00
        ld   sp,NN                      ;; 31 30 00
        ld   bc,(NN)                    ;; ED 4B 30 00
        ld   de,(NN)                    ;; ED 5B 30 00
        ld   hl,(NN)                    ;; 2A 30 00
        ld   ix,(NN)                    ;; DD 2A 30 00
        ld   iy,(NN)                    ;; FD 2A 30 00
        ld   sp,(NN)                    ;; ED 7B 30 00
        ld   (NN),bc                    ;; ED 43 30 00
        ld   (NN),de                    ;; ED 53 30 00
        ld   (NN),hl                    ;; 22 30 00
        ld   (NN),ix                    ;; DD 22 30 00
        ld   (NN),iy                    ;; FD 22 30 00
        ld   (NN),sp                    ;; ED 73 30 00
        ld   sp,hl                      ;; F9
        ld   sp,ix                      ;; DD F9
        ld   sp,iy                      ;; FD F9
        push bc                         ;; C5
        push de                         ;; D5
        push hl                         ;; E5
        push ix                         ;; DD E5
        push iy                         ;; FD E5
        push af                         ;; F5
        pop  bc                         ;; C1
        pop  de                         ;; D1
        pop  hl                         ;; E1
        pop  ix                         ;; DD E1
        pop  iy                         ;; FD E1
        pop  af                         ;; F1

; ld bc,bc =}      0x40+<1:3>+<2>      0x49+<1:3>+<2>
; ld de,bc =}      0x40+<1:3>+<2>      0x49+<1:3>+<2>
; ld hl,bc =}      0x40+<1:3>+<2>      0x49+<1:3>+<2>
; ld bc,de =}      0x40+<1:3>+<2>      0x49+<1:3>+<2>
; ld de,de =}      0x40+<1:3>+<2>      0x49+<1:3>+<2>
; ld hl,de =}      0x40+<1:3>+<2>      0x49+<1:3>+<2>
; ld bc,hl =}      0x40+<1:3>+<2>      0x49+<1:3>+<2>
; ld de,hl =}      0x40+<1:3>+<2>      0x49+<1:3>+<2>
; ld hl,hl =}      0x40+<1:3>+<2>      0x49+<1:3>+<2>
; ld bc,ix    =} 0xDD 0x44+<1:3>     0xDD 0x4D+<1:3>
; ld de,ix    =} 0xDD 0x44+<1:3>     0xDD 0x4D+<1:3>
; ld bc,iy    =} 0xFD 0x44+<1:3>     0xFD 0x4D+<1:3>
; ld de,iy    =} 0xFD 0x44+<1:3>     0xFD 0x4D+<1:3>
;
; ld bc,(hl)    =}      0x4E+<1:3> 0x23     0x46+<1:3> 0x2B
; ld de,(hl)    =}      0x4E+<1:3> 0x23     0x46+<1:3> 0x2B
; ldi bc,(hl)    =}      0x4E+<1:3> 0x23     0x46+<1:3> 0x23
; ldi de,(hl)    =}      0x4E+<1:3> 0x23     0x46+<1:3> 0x23
;
; ld bc,(ix+DIS)  =} 0xDD 0x4E+<1:3> DIS           0xDD 0x46+<1:3> DIS+1
; ld de,(ix+DIS)  =} 0xDD 0x4E+<1:3> DIS           0xDD 0x46+<1:3> DIS+1
; ld hl,(ix+DIS)  =} 0xDD 0x4E+<1:3> DIS           0xDD 0x46+<1:3> DIS+1
; ldi bc,(ix+DIS)  =} 0xDD 0x4E+<1:3> DIS 0xDD 0x23 0xDD 0x46+<1:3> DIS 0xDD 0x23
; ldi de,(ix+DIS)  =} 0xDD 0x4E+<1:3> DIS 0xDD 0x23 0xDD 0x46+<1:3> DIS 0xDD 0x23
; ldi hl,(ix+DIS)  =} 0xDD 0x4E+<1:3> DIS 0xDD 0x23 0xDD 0x46+<1:3> DIS 0xDD 0x23
;
; ld bc,(iy+DIS)  =} 0xFD 0x4E+<1:3> DIS           0xFD 0x46+<1:3> DIS+1
; ld de,(iy+DIS)  =} 0xFD 0x4E+<1:3> DIS           0xFD 0x46+<1:3> DIS+1
; ld hl,(iy+DIS)  =} 0xFD 0x4E+<1:3> DIS           0xFD 0x46+<1:3> DIS+1
; ldi bc,(iy+DIS)  =} 0xFD 0x4E+<1:3> DIS 0xFD 0x23 0xFD 0x46+<1:3> DIS 0xFD 0x23
; ldi de,(iy+DIS)  =} 0xFD 0x4E+<1:3> DIS 0xFD 0x23 0xFD 0x46+<1:3> DIS 0xFD 0x23
; ldi hl,(iy+DIS)  =} 0xFD 0x4E+<1:3> DIS 0xFD 0x23 0xFD 0x46+<1:3> DIS 0xFD 0x23
;
; ld  (hl),bc    =}      0x71+<2> 0x23     0x70+<2> 0x2B
; ld  (hl),de    =}      0x71+<2> 0x23     0x70+<2> 0x2B
; ldi (hl),bc    =}      0x71+<2> 0x23     0x70+<2> 0x23
; ldi (hl),de    =}      0x71+<2> 0x23     0x70+<2> 0x23
;
; ld  (ix+DIS),bc  =} 0xDD 0x71+<2> DIS           0xDD 0x70+<2> DIS+1
; ld  (ix+DIS),de  =} 0xDD 0x71+<2> DIS           0xDD 0x70+<2> DIS+1
; ld  (ix+DIS),hl  =} 0xDD 0x71+<2> DIS           0xDD 0x70+<2> DIS+1
; ldi (ix+DIS),bc  =} 0xDD 0x71+<2> DIS 0xDD 0x23 0xDD 0x70+<2> DIS 0xDD 0x23
; ldi (ix+DIS),de  =} 0xDD 0x71+<2> DIS 0xDD 0x23 0xDD 0x70+<2> DIS 0xDD 0x23
; ldi (ix+DIS),hl  =} 0xDD 0x71+<2> DIS 0xDD 0x23 0xDD 0x70+<2> DIS 0xDD 0x23
;
; ld  (iy+DIS),bc  =} 0xFD 0x71+<2> DIS 0xFD 0x70+<2> DIS+1
; ld  (iy+DIS),de  =} 0xFD 0x71+<2> DIS 0xFD 0x70+<2> DIS+1
; ld  (iy+DIS),hl  =} 0xFD 0x71+<2> DIS 0xFD 0x70+<2> DIS+1
; ldi (iy+DIS),bc  =} 0xFD 0x71+<2> DIS 0xFD 0x23 0xFD 0x70+<2> DIS 0xFD 0x23
; ldi (iy+DIS),de  =} 0xFD 0x71+<2> DIS 0xFD 0x23 0xFD 0x70+<2> DIS 0xFD 0x23
; ldi (iy+DIS),hl  =} 0xFD 0x71+<2> DIS 0xFD 0x23 0xFD 0x70+<2> DIS 0xFD 0x23
;
; ld  hl,ix      =} 0xDD 0xE5 0xE1
; ld  hl,iy      =} 0xFD 0xE5 0xE1
;
; ld ix,bc    =} 0xDD 0x69+<2>       0xDD 0x60+<2>
; ld ix,de    =} 0xDD 0x69+<2>       0xDD 0x60+<2>
; ld iy,bc    =} 0xFD 0x69+<2>       0xFD 0x60+<2>
; ld iy,de    =} 0xFD 0x69+<2>       0xFD 0x60+<2>
;
; ld ix,hl      =} 0xE5 0xDD 0xE1
; ld iy,hl      =} 0xE5 0xFD 0xE1
;
; ld ix,ix      =} 0xDD 0x6D 0xDD 0x64
; ld ix,iy      =} 0xFD 0xE5 0xDD 0xE1
;
; ld iy,iy      =} 0xFD 0x6D 0xFD 0x64
; ld iy,ix      =} 0xDD 0xE5 0xFD 0xE1

;------------------------------------------------------------------------------
; Exchange, block transfer, search group
;------------------------------------------------------------------------------

        ex   de,hl                      ;; EB
        ex   af,af                      ;; 08
        ex   af,af'                     ;; 08
        exx                             ;; D9

IF      !RABBIT
        ex   (sp),hl                    ;; E3
ELSE    
        ex   (sp),hl
ENDIF   
        ex   (sp),ix                    ;; DD E3
        ex   (sp),iy                    ;; FD E3

        ldi                             ;; ED A0
        ldir                            ;; ED B0
        ldd                             ;; ED A8
        lddr                            ;; ED B8

IF      !RABBIT
        cpi                             ;; ED A1
        cpir                            ;; ED B1
        cpd                             ;; ED A9
        cpdr                            ;; ED B9
ELSE    
        cpi
        cpir
        cpd
        cpdr
ENDIF   

;------------------------------------------------------------------------------
; 8 bit arithmetic and logical group
;------------------------------------------------------------------------------

        add  a,b                        ;; 80
        adc  a,b                        ;; 88
        sbc  a,b                        ;; 98
        add  a,c                        ;; 81
        adc  a,c                        ;; 89
        sbc  a,c                        ;; 99
        add  a,d                        ;; 82
        adc  a,d                        ;; 8A
        sbc  a,d                        ;; 9A
        add  a,e                        ;; 83
        adc  a,e                        ;; 8B
        sbc  a,e                        ;; 9B
        add  a,h                        ;; 84
        adc  a,h                        ;; 8C
        sbc  a,h                        ;; 9C
        add  a,l                        ;; 85
        adc  a,l                        ;; 8D
        sbc  a,l                        ;; 9D
        add  a,a                        ;; 87
        adc  a,a                        ;; 8F
        sbc  a,a                        ;; 9F
        add  a,(hl)                     ;; 86
        adc  a,(hl)                     ;; 8E
        sbc  a,(hl)                     ;; 9E
        add  a,(ix+DIS)                 ;; DD 86 40
        adc  a,(ix+DIS)                 ;; DD 8E 40
        sbc  a,(ix+DIS)                 ;; DD 9E 40
        add  a,(iy+DIS)                 ;; FD 86 40
        adc  a,(iy+DIS)                 ;; FD 8E 40
        sbc  a,(iy+DIS)                 ;; FD 9E 40
        add  a,N                        ;; C6 20
        adc  a,N                        ;; CE 20
        sbc  a,N                        ;; DE 20
        add  b                          ;; 80
        adc  b                          ;; 88
        sbc  b                          ;; 98
        add  c                          ;; 81
        adc  c                          ;; 89
        sbc  c                          ;; 99
        add  d                          ;; 82
        adc  d                          ;; 8A
        sbc  d                          ;; 9A
        add  e                          ;; 83
        adc  e                          ;; 8B
        sbc  e                          ;; 9B
        add  h                          ;; 84
        adc  h                          ;; 8C
        sbc  h                          ;; 9C
        add  l                          ;; 85
        adc  l                          ;; 8D
        sbc  l                          ;; 9D
        add  a                          ;; 87
        adc  a                          ;; 8F
        sbc  a                          ;; 9F
        add  (hl)                       ;; 86
        adc  (hl)                       ;; 8E
        sbc  (hl)                       ;; 9E
        add  (ix+DIS)                   ;; DD 86 40
        adc  (ix+DIS)                   ;; DD 8E 40
        sbc  (ix+DIS)                   ;; DD 9E 40
        add  (iy+DIS)                   ;; FD 86 40
        adc  (iy+DIS)                   ;; FD 8E 40
        sbc  (iy+DIS)                   ;; FD 9E 40
        add  N                          ;; C6 20
        adc  N                          ;; CE 20
        sbc  N                          ;; DE 20

        sub  b                          ;; 90
        and  b                          ;; A0
        xor  b                          ;; A8
        or   b                          ;; B0
        cp   b                          ;; B8
        sub  c                          ;; 91
        and  c                          ;; A1
        xor  c                          ;; A9
        or   c                          ;; B1
        cp   c                          ;; B9
        sub  d                          ;; 92
        and  d                          ;; A2
        xor  d                          ;; AA
        or   d                          ;; B2
        cp   d                          ;; BA
        sub  e                          ;; 93
        and  e                          ;; A3
        xor  e                          ;; AB
        or   e                          ;; B3
        cp   e                          ;; BB
        sub  h                          ;; 94
        and  h                          ;; A4
        xor  h                          ;; AC
        or   h                          ;; B4
        cp   h                          ;; BC
        sub  l                          ;; 95
        and  l                          ;; A5
        xor  l                          ;; AD
        or   l                          ;; B5
        cp   l                          ;; BD
        sub  a                          ;; 97
        and  a                          ;; A7
        xor  a                          ;; AF
        or   a                          ;; B7
        cp   a                          ;; BF
        sub  (hl)                       ;; 96
        and  (hl)                       ;; A6
        xor  (hl)                       ;; AE
        or   (hl)                       ;; B6
        cp   (hl)                       ;; BE
        sub  (ix+DIS)                   ;; DD 96 40
        and  (ix+DIS)                   ;; DD A6 40
        xor  (ix+DIS)                   ;; DD AE 40
        or   (ix+DIS)                   ;; DD B6 40
        cp   (ix+DIS)                   ;; DD BE 40
        sub  (iy+DIS)                   ;; FD 96 40
        and  (iy+DIS)                   ;; FD A6 40
        xor  (iy+DIS)                   ;; FD AE 40
        or   (iy+DIS)                   ;; FD B6 40
        cp   (iy+DIS)                   ;; FD BE 40
        sub  N                          ;; D6 20
        and  N                          ;; E6 20
        xor  N                          ;; EE 20
        or   N                          ;; F6 20
        cp   N                          ;; FE 20
        sub  a,b                        ;; 90
        and  a,b                        ;; A0
        xor  a,b                        ;; A8
        or   a,b                        ;; B0
        cp   a,b                        ;; B8
        sub  a,c                        ;; 91
        and  a,c                        ;; A1
        xor  a,c                        ;; A9
        or   a,c                        ;; B1
        cp   a,c                        ;; B9
        sub  a,d                        ;; 92
        and  a,d                        ;; A2
        xor  a,d                        ;; AA
        or   a,d                        ;; B2
        cp   a,d                        ;; BA
        sub  a,e                        ;; 93
        and  a,e                        ;; A3
        xor  a,e                        ;; AB
        or   a,e                        ;; B3
        cp   a,e                        ;; BB
        sub  a,h                        ;; 94
        and  a,h                        ;; A4
        xor  a,h                        ;; AC
        or   a,h                        ;; B4
        cp   a,h                        ;; BC
        sub  a,l                        ;; 95
        and  a,l                        ;; A5
        xor  a,l                        ;; AD
        or   a,l                        ;; B5
        cp   a,l                        ;; BD
        sub  a,a                        ;; 97
        and  a,a                        ;; A7
        xor  a,a                        ;; AF
        or   a,a                        ;; B7
        cp   a,a                        ;; BF
        sub  a,(hl)                     ;; 96
        and  a,(hl)                     ;; A6
        xor  a,(hl)                     ;; AE
        or   a,(hl)                     ;; B6
        cp   a,(hl)                     ;; BE
        sub  a,(ix+DIS)                 ;; DD 96 40
        and  a,(ix+DIS)                 ;; DD A6 40
        xor  a,(ix+DIS)                 ;; DD AE 40
        or   a,(ix+DIS)                 ;; DD B6 40
        cp   a,(ix+DIS)                 ;; DD BE 40
        sub  a,(iy+DIS)                 ;; FD 96 40
        and  a,(iy+DIS)                 ;; FD A6 40
        xor  a,(iy+DIS)                 ;; FD AE 40
        or   a,(iy+DIS)                 ;; FD B6 40
        cp   a,(iy+DIS)                 ;; FD BE 40
        sub  a,N                        ;; D6 20
        and  a,N                        ;; E6 20
        xor  a,N                        ;; EE 20
        or   a,N                        ;; F6 20
        cp   a,N                        ;; FE 20

        inc  b                          ;; 04
        dec  b                          ;; 05
        inc  c                          ;; 0C
        dec  c                          ;; 0D
        inc  d                          ;; 14
        dec  d                          ;; 15
        inc  e                          ;; 1C
        dec  e                          ;; 1D
        inc  h                          ;; 24
        dec  h                          ;; 25
        inc  l                          ;; 2C
        dec  l                          ;; 2D
        inc  a                          ;; 3C
        dec  a                          ;; 3D
        inc  (hl)                       ;; 34
        dec  (hl)                       ;; 35
        inc  (ix+DIS)                   ;; DD 34 40
        dec  (ix+DIS)                   ;; DD 35 40
        inc  (iy+DIS)                   ;; FD 34 40
        dec  (iy+DIS)                   ;; FD 35 40

IF      !RABBIT
        add  a,ixh                      ;; DD 84
        adc  a,ixh                      ;; DD 8C
        sbc  a,ixh                      ;; DD 9C
        add  a,iyh                      ;; FD 84
        adc  a,iyh                      ;; FD 8C
        sbc  a,iyh                      ;; FD 9C
        add  a,ixl                      ;; DD 85
        adc  a,ixl                      ;; DD 8D
        sbc  a,ixl                      ;; DD 9D
        add  a,iyl                      ;; FD 85
        adc  a,iyl                      ;; FD 8D
        sbc  a,iyl                      ;; FD 9D
        add  ixh                        ;; DD 84
        adc  ixh                        ;; DD 8C
        sbc  ixh                        ;; DD 9C
        add  iyh                        ;; FD 84
        adc  iyh                        ;; FD 8C
        sbc  iyh                        ;; FD 9C
        add  ixl                        ;; DD 85
        adc  ixl                        ;; DD 8D
        sbc  ixl                        ;; DD 9D
        add  iyl                        ;; FD 85
        adc  iyl                        ;; FD 8D
        sbc  iyl                        ;; FD 9D
        sub  ixh                        ;; DD 94
        and  ixh                        ;; DD A4
        xor  ixh                        ;; DD AC
        or   ixh                        ;; DD B4
        cp   ixh                        ;; DD BC
        sub  iyh                        ;; FD 94
        and  iyh                        ;; FD A4
        xor  iyh                        ;; FD AC
        or   iyh                        ;; FD B4
        cp   iyh                        ;; FD BC
        sub  ixl                        ;; DD 95
        and  ixl                        ;; DD A5
        xor  ixl                        ;; DD AD
        or   ixl                        ;; DD B5
        cp   ixl                        ;; DD BD
        sub  iyl                        ;; FD 95
        and  iyl                        ;; FD A5
        xor  iyl                        ;; FD AD
        or   iyl                        ;; FD B5
        cp   iyl                        ;; FD BD
        sub  a,ixh                      ;; DD 94
        and  a,ixh                      ;; DD A4
        xor  a,ixh                      ;; DD AC
        or   a,ixh                      ;; DD B4
        cp   a,ixh                      ;; DD BC
        sub  a,iyh                      ;; FD 94
        and  a,iyh                      ;; FD A4
        xor  a,iyh                      ;; FD AC
        or   a,iyh                      ;; FD B4
        cp   a,iyh                      ;; FD BC
        sub  a,ixl                      ;; DD 95
        and  a,ixl                      ;; DD A5
        xor  a,ixl                      ;; DD AD
        or   a,ixl                      ;; DD B5
        cp   a,ixl                      ;; DD BD
        sub  a,iyl                      ;; FD 95
        and  a,iyl                      ;; FD A5
        xor  a,iyl                      ;; FD AD
        or   a,iyl                      ;; FD B5
        cp   a,iyl                      ;; FD BD
        inc  ixh                        ;; DD 24
        dec  ixh                        ;; DD 25
        inc  iyh                        ;; FD 24
        dec  iyh                        ;; FD 25
        inc  ixl                        ;; DD 2C
        dec  ixl                        ;; DD 2D
        inc  iyl                        ;; FD 2C
        dec  iyl                        ;; FD 2D
ELSE    
        add  a,ixh
        adc  a,ixh
        sbc  a,ixh
        add  a,iyh
        adc  a,iyh
        sbc  a,iyh
        add  a,ixl
        adc  a,ixl
        sbc  a,ixl
        add  a,iyl
        adc  a,iyl
        sbc  a,iyl
        add  ixh
        adc  ixh
        sbc  ixh
        add  iyh
        adc  iyh
        sbc  iyh
        add  ixl
        adc  ixl
        sbc  ixl
        add  iyl
        adc  iyl
        sbc  iyl
        sub  ixh
        and  ixh
        xor  ixh
        or   ixh
        cp   ixh
        sub  iyh
        and  iyh
        xor  iyh
        or   iyh
        cp   iyh
        sub  ixl
        and  ixl
        xor  ixl
        or   ixl
        cp   ixl
        sub  iyl
        and  iyl
        xor  iyl
        or   iyl
        cp   iyl
        sub  a,ixh
        and  a,ixh
        xor  a,ixh
        or   a,ixh
        cp   a,ixh
        sub  a,iyh
        and  a,iyh
        xor  a,iyh
        or   a,iyh
        cp   a,iyh
        sub  a,ixl
        and  a,ixl
        xor  a,ixl
        or   a,ixl
        cp   a,ixl
        sub  a,iyl
        and  a,iyl
        xor  a,iyl
        or   a,iyl
        cp   a,iyl
        inc  ixh
        dec  ixh
        inc  iyh
        dec  iyh
        inc  ixl
        dec  ixl
        inc  iyl
        dec  iyl
ENDIF   

;------------------------------------------------------------------------------
; 16 bit arithmetic and logical group
;------------------------------------------------------------------------------

        add  hl,bc                      ;; 09
        add  hl,de                      ;; 19
        add  hl,hl                      ;; 29
        add  hl,sp                      ;; 39
        add  ix,bc                      ;; DD 09
        add  ix,de                      ;; DD 19
        add  ix,ix                      ;; DD 29
        add  ix,sp                      ;; DD 39
        add  iy,bc                      ;; FD 09
        add  iy,de                      ;; FD 19
        add  iy,iy                      ;; FD 29
        add  iy,sp                      ;; FD 39

        sbc  hl,bc                      ;; ED 42
        adc  hl,bc                      ;; ED 4A
        sbc  hl,de                      ;; ED 52
        adc  hl,de                      ;; ED 5A
        sbc  hl,hl                      ;; ED 62
        adc  hl,hl                      ;; ED 6A
        sbc  hl,sp                      ;; ED 72
        adc  hl,sp                      ;; ED 7A
; sub       hl,bc      =} 0xB7 0xED 0x42+<2:4>
; sub       hl,de      =} 0xB7 0xED 0x42+<2:4>
; sub       hl,hl      =} 0xB7 0xED 0x42+<2:4>
; sub       hl,sp      =} 0xB7 0xED 0x42+<2:4>

        inc  bc                         ;; 03
        dec  bc                         ;; 0B
        inc  de                         ;; 13
        dec  de                         ;; 1B
        inc  hl                         ;; 23
        dec  hl                         ;; 2B
        inc  ix                         ;; DD 23
        dec  ix                         ;; DD 2B
        inc  iy                         ;; FD 23
        dec  iy                         ;; FD 2B
        inc  sp                         ;; 33
        dec  sp                         ;; 3B

;------------------------------------------------------------------------------
; rotate and shift group
;------------------------------------------------------------------------------

        rlca                            ;; 07
        rrca                            ;; 0F
        rla                             ;; 17
        rra                             ;; 1F

        rlc  b                          ;; CB 00
        rrc  b                          ;; CB 08
        rl   b                          ;; CB 10
        rr   b                          ;; CB 18
        sla  b                          ;; CB 20
        sra  b                          ;; CB 28
        srl  b                          ;; CB 38
        rlc  c                          ;; CB 01
        rrc  c                          ;; CB 09
        rl   c                          ;; CB 11
        rr   c                          ;; CB 19
        sla  c                          ;; CB 21
        sra  c                          ;; CB 29
        srl  c                          ;; CB 39
        rlc  d                          ;; CB 02
        rrc  d                          ;; CB 0A
        rl   d                          ;; CB 12
        rr   d                          ;; CB 1A
        sla  d                          ;; CB 22
        sra  d                          ;; CB 2A
        srl  d                          ;; CB 3A
        rlc  e                          ;; CB 03
        rrc  e                          ;; CB 0B
        rl   e                          ;; CB 13
        rr   e                          ;; CB 1B
        sla  e                          ;; CB 23
        sra  e                          ;; CB 2B
        srl  e                          ;; CB 3B
        rlc  h                          ;; CB 04
        rrc  h                          ;; CB 0C
        rl   h                          ;; CB 14
        rr   h                          ;; CB 1C
        sla  h                          ;; CB 24
        sra  h                          ;; CB 2C
        srl  h                          ;; CB 3C
        rlc  l                          ;; CB 05
        rrc  l                          ;; CB 0D
        rl   l                          ;; CB 15
        rr   l                          ;; CB 1D
        sla  l                          ;; CB 25
        sra  l                          ;; CB 2D
        srl  l                          ;; CB 3D
        rlc  a                          ;; CB 07
        rrc  a                          ;; CB 0F
        rl   a                          ;; CB 17
        rr   a                          ;; CB 1F
        sla  a                          ;; CB 27
        sra  a                          ;; CB 2F
        srl  a                          ;; CB 3F
        rlc  (hl)                       ;; CB 06
        rrc  (hl)                       ;; CB 0E
        rl   (hl)                       ;; CB 16
        rr   (hl)                       ;; CB 1E
        sla  (hl)                       ;; CB 26
        sra  (hl)                       ;; CB 2E
        srl  (hl)                       ;; CB 3E
        rlc  (ix+DIS)                   ;; DD CB 40 06
        rrc  (ix+DIS)                   ;; DD CB 40 0E
        rl   (ix+DIS)                   ;; DD CB 40 16
        rr   (ix+DIS)                   ;; DD CB 40 1E
        sla  (ix+DIS)                   ;; DD CB 40 26
        sra  (ix+DIS)                   ;; DD CB 40 2E
        srl  (ix+DIS)                   ;; DD CB 40 3E
        rlc  (iy+DIS)                   ;; FD CB 40 06
        rrc  (iy+DIS)                   ;; FD CB 40 0E
        rl   (iy+DIS)                   ;; FD CB 40 16
        rr   (iy+DIS)                   ;; FD CB 40 1E
        sla  (iy+DIS)                   ;; FD CB 40 26
        sra  (iy+DIS)                   ;; FD CB 40 2E
        srl  (iy+DIS)                   ;; FD CB 40 3E
; rlc (ix+DIS),b =} 0xDD 0xCB DIS 0x00+<0:3+<2
; rrc (ix+DIS),b =} 0xDD 0xCB DIS 0x00+<0:3+<2
; rl (ix+DIS),b =} 0xDD 0xCB DIS 0x00+<0:3+<2
; rr (ix+DIS),b =} 0xDD 0xCB DIS 0x00+<0:3+<2
; sla (ix+DIS),b =} 0xDD 0xCB DIS 0x00+<0:3+<2
; sra (ix+DIS),b =} 0xDD 0xCB DIS 0x00+<0:3+<2
; srl (ix+DIS),b =} 0xDD 0xCB DIS 0x00+<0:3+<2
; rlc (ix+DIS),c =} 0xDD 0xCB DIS 0x00+<0:3+<2
; rrc (ix+DIS),c =} 0xDD 0xCB DIS 0x00+<0:3+<2
; rl (ix+DIS),c =} 0xDD 0xCB DIS 0x00+<0:3+<2
; rr (ix+DIS),c =} 0xDD 0xCB DIS 0x00+<0:3+<2
; sla (ix+DIS),c =} 0xDD 0xCB DIS 0x00+<0:3+<2
; sra (ix+DIS),c =} 0xDD 0xCB DIS 0x00+<0:3+<2
; srl (ix+DIS),c =} 0xDD 0xCB DIS 0x00+<0:3+<2
; rlc (ix+DIS),d =} 0xDD 0xCB DIS 0x00+<0:3+<2
; rrc (ix+DIS),d =} 0xDD 0xCB DIS 0x00+<0:3+<2
; rl (ix+DIS),d =} 0xDD 0xCB DIS 0x00+<0:3+<2
; rr (ix+DIS),d =} 0xDD 0xCB DIS 0x00+<0:3+<2
; sla (ix+DIS),d =} 0xDD 0xCB DIS 0x00+<0:3+<2
; sra (ix+DIS),d =} 0xDD 0xCB DIS 0x00+<0:3+<2
; srl (ix+DIS),d =} 0xDD 0xCB DIS 0x00+<0:3+<2
; rlc (ix+DIS),e =} 0xDD 0xCB DIS 0x00+<0:3+<2
; rrc (ix+DIS),e =} 0xDD 0xCB DIS 0x00+<0:3+<2
; rl (ix+DIS),e =} 0xDD 0xCB DIS 0x00+<0:3+<2
; rr (ix+DIS),e =} 0xDD 0xCB DIS 0x00+<0:3+<2
; sla (ix+DIS),e =} 0xDD 0xCB DIS 0x00+<0:3+<2
; sra (ix+DIS),e =} 0xDD 0xCB DIS 0x00+<0:3+<2
; srl (ix+DIS),e =} 0xDD 0xCB DIS 0x00+<0:3+<2
; rlc (ix+DIS),h =} 0xDD 0xCB DIS 0x00+<0:3+<2
; rrc (ix+DIS),h =} 0xDD 0xCB DIS 0x00+<0:3+<2
; rl (ix+DIS),h =} 0xDD 0xCB DIS 0x00+<0:3+<2
; rr (ix+DIS),h =} 0xDD 0xCB DIS 0x00+<0:3+<2
; sla (ix+DIS),h =} 0xDD 0xCB DIS 0x00+<0:3+<2
; sra (ix+DIS),h =} 0xDD 0xCB DIS 0x00+<0:3+<2
; srl (ix+DIS),h =} 0xDD 0xCB DIS 0x00+<0:3+<2
; rlc (ix+DIS),l =} 0xDD 0xCB DIS 0x00+<0:3+<2
; rrc (ix+DIS),l =} 0xDD 0xCB DIS 0x00+<0:3+<2
; rl (ix+DIS),l =} 0xDD 0xCB DIS 0x00+<0:3+<2
; rr (ix+DIS),l =} 0xDD 0xCB DIS 0x00+<0:3+<2
; sla (ix+DIS),l =} 0xDD 0xCB DIS 0x00+<0:3+<2
; sra (ix+DIS),l =} 0xDD 0xCB DIS 0x00+<0:3+<2
; srl (ix+DIS),l =} 0xDD 0xCB DIS 0x00+<0:3+<2
; rlc (ix+DIS),a =} 0xDD 0xCB DIS 0x00+<0:3+<2
; rrc (ix+DIS),a =} 0xDD 0xCB DIS 0x00+<0:3+<2
; rl (ix+DIS),a =} 0xDD 0xCB DIS 0x00+<0:3+<2
; rr (ix+DIS),a =} 0xDD 0xCB DIS 0x00+<0:3+<2
; sla (ix+DIS),a =} 0xDD 0xCB DIS 0x00+<0:3+<2
; sra (ix+DIS),a =} 0xDD 0xCB DIS 0x00+<0:3+<2
; srl (ix+DIS),a =} 0xDD 0xCB DIS 0x00+<0:3+<2
; rlc (iy+DIS),b =} 0xFD 0xCB DIS 0x00+<0:3+<2
; rrc (iy+DIS),b =} 0xFD 0xCB DIS 0x00+<0:3+<2
; rl (iy+DIS),b =} 0xFD 0xCB DIS 0x00+<0:3+<2
; rr (iy+DIS),b =} 0xFD 0xCB DIS 0x00+<0:3+<2
; sla (iy+DIS),b =} 0xFD 0xCB DIS 0x00+<0:3+<2
; sra (iy+DIS),b =} 0xFD 0xCB DIS 0x00+<0:3+<2
; srl (iy+DIS),b =} 0xFD 0xCB DIS 0x00+<0:3+<2
; rlc (iy+DIS),c =} 0xFD 0xCB DIS 0x00+<0:3+<2
; rrc (iy+DIS),c =} 0xFD 0xCB DIS 0x00+<0:3+<2
; rl (iy+DIS),c =} 0xFD 0xCB DIS 0x00+<0:3+<2
; rr (iy+DIS),c =} 0xFD 0xCB DIS 0x00+<0:3+<2
; sla (iy+DIS),c =} 0xFD 0xCB DIS 0x00+<0:3+<2
; sra (iy+DIS),c =} 0xFD 0xCB DIS 0x00+<0:3+<2
; srl (iy+DIS),c =} 0xFD 0xCB DIS 0x00+<0:3+<2
; rlc (iy+DIS),d =} 0xFD 0xCB DIS 0x00+<0:3+<2
; rrc (iy+DIS),d =} 0xFD 0xCB DIS 0x00+<0:3+<2
; rl (iy+DIS),d =} 0xFD 0xCB DIS 0x00+<0:3+<2
; rr (iy+DIS),d =} 0xFD 0xCB DIS 0x00+<0:3+<2
; sla (iy+DIS),d =} 0xFD 0xCB DIS 0x00+<0:3+<2
; sra (iy+DIS),d =} 0xFD 0xCB DIS 0x00+<0:3+<2
; srl (iy+DIS),d =} 0xFD 0xCB DIS 0x00+<0:3+<2
; rlc (iy+DIS),e =} 0xFD 0xCB DIS 0x00+<0:3+<2
; rrc (iy+DIS),e =} 0xFD 0xCB DIS 0x00+<0:3+<2
; rl (iy+DIS),e =} 0xFD 0xCB DIS 0x00+<0:3+<2
; rr (iy+DIS),e =} 0xFD 0xCB DIS 0x00+<0:3+<2
; sla (iy+DIS),e =} 0xFD 0xCB DIS 0x00+<0:3+<2
; sra (iy+DIS),e =} 0xFD 0xCB DIS 0x00+<0:3+<2
; srl (iy+DIS),e =} 0xFD 0xCB DIS 0x00+<0:3+<2
; rlc (iy+DIS),h =} 0xFD 0xCB DIS 0x00+<0:3+<2
; rrc (iy+DIS),h =} 0xFD 0xCB DIS 0x00+<0:3+<2
; rl (iy+DIS),h =} 0xFD 0xCB DIS 0x00+<0:3+<2
; rr (iy+DIS),h =} 0xFD 0xCB DIS 0x00+<0:3+<2
; sla (iy+DIS),h =} 0xFD 0xCB DIS 0x00+<0:3+<2
; sra (iy+DIS),h =} 0xFD 0xCB DIS 0x00+<0:3+<2
; srl (iy+DIS),h =} 0xFD 0xCB DIS 0x00+<0:3+<2
; rlc (iy+DIS),l =} 0xFD 0xCB DIS 0x00+<0:3+<2
; rrc (iy+DIS),l =} 0xFD 0xCB DIS 0x00+<0:3+<2
; rl (iy+DIS),l =} 0xFD 0xCB DIS 0x00+<0:3+<2
; rr (iy+DIS),l =} 0xFD 0xCB DIS 0x00+<0:3+<2
; sla (iy+DIS),l =} 0xFD 0xCB DIS 0x00+<0:3+<2
; sra (iy+DIS),l =} 0xFD 0xCB DIS 0x00+<0:3+<2
; srl (iy+DIS),l =} 0xFD 0xCB DIS 0x00+<0:3+<2
; rlc (iy+DIS),a =} 0xFD 0xCB DIS 0x00+<0:3+<2
; rrc (iy+DIS),a =} 0xFD 0xCB DIS 0x00+<0:3+<2
; rl (iy+DIS),a =} 0xFD 0xCB DIS 0x00+<0:3+<2
; rr (iy+DIS),a =} 0xFD 0xCB DIS 0x00+<0:3+<2
; sla (iy+DIS),a =} 0xFD 0xCB DIS 0x00+<0:3+<2
; sra (iy+DIS),a =} 0xFD 0xCB DIS 0x00+<0:3+<2
; srl (iy+DIS),a =} 0xFD 0xCB DIS 0x00+<0:3+<2
; sll ...
; sli ...

IF      !RABBIT
        rld                             ;; ED 6F
        rrd                             ;; ED 67
ELSE    
        rld
        rrd
ENDIF   

; # rotate 16 bits
;
; rl bc     =} 0xCB 0x11+<1 0xCB 0x10+<1
; rl de     =} 0xCB 0x11+<1 0xCB 0x10+<1
; rl hl     =} 0xCB 0x11+<1 0xCB 0x10+<1
; rr bc     =} 0xCB 0x18+<1 0xCB 0x19+<1
; rr de     =} 0xCB 0x18+<1 0xCB 0x19+<1
; rr hl     =} 0xCB 0x18+<1 0xCB 0x19+<1
;
; sla hl       =} 0x29   # special case: add hl,hl
; sla bc    =} 0xCB 0x21+<1 0xCB 0x10+<1
; sla de    =} 0xCB 0x21+<1 0xCB 0x10+<1
; sla hl    =} 0xCB 0x21+<1 0xCB 0x10+<1
; sll bc    =} 0xCB 0x31+<1 0xCB 0x10+<1
; sll de    =} 0xCB 0x31+<1 0xCB 0x10+<1
; sll hl    =} 0xCB 0x31+<1 0xCB 0x10+<1
; sli bc    =} 0xCB 0x31+<1 0xCB 0x10+<1
; sli de    =} 0xCB 0x31+<1 0xCB 0x10+<1
; sli hl    =} 0xCB 0x31+<1 0xCB 0x10+<1
;
; sra bc    =} 0xCB 0x28+<1 0xCB 0x19+<1
; sra de    =} 0xCB 0x28+<1 0xCB 0x19+<1
; sra hl    =} 0xCB 0x28+<1 0xCB 0x19+<1
; srl bc    =} 0xCB 0x38+<1 0xCB 0x19+<1
; srl de    =} 0xCB 0x38+<1 0xCB 0x19+<1
; srl hl    =} 0xCB 0x38+<1 0xCB 0x19+<1

;------------------------------------------------------------------------------
; General purpose arithmetic and CPU control group
;------------------------------------------------------------------------------

        cpl                             ;; 2F
        neg                             ;; ED 44
        ccf                             ;; 3F
        scf                             ;; 37
        nop                             ;; 00

IF      !RABBIT
        daa                             ;; 27
        di                              ;; F3
        ei                              ;; FB
        halt                            ;; 76

        im   0                          ;; ED 46
        im   1                          ;; ED 56
        im   2                          ;; ED 5E

ELSE    
        daa
        di
        ei
        halt
        im   0
        im   1
        im   2
ENDIF   

;------------------------------------------------------------------------------
; Bit Set, Reset and Test Group
;------------------------------------------------------------------------------

        bit  0,b                        ;; CB 40
        res  0,b                        ;; CB 80
        set  0,b                        ;; CB C0
        bit  1,b                        ;; CB 48
        res  1,b                        ;; CB 88
        set  1,b                        ;; CB C8
        bit  2,b                        ;; CB 50
        res  2,b                        ;; CB 90
        set  2,b                        ;; CB D0
        bit  3,b                        ;; CB 58
        res  3,b                        ;; CB 98
        set  3,b                        ;; CB D8
        bit  4,b                        ;; CB 60
        res  4,b                        ;; CB A0
        set  4,b                        ;; CB E0
        bit  5,b                        ;; CB 68
        res  5,b                        ;; CB A8
        set  5,b                        ;; CB E8
        bit  6,b                        ;; CB 70
        res  6,b                        ;; CB B0
        set  6,b                        ;; CB F0
        bit  7,b                        ;; CB 78
        res  7,b                        ;; CB B8
        set  7,b                        ;; CB F8
        bit  0,c                        ;; CB 41
        res  0,c                        ;; CB 81
        set  0,c                        ;; CB C1
        bit  1,c                        ;; CB 49
        res  1,c                        ;; CB 89
        set  1,c                        ;; CB C9
        bit  2,c                        ;; CB 51
        res  2,c                        ;; CB 91
        set  2,c                        ;; CB D1
        bit  3,c                        ;; CB 59
        res  3,c                        ;; CB 99
        set  3,c                        ;; CB D9
        bit  4,c                        ;; CB 61
        res  4,c                        ;; CB A1
        set  4,c                        ;; CB E1
        bit  5,c                        ;; CB 69
        res  5,c                        ;; CB A9
        set  5,c                        ;; CB E9
        bit  6,c                        ;; CB 71
        res  6,c                        ;; CB B1
        set  6,c                        ;; CB F1
        bit  7,c                        ;; CB 79
        res  7,c                        ;; CB B9
        set  7,c                        ;; CB F9
        bit  0,d                        ;; CB 42
        res  0,d                        ;; CB 82
        set  0,d                        ;; CB C2
        bit  1,d                        ;; CB 4A
        res  1,d                        ;; CB 8A
        set  1,d                        ;; CB CA
        bit  2,d                        ;; CB 52
        res  2,d                        ;; CB 92
        set  2,d                        ;; CB D2
        bit  3,d                        ;; CB 5A
        res  3,d                        ;; CB 9A
        set  3,d                        ;; CB DA
        bit  4,d                        ;; CB 62
        res  4,d                        ;; CB A2
        set  4,d                        ;; CB E2
        bit  5,d                        ;; CB 6A
        res  5,d                        ;; CB AA
        set  5,d                        ;; CB EA
        bit  6,d                        ;; CB 72
        res  6,d                        ;; CB B2
        set  6,d                        ;; CB F2
        bit  7,d                        ;; CB 7A
        res  7,d                        ;; CB BA
        set  7,d                        ;; CB FA
        bit  0,e                        ;; CB 43
        res  0,e                        ;; CB 83
        set  0,e                        ;; CB C3
        bit  1,e                        ;; CB 4B
        res  1,e                        ;; CB 8B
        set  1,e                        ;; CB CB
        bit  2,e                        ;; CB 53
        res  2,e                        ;; CB 93
        set  2,e                        ;; CB D3
        bit  3,e                        ;; CB 5B
        res  3,e                        ;; CB 9B
        set  3,e                        ;; CB DB
        bit  4,e                        ;; CB 63
        res  4,e                        ;; CB A3
        set  4,e                        ;; CB E3
        bit  5,e                        ;; CB 6B
        res  5,e                        ;; CB AB
        set  5,e                        ;; CB EB
        bit  6,e                        ;; CB 73
        res  6,e                        ;; CB B3
        set  6,e                        ;; CB F3
        bit  7,e                        ;; CB 7B
        res  7,e                        ;; CB BB
        set  7,e                        ;; CB FB
        bit  0,h                        ;; CB 44
        res  0,h                        ;; CB 84
        set  0,h                        ;; CB C4
        bit  1,h                        ;; CB 4C
        res  1,h                        ;; CB 8C
        set  1,h                        ;; CB CC
        bit  2,h                        ;; CB 54
        res  2,h                        ;; CB 94
        set  2,h                        ;; CB D4
        bit  3,h                        ;; CB 5C
        res  3,h                        ;; CB 9C
        set  3,h                        ;; CB DC
        bit  4,h                        ;; CB 64
        res  4,h                        ;; CB A4
        set  4,h                        ;; CB E4
        bit  5,h                        ;; CB 6C
        res  5,h                        ;; CB AC
        set  5,h                        ;; CB EC
        bit  6,h                        ;; CB 74
        res  6,h                        ;; CB B4
        set  6,h                        ;; CB F4
        bit  7,h                        ;; CB 7C
        res  7,h                        ;; CB BC
        set  7,h                        ;; CB FC
        bit  0,l                        ;; CB 45
        res  0,l                        ;; CB 85
        set  0,l                        ;; CB C5
        bit  1,l                        ;; CB 4D
        res  1,l                        ;; CB 8D
        set  1,l                        ;; CB CD
        bit  2,l                        ;; CB 55
        res  2,l                        ;; CB 95
        set  2,l                        ;; CB D5
        bit  3,l                        ;; CB 5D
        res  3,l                        ;; CB 9D
        set  3,l                        ;; CB DD
        bit  4,l                        ;; CB 65
        res  4,l                        ;; CB A5
        set  4,l                        ;; CB E5
        bit  5,l                        ;; CB 6D
        res  5,l                        ;; CB AD
        set  5,l                        ;; CB ED
        bit  6,l                        ;; CB 75
        res  6,l                        ;; CB B5
        set  6,l                        ;; CB F5
        bit  7,l                        ;; CB 7D
        res  7,l                        ;; CB BD
        set  7,l                        ;; CB FD
        bit  0,a                        ;; CB 47
        res  0,a                        ;; CB 87
        set  0,a                        ;; CB C7
        bit  1,a                        ;; CB 4F
        res  1,a                        ;; CB 8F
        set  1,a                        ;; CB CF
        bit  2,a                        ;; CB 57
        res  2,a                        ;; CB 97
        set  2,a                        ;; CB D7
        bit  3,a                        ;; CB 5F
        res  3,a                        ;; CB 9F
        set  3,a                        ;; CB DF
        bit  4,a                        ;; CB 67
        res  4,a                        ;; CB A7
        set  4,a                        ;; CB E7
        bit  5,a                        ;; CB 6F
        res  5,a                        ;; CB AF
        set  5,a                        ;; CB EF
        bit  6,a                        ;; CB 77
        res  6,a                        ;; CB B7
        set  6,a                        ;; CB F7
        bit  7,a                        ;; CB 7F
        res  7,a                        ;; CB BF
        set  7,a                        ;; CB FF
        bit  0,(hl)                     ;; CB 46
        res  0,(hl)                     ;; CB 86
        set  0,(hl)                     ;; CB C6
        bit  1,(hl)                     ;; CB 4E
        res  1,(hl)                     ;; CB 8E
        set  1,(hl)                     ;; CB CE
        bit  2,(hl)                     ;; CB 56
        res  2,(hl)                     ;; CB 96
        set  2,(hl)                     ;; CB D6
        bit  3,(hl)                     ;; CB 5E
        res  3,(hl)                     ;; CB 9E
        set  3,(hl)                     ;; CB DE
        bit  4,(hl)                     ;; CB 66
        res  4,(hl)                     ;; CB A6
        set  4,(hl)                     ;; CB E6
        bit  5,(hl)                     ;; CB 6E
        res  5,(hl)                     ;; CB AE
        set  5,(hl)                     ;; CB EE
        bit  6,(hl)                     ;; CB 76
        res  6,(hl)                     ;; CB B6
        set  6,(hl)                     ;; CB F6
        bit  7,(hl)                     ;; CB 7E
        res  7,(hl)                     ;; CB BE
        set  7,(hl)                     ;; CB FE
        bit  0,(ix+DIS)                 ;; DD CB 40 46
        res  0,(ix+DIS)                 ;; DD CB 40 86
        set  0,(ix+DIS)                 ;; DD CB 40 C6
        bit  1,(ix+DIS)                 ;; DD CB 40 4E
        res  1,(ix+DIS)                 ;; DD CB 40 8E
        set  1,(ix+DIS)                 ;; DD CB 40 CE
        bit  2,(ix+DIS)                 ;; DD CB 40 56
        res  2,(ix+DIS)                 ;; DD CB 40 96
        set  2,(ix+DIS)                 ;; DD CB 40 D6
        bit  3,(ix+DIS)                 ;; DD CB 40 5E
        res  3,(ix+DIS)                 ;; DD CB 40 9E
        set  3,(ix+DIS)                 ;; DD CB 40 DE
        bit  4,(ix+DIS)                 ;; DD CB 40 66
        res  4,(ix+DIS)                 ;; DD CB 40 A6
        set  4,(ix+DIS)                 ;; DD CB 40 E6
        bit  5,(ix+DIS)                 ;; DD CB 40 6E
        res  5,(ix+DIS)                 ;; DD CB 40 AE
        set  5,(ix+DIS)                 ;; DD CB 40 EE
        bit  6,(ix+DIS)                 ;; DD CB 40 76
        res  6,(ix+DIS)                 ;; DD CB 40 B6
        set  6,(ix+DIS)                 ;; DD CB 40 F6
        bit  7,(ix+DIS)                 ;; DD CB 40 7E
        res  7,(ix+DIS)                 ;; DD CB 40 BE
        set  7,(ix+DIS)                 ;; DD CB 40 FE
        bit  0,(iy+DIS)                 ;; FD CB 40 46
        res  0,(iy+DIS)                 ;; FD CB 40 86
        set  0,(iy+DIS)                 ;; FD CB 40 C6
        bit  1,(iy+DIS)                 ;; FD CB 40 4E
        res  1,(iy+DIS)                 ;; FD CB 40 8E
        set  1,(iy+DIS)                 ;; FD CB 40 CE
        bit  2,(iy+DIS)                 ;; FD CB 40 56
        res  2,(iy+DIS)                 ;; FD CB 40 96
        set  2,(iy+DIS)                 ;; FD CB 40 D6
        bit  3,(iy+DIS)                 ;; FD CB 40 5E
        res  3,(iy+DIS)                 ;; FD CB 40 9E
        set  3,(iy+DIS)                 ;; FD CB 40 DE
        bit  4,(iy+DIS)                 ;; FD CB 40 66
        res  4,(iy+DIS)                 ;; FD CB 40 A6
        set  4,(iy+DIS)                 ;; FD CB 40 E6
        bit  5,(iy+DIS)                 ;; FD CB 40 6E
        res  5,(iy+DIS)                 ;; FD CB 40 AE
        set  5,(iy+DIS)                 ;; FD CB 40 EE
        bit  6,(iy+DIS)                 ;; FD CB 40 76
        res  6,(iy+DIS)                 ;; FD CB 40 B6
        set  6,(iy+DIS)                 ;; FD CB 40 F6
        bit  7,(iy+DIS)                 ;; FD CB 40 7E
        res  7,(iy+DIS)                 ;; FD CB 40 BE
        set  7,(iy+DIS)                 ;; FD CB 40 FE


; res     0,(ix+DIS),b =} 0xDD 0xCB DIS <0:6+<1:3+<3
; set     0,(ix+DIS),b =} 0xDD 0xCB DIS <0:6+<1:3+<3
; res     1,(ix+DIS),b =} 0xDD 0xCB DIS <0:6+<1:3+<3
; set     1,(ix+DIS),b =} 0xDD 0xCB DIS <0:6+<1:3+<3
; res     2,(ix+DIS),b =} 0xDD 0xCB DIS <0:6+<1:3+<3
; set     2,(ix+DIS),b =} 0xDD 0xCB DIS <0:6+<1:3+<3
; res     3,(ix+DIS),b =} 0xDD 0xCB DIS <0:6+<1:3+<3
; set     3,(ix+DIS),b =} 0xDD 0xCB DIS <0:6+<1:3+<3
; res     4,(ix+DIS),b =} 0xDD 0xCB DIS <0:6+<1:3+<3
; set     4,(ix+DIS),b =} 0xDD 0xCB DIS <0:6+<1:3+<3
; res     5,(ix+DIS),b =} 0xDD 0xCB DIS <0:6+<1:3+<3
; set     5,(ix+DIS),b =} 0xDD 0xCB DIS <0:6+<1:3+<3
; res     6,(ix+DIS),b =} 0xDD 0xCB DIS <0:6+<1:3+<3
; set     6,(ix+DIS),b =} 0xDD 0xCB DIS <0:6+<1:3+<3
; res     7,(ix+DIS),b =} 0xDD 0xCB DIS <0:6+<1:3+<3
; set     7,(ix+DIS),b =} 0xDD 0xCB DIS <0:6+<1:3+<3
; res     0,(ix+DIS),c =} 0xDD 0xCB DIS <0:6+<1:3+<3
; set     0,(ix+DIS),c =} 0xDD 0xCB DIS <0:6+<1:3+<3
; res     1,(ix+DIS),c =} 0xDD 0xCB DIS <0:6+<1:3+<3
; set     1,(ix+DIS),c =} 0xDD 0xCB DIS <0:6+<1:3+<3
; res     2,(ix+DIS),c =} 0xDD 0xCB DIS <0:6+<1:3+<3
; set     2,(ix+DIS),c =} 0xDD 0xCB DIS <0:6+<1:3+<3
; res     3,(ix+DIS),c =} 0xDD 0xCB DIS <0:6+<1:3+<3
; set     3,(ix+DIS),c =} 0xDD 0xCB DIS <0:6+<1:3+<3
; res     4,(ix+DIS),c =} 0xDD 0xCB DIS <0:6+<1:3+<3
; set     4,(ix+DIS),c =} 0xDD 0xCB DIS <0:6+<1:3+<3
; res     5,(ix+DIS),c =} 0xDD 0xCB DIS <0:6+<1:3+<3
; set     5,(ix+DIS),c =} 0xDD 0xCB DIS <0:6+<1:3+<3
; res     6,(ix+DIS),c =} 0xDD 0xCB DIS <0:6+<1:3+<3
; set     6,(ix+DIS),c =} 0xDD 0xCB DIS <0:6+<1:3+<3
; res     7,(ix+DIS),c =} 0xDD 0xCB DIS <0:6+<1:3+<3
; set     7,(ix+DIS),c =} 0xDD 0xCB DIS <0:6+<1:3+<3
; res     0,(ix+DIS),d =} 0xDD 0xCB DIS <0:6+<1:3+<3
; set     0,(ix+DIS),d =} 0xDD 0xCB DIS <0:6+<1:3+<3
; res     1,(ix+DIS),d =} 0xDD 0xCB DIS <0:6+<1:3+<3
; set     1,(ix+DIS),d =} 0xDD 0xCB DIS <0:6+<1:3+<3
; res     2,(ix+DIS),d =} 0xDD 0xCB DIS <0:6+<1:3+<3
; set     2,(ix+DIS),d =} 0xDD 0xCB DIS <0:6+<1:3+<3
; res     3,(ix+DIS),d =} 0xDD 0xCB DIS <0:6+<1:3+<3
; set     3,(ix+DIS),d =} 0xDD 0xCB DIS <0:6+<1:3+<3
; res     4,(ix+DIS),d =} 0xDD 0xCB DIS <0:6+<1:3+<3
; set     4,(ix+DIS),d =} 0xDD 0xCB DIS <0:6+<1:3+<3
; res     5,(ix+DIS),d =} 0xDD 0xCB DIS <0:6+<1:3+<3
; set     5,(ix+DIS),d =} 0xDD 0xCB DIS <0:6+<1:3+<3
; res     6,(ix+DIS),d =} 0xDD 0xCB DIS <0:6+<1:3+<3
; set     6,(ix+DIS),d =} 0xDD 0xCB DIS <0:6+<1:3+<3
; res     7,(ix+DIS),d =} 0xDD 0xCB DIS <0:6+<1:3+<3
; set     7,(ix+DIS),d =} 0xDD 0xCB DIS <0:6+<1:3+<3
; res     0,(ix+DIS),e =} 0xDD 0xCB DIS <0:6+<1:3+<3
; set     0,(ix+DIS),e =} 0xDD 0xCB DIS <0:6+<1:3+<3
; res     1,(ix+DIS),e =} 0xDD 0xCB DIS <0:6+<1:3+<3
; set     1,(ix+DIS),e =} 0xDD 0xCB DIS <0:6+<1:3+<3
; res     2,(ix+DIS),e =} 0xDD 0xCB DIS <0:6+<1:3+<3
; set     2,(ix+DIS),e =} 0xDD 0xCB DIS <0:6+<1:3+<3
; res     3,(ix+DIS),e =} 0xDD 0xCB DIS <0:6+<1:3+<3
; set     3,(ix+DIS),e =} 0xDD 0xCB DIS <0:6+<1:3+<3
; res     4,(ix+DIS),e =} 0xDD 0xCB DIS <0:6+<1:3+<3
; set     4,(ix+DIS),e =} 0xDD 0xCB DIS <0:6+<1:3+<3
; res     5,(ix+DIS),e =} 0xDD 0xCB DIS <0:6+<1:3+<3
; set     5,(ix+DIS),e =} 0xDD 0xCB DIS <0:6+<1:3+<3
; res     6,(ix+DIS),e =} 0xDD 0xCB DIS <0:6+<1:3+<3
; set     6,(ix+DIS),e =} 0xDD 0xCB DIS <0:6+<1:3+<3
; res     7,(ix+DIS),e =} 0xDD 0xCB DIS <0:6+<1:3+<3
; set     7,(ix+DIS),e =} 0xDD 0xCB DIS <0:6+<1:3+<3
; res     0,(ix+DIS),h =} 0xDD 0xCB DIS <0:6+<1:3+<3
; set     0,(ix+DIS),h =} 0xDD 0xCB DIS <0:6+<1:3+<3
; res     1,(ix+DIS),h =} 0xDD 0xCB DIS <0:6+<1:3+<3
; set     1,(ix+DIS),h =} 0xDD 0xCB DIS <0:6+<1:3+<3
; res     2,(ix+DIS),h =} 0xDD 0xCB DIS <0:6+<1:3+<3
; set     2,(ix+DIS),h =} 0xDD 0xCB DIS <0:6+<1:3+<3
; res     3,(ix+DIS),h =} 0xDD 0xCB DIS <0:6+<1:3+<3
; set     3,(ix+DIS),h =} 0xDD 0xCB DIS <0:6+<1:3+<3
; res     4,(ix+DIS),h =} 0xDD 0xCB DIS <0:6+<1:3+<3
; set     4,(ix+DIS),h =} 0xDD 0xCB DIS <0:6+<1:3+<3
; res     5,(ix+DIS),h =} 0xDD 0xCB DIS <0:6+<1:3+<3
; set     5,(ix+DIS),h =} 0xDD 0xCB DIS <0:6+<1:3+<3
; res     6,(ix+DIS),h =} 0xDD 0xCB DIS <0:6+<1:3+<3
; set     6,(ix+DIS),h =} 0xDD 0xCB DIS <0:6+<1:3+<3
; res     7,(ix+DIS),h =} 0xDD 0xCB DIS <0:6+<1:3+<3
; set     7,(ix+DIS),h =} 0xDD 0xCB DIS <0:6+<1:3+<3
; res     0,(ix+DIS),l =} 0xDD 0xCB DIS <0:6+<1:3+<3
; set     0,(ix+DIS),l =} 0xDD 0xCB DIS <0:6+<1:3+<3
; res     1,(ix+DIS),l =} 0xDD 0xCB DIS <0:6+<1:3+<3
; set     1,(ix+DIS),l =} 0xDD 0xCB DIS <0:6+<1:3+<3
; res     2,(ix+DIS),l =} 0xDD 0xCB DIS <0:6+<1:3+<3
; set     2,(ix+DIS),l =} 0xDD 0xCB DIS <0:6+<1:3+<3
; res     3,(ix+DIS),l =} 0xDD 0xCB DIS <0:6+<1:3+<3
; set     3,(ix+DIS),l =} 0xDD 0xCB DIS <0:6+<1:3+<3
; res     4,(ix+DIS),l =} 0xDD 0xCB DIS <0:6+<1:3+<3
; set     4,(ix+DIS),l =} 0xDD 0xCB DIS <0:6+<1:3+<3
; res     5,(ix+DIS),l =} 0xDD 0xCB DIS <0:6+<1:3+<3
; set     5,(ix+DIS),l =} 0xDD 0xCB DIS <0:6+<1:3+<3
; res     6,(ix+DIS),l =} 0xDD 0xCB DIS <0:6+<1:3+<3
; set     6,(ix+DIS),l =} 0xDD 0xCB DIS <0:6+<1:3+<3
; res     7,(ix+DIS),l =} 0xDD 0xCB DIS <0:6+<1:3+<3
; set     7,(ix+DIS),l =} 0xDD 0xCB DIS <0:6+<1:3+<3
; res     0,(ix+DIS),a =} 0xDD 0xCB DIS <0:6+<1:3+<3
; set     0,(ix+DIS),a =} 0xDD 0xCB DIS <0:6+<1:3+<3
; res     1,(ix+DIS),a =} 0xDD 0xCB DIS <0:6+<1:3+<3
; set     1,(ix+DIS),a =} 0xDD 0xCB DIS <0:6+<1:3+<3
; res     2,(ix+DIS),a =} 0xDD 0xCB DIS <0:6+<1:3+<3
; set     2,(ix+DIS),a =} 0xDD 0xCB DIS <0:6+<1:3+<3
; res     3,(ix+DIS),a =} 0xDD 0xCB DIS <0:6+<1:3+<3
; set     3,(ix+DIS),a =} 0xDD 0xCB DIS <0:6+<1:3+<3
; res     4,(ix+DIS),a =} 0xDD 0xCB DIS <0:6+<1:3+<3
; set     4,(ix+DIS),a =} 0xDD 0xCB DIS <0:6+<1:3+<3
; res     5,(ix+DIS),a =} 0xDD 0xCB DIS <0:6+<1:3+<3
; set     5,(ix+DIS),a =} 0xDD 0xCB DIS <0:6+<1:3+<3
; res     6,(ix+DIS),a =} 0xDD 0xCB DIS <0:6+<1:3+<3
; set     6,(ix+DIS),a =} 0xDD 0xCB DIS <0:6+<1:3+<3
; res     7,(ix+DIS),a =} 0xDD 0xCB DIS <0:6+<1:3+<3
; set     7,(ix+DIS),a =} 0xDD 0xCB DIS <0:6+<1:3+<3
; res     0,(iy+DIS),b =} 0xFD 0xCB DIS <0:6+<1:3+<3
; set     0,(iy+DIS),b =} 0xFD 0xCB DIS <0:6+<1:3+<3
; res     1,(iy+DIS),b =} 0xFD 0xCB DIS <0:6+<1:3+<3
; set     1,(iy+DIS),b =} 0xFD 0xCB DIS <0:6+<1:3+<3
; res     2,(iy+DIS),b =} 0xFD 0xCB DIS <0:6+<1:3+<3
; set     2,(iy+DIS),b =} 0xFD 0xCB DIS <0:6+<1:3+<3
; res     3,(iy+DIS),b =} 0xFD 0xCB DIS <0:6+<1:3+<3
; set     3,(iy+DIS),b =} 0xFD 0xCB DIS <0:6+<1:3+<3
; res     4,(iy+DIS),b =} 0xFD 0xCB DIS <0:6+<1:3+<3
; set     4,(iy+DIS),b =} 0xFD 0xCB DIS <0:6+<1:3+<3
; res     5,(iy+DIS),b =} 0xFD 0xCB DIS <0:6+<1:3+<3
; set     5,(iy+DIS),b =} 0xFD 0xCB DIS <0:6+<1:3+<3
; res     6,(iy+DIS),b =} 0xFD 0xCB DIS <0:6+<1:3+<3
; set     6,(iy+DIS),b =} 0xFD 0xCB DIS <0:6+<1:3+<3
; res     7,(iy+DIS),b =} 0xFD 0xCB DIS <0:6+<1:3+<3
; set     7,(iy+DIS),b =} 0xFD 0xCB DIS <0:6+<1:3+<3
; res     0,(iy+DIS),c =} 0xFD 0xCB DIS <0:6+<1:3+<3
; set     0,(iy+DIS),c =} 0xFD 0xCB DIS <0:6+<1:3+<3
; res     1,(iy+DIS),c =} 0xFD 0xCB DIS <0:6+<1:3+<3
; set     1,(iy+DIS),c =} 0xFD 0xCB DIS <0:6+<1:3+<3
; res     2,(iy+DIS),c =} 0xFD 0xCB DIS <0:6+<1:3+<3
; set     2,(iy+DIS),c =} 0xFD 0xCB DIS <0:6+<1:3+<3
; res     3,(iy+DIS),c =} 0xFD 0xCB DIS <0:6+<1:3+<3
; set     3,(iy+DIS),c =} 0xFD 0xCB DIS <0:6+<1:3+<3
; res     4,(iy+DIS),c =} 0xFD 0xCB DIS <0:6+<1:3+<3
; set     4,(iy+DIS),c =} 0xFD 0xCB DIS <0:6+<1:3+<3
; res     5,(iy+DIS),c =} 0xFD 0xCB DIS <0:6+<1:3+<3
; set     5,(iy+DIS),c =} 0xFD 0xCB DIS <0:6+<1:3+<3
; res     6,(iy+DIS),c =} 0xFD 0xCB DIS <0:6+<1:3+<3
; set     6,(iy+DIS),c =} 0xFD 0xCB DIS <0:6+<1:3+<3
; res     7,(iy+DIS),c =} 0xFD 0xCB DIS <0:6+<1:3+<3
; set     7,(iy+DIS),c =} 0xFD 0xCB DIS <0:6+<1:3+<3
; res     0,(iy+DIS),d =} 0xFD 0xCB DIS <0:6+<1:3+<3
; set     0,(iy+DIS),d =} 0xFD 0xCB DIS <0:6+<1:3+<3
; res     1,(iy+DIS),d =} 0xFD 0xCB DIS <0:6+<1:3+<3
; set     1,(iy+DIS),d =} 0xFD 0xCB DIS <0:6+<1:3+<3
; res     2,(iy+DIS),d =} 0xFD 0xCB DIS <0:6+<1:3+<3
; set     2,(iy+DIS),d =} 0xFD 0xCB DIS <0:6+<1:3+<3
; res     3,(iy+DIS),d =} 0xFD 0xCB DIS <0:6+<1:3+<3
; set     3,(iy+DIS),d =} 0xFD 0xCB DIS <0:6+<1:3+<3
; res     4,(iy+DIS),d =} 0xFD 0xCB DIS <0:6+<1:3+<3
; set     4,(iy+DIS),d =} 0xFD 0xCB DIS <0:6+<1:3+<3
; res     5,(iy+DIS),d =} 0xFD 0xCB DIS <0:6+<1:3+<3
; set     5,(iy+DIS),d =} 0xFD 0xCB DIS <0:6+<1:3+<3
; res     6,(iy+DIS),d =} 0xFD 0xCB DIS <0:6+<1:3+<3
; set     6,(iy+DIS),d =} 0xFD 0xCB DIS <0:6+<1:3+<3
; res     7,(iy+DIS),d =} 0xFD 0xCB DIS <0:6+<1:3+<3
; set     7,(iy+DIS),d =} 0xFD 0xCB DIS <0:6+<1:3+<3
; res     0,(iy+DIS),e =} 0xFD 0xCB DIS <0:6+<1:3+<3
; set     0,(iy+DIS),e =} 0xFD 0xCB DIS <0:6+<1:3+<3
; res     1,(iy+DIS),e =} 0xFD 0xCB DIS <0:6+<1:3+<3
; set     1,(iy+DIS),e =} 0xFD 0xCB DIS <0:6+<1:3+<3
; res     2,(iy+DIS),e =} 0xFD 0xCB DIS <0:6+<1:3+<3
; set     2,(iy+DIS),e =} 0xFD 0xCB DIS <0:6+<1:3+<3
; res     3,(iy+DIS),e =} 0xFD 0xCB DIS <0:6+<1:3+<3
; set     3,(iy+DIS),e =} 0xFD 0xCB DIS <0:6+<1:3+<3
; res     4,(iy+DIS),e =} 0xFD 0xCB DIS <0:6+<1:3+<3
; set     4,(iy+DIS),e =} 0xFD 0xCB DIS <0:6+<1:3+<3
; res     5,(iy+DIS),e =} 0xFD 0xCB DIS <0:6+<1:3+<3
; set     5,(iy+DIS),e =} 0xFD 0xCB DIS <0:6+<1:3+<3
; res     6,(iy+DIS),e =} 0xFD 0xCB DIS <0:6+<1:3+<3
; set     6,(iy+DIS),e =} 0xFD 0xCB DIS <0:6+<1:3+<3
; res     7,(iy+DIS),e =} 0xFD 0xCB DIS <0:6+<1:3+<3
; set     7,(iy+DIS),e =} 0xFD 0xCB DIS <0:6+<1:3+<3
; res     0,(iy+DIS),h =} 0xFD 0xCB DIS <0:6+<1:3+<3
; set     0,(iy+DIS),h =} 0xFD 0xCB DIS <0:6+<1:3+<3
; res     1,(iy+DIS),h =} 0xFD 0xCB DIS <0:6+<1:3+<3
; set     1,(iy+DIS),h =} 0xFD 0xCB DIS <0:6+<1:3+<3
; res     2,(iy+DIS),h =} 0xFD 0xCB DIS <0:6+<1:3+<3
; set     2,(iy+DIS),h =} 0xFD 0xCB DIS <0:6+<1:3+<3
; res     3,(iy+DIS),h =} 0xFD 0xCB DIS <0:6+<1:3+<3
; set     3,(iy+DIS),h =} 0xFD 0xCB DIS <0:6+<1:3+<3
; res     4,(iy+DIS),h =} 0xFD 0xCB DIS <0:6+<1:3+<3
; set     4,(iy+DIS),h =} 0xFD 0xCB DIS <0:6+<1:3+<3
; res     5,(iy+DIS),h =} 0xFD 0xCB DIS <0:6+<1:3+<3
; set     5,(iy+DIS),h =} 0xFD 0xCB DIS <0:6+<1:3+<3
; res     6,(iy+DIS),h =} 0xFD 0xCB DIS <0:6+<1:3+<3
; set     6,(iy+DIS),h =} 0xFD 0xCB DIS <0:6+<1:3+<3
; res     7,(iy+DIS),h =} 0xFD 0xCB DIS <0:6+<1:3+<3
; set     7,(iy+DIS),h =} 0xFD 0xCB DIS <0:6+<1:3+<3
; res     0,(iy+DIS),l =} 0xFD 0xCB DIS <0:6+<1:3+<3
; set     0,(iy+DIS),l =} 0xFD 0xCB DIS <0:6+<1:3+<3
; res     1,(iy+DIS),l =} 0xFD 0xCB DIS <0:6+<1:3+<3
; set     1,(iy+DIS),l =} 0xFD 0xCB DIS <0:6+<1:3+<3
; res     2,(iy+DIS),l =} 0xFD 0xCB DIS <0:6+<1:3+<3
; set     2,(iy+DIS),l =} 0xFD 0xCB DIS <0:6+<1:3+<3
; res     3,(iy+DIS),l =} 0xFD 0xCB DIS <0:6+<1:3+<3
; set     3,(iy+DIS),l =} 0xFD 0xCB DIS <0:6+<1:3+<3
; res     4,(iy+DIS),l =} 0xFD 0xCB DIS <0:6+<1:3+<3
; set     4,(iy+DIS),l =} 0xFD 0xCB DIS <0:6+<1:3+<3
; res     5,(iy+DIS),l =} 0xFD 0xCB DIS <0:6+<1:3+<3
; set     5,(iy+DIS),l =} 0xFD 0xCB DIS <0:6+<1:3+<3
; res     6,(iy+DIS),l =} 0xFD 0xCB DIS <0:6+<1:3+<3
; set     6,(iy+DIS),l =} 0xFD 0xCB DIS <0:6+<1:3+<3
; res     7,(iy+DIS),l =} 0xFD 0xCB DIS <0:6+<1:3+<3
; set     7,(iy+DIS),l =} 0xFD 0xCB DIS <0:6+<1:3+<3
; res     0,(iy+DIS),a =} 0xFD 0xCB DIS <0:6+<1:3+<3
; set     0,(iy+DIS),a =} 0xFD 0xCB DIS <0:6+<1:3+<3
; res     1,(iy+DIS),a =} 0xFD 0xCB DIS <0:6+<1:3+<3
; set     1,(iy+DIS),a =} 0xFD 0xCB DIS <0:6+<1:3+<3
; res     2,(iy+DIS),a =} 0xFD 0xCB DIS <0:6+<1:3+<3
; set     2,(iy+DIS),a =} 0xFD 0xCB DIS <0:6+<1:3+<3
; res     3,(iy+DIS),a =} 0xFD 0xCB DIS <0:6+<1:3+<3
; set     3,(iy+DIS),a =} 0xFD 0xCB DIS <0:6+<1:3+<3
; res     4,(iy+DIS),a =} 0xFD 0xCB DIS <0:6+<1:3+<3
; set     4,(iy+DIS),a =} 0xFD 0xCB DIS <0:6+<1:3+<3
; res     5,(iy+DIS),a =} 0xFD 0xCB DIS <0:6+<1:3+<3
; set     5,(iy+DIS),a =} 0xFD 0xCB DIS <0:6+<1:3+<3
; res     6,(iy+DIS),a =} 0xFD 0xCB DIS <0:6+<1:3+<3
; set     6,(iy+DIS),a =} 0xFD 0xCB DIS <0:6+<1:3+<3
; res     7,(iy+DIS),a =} 0xFD 0xCB DIS <0:6+<1:3+<3
; set     7,(iy+DIS),a =} 0xFD 0xCB DIS <0:6+<1:3+<3

;------------------------------------------------------------------------------
; Jump Group
;------------------------------------------------------------------------------
        jp   NN                         ;; C3 30 00
        jp   (hl)                       ;; E9
        jp   (ix)                       ;; DD E9
        jp   (iy)                       ;; FD E9
        jp   nz,NN                      ;; C2 30 00
        jp   z,NN                       ;; CA 30 00
        jp   nc,NN                      ;; D2 30 00
        jp   c,NN                       ;; DA 30 00
        jp   po,NN                      ;; E2 30 00
        jp   pe,NN                      ;; EA 30 00
        jp   p,NN                       ;; F2 30 00
        jp   m,NN                       ;; FA 30 00

                                        ; max forward jump
        jr   jr2                        ;; 18 7F
        jr   jr2                        ;; 18 7D
        jr   jr2                        ;; 18 7B

        djnz ASMPC                      ;; 10 FE
        djnz ASMPC+0x81                 ;; 10 7F
        jr   ASMPC                      ;; 18 FE
        jr   ASMPC-0x7E                 ;; 18 80

        djnz jr1                        ;; 10 00
jr1:    
        jr   jr1                        ;; 18 FE
        djnz jr1                        ;; 10 FC
        jr   nz,jr1                     ;; 20 FA
        jr   z,jr1                      ;; 28 F8
        jr   nc,jr1                     ;; 30 F6
        jr   c,jr1                      ;; 38 F4

        defb 1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25
                                        ;; 01 02 03 04 05 06 07 08 09 0A 0B 0C 0D 0E 0F 10 11 12 13 14 15 16 17 18 19
        defb 26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50
                                        ;; 1A 1B 1C 1D 1E 1F 20 21 22 23 24 25 26 27 28 29 2A 2B 2C 2D 2E 2F 30 31 32
        defb 51,52,53,54,55,56,57,58,59,60,61,62,63,64,65,66,67,68,69,70,71,72,73,74,75
                                        ;; 33 34 35 36 37 38 39 3A 3B 3C 3D 3E 3F 40 41 42 43 44 45 46 47 48 49 4A 4B
        defb 76,77,78,79,80,81,82,83,84,85,86,87,88,89,90,91,92,93,94,95,96,97,98,99,100,101
                                        ;; 4C 4D 4E 4F 50 51 52 53 54 55 56 57 58 59 5A 5B 5C 5D 5E 5F 60 61 62 63 64 65

jr2:    
        defb 1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25
                                        ;; 01 02 03 04 05 06 07 08 09 0A 0B 0C 0D 0E 0F 10 11 12 13 14 15 16 17 18 19
        defb 26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50
                                        ;; 1A 1B 1C 1D 1E 1F 20 21 22 23 24 25 26 27 28 29 2A 2B 2C 2D 2E 2F 30 31 32
        defb 51,52,53,54,55,56,57,58,59,60,61,62,63,64,65,66,67,68,69,70,71,72,73,74,75
                                        ;; 33 34 35 36 37 38 39 3A 3B 3C 3D 3E 3F 40 41 42 43 44 45 46 47 48 49 4A 4B
        defb 76,77,78,79,80,81,82,83,84,85,86,87,88,89,90,91,92,93,94,95,96,97,98,99,100
                                        ;; 4C 4D 4E 4F 50 51 52 53 54 55 56 57 58 59 5A 5B 5C 5D 5E 5F 60 61 62 63 64
        defb 101,102,103,104,105,106,107,108,109,110,111,112,113,114,115,116,117,118,119,120,121,122
                                        ;; 65 66 67 68 69 6A 6B 6C 6D 6E 6F 70 71 72 73 74 75 76 77 78 79 7A

        jr   jr2                        ;; 18 84
        jr   jr2                        ;; 18 82
                                        ; max backward jump - z80pack does not accept -128
        jr   jr2                        ;; 18 80


; jr po,NN
; jr pe,NN
; jr p,NN
; jr m,NN


;------------------------------------------------------------------------------
; Call and Return Group
;------------------------------------------------------------------------------

        call NN                         ;; CD 30 00
        ret                             ;; C9
        ret  nz                         ;; C0
        ret  z                          ;; C8
        ret  nc                         ;; D0
        ret  c                          ;; D8
        ret  po                         ;; E0
        ret  pe                         ;; E8
        ret  p                          ;; F0
        ret  m                          ;; F8
        reti                            ;; ED 4D
; rst 0
; rst 1
; rst 2
; rst 3
; rst 4
; rst 5
; rst 6
; rst 7


IF      !RABBIT
        call nz,NN                      ;; C4 30 00
        call z,NN                       ;; CC 30 00
        call nc,NN                      ;; D4 30 00
        call c,NN                       ;; DC 30 00
        call po,NN                      ;; E4 30 00
        call pe,NN                      ;; EC 30 00
        call p,NN                       ;; F4 30 00
        call m,NN                       ;; FC 30 00

        retn                            ;; ED 45

        rst  00h                        ;; C7
        rst  08h                        ;; CF
        rst  10h                        ;; D7
        rst  18h                        ;; DF
        rst  20h                        ;; E7
        rst  28h                        ;; EF
        rst  30h                        ;; F7
        rst  38h                        ;; FF
ELSE    
        call nz,NN
        call z,NN
        call nc,NN
        call c,NN
        call po,NN
        call pe,NN
        call p,NN
        call m,NN

        retn

        rst  10h
        rst  18h
        rst  20h
        rst  28h
        rst  38h
        rst  00h
        rst  08h
        rst  30h
ENDIF   


;------------------------------------------------------------------------------
; Input and Output Group
;------------------------------------------------------------------------------

IF      !RABBIT
        in   a,(N)                      ;; DB 20
        in   b,(c)                      ;; ED 40
        in   c,(c)                      ;; ED 48
        in   d,(c)                      ;; ED 50
        in   e,(c)                      ;; ED 58
        in   h,(c)                      ;; ED 60
        in   l,(c)                      ;; ED 68
        in   a,(c)                      ;; ED 78
; in f,(c)

        ini                             ;; ED A2
        inir                            ;; ED B2
        ind                             ;; ED AA
        indr                            ;; ED BA

        out  (N),a                      ;; D3 20
        out  (c),b                      ;; ED 41
        out  (c),c                      ;; ED 49
        out  (c),d                      ;; ED 51
        out  (c),e                      ;; ED 59
        out  (c),h                      ;; ED 61
        out  (c),l                      ;; ED 69
        out  (c),a                      ;; ED 79
; out (c),0

        outi                            ;; ED A3
        otir                            ;; ED B3
        outd                            ;; ED AB
        otdr                            ;; ED BB
ELSE    
        in   a,(0)
        in   b,(c)
        in   c,(c)
        in   d,(c)
        in   e,(c)
        in   h,(c)
        in   l,(c)
        in   a,(c)
        ini
        inir
        ind
        indr
        out  (0),a
        out  (c),b
        out  (c),c
        out  (c),d
        out  (c),e
        out  (c),h
        out  (c),l
        out  (c),a
        outi
        otir
        outd
        otdr
ENDIF   

;------------------------------------------------------------------------------
; IF ELSE ENDIF
;------------------------------------------------------------------------------
        if   1
          defb 1                        ;; 01
          if   1
            defb 2                      ;; 02
          else
            defb 3
          endif
        else
          defb 4
          if   1
            defb 5
          else
            defb 6
          endif
        endif

        if   0
          defb 7
        endif

        if   1
          defb 8                        ;; 08
        endif

        if   0
          defb 9
        else
          defb 10                       ;; 0A
        endif

        if   undefined
          defb 11
        else
          defb 12                       ;; 0C
        endif

        if   undefined | 1
          defb 13                       ;; 0D
        else
          defb 14
        endif

;------------------------------------------------------------------------------
; IFDEF ELSE ENDIF
;------------------------------------------------------------------------------
        defc ifdef_1 = 0
        define ifdef_2

        ifdef ZERO
          defb 1                        ;; 01
        else
          defb 2
        endif

        ifdef undefined
          defb 3
        else
          defb 4                        ;; 04
        endif

        ifdef ifdef_1
          defb 5                        ;; 05
        else
          defb 6
        endif

        ifdef ifdef_2
          defb 7                        ;; 07
        else
          defb 8
        endif

        ifdef ifdef_3
          defb 9
        else
          defb 10                       ;; 0A
        endif

;------------------------------------------------------------------------------
; IFNDEF ELSE ENDIF
;------------------------------------------------------------------------------
        defc ifndef_1 = 0
        define ifndef_2

        ifndef ZERO
          defb 1
        else
          defb 2                        ;; 02
        endif

        ifndef undefined
          defb 3                        ;; 03
        else
          defb 4
        endif

        ifndef ifndef_1
          defb 5
        else
          defb 6                        ;; 06
        endif

        ifndef ifndef_2
          defb 7
        else
          defb 8                        ;; 08
        endif

        ifndef ifndef_3
          defb 9                        ;; 09
        else
          defb 10
        endif

;------------------------------------------------------------------------------
; DEFGROUP
;------------------------------------------------------------------------------
        defgroup
        {
          f0, f1
          f2, f3,
          f10  = 10,
          f11,
          f20  = 20, f21
          rl
        }
        defb f0,f1,f2,f3,f10,f11,f20,f21,rl
                                        ;; 00 01 02 03 0A 0B 14 15 16

        defgroup
        {
          dg1, dg2  = 3
          dg3  = 7,
        }
        defb dg1,dg2,dg3                ;; 00 03 07

                                        ; check with conditional assembly
        if   1
          defgroup
          {
            ff   = 1
          }
        else
          defgroup
          {
            ff   = 2
          }
        endif
        if   0
          defgroup
          {
            fg   = 1
          }
        else
          defgroup
          {
            fg   = 2
          }
        endif
        defb ff, fg                     ;; 01 02

;------------------------------------------------------------------------------
; DEFS
;------------------------------------------------------------------------------
        defs 0
        defs 1                          ;; 00
        defs 2                          ;; 00 00
        defs 3                          ;; 00 00 00
        defs 4                          ;; 00 00 00 00

        defs 2,-128                     ;; 80 80
        defs 2,-127                     ;; 81 81
        defs 2,0                        ;; 00 00
        defs 2,255                      ;; FF FF

        if   0
          defs 2,0
        else
          defs 2,2                      ;; 02 02
        endif

;------------------------------------------------------------------------------
; DEFVARS
;------------------------------------------------------------------------------
        defc defvars_base = 0x80
        defvars defvars_base

        {
          df1  ds.b 4
          df2  ds.w 2
          df3  ds.p 2
          df4  ds.q 2
          df5
          rr

        }
        defb df1, df2, df3, df4, df5, rr
                                        ;; 80 84 88 8E 96 96

        defvars 0 {
          df6  ds.b 1
          df7  ds.b 1
          df8
        }
        defb df6, df7, df8              ;; 00 01 02

        defvars -1                      ; continue after df5
        {
          df9  ds.b 1
          df10 ds.b 1
          df11
          df12
        }
        defb df9, df10, df11, df12      ;; 96 97 98 98

        defvars 0 {
          df13 ds.b 1
          df14 ds.b 1
          df15
        }
        defb df13, df14, df15           ;; 00 01 02

        defvars -1                      ; continue after df12
        {
          df16 ds.b 1
          df17 ds.b 1
          df18 ds.b 0
          df19
        }
        defb df16, df17, df18, df19     ;; 98 99 9A 9A

                                        ; check with conditional assembly
        if   1
          defvars 0
          {
            df20 ds.b 1
            df21
          }
        else
          defvars 0
          {
            df20 ds.w 1
            df21
          }
        endif
        defb df20, df21                 ;; 00 01

        if   0
          defvars 0
          {
            df30 ds.b 1
            df31
          }
        else
          defvars 0
          {
            df30 ds.w 1
            df31
          }
        endif
        defb df30, df31                 ;; 00 02

;------------------------------------------------------------------------------
; Allow labels with names of opcodes
;------------------------------------------------------------------------------

        extern ld

        nop                             ;; 00
        jr   nop                        ;; 18 00
nop:    

IF      !RABBIT
        di                              ;; F3
        jr   di                         ;; 18 00
di:     
        ei                              ;; FB
        jr   ei                         ;; 18 00
ei:     
ENDIF   

;------------------------------------------------------------------------------
; Test parsing of expressions with parentheses inside parentheses
;------------------------------------------------------------------------------
IF      !RABBIT
        out  (N),a                      ;; D3 20
        out  ((N)),a                    ;; D3 20
        out  (N+2*(3-3)),a              ;; D3 20
ENDIF   

;------------------------------------------------------------------------------
; Z88DK specific opcodes
;------------------------------------------------------------------------------
        call_oz 1                       ;; E7 01
        call_oz 255                     ;; E7 FF
        call_oz 256                     ;; E7 00 01
        call_oz 65535                   ;; E7 FF FF

IF      !RABBIT
        call_pkg 0                      ;; CF 00 00
        call_pkg 1                      ;; CF 01 00
        call_pkg 65535                  ;; CF FF FF
ENDIF   

        fpp  1                          ;; DF 01
        fpp  254                        ;; DF FE

        invoke 0                        ;; CD 00 00
        invoke 1                        ;; CD 01 00
        invoke 65535                    ;; CD FF FF
END_ASM
);
z80asm(
    options => "-l -b",
    asm  => <<'END_ASM',
        ldx                             ;; error: syntax error
        ld                              ;; error: syntax error
        ld   a,1+                       ;; error: syntax error
        ld   a,'                        ;; error: invalid single quoted character
        ld   a,''                       ;; error: invalid single quoted character
        ld   a,'a                       ;; error: invalid single quoted character
        ld   a,'he'                     ;; error: invalid single quoted character
        ld   a,"a"                      ;; error: syntax error
        defb "                          ;; error: unclosed quoted string
        defb "hello                     ;; error: unclosed quoted string
        defb 1/0                        ;; error 2: division by zero
        defb 1% 0                       ;; error 2: division by zero
        defb 1?                         ;; error: syntax error
        defb 1?2                        ;; error: syntax error in expression
        defb 1?2:                       ;; error: syntax error
        defb 1?2:1?                     ;; error: syntax error
        defm "hello ",                  ;; error: syntax error
        defm "hello "&                  ;; error: syntax error
        defm "hello "&"world"           ;; error: syntax error
        defm "hello"&32&"world"         ;; error: syntax error
        defm 32,                        ;; error: syntax error
IF      !RABBIT
ELSE    
ENDIF   
        ld   (bc),b                     ;; error: syntax error
        ld   (de),b                     ;; error: syntax error
        ld   (bc),c                     ;; error: syntax error
        ld   (de),c                     ;; error: syntax error
        ld   (bc),d                     ;; error: syntax error
        ld   (de),d                     ;; error: syntax error
        ld   (bc),e                     ;; error: syntax error
        ld   (de),e                     ;; error: syntax error
        ld   (bc),h                     ;; error: syntax error
        ld   (de),h                     ;; error: syntax error
        ld   (bc),l                     ;; error: syntax error
        ld   (de),l                     ;; error: syntax error
        ld   (bc),(hl)                  ;; error: syntax error
        ld   (de),(hl)                  ;; error: syntax error
        ld   (bc),(ix+DIS)              ;; error: syntax error
        ld   (de),(ix+DIS)              ;; error: syntax error
        ld   (bc),(iy+DIS)              ;; error: syntax error
        ld   (de),(iy+DIS)              ;; error: syntax error
        ld   (bc),N                     ;; error: syntax error
        ld   (de),N                     ;; error: syntax error
IF      !RABBIT
ELSE    
ENDIF   
IF      !RABBIT
ELSE    
ENDIF   
IF      !RABBIT
ELSE    
ENDIF   
IF      !RABBIT
ELSE    
ENDIF   
IF      !RABBIT
ELSE    
ENDIF   
IF      !RABBIT
        im   -1                         ;; error: integer '-1' out of range
        im   3                          ;; error: integer '3' out of range
        im   undefined                  ;; error: symbol 'undefined' not defined
ELSE    
ENDIF   
        bit  -1,a                       ;; error: integer '-1' out of range
        res  -1,a                       ;; error: integer '-1' out of range
        set  -1,a                       ;; error: integer '-1' out of range
        bit  8,a                        ;; error: integer '8' out of range
        res  8,a                        ;; error: integer '8' out of range
        set  8,a                        ;; error: integer '8' out of range
        bit  undefined,a                ;; error: symbol 'undefined' not defined
        res  undefined,a                ;; error: symbol 'undefined' not defined
        set  undefined,a                ;; error: symbol 'undefined' not defined
        djnz ASMPC-0x7F                 ;; error 2: integer '-129' out of range
        djnz ASMPC+0x82                 ;; error 2: integer '128' out of range
        jr   ASMPC-0x7F                 ;; error 2: integer '-129' out of range
        jr   ASMPC+0x82                 ;; error 2: integer '128' out of range
        jr   nz,ASMPC-0x7F              ;; error 2: integer '-129' out of range
        jr   nz,ASMPC+0x82              ;; error 2: integer '128' out of range
        jr   z,ASMPC-0x7F               ;; error 2: integer '-129' out of range
        jr   z,ASMPC+0x82               ;; error 2: integer '128' out of range
        jr   nc,ASMPC-0x7F              ;; error 2: integer '-129' out of range
        jr   nc,ASMPC+0x82              ;; error 2: integer '128' out of range
        jr   c,ASMPC-0x7F               ;; error 2: integer '-129' out of range
        jr   c,ASMPC+0x82               ;; error 2: integer '128' out of range
IF      !RABBIT
ELSE    
ENDIF   
        rst  undefined                  ;; error: symbol 'undefined' not defined
        rst  -1                         ;; error: integer '-1' out of range
        rst  1                          ;; error: integer '1' out of range
        rst  7                          ;; error: integer '7' out of range
        rst  9                          ;; error: integer '9' out of range
        rst  15                         ;; error: integer '15' out of range
        rst  17                         ;; error: integer '17' out of range
        rst  23                         ;; error: integer '23' out of range
        rst  25                         ;; error: integer '25' out of range
        rst  31                         ;; error: integer '31' out of range
        rst  33                         ;; error: integer '33' out of range
        rst  39                         ;; error: integer '39' out of range
        rst  41                         ;; error: integer '41' out of range
        rst  47                         ;; error: integer '47' out of range
        rst  49                         ;; error: integer '49' out of range
        rst  55                         ;; error: integer '55' out of range
        rst  57                         ;; error: integer '57' out of range
IF      !RABBIT
ELSE    
ENDIF   
ds:     defs not_defined                ;; error: symbol 'not_defined' not defined
                                        ; BUG_0007
        defs -1                         ;; error: integer '-1' out of range
        defs 65537                      ;; error: integer '65537' out of range
        defs 2,not_defined              ;; error: symbol 'not_defined' not defined
        defs 2,-129                     ;; error: integer '-129' out of range
        defs 2,256                      ;; error: integer '256' out of range
IF      !RABBIT
ENDIF   
IF      !RABBIT
        out  N,a                        ;; error: syntax error
ENDIF   
        call_oz 0                       ;; error: integer '0' out of range
        call_oz 65536                   ;; error: integer '65536' out of range
IF      !RABBIT
        call_pkg -1                     ;; error: integer '-1' out of range
        call_pkg 65536                  ;; error: integer '65536' out of range
ENDIF   
        fpp  0                          ;; error: integer '0' out of range
        fpp  255                        ;; error: integer '255' out of range
        fpp  256                        ;; error: integer '256' out of range
        invoke -1                       ;; error: integer '-1' out of range
        invoke 65536                    ;; error: integer '65536' out of range
END_ASM
);
z80asm(
    options => "-l -b -DRABBIT --RCMX000 -i".z80emu(),
    asm1 => <<'END_ASM',
        public ZERO
        defc ZERO    = 0
END_ASM
    asm  => <<'END_ASM',
;------------------------------------------------------------------------------
; Z88DK Z80 Macro Assembler
;
; Input data for tests, to be parsed by build_opcodes.pl
;
; Copyright (C) Gunther Strube, InterLogic 1993-99
; Copyright (C) Paulo Custodio, 2011-2015
; License: The Artistic License 2.0, http://www.perlfoundation.org/artistic_license_2_0
; Repository: https://github.com/pauloscustodio/z88dk-z80asm
;------------------------------------------------------------------------------

        org  0100h

        extern ZERO

        defc N   = 20h
        defc NN  =  30h
        defc DIS = 40h

;------------------------------------------------------------------------------
; Value ranges
; z80pack is less permissive than z80asm in out of range
;------------------------------------------------------------------------------


; Byte
        ld   a,-128                     ;; 3E 80
        ld   a,-1                       ;; 3E FF
        ld   a,0                        ;; 3E 00
        ld   a,1                        ;; 3E 01
        ld   a,127                      ;; 3E 7F
        ld   a,255                      ;; 3E FF
        ld   a,-129                     ;; warn 2: integer '-129' out of range
                                        ;; 3E 7F
        ld   a,256                      ;; warn 2: integer '256' out of range
                                        ;; 3E 00

; SignedByte
        ld   a,(ix-129)                 ;; warn 2: integer '-129' out of range
                                        ;; DD 7E 7F
        ld   a,(iy-129)                 ;; warn 2: integer '-129' out of range
                                        ;; FD 7E 7F
        ld   a,(ix+128)                 ;; warn 2: integer '128' out of range
                                        ;; DD 7E 80
        ld   a,(iy+128)                 ;; warn 2: integer '128' out of range
                                        ;; FD 7E 80
        ld   a,(ix-128)                 ;; DD 7E 80
        ld   a,(iy-128)                 ;; FD 7E 80
        ld   a,(ix)                     ;; DD 7E 00
        ld   a,(iy)                     ;; FD 7E 00
        ld   a,(ix+0)                   ;; DD 7E 00
        ld   a,(iy+0)                   ;; FD 7E 00
        ld   a,(ix+127)                 ;; DD 7E 7F
        ld   a,(iy+127)                 ;; FD 7E 7F

; Word
        ld   bc,-32768                  ;; 01 00 80
        ld   bc,-1                      ;; 01 FF FF
        ld   bc,0                       ;; 01 00 00
        ld   bc,1                       ;; 01 01 00
        ld   bc,32767                   ;; 01 FF 7F
        ld   bc,65535                   ;; 01 FF FF
        ld   bc,-32769                  ;; warn 2: integer '-32769' out of range
                                        ;; 01 FF 7F
        ld   bc,65536                   ;; warn 2: integer '65536' out of range
                                        ;; 01 00 00

; 32-bit arithmetic, long range is not tested on a 32bit long
        defq 0xFFFFFFFF                 ;; FF FF FF FF
        defq 0xFFFFFFFF+1               ;; 00 00 00 00

; call out of range
        call -32768                     ;; CD 00 80
        call -1                         ;; CD FF FF
        call 0                          ;; CD 00 00
        call 1                          ;; CD 01 00
        call 65535                      ;; CD FF FF
        call -32769                     ;; warn 2: integer '-32769' out of range
                                        ;; CD FF 7F
        call 65536                      ;; warn 2: integer '65536' out of range
                                        ;; CD 00 00

;------------------------------------------------------------------------------
; Expressions
;------------------------------------------------------------------------------
        ld   a,1                        ;; 3E 01
        ld   a,'a'                      ;; 3E 61

.label_1 ld   a,2                       ;; 3E 02
label_2: ld   a,3                       ;; 3E 03

        defw label_1, label_2           ;; 6D 01 6F 01
        defw ZERO+label_1               ;; 6D 01
        defb #label_2-label_1           ;; 02
        defb #ZERO+label_2-label_1      ;; 02

        defb 255,128,0,-128             ;; FF 80 00 80
        defb ZERO+255,ZERO-128          ;; FF 80

        defw 01234h,0FFFFh              ;; 34 12 FF FF
        defw 0,-8000h                   ;; 00 00 00 80
        defw ZERO+0FFFFh,ZERO-8000h     ;; FF FF 00 80

        defq 012345678h,0FFFFFFFFh      ;; 78 56 34 12 FF FF FF FF
        defq 0,-80000000h               ;; 00 00 00 00 00 00 00 80
        defq ZERO+0FFFFFFFFh            ;; FF FF FF FF
        defq ZERO-80000000h             ;; 00 00 00 80

        defb $FF,0xFE,0BEH,0ebh         ;; FF FE BE EB
        defb ZERO+$FF                   ;; FF

        defb @1010,1010B,1010b,0b1010   ;; 0A 0A 0A 0A
        defb ZERO+@1010                 ;; 0A

; example 'A' letter
        defb %00000000                  ;; 00
        defb %00111100                  ;; 3C
        defb %01000010                  ;; 42
        defb %01000010                  ;; 42
        defb %01111110                  ;; 7E
        defb %01000010                  ;; 42
        defb %01000010                  ;; 42
        defb %00000000                  ;; 00

        defb %"--------"                ;; 00
        defb %"--####--"                ;; 3C
        defb %"-#----#-"                ;; 42
        defb %"-#----#-"                ;; 42
        defb %"-######-"                ;; 7E
        defb %"-#----#-"                ;; 42
        defb %"-#----#-"                ;; 42
        defb %"--------"                ;; 00

        defb @00000000                  ;; 00
        defb @00111100                  ;; 3C
        defb @01000010                  ;; 42
        defb @01000010                  ;; 42
        defb @01111110                  ;; 7E
        defb @01000010                  ;; 42
        defb @01000010                  ;; 42
        defb @00000000                  ;; 00

        defb @"--------"                ;; 00
        defb @"--####--"                ;; 3C
        defb @"-#----#-"                ;; 42
        defb @"-#----#-"                ;; 42
        defb @"-######-"                ;; 7E
        defb @"-#----#-"                ;; 42
        defb @"-#----#-"                ;; 42
        defb @"--------"                ;; 00

; BUG_0044: binary constants with more than 8 bits not accepted
        defw %"####---###--##-#"        ;; CD F1
        defw %01111000111001101         ;; CD F1
        defq %"#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-"
                                        ;; AA AA AA AA

        defb 1<0,1<1,1<2                ;; 00 00 01
        defb ZERO+1<0,ZERO+1<1,ZERO+1<2 ;; 00 00 01

        defb 1<=0,1<=1,1<=2             ;; 00 01 01
        defb ZERO+1<=0,ZERO+1<=1,ZERO+1<=2
                                        ;; 00 01 01

        defb 1=0,1=1,1=2                ;; 00 01 00
        defb ZERO+1=0,ZERO+1=1,ZERO+1=2 ;; 00 01 00

        defb 1==0,1==1,1==2             ;; 00 01 00
        defb ZERO+1==0,ZERO+1==1,ZERO+1==2
                                        ;; 00 01 00

        defb 1!=0,1!=1,1!=2             ;; 01 00 01
        defb ZERO+1!=0,ZERO+1!=1,ZERO+1!=2
                                        ;; 01 00 01

        defb 1<>0,1<>1,1<>2             ;; 01 00 01
        defb ZERO+1<>0,ZERO+1<>1,ZERO+1<>2
                                        ;; 01 00 01

        defb 1>0,1>1,1>2                ;; 01 00 00
        defb ZERO+1>0,ZERO+1>1,ZERO+1>2 ;; 01 00 00
        defb 1>=0,1>=1,1>=2             ;; 01 01 00
        defb ZERO+1>=0,ZERO+1>=1,ZERO+1>=2
                                        ;; 01 01 00
        defb +1,-1                      ;; 01 FF
        defb ZERO++1,ZERO+-1            ;; 01 FF


        defb 1+1,3-1                    ;; 02 02
        defb ZERO+1+1,ZERO+3-1          ;; 02 02

        defb 3&2,2|0,0^2                ;; 02 02 02
        defb ZERO+3&2,ZERO+2|0,ZERO+0^2 ;; 02 02 02

        defb (~0xAA)&0xFF               ;; 55
        defb ZERO+(~0xAA)&0xFF          ;; 55

        defb 5*2,100/10,10%3            ;; 0A 0A 01
        defb ZERO+5*2,ZERO+100/10,ZERO+10%3
                                        ;; 0A 0A 01

; BUG_0040: Detect and report division by zero instead of crashing

        defb 2**7,2**6                  ;; 80 40
        defb ZERO+2**7,ZERO+2**6        ;; 80 40

        defb 2**1,2**0                  ;; 02 01
        defb ZERO+2**1,ZERO+2**0        ;; 02 01

; BUG_0041: truncate negative powers to zero, i.e. pow(2,-1) == 0
        defb 2**-1                      ;; 00
        defb ZERO+2**-1                 ;; 00

        defb 2*[1+2*(1+2)]              ;; 0E
        defb ZERO+2*[1+2*(1+2)]         ;; 0E

        defb 2*1+2*1+2                  ;; 06
        defb ZERO+2*1+2*1+2             ;; 06

        defb !0,!1                      ;; 01 00
        defb ZERO+!0,ZERO+!1            ;; 01 00

        defb 0&&0,0&&1,1&&0,1&&1        ;; 00 00 00 01
        defb ZERO+0&&0,ZERO+0&&1,ZERO+1&&0,ZERO+1&&1
                                        ;; 00 00 00 01

        defb 0||0,0||1,1||0,1||1        ;; 00 01 01 01
        defb ZERO+0||0,ZERO+0||1,ZERO+1||0,ZERO+1||1
                                        ;; 00 01 01 01

        defb 0||0||1,0||0||0            ;; 01 00
        defb ZERO+0||0||1,ZERO+0||0||0  ;; 01 00

        defb ' '                        ;; 20
        defb ZERO+' '                   ;; 20

        defb 1<<7,128>>7                ;; 80 01
        defb ZERO+1<<7,ZERO+128>>7      ;; 80 01

        defb 1?2:3,0?4:5                ;; 02 05
        defb ZERO+1?2:3,ZERO+0?4:5      ;; 02 05


; EACH was interpreted as 0x0EAC - fixed
EACH:   djnz EACH                       ;; 10 FE

; check priorities
        defb 1 || 0 && 0                ;; 01
        defb 0 && 0 |  1                ;; 00
        defb 0 && 0 ^  1                ;; 00
        defb 0 |  1 &  1                ;; 01
        defb 1 ^  0 &  0                ;; 01
        defb 0 &  1 == 0                ;; 00
        defb 0 &  0 != 1                ;; 00
        defb 2 == 1 << 1                ;; 01
        defb 1 << 1 +  3                ;; 10
        defb 1 +  2 *  3                ;; 07
        defb 2 *  3 ** 4                ;; A2
        defw 2 ** 3 ** 2                ;; 00 02
        defb 2 ** -3                    ;; 00
        defb ---+--+-2                  ;; 02
        defb 1 ? 2 : 3, 0 ? 4 : 5       ;; 02 05
        defb 0 ? 0 ? 2 : 3 : 0 ? 4 : 5  ;; 05
        defb 0 ? 0 ? 2 : 3 : 1 ? 4 : 5  ;; 04
        defb 1 ? 0 ? 2 : 3 : 1 ? 4 : 5  ;; 03
        defb 1 ? 1 ? 2 : 3 : 1 ? 4 : 5  ;; 02
        defb ~~2                        ;; 02

; BUG_0043: buffer overflow on constants longer than 128 chars in object file
        defw ZERO+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1+1
                                        ;; E8 03

;------------------------------------------------------------------------------
; DEFB, DEFW, DEFQ
;------------------------------------------------------------------------------

        defb 1,2,3,4,5,6,7,8,10,11,12,13,14,15,16,17,18,19,20,'!'
                                        ;; 01 02 03 04 05 06 07 08 0A 0B 0C 0D 0E 0F 10 11 12 13 14 21
        defw 1,2,3,4,5,6,7,8,10,11,12,13,14,15,16,17,18,19,20,'!'
                                        ;; 01 00 02 00 03 00 04 00 05 00 06 00 07 00 08 00 0A 00 0B 00 0C 00 0D 00 0E 00 0F 00 10 00 11 00 12 00 13 00 14 00 21 00
        defb "ABCDEFGHIJKLMNOPQRSTUVWXYZ"
                                        ;; 41 42 43 44 45 46 47 48 49 4A 4B 4C 4D 4E 4F 50 51 52 53 54 55 56 57 58 59 5A
        defw 0,102h,203h,304h           ;; 00 00 02 01 03 02 04 03
        defq 0,1020304h,5060708h        ;; 00 00 00 00 04 03 02 01 08 07 06 05

        defm "hello",32,"","world"      ;; 68 65 6C 6C 6F 20 77 6F 72 6C 64
        defm "hello",ZERO+32,"","world" ;; 68 65 6C 6C 6F 20 77 6F 72 6C 64
        defm 32,"world"                 ;; 20 77 6F 72 6C 64


;------------------------------------------------------------------------------
; 8 bit load group
;------------------------------------------------------------------------------

        ld   b,b                        ;; 40
        ld   c,b                        ;; 48
        ld   d,b                        ;; 50
        ld   e,b                        ;; 58
        ld   h,b                        ;; 60
        ld   l,b                        ;; 68
        ld   a,b                        ;; 78
        ld   b,c                        ;; 41
        ld   c,c                        ;; 49
        ld   d,c                        ;; 51
        ld   e,c                        ;; 59
        ld   h,c                        ;; 61
        ld   l,c                        ;; 69
        ld   a,c                        ;; 79
        ld   b,d                        ;; 42
        ld   c,d                        ;; 4A
        ld   d,d                        ;; 52
        ld   e,d                        ;; 5A
        ld   h,d                        ;; 62
        ld   l,d                        ;; 6A
        ld   a,d                        ;; 7A
        ld   b,e                        ;; 43
        ld   c,e                        ;; 4B
        ld   d,e                        ;; 53
        ld   e,e                        ;; 5B
        ld   h,e                        ;; 63
        ld   l,e                        ;; 6B
        ld   a,e                        ;; 7B
        ld   b,h                        ;; 44
        ld   c,h                        ;; 4C
        ld   d,h                        ;; 54
        ld   e,h                        ;; 5C
        ld   h,h                        ;; 64
        ld   l,h                        ;; 6C
        ld   a,h                        ;; 7C
        ld   b,l                        ;; 45
        ld   c,l                        ;; 4D
        ld   d,l                        ;; 55
        ld   e,l                        ;; 5D
        ld   h,l                        ;; 65
        ld   l,l                        ;; 6D
        ld   a,l                        ;; 7D
        ld   b,a                        ;; 47
        ld   c,a                        ;; 4F
        ld   d,a                        ;; 57
        ld   e,a                        ;; 5F
        ld   h,a                        ;; 67
        ld   l,a                        ;; 6F
        ld   a,a                        ;; 7F
        ld   b,N                        ;; 06 20
        ld   c,N                        ;; 0E 20
        ld   d,N                        ;; 16 20
        ld   e,N                        ;; 1E 20
        ld   h,N                        ;; 26 20
        ld   l,N                        ;; 2E 20
        ld   a,N                        ;; 3E 20

IF      !RABBIT
        ld   b,ixh
        ld   c,ixh
        ld   d,ixh
        ld   e,ixh
        ld   ixh,ixh
        ld   ixl,ixh
        ld   a,ixh
        ld   b,ixl
        ld   c,ixl
        ld   d,ixl
        ld   e,ixl
        ld   ixh,ixl
        ld   ixl,ixl
        ld   a,ixl
        ld   ixh,b
        ld   ixl,b
        ld   ixh,c
        ld   ixl,c
        ld   ixh,d
        ld   ixl,d
        ld   ixh,e
        ld   ixl,e
        ld   ixh,ixh
        ld   ixl,ixh
        ld   ixh,ixl
        ld   ixl,ixl
        ld   ixh,a
        ld   ixl,a
        ld   ixh,N
        ld   ixl,N

        ld   b,iyh
        ld   c,iyh
        ld   d,iyh
        ld   e,iyh
        ld   iyh,iyh
        ld   iyl,iyh
        ld   a,iyh
        ld   b,iyl
        ld   c,iyl
        ld   d,iyl
        ld   e,iyl
        ld   iyh,iyl
        ld   iyl,iyl
        ld   a,iyl
        ld   iyh,b
        ld   iyl,b
        ld   iyh,c
        ld   iyl,c
        ld   iyh,d
        ld   iyl,d
        ld   iyh,e
        ld   iyl,e
        ld   iyh,iyh
        ld   iyl,iyh
        ld   iyh,iyl
        ld   iyl,iyl
        ld   iyh,a
        ld   iyl,a
        ld   iyh,N
        ld   iyl,N
ELSE    

ENDIF   

        ld   b,(hl)                     ;; 46
        ld   c,(hl)                     ;; 4E
        ld   d,(hl)                     ;; 56
        ld   e,(hl)                     ;; 5E
        ld   h,(hl)                     ;; 66
        ld   l,(hl)                     ;; 6E
        ld   a,(hl)                     ;; 7E
; ldi b,(hl)   ;;  ld b,(hl) ;; inc hl
; ldi c,(hl)   ;;  ld c,(hl) ;; inc hl
; ldi d,(hl)   ;;  ld d,(hl) ;; inc hl
; ldi e,(hl)   ;;  ld e,(hl) ;; inc hl
; ldi h,(hl)   ;;  ld h,(hl) ;; inc hl
; ldi l,(hl)   ;;  ld l,(hl) ;; inc hl
; ldi a,(hl)   ;;  ld a,(hl) ;; inc hl
; ldd b,(hl)   ;;  ld b,(hl) ;; dec hl
; ldd c,(hl)   ;;  ld c,(hl) ;; dec hl
; ldd d,(hl)   ;;  ld d,(hl) ;; dec hl
; ldd e,(hl)   ;;  ld e,(hl) ;; dec hl
; ldd h,(hl)   ;;  ld h,(hl) ;; dec hl
; ldd l,(hl)   ;;  ld l,(hl) ;; dec hl
; ldd a,(hl)   ;;  ld a,(hl) ;; dec hl

        ld   b,(ix+DIS)                 ;; DD 46 40
        ld   c,(ix+DIS)                 ;; DD 4E 40
        ld   d,(ix+DIS)                 ;; DD 56 40
        ld   e,(ix+DIS)                 ;; DD 5E 40
        ld   h,(ix+DIS)                 ;; DD 66 40
        ld   l,(ix+DIS)                 ;; DD 6E 40
        ld   a,(ix+DIS)                 ;; DD 7E 40
        ld   b,(iy+DIS)                 ;; FD 46 40
        ld   c,(iy+DIS)                 ;; FD 4E 40
        ld   d,(iy+DIS)                 ;; FD 56 40
        ld   e,(iy+DIS)                 ;; FD 5E 40
        ld   h,(iy+DIS)                 ;; FD 66 40
        ld   l,(iy+DIS)                 ;; FD 6E 40
        ld   a,(iy+DIS)                 ;; FD 7E 40
; ldi b,(ix+DIS) ;; ld b,(ix+DIS) ;; inc ix
; ldi c,(ix+DIS) ;; ld c,(ix+DIS) ;; inc ix
; ldi d,(ix+DIS) ;; ld d,(ix+DIS) ;; inc ix
; ldi e,(ix+DIS) ;; ld e,(ix+DIS) ;; inc ix
; ldi h,(ix+DIS) ;; ld h,(ix+DIS) ;; inc ix
; ldi l,(ix+DIS) ;; ld l,(ix+DIS) ;; inc ix
; ldi a,(ix+DIS) ;; ld a,(ix+DIS) ;; inc ix
; ldi b,(iy+DIS) ;; ld b,(iy+DIS) ;; inc iy
; ldi c,(iy+DIS) ;; ld c,(iy+DIS) ;; inc iy
; ldi d,(iy+DIS) ;; ld d,(iy+DIS) ;; inc iy
; ldi e,(iy+DIS) ;; ld e,(iy+DIS) ;; inc iy
; ldi h,(iy+DIS) ;; ld h,(iy+DIS) ;; inc iy
; ldi l,(iy+DIS) ;; ld l,(iy+DIS) ;; inc iy
; ldi a,(iy+DIS) ;; ld a,(iy+DIS) ;; inc iy
; ldd b,(ix+DIS) ;; ld b,(ix+DIS) ;; dec ix
; ldd c,(ix+DIS) ;; ld c,(ix+DIS) ;; dec ix
; ldd d,(ix+DIS) ;; ld d,(ix+DIS) ;; dec ix
; ldd e,(ix+DIS) ;; ld e,(ix+DIS) ;; dec ix
; ldd h,(ix+DIS) ;; ld h,(ix+DIS) ;; dec ix
; ldd l,(ix+DIS) ;; ld l,(ix+DIS) ;; dec ix
; ldd a,(ix+DIS) ;; ld a,(ix+DIS) ;; dec ix
; ldd b,(iy+DIS) ;; ld b,(iy+DIS) ;; dec iy
; ldd c,(iy+DIS) ;; ld c,(iy+DIS) ;; dec iy
; ldd d,(iy+DIS) ;; ld d,(iy+DIS) ;; dec iy
; ldd e,(iy+DIS) ;; ld e,(iy+DIS) ;; dec iy
; ldd h,(iy+DIS) ;; ld h,(iy+DIS) ;; dec iy
; ldd l,(iy+DIS) ;; ld l,(iy+DIS) ;; dec iy
; ldd a,(iy+DIS) ;; ld a,(iy+DIS) ;; dec iy

        ld   (hl),b                     ;; 70
        ld   (hl),c                     ;; 71
        ld   (hl),d                     ;; 72
        ld   (hl),e                     ;; 73
        ld   (hl),h                     ;; 74
        ld   (hl),l                     ;; 75
        ld   (hl),a                     ;; 77
; ldi (hl),b   ;;  ld (hl),b ;; inc hl
; ldi (hl),c   ;;  ld (hl),c ;; inc hl
; ldi (hl),d   ;;  ld (hl),d ;; inc hl
; ldi (hl),e   ;;  ld (hl),e ;; inc hl
; ldi (hl),h   ;;  ld (hl),h ;; inc hl
; ldi (hl),l   ;;  ld (hl),l ;; inc hl
; ldi (hl),a   ;;  ld (hl),a ;; inc hl
; ldd (hl),b   ;;  ld (hl),b ;; dec hl
; ldd (hl),c   ;;  ld (hl),c ;; dec hl
; ldd (hl),d   ;;  ld (hl),d ;; dec hl
; ldd (hl),e   ;;  ld (hl),e ;; dec hl
; ldd (hl),h   ;;  ld (hl),h ;; dec hl
; ldd (hl),l   ;;  ld (hl),l ;; dec hl
; ldd (hl),a   ;;  ld (hl),a ;; dec hl

        ld   (ix+DIS),b                 ;; DD 70 40
        ld   (iy+DIS),b                 ;; FD 70 40
        ld   (ix+DIS),c                 ;; DD 71 40
        ld   (iy+DIS),c                 ;; FD 71 40
        ld   (ix+DIS),d                 ;; DD 72 40
        ld   (iy+DIS),d                 ;; FD 72 40
        ld   (ix+DIS),e                 ;; DD 73 40
        ld   (iy+DIS),e                 ;; FD 73 40
        ld   (ix+DIS),h                 ;; DD 74 40
        ld   (iy+DIS),h                 ;; FD 74 40
        ld   (ix+DIS),l                 ;; DD 75 40
        ld   (iy+DIS),l                 ;; FD 75 40
        ld   (ix+DIS),a                 ;; DD 77 40
        ld   (iy+DIS),a                 ;; FD 77 40
; ldi (ix+DIS),b ;; ld (ix+DIS),b ;; inc ix
; ldi (iy+DIS),b ;; ld (iy+DIS),b ;; inc iy
; ldi (ix+DIS),c ;; ld (ix+DIS),c ;; inc ix
; ldi (iy+DIS),c ;; ld (iy+DIS),c ;; inc iy
; ldi (ix+DIS),d ;; ld (ix+DIS),d ;; inc ix
; ldi (iy+DIS),d ;; ld (iy+DIS),d ;; inc iy
; ldi (ix+DIS),e ;; ld (ix+DIS),e ;; inc ix
; ldi (iy+DIS),e ;; ld (iy+DIS),e ;; inc iy
; ldi (ix+DIS),h ;; ld (ix+DIS),h ;; inc ix
; ldi (iy+DIS),h ;; ld (iy+DIS),h ;; inc iy
; ldi (ix+DIS),l ;; ld (ix+DIS),l ;; inc ix
; ldi (iy+DIS),l ;; ld (iy+DIS),l ;; inc iy
; ldi (ix+DIS),a ;; ld (ix+DIS),a ;; inc ix
; ldi (iy+DIS),a ;; ld (iy+DIS),a ;; inc iy
; ldd (ix+DIS),b ;; ld (ix+DIS),b ;; dec ix
; ldd (iy+DIS),b ;; ld (iy+DIS),b ;; dec iy
; ldd (ix+DIS),c ;; ld (ix+DIS),c ;; dec ix
; ldd (iy+DIS),c ;; ld (iy+DIS),c ;; dec iy
; ldd (ix+DIS),d ;; ld (ix+DIS),d ;; dec ix
; ldd (iy+DIS),d ;; ld (iy+DIS),d ;; dec iy
; ldd (ix+DIS),e ;; ld (ix+DIS),e ;; dec ix
; ldd (iy+DIS),e ;; ld (iy+DIS),e ;; dec iy
; ldd (ix+DIS),h ;; ld (ix+DIS),h ;; dec ix
; ldd (iy+DIS),h ;; ld (iy+DIS),h ;; dec iy
; ldd (ix+DIS),l ;; ld (ix+DIS),l ;; dec ix
; ldd (iy+DIS),l ;; ld (iy+DIS),l ;; dec iy
; ldd (ix+DIS),a ;; ld (ix+DIS),a ;; dec ix
; ldd (iy+DIS),a ;; ld (iy+DIS),a ;; dec iy

        ld   (hl),N                     ;; 36 20
; ldi (hl),N       ;; ld (hl),N ;; inc hl
; ldd (hl),N       ;; ld (hl),N ;; dec hl

        ld   (ix+DIS),N                 ;; DD 36 40 20
        ld   (iy+DIS),N                 ;; FD 36 40 20
; ldi (ix+DIS),N     ;; ld (ix+DIS),N ;; inc ix
; ldi (iy+DIS),N     ;; ld (iy+DIS),N ;; inc iy
; ldd (ix+DIS),N     ;; ld (ix+DIS),N ;; dec ix
; ldd (iy+DIS),N     ;; ld (iy+DIS),N ;; dec iy

        ld   a,(bc)                     ;; 0A
        ld   a,(de)                     ;; 1A
; ldi a,(bc)      ;; ld a,(bc) ;; inc bc
; ldi a,(de)      ;; ld a,(de) ;; inc de
; ldd a,(bc)      ;; ld a,(bc) ;; dec bc
; ldd a,(de)      ;; ld a,(de) ;; dec de

        ld   (bc),a                     ;; 02
        ld   (de),a                     ;; 12
; ldi (bc),a      ;; ld (bc),a ;; inc bc
; ldi (de),a      ;; ld (de),a ;; inc de
; ldd (bc),a      ;; ld (bc),a ;; dec bc
; ldd (de),a      ;; ld (de),a ;; dec de

        ld   a,(NN)                     ;; 3A 30 00
        ld   (NN),a                     ;; 32 30 00


IF      !RABBIT
        ld   i,a
        ld   r,a
        ld   a,i
        ld   a,r
ELSE    
        ld   iir,a                      ;; ED 47
        ld   eir,a                      ;; ED 4F
        ld   a,iir                      ;; ED 57
        ld   a,eir                      ;; ED 5F
ENDIF   

;------------------------------------------------------------------------------
; 16 bit load group
;------------------------------------------------------------------------------

        ld   bc,NN                      ;; 01 30 00
        ld   de,NN                      ;; 11 30 00
        ld   hl,NN                      ;; 21 30 00
        ld   ix,NN                      ;; DD 21 30 00
        ld   iy,NN                      ;; FD 21 30 00
        ld   sp,NN                      ;; 31 30 00
        ld   bc,(NN)                    ;; ED 4B 30 00
        ld   de,(NN)                    ;; ED 5B 30 00
        ld   hl,(NN)                    ;; 2A 30 00
        ld   ix,(NN)                    ;; DD 2A 30 00
        ld   iy,(NN)                    ;; FD 2A 30 00
        ld   sp,(NN)                    ;; ED 7B 30 00
        ld   (NN),bc                    ;; ED 43 30 00
        ld   (NN),de                    ;; ED 53 30 00
        ld   (NN),hl                    ;; 22 30 00
        ld   (NN),ix                    ;; DD 22 30 00
        ld   (NN),iy                    ;; FD 22 30 00
        ld   (NN),sp                    ;; ED 73 30 00
        ld   sp,hl                      ;; F9
        ld   sp,ix                      ;; DD F9
        ld   sp,iy                      ;; FD F9
        push bc                         ;; C5
        push de                         ;; D5
        push hl                         ;; E5
        push ix                         ;; DD E5
        push iy                         ;; FD E5
        push af                         ;; F5
        pop  bc                         ;; C1
        pop  de                         ;; D1
        pop  hl                         ;; E1
        pop  ix                         ;; DD E1
        pop  iy                         ;; FD E1
        pop  af                         ;; F1

; ld bc,bc =}      0x40+<1:3>+<2>      0x49+<1:3>+<2>
; ld de,bc =}      0x40+<1:3>+<2>      0x49+<1:3>+<2>
; ld hl,bc =}      0x40+<1:3>+<2>      0x49+<1:3>+<2>
; ld bc,de =}      0x40+<1:3>+<2>      0x49+<1:3>+<2>
; ld de,de =}      0x40+<1:3>+<2>      0x49+<1:3>+<2>
; ld hl,de =}      0x40+<1:3>+<2>      0x49+<1:3>+<2>
; ld bc,hl =}      0x40+<1:3>+<2>      0x49+<1:3>+<2>
; ld de,hl =}      0x40+<1:3>+<2>      0x49+<1:3>+<2>
; ld hl,hl =}      0x40+<1:3>+<2>      0x49+<1:3>+<2>
; ld bc,ix    =} 0xDD 0x44+<1:3>     0xDD 0x4D+<1:3>
; ld de,ix    =} 0xDD 0x44+<1:3>     0xDD 0x4D+<1:3>
; ld bc,iy    =} 0xFD 0x44+<1:3>     0xFD 0x4D+<1:3>
; ld de,iy    =} 0xFD 0x44+<1:3>     0xFD 0x4D+<1:3>
;
; ld bc,(hl)    =}      0x4E+<1:3> 0x23     0x46+<1:3> 0x2B
; ld de,(hl)    =}      0x4E+<1:3> 0x23     0x46+<1:3> 0x2B
; ldi bc,(hl)    =}      0x4E+<1:3> 0x23     0x46+<1:3> 0x23
; ldi de,(hl)    =}      0x4E+<1:3> 0x23     0x46+<1:3> 0x23
;
; ld bc,(ix+DIS)  =} 0xDD 0x4E+<1:3> DIS           0xDD 0x46+<1:3> DIS+1
; ld de,(ix+DIS)  =} 0xDD 0x4E+<1:3> DIS           0xDD 0x46+<1:3> DIS+1
; ld hl,(ix+DIS)  =} 0xDD 0x4E+<1:3> DIS           0xDD 0x46+<1:3> DIS+1
; ldi bc,(ix+DIS)  =} 0xDD 0x4E+<1:3> DIS 0xDD 0x23 0xDD 0x46+<1:3> DIS 0xDD 0x23
; ldi de,(ix+DIS)  =} 0xDD 0x4E+<1:3> DIS 0xDD 0x23 0xDD 0x46+<1:3> DIS 0xDD 0x23
; ldi hl,(ix+DIS)  =} 0xDD 0x4E+<1:3> DIS 0xDD 0x23 0xDD 0x46+<1:3> DIS 0xDD 0x23
;
; ld bc,(iy+DIS)  =} 0xFD 0x4E+<1:3> DIS           0xFD 0x46+<1:3> DIS+1
; ld de,(iy+DIS)  =} 0xFD 0x4E+<1:3> DIS           0xFD 0x46+<1:3> DIS+1
; ld hl,(iy+DIS)  =} 0xFD 0x4E+<1:3> DIS           0xFD 0x46+<1:3> DIS+1
; ldi bc,(iy+DIS)  =} 0xFD 0x4E+<1:3> DIS 0xFD 0x23 0xFD 0x46+<1:3> DIS 0xFD 0x23
; ldi de,(iy+DIS)  =} 0xFD 0x4E+<1:3> DIS 0xFD 0x23 0xFD 0x46+<1:3> DIS 0xFD 0x23
; ldi hl,(iy+DIS)  =} 0xFD 0x4E+<1:3> DIS 0xFD 0x23 0xFD 0x46+<1:3> DIS 0xFD 0x23
;
; ld  (hl),bc    =}      0x71+<2> 0x23     0x70+<2> 0x2B
; ld  (hl),de    =}      0x71+<2> 0x23     0x70+<2> 0x2B
; ldi (hl),bc    =}      0x71+<2> 0x23     0x70+<2> 0x23
; ldi (hl),de    =}      0x71+<2> 0x23     0x70+<2> 0x23
;
; ld  (ix+DIS),bc  =} 0xDD 0x71+<2> DIS           0xDD 0x70+<2> DIS+1
; ld  (ix+DIS),de  =} 0xDD 0x71+<2> DIS           0xDD 0x70+<2> DIS+1
; ld  (ix+DIS),hl  =} 0xDD 0x71+<2> DIS           0xDD 0x70+<2> DIS+1
; ldi (ix+DIS),bc  =} 0xDD 0x71+<2> DIS 0xDD 0x23 0xDD 0x70+<2> DIS 0xDD 0x23
; ldi (ix+DIS),de  =} 0xDD 0x71+<2> DIS 0xDD 0x23 0xDD 0x70+<2> DIS 0xDD 0x23
; ldi (ix+DIS),hl  =} 0xDD 0x71+<2> DIS 0xDD 0x23 0xDD 0x70+<2> DIS 0xDD 0x23
;
; ld  (iy+DIS),bc  =} 0xFD 0x71+<2> DIS 0xFD 0x70+<2> DIS+1
; ld  (iy+DIS),de  =} 0xFD 0x71+<2> DIS 0xFD 0x70+<2> DIS+1
; ld  (iy+DIS),hl  =} 0xFD 0x71+<2> DIS 0xFD 0x70+<2> DIS+1
; ldi (iy+DIS),bc  =} 0xFD 0x71+<2> DIS 0xFD 0x23 0xFD 0x70+<2> DIS 0xFD 0x23
; ldi (iy+DIS),de  =} 0xFD 0x71+<2> DIS 0xFD 0x23 0xFD 0x70+<2> DIS 0xFD 0x23
; ldi (iy+DIS),hl  =} 0xFD 0x71+<2> DIS 0xFD 0x23 0xFD 0x70+<2> DIS 0xFD 0x23
;
; ld  hl,ix      =} 0xDD 0xE5 0xE1
; ld  hl,iy      =} 0xFD 0xE5 0xE1
;
; ld ix,bc    =} 0xDD 0x69+<2>       0xDD 0x60+<2>
; ld ix,de    =} 0xDD 0x69+<2>       0xDD 0x60+<2>
; ld iy,bc    =} 0xFD 0x69+<2>       0xFD 0x60+<2>
; ld iy,de    =} 0xFD 0x69+<2>       0xFD 0x60+<2>
;
; ld ix,hl      =} 0xE5 0xDD 0xE1
; ld iy,hl      =} 0xE5 0xFD 0xE1
;
; ld ix,ix      =} 0xDD 0x6D 0xDD 0x64
; ld ix,iy      =} 0xFD 0xE5 0xDD 0xE1
;
; ld iy,iy      =} 0xFD 0x6D 0xFD 0x64
; ld iy,ix      =} 0xDD 0xE5 0xFD 0xE1

;------------------------------------------------------------------------------
; Exchange, block transfer, search group
;------------------------------------------------------------------------------

        ex   de,hl                      ;; EB
        ex   af,af                      ;; 08
        ex   af,af'                     ;; 08
        exx                             ;; D9

IF      !RABBIT
        ex   (sp),hl
ELSE    
        ex   (sp),hl                    ;; ED 54
ENDIF   
        ex   (sp),ix                    ;; DD E3
        ex   (sp),iy                    ;; FD E3

        ldi                             ;; ED A0
        ldir                            ;; ED B0
        ldd                             ;; ED A8
        lddr                            ;; ED B8

IF      !RABBIT
        cpi
        cpir
        cpd
        cpdr
ELSE    
        cpi                             ;; CD 72 0A
        cpir                            ;; CD 8F 0A
        cpd                             ;; CD 29 0A
        cpdr                            ;; CD 46 0A
ENDIF   

;------------------------------------------------------------------------------
; 8 bit arithmetic and logical group
;------------------------------------------------------------------------------

        add  a,b                        ;; 80
        adc  a,b                        ;; 88
        sbc  a,b                        ;; 98
        add  a,c                        ;; 81
        adc  a,c                        ;; 89
        sbc  a,c                        ;; 99
        add  a,d                        ;; 82
        adc  a,d                        ;; 8A
        sbc  a,d                        ;; 9A
        add  a,e                        ;; 83
        adc  a,e                        ;; 8B
        sbc  a,e                        ;; 9B
        add  a,h                        ;; 84
        adc  a,h                        ;; 8C
        sbc  a,h                        ;; 9C
        add  a,l                        ;; 85
        adc  a,l                        ;; 8D
        sbc  a,l                        ;; 9D
        add  a,a                        ;; 87
        adc  a,a                        ;; 8F
        sbc  a,a                        ;; 9F
        add  a,(hl)                     ;; 86
        adc  a,(hl)                     ;; 8E
        sbc  a,(hl)                     ;; 9E
        add  a,(ix+DIS)                 ;; DD 86 40
        adc  a,(ix+DIS)                 ;; DD 8E 40
        sbc  a,(ix+DIS)                 ;; DD 9E 40
        add  a,(iy+DIS)                 ;; FD 86 40
        adc  a,(iy+DIS)                 ;; FD 8E 40
        sbc  a,(iy+DIS)                 ;; FD 9E 40
        add  a,N                        ;; C6 20
        adc  a,N                        ;; CE 20
        sbc  a,N                        ;; DE 20
        add  b                          ;; 80
        adc  b                          ;; 88
        sbc  b                          ;; 98
        add  c                          ;; 81
        adc  c                          ;; 89
        sbc  c                          ;; 99
        add  d                          ;; 82
        adc  d                          ;; 8A
        sbc  d                          ;; 9A
        add  e                          ;; 83
        adc  e                          ;; 8B
        sbc  e                          ;; 9B
        add  h                          ;; 84
        adc  h                          ;; 8C
        sbc  h                          ;; 9C
        add  l                          ;; 85
        adc  l                          ;; 8D
        sbc  l                          ;; 9D
        add  a                          ;; 87
        adc  a                          ;; 8F
        sbc  a                          ;; 9F
        add  (hl)                       ;; 86
        adc  (hl)                       ;; 8E
        sbc  (hl)                       ;; 9E
        add  (ix+DIS)                   ;; DD 86 40
        adc  (ix+DIS)                   ;; DD 8E 40
        sbc  (ix+DIS)                   ;; DD 9E 40
        add  (iy+DIS)                   ;; FD 86 40
        adc  (iy+DIS)                   ;; FD 8E 40
        sbc  (iy+DIS)                   ;; FD 9E 40
        add  N                          ;; C6 20
        adc  N                          ;; CE 20
        sbc  N                          ;; DE 20

        sub  b                          ;; 90
        and  b                          ;; A0
        xor  b                          ;; A8
        or   b                          ;; B0
        cp   b                          ;; B8
        sub  c                          ;; 91
        and  c                          ;; A1
        xor  c                          ;; A9
        or   c                          ;; B1
        cp   c                          ;; B9
        sub  d                          ;; 92
        and  d                          ;; A2
        xor  d                          ;; AA
        or   d                          ;; B2
        cp   d                          ;; BA
        sub  e                          ;; 93
        and  e                          ;; A3
        xor  e                          ;; AB
        or   e                          ;; B3
        cp   e                          ;; BB
        sub  h                          ;; 94
        and  h                          ;; A4
        xor  h                          ;; AC
        or   h                          ;; B4
        cp   h                          ;; BC
        sub  l                          ;; 95
        and  l                          ;; A5
        xor  l                          ;; AD
        or   l                          ;; B5
        cp   l                          ;; BD
        sub  a                          ;; 97
        and  a                          ;; A7
        xor  a                          ;; AF
        or   a                          ;; B7
        cp   a                          ;; BF
        sub  (hl)                       ;; 96
        and  (hl)                       ;; A6
        xor  (hl)                       ;; AE
        or   (hl)                       ;; B6
        cp   (hl)                       ;; BE
        sub  (ix+DIS)                   ;; DD 96 40
        and  (ix+DIS)                   ;; DD A6 40
        xor  (ix+DIS)                   ;; DD AE 40
        or   (ix+DIS)                   ;; DD B6 40
        cp   (ix+DIS)                   ;; DD BE 40
        sub  (iy+DIS)                   ;; FD 96 40
        and  (iy+DIS)                   ;; FD A6 40
        xor  (iy+DIS)                   ;; FD AE 40
        or   (iy+DIS)                   ;; FD B6 40
        cp   (iy+DIS)                   ;; FD BE 40
        sub  N                          ;; D6 20
        and  N                          ;; E6 20
        xor  N                          ;; EE 20
        or   N                          ;; F6 20
        cp   N                          ;; FE 20
        sub  a,b                        ;; 90
        and  a,b                        ;; A0
        xor  a,b                        ;; A8
        or   a,b                        ;; B0
        cp   a,b                        ;; B8
        sub  a,c                        ;; 91
        and  a,c                        ;; A1
        xor  a,c                        ;; A9
        or   a,c                        ;; B1
        cp   a,c                        ;; B9
        sub  a,d                        ;; 92
        and  a,d                        ;; A2
        xor  a,d                        ;; AA
        or   a,d                        ;; B2
        cp   a,d                        ;; BA
        sub  a,e                        ;; 93
        and  a,e                        ;; A3
        xor  a,e                        ;; AB
        or   a,e                        ;; B3
        cp   a,e                        ;; BB
        sub  a,h                        ;; 94
        and  a,h                        ;; A4
        xor  a,h                        ;; AC
        or   a,h                        ;; B4
        cp   a,h                        ;; BC
        sub  a,l                        ;; 95
        and  a,l                        ;; A5
        xor  a,l                        ;; AD
        or   a,l                        ;; B5
        cp   a,l                        ;; BD
        sub  a,a                        ;; 97
        and  a,a                        ;; A7
        xor  a,a                        ;; AF
        or   a,a                        ;; B7
        cp   a,a                        ;; BF
        sub  a,(hl)                     ;; 96
        and  a,(hl)                     ;; A6
        xor  a,(hl)                     ;; AE
        or   a,(hl)                     ;; B6
        cp   a,(hl)                     ;; BE
        sub  a,(ix+DIS)                 ;; DD 96 40
        and  a,(ix+DIS)                 ;; DD A6 40
        xor  a,(ix+DIS)                 ;; DD AE 40
        or   a,(ix+DIS)                 ;; DD B6 40
        cp   a,(ix+DIS)                 ;; DD BE 40
        sub  a,(iy+DIS)                 ;; FD 96 40
        and  a,(iy+DIS)                 ;; FD A6 40
        xor  a,(iy+DIS)                 ;; FD AE 40
        or   a,(iy+DIS)                 ;; FD B6 40
        cp   a,(iy+DIS)                 ;; FD BE 40
        sub  a,N                        ;; D6 20
        and  a,N                        ;; E6 20
        xor  a,N                        ;; EE 20
        or   a,N                        ;; F6 20
        cp   a,N                        ;; FE 20

        inc  b                          ;; 04
        dec  b                          ;; 05
        inc  c                          ;; 0C
        dec  c                          ;; 0D
        inc  d                          ;; 14
        dec  d                          ;; 15
        inc  e                          ;; 1C
        dec  e                          ;; 1D
        inc  h                          ;; 24
        dec  h                          ;; 25
        inc  l                          ;; 2C
        dec  l                          ;; 2D
        inc  a                          ;; 3C
        dec  a                          ;; 3D
        inc  (hl)                       ;; 34
        dec  (hl)                       ;; 35
        inc  (ix+DIS)                   ;; DD 34 40
        dec  (ix+DIS)                   ;; DD 35 40
        inc  (iy+DIS)                   ;; FD 34 40
        dec  (iy+DIS)                   ;; FD 35 40

IF      !RABBIT
        add  a,ixh
        adc  a,ixh
        sbc  a,ixh
        add  a,iyh
        adc  a,iyh
        sbc  a,iyh
        add  a,ixl
        adc  a,ixl
        sbc  a,ixl
        add  a,iyl
        adc  a,iyl
        sbc  a,iyl
        add  ixh
        adc  ixh
        sbc  ixh
        add  iyh
        adc  iyh
        sbc  iyh
        add  ixl
        adc  ixl
        sbc  ixl
        add  iyl
        adc  iyl
        sbc  iyl
        sub  ixh
        and  ixh
        xor  ixh
        or   ixh
        cp   ixh
        sub  iyh
        and  iyh
        xor  iyh
        or   iyh
        cp   iyh
        sub  ixl
        and  ixl
        xor  ixl
        or   ixl
        cp   ixl
        sub  iyl
        and  iyl
        xor  iyl
        or   iyl
        cp   iyl
        sub  a,ixh
        and  a,ixh
        xor  a,ixh
        or   a,ixh
        cp   a,ixh
        sub  a,iyh
        and  a,iyh
        xor  a,iyh
        or   a,iyh
        cp   a,iyh
        sub  a,ixl
        and  a,ixl
        xor  a,ixl
        or   a,ixl
        cp   a,ixl
        sub  a,iyl
        and  a,iyl
        xor  a,iyl
        or   a,iyl
        cp   a,iyl
        inc  ixh
        dec  ixh
        inc  iyh
        dec  iyh
        inc  ixl
        dec  ixl
        inc  iyl
        dec  iyl
ELSE    
ENDIF   

;------------------------------------------------------------------------------
; 16 bit arithmetic and logical group
;------------------------------------------------------------------------------

        add  hl,bc                      ;; 09
        add  hl,de                      ;; 19
        add  hl,hl                      ;; 29
        add  hl,sp                      ;; 39
        add  ix,bc                      ;; DD 09
        add  ix,de                      ;; DD 19
        add  ix,ix                      ;; DD 29
        add  ix,sp                      ;; DD 39
        add  iy,bc                      ;; FD 09
        add  iy,de                      ;; FD 19
        add  iy,iy                      ;; FD 29
        add  iy,sp                      ;; FD 39

        sbc  hl,bc                      ;; ED 42
        adc  hl,bc                      ;; ED 4A
        sbc  hl,de                      ;; ED 52
        adc  hl,de                      ;; ED 5A
        sbc  hl,hl                      ;; ED 62
        adc  hl,hl                      ;; ED 6A
        sbc  hl,sp                      ;; ED 72
        adc  hl,sp                      ;; ED 7A
; sub       hl,bc      =} 0xB7 0xED 0x42+<2:4>
; sub       hl,de      =} 0xB7 0xED 0x42+<2:4>
; sub       hl,hl      =} 0xB7 0xED 0x42+<2:4>
; sub       hl,sp      =} 0xB7 0xED 0x42+<2:4>

        inc  bc                         ;; 03
        dec  bc                         ;; 0B
        inc  de                         ;; 13
        dec  de                         ;; 1B
        inc  hl                         ;; 23
        dec  hl                         ;; 2B
        inc  ix                         ;; DD 23
        dec  ix                         ;; DD 2B
        inc  iy                         ;; FD 23
        dec  iy                         ;; FD 2B
        inc  sp                         ;; 33
        dec  sp                         ;; 3B

;------------------------------------------------------------------------------
; rotate and shift group
;------------------------------------------------------------------------------

        rlca                            ;; 07
        rrca                            ;; 0F
        rla                             ;; 17
        rra                             ;; 1F

        rlc  b                          ;; CB 00
        rrc  b                          ;; CB 08
        rl   b                          ;; CB 10
        rr   b                          ;; CB 18
        sla  b                          ;; CB 20
        sra  b                          ;; CB 28
        srl  b                          ;; CB 38
        rlc  c                          ;; CB 01
        rrc  c                          ;; CB 09
        rl   c                          ;; CB 11
        rr   c                          ;; CB 19
        sla  c                          ;; CB 21
        sra  c                          ;; CB 29
        srl  c                          ;; CB 39
        rlc  d                          ;; CB 02
        rrc  d                          ;; CB 0A
        rl   d                          ;; CB 12
        rr   d                          ;; CB 1A
        sla  d                          ;; CB 22
        sra  d                          ;; CB 2A
        srl  d                          ;; CB 3A
        rlc  e                          ;; CB 03
        rrc  e                          ;; CB 0B
        rl   e                          ;; CB 13
        rr   e                          ;; CB 1B
        sla  e                          ;; CB 23
        sra  e                          ;; CB 2B
        srl  e                          ;; CB 3B
        rlc  h                          ;; CB 04
        rrc  h                          ;; CB 0C
        rl   h                          ;; CB 14
        rr   h                          ;; CB 1C
        sla  h                          ;; CB 24
        sra  h                          ;; CB 2C
        srl  h                          ;; CB 3C
        rlc  l                          ;; CB 05
        rrc  l                          ;; CB 0D
        rl   l                          ;; CB 15
        rr   l                          ;; CB 1D
        sla  l                          ;; CB 25
        sra  l                          ;; CB 2D
        srl  l                          ;; CB 3D
        rlc  a                          ;; CB 07
        rrc  a                          ;; CB 0F
        rl   a                          ;; CB 17
        rr   a                          ;; CB 1F
        sla  a                          ;; CB 27
        sra  a                          ;; CB 2F
        srl  a                          ;; CB 3F
        rlc  (hl)                       ;; CB 06
        rrc  (hl)                       ;; CB 0E
        rl   (hl)                       ;; CB 16
        rr   (hl)                       ;; CB 1E
        sla  (hl)                       ;; CB 26
        sra  (hl)                       ;; CB 2E
        srl  (hl)                       ;; CB 3E
        rlc  (ix+DIS)                   ;; DD CB 40 06
        rrc  (ix+DIS)                   ;; DD CB 40 0E
        rl   (ix+DIS)                   ;; DD CB 40 16
        rr   (ix+DIS)                   ;; DD CB 40 1E
        sla  (ix+DIS)                   ;; DD CB 40 26
        sra  (ix+DIS)                   ;; DD CB 40 2E
        srl  (ix+DIS)                   ;; DD CB 40 3E
        rlc  (iy+DIS)                   ;; FD CB 40 06
        rrc  (iy+DIS)                   ;; FD CB 40 0E
        rl   (iy+DIS)                   ;; FD CB 40 16
        rr   (iy+DIS)                   ;; FD CB 40 1E
        sla  (iy+DIS)                   ;; FD CB 40 26
        sra  (iy+DIS)                   ;; FD CB 40 2E
        srl  (iy+DIS)                   ;; FD CB 40 3E
; rlc (ix+DIS),b =} 0xDD 0xCB DIS 0x00+<0:3+<2
; rrc (ix+DIS),b =} 0xDD 0xCB DIS 0x00+<0:3+<2
; rl (ix+DIS),b =} 0xDD 0xCB DIS 0x00+<0:3+<2
; rr (ix+DIS),b =} 0xDD 0xCB DIS 0x00+<0:3+<2
; sla (ix+DIS),b =} 0xDD 0xCB DIS 0x00+<0:3+<2
; sra (ix+DIS),b =} 0xDD 0xCB DIS 0x00+<0:3+<2
; srl (ix+DIS),b =} 0xDD 0xCB DIS 0x00+<0:3+<2
; rlc (ix+DIS),c =} 0xDD 0xCB DIS 0x00+<0:3+<2
; rrc (ix+DIS),c =} 0xDD 0xCB DIS 0x00+<0:3+<2
; rl (ix+DIS),c =} 0xDD 0xCB DIS 0x00+<0:3+<2
; rr (ix+DIS),c =} 0xDD 0xCB DIS 0x00+<0:3+<2
; sla (ix+DIS),c =} 0xDD 0xCB DIS 0x00+<0:3+<2
; sra (ix+DIS),c =} 0xDD 0xCB DIS 0x00+<0:3+<2
; srl (ix+DIS),c =} 0xDD 0xCB DIS 0x00+<0:3+<2
; rlc (ix+DIS),d =} 0xDD 0xCB DIS 0x00+<0:3+<2
; rrc (ix+DIS),d =} 0xDD 0xCB DIS 0x00+<0:3+<2
; rl (ix+DIS),d =} 0xDD 0xCB DIS 0x00+<0:3+<2
; rr (ix+DIS),d =} 0xDD 0xCB DIS 0x00+<0:3+<2
; sla (ix+DIS),d =} 0xDD 0xCB DIS 0x00+<0:3+<2
; sra (ix+DIS),d =} 0xDD 0xCB DIS 0x00+<0:3+<2
; srl (ix+DIS),d =} 0xDD 0xCB DIS 0x00+<0:3+<2
; rlc (ix+DIS),e =} 0xDD 0xCB DIS 0x00+<0:3+<2
; rrc (ix+DIS),e =} 0xDD 0xCB DIS 0x00+<0:3+<2
; rl (ix+DIS),e =} 0xDD 0xCB DIS 0x00+<0:3+<2
; rr (ix+DIS),e =} 0xDD 0xCB DIS 0x00+<0:3+<2
; sla (ix+DIS),e =} 0xDD 0xCB DIS 0x00+<0:3+<2
; sra (ix+DIS),e =} 0xDD 0xCB DIS 0x00+<0:3+<2
; srl (ix+DIS),e =} 0xDD 0xCB DIS 0x00+<0:3+<2
; rlc (ix+DIS),h =} 0xDD 0xCB DIS 0x00+<0:3+<2
; rrc (ix+DIS),h =} 0xDD 0xCB DIS 0x00+<0:3+<2
; rl (ix+DIS),h =} 0xDD 0xCB DIS 0x00+<0:3+<2
; rr (ix+DIS),h =} 0xDD 0xCB DIS 0x00+<0:3+<2
; sla (ix+DIS),h =} 0xDD 0xCB DIS 0x00+<0:3+<2
; sra (ix+DIS),h =} 0xDD 0xCB DIS 0x00+<0:3+<2
; srl (ix+DIS),h =} 0xDD 0xCB DIS 0x00+<0:3+<2
; rlc (ix+DIS),l =} 0xDD 0xCB DIS 0x00+<0:3+<2
; rrc (ix+DIS),l =} 0xDD 0xCB DIS 0x00+<0:3+<2
; rl (ix+DIS),l =} 0xDD 0xCB DIS 0x00+<0:3+<2
; rr (ix+DIS),l =} 0xDD 0xCB DIS 0x00+<0:3+<2
; sla (ix+DIS),l =} 0xDD 0xCB DIS 0x00+<0:3+<2
; sra (ix+DIS),l =} 0xDD 0xCB DIS 0x00+<0:3+<2
; srl (ix+DIS),l =} 0xDD 0xCB DIS 0x00+<0:3+<2
; rlc (ix+DIS),a =} 0xDD 0xCB DIS 0x00+<0:3+<2
; rrc (ix+DIS),a =} 0xDD 0xCB DIS 0x00+<0:3+<2
; rl (ix+DIS),a =} 0xDD 0xCB DIS 0x00+<0:3+<2
; rr (ix+DIS),a =} 0xDD 0xCB DIS 0x00+<0:3+<2
; sla (ix+DIS),a =} 0xDD 0xCB DIS 0x00+<0:3+<2
; sra (ix+DIS),a =} 0xDD 0xCB DIS 0x00+<0:3+<2
; srl (ix+DIS),a =} 0xDD 0xCB DIS 0x00+<0:3+<2
; rlc (iy+DIS),b =} 0xFD 0xCB DIS 0x00+<0:3+<2
; rrc (iy+DIS),b =} 0xFD 0xCB DIS 0x00+<0:3+<2
; rl (iy+DIS),b =} 0xFD 0xCB DIS 0x00+<0:3+<2
; rr (iy+DIS),b =} 0xFD 0xCB DIS 0x00+<0:3+<2
; sla (iy+DIS),b =} 0xFD 0xCB DIS 0x00+<0:3+<2
; sra (iy+DIS),b =} 0xFD 0xCB DIS 0x00+<0:3+<2
; srl (iy+DIS),b =} 0xFD 0xCB DIS 0x00+<0:3+<2
; rlc (iy+DIS),c =} 0xFD 0xCB DIS 0x00+<0:3+<2
; rrc (iy+DIS),c =} 0xFD 0xCB DIS 0x00+<0:3+<2
; rl (iy+DIS),c =} 0xFD 0xCB DIS 0x00+<0:3+<2
; rr (iy+DIS),c =} 0xFD 0xCB DIS 0x00+<0:3+<2
; sla (iy+DIS),c =} 0xFD 0xCB DIS 0x00+<0:3+<2
; sra (iy+DIS),c =} 0xFD 0xCB DIS 0x00+<0:3+<2
; srl (iy+DIS),c =} 0xFD 0xCB DIS 0x00+<0:3+<2
; rlc (iy+DIS),d =} 0xFD 0xCB DIS 0x00+<0:3+<2
; rrc (iy+DIS),d =} 0xFD 0xCB DIS 0x00+<0:3+<2
; rl (iy+DIS),d =} 0xFD 0xCB DIS 0x00+<0:3+<2
; rr (iy+DIS),d =} 0xFD 0xCB DIS 0x00+<0:3+<2
; sla (iy+DIS),d =} 0xFD 0xCB DIS 0x00+<0:3+<2
; sra (iy+DIS),d =} 0xFD 0xCB DIS 0x00+<0:3+<2
; srl (iy+DIS),d =} 0xFD 0xCB DIS 0x00+<0:3+<2
; rlc (iy+DIS),e =} 0xFD 0xCB DIS 0x00+<0:3+<2
; rrc (iy+DIS),e =} 0xFD 0xCB DIS 0x00+<0:3+<2
; rl (iy+DIS),e =} 0xFD 0xCB DIS 0x00+<0:3+<2
; rr (iy+DIS),e =} 0xFD 0xCB DIS 0x00+<0:3+<2
; sla (iy+DIS),e =} 0xFD 0xCB DIS 0x00+<0:3+<2
; sra (iy+DIS),e =} 0xFD 0xCB DIS 0x00+<0:3+<2
; srl (iy+DIS),e =} 0xFD 0xCB DIS 0x00+<0:3+<2
; rlc (iy+DIS),h =} 0xFD 0xCB DIS 0x00+<0:3+<2
; rrc (iy+DIS),h =} 0xFD 0xCB DIS 0x00+<0:3+<2
; rl (iy+DIS),h =} 0xFD 0xCB DIS 0x00+<0:3+<2
; rr (iy+DIS),h =} 0xFD 0xCB DIS 0x00+<0:3+<2
; sla (iy+DIS),h =} 0xFD 0xCB DIS 0x00+<0:3+<2
; sra (iy+DIS),h =} 0xFD 0xCB DIS 0x00+<0:3+<2
; srl (iy+DIS),h =} 0xFD 0xCB DIS 0x00+<0:3+<2
; rlc (iy+DIS),l =} 0xFD 0xCB DIS 0x00+<0:3+<2
; rrc (iy+DIS),l =} 0xFD 0xCB DIS 0x00+<0:3+<2
; rl (iy+DIS),l =} 0xFD 0xCB DIS 0x00+<0:3+<2
; rr (iy+DIS),l =} 0xFD 0xCB DIS 0x00+<0:3+<2
; sla (iy+DIS),l =} 0xFD 0xCB DIS 0x00+<0:3+<2
; sra (iy+DIS),l =} 0xFD 0xCB DIS 0x00+<0:3+<2
; srl (iy+DIS),l =} 0xFD 0xCB DIS 0x00+<0:3+<2
; rlc (iy+DIS),a =} 0xFD 0xCB DIS 0x00+<0:3+<2
; rrc (iy+DIS),a =} 0xFD 0xCB DIS 0x00+<0:3+<2
; rl (iy+DIS),a =} 0xFD 0xCB DIS 0x00+<0:3+<2
; rr (iy+DIS),a =} 0xFD 0xCB DIS 0x00+<0:3+<2
; sla (iy+DIS),a =} 0xFD 0xCB DIS 0x00+<0:3+<2
; sra (iy+DIS),a =} 0xFD 0xCB DIS 0x00+<0:3+<2
; srl (iy+DIS),a =} 0xFD 0xCB DIS 0x00+<0:3+<2
; sll ...
; sli ...

IF      !RABBIT
        rld
        rrd
ELSE    
        rld                             ;; CD BB 0A
        rrd                             ;; CD DD 0A
ENDIF   

; # rotate 16 bits
;
; rl bc     =} 0xCB 0x11+<1 0xCB 0x10+<1
; rl de     =} 0xCB 0x11+<1 0xCB 0x10+<1
; rl hl     =} 0xCB 0x11+<1 0xCB 0x10+<1
; rr bc     =} 0xCB 0x18+<1 0xCB 0x19+<1
; rr de     =} 0xCB 0x18+<1 0xCB 0x19+<1
; rr hl     =} 0xCB 0x18+<1 0xCB 0x19+<1
;
; sla hl       =} 0x29   # special case: add hl,hl
; sla bc    =} 0xCB 0x21+<1 0xCB 0x10+<1
; sla de    =} 0xCB 0x21+<1 0xCB 0x10+<1
; sla hl    =} 0xCB 0x21+<1 0xCB 0x10+<1
; sll bc    =} 0xCB 0x31+<1 0xCB 0x10+<1
; sll de    =} 0xCB 0x31+<1 0xCB 0x10+<1
; sll hl    =} 0xCB 0x31+<1 0xCB 0x10+<1
; sli bc    =} 0xCB 0x31+<1 0xCB 0x10+<1
; sli de    =} 0xCB 0x31+<1 0xCB 0x10+<1
; sli hl    =} 0xCB 0x31+<1 0xCB 0x10+<1
;
; sra bc    =} 0xCB 0x28+<1 0xCB 0x19+<1
; sra de    =} 0xCB 0x28+<1 0xCB 0x19+<1
; sra hl    =} 0xCB 0x28+<1 0xCB 0x19+<1
; srl bc    =} 0xCB 0x38+<1 0xCB 0x19+<1
; srl de    =} 0xCB 0x38+<1 0xCB 0x19+<1
; srl hl    =} 0xCB 0x38+<1 0xCB 0x19+<1

;------------------------------------------------------------------------------
; General purpose arithmetic and CPU control group
;------------------------------------------------------------------------------

        cpl                             ;; 2F
        neg                             ;; ED 44
        ccf                             ;; 3F
        scf                             ;; 37
        nop                             ;; 00

IF      !RABBIT
        daa
        di
        ei
        halt

        im   0
        im   1
        im   2

        im   -1
        im   3
        im   undefined
ELSE    
ENDIF   

;------------------------------------------------------------------------------
; Bit Set, Reset and Test Group
;------------------------------------------------------------------------------

        bit  0,b                        ;; CB 40
        res  0,b                        ;; CB 80
        set  0,b                        ;; CB C0
        bit  1,b                        ;; CB 48
        res  1,b                        ;; CB 88
        set  1,b                        ;; CB C8
        bit  2,b                        ;; CB 50
        res  2,b                        ;; CB 90
        set  2,b                        ;; CB D0
        bit  3,b                        ;; CB 58
        res  3,b                        ;; CB 98
        set  3,b                        ;; CB D8
        bit  4,b                        ;; CB 60
        res  4,b                        ;; CB A0
        set  4,b                        ;; CB E0
        bit  5,b                        ;; CB 68
        res  5,b                        ;; CB A8
        set  5,b                        ;; CB E8
        bit  6,b                        ;; CB 70
        res  6,b                        ;; CB B0
        set  6,b                        ;; CB F0
        bit  7,b                        ;; CB 78
        res  7,b                        ;; CB B8
        set  7,b                        ;; CB F8
        bit  0,c                        ;; CB 41
        res  0,c                        ;; CB 81
        set  0,c                        ;; CB C1
        bit  1,c                        ;; CB 49
        res  1,c                        ;; CB 89
        set  1,c                        ;; CB C9
        bit  2,c                        ;; CB 51
        res  2,c                        ;; CB 91
        set  2,c                        ;; CB D1
        bit  3,c                        ;; CB 59
        res  3,c                        ;; CB 99
        set  3,c                        ;; CB D9
        bit  4,c                        ;; CB 61
        res  4,c                        ;; CB A1
        set  4,c                        ;; CB E1
        bit  5,c                        ;; CB 69
        res  5,c                        ;; CB A9
        set  5,c                        ;; CB E9
        bit  6,c                        ;; CB 71
        res  6,c                        ;; CB B1
        set  6,c                        ;; CB F1
        bit  7,c                        ;; CB 79
        res  7,c                        ;; CB B9
        set  7,c                        ;; CB F9
        bit  0,d                        ;; CB 42
        res  0,d                        ;; CB 82
        set  0,d                        ;; CB C2
        bit  1,d                        ;; CB 4A
        res  1,d                        ;; CB 8A
        set  1,d                        ;; CB CA
        bit  2,d                        ;; CB 52
        res  2,d                        ;; CB 92
        set  2,d                        ;; CB D2
        bit  3,d                        ;; CB 5A
        res  3,d                        ;; CB 9A
        set  3,d                        ;; CB DA
        bit  4,d                        ;; CB 62
        res  4,d                        ;; CB A2
        set  4,d                        ;; CB E2
        bit  5,d                        ;; CB 6A
        res  5,d                        ;; CB AA
        set  5,d                        ;; CB EA
        bit  6,d                        ;; CB 72
        res  6,d                        ;; CB B2
        set  6,d                        ;; CB F2
        bit  7,d                        ;; CB 7A
        res  7,d                        ;; CB BA
        set  7,d                        ;; CB FA
        bit  0,e                        ;; CB 43
        res  0,e                        ;; CB 83
        set  0,e                        ;; CB C3
        bit  1,e                        ;; CB 4B
        res  1,e                        ;; CB 8B
        set  1,e                        ;; CB CB
        bit  2,e                        ;; CB 53
        res  2,e                        ;; CB 93
        set  2,e                        ;; CB D3
        bit  3,e                        ;; CB 5B
        res  3,e                        ;; CB 9B
        set  3,e                        ;; CB DB
        bit  4,e                        ;; CB 63
        res  4,e                        ;; CB A3
        set  4,e                        ;; CB E3
        bit  5,e                        ;; CB 6B
        res  5,e                        ;; CB AB
        set  5,e                        ;; CB EB
        bit  6,e                        ;; CB 73
        res  6,e                        ;; CB B3
        set  6,e                        ;; CB F3
        bit  7,e                        ;; CB 7B
        res  7,e                        ;; CB BB
        set  7,e                        ;; CB FB
        bit  0,h                        ;; CB 44
        res  0,h                        ;; CB 84
        set  0,h                        ;; CB C4
        bit  1,h                        ;; CB 4C
        res  1,h                        ;; CB 8C
        set  1,h                        ;; CB CC
        bit  2,h                        ;; CB 54
        res  2,h                        ;; CB 94
        set  2,h                        ;; CB D4
        bit  3,h                        ;; CB 5C
        res  3,h                        ;; CB 9C
        set  3,h                        ;; CB DC
        bit  4,h                        ;; CB 64
        res  4,h                        ;; CB A4
        set  4,h                        ;; CB E4
        bit  5,h                        ;; CB 6C
        res  5,h                        ;; CB AC
        set  5,h                        ;; CB EC
        bit  6,h                        ;; CB 74
        res  6,h                        ;; CB B4
        set  6,h                        ;; CB F4
        bit  7,h                        ;; CB 7C
        res  7,h                        ;; CB BC
        set  7,h                        ;; CB FC
        bit  0,l                        ;; CB 45
        res  0,l                        ;; CB 85
        set  0,l                        ;; CB C5
        bit  1,l                        ;; CB 4D
        res  1,l                        ;; CB 8D
        set  1,l                        ;; CB CD
        bit  2,l                        ;; CB 55
        res  2,l                        ;; CB 95
        set  2,l                        ;; CB D5
        bit  3,l                        ;; CB 5D
        res  3,l                        ;; CB 9D
        set  3,l                        ;; CB DD
        bit  4,l                        ;; CB 65
        res  4,l                        ;; CB A5
        set  4,l                        ;; CB E5
        bit  5,l                        ;; CB 6D
        res  5,l                        ;; CB AD
        set  5,l                        ;; CB ED
        bit  6,l                        ;; CB 75
        res  6,l                        ;; CB B5
        set  6,l                        ;; CB F5
        bit  7,l                        ;; CB 7D
        res  7,l                        ;; CB BD
        set  7,l                        ;; CB FD
        bit  0,a                        ;; CB 47
        res  0,a                        ;; CB 87
        set  0,a                        ;; CB C7
        bit  1,a                        ;; CB 4F
        res  1,a                        ;; CB 8F
        set  1,a                        ;; CB CF
        bit  2,a                        ;; CB 57
        res  2,a                        ;; CB 97
        set  2,a                        ;; CB D7
        bit  3,a                        ;; CB 5F
        res  3,a                        ;; CB 9F
        set  3,a                        ;; CB DF
        bit  4,a                        ;; CB 67
        res  4,a                        ;; CB A7
        set  4,a                        ;; CB E7
        bit  5,a                        ;; CB 6F
        res  5,a                        ;; CB AF
        set  5,a                        ;; CB EF
        bit  6,a                        ;; CB 77
        res  6,a                        ;; CB B7
        set  6,a                        ;; CB F7
        bit  7,a                        ;; CB 7F
        res  7,a                        ;; CB BF
        set  7,a                        ;; CB FF
        bit  0,(hl)                     ;; CB 46
        res  0,(hl)                     ;; CB 86
        set  0,(hl)                     ;; CB C6
        bit  1,(hl)                     ;; CB 4E
        res  1,(hl)                     ;; CB 8E
        set  1,(hl)                     ;; CB CE
        bit  2,(hl)                     ;; CB 56
        res  2,(hl)                     ;; CB 96
        set  2,(hl)                     ;; CB D6
        bit  3,(hl)                     ;; CB 5E
        res  3,(hl)                     ;; CB 9E
        set  3,(hl)                     ;; CB DE
        bit  4,(hl)                     ;; CB 66
        res  4,(hl)                     ;; CB A6
        set  4,(hl)                     ;; CB E6
        bit  5,(hl)                     ;; CB 6E
        res  5,(hl)                     ;; CB AE
        set  5,(hl)                     ;; CB EE
        bit  6,(hl)                     ;; CB 76
        res  6,(hl)                     ;; CB B6
        set  6,(hl)                     ;; CB F6
        bit  7,(hl)                     ;; CB 7E
        res  7,(hl)                     ;; CB BE
        set  7,(hl)                     ;; CB FE
        bit  0,(ix+DIS)                 ;; DD CB 40 46
        res  0,(ix+DIS)                 ;; DD CB 40 86
        set  0,(ix+DIS)                 ;; DD CB 40 C6
        bit  1,(ix+DIS)                 ;; DD CB 40 4E
        res  1,(ix+DIS)                 ;; DD CB 40 8E
        set  1,(ix+DIS)                 ;; DD CB 40 CE
        bit  2,(ix+DIS)                 ;; DD CB 40 56
        res  2,(ix+DIS)                 ;; DD CB 40 96
        set  2,(ix+DIS)                 ;; DD CB 40 D6
        bit  3,(ix+DIS)                 ;; DD CB 40 5E
        res  3,(ix+DIS)                 ;; DD CB 40 9E
        set  3,(ix+DIS)                 ;; DD CB 40 DE
        bit  4,(ix+DIS)                 ;; DD CB 40 66
        res  4,(ix+DIS)                 ;; DD CB 40 A6
        set  4,(ix+DIS)                 ;; DD CB 40 E6
        bit  5,(ix+DIS)                 ;; DD CB 40 6E
        res  5,(ix+DIS)                 ;; DD CB 40 AE
        set  5,(ix+DIS)                 ;; DD CB 40 EE
        bit  6,(ix+DIS)                 ;; DD CB 40 76
        res  6,(ix+DIS)                 ;; DD CB 40 B6
        set  6,(ix+DIS)                 ;; DD CB 40 F6
        bit  7,(ix+DIS)                 ;; DD CB 40 7E
        res  7,(ix+DIS)                 ;; DD CB 40 BE
        set  7,(ix+DIS)                 ;; DD CB 40 FE
        bit  0,(iy+DIS)                 ;; FD CB 40 46
        res  0,(iy+DIS)                 ;; FD CB 40 86
        set  0,(iy+DIS)                 ;; FD CB 40 C6
        bit  1,(iy+DIS)                 ;; FD CB 40 4E
        res  1,(iy+DIS)                 ;; FD CB 40 8E
        set  1,(iy+DIS)                 ;; FD CB 40 CE
        bit  2,(iy+DIS)                 ;; FD CB 40 56
        res  2,(iy+DIS)                 ;; FD CB 40 96
        set  2,(iy+DIS)                 ;; FD CB 40 D6
        bit  3,(iy+DIS)                 ;; FD CB 40 5E
        res  3,(iy+DIS)                 ;; FD CB 40 9E
        set  3,(iy+DIS)                 ;; FD CB 40 DE
        bit  4,(iy+DIS)                 ;; FD CB 40 66
        res  4,(iy+DIS)                 ;; FD CB 40 A6
        set  4,(iy+DIS)                 ;; FD CB 40 E6
        bit  5,(iy+DIS)                 ;; FD CB 40 6E
        res  5,(iy+DIS)                 ;; FD CB 40 AE
        set  5,(iy+DIS)                 ;; FD CB 40 EE
        bit  6,(iy+DIS)                 ;; FD CB 40 76
        res  6,(iy+DIS)                 ;; FD CB 40 B6
        set  6,(iy+DIS)                 ;; FD CB 40 F6
        bit  7,(iy+DIS)                 ;; FD CB 40 7E
        res  7,(iy+DIS)                 ;; FD CB 40 BE
        set  7,(iy+DIS)                 ;; FD CB 40 FE


; res     0,(ix+DIS),b =} 0xDD 0xCB DIS <0:6+<1:3+<3
; set     0,(ix+DIS),b =} 0xDD 0xCB DIS <0:6+<1:3+<3
; res     1,(ix+DIS),b =} 0xDD 0xCB DIS <0:6+<1:3+<3
; set     1,(ix+DIS),b =} 0xDD 0xCB DIS <0:6+<1:3+<3
; res     2,(ix+DIS),b =} 0xDD 0xCB DIS <0:6+<1:3+<3
; set     2,(ix+DIS),b =} 0xDD 0xCB DIS <0:6+<1:3+<3
; res     3,(ix+DIS),b =} 0xDD 0xCB DIS <0:6+<1:3+<3
; set     3,(ix+DIS),b =} 0xDD 0xCB DIS <0:6+<1:3+<3
; res     4,(ix+DIS),b =} 0xDD 0xCB DIS <0:6+<1:3+<3
; set     4,(ix+DIS),b =} 0xDD 0xCB DIS <0:6+<1:3+<3
; res     5,(ix+DIS),b =} 0xDD 0xCB DIS <0:6+<1:3+<3
; set     5,(ix+DIS),b =} 0xDD 0xCB DIS <0:6+<1:3+<3
; res     6,(ix+DIS),b =} 0xDD 0xCB DIS <0:6+<1:3+<3
; set     6,(ix+DIS),b =} 0xDD 0xCB DIS <0:6+<1:3+<3
; res     7,(ix+DIS),b =} 0xDD 0xCB DIS <0:6+<1:3+<3
; set     7,(ix+DIS),b =} 0xDD 0xCB DIS <0:6+<1:3+<3
; res     0,(ix+DIS),c =} 0xDD 0xCB DIS <0:6+<1:3+<3
; set     0,(ix+DIS),c =} 0xDD 0xCB DIS <0:6+<1:3+<3
; res     1,(ix+DIS),c =} 0xDD 0xCB DIS <0:6+<1:3+<3
; set     1,(ix+DIS),c =} 0xDD 0xCB DIS <0:6+<1:3+<3
; res     2,(ix+DIS),c =} 0xDD 0xCB DIS <0:6+<1:3+<3
; set     2,(ix+DIS),c =} 0xDD 0xCB DIS <0:6+<1:3+<3
; res     3,(ix+DIS),c =} 0xDD 0xCB DIS <0:6+<1:3+<3
; set     3,(ix+DIS),c =} 0xDD 0xCB DIS <0:6+<1:3+<3
; res     4,(ix+DIS),c =} 0xDD 0xCB DIS <0:6+<1:3+<3
; set     4,(ix+DIS),c =} 0xDD 0xCB DIS <0:6+<1:3+<3
; res     5,(ix+DIS),c =} 0xDD 0xCB DIS <0:6+<1:3+<3
; set     5,(ix+DIS),c =} 0xDD 0xCB DIS <0:6+<1:3+<3
; res     6,(ix+DIS),c =} 0xDD 0xCB DIS <0:6+<1:3+<3
; set     6,(ix+DIS),c =} 0xDD 0xCB DIS <0:6+<1:3+<3
; res     7,(ix+DIS),c =} 0xDD 0xCB DIS <0:6+<1:3+<3
; set     7,(ix+DIS),c =} 0xDD 0xCB DIS <0:6+<1:3+<3
; res     0,(ix+DIS),d =} 0xDD 0xCB DIS <0:6+<1:3+<3
; set     0,(ix+DIS),d =} 0xDD 0xCB DIS <0:6+<1:3+<3
; res     1,(ix+DIS),d =} 0xDD 0xCB DIS <0:6+<1:3+<3
; set     1,(ix+DIS),d =} 0xDD 0xCB DIS <0:6+<1:3+<3
; res     2,(ix+DIS),d =} 0xDD 0xCB DIS <0:6+<1:3+<3
; set     2,(ix+DIS),d =} 0xDD 0xCB DIS <0:6+<1:3+<3
; res     3,(ix+DIS),d =} 0xDD 0xCB DIS <0:6+<1:3+<3
; set     3,(ix+DIS),d =} 0xDD 0xCB DIS <0:6+<1:3+<3
; res     4,(ix+DIS),d =} 0xDD 0xCB DIS <0:6+<1:3+<3
; set     4,(ix+DIS),d =} 0xDD 0xCB DIS <0:6+<1:3+<3
; res     5,(ix+DIS),d =} 0xDD 0xCB DIS <0:6+<1:3+<3
; set     5,(ix+DIS),d =} 0xDD 0xCB DIS <0:6+<1:3+<3
; res     6,(ix+DIS),d =} 0xDD 0xCB DIS <0:6+<1:3+<3
; set     6,(ix+DIS),d =} 0xDD 0xCB DIS <0:6+<1:3+<3
; res     7,(ix+DIS),d =} 0xDD 0xCB DIS <0:6+<1:3+<3
; set     7,(ix+DIS),d =} 0xDD 0xCB DIS <0:6+<1:3+<3
; res     0,(ix+DIS),e =} 0xDD 0xCB DIS <0:6+<1:3+<3
; set     0,(ix+DIS),e =} 0xDD 0xCB DIS <0:6+<1:3+<3
; res     1,(ix+DIS),e =} 0xDD 0xCB DIS <0:6+<1:3+<3
; set     1,(ix+DIS),e =} 0xDD 0xCB DIS <0:6+<1:3+<3
; res     2,(ix+DIS),e =} 0xDD 0xCB DIS <0:6+<1:3+<3
; set     2,(ix+DIS),e =} 0xDD 0xCB DIS <0:6+<1:3+<3
; res     3,(ix+DIS),e =} 0xDD 0xCB DIS <0:6+<1:3+<3
; set     3,(ix+DIS),e =} 0xDD 0xCB DIS <0:6+<1:3+<3
; res     4,(ix+DIS),e =} 0xDD 0xCB DIS <0:6+<1:3+<3
; set     4,(ix+DIS),e =} 0xDD 0xCB DIS <0:6+<1:3+<3
; res     5,(ix+DIS),e =} 0xDD 0xCB DIS <0:6+<1:3+<3
; set     5,(ix+DIS),e =} 0xDD 0xCB DIS <0:6+<1:3+<3
; res     6,(ix+DIS),e =} 0xDD 0xCB DIS <0:6+<1:3+<3
; set     6,(ix+DIS),e =} 0xDD 0xCB DIS <0:6+<1:3+<3
; res     7,(ix+DIS),e =} 0xDD 0xCB DIS <0:6+<1:3+<3
; set     7,(ix+DIS),e =} 0xDD 0xCB DIS <0:6+<1:3+<3
; res     0,(ix+DIS),h =} 0xDD 0xCB DIS <0:6+<1:3+<3
; set     0,(ix+DIS),h =} 0xDD 0xCB DIS <0:6+<1:3+<3
; res     1,(ix+DIS),h =} 0xDD 0xCB DIS <0:6+<1:3+<3
; set     1,(ix+DIS),h =} 0xDD 0xCB DIS <0:6+<1:3+<3
; res     2,(ix+DIS),h =} 0xDD 0xCB DIS <0:6+<1:3+<3
; set     2,(ix+DIS),h =} 0xDD 0xCB DIS <0:6+<1:3+<3
; res     3,(ix+DIS),h =} 0xDD 0xCB DIS <0:6+<1:3+<3
; set     3,(ix+DIS),h =} 0xDD 0xCB DIS <0:6+<1:3+<3
; res     4,(ix+DIS),h =} 0xDD 0xCB DIS <0:6+<1:3+<3
; set     4,(ix+DIS),h =} 0xDD 0xCB DIS <0:6+<1:3+<3
; res     5,(ix+DIS),h =} 0xDD 0xCB DIS <0:6+<1:3+<3
; set     5,(ix+DIS),h =} 0xDD 0xCB DIS <0:6+<1:3+<3
; res     6,(ix+DIS),h =} 0xDD 0xCB DIS <0:6+<1:3+<3
; set     6,(ix+DIS),h =} 0xDD 0xCB DIS <0:6+<1:3+<3
; res     7,(ix+DIS),h =} 0xDD 0xCB DIS <0:6+<1:3+<3
; set     7,(ix+DIS),h =} 0xDD 0xCB DIS <0:6+<1:3+<3
; res     0,(ix+DIS),l =} 0xDD 0xCB DIS <0:6+<1:3+<3
; set     0,(ix+DIS),l =} 0xDD 0xCB DIS <0:6+<1:3+<3
; res     1,(ix+DIS),l =} 0xDD 0xCB DIS <0:6+<1:3+<3
; set     1,(ix+DIS),l =} 0xDD 0xCB DIS <0:6+<1:3+<3
; res     2,(ix+DIS),l =} 0xDD 0xCB DIS <0:6+<1:3+<3
; set     2,(ix+DIS),l =} 0xDD 0xCB DIS <0:6+<1:3+<3
; res     3,(ix+DIS),l =} 0xDD 0xCB DIS <0:6+<1:3+<3
; set     3,(ix+DIS),l =} 0xDD 0xCB DIS <0:6+<1:3+<3
; res     4,(ix+DIS),l =} 0xDD 0xCB DIS <0:6+<1:3+<3
; set     4,(ix+DIS),l =} 0xDD 0xCB DIS <0:6+<1:3+<3
; res     5,(ix+DIS),l =} 0xDD 0xCB DIS <0:6+<1:3+<3
; set     5,(ix+DIS),l =} 0xDD 0xCB DIS <0:6+<1:3+<3
; res     6,(ix+DIS),l =} 0xDD 0xCB DIS <0:6+<1:3+<3
; set     6,(ix+DIS),l =} 0xDD 0xCB DIS <0:6+<1:3+<3
; res     7,(ix+DIS),l =} 0xDD 0xCB DIS <0:6+<1:3+<3
; set     7,(ix+DIS),l =} 0xDD 0xCB DIS <0:6+<1:3+<3
; res     0,(ix+DIS),a =} 0xDD 0xCB DIS <0:6+<1:3+<3
; set     0,(ix+DIS),a =} 0xDD 0xCB DIS <0:6+<1:3+<3
; res     1,(ix+DIS),a =} 0xDD 0xCB DIS <0:6+<1:3+<3
; set     1,(ix+DIS),a =} 0xDD 0xCB DIS <0:6+<1:3+<3
; res     2,(ix+DIS),a =} 0xDD 0xCB DIS <0:6+<1:3+<3
; set     2,(ix+DIS),a =} 0xDD 0xCB DIS <0:6+<1:3+<3
; res     3,(ix+DIS),a =} 0xDD 0xCB DIS <0:6+<1:3+<3
; set     3,(ix+DIS),a =} 0xDD 0xCB DIS <0:6+<1:3+<3
; res     4,(ix+DIS),a =} 0xDD 0xCB DIS <0:6+<1:3+<3
; set     4,(ix+DIS),a =} 0xDD 0xCB DIS <0:6+<1:3+<3
; res     5,(ix+DIS),a =} 0xDD 0xCB DIS <0:6+<1:3+<3
; set     5,(ix+DIS),a =} 0xDD 0xCB DIS <0:6+<1:3+<3
; res     6,(ix+DIS),a =} 0xDD 0xCB DIS <0:6+<1:3+<3
; set     6,(ix+DIS),a =} 0xDD 0xCB DIS <0:6+<1:3+<3
; res     7,(ix+DIS),a =} 0xDD 0xCB DIS <0:6+<1:3+<3
; set     7,(ix+DIS),a =} 0xDD 0xCB DIS <0:6+<1:3+<3
; res     0,(iy+DIS),b =} 0xFD 0xCB DIS <0:6+<1:3+<3
; set     0,(iy+DIS),b =} 0xFD 0xCB DIS <0:6+<1:3+<3
; res     1,(iy+DIS),b =} 0xFD 0xCB DIS <0:6+<1:3+<3
; set     1,(iy+DIS),b =} 0xFD 0xCB DIS <0:6+<1:3+<3
; res     2,(iy+DIS),b =} 0xFD 0xCB DIS <0:6+<1:3+<3
; set     2,(iy+DIS),b =} 0xFD 0xCB DIS <0:6+<1:3+<3
; res     3,(iy+DIS),b =} 0xFD 0xCB DIS <0:6+<1:3+<3
; set     3,(iy+DIS),b =} 0xFD 0xCB DIS <0:6+<1:3+<3
; res     4,(iy+DIS),b =} 0xFD 0xCB DIS <0:6+<1:3+<3
; set     4,(iy+DIS),b =} 0xFD 0xCB DIS <0:6+<1:3+<3
; res     5,(iy+DIS),b =} 0xFD 0xCB DIS <0:6+<1:3+<3
; set     5,(iy+DIS),b =} 0xFD 0xCB DIS <0:6+<1:3+<3
; res     6,(iy+DIS),b =} 0xFD 0xCB DIS <0:6+<1:3+<3
; set     6,(iy+DIS),b =} 0xFD 0xCB DIS <0:6+<1:3+<3
; res     7,(iy+DIS),b =} 0xFD 0xCB DIS <0:6+<1:3+<3
; set     7,(iy+DIS),b =} 0xFD 0xCB DIS <0:6+<1:3+<3
; res     0,(iy+DIS),c =} 0xFD 0xCB DIS <0:6+<1:3+<3
; set     0,(iy+DIS),c =} 0xFD 0xCB DIS <0:6+<1:3+<3
; res     1,(iy+DIS),c =} 0xFD 0xCB DIS <0:6+<1:3+<3
; set     1,(iy+DIS),c =} 0xFD 0xCB DIS <0:6+<1:3+<3
; res     2,(iy+DIS),c =} 0xFD 0xCB DIS <0:6+<1:3+<3
; set     2,(iy+DIS),c =} 0xFD 0xCB DIS <0:6+<1:3+<3
; res     3,(iy+DIS),c =} 0xFD 0xCB DIS <0:6+<1:3+<3
; set     3,(iy+DIS),c =} 0xFD 0xCB DIS <0:6+<1:3+<3
; res     4,(iy+DIS),c =} 0xFD 0xCB DIS <0:6+<1:3+<3
; set     4,(iy+DIS),c =} 0xFD 0xCB DIS <0:6+<1:3+<3
; res     5,(iy+DIS),c =} 0xFD 0xCB DIS <0:6+<1:3+<3
; set     5,(iy+DIS),c =} 0xFD 0xCB DIS <0:6+<1:3+<3
; res     6,(iy+DIS),c =} 0xFD 0xCB DIS <0:6+<1:3+<3
; set     6,(iy+DIS),c =} 0xFD 0xCB DIS <0:6+<1:3+<3
; res     7,(iy+DIS),c =} 0xFD 0xCB DIS <0:6+<1:3+<3
; set     7,(iy+DIS),c =} 0xFD 0xCB DIS <0:6+<1:3+<3
; res     0,(iy+DIS),d =} 0xFD 0xCB DIS <0:6+<1:3+<3
; set     0,(iy+DIS),d =} 0xFD 0xCB DIS <0:6+<1:3+<3
; res     1,(iy+DIS),d =} 0xFD 0xCB DIS <0:6+<1:3+<3
; set     1,(iy+DIS),d =} 0xFD 0xCB DIS <0:6+<1:3+<3
; res     2,(iy+DIS),d =} 0xFD 0xCB DIS <0:6+<1:3+<3
; set     2,(iy+DIS),d =} 0xFD 0xCB DIS <0:6+<1:3+<3
; res     3,(iy+DIS),d =} 0xFD 0xCB DIS <0:6+<1:3+<3
; set     3,(iy+DIS),d =} 0xFD 0xCB DIS <0:6+<1:3+<3
; res     4,(iy+DIS),d =} 0xFD 0xCB DIS <0:6+<1:3+<3
; set     4,(iy+DIS),d =} 0xFD 0xCB DIS <0:6+<1:3+<3
; res     5,(iy+DIS),d =} 0xFD 0xCB DIS <0:6+<1:3+<3
; set     5,(iy+DIS),d =} 0xFD 0xCB DIS <0:6+<1:3+<3
; res     6,(iy+DIS),d =} 0xFD 0xCB DIS <0:6+<1:3+<3
; set     6,(iy+DIS),d =} 0xFD 0xCB DIS <0:6+<1:3+<3
; res     7,(iy+DIS),d =} 0xFD 0xCB DIS <0:6+<1:3+<3
; set     7,(iy+DIS),d =} 0xFD 0xCB DIS <0:6+<1:3+<3
; res     0,(iy+DIS),e =} 0xFD 0xCB DIS <0:6+<1:3+<3
; set     0,(iy+DIS),e =} 0xFD 0xCB DIS <0:6+<1:3+<3
; res     1,(iy+DIS),e =} 0xFD 0xCB DIS <0:6+<1:3+<3
; set     1,(iy+DIS),e =} 0xFD 0xCB DIS <0:6+<1:3+<3
; res     2,(iy+DIS),e =} 0xFD 0xCB DIS <0:6+<1:3+<3
; set     2,(iy+DIS),e =} 0xFD 0xCB DIS <0:6+<1:3+<3
; res     3,(iy+DIS),e =} 0xFD 0xCB DIS <0:6+<1:3+<3
; set     3,(iy+DIS),e =} 0xFD 0xCB DIS <0:6+<1:3+<3
; res     4,(iy+DIS),e =} 0xFD 0xCB DIS <0:6+<1:3+<3
; set     4,(iy+DIS),e =} 0xFD 0xCB DIS <0:6+<1:3+<3
; res     5,(iy+DIS),e =} 0xFD 0xCB DIS <0:6+<1:3+<3
; set     5,(iy+DIS),e =} 0xFD 0xCB DIS <0:6+<1:3+<3
; res     6,(iy+DIS),e =} 0xFD 0xCB DIS <0:6+<1:3+<3
; set     6,(iy+DIS),e =} 0xFD 0xCB DIS <0:6+<1:3+<3
; res     7,(iy+DIS),e =} 0xFD 0xCB DIS <0:6+<1:3+<3
; set     7,(iy+DIS),e =} 0xFD 0xCB DIS <0:6+<1:3+<3
; res     0,(iy+DIS),h =} 0xFD 0xCB DIS <0:6+<1:3+<3
; set     0,(iy+DIS),h =} 0xFD 0xCB DIS <0:6+<1:3+<3
; res     1,(iy+DIS),h =} 0xFD 0xCB DIS <0:6+<1:3+<3
; set     1,(iy+DIS),h =} 0xFD 0xCB DIS <0:6+<1:3+<3
; res     2,(iy+DIS),h =} 0xFD 0xCB DIS <0:6+<1:3+<3
; set     2,(iy+DIS),h =} 0xFD 0xCB DIS <0:6+<1:3+<3
; res     3,(iy+DIS),h =} 0xFD 0xCB DIS <0:6+<1:3+<3
; set     3,(iy+DIS),h =} 0xFD 0xCB DIS <0:6+<1:3+<3
; res     4,(iy+DIS),h =} 0xFD 0xCB DIS <0:6+<1:3+<3
; set     4,(iy+DIS),h =} 0xFD 0xCB DIS <0:6+<1:3+<3
; res     5,(iy+DIS),h =} 0xFD 0xCB DIS <0:6+<1:3+<3
; set     5,(iy+DIS),h =} 0xFD 0xCB DIS <0:6+<1:3+<3
; res     6,(iy+DIS),h =} 0xFD 0xCB DIS <0:6+<1:3+<3
; set     6,(iy+DIS),h =} 0xFD 0xCB DIS <0:6+<1:3+<3
; res     7,(iy+DIS),h =} 0xFD 0xCB DIS <0:6+<1:3+<3
; set     7,(iy+DIS),h =} 0xFD 0xCB DIS <0:6+<1:3+<3
; res     0,(iy+DIS),l =} 0xFD 0xCB DIS <0:6+<1:3+<3
; set     0,(iy+DIS),l =} 0xFD 0xCB DIS <0:6+<1:3+<3
; res     1,(iy+DIS),l =} 0xFD 0xCB DIS <0:6+<1:3+<3
; set     1,(iy+DIS),l =} 0xFD 0xCB DIS <0:6+<1:3+<3
; res     2,(iy+DIS),l =} 0xFD 0xCB DIS <0:6+<1:3+<3
; set     2,(iy+DIS),l =} 0xFD 0xCB DIS <0:6+<1:3+<3
; res     3,(iy+DIS),l =} 0xFD 0xCB DIS <0:6+<1:3+<3
; set     3,(iy+DIS),l =} 0xFD 0xCB DIS <0:6+<1:3+<3
; res     4,(iy+DIS),l =} 0xFD 0xCB DIS <0:6+<1:3+<3
; set     4,(iy+DIS),l =} 0xFD 0xCB DIS <0:6+<1:3+<3
; res     5,(iy+DIS),l =} 0xFD 0xCB DIS <0:6+<1:3+<3
; set     5,(iy+DIS),l =} 0xFD 0xCB DIS <0:6+<1:3+<3
; res     6,(iy+DIS),l =} 0xFD 0xCB DIS <0:6+<1:3+<3
; set     6,(iy+DIS),l =} 0xFD 0xCB DIS <0:6+<1:3+<3
; res     7,(iy+DIS),l =} 0xFD 0xCB DIS <0:6+<1:3+<3
; set     7,(iy+DIS),l =} 0xFD 0xCB DIS <0:6+<1:3+<3
; res     0,(iy+DIS),a =} 0xFD 0xCB DIS <0:6+<1:3+<3
; set     0,(iy+DIS),a =} 0xFD 0xCB DIS <0:6+<1:3+<3
; res     1,(iy+DIS),a =} 0xFD 0xCB DIS <0:6+<1:3+<3
; set     1,(iy+DIS),a =} 0xFD 0xCB DIS <0:6+<1:3+<3
; res     2,(iy+DIS),a =} 0xFD 0xCB DIS <0:6+<1:3+<3
; set     2,(iy+DIS),a =} 0xFD 0xCB DIS <0:6+<1:3+<3
; res     3,(iy+DIS),a =} 0xFD 0xCB DIS <0:6+<1:3+<3
; set     3,(iy+DIS),a =} 0xFD 0xCB DIS <0:6+<1:3+<3
; res     4,(iy+DIS),a =} 0xFD 0xCB DIS <0:6+<1:3+<3
; set     4,(iy+DIS),a =} 0xFD 0xCB DIS <0:6+<1:3+<3
; res     5,(iy+DIS),a =} 0xFD 0xCB DIS <0:6+<1:3+<3
; set     5,(iy+DIS),a =} 0xFD 0xCB DIS <0:6+<1:3+<3
; res     6,(iy+DIS),a =} 0xFD 0xCB DIS <0:6+<1:3+<3
; set     6,(iy+DIS),a =} 0xFD 0xCB DIS <0:6+<1:3+<3
; res     7,(iy+DIS),a =} 0xFD 0xCB DIS <0:6+<1:3+<3
; set     7,(iy+DIS),a =} 0xFD 0xCB DIS <0:6+<1:3+<3

;------------------------------------------------------------------------------
; Jump Group
;------------------------------------------------------------------------------
        jp   NN                         ;; C3 30 00
        jp   (hl)                       ;; E9
        jp   (ix)                       ;; DD E9
        jp   (iy)                       ;; FD E9
        jp   nz,NN                      ;; C2 30 00
        jp   z,NN                       ;; CA 30 00
        jp   nc,NN                      ;; D2 30 00
        jp   c,NN                       ;; DA 30 00
        jp   po,NN                      ;; E2 30 00
        jp   pe,NN                      ;; EA 30 00
        jp   p,NN                       ;; F2 30 00
        jp   m,NN                       ;; FA 30 00

                                        ; max forward jump
        jr   jr2                        ;; 18 7F
        jr   jr2                        ;; 18 7D
        jr   jr2                        ;; 18 7B

        djnz ASMPC                      ;; 10 FE
        djnz ASMPC+0x81                 ;; 10 7F
        jr   ASMPC                      ;; 18 FE
        jr   ASMPC-0x7E                 ;; 18 80

        djnz jr1                        ;; 10 00
jr1:    
        jr   jr1                        ;; 18 FE
        djnz jr1                        ;; 10 FC
        jr   nz,jr1                     ;; 20 FA
        jr   z,jr1                      ;; 28 F8
        jr   nc,jr1                     ;; 30 F6
        jr   c,jr1                      ;; 38 F4

        defb 1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25
                                        ;; 01 02 03 04 05 06 07 08 09 0A 0B 0C 0D 0E 0F 10 11 12 13 14 15 16 17 18 19
        defb 26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50
                                        ;; 1A 1B 1C 1D 1E 1F 20 21 22 23 24 25 26 27 28 29 2A 2B 2C 2D 2E 2F 30 31 32
        defb 51,52,53,54,55,56,57,58,59,60,61,62,63,64,65,66,67,68,69,70,71,72,73,74,75
                                        ;; 33 34 35 36 37 38 39 3A 3B 3C 3D 3E 3F 40 41 42 43 44 45 46 47 48 49 4A 4B
        defb 76,77,78,79,80,81,82,83,84,85,86,87,88,89,90,91,92,93,94,95,96,97,98,99,100,101
                                        ;; 4C 4D 4E 4F 50 51 52 53 54 55 56 57 58 59 5A 5B 5C 5D 5E 5F 60 61 62 63 64 65

jr2:    
        defb 1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25
                                        ;; 01 02 03 04 05 06 07 08 09 0A 0B 0C 0D 0E 0F 10 11 12 13 14 15 16 17 18 19
        defb 26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50
                                        ;; 1A 1B 1C 1D 1E 1F 20 21 22 23 24 25 26 27 28 29 2A 2B 2C 2D 2E 2F 30 31 32
        defb 51,52,53,54,55,56,57,58,59,60,61,62,63,64,65,66,67,68,69,70,71,72,73,74,75
                                        ;; 33 34 35 36 37 38 39 3A 3B 3C 3D 3E 3F 40 41 42 43 44 45 46 47 48 49 4A 4B
        defb 76,77,78,79,80,81,82,83,84,85,86,87,88,89,90,91,92,93,94,95,96,97,98,99,100
                                        ;; 4C 4D 4E 4F 50 51 52 53 54 55 56 57 58 59 5A 5B 5C 5D 5E 5F 60 61 62 63 64
        defb 101,102,103,104,105,106,107,108,109,110,111,112,113,114,115,116,117,118,119,120,121,122
                                        ;; 65 66 67 68 69 6A 6B 6C 6D 6E 6F 70 71 72 73 74 75 76 77 78 79 7A

        jr   jr2                        ;; 18 84
        jr   jr2                        ;; 18 82
                                        ; max backward jump - z80pack does not accept -128
        jr   jr2                        ;; 18 80


; jr po,NN
; jr pe,NN
; jr p,NN
; jr m,NN


;------------------------------------------------------------------------------
; Call and Return Group
;------------------------------------------------------------------------------

        call NN                         ;; CD 30 00
        ret                             ;; C9
        ret  nz                         ;; C0
        ret  z                          ;; C8
        ret  nc                         ;; D0
        ret  c                          ;; D8
        ret  po                         ;; E0
        ret  pe                         ;; E8
        ret  p                          ;; F0
        ret  m                          ;; F8
        reti                            ;; ED 4D
; rst 0
; rst 1
; rst 2
; rst 3
; rst 4
; rst 5
; rst 6
; rst 7


IF      !RABBIT
        call nz,NN
        call z,NN
        call nc,NN
        call c,NN
        call po,NN
        call pe,NN
        call p,NN
        call m,NN

        retn

        rst  00h
        rst  08h
        rst  10h
        rst  18h
        rst  20h
        rst  28h
        rst  30h
        rst  38h
ELSE    
        call nz,NN                      ;; 28 03 CD 30 00
        call z,NN                       ;; 20 03 CD 30 00
        call nc,NN                      ;; 38 03 CD 30 00
        call c,NN                       ;; 30 03 CD 30 00
        call po,NN                      ;; EA AE 09 CD 30 00
        call pe,NN                      ;; E2 B4 09 CD 30 00
        call p,NN                       ;; FA BA 09 CD 30 00
        call m,NN                       ;; F2 C0 09 CD 30 00


        rst  10h                        ;; D7
        rst  18h                        ;; DF
        rst  20h                        ;; E7
        rst  28h                        ;; EF
        rst  38h                        ;; FF
ENDIF   


;------------------------------------------------------------------------------
; Input and Output Group
;------------------------------------------------------------------------------

IF      !RABBIT
        in   a,(N)
        in   b,(c)
        in   c,(c)
        in   d,(c)
        in   e,(c)
        in   h,(c)
        in   l,(c)
        in   a,(c)
; in f,(c)

        ini
        inir
        ind
        indr

        out  (N),a
        out  (c),b
        out  (c),c
        out  (c),d
        out  (c),e
        out  (c),h
        out  (c),l
        out  (c),a
; out (c),0

        outi
        otir
        outd
        otdr
ELSE    
ENDIF   

;------------------------------------------------------------------------------
; IF ELSE ENDIF
;------------------------------------------------------------------------------
        if   1
          defb 1                        ;; 01
          if   1
            defb 2                      ;; 02
          else
            defb 3
          endif
        else
          defb 4
          if   1
            defb 5
          else
            defb 6
          endif
        endif

        if   0
          defb 7
        endif

        if   1
          defb 8                        ;; 08
        endif

        if   0
          defb 9
        else
          defb 10                       ;; 0A
        endif

        if   undefined
          defb 11
        else
          defb 12                       ;; 0C
        endif

        if   undefined | 1
          defb 13                       ;; 0D
        else
          defb 14
        endif

;------------------------------------------------------------------------------
; IFDEF ELSE ENDIF
;------------------------------------------------------------------------------
        defc ifdef_1 = 0
        define ifdef_2

        ifdef ZERO
          defb 1                        ;; 01
        else
          defb 2
        endif

        ifdef undefined
          defb 3
        else
          defb 4                        ;; 04
        endif

        ifdef ifdef_1
          defb 5                        ;; 05
        else
          defb 6
        endif

        ifdef ifdef_2
          defb 7                        ;; 07
        else
          defb 8
        endif

        ifdef ifdef_3
          defb 9
        else
          defb 10                       ;; 0A
        endif

;------------------------------------------------------------------------------
; IFNDEF ELSE ENDIF
;------------------------------------------------------------------------------
        defc ifndef_1 = 0
        define ifndef_2

        ifndef ZERO
          defb 1
        else
          defb 2                        ;; 02
        endif

        ifndef undefined
          defb 3                        ;; 03
        else
          defb 4
        endif

        ifndef ifndef_1
          defb 5
        else
          defb 6                        ;; 06
        endif

        ifndef ifndef_2
          defb 7
        else
          defb 8                        ;; 08
        endif

        ifndef ifndef_3
          defb 9                        ;; 09
        else
          defb 10
        endif

;------------------------------------------------------------------------------
; DEFGROUP
;------------------------------------------------------------------------------
        defgroup
        {
          f0, f1
          f2, f3,
          f10  = 10,
          f11,
          f20  = 20, f21
          rl
        }
        defb f0,f1,f2,f3,f10,f11,f20,f21,rl
                                        ;; 00 01 02 03 0A 0B 14 15 16

        defgroup
        {
          dg1, dg2  = 3
          dg3  = 7,
        }
        defb dg1,dg2,dg3                ;; 00 03 07

                                        ; check with conditional assembly
        if   1
          defgroup
          {
            ff   = 1
          }
        else
          defgroup
          {
            ff   = 2
          }
        endif
        if   0
          defgroup
          {
            fg   = 1
          }
        else
          defgroup
          {
            fg   = 2
          }
        endif
        defb ff, fg                     ;; 01 02

;------------------------------------------------------------------------------
; DEFS
;------------------------------------------------------------------------------
        defs 0
        defs 1                          ;; 00
        defs 2                          ;; 00 00
        defs 3                          ;; 00 00 00
        defs 4                          ;; 00 00 00 00

        defs 2,-128                     ;; 80 80
        defs 2,-127                     ;; 81 81
        defs 2,0                        ;; 00 00
        defs 2,255                      ;; FF FF

        if   0
          defs 2,0
        else
          defs 2,2                      ;; 02 02
        endif

;------------------------------------------------------------------------------
; DEFVARS
;------------------------------------------------------------------------------
        defc defvars_base = 0x80
        defvars defvars_base

        {
          df1  ds.b 4
          df2  ds.w 2
          df3  ds.p 2
          df4  ds.q 2
          df5
          rr

        }
        defb df1, df2, df3, df4, df5, rr
                                        ;; 80 84 88 8E 96 96

        defvars 0 {
          df6  ds.b 1
          df7  ds.b 1
          df8
        }
        defb df6, df7, df8              ;; 00 01 02

        defvars -1                      ; continue after df5
        {
          df9  ds.b 1
          df10 ds.b 1
          df11
          df12
        }
        defb df9, df10, df11, df12      ;; 96 97 98 98

        defvars 0 {
          df13 ds.b 1
          df14 ds.b 1
          df15
        }
        defb df13, df14, df15           ;; 00 01 02

        defvars -1                      ; continue after df12
        {
          df16 ds.b 1
          df17 ds.b 1
          df18 ds.b 0
          df19
        }
        defb df16, df17, df18, df19     ;; 98 99 9A 9A

                                        ; check with conditional assembly
        if   1
          defvars 0
          {
            df20 ds.b 1
            df21
          }
        else
          defvars 0
          {
            df20 ds.w 1
            df21
          }
        endif
        defb df20, df21                 ;; 00 01

        if   0
          defvars 0
          {
            df30 ds.b 1
            df31
          }
        else
          defvars 0
          {
            df30 ds.w 1
            df31
          }
        endif
        defb df30, df31                 ;; 00 02

;------------------------------------------------------------------------------
; Allow labels with names of opcodes
;------------------------------------------------------------------------------

        extern ld

        nop                             ;; 00
        jr   nop                        ;; 18 00
nop:    

IF      !RABBIT
        di
        jr   di
di:     
        ei
        jr   ei
ei:     
ENDIF   

;------------------------------------------------------------------------------
; Test parsing of expressions with parentheses inside parentheses
;------------------------------------------------------------------------------
IF      !RABBIT
        out  N,a
        out  (N),a
        out  ((N)),a
        out  (N+2*(3-3)),a
ENDIF   

;------------------------------------------------------------------------------
; Z88DK specific opcodes
;------------------------------------------------------------------------------
        call_oz 1                       ;; E7 01
        call_oz 255                     ;; E7 FF
        call_oz 256                     ;; E7 00 01
        call_oz 65535                   ;; E7 FF FF

IF      !RABBIT
        call_pkg 0
        call_pkg 1
        call_pkg 65535
        call_pkg -1
        call_pkg 65536
ENDIF   

        fpp  1                          ;; DF 01
        fpp  254                        ;; DF FE

        invoke 0                        ;; CD 00 00
        invoke 1                        ;; CD 01 00
        invoke 65535                    ;; CD FF FF 38 12 BE 2B 0B F5 E3 CB 85 CB D5 78 B1 20 02 CB 95 E3 F1 C9 BE 2B 0B F5 E3 CB C5 18 EC 30 06 CD 4E 0A 37 C9 2B 0B BE 28 12 0C 0D 20 F7 04 10 F4 BE 2B F5 E3 CB 85 CB 95 E3 F1 C9 2B F5 78 B1 28 F2 E3 CB 85 CB D5 E3 F1 C9 38 12 BE 23 0B F5 E3 CB 85 CB D5 78 B1 20 02 CB 95 E3 F1 C9 BE 23 0B F5 E3 CB C5 18 EC 30 06 CD 97 0A 37 C9 23 0B BE 28 12 0C 0D 20 F7 04 10 F4 BE 23 F5 E3 CB 85 CB 95 E3 F1 C9 23 F5 78 B1 28 F2 E3 CB 85 CB D5 E3 F1 C9 30 05 CD C2 0A 37 C9 07 07 07 07 CB 27 CB 16 CE 00 17 CB 16 CE 00 17 CB 16 CE 00 17 CB 16 CE 00 B7 C9 30 05 CD E4 0A 37 C9 CB 3F CB 1E 1F CB 1E 1F CB 1E 1F CB 1E 1F 1F 1F 1F 1F B7 C9
END_ASM
);
z80asm(
    options => "-l -b -DRABBIT --RCMX000 -i".z80emu(),
    asm  => <<'END_ASM',
        ldx                             ;; error: syntax error
        ld                              ;; error: syntax error
        ld   a,1+                       ;; error: syntax error
        ld   a,'                        ;; error: invalid single quoted character
        ld   a,''                       ;; error: invalid single quoted character
        ld   a,'a                       ;; error: invalid single quoted character
        ld   a,'he'                     ;; error: invalid single quoted character
        ld   a,"a"                      ;; error: syntax error
        defb "                          ;; error: unclosed quoted string
        defb "hello                     ;; error: unclosed quoted string
        defb 1/0                        ;; error 2: division by zero
        defb 1% 0                       ;; error 2: division by zero
        defb 1?                         ;; error: syntax error
        defb 1?2                        ;; error: syntax error in expression
        defb 1?2:                       ;; error: syntax error
        defb 1?2:1?                     ;; error: syntax error
        defm "hello ",                  ;; error: syntax error
        defm "hello "&                  ;; error: syntax error
        defm "hello "&"world"           ;; error: syntax error
        defm "hello"&32&"world"         ;; error: syntax error
        defm 32,                        ;; error: syntax error
IF      !RABBIT
ELSE    
        ld   b,ixh                      ;; error: illegal identifier
        ld   c,ixh                      ;; error: illegal identifier
        ld   d,ixh                      ;; error: illegal identifier
        ld   e,ixh                      ;; error: illegal identifier
        ld   ixh,ixh                    ;; error: illegal identifier
        ld   ixl,ixh                    ;; error: illegal identifier
        ld   a,ixh                      ;; error: illegal identifier
        ld   b,ixl                      ;; error: illegal identifier
        ld   c,ixl                      ;; error: illegal identifier
        ld   d,ixl                      ;; error: illegal identifier
        ld   e,ixl                      ;; error: illegal identifier
        ld   ixh,ixl                    ;; error: illegal identifier
        ld   ixl,ixl                    ;; error: illegal identifier
        ld   a,ixl                      ;; error: illegal identifier
        ld   ixh,b                      ;; error: illegal identifier
        ld   ixl,b                      ;; error: illegal identifier
        ld   ixh,c                      ;; error: illegal identifier
        ld   ixl,c                      ;; error: illegal identifier
        ld   ixh,d                      ;; error: illegal identifier
        ld   ixl,d                      ;; error: illegal identifier
        ld   ixh,e                      ;; error: illegal identifier
        ld   ixl,e                      ;; error: illegal identifier
        ld   ixh,ixh                    ;; error: illegal identifier
        ld   ixl,ixh                    ;; error: illegal identifier
        ld   ixh,ixl                    ;; error: illegal identifier
        ld   ixl,ixl                    ;; error: illegal identifier
        ld   ixh,a                      ;; error: illegal identifier
        ld   ixl,a                      ;; error: illegal identifier
        ld   ixh,1                      ;; error: illegal identifier
        ld   ixl,1                      ;; error: illegal identifier
        ld   b,iyh                      ;; error: illegal identifier
        ld   c,iyh                      ;; error: illegal identifier
        ld   d,iyh                      ;; error: illegal identifier
        ld   e,iyh                      ;; error: illegal identifier
        ld   iyh,iyh                    ;; error: illegal identifier
        ld   iyl,iyh                    ;; error: illegal identifier
        ld   a,iyh                      ;; error: illegal identifier
        ld   b,iyl                      ;; error: illegal identifier
        ld   c,iyl                      ;; error: illegal identifier
        ld   d,iyl                      ;; error: illegal identifier
        ld   e,iyl                      ;; error: illegal identifier
        ld   iyh,iyl                    ;; error: illegal identifier
        ld   iyl,iyl                    ;; error: illegal identifier
        ld   a,iyl                      ;; error: illegal identifier
        ld   iyh,b                      ;; error: illegal identifier
        ld   iyl,b                      ;; error: illegal identifier
        ld   iyh,c                      ;; error: illegal identifier
        ld   iyl,c                      ;; error: illegal identifier
        ld   iyh,d                      ;; error: illegal identifier
        ld   iyl,d                      ;; error: illegal identifier
        ld   iyh,e                      ;; error: illegal identifier
        ld   iyl,e                      ;; error: illegal identifier
        ld   iyh,iyh                    ;; error: illegal identifier
        ld   iyl,iyh                    ;; error: illegal identifier
        ld   iyh,iyl                    ;; error: illegal identifier
        ld   iyl,iyl                    ;; error: illegal identifier
        ld   iyh,a                      ;; error: illegal identifier
        ld   iyl,a                      ;; error: illegal identifier
        ld   iyh,1                      ;; error: illegal identifier
        ld   iyl,1                      ;; error: illegal identifier
ENDIF   
        ld   (bc),b                     ;; error: syntax error
        ld   (de),b                     ;; error: syntax error
        ld   (bc),c                     ;; error: syntax error
        ld   (de),c                     ;; error: syntax error
        ld   (bc),d                     ;; error: syntax error
        ld   (de),d                     ;; error: syntax error
        ld   (bc),e                     ;; error: syntax error
        ld   (de),e                     ;; error: syntax error
        ld   (bc),h                     ;; error: syntax error
        ld   (de),h                     ;; error: syntax error
        ld   (bc),l                     ;; error: syntax error
        ld   (de),l                     ;; error: syntax error
        ld   (bc),(hl)                  ;; error: syntax error
        ld   (de),(hl)                  ;; error: syntax error
        ld   (bc),(ix+DIS)              ;; error: syntax error
        ld   (de),(ix+DIS)              ;; error: syntax error
        ld   (bc),(iy+DIS)              ;; error: syntax error
        ld   (de),(iy+DIS)              ;; error: syntax error
        ld   (bc),N                     ;; error: syntax error
        ld   (de),N                     ;; error: syntax error
IF      !RABBIT
ELSE    
ENDIF   
IF      !RABBIT
ELSE    
ENDIF   
IF      !RABBIT
ELSE    
ENDIF   
IF      !RABBIT
ELSE    
        add  a,ixh                      ;; error: illegal identifier
        adc  a,ixh                      ;; error: illegal identifier
        sbc  a,ixh                      ;; error: illegal identifier
        add  a,iyh                      ;; error: illegal identifier
        adc  a,iyh                      ;; error: illegal identifier
        sbc  a,iyh                      ;; error: illegal identifier
        add  a,ixl                      ;; error: illegal identifier
        adc  a,ixl                      ;; error: illegal identifier
        sbc  a,ixl                      ;; error: illegal identifier
        add  a,iyl                      ;; error: illegal identifier
        adc  a,iyl                      ;; error: illegal identifier
        sbc  a,iyl                      ;; error: illegal identifier
        add  ixh                        ;; error: illegal identifier
        adc  ixh                        ;; error: illegal identifier
        sbc  ixh                        ;; error: illegal identifier
        add  iyh                        ;; error: illegal identifier
        adc  iyh                        ;; error: illegal identifier
        sbc  iyh                        ;; error: illegal identifier
        add  ixl                        ;; error: illegal identifier
        adc  ixl                        ;; error: illegal identifier
        sbc  ixl                        ;; error: illegal identifier
        add  iyl                        ;; error: illegal identifier
        adc  iyl                        ;; error: illegal identifier
        sbc  iyl                        ;; error: illegal identifier
        sub  ixh                        ;; error: illegal identifier
        and  ixh                        ;; error: illegal identifier
        xor  ixh                        ;; error: illegal identifier
        or   ixh                        ;; error: illegal identifier
        cp   ixh                        ;; error: illegal identifier
        sub  iyh                        ;; error: illegal identifier
        and  iyh                        ;; error: illegal identifier
        xor  iyh                        ;; error: illegal identifier
        or   iyh                        ;; error: illegal identifier
        cp   iyh                        ;; error: illegal identifier
        sub  ixl                        ;; error: illegal identifier
        and  ixl                        ;; error: illegal identifier
        xor  ixl                        ;; error: illegal identifier
        or   ixl                        ;; error: illegal identifier
        cp   ixl                        ;; error: illegal identifier
        sub  iyl                        ;; error: illegal identifier
        and  iyl                        ;; error: illegal identifier
        xor  iyl                        ;; error: illegal identifier
        or   iyl                        ;; error: illegal identifier
        cp   iyl                        ;; error: illegal identifier
        sub  a,ixh                      ;; error: illegal identifier
        and  a,ixh                      ;; error: illegal identifier
        xor  a,ixh                      ;; error: illegal identifier
        or   a,ixh                      ;; error: illegal identifier
        cp   a,ixh                      ;; error: illegal identifier
        sub  a,iyh                      ;; error: illegal identifier
        and  a,iyh                      ;; error: illegal identifier
        xor  a,iyh                      ;; error: illegal identifier
        or   a,iyh                      ;; error: illegal identifier
        cp   a,iyh                      ;; error: illegal identifier
        sub  a,ixl                      ;; error: illegal identifier
        and  a,ixl                      ;; error: illegal identifier
        xor  a,ixl                      ;; error: illegal identifier
        or   a,ixl                      ;; error: illegal identifier
        cp   a,ixl                      ;; error: illegal identifier
        sub  a,iyl                      ;; error: illegal identifier
        and  a,iyl                      ;; error: illegal identifier
        xor  a,iyl                      ;; error: illegal identifier
        or   a,iyl                      ;; error: illegal identifier
        cp   a,iyl                      ;; error: illegal identifier
        inc  ixh                        ;; error: illegal identifier
        dec  ixh                        ;; error: illegal identifier
        inc  iyh                        ;; error: illegal identifier
        dec  iyh                        ;; error: illegal identifier
        inc  ixl                        ;; error: illegal identifier
        dec  ixl                        ;; error: illegal identifier
        inc  iyl                        ;; error: illegal identifier
        dec  iyl                        ;; error: illegal identifier
ENDIF   
IF      !RABBIT
ELSE    
ENDIF   
IF      !RABBIT
ELSE    
        daa                             ;; error: illegal identifier
        di                              ;; error: illegal identifier
        ei                              ;; error: illegal identifier
        halt                            ;; error: illegal identifier
        im   0                          ;; error: illegal identifier
        im   1                          ;; error: illegal identifier
        im   2                          ;; error: illegal identifier
ENDIF   
        bit  -1,a                       ;; error: integer '-1' out of range
        res  -1,a                       ;; error: integer '-1' out of range
        set  -1,a                       ;; error: integer '-1' out of range
        bit  8,a                        ;; error: integer '8' out of range
        res  8,a                        ;; error: integer '8' out of range
        set  8,a                        ;; error: integer '8' out of range
        bit  undefined,a                ;; error: symbol 'undefined' not defined
        res  undefined,a                ;; error: symbol 'undefined' not defined
        set  undefined,a                ;; error: symbol 'undefined' not defined
        djnz ASMPC-0x7F                 ;; error 2: integer '-129' out of range
        djnz ASMPC+0x82                 ;; error 2: integer '128' out of range
        jr   ASMPC-0x7F                 ;; error 2: integer '-129' out of range
        jr   ASMPC+0x82                 ;; error 2: integer '128' out of range
        jr   nz,ASMPC-0x7F              ;; error 2: integer '-129' out of range
        jr   nz,ASMPC+0x82              ;; error 2: integer '128' out of range
        jr   z,ASMPC-0x7F               ;; error 2: integer '-129' out of range
        jr   z,ASMPC+0x82               ;; error 2: integer '128' out of range
        jr   nc,ASMPC-0x7F              ;; error 2: integer '-129' out of range
        jr   nc,ASMPC+0x82              ;; error 2: integer '128' out of range
        jr   c,ASMPC-0x7F               ;; error 2: integer '-129' out of range
        jr   c,ASMPC+0x82               ;; error 2: integer '128' out of range
IF      !RABBIT
ELSE    
        retn                            ;; error: illegal identifier
        rst  00h                        ;; error: illegal identifier
        rst  08h                        ;; error: illegal identifier
        rst  30h                        ;; error: illegal identifier
ENDIF   
        rst  undefined                  ;; error: symbol 'undefined' not defined
        rst  -1                         ;; error: integer '-1' out of range
        rst  1                          ;; error: integer '1' out of range
        rst  7                          ;; error: integer '7' out of range
        rst  9                          ;; error: integer '9' out of range
        rst  15                         ;; error: integer '15' out of range
        rst  17                         ;; error: integer '17' out of range
        rst  23                         ;; error: integer '23' out of range
        rst  25                         ;; error: integer '25' out of range
        rst  31                         ;; error: integer '31' out of range
        rst  33                         ;; error: integer '33' out of range
        rst  39                         ;; error: integer '39' out of range
        rst  41                         ;; error: integer '41' out of range
        rst  47                         ;; error: integer '47' out of range
        rst  49                         ;; error: integer '49' out of range
        rst  55                         ;; error: integer '55' out of range
        rst  57                         ;; error: integer '57' out of range
IF      !RABBIT
ELSE    
        in   a,(0)                      ;; error: illegal identifier
        in   b,(c)                      ;; error: illegal identifier
        in   c,(c)                      ;; error: illegal identifier
        in   d,(c)                      ;; error: illegal identifier
        in   e,(c)                      ;; error: illegal identifier
        in   h,(c)                      ;; error: illegal identifier
        in   l,(c)                      ;; error: illegal identifier
        in   a,(c)                      ;; error: illegal identifier
        ini                             ;; error: illegal identifier
        inir                            ;; error: illegal identifier
        ind                             ;; error: illegal identifier
        indr                            ;; error: illegal identifier
        out  (0),a                      ;; error: illegal identifier
        out  (c),b                      ;; error: illegal identifier
        out  (c),c                      ;; error: illegal identifier
        out  (c),d                      ;; error: illegal identifier
        out  (c),e                      ;; error: illegal identifier
        out  (c),h                      ;; error: illegal identifier
        out  (c),l                      ;; error: illegal identifier
        out  (c),a                      ;; error: illegal identifier
        outi                            ;; error: illegal identifier
        otir                            ;; error: illegal identifier
        outd                            ;; error: illegal identifier
        otdr                            ;; error: illegal identifier
ENDIF   
ds:     defs not_defined                ;; error: symbol 'not_defined' not defined
                                        ; BUG_0007
        defs -1                         ;; error: integer '-1' out of range
        defs 65537                      ;; error: integer '65537' out of range
        defs 2,not_defined              ;; error: symbol 'not_defined' not defined
        defs 2,-129                     ;; error: integer '-129' out of range
        defs 2,256                      ;; error: integer '256' out of range
IF      !RABBIT
ENDIF   
IF      !RABBIT
ENDIF   
        call_oz 0                       ;; error: integer '0' out of range
        call_oz 65536                   ;; error: integer '65536' out of range
IF      !RABBIT
ENDIF   
        fpp  0                          ;; error: integer '0' out of range
        fpp  255                        ;; error: integer '255' out of range
        fpp  256                        ;; error: integer '256' out of range
        invoke -1                       ;; error: integer '-1' out of range
        invoke 65536                    ;; error: integer '65536' out of range
END_ASM
);
