" VIM Syntax file for txr
" Kaz Kylheku <kaz@kylheku.com>

" INSTALL-HOWTO:
"
" 1. Create the directory .vim/syntax in your home directory and
"    put the files txr.vim and tl.vim into this directory.
" 2. In your .vimrc, add this command to associate *.txr, *.tl and *.tlo
"    files with the txr and tl filetypes:
"    :au BufRead,BufNewFile *.txr set filetype=txr | set lisp
"    :au BufRead,BufNewFile *.tl,*.tlo set filetype=tl | set lisp
"
" If you want syntax highlighting to be on automatically (for any language)
" you need to add ":syntax on" in your .vimrc also. But you knew that already!
"
" This file is generated by the genvim.txr script in the TXR source tree.

syn case match
syn spell toplevel

setlocal iskeyword=a-z,A-Z,48-57,!,$,%,&,*,+,-,<,=,>,?,\\,_,~,/,^

syn keyword tl_keyword contained %e% %pi% * *args*
syn keyword tl_keyword contained *args-eff* *args-full* *child-env* *doc-url*
syn keyword tl_keyword contained *filters* *full-args* *gensym-counter* *hash-seed*
syn keyword tl_keyword contained *lib-version* *listener-greedy-eval-p* *listener-hist-len* *listener-multi-line-p*
syn keyword tl_keyword contained *listener-pprint-p* *listener-sel-inclusive-p* *load-hooks* *load-path*
syn keyword tl_keyword contained *match-macro* *opt-level* *package* *package-alist*
syn keyword tl_keyword contained *param-macro* *place-clobber-expander* *place-delete-expander* *place-macro*
syn keyword tl_keyword contained *place-update-expander* *pprint-flo-format* *print-base* *print-circle*
syn keyword tl_keyword contained *print-flo-digits* *print-flo-format* *print-flo-precision* *random-state*
syn keyword tl_keyword contained *random-warmup* *read-bad-json* *read-unknown-structs* *rec-source-loc*
syn keyword tl_keyword contained *stddebug* *stderr* *stdin* *stdlog*
syn keyword tl_keyword contained *stdnull* *stdout* *struct-clause-expander* *trace-output*
syn keyword tl_keyword contained *tree-fun-whitelist* *txr-version* *unhandled-hook* +
syn keyword tl_keyword contained - / /= :
syn keyword tl_keyword contained :abandoned :abs :addr :all
syn keyword tl_keyword contained :android :apf :append :args
syn keyword tl_keyword contained :atime :auto :awk-again :awk-file
syn keyword tl_keyword contained :awk-rec :begin :begin-file :blksize
syn keyword tl_keyword contained :blocks :bool :byte-oriented :cdigit
syn keyword tl_keyword contained :chars :cint :close :continue
syn keyword tl_keyword contained :counter :cspace :ctime :cword-char
syn keyword tl_keyword contained :cygnal :cygwin :dec :decline
syn keyword tl_keyword contained :delegate :dev :digit :downcase
syn keyword tl_keyword contained :end :end-file :env :eq-based
syn keyword tl_keyword contained :eql-based :equal-based :explicit-no :fallback
syn keyword tl_keyword contained :fd :fence :fields :filter
syn keyword tl_keyword contained :fini :finish :float :form
syn keyword tl_keyword contained :from-current :from-end :from-start :from_html
syn keyword tl_keyword contained :frombase64 :frombase64url :fromhtml :frompercent
syn keyword tl_keyword contained :fromurl :fun :function :gap
syn keyword tl_keyword contained :gid :greedy :hex :hextoint
syn keyword tl_keyword contained :inf :init :ino :inp
syn keyword tl_keyword contained :inputs :instance :into :key
syn keyword tl_keyword contained :let :lfilt :lines :linux
syn keyword tl_keyword contained :list :lists :local :longest
syn keyword tl_keyword contained :macos :mandatory :mass-delegate :match
syn keyword tl_keyword contained :maxgap :maxtimes :method :mid
syn keyword tl_keyword contained :mingap :mintimes :mode :mtime
syn keyword tl_keyword contained :name :named :next-spec :nlink
syn keyword tl_keyword contained :nothrow :oct :openbsd :outf
syn keyword tl_keyword contained :outp :output :owner :perms
syn keyword tl_keyword contained :postinit :prio :rdev :real-time
syn keyword tl_keyword contained :reflect :repeat-spec :resolve :rfilt
syn keyword tl_keyword contained :set :set-file :shortest :size
syn keyword tl_keyword contained :solaris :solaris10 :space :static
syn keyword tl_keyword contained :str :string :symacro :symlinks
syn keyword tl_keyword contained :text :times :tlist :to_html
syn keyword tl_keyword contained :tobase64 :tobase64url :tofloat :tohtml
syn keyword tl_keyword contained :tohtml* :toint :tonumber :topercent
syn keyword tl_keyword contained :tourl :uid :unknown :upcase
syn keyword tl_keyword contained :use :use-from :use-syms :userdata
syn keyword tl_keyword contained :var :vars :weak-and :weak-keys
syn keyword tl_keyword contained :weak-or :weak-vals :whole :word-char
syn keyword tl_keyword contained :wrap < <= =
syn keyword tl_keyword contained > >= abort abs
syn keyword tl_keyword contained abs-path-p acons acons-new aconsql-new
syn keyword tl_keyword contained acos acosh add-suffix ado
syn keyword tl_keyword contained af-inet af-inet6 af-unix af-unspec
syn keyword tl_keyword contained ai-addrconfig ai-all ai-canonname ai-numerichost
syn keyword tl_keyword contained ai-numericserv ai-passive ai-v4mapped alet
syn keyword tl_keyword contained align alignof alist-nremove alist-remove
syn keyword tl_keyword contained all allocate-struct and andf
syn keyword tl_keyword contained ap apf append append*
syn keyword tl_keyword contained append-each append-each* append-each-prod append-each-prod*
syn keyword tl_keyword contained append-match-products append-matches apply aret
syn keyword tl_keyword contained array arraysize ash asin
syn keyword tl_keyword contained asinh assert assoc assq
syn keyword tl_keyword contained assql at-exit-call at-exit-do-not-call atan
syn keyword tl_keyword contained atan2 atanh atom awk
syn keyword tl_keyword contained base-name base64-decode base64-decode-buf base64-encode
syn keyword tl_keyword contained base64-stream-dec base64-stream-enc base64url-decode base64url-decode-buf
syn keyword tl_keyword contained base64url-encode base64url-stream-dec base64url-stream-enc bchar
syn keyword tl_keyword contained be-double be-float be-int16 be-int32
syn keyword tl_keyword contained be-int64 be-uint16 be-uint32 be-uint64
syn keyword tl_keyword contained bignum-len bignump bindable bit
syn keyword tl_keyword contained bitset blkcnt-t blksize-t block
syn keyword tl_keyword contained block* bool boundp bracket
syn keyword tl_keyword contained break-str brkint bs0 bs1
syn keyword tl_keyword contained bsdly bstr bstr-d buf
syn keyword tl_keyword contained buf-alloc-size buf-carray buf-d buf-get-char
syn keyword tl_keyword contained buf-get-cptr buf-get-double buf-get-float buf-get-i16
syn keyword tl_keyword contained buf-get-i32 buf-get-i64 buf-get-i8 buf-get-int
syn keyword tl_keyword contained buf-get-long buf-get-short buf-get-u16 buf-get-u32
syn keyword tl_keyword contained buf-get-u64 buf-get-u8 buf-get-uchar buf-get-uint
syn keyword tl_keyword contained buf-get-ulong buf-get-ushort buf-int buf-list
syn keyword tl_keyword contained buf-put-buf buf-put-char buf-put-cptr buf-put-double
syn keyword tl_keyword contained buf-put-float buf-put-i16 buf-put-i32 buf-put-i64
syn keyword tl_keyword contained buf-put-i8 buf-put-int buf-put-long buf-put-short
syn keyword tl_keyword contained buf-put-u16 buf-put-u32 buf-put-u64 buf-put-u8
syn keyword tl_keyword contained buf-put-uchar buf-put-uint buf-put-ulong buf-put-ushort
syn keyword tl_keyword contained buf-set-length buf-str buf-trim buf-uint
syn keyword tl_keyword contained bufp build build-list buildn
syn keyword tl_keyword contained built-in-type-p butlast butlastn caaaaar
syn keyword tl_keyword contained caaaadr caaaar caaadar caaaddr
syn keyword tl_keyword contained caaadr caaar caadaar caadadr
syn keyword tl_keyword contained caadar caaddar caadddr caaddr
syn keyword tl_keyword contained caadr caar cadaaar cadaadr
syn keyword tl_keyword contained cadaar cadadar cadaddr cadadr
syn keyword tl_keyword contained cadar caddaar caddadr caddar
syn keyword tl_keyword contained cadddar caddddr cadddr caddr
syn keyword tl_keyword contained cadr call call-clobber-expander call-delete-expander
syn keyword tl_keyword contained call-finalizers call-super-fun call-super-method call-update-expander
syn keyword tl_keyword contained callf car carray carray-blank
syn keyword tl_keyword contained carray-buf carray-buf-sync carray-cptr carray-dup
syn keyword tl_keyword contained carray-free carray-get carray-getz carray-int
syn keyword tl_keyword contained carray-list carray-own carray-pun carray-put
syn keyword tl_keyword contained carray-putz carray-ref carray-refset carray-replace
syn keyword tl_keyword contained carray-set-length carray-sub carray-type carray-uint
syn keyword tl_keyword contained carray-vec carrayp caseq caseq*
syn keyword tl_keyword contained caseql caseql* casequal casequal*
syn keyword tl_keyword contained cat-files cat-str cat-streams cat-vec
syn keyword tl_keyword contained catch catch* catch** catenated-stream-p
syn keyword tl_keyword contained catenated-stream-push cbaud cbaudex cdaaaar
syn keyword tl_keyword contained cdaaadr cdaaar cdaadar cdaaddr
syn keyword tl_keyword contained cdaadr cdaar cdadaar cdadadr
syn keyword tl_keyword contained cdadar cdaddar cdadddr cdaddr
syn keyword tl_keyword contained cdadr cdar cddaaar cddaadr
syn keyword tl_keyword contained cddaar cddadar cddaddr cddadr
syn keyword tl_keyword contained cddar cdddaar cdddadr cdddar
syn keyword tl_keyword contained cddddar cdddddr cddddr cdddr
syn keyword tl_keyword contained cddr cdr ceil ceil-rem
syn keyword tl_keyword contained chain chand char chdir
syn keyword tl_keyword contained chmod chmod-rec chown chown-rec
syn keyword tl_keyword contained chr-digit chr-int chr-isalnum chr-isalpha
syn keyword tl_keyword contained chr-isascii chr-isblank chr-iscntrl chr-isdigit
syn keyword tl_keyword contained chr-isgraph chr-islower chr-isprint chr-ispunct
syn keyword tl_keyword contained chr-isspace chr-isunisp chr-isupper chr-isxdigit
syn keyword tl_keyword contained chr-num chr-str chr-str-set chr-tolower
syn keyword tl_keyword contained chr-toupper chr-xdigit chrp clamp
syn keyword tl_keyword contained clear-dirty clear-error clear-mask clear-struct
syn keyword tl_keyword contained clearhash clocal clock-t clockid-t
syn keyword tl_keyword contained close close-stream closedir closelog
syn keyword tl_keyword contained closure cmp-str cmspar coded-length
syn keyword tl_keyword contained collect-each collect-each* collect-each-prod collect-each-prod*
syn keyword tl_keyword contained comb command-get command-get-buf command-get-json
syn keyword tl_keyword contained command-get-jsons command-get-lines command-get-string command-put
syn keyword tl_keyword contained command-put-buf command-put-json command-put-jsons command-put-lines
syn keyword tl_keyword contained command-put-string compare-swap compile compile-defr-warning
syn keyword tl_keyword contained compile-error compile-file compile-only compile-toplevel
syn keyword tl_keyword contained compile-update-file compile-warning compl-span-str cond
syn keyword tl_keyword contained conda condlet cons conses
syn keyword tl_keyword contained conses* consp constantp contain[s]
syn keyword tl_keyword contained copy copy-alist copy-buf copy-carray
syn keyword tl_keyword contained copy-cons copy-cptr copy-file copy-files
syn keyword tl_keyword contained copy-fun copy-hash copy-list copy-path-rec
syn keyword tl_keyword contained copy-search-tree copy-str copy-struct copy-tnode
syn keyword tl_keyword contained copy-tree copy-tree-iter copy-vec cos
syn keyword tl_keyword contained cosh count-if count-until-match countq
syn keyword tl_keyword contained countql countqual cptr cptr-buf
syn keyword tl_keyword contained cptr-carray cptr-cast cptr-free cptr-get
syn keyword tl_keyword contained cptr-int cptr-null cptr-obj cptr-out
syn keyword tl_keyword contained cptr-size-hint cptr-type cptr-zap cptrp
syn keyword tl_keyword contained cr0 cr1 cr2 cr3
syn keyword tl_keyword contained crc32 crc32-stream crdly cread
syn keyword tl_keyword contained crtscts crypt cs5 cs6
syn keyword tl_keyword contained cs7 cs8 csize cstopb
syn keyword tl_keyword contained cum-norm-dist cxr cyr daemon
syn keyword tl_keyword contained dec defer-warning defex deffi
syn keyword tl_keyword contained deffi-cb deffi-cb-unsafe deffi-struct deffi-sym
syn keyword tl_keyword contained deffi-type deffi-union deffi-var define-accessor
syn keyword tl_keyword contained define-modify-macro define-option-struct define-param-expander define-place-macro
syn keyword tl_keyword contained define-struct-clause defmacro defmatch defmeth
syn keyword tl_keyword contained defpackage defparm defparml defplace
syn keyword tl_keyword contained defset defstruct defsymacro defun
syn keyword tl_keyword contained defun-match defvar defvarl del
syn keyword tl_keyword contained delay delcons delete-package dev-t
syn keyword tl_keyword contained diff digits digpow dir-name
syn keyword tl_keyword contained dirstat disassemble display-width divides
syn keyword tl_keyword contained dlclose dlopen dlsym dlsym-checked
syn keyword tl_keyword contained dlvsym dlvsym-checked do doc
syn keyword tl_keyword contained dohash doloop doloop* dotimes
syn keyword tl_keyword contained double downcase-str drop drop-until
syn keyword tl_keyword contained drop-while dt-blk dt-chr dt-dir
syn keyword tl_keyword contained dt-fifo dt-lnk dt-reg dt-sock
syn keyword tl_keyword contained dt-unknown dump-compiled-objects dump-deferred-warnings dup
syn keyword tl_keyword contained dupfd dwim e2big eacces
syn keyword tl_keyword contained each each* each-false each-match
syn keyword tl_keyword contained each-match-product each-prod each-prod* each-true
syn keyword tl_keyword contained eaddrinuse eaddrnotavail eafnosupport eagain
syn keyword tl_keyword contained ealready ebadf ebadmsg ebusy
syn keyword tl_keyword contained ecanceled ecaseq ecaseq* ecaseql
syn keyword tl_keyword contained ecaseql* ecasequal ecasequal* echild
syn keyword tl_keyword contained echo echoctl echoe echok
syn keyword tl_keyword contained echoke echonl echoprt econnaborted
syn keyword tl_keyword contained econnrefused econnreset edeadlk edestaddrreq
syn keyword tl_keyword contained edom edquot eexist efault
syn keyword tl_keyword contained efbig ehostunreach eidrm eighth
syn keyword tl_keyword contained eilseq einprogress eintr einval
syn keyword tl_keyword contained eio eisconn eisdir elemsize
syn keyword tl_keyword contained elemtype eloop emfile emlink
syn keyword tl_keyword contained empty emsgsize emultihop enametoolong
syn keyword tl_keyword contained endgrent endp endpwent ends-with
syn keyword tl_keyword contained enetdown enetreset enetunreach enfile
syn keyword tl_keyword contained enobufs enodata enodev enoent
syn keyword tl_keyword contained enoexec enolck enolink enomem
syn keyword tl_keyword contained enomsg enoprotoopt enospc enosr
syn keyword tl_keyword contained enostr enosys enotconn enotdir
syn keyword tl_keyword contained enotempty enotrecoverable enotsock enotsup
syn keyword tl_keyword contained enotty ensure-dir enum enumed
syn keyword tl_keyword contained env env-fbind env-fbindings env-hash
syn keyword tl_keyword contained env-next env-vbind env-vbindings enxio
syn keyword tl_keyword contained eopnotsupp eoverflow eownerdead eperm
syn keyword tl_keyword contained epipe eproto eprotonosupport eprototype
syn keyword tl_keyword contained eq eql equal equot
syn keyword tl_keyword contained erange erofs errno error
syn keyword tl_keyword contained espipe esrch estale etime
syn keyword tl_keyword contained etimedout etxtbsy etypecase eval
syn keyword tl_keyword contained eval-only evenp ewouldblock exception-subtype-map
syn keyword tl_keyword contained exception-subtype-p exdev exec exit
syn keyword tl_keyword contained exit* exp expand expand*
syn keyword tl_keyword contained expand-left expand-right expand-with-free-refs expt
syn keyword tl_keyword contained exptmod extproc f$ f-dupfd
syn keyword tl_keyword contained f-dupfd-cloexec f-getfd f-getfl f-getlk
syn keyword tl_keyword contained f-rdlck f-setfd f-setfl f-setlk
syn keyword tl_keyword contained f-setlkw f-unlck f-wrlck f^
syn keyword tl_keyword contained f^$ false fboundp fcntl
syn keyword tl_keyword contained fd-cloexec ff0 ff1 ffdly
syn keyword tl_keyword contained ffi ffi-alignof ffi-arraysize ffi-call
syn keyword tl_keyword contained ffi-elemsize ffi-elemtype ffi-get ffi-in
syn keyword tl_keyword contained ffi-make-call-desc ffi-make-closure ffi-offsetof ffi-out
syn keyword tl_keyword contained ffi-put ffi-put-into ffi-size ffi-type-compile
syn keyword tl_keyword contained ffi-type-operator-p ffi-type-p ffi-typedef fifth
syn keyword tl_keyword contained file-append file-append-buf file-append-json file-append-jsons
syn keyword tl_keyword contained file-append-lines file-append-string file-get file-get-buf
syn keyword tl_keyword contained file-get-json file-get-jsons file-get-lines file-get-string
syn keyword tl_keyword contained file-place-buf file-put file-put-buf file-put-json
syn keyword tl_keyword contained file-put-jsons file-put-lines file-put-string fileno
syn keyword tl_keyword contained fill-buf fill-buf-adjust fill-carray fill-obj
syn keyword tl_keyword contained fill-vec filter-equal filter-string-tree finalize
syn keyword tl_keyword contained find find-frame find-frames find-frames-by-mask
syn keyword tl_keyword contained find-if find-max find-max-key find-min
syn keyword tl_keyword contained find-min-key find-package find-struct-type find-symbol
syn keyword tl_keyword contained find-symbol-fb find-true first fixnum-max
syn keyword tl_keyword contained fixnum-min fixnump flatcar flatcar*
syn keyword tl_keyword contained flatten flatten* flet flip
syn keyword tl_keyword contained flipargs flo-dig flo-down flo-epsilon
syn keyword tl_keyword contained flo-get-round-mode flo-int flo-max flo-max-dig
syn keyword tl_keyword contained flo-min flo-near flo-set-round-mode flo-str
syn keyword tl_keyword contained flo-up flo-zero float floatp
syn keyword tl_keyword contained floor floor-rem flow flush-stream
syn keyword tl_keyword contained flusho fmakunbound fmt fnm-casefold
syn keyword tl_keyword contained fnm-extmatch fnm-leading-dir fnm-noescape fnm-pathname
syn keyword tl_keyword contained fnm-period fnmatch for for*
syn keyword tl_keyword contained force force-break fork format
syn keyword tl_keyword contained fourth fr$ fr^ fr^$
syn keyword tl_keyword contained from frr fsblkcnt-t fsfilcnt-t
syn keyword tl_keyword contained fstat ftw ftw-actionretval ftw-chdir
syn keyword tl_keyword contained ftw-continue ftw-d ftw-depth ftw-dnr
syn keyword tl_keyword contained ftw-dp ftw-f ftw-mount ftw-ns
syn keyword tl_keyword contained ftw-phys ftw-skip-siblings ftw-skip-subtree ftw-sl
syn keyword tl_keyword contained ftw-sln ftw-stop fun fun-fixparam-count
syn keyword tl_keyword contained fun-optparam-count fun-variadic func-get-env func-get-form
syn keyword tl_keyword contained func-get-name func-set-env functionp gcd
syn keyword tl_keyword contained gen gen-hash-seed generate gensym
syn keyword tl_keyword contained gequal get-buf-from-stream get-byte get-char
syn keyword tl_keyword contained get-clobber-expander get-delete-expander get-error get-error-str
syn keyword tl_keyword contained get-frames get-hash-userdata get-indent get-indent-mode
syn keyword tl_keyword contained get-json get-jsons get-line get-line-as-buf
syn keyword tl_keyword contained get-lines get-list-from-stream get-obj get-sig-handler
syn keyword tl_keyword contained get-stack-limit get-string get-string-from-stream get-update-expander
syn keyword tl_keyword contained getaddrinfo getegid getenv geteuid
syn keyword tl_keyword contained getgid getgrent getgrgid getgrnam
syn keyword tl_keyword contained getgroups gethash getitimer getopts
syn keyword tl_keyword contained getpid getppid getpwent getpwnam
syn keyword tl_keyword contained getpwuid getresgid getresuid getrlimit
syn keyword tl_keyword contained getuid gid-t ginterate giterate
syn keyword tl_keyword contained glob glob-altdirfunc glob-brace glob-err
syn keyword tl_keyword contained glob-mark glob-nocheck glob-noescape glob-nomagic
syn keyword tl_keyword contained glob-nosort glob-onlydir glob-period glob-tilde
syn keyword tl_keyword contained glob-tilde-check go grade greater
syn keyword tl_keyword contained group-by group-reduce gun handle
syn keyword tl_keyword contained handle* handler-bind hash hash-alist
syn keyword tl_keyword contained hash-begin hash-construct hash-count hash-diff
syn keyword tl_keyword contained hash-eql hash-equal hash-from-alist hash-from-pairs
syn keyword tl_keyword contained hash-invert hash-isec hash-keys hash-keys-of
syn keyword tl_keyword contained hash-list hash-next hash-pairs hash-peek
syn keyword tl_keyword contained hash-proper-subset hash-reset hash-revget hash-subset
syn keyword tl_keyword contained hash-symdiff hash-uni hash-update hash-update-1
syn keyword tl_keyword contained hash-userdata hash-values hash-zip hashp
syn keyword tl_keyword contained have hlet hlet* html-decode
syn keyword tl_keyword contained html-encode html-encode* hupcl iapply
syn keyword tl_keyword contained icanon icrnl id-t identity
syn keyword tl_keyword contained identity* ido iexten if
syn keyword tl_keyword contained if-match ifa iff iffi
syn keyword tl_keyword contained iflet ignbrk igncr ignerr
syn keyword tl_keyword contained ignpar ignwarn imaxbel improper-plist-to-alist
syn keyword tl_keyword contained in in-package in-range in-range*
syn keyword tl_keyword contained in6addr-any in6addr-loopback in6addr-str inaddr-any
syn keyword tl_keyword contained inaddr-loopback inaddr-str inc inc-indent
syn keyword tl_keyword contained indent-code indent-data indent-foff indent-off
syn keyword tl_keyword contained inhash inlcr ino-t inpck
syn keyword tl_keyword contained int int-buf int-carray int-chr
syn keyword tl_keyword contained int-cptr int-flo int-ptr-t int-str
syn keyword tl_keyword contained int16 int32 int64 int8
syn keyword tl_keyword contained integerp intern intern-fb interp-fun-p
syn keyword tl_keyword contained interpose inv-cum-norm invoke-catch ip
syn keyword tl_keyword contained ipf ipproto-ip ipproto-ipv6 ipproto-tcp
syn keyword tl_keyword contained ipproto-udp ipv6-join-group ipv6-leave-group ipv6-multicast-hops
syn keyword tl_keyword contained ipv6-multicast-if ipv6-multicast-loop ipv6-unicast-hops ipv6-v6only
syn keyword tl_keyword contained iread isatty isec isig
syn keyword tl_keyword contained isqrt istrip iter-begin iter-item
syn keyword tl_keyword contained iter-more iter-reset iter-step iterable
syn keyword tl_keyword contained itimer-prof itimer-real itimer-virtual iuclc
syn keyword tl_keyword contained iutf8 ixany ixoff ixon
syn keyword tl_keyword contained join join-with json juxt
syn keyword tl_keyword contained keep-if keep-if* keep-match-products keep-matches
syn keyword tl_keyword contained keepq keepql keepqual key
syn keyword tl_keyword contained key-t keyword-package keywordp kill
syn keyword tl_keyword contained labels lambda lambda-match last
syn keyword tl_keyword contained lazy-str lazy-str-force lazy-str-force-upto lazy-str-get-trailing-list
syn keyword tl_keyword contained lazy-stream-cons lazy-stringp lchown lcm
syn keyword tl_keyword contained lcons lcons-car lcons-cdr lcons-fun
syn keyword tl_keyword contained lconsp ldiff ldo le-double
syn keyword tl_keyword contained le-float le-int16 le-int32 le-int64
syn keyword tl_keyword contained le-uint16 le-uint32 le-uint64 left
syn keyword tl_keyword contained len length length-buf length-carray
syn keyword tl_keyword contained length-list length-str length-str-< length-str-<=
syn keyword tl_keyword contained length-str-> length-str->= length-vec lequal
syn keyword tl_keyword contained less let let* lexical-fun-p
syn keyword tl_keyword contained lexical-lisp1-binding lexical-var-p lib-version link
syn keyword tl_keyword contained lisp-parse list list* list-carray
syn keyword tl_keyword contained list-seq list-str list-vec list-vector
syn keyword tl_keyword contained listp lnew lnew* load
syn keyword tl_keyword contained load-for load-time loff-t log
syn keyword tl_keyword contained log-alert log-auth log-authpriv log-cons
syn keyword tl_keyword contained log-crit log-daemon log-debug log-emerg
syn keyword tl_keyword contained log-err log-info log-ndelay log-notice
syn keyword tl_keyword contained log-nowait log-odelay log-perror log-pid
syn keyword tl_keyword contained log-user log-warning log10 log2
syn keyword tl_keyword contained logand logcount logior lognot
syn keyword tl_keyword contained logtest logtrunc logxor long
syn keyword tl_keyword contained long-suffix longlong lop lset
syn keyword tl_keyword contained lstat lutimes m$ m^
syn keyword tl_keyword contained m^$ mac-env-param-bind mac-param-bind macro-ancestor
syn keyword tl_keyword contained macro-form-p macro-time macroexpand macroexpand-1
syn keyword tl_keyword contained macroexpand-1-lisp1 macroexpand-lisp1 macrolet madv-dodump
syn keyword tl_keyword contained madv-dofork madv-dontdump madv-dontfork madv-dontneed
syn keyword tl_keyword contained madv-free madv-hugepage madv-hwpoison madv-keeponfork
syn keyword tl_keyword contained madv-mergeable madv-nohugepage madv-normal madv-random
syn keyword tl_keyword contained madv-remove madv-sequential madv-unmergeable madv-willneed
syn keyword tl_keyword contained madv-wipeonfork madvise major make-buf
syn keyword tl_keyword contained make-buf-stream make-byte-input-stream make-catenated-stream make-env
syn keyword tl_keyword contained make-hash make-lazy-cons make-lazy-struct make-like
syn keyword tl_keyword contained make-package make-random-state make-similar-hash make-similar-tree
syn keyword tl_keyword contained make-string-byte-input-stream make-string-input-stream make-string-output-stream make-strlist-input-stream
syn keyword tl_keyword contained make-strlist-output-stream make-struct make-struct-delegate-stream make-struct-type
syn keyword tl_keyword contained make-sym make-time make-time-utc make-trie
syn keyword tl_keyword contained make-union make-zstruct makedev makunbound
syn keyword tl_keyword contained map-anon map-fixed map-growsdown map-huge-mask
syn keyword tl_keyword contained map-huge-shift map-hugetlb map-locked map-nonblock
syn keyword tl_keyword contained map-noreserve map-populate map-private map-shared
syn keyword tl_keyword contained map-stack mapcar mapcar* mapdo
syn keyword tl_keyword contained mapf maphash mappend mappend*
syn keyword tl_keyword contained maprend maprod maprodo mask
syn keyword tl_keyword contained match match-case match-ecase match-error
syn keyword tl_keyword contained match-fboundp match-fun match-regex match-regex-right
syn keyword tl_keyword contained match-regst match-regst-right match-str match-str-tree
syn keyword tl_keyword contained max mboundp md5 md5-begin
syn keyword tl_keyword contained md5-end md5-hash md5-stream member
syn keyword tl_keyword contained member-if memp memq memql
syn keyword tl_keyword contained memqual meq meql mequal
syn keyword tl_keyword contained merge merge-delete-package meth method
syn keyword tl_keyword contained min minor minusp mismatch
syn keyword tl_keyword contained mkdir mkdtemp mkfifo mknod
syn keyword tl_keyword contained mkstemp mkstring mlet mmakunbound
syn keyword tl_keyword contained mmap mod mode-t mprotect
syn keyword tl_keyword contained ms-async ms-invalidate ms-sync msync
syn keyword tl_keyword contained mul-each mul-each* mul-each-prod mul-each-prod*
syn keyword tl_keyword contained multi multi-sort munmap n-choose-k
syn keyword tl_keyword contained n-perm-k nand nandf nconc
syn keyword tl_keyword contained neg neq neql nequal
syn keyword tl_keyword contained new new* nexpand-left nil
syn keyword tl_keyword contained nilf ninth nl0 nl1
syn keyword tl_keyword contained nldly nlink-t noflsh none
syn keyword tl_keyword contained nor norf not notf
syn keyword tl_keyword contained nreconc nreverse nrot nshuffle
syn keyword tl_keyword contained nsort nth nthcdr nthlast
syn keyword tl_keyword contained null nullify num-chr num-str
syn keyword tl_keyword contained numberp nzerop o-accmode o-append
syn keyword tl_keyword contained o-async o-cloexec o-creat o-direct
syn keyword tl_keyword contained o-directory o-noatime o-noctty o-nofollow
syn keyword tl_keyword contained o-nonblock o-path o-rdonly o-rdwr
syn keyword tl_keyword contained o-sync o-trunc o-wronly oand
syn keyword tl_keyword contained obtain obtain* obtain*-block obtain-block
syn keyword tl_keyword contained ocrnl oddp ofdel off-t
syn keyword tl_keyword contained offsetof ofill olcuc onlcr
syn keyword tl_keyword contained onlret onocr op open-command
syn keyword tl_keyword contained open-directory open-file open-fileno open-files
syn keyword tl_keyword contained open-files* open-pipe open-process open-socket
syn keyword tl_keyword contained open-socket-pair open-subprocess open-tail opendir
syn keyword tl_keyword contained openlog opip opost opt
syn keyword tl_keyword contained opthelp opthelp-conventions opthelp-types or
syn keyword tl_keyword contained orf package-alist package-fallback-list package-foreign-symbols
syn keyword tl_keyword contained package-local-symbols package-name package-symbols packagep
syn keyword tl_keyword contained pad page-size pairlis parenb
syn keyword tl_keyword contained parmrk parodd parse-errors partition
syn keyword tl_keyword contained partition* partition-by partition-if path-blkdev-p
syn keyword tl_keyword contained path-cat path-chrdev-p path-dir-empty path-dir-p
syn keyword tl_keyword contained path-equal path-executable-to-me-p path-exists-p path-file-p
syn keyword tl_keyword contained path-mine-p path-my-group-p path-newer path-older
syn keyword tl_keyword contained path-pipe-p path-private-to-me-p path-read-writable-to-me-p path-readable-to-me-p
syn keyword tl_keyword contained path-same-object path-search path-sep-chars path-setgid-p
syn keyword tl_keyword contained path-setuid-p path-sock-p path-sticky-p path-strictly-private-to-me-p
syn keyword tl_keyword contained path-symlink-p path-writable-to-me-p pdec pendin
syn keyword tl_keyword contained perm pic pid-t pinc
syn keyword tl_keyword contained pipe place-form-p placelet placelet*
syn keyword tl_keyword contained plist-to-alist plusp poll poll-err
syn keyword tl_keyword contained poll-in poll-nval poll-out poll-pri
syn keyword tl_keyword contained poll-rdband poll-rdhup poll-wrband poly
syn keyword tl_keyword contained pop pop-after-load portable-abs-path-p pos
syn keyword tl_keyword contained pos-if pos-max pos-min posq
syn keyword tl_keyword contained posql posqual pppred ppred
syn keyword tl_keyword contained pprinl pprint pprof pred
syn keyword tl_keyword contained prinl print prod prof
syn keyword tl_keyword contained prog prog* prog1 prog2
syn keyword tl_keyword contained progn promisep prop proper-list-p
syn keyword tl_keyword contained proper-listp prot-exec prot-growsdown prot-growsup
syn keyword tl_keyword contained prot-none prot-read prot-write pset
syn keyword tl_keyword contained ptr ptr-in ptr-in-d ptr-out
syn keyword tl_keyword contained ptr-out-d ptr-out-s ptrdiff-t pub:txr-sym
syn keyword tl_keyword contained pure-rel-path-p purge-deferred-warning push push-after-load
syn keyword tl_keyword contained pushhash pushnew put-buf put-byte
syn keyword tl_keyword contained put-carray put-char put-json put-jsonl
syn keyword tl_keyword contained put-jsons put-line put-lines put-obj
syn keyword tl_keyword contained put-string put-strings pwd qquote
syn keyword tl_keyword contained qref quantile quip quote
syn keyword tl_keyword contained r$ r^ r^$ raise
syn keyword tl_keyword contained rand random random-buf random-fixnum
syn keyword tl_keyword contained random-float random-float-incl random-sample random-state-get-vec
syn keyword tl_keyword contained random-state-p range range* range-regex
syn keyword tl_keyword contained rangep rassoc rassq rassql
syn keyword tl_keyword contained rcomb rcons read read-once
syn keyword tl_keyword contained read-until-match readdir readlink real-time-stream-p
syn keyword tl_keyword contained realpath record-adapter reduce-left reduce-right
syn keyword tl_keyword contained ref refset regex-compile regex-from-trie
syn keyword tl_keyword contained regex-optimize regex-parse regex-prefix-match regex-source
syn keyword tl_keyword contained regexp register-exception-subtypes register-tentative-def regsub
syn keyword tl_keyword contained rehome-sym reject rel-path relate
syn keyword tl_keyword contained release-deferred-warnings remhash remove-if remove-if*
syn keyword tl_keyword contained remove-path remove-path-rec remq remq*
syn keyword tl_keyword contained remql remql* remqual remqual*
syn keyword tl_keyword contained rename-path repeat replace replace-buf
syn keyword tl_keyword contained replace-env replace-list replace-str replace-struct
syn keyword tl_keyword contained replace-tree-iter replace-vec reset-struct rest
syn keyword tl_keyword contained ret retf return return*
syn keyword tl_keyword contained return-from revappend reverse rfind
syn keyword tl_keyword contained rfind-if right rlcp rlcp-tree
syn keyword tl_keyword contained rlet rlim-infinity rlim-saved-cur rlim-saved-max
syn keyword tl_keyword contained rlimit-as rlimit-core rlimit-cpu rlimit-data
syn keyword tl_keyword contained rlimit-fsize rlimit-nofile rlimit-stack rlist
syn keyword tl_keyword contained rlist* rmdir rmember rmember-if
syn keyword tl_keyword contained rmemq rmemql rmemqual rmismatch
syn keyword tl_keyword contained rot rotate round round-rem
syn keyword tl_keyword contained rperm rplaca rplacd rpoly
syn keyword tl_keyword contained rpos rpos-if rposq rposql
syn keyword tl_keyword contained rposqual rr rra rsearch
syn keyword tl_keyword contained rslot rtld-deepbind rtld-global rtld-lazy
syn keyword tl_keyword contained rtld-local rtld-nodelete rtld-noload rtld-now
syn keyword tl_keyword contained run s-ifblk s-ifchr s-ifdir
syn keyword tl_keyword contained s-ififo s-iflnk s-ifmt s-ifreg
syn keyword tl_keyword contained s-ifsock s-irgrp s-iroth s-irusr
syn keyword tl_keyword contained s-irwxg s-irwxo s-irwxu s-isgid
syn keyword tl_keyword contained s-isuid s-isvtx s-iwgrp s-iwoth
syn keyword tl_keyword contained s-iwusr s-ixgrp s-ixoth s-ixusr
syn keyword tl_keyword contained save-exe sbit scan-until-match search
syn keyword tl_keyword contained search-regex search-regst search-str search-str-tree
syn keyword tl_keyword contained second seek-cur seek-end seek-set
syn keyword tl_keyword contained seek-stream select self-load-path self-path
syn keyword tl_keyword contained separate seq-begin seq-next seq-reset
syn keyword tl_keyword contained seqp set set-diff set-hash-userdata
syn keyword tl_keyword contained set-indent set-indent-mode set-key set-left
syn keyword tl_keyword contained set-mask set-max-depth set-max-length set-package-fallback-list
syn keyword tl_keyword contained set-right set-sig-handler set-stack-limit setegid
syn keyword tl_keyword contained setenv seteuid setgid setgrent
syn keyword tl_keyword contained setgroups sethash setitimer setlogmask
syn keyword tl_keyword contained setpwent setresgid setresuid setrlimit
syn keyword tl_keyword contained setuid seventh sh sha256
syn keyword tl_keyword contained sha256-begin sha256-end sha256-hash sha256-stream
syn keyword tl_keyword contained shift short short-suffix shuffle
syn keyword tl_keyword contained shut-rd shut-rdwr shut-wr sig-abrt
syn keyword tl_keyword contained sig-alrm sig-atomic-t sig-bus sig-check
syn keyword tl_keyword contained sig-chld sig-cont sig-fpe sig-hup
syn keyword tl_keyword contained sig-ill sig-int sig-io sig-iot
syn keyword tl_keyword contained sig-kill sig-pipe sig-poll sig-prof
syn keyword tl_keyword contained sig-pwr sig-quit sig-segv sig-stkflt
syn keyword tl_keyword contained sig-stop sig-sys sig-term sig-trap
syn keyword tl_keyword contained sig-tstp sig-ttin sig-ttou sig-urg
syn keyword tl_keyword contained sig-usr1 sig-usr2 sig-vtalrm sig-winch
syn keyword tl_keyword contained sig-xcpu sig-xfsz sign-extend signum
syn keyword tl_keyword contained sin sinh sixth size-t
syn keyword tl_keyword contained size-vec sizeof slet slot
syn keyword tl_keyword contained slotp slots slotset so-acceptconn
syn keyword tl_keyword contained so-broadcast so-debug so-dontroute so-error
syn keyword tl_keyword contained so-keepalive so-linger so-oobinline so-rcvbuf
syn keyword tl_keyword contained so-rcvlowat so-rcvtimeo so-reuseaddr so-sndbuf
syn keyword tl_keyword contained so-sndlowat so-sndtimeo so-type sock-accept
syn keyword tl_keyword contained sock-bind sock-cloexec sock-connect sock-dgram
syn keyword tl_keyword contained sock-family sock-listen sock-nonblock sock-opt
syn keyword tl_keyword contained sock-peer sock-recv-timeout sock-send-timeout sock-set-opt
syn keyword tl_keyword contained sock-set-peer sock-shutdown sock-stream sock-type
syn keyword tl_keyword contained socklen-t sol-socket some some-false
syn keyword tl_keyword contained some-true sort sort-group source-loc
syn keyword tl_keyword contained source-loc-str span-str special-operator-p special-var-p
syn keyword tl_keyword contained spl splice split split*
syn keyword tl_keyword contained split-str split-str-set sqrt square
syn keyword tl_keyword contained ssize-t sspl sssucc ssucc
syn keyword tl_keyword contained starts-with stat static-slot static-slot-ensure
syn keyword tl_keyword contained static-slot-home static-slot-p static-slot-set stdlib
syn keyword tl_keyword contained str str-buf str-d str-in6addr
syn keyword tl_keyword contained str-in6addr-net str-inaddr str-inaddr-net str-seq
syn keyword tl_keyword contained str< str<= str= str>
syn keyword tl_keyword contained str>= stream-get-prop stream-set-prop streamp
syn keyword tl_keyword contained strerror string-extend string-finish string-get-code
syn keyword tl_keyword contained string-lt string-set-code stringp strsignal
syn keyword tl_keyword contained struct struct-from-args struct-from-plist struct-get-initfun
syn keyword tl_keyword contained struct-get-postinitfun struct-set-initfun struct-set-postinitfun struct-type
syn keyword tl_keyword contained struct-type-name struct-type-p structp sub
syn keyword tl_keyword contained sub-buf sub-list sub-str sub-tree
syn keyword tl_keyword contained sub-vec subq subql subqual
syn keyword tl_keyword contained subst subtypep succ sum
syn keyword tl_keyword contained sum-each sum-each* sum-each-prod sum-each-prod*
syn keyword tl_keyword contained super super-method suspend swap
syn keyword tl_keyword contained symacrolet symbol-function symbol-macro symbol-name
syn keyword tl_keyword contained symbol-package symbol-value symbolp symdiff
syn keyword tl_keyword contained symlink sys:%backpatch-high16% sys:%backpatch-low16% sys:%big-endian%
syn keyword tl_keyword contained sys:%bin-op% sys:%bin-ops% sys:%block-using-funs% sys:%call-op%
syn keyword tl_keyword contained sys:%const-foldable% sys:%const-foldable-funs% sys:%dbg-command-env% sys:%effect-free%
syn keyword tl_keyword contained sys:%effect-free-funs% sys:%eval-cache% sys:%functional% sys:%functional-funs%
syn keyword tl_keyword contained sys:%gcall-op% sys:%lev-bits% sys:%lev-size% sys:%max-lambda-fixed-args%
syn keyword tl_keyword contained sys:%max-lev% sys:%max-lev-idx% sys:%max-sm-lev% sys:%max-sm-lev-idx%
syn keyword tl_keyword contained sys:%max-v-lev% sys:%nary-ops% sys:%oc-code% sys:%oc-hash%
syn keyword tl_keyword contained sys:%oc-list-builder% sys:%package-manip% sys:%param-info% sys:%quip-rand-state%
syn keyword tl_keyword contained sys:%quips% sys:%shuffled-quips% sys:%sm-lev-bits% sys:%sm-lev-size%
syn keyword tl_keyword contained sys:%test-funs% sys:%test-funs-neg% sys:%test-funs-ops% sys:%test-funs-pos%
syn keyword tl_keyword contained sys:%test-inv% sys:%test-opcode% sys:%tlo-ver% sys:*dedup*
syn keyword tl_keyword contained sys:*emit* sys:*eval* sys:*in-compilation-unit* sys:*load-recursive*
syn keyword tl_keyword contained sys:*load-time* sys:*match-form* sys:*op-ctx* sys:*pl-env*
syn keyword tl_keyword contained sys:*pl-form* sys:*top-level* sys:*trace-hash* sys:*trace-level*
syn keyword tl_keyword contained sys:*unchecked-calls* sys:abscond* sys:abscond-from sys:add-neg-parens
syn keyword tl_keyword contained sys:analyze-argtypes sys:analyze-params sys:apply sys:arith-each
syn keyword tl_keyword contained sys:asm-error sys:assumed-fun sys:autoload-try-fun sys:awk%--rng
syn keyword tl_keyword contained sys:awk%--rng+ sys:awk%--rng- sys:awk%-rng+ sys:awk%rng+
syn keyword tl_keyword contained sys:awk-code-move-check sys:awk-error sys:awk-expander sys:awk-field-name-code
syn keyword tl_keyword contained sys:awk-fun-let sys:awk-fun-shadowing-env sys:awk-mac-let sys:awk-redir
syn keyword tl_keyword contained sys:awk-symac-let sys:awk-test sys:b* sys:b+
syn keyword tl_keyword contained sys:b- sys:b/ sys:b< sys:b<=
syn keyword tl_keyword contained sys:b= sys:b=> sys:b> sys:bad-slot-syntax
syn keyword tl_keyword contained sys:bind-mac-check sys:bind-mac-error sys:bindable-check sys:bits
syn keyword tl_keyword contained sys:bits-to-obj sys:blk sys:build-expander sys:capture-cont
syn keyword tl_keyword contained sys:catch sys:check sys:check-end sys:check-slot
syn keyword tl_keyword contained sys:check-struct sys:check-sym sys:circref sys:comma-positions
syn keyword tl_keyword contained sys:compat sys:compile-and-match sys:compile-as-match sys:compile-atom-match
syn keyword tl_keyword contained sys:compile-cons-structure sys:compile-exprs-match sys:compile-file-conditionally sys:compile-hash-match
syn keyword tl_keyword contained sys:compile-loop-match sys:compile-match sys:compile-new-var-match sys:compile-not-match
syn keyword tl_keyword contained sys:compile-or-match sys:compile-predicate-match sys:compile-range-match sys:compile-require-match
syn keyword tl_keyword contained sys:compile-scan-match sys:compile-struct-match sys:compile-var-match sys:compile-vec-match
syn keyword tl_keyword contained sys:compile-with-match sys:compiler-emit-warnings sys:conv sys:conv-expand
syn keyword tl_keyword contained sys:conv-expand-sym sys:conv-let sys:ctx-form sys:ctx-name
syn keyword tl_keyword contained sys:dbg-all sys:dbg-backtrace sys:dbg-clear sys:dbg-enable
syn keyword tl_keyword contained sys:dbg-restore sys:dbg-set sys:dbg-step sys:debugger
syn keyword tl_keyword contained sys:dedup sys:dedup-labels sys:deffi-cb-expander sys:define-method
syn keyword tl_keyword contained sys:defset-expander sys:defset-expander-simple sys:detached-run sys:dig
syn keyword tl_keyword contained sys:disassemble-cdf sys:dlib-expr sys:do-conv sys:do-copy-obj
syn keyword tl_keyword contained sys:do-path-test sys:do-tweak-obj sys:doc-syms sys:dump-to-tlo
syn keyword tl_keyword contained sys:dvbind sys:dwim-del sys:dwim-set sys:dyn-size
syn keyword tl_keyword contained sys:each-match-expander sys:each-op sys:early-peephole sys:enc-small-op
syn keyword tl_keyword contained sys:ensure-op-arg sys:env-to-let sys:eq-comparable sys:eql-comparable
syn keyword tl_keyword contained sys:eval-cache-emit-warnings sys:eval-err sys:expand-and sys:expand-arith-each-prod
syn keyword tl_keyword contained sys:expand-bind-mac-params sys:expand-defmacro sys:expand-defsymacro sys:expand-defun
syn keyword tl_keyword contained sys:expand-defvarl sys:expand-dohash sys:expand-doloop sys:expand-each
syn keyword tl_keyword contained sys:expand-each-prod sys:expand-each-prod* sys:expand-handle sys:expand-lambda-match
syn keyword tl_keyword contained sys:expand-neg-parens sys:expand-params sys:expand-pic sys:expand-pic-align
syn keyword tl_keyword contained sys:expand-pic-num sys:expand-pic-num-commas sys:expand-quasi sys:expand-quasi-args
syn keyword tl_keyword contained sys:expand-quasi-match sys:expand-quasi-mods sys:expand-sym-ref sys:expr
syn keyword tl_keyword contained sys:fbind sys:find-parent sys:fixed-point sys:flatten-or
syn keyword tl_keyword contained sys:fmt-flex sys:fmt-join sys:fmt-simple sys:for-op
syn keyword tl_keyword contained sys:gc sys:gc-set-delta sys:get-buf-common sys:get-fun-getter-setter
syn keyword tl_keyword contained sys:get-mb sys:get-param-info sys:get-place-macro sys:get-var-list
syn keyword tl_keyword contained sys:get-vars sys:get-vb sys:getopts-error sys:handle-bad-syntax
syn keyword tl_keyword contained sys:hlet-expand sys:if-to-cond sys:in6addr-condensed-text sys:insert-commas
syn keyword tl_keyword contained sys:is-label sys:l1-setq sys:l1-val sys:lambda-apply-transform
syn keyword tl_keyword contained sys:lambda-excess-apply-list sys:lambda-short-apply-list sys:lambda-too-few-args sys:lambda-too-many-args
syn keyword tl_keyword contained sys:lbind sys:lisp1-setq sys:lisp1-value sys:list-builder-flets
syn keyword tl_keyword contained sys:list-from-vm-desc sys:load-time-lit sys:loc sys:loosen
syn keyword tl_keyword contained sys:mac-env-flatten sys:make-anon-package sys:make-command-env sys:make-copy-path-opts
syn keyword tl_keyword contained sys:make-struct-lit sys:make-struct-type sys:mark-special sys:match-pat-error
syn keyword tl_keyword contained sys:misleading-ref-check sys:name-str sys:new-expander sys:new-type
syn keyword tl_keyword contained sys:non-triv-pat-p sys:null-reg sys:obtain-impl sys:op-alpha-rename
syn keyword tl_keyword contained sys:op-ensure-rec sys:op-expand sys:op-meta-p sys:op-rec-p
syn keyword tl_keyword contained sys:open-compile-streams sys:open-url sys:operand-to-exp sys:operand-to-sym
syn keyword tl_keyword contained sys:opip-expand sys:opt-dash sys:opt-err sys:orig-form
syn keyword tl_keyword contained sys:os-symbol sys:param-check sys:parse-compound-operand sys:parse-lambda-match-clause
syn keyword tl_keyword contained sys:parse-operand sys:pat-len sys:path-access sys:path-examine
syn keyword tl_keyword contained sys:path-simplify sys:path-split sys:path-test-mode sys:path-test-type
syn keyword tl_keyword contained sys:path-volume sys:pic-join-opt sys:pl-expand sys:placelet-1
syn keyword tl_keyword contained sys:print-backtrace sys:propagate-ancestor sys:propagate-perms sys:prune-missing-inits
syn keyword tl_keyword contained sys:qquote sys:quasi sys:quasilist sys:r-s-let-expander
syn keyword tl_keyword contained sys:reduce-constant sys:reduce-lisp sys:reduce-or sys:reg-expand-nongreedy
syn keyword tl_keyword contained sys:register-opcode sys:register-simple-accessor sys:repl sys:rewrite
syn keyword tl_keyword contained sys:rewrite-case sys:rplaca sys:rplacd sys:rslotset
syn keyword tl_keyword contained sys:rt-assert-fail sys:rt-defmacro sys:rt-defsymacro sys:rt-defun
syn keyword tl_keyword contained sys:rt-defv sys:rt-defvarl sys:rt-load-for sys:rt-pprof
syn keyword tl_keyword contained sys:safe-const-eval sys:safe-const-reduce sys:safe-constantp sys:set-hash-traversal-limit
syn keyword tl_keyword contained sys:set-macro-ancestor sys:setq sys:setqf sys:simplify-or
syn keyword tl_keyword contained sys:slot-types sys:small-op-p sys:small-op-to-sym sys:splice
syn keyword tl_keyword contained sys:static-slot-types sys:str-inaddr-net-impl sys:struct-lit sys:stuff-key-params
syn keyword tl_keyword contained sys:subst-preserve sys:switch sys:sym-clobber-expander sys:sym-delete-expander
syn keyword tl_keyword contained sys:sym-update-expander sys:system-symbol-p sys:top-fb sys:top-mb
syn keyword tl_keyword contained sys:top-vb sys:tr* sys:trace sys:trace-canonicalize-name
syn keyword tl_keyword contained sys:trace-enter sys:trace-leave sys:trace-redefine-check sys:transform-qquote
syn keyword tl_keyword contained sys:tree-construct sys:trfm sys:true-const-p sys:txr-case-impl
syn keyword tl_keyword contained sys:typecase-expander sys:unquote sys:untrace sys:upenv
syn keyword tl_keyword contained sys:uw-block sys:uw-captured-block sys:uw-catch sys:uw-cont-copy
syn keyword tl_keyword contained sys:uw-eval sys:uw-expand sys:uw-fcall sys:uw-guard
syn keyword tl_keyword contained sys:uw-handle sys:uw-menv sys:var sys:var-pat-p
syn keyword tl_keyword contained sys:vars-check sys:vm-closure-desc sys:vm-closure-entry sys:vm-desc-bytecode
syn keyword tl_keyword contained sys:vm-desc-datavec sys:vm-desc-nlevels sys:vm-desc-nregs sys:vm-desc-symvec
syn keyword tl_keyword contained sys:vm-execute-toplevel sys:vm-make-desc sys:wdwrap sys:when-exprs-match
syn keyword tl_keyword contained sys:with-disabled-debugging sys:with-dyn-lib-check syslog system-package
syn keyword tl_keyword contained t tab0 tab1 tab2
syn keyword tl_keyword contained tab3 tabdly tagbody tailp
syn keyword tl_keyword contained take take-until take-while tan
syn keyword tl_keyword contained tanh tb tc tcdrain
syn keyword tl_keyword contained tcflow tcflush tcgetattr tciflush
syn keyword tl_keyword contained tcioff tcioflush tcion tcoflush
syn keyword tl_keyword contained tcooff tcoon tcp-nodelay tcsadrain
syn keyword tl_keyword contained tcsaflush tcsanow tcsendbreak tcsetattr
syn keyword tl_keyword contained tentative-def-exists tenth test-clear test-clear-dirty
syn keyword tl_keyword contained test-dec test-dirty test-inc test-neq-set-indent-mode
syn keyword tl_keyword contained test-set test-set-indent-mode tf third
syn keyword tl_keyword contained throw throwf time time-fields-local
syn keyword tl_keyword contained time-fields-utc time-nsec time-parse time-parse-local
syn keyword tl_keyword contained time-parse-utc time-string-local time-string-utc time-struct-local
syn keyword tl_keyword contained time-struct-utc time-t time-usec tmpfile
syn keyword tl_keyword contained tnode tnodep to tofloat
syn keyword tl_keyword contained tofloatz toint tointz tojson
syn keyword tl_keyword contained tok tok-str tok-where tostop
syn keyword tl_keyword contained tostring tostringp touch tprint
syn keyword tl_keyword contained trace transpose tree tree-begin
syn keyword tl_keyword contained tree-bind tree-case tree-clear tree-count
syn keyword tl_keyword contained tree-del-min tree-del-min-node tree-delete tree-delete-node
syn keyword tl_keyword contained tree-delete-specific-node tree-find tree-insert tree-insert-node
syn keyword tl_keyword contained tree-lookup tree-lookup-node tree-min tree-min-node
syn keyword tl_keyword contained tree-next tree-peek tree-reset tree-root
syn keyword tl_keyword contained treep trie-add trie-compress trie-lookup-begin
syn keyword tl_keyword contained trie-lookup-feed-char trie-value-at trim-left trim-long-suffix
syn keyword tl_keyword contained trim-right trim-short-suffix trim-str true
syn keyword tl_keyword contained trunc trunc-rem truncate-stream tuples
syn keyword tl_keyword contained tuples* txr-case txr-exe-path txr-if
syn keyword tl_keyword contained txr-parse txr-path txr-version txr-when
syn keyword tl_keyword contained typecase typedef typeof typep
syn keyword tl_keyword contained ubit uchar uid-t uint
syn keyword tl_keyword contained uint-buf uint-carray uint-ptr-t uint16
syn keyword tl_keyword contained uint32 uint64 uint8 ulong
syn keyword tl_keyword contained ulonglong umask umeth umethod
syn keyword tl_keyword contained uname unget-byte unget-char uni
syn keyword tl_keyword contained unintern union union-get union-in
syn keyword tl_keyword contained union-members union-out union-put uniq
syn keyword tl_keyword contained unique unless unquote unsetenv
syn keyword tl_keyword contained until until* untrace unuse-package
syn keyword tl_keyword contained unuse-sym unwind-protect upcase-str upd
syn keyword tl_keyword contained update uref url-decode url-encode
syn keyword tl_keyword contained use use-package use-sym user-package
syn keyword tl_keyword contained ushort usl usleep uslot
syn keyword tl_keyword contained utimes val vdiscard vec
syn keyword tl_keyword contained vec-carray vec-list vec-push vec-seq
syn keyword tl_keyword contained vec-set-length vecref vector vector-list
syn keyword tl_keyword contained vectorp veof veol veol2
syn keyword tl_keyword contained verase vintr vkill vlnext
syn keyword tl_keyword contained vm-fun-p vmin void vquit
syn keyword tl_keyword contained vreprint vstart vstop vsusp
syn keyword tl_keyword contained vswtc vt0 vt1 vtdly
syn keyword tl_keyword contained vtime vwerase w-continued w-coredump
syn keyword tl_keyword contained w-exitstatus w-ifcontinued w-ifexited w-ifsignaled
syn keyword tl_keyword contained w-ifstopped w-nohang w-stopsig w-termsig
syn keyword tl_keyword contained w-untraced wait wchar weave
syn keyword tl_keyword contained when when-match whena whenlet
syn keyword tl_keyword contained where while while* while-match
syn keyword tl_keyword contained while-match-case while-true-match-case whilet width
syn keyword tl_keyword contained width-check window-map window-mapdo window-mappend
syn keyword tl_keyword contained wint-t with-clobber-expander with-compilation-unit with-delete-expander
syn keyword tl_keyword contained with-dyn-lib with-gensyms with-hash-iter with-in-buf-stream
syn keyword tl_keyword contained with-in-string-byte-stream with-in-string-stream with-objects with-out-buf-stream
syn keyword tl_keyword contained with-out-string-stream with-out-strlist-stream with-resources with-slots
syn keyword tl_keyword contained with-stream with-update-expander wrap wrap*
syn keyword tl_keyword contained wstr wstr-d xcase yield
syn keyword tl_keyword contained yield-from zap zarray zchar
syn keyword tl_keyword contained zero-fill zerop zip znew
syn match txr_nested_error "[^\t ]\+" contained
syn match txr_variable "\(@[ \t]*\)[*]\?[ \t]*[A-Za-z_][A-Za-z_0-9]*"
syn match txr_splicevar "@[ \t,*@]*[A-Za-z_][A-Za-z_0-9]*" contained
syn match txr_metanum "@\+[0-9]\+"
syn match txr_badesc "\\." contained
syn match txr_escat "\\@" contained
syn match txr_stresc "\\[abtnvfre\\ "`']" contained
syn match txr_numesc "\\x[0-9A-Fa-f]\+;\?" contained
syn match txr_numesc "\\[0-7]\+;\?" contained
syn match txr_regesc "\\[abtnvfre\\ /sSdDwW()\|.*?+~&%\[\]\-]" contained

syn match txr_error "#[^HSRTN]"

syn match txr_chr "#\\x[0-9A-Fa-f]\+"
syn match txr_chr "#\\o[0-7]\+"
syn match txr_chr "#\\[^ \t\nA-Za-z_0-9]"
syn match txr_chr "#\\[A-Za-z_0-9]\+"
syn match txr_ncomment ";.*"

syn match txr_hashbang "\%^#!.*"

syn match txr_dot "\." contained
syn match txr_ident "[A-Za-z_0-9!$%&*+\-<=>?\\_~]*[A-Za-z_!$%&*+\-<=>?\\_~^][A-Za-z_0-9!$%&*+\-<=>?\\_~^]*" contained
syn match tl_ident "[:@][A-Za-z_0-9!$%&*+\-<=>?\\_~^/]\+"
syn match txr_braced_ident "[:][A-Za-z_0-9!$%&*+\-<=>?\\_~^/]\+" contained
syn match tl_ident "[A-Za-z_0-9!$%&*+\-<=>?\\_~/]\+[A-Za-z_0-9!$%&*+\-<=>?\\_~^/#]*"
syn match txr_pnum "#[xob][+\-]\?[A-Za-z_0-9]\+" contains=txr_xnum,txr_bnum,txr_onum
syn match txr_xnum "#x[+\-]\?[0-9A-Fa-f]\+" containedin=txr_pnum contained
syn match txr_onum "#o[+\-]\?[0-7]\+" containedin=txr_pnum contained
syn match txr_bnum "#b[+\-]\?[01]\+" containedin=txr_pnum contained
syn match txr_num "[+\-]\?[0-9]\+\([^A-Za-z_0-9!$%&*+\-<=>?\\_~^/#]\|\n\)"me=e-1
syn match txr_badnum "[+\-]\?[0-9]*[.][0-9]\+\([eE][+\-]\?[0-9]\+\)\?[A-Za-z_!$%&*+\-<=>?\\_~^/#]\+"
syn match txr_num "[+\-]\?[0-9]*[.][0-9]\+\([eE][+\-]\?[0-9]\+\)\?\([^A-Za-z_0-9!$%&*+\-<=>?\\_~^/#]\|\n\)"me=e-1
syn match txr_num "[+\-]\?[0-9]\+\([eE][+\-]\?[0-9]\+\)\([^A-Za-z_0-9!$%&*+\-<=>?\\_~^/#]\|\n\)"me=e-1
syn match tl_ident ":"
syn match tl_splice "[ \t,]\|,[*]"

syn match txr_unquote "," contained
syn match txr_splice ",\*" contained
syn match txr_quote "'" contained
syn match txr_quote "\^" contained
syn match txr_dotdot "\.\." contained
syn match txr_metaat "@" contained

syn match txr_buf_error "[^']" contained
syn match txr_buf_interior "\([0-9A-Fa-f][\n\t ]*[0-9A-Fa-f]\|[\n\t ]\+\)" contained

syn region txr_bracevar matchgroup=Delimiter start="@[ \t]*[*]\?{" matchgroup=Delimiter end="}" contains=txr_num,txr_pnum,tl_ident,tl_splice,tl_metanum,txr_metaat,txr_circ,txr_braced_ident,txr_dot,txr_dotdot,txr_string,txr_list,txr_bracket,txr_mlist,txr_mbracket,txr_regex,tl_regex,txr_quasilit,txr_chr,txr_nested_error
syn region tl_bracevar contained matchgroup=Delimiter start="@[ \t]*[*]\?{" matchgroup=Delimiter end="}" contains=txr_num,txr_pnum,tl_ident,tl_splice,tl_metanum,txr_metaat,txr_circ,txr_braced_ident,txr_dot,txr_dotdot,txr_string,txr_list,txr_bracket,txr_mlist,txr_mbracket,txr_regex,tl_regex,txr_quasilit,txr_chr,txr_nested_error
syn region txr_list matchgroup=Delimiter start="\(#[HSRTN]\?\)\?(" matchgroup=Delimiter end=")" contains=tl_keyword,txr_string,tl_regex,txr_num,txr_pnum,txr_badnum,tl_ident,txr_metanum,txr_ign_par,txr_ign_bkt,txr_ign_tok,txr_list,txr_bracket,txr_mlist,txr_mbracket,txr_quasilit,txr_chr,txr_buf,txr_quote,txr_unquote,txr_splice,txr_dot,txr_dotdot,txr_metaat,txr_circ,txr_jhash,txr_jarray,txr_jatom,txr_ncomment,txr_nested_error
syn region txr_bracket matchgroup=Delimiter start="\[" matchgroup=Delimiter end="\]" contains=tl_keyword,txr_string,tl_regex,txr_num,txr_pnum,txr_badnum,tl_ident,txr_metanum,txr_ign_par,txr_ign_bkt,txr_ign_tok,txr_list,txr_bracket,txr_mlist,txr_mbracket,txr_quasilit,txr_chr,txr_buf,txr_quote,txr_unquote,txr_splice,txr_dot,txr_dotdot,txr_metaat,txr_circ,txr_jhash,txr_jarray,txr_jatom,txr_ncomment,txr_nested_error
syn region txr_mlist matchgroup=Delimiter start="@[ \t^',]*(" matchgroup=Delimiter end=")" contains=tl_keyword,txr_string,tl_regex,txr_num,txr_pnum,txr_badnum,tl_ident,txr_metanum,txr_ign_par,txr_ign_bkt,txr_ign_tok,txr_list,txr_bracket,txr_mlist,txr_mbracket,txr_quasilit,txr_chr,txr_buf,txr_quote,txr_unquote,txr_splice,txr_dot,txr_dotdot,txr_metaat,txr_circ,txr_jhash,txr_jarray,txr_jatom,txr_ncomment,txr_nested_error
syn region txr_mbracket matchgroup=Delimiter start="@[ \t^',]*\[" matchgroup=Delimiter end="\]" contains=tl_keyword,txr_string,tl_regex,txr_num,txr_pnum,txr_badnum,tl_ident,txr_metanum,txr_ign_par,txr_ign_bkt,txr_ign_tok,txr_list,txr_bracket,txr_mlist,txr_mbracket,txr_quasilit,txr_chr,txr_buf,txr_quote,txr_unquote,txr_splice,txr_dot,txr_dotdot,txr_metaat,txr_circ,txr_jhash,txr_jarray,txr_jatom,txr_ncomment,txr_nested_error
syn region txr_string start=+#\?\*\?"+ skip=+\\\n+ end=+["\n]+ contains=txr_stresc,txr_numesc,txr_badesc
syn region txr_quasilit start=+#\?\*\?`+ skip=+\\\n+ end=+[`\n]+ contains=txr_splicevar,txr_metanum,tl_bracevar,txr_mlist,txr_mbracket,txr_escat,txr_stresc,txr_numesc,txr_badesc
syn region txr_regex start="/" skip=+\\\n+ end="[/\n]" contains=txr_regesc,txr_numesc,txr_badesc
syn region tl_regex start="#/" skip=+\\\n+ end="[/\n]" contains=txr_regesc,txr_numesc,txr_badesc
syn region txr_buf matchgroup=txr_buf start="#b'" end="'" contains=txr_buf_interior,txr_buf_error
syn region txr_ign_tok matchgroup=Comment start="#;" end="[ \(\)\[\]]"me=e   contains=tl_keyword,txr_string,tl_regex,txr_num,txr_pnum,txr_badnum,tl_ident,txr_metanum,txr_ign_par,txr_ign_bkt,txr_ign_tok,txr_list,txr_bracket,txr_mlist,txr_mbracket,txr_quasilit,txr_chr,txr_buf,txr_quote,txr_unquote,txr_splice,txr_dot,txr_dotdot,txr_metaat,txr_circ,txr_jhash,txr_jarray,txr_jatom,txr_ncomment,txr_nested_error
syn region txr_ign_par matchgroup=Comment start="#;[ \t',]*\(#[HSRTN]\?\)\?(" matchgroup=Comment end=")" contains=txr_ign_par_interior,txr_ign_bkt_interior
syn region txr_ign_bkt matchgroup=Comment start="#;[ \t',]*\(#[HSRTN]\?\)\?\[" matchgroup=Comment end="\]" contains=txr_ign_par_interior,txr_ign_bkt_interior
syn region txr_ign_bkt matchgroup=Comment start="#;[ \t',]*\(#[HSRTN]\?\)\?\[" matchgroup=Comment end="\]" contains=txr_ign_par_interior,txr_ign_bkt_interior
syn region txr_ign_par_interior contained matchgroup=Comment start="(" matchgroup=Comment end=")" contains=txr_ign_par_interior,txr_ign_bkt_interior
syn region txr_ign_bkt_interior contained matchgroup=Comment start="\[" matchgroup=Comment end="\]" contains=txr_ign_par_interior,txr_ign_bkt_interior

syn match txr_jerr "." contained
syn match txr_jpunc "[,: \t\n]" contained
syn match txr_jesc "\\[bfnrt"\\/]" contained
syn match txr_juesc "\\u[0-9A-Fa-f][0-9A-Fa-f][0-9A-Fa-f][0-9A-Fa-f]" contained
syn match txr_jnum "-\?\(0\|[1-9][0-9]*\)\([.][0-9]\+\)\?\([Ee][+-]\?[0-9]\+\)\?" contained
syn match txr_jkeyword "true\|false\|null" contained

syn region txr_jatom matchgroup=Delimiter start="#J\^\?[\t\n ]*"rs=e end="[\t\n ]\|[\])}]"re=e-1 contains=txr_jarray_in,txr_jhash_in,txr_jkeyword,txr_jstring,txr_jnum,txr_jpunc,txr_junqlist,txr_junqbkt,txr_junqtok,txr_circ,txr_jerr
syn region txr_junqtok matchgroup=Delimiter start="\~" end="[ \(\)\[\]{}]"re=s contains=tl_keyword,txr_string,tl_regex,txr_num,txr_pnum,txr_badnum,tl_ident,txr_metanum,txr_ign_par,txr_ign_bkt,txr_ign_tok,txr_list,txr_bracket,txr_mlist,txr_mbracket,txr_quasilit,txr_chr,txr_buf,txr_quote,txr_unquote,txr_splice,txr_dot,txr_dotdot,txr_metaat,txr_circ,txr_jhash,txr_jarray,txr_jatom,txr_ncomment,txr_nested_error
syn region txr_junqlist matchgroup=Delimiter start="\~\*\?#\?(" end=")" contains=tl_keyword,txr_string,tl_regex,txr_num,txr_pnum,txr_badnum,tl_ident,txr_metanum,txr_ign_par,txr_ign_bkt,txr_ign_tok,txr_list,txr_bracket,txr_mlist,txr_mbracket,txr_quasilit,txr_chr,txr_buf,txr_quote,txr_unquote,txr_splice,txr_dot,txr_dotdot,txr_metaat,txr_circ,txr_jhash,txr_jarray,txr_jatom,txr_ncomment,txr_nested_error
syn region txr_junqbkt matchgroup=Delimiter start="\~\*\?\[" end="\]" contains=tl_keyword,txr_string,tl_regex,txr_num,txr_pnum,txr_badnum,tl_ident,txr_metanum,txr_ign_par,txr_ign_bkt,txr_ign_tok,txr_list,txr_bracket,txr_mlist,txr_mbracket,txr_quasilit,txr_chr,txr_buf,txr_quote,txr_unquote,txr_splice,txr_dot,txr_dotdot,txr_metaat,txr_circ,txr_jhash,txr_jarray,txr_jatom,txr_ncomment,txr_nested_error
syn region txr_jstring matchgroup=Delimiter start=+"+ end=+["\n]+ contains=txr_jesc,txr_juesc,txr_badesc
syn region txr_jarray matchgroup=Delimiter start="#J\^\?[\t\n ]*\[" matchgroup=Delimiter end="\]" contains=txr_jarray_in,txr_jhash_in,txr_jkeyword,txr_jstring,txr_jnum,txr_jpunc,txr_junqlist,txr_junqbkt,txr_junqtok,txr_circ,txr_jerr
syn region txr_jhash matchgroup=Delimiter start="#J\^\?[\t\n ]*{" matchgroup=Delimiter end="}" contains=txr_jarray_in,txr_jhash_in,txr_jkeyword,txr_jstring,txr_jnum,txr_jpunc,txr_junqlist,txr_junqbkt,txr_junqtok,txr_circ,txr_jerr
syn region txr_jarray_in contained matchgroup=Delimiter start="\[" end="\]" contains=txr_jarray_in,txr_jhash_in,txr_jkeyword,txr_jstring,txr_jnum,txr_jpunc,txr_junqlist,txr_junqbkt,txr_junqtok,txr_circ,txr_jerr
syn region txr_jhash_in contained matchgroup=Delimiter start="{" end="}" contains=txr_jarray_in,txr_jhash_in,txr_jkeyword,txr_jstring,txr_jnum,txr_jpunc,txr_junqlist,txr_junqbkt,txr_junqtok,txr_circ,txr_jerr

syn match txr_circ "#[0-9]\+[#=]" contained

hi def link txr_at Special
hi def link txr_atstar Special
hi def link txr_atat Special
hi def link txr_comment Comment
hi def link txr_ncomment Comment
hi def link txr_hashbang Preproc
hi def link txr_contin Preproc
hi def link txr_char String
hi def link tl_keyword Type
hi def link txr_string String
hi def link txr_chr String
hi def link txr_quasilit String
hi def link txr_regex String
hi def link tl_regex String
hi def link txr_regdir String
hi def link txr_variable Identifier
hi def link txr_splicevar Identifier
hi def link txr_metanum Identifier
hi def link txr_escat Special
hi def link txr_stresc Special
hi def link txr_numesc Special
hi def link txr_regesc Special
hi def link txr_badesc Error
hi def link txr_ident Identifier
hi def link tl_ident Identifier
hi def link txr_num Number
hi def link txr_xnum Number
hi def link txr_bnum Number
hi def link txr_onum Number
hi def link txr_badnum Error
hi def link txr_pnum Error
hi def link txr_quote Special
hi def link txr_unquote Special
hi def link txr_splice Special
hi def link txr_dot Special
hi def link txr_dotdot Special
hi def link txr_metaat Special
hi def link txr_circ Special
hi def link txr_munqspl Special
hi def link tl_splice Special
hi def link txr_error Error
hi def link txr_nested_error Error
hi def link txr_buf String
hi def link txr_buf_interior String
hi def link txr_buf_error Error
hi def link txr_ign_par Comment
hi def link txr_ign_bkt_interior Comment
hi def link txr_ign_par_interior Comment
hi def link txr_ign_bkt Comment
hi def link txr_ign_tok Comment

hi def link txr_jkeyword Type
hi def link txr_jnum Number
hi def link txr_jstring String
hi def link txr_jesc Special
hi def link txr_juesc Special
hi def link txr_jpunc Special
hi def link txr_jerr Error

let b:current_syntax = "lisp"

set lispwords=ado,alet,align,alignof,ap,append-each,append-each*,append-each-prod,append-each-prod*,append-match-products,append-matches,aret,array,arraysize,assert,awk,bit,block,block*,bool,buf,buf-d,build,buildn,carray,caseq,caseq*,caseql,caseql*,casequal,casequal*,catch,catch*,catch**,clear-mask,collect-each,collect-each*,collect-each-prod,collect-each-prod*,compare-swap,compile-only,cond,conda,condlet,cptr,dec,defex,deffi,deffi-cb,deffi-cb-unsafe,deffi-struct,deffi-sym,deffi-type,deffi-union,deffi-var,define-accessor,define-modify-macro,define-option-struct,define-param-expander,define-place-macro,define-struct-clause,defmacro,defmatch,defmeth,defpackage,defparm,defparml,defplace,defset,defstruct,defsymacro,defun,defun-match,defvar,defvarl,del,delay,do,dohash,doloop,doloop*,dotimes,each,each*,each-false,each-match,each-match-product,each-prod,each-prod*,each-true,ecaseq,ecaseq*,ecaseql,ecaseql*,ecasequal,ecasequal*,elemsize,elemtype,enum,enumed,equot,etypecase,eval-only,ffi,flet,flip,flow,for,for*,fun,gen,go,gun,handle,handle*,handler-bind,hlet,hlet*,ido,if,if-match,ifa,iflet,ignerr,ignwarn,in-package,ip,json,keep-match-products,keep-matches,labels,lambda,lambda-match,lcons,ldo,let,let*,lnew*,load-for,load-time,lop,lset,mac-env-param-bind,mac-param-bind,macro-time,macrolet,match,match-case,match-ecase,mlet,mul-each,mul-each*,mul-each-prod,mul-each-prod*,nand,new*,nor,obtain,obtain*,obtain*-block,obtain-block,offsetof,op,pdec,pic,pinc,placelet,placelet*,pop,pop-after-load,pprof,prof,prog,prog*,prog1,prog2,progn,ptr,ptr-in,ptr-in-d,ptr-out,ptr-out-d,ptr-out-s,push,push-after-load,pushnew,ret,return,return-from,rlet,rslot,sbit,set-mask,sizeof,slet,some-false,some-true,splice,struct,sum-each,sum-each*,sum-each-prod,sum-each-prod*,suspend,symacrolet,sys:abscond-from,sys:arith-each,sys:awk-fun-let,sys:awk-mac-let,sys:awk-redir,sys:awk-symac-let,sys:blk,sys:catch,sys:conv,sys:conv-expand-sym,sys:dlib-expr,sys:dvbind,sys:each-op,sys:expr,sys:fbind,sys:fixed-point,sys:for-op,sys:l1-val,sys:lbind,sys:lisp1-value,sys:load-time-lit,sys:path-examine,sys:placelet-1,sys:rewrite-case,sys:splice,sys:struct-lit,sys:switch,sys:txr-case-impl,sys:unquote,sys:upenv,sys:var,sys:when-exprs-match,sys:with-disabled-debugging,tagbody,tb,tc,test-clear,test-dec,test-inc,test-set,trace,tree-bind,tree-case,txr-case,txr-if,txr-when,typecase,typedef,ubit,union,unless,unquote,until,until*,untrace,unwind-protect,upd,uref,when,when-match,whena,whenlet,while,while*,while-match,while-match-case,while-true-match-case,whilet,with-clobber-expander,with-compilation-unit,with-delete-expander,with-dyn-lib,with-gensyms,with-hash-iter,with-in-buf-stream,with-in-string-byte-stream,with-in-string-stream,with-objects,with-out-buf-stream,with-out-string-stream,with-out-strlist-stream,with-resources,with-slots,with-stream,with-update-expander,yield,yield-from,zap,zarray,znew,:method,:function,:init,:postinit,:fini
set comments=:\;\;\;,:\;\;,:\;
