/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.hibernate.viewobjects;

import java.util.ArrayList;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.plugins.hibernate.mapping.MappedClassInfo;
import net.sourceforge.squirrel_sql.plugins.hibernate.mapping.PropertyInfo;
import net.sourceforge.squirrel_sql.plugins.hibernate.server.ObjectSubstitute;
import net.sourceforge.squirrel_sql.plugins.hibernate.viewobjects.HibernatePropertyReader;
import net.sourceforge.squirrel_sql.plugins.hibernate.viewobjects.SingleResult;
import net.sourceforge.squirrel_sql.plugins.hibernate.viewobjects.ViewObjectsUtil;

public class PersistentCollectionResult {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(PersistentCollectionResult.class);
    private PropertyInfo _propertyInfo;
    private String _toString;
    private ArrayList<SingleResult> _kidResults = new ArrayList();

    public PersistentCollectionResult(HibernatePropertyReader hprPersistentCollection, PropertyInfo propertyInfo, ArrayList<MappedClassInfo> mappedClassInfos) {
        this._propertyInfo = propertyInfo;
        String propertyName = this._propertyInfo.getHibernatePropertyInfo().getPropertyName();
        String className = this._propertyInfo.getMappedClassInfo().getClassName();
        if (hprPersistentCollection.wasInitialized()) {
            this._toString = s_stringMgr.getString("PersistentCollectionResult.initialized", new Object[]{propertyName, className});
            MappedClassInfo mci = null;
            for (ObjectSubstitute objectSubstitute : hprPersistentCollection.getPersistentCollection()) {
                if (null == mci) {
                    mci = ViewObjectsUtil.findMappedClassInfo(objectSubstitute.getClassName(), mappedClassInfos, false);
                }
                this._kidResults.add(new SingleResult(objectSubstitute, mci));
            }
        } else {
            this._toString = s_stringMgr.getString("PersistentCollectionResult.uninitialized", new Object[]{propertyName, className});
        }
    }

    public ArrayList<SingleResult> getKidResults() {
        return this._kidResults;
    }

    public String toString() {
        return this._toString;
    }
}

