/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.db2.exp;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.INodeExpander;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.ObjectTreeNode;
import net.sourceforge.squirrel_sql.fw.sql.DatabaseObjectInfo;
import net.sourceforge.squirrel_sql.fw.sql.DatabaseObjectType;
import net.sourceforge.squirrel_sql.fw.sql.IDatabaseObjectInfo;
import net.sourceforge.squirrel_sql.fw.sql.ISQLDatabaseMetaData;
import net.sourceforge.squirrel_sql.fw.sql.SQLDatabaseMetaData;
import net.sourceforge.squirrel_sql.plugins.db2.exp.SequenceParentExpander;
import net.sourceforge.squirrel_sql.plugins.db2.exp.UDFParentExpander;
import net.sourceforge.squirrel_sql.plugins.db2.sql.DB2Sql;

public class SchemaExpander
implements INodeExpander {
    private final DB2Sql db2Sql;

    public SchemaExpander(DB2Sql db2Sql) {
        this.db2Sql = db2Sql;
    }

    public List<ObjectTreeNode> createChildren(ISession session, ObjectTreeNode parentNode) {
        ArrayList<ObjectTreeNode> childNodes = new ArrayList<ObjectTreeNode>();
        IDatabaseObjectInfo parentDbinfo = parentNode.getDatabaseObjectInfo();
        SQLDatabaseMetaData md = session.getSQLConnection().getSQLMetaData();
        String catalogName = parentDbinfo.getCatalogName();
        String schemaName = parentDbinfo.getSimpleName();
        DatabaseObjectInfo seqInfo = new DatabaseObjectInfo(catalogName, schemaName, "SEQUENCE", DatabaseObjectType.SEQUENCE_TYPE_DBO, (ISQLDatabaseMetaData)md);
        ObjectTreeNode node = new ObjectTreeNode(session, (IDatabaseObjectInfo)seqInfo);
        node.addExpander((INodeExpander)new SequenceParentExpander(this.db2Sql));
        childNodes.add(node);
        DatabaseObjectInfo udfInfo = new DatabaseObjectInfo(catalogName, schemaName, "UDF", DatabaseObjectType.UDF_TYPE_DBO, (ISQLDatabaseMetaData)md);
        ObjectTreeNode udfnode = new ObjectTreeNode(session, (IDatabaseObjectInfo)udfInfo);
        udfnode.addExpander((INodeExpander)new UDFParentExpander(this.db2Sql));
        childNodes.add(udfnode);
        return childNodes;
    }
}

