/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.i18n;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import net.sourceforge.squirrel_sql.client.plugin.PluginResources;
import net.sourceforge.squirrel_sql.fw.gui.MultipleLineLabel;
import net.sourceforge.squirrel_sql.fw.props.Props;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

public class TranslatorsPanel
extends JPanel {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(TranslatorsPanel.class);
    JTabbedPane tabTranlators = new JTabbedPane();
    JComboBox cboLocales = new JComboBox();
    JButton btnLoad = new JButton(s_stringMgr.getString("I18n.loadBundles"));
    JTextField txtWorkingDir = new JTextField();
    JButton btnChooseWorkDir;
    JTextField txtEditorCommand = new JTextField();
    JButton btnChooseNativeToAsciiCommand;
    JTextField txtNativeToAsciiCommand = new JTextField();
    JButton btnChooseEditorCommand;
    JTextField txtNativeToAsciiOutDir = new JTextField();
    JButton btnChooseNativeToAsciiOutDir;
    JTable tblBundels = new JTable();
    JCheckBox cbxIncludeTimestamp = null;
    JCheckBox cbxExcludeComplete = null;
    private static final String PREF_KEY_INCLUDE_TIMESTAMP = "SquirrelSQL.i18n.includeTimestamp";
    public static final String PREF_KEY_EXCLUDE_COMPLETE = "SquirrelSQL.i18n.excludeComplete";
    private String infoText = "How translation works:\n1. Choose the locale you wish to translate for. A Locale at least consist of a language part like en (English). It may also consist of a country part like en_us (English _ United States). In most cases your translation won't be country depended. In this case you choose a locale that only consists of a language part.\n\n2. Click the 'Load bundles' button to fill the 'Bundles' table. This will give you an overview how many translations are to be done.\n\n3. Choose a working directory where SQuirreL should generate the templates for your translations. When loading the 'Bundles' table SQuirreL looks in this directory to find out which translations have already been done.\n\n4. Optionally choose an edtior command. This will allow you to open the files where you do your translations via right mouse menu of the bundles table.\n\n5. Before you can start translating you must use the right mouse menu in the 'Bundles' table to generate a translation template file. The generated template file consist of entries like this:\n#button.add.title=Add\n#button.add.title=\nwhich you turn into an entry of this kind:\n#button.add.title=Add\nbutton.add.title=<Your translation here>\nAfter this you might click the load bundles button again to see the number of tranlations to do decrease.\n\n6. To see your translations on next SQuirreL restart you need to:\ni. Edit the class path in your SQuirreL start batch or shell file to include your working directory.\nii. If your machine is running with locale different from the one you are translating to edit your your SQuirreL start batch or shell to pass the right country to your Java Virtual Machine.\nIn the shell or batch files you'll find further details about what to do.\n\n7. For non-latin1 encodings use the native2ascii tool included in JDK 1.4.x. For details see:\nhttp://java.sun.com/j2se/1.4.2/docs/tooldocs/windows/native2ascii.html\n\n8. For other translation issues or any further questions see our developer mailing list at squirrel-sql-develop@lists.sourceforge.net";

    public TranslatorsPanel(PluginResources resources) {
        this.setLayout(new GridLayout(1, 1));
        this.add(this.tabTranlators);
        JPanel translationsPanel = this.getTranslationsPanel(resources);
        this.tabTranlators.addTab(s_stringMgr.getString("I18n.tranlations"), translationsPanel);
        this.tabTranlators.addTab(s_stringMgr.getString("I18n.info"), new JScrollPane((Component)new MultipleLineLabel(this.infoText)));
        String includeTimestamp = Props.getString((String)PREF_KEY_INCLUDE_TIMESTAMP, (String)"true");
        this.cbxIncludeTimestamp.setSelected(includeTimestamp.equals("true"));
        String excludeComplete = Props.getString((String)PREF_KEY_EXCLUDE_COMPLETE, (String)"false");
        this.cbxExcludeComplete.setSelected(excludeComplete.equals("true"));
    }

    private JPanel getTranslationsPanel(PluginResources resources) {
        JPanel ret = new JPanel();
        ret.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0);
        ret.add((Component)new JLabel(s_stringMgr.getString("I18n.locales")), gbc);
        gbc = new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 18, 1, new Insets(5, 0, 0, 5), 0, 0);
        ret.add((Component)this.cboLocales, gbc);
        gbc = new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 0, 0, 5), 0, 0);
        ret.add((Component)this.btnLoad, gbc);
        gbc = new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0);
        ret.add((Component)new JLabel(s_stringMgr.getString("I18n.WorkingDir")), gbc);
        gbc = new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 18, 1, new Insets(5, 0, 0, 5), 0, 0);
        ret.add((Component)this.txtWorkingDir, gbc);
        this.btnChooseWorkDir = new JButton(resources.getIcon("Open"));
        gbc = new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 0, 0, 5), 0, 0);
        ret.add((Component)this.btnChooseWorkDir, gbc);
        gbc = new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0);
        ret.add((Component)new JLabel(s_stringMgr.getString("I18n.EditorCommand")), gbc);
        gbc = new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 18, 1, new Insets(5, 0, 0, 5), 0, 0);
        ret.add((Component)this.txtEditorCommand, gbc);
        this.btnChooseEditorCommand = new JButton(resources.getIcon("Open"));
        gbc = new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 0, 0, 5), 0, 0);
        ret.add((Component)this.btnChooseEditorCommand, gbc);
        gbc = new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0);
        ret.add((Component)new MultipleLineLabel(s_stringMgr.getString("I18n.NativeToAscii")), gbc);
        gbc = new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 0, 5), 0, 0);
        ret.add((Component)this.txtNativeToAsciiCommand, gbc);
        this.btnChooseNativeToAsciiCommand = new JButton(resources.getIcon("Open"));
        gbc = new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 5), 0, 0);
        ret.add((Component)this.btnChooseNativeToAsciiCommand, gbc);
        gbc = new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0);
        ret.add((Component)new JLabel(s_stringMgr.getString("I18n.NativeToAsciiOutDir")), gbc);
        gbc = new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 16, 1, new Insets(5, 0, 0, 5), 0, 0);
        ret.add((Component)this.txtNativeToAsciiOutDir, gbc);
        this.btnChooseNativeToAsciiOutDir = new JButton(resources.getIcon("Open"));
        gbc = new GridBagConstraints(2, 4, 1, 1, 0.0, 0.0, 16, 0, new Insets(5, 0, 0, 5), 0, 0);
        ret.add((Component)this.btnChooseNativeToAsciiOutDir, gbc);
        gbc = new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 16, 0, new Insets(5, 0, 0, 5), 0, 0);
        this.cbxIncludeTimestamp = new JCheckBox(s_stringMgr.getString("I18n.includeTimestamp"));
        ret.add((Component)this.cbxIncludeTimestamp, gbc);
        this.cbxExcludeComplete = new JCheckBox(s_stringMgr.getString("I18n.excludeComplete"));
        gbc = new GridBagConstraints(1, 6, 1, 1, 0.0, 0.0, 16, 0, new Insets(5, 0, 0, 5), 0, 0);
        ret.add((Component)this.cbxExcludeComplete, gbc);
        gbc = new GridBagConstraints(0, 7, 3, 1, 0.0, 0.0, 18, 0, new Insets(5, 0, 0, 5), 0, 0);
        ret.add((Component)new JLabel(s_stringMgr.getString("I18n.bundles")), gbc);
        gbc = new GridBagConstraints(0, 8, 3, 1, 1.0, 1.0, 18, 1, new Insets(5, 0, 0, 5), 0, 0);
        ret.add((Component)new JScrollPane(this.tblBundels), gbc);
        return ret;
    }
}

