/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.mssql.util;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import net.sourceforge.squirrel_sql.fw.sql.IDatabaseObjectInfo;
import net.sourceforge.squirrel_sql.fw.sql.IProcedureInfo;
import net.sourceforge.squirrel_sql.fw.sql.ISQLConnection;
import net.sourceforge.squirrel_sql.fw.sql.ITableInfo;
import net.sourceforge.squirrel_sql.fw.sql.IUDTInfo;
import net.sourceforge.squirrel_sql.fw.sql.SQLUtilities;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import net.sourceforge.squirrel_sql.plugins.mssql.sql.constraint.CheckConstraint;
import net.sourceforge.squirrel_sql.plugins.mssql.sql.constraint.DefaultConstraint;
import net.sourceforge.squirrel_sql.plugins.mssql.sql.constraint.ForeignKeyConstraint;
import net.sourceforge.squirrel_sql.plugins.mssql.sql.constraint.PrimaryKeyConstraint;
import net.sourceforge.squirrel_sql.plugins.mssql.sql.constraint.TableConstraints;
import net.sourceforge.squirrel_sql.plugins.mssql.sql.dbfile.DatabaseFile;
import net.sourceforge.squirrel_sql.plugins.mssql.sql.dbfile.DatabaseFileInfo;

public class MssqlIntrospector {
    private static final ILogger s_log = LoggerController.createLogger(MssqlIntrospector.class);
    public static final int MSSQL_TABLE = 1;
    public static final int MSSQL_VIEW = 2;
    public static final int MSSQL_STOREDPROCEDURE = 3;
    public static final int MSSQL_UDF = 4;
    public static final int MSSQL_UDT = 5;
    public static final int MSSQL_RULE = 6;
    public static final int MSSQL_DEFAULT = 7;
    public static final int MSSQL_UNKNOWN = -1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TableConstraints getTableConstraints(IDatabaseObjectInfo oi, ISQLConnection conn) throws SQLException {
        TableConstraints constraints = new TableConstraints();
        Connection c = conn.getConnection();
        CallableStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = c.prepareCall("{ call sp_helpconstraint ?, ? }");
            stmt.setString(1, oi.getSimpleName());
            stmt.setString(2, "nomsg");
            rs = stmt.executeQuery();
            while (rs.next()) {
                String col;
                String constraintType = rs.getString(1);
                String constraintName = rs.getString(2);
                String constraintKeys = rs.getString(7);
                if (constraintType.startsWith("DEFAULT")) {
                    DefaultConstraint def = new DefaultConstraint();
                    col = constraintType.substring(18).trim();
                    def.setConstraintName(constraintName);
                    def.addConstraintColumn(col);
                    def.setDefaultExpression(constraintKeys);
                    constraints.addConstraint(def);
                    continue;
                }
                if (constraintType.startsWith("CHECK")) {
                    CheckConstraint check = new CheckConstraint();
                    col = constraintType.substring(16).trim();
                    check.setConstraintName(constraintName);
                    check.addConstraintColumn(col);
                    check.setCheckExpression(constraintKeys);
                    constraints.addConstraint(check);
                    continue;
                }
                if (constraintType.startsWith("FOREIGN KEY")) {
                    ForeignKeyConstraint fk = new ForeignKeyConstraint();
                    fk.setConstraintName(constraintName);
                    String[] foreignColumns = constraintKeys.split(", ");
                    for (int i = 0; i < foreignColumns.length; ++i) {
                        fk.addConstraintColumn(foreignColumns[i]);
                    }
                    rs.next();
                    constraintKeys = rs.getString(7);
                    constraintKeys = constraintKeys.substring(11);
                    String[] tableAndColumns = constraintKeys.split(" ", 2);
                    fk.setReferencedTable(tableAndColumns[0]);
                    String[] primaryColumns = tableAndColumns[1].substring(1, tableAndColumns[1].length() - 2).split(",");
                    for (int i = 0; i < primaryColumns.length; ++i) {
                        fk.addPrimaryColumn(primaryColumns[i]);
                    }
                    constraints.addConstraint(fk);
                    continue;
                }
                if (!constraintType.startsWith("PRIMARY KEY")) continue;
                PrimaryKeyConstraint pk = new PrimaryKeyConstraint();
                pk.setConstraintName(constraintName);
                pk.setClustered(constraintType.endsWith("(clustered)"));
                String[] cols = constraintKeys.split(", ");
                for (int i = 0; i < cols.length; ++i) {
                    pk.addConstraintColumn(cols[i]);
                }
                constraints.addConstraint(pk);
            }
        }
        catch (SQLException ex) {
            TableConstraints tableConstraints;
            try {
                s_log.error((Object)("getTableConstraints: Unexpected exception - " + ex.getMessage()), (Throwable)ex);
                tableConstraints = constraints;
            }
            catch (Throwable throwable) {
                SQLUtilities.closeStatement((Statement)stmt);
                SQLUtilities.closeResultSet(rs);
                throw throwable;
            }
            SQLUtilities.closeStatement((Statement)stmt);
            SQLUtilities.closeResultSet((ResultSet)rs);
            return tableConstraints;
        }
        SQLUtilities.closeStatement((Statement)stmt);
        SQLUtilities.closeResultSet((ResultSet)rs);
        return constraints;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DatabaseFileInfo getDatabaseFileInfo(String catalogName, ISQLConnection conn) throws SQLException {
        ResultSet rs;
        CallableStatement stmt;
        DatabaseFileInfo dbInfo;
        block15: {
            DatabaseFileInfo i2;
            block14: {
                dbInfo = new DatabaseFileInfo();
                Connection c = conn.getConnection();
                stmt = null;
                rs = null;
                stmt = c.prepareCall("{ call sp_helpdb ? }");
                stmt.setString(1, catalogName);
                if (stmt.execute()) break block14;
                DatabaseFileInfo databaseFileInfo = null;
                SQLUtilities.closeResultSet(rs);
                SQLUtilities.closeStatement((Statement)stmt);
                return databaseFileInfo;
            }
            try {
                rs = stmt.getResultSet();
                rs.next();
                dbInfo.setDatabaseName(rs.getString(1));
                dbInfo.setDatabaseSize(rs.getString(2));
                dbInfo.setOwner(rs.getString(3));
                dbInfo.setCreatedDate(rs.getString(5));
                String[] options = rs.getString(6).split(", ");
                dbInfo.setCompatibilityLevel(rs.getShort(7));
                for (int i2 = 0; i2 < options.length; ++i2) {
                    if (options[i2].indexOf(61) != -1) {
                        String[] parts = options[i2].split("=");
                        dbInfo.setOption(parts[0], parts[1]);
                        continue;
                    }
                    dbInfo.setOption(options[i2], "1");
                }
                if (stmt.getMoreResults()) break block15;
                i2 = dbInfo;
            }
            catch (Exception e) {
                try {
                    s_log.error((Object)("getDatabaseFileInfo(1): Unexpected exception - " + e.getMessage()), (Throwable)e);
                }
                catch (Throwable throwable) {
                    SQLUtilities.closeResultSet(rs);
                    SQLUtilities.closeStatement((Statement)stmt);
                    throw throwable;
                }
                SQLUtilities.closeResultSet((ResultSet)rs);
                SQLUtilities.closeStatement((Statement)stmt);
            }
            SQLUtilities.closeResultSet((ResultSet)rs);
            SQLUtilities.closeStatement((Statement)stmt);
            return i2;
        }
        SQLUtilities.closeResultSet((ResultSet)rs);
        SQLUtilities.closeStatement((Statement)stmt);
        try {
            rs = stmt.getResultSet();
            while (rs.next()) {
                String name = rs.getString(1).trim();
                short id = rs.getShort(2);
                String filename = rs.getString(3).trim();
                String filegroup = rs.getString(4);
                String size = rs.getString(5);
                String maxSize = rs.getString(6);
                String growth = rs.getString(7);
                String usage = rs.getString(8);
                DatabaseFile file = new DatabaseFile();
                file.setName(name);
                file.setId(id);
                file.setFilename(filename);
                file.setFilegroup(filegroup);
                file.setSize(size);
                file.setMaxSize(maxSize);
                file.setGrowth(growth);
                file.setUsage(usage);
                if (filegroup == null) {
                    dbInfo.addLogFile(file);
                    continue;
                }
                dbInfo.addDataFile(file);
            }
        }
        catch (Exception e) {
            s_log.error((Object)("getDatabaseFileInfo(2): Unexpected exception - " + e.getMessage()), (Throwable)e);
        }
        finally {
            SQLUtilities.closeResultSet((ResultSet)rs);
        }
        return dbInfo;
    }

    public static int getObjectInfoType(IDatabaseObjectInfo oi) {
        if (oi instanceof ITableInfo) {
            String tableType = ((ITableInfo)oi).getType();
            if (tableType.equals("TABLE")) {
                return 1;
            }
            if (tableType.equals("VIEW")) {
                return 2;
            }
            return -1;
        }
        if (oi instanceof IProcedureInfo) {
            String simpleName = oi.getSimpleName();
            if (simpleName.endsWith(";0")) {
                return 4;
            }
            if (simpleName.endsWith(";1")) {
                return 3;
            }
            return -1;
        }
        if (oi instanceof IUDTInfo) {
            return 5;
        }
        return -1;
    }

    public static String generateCreateScript(IDatabaseObjectInfo oi, ISQLConnection conn, boolean withConstraints) throws SQLException {
        StringBuilder buf = new StringBuilder();
        if (MssqlIntrospector.getObjectInfoType(oi) == 1) {
            buf.append(MssqlIntrospector.generateCreateTableScript(oi, conn, withConstraints));
        } else {
            Connection c = conn.getConnection();
            buf.append(MssqlIntrospector.getHelpTextForObject(MssqlIntrospector.getFixedVersionedObjectName(oi.getSimpleName()), c));
        }
        buf.append("GO\n\n");
        return buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getHelpTextForObject(String objectName, Connection c) throws SQLException {
        StringBuilder buf = new StringBuilder();
        CallableStatement stmt = null;
        ResultSet helpText = null;
        try {
            stmt = c.prepareCall("{ call sp_helptext (?) }");
            stmt.setString(1, objectName);
            helpText = stmt.executeQuery();
            while (helpText.next()) {
                buf.append(helpText.getString(1));
            }
        }
        catch (Exception e) {
            try {
                s_log.error((Object)("getHelpTextForObject: Unexpected exception - " + e.getMessage()), (Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtilities.closeResultSet(helpText);
                SQLUtilities.closeStatement((Statement)stmt);
                throw throwable;
            }
            SQLUtilities.closeResultSet((ResultSet)helpText);
            SQLUtilities.closeStatement((Statement)stmt);
        }
        SQLUtilities.closeResultSet((ResultSet)helpText);
        SQLUtilities.closeStatement((Statement)stmt);
        return buf.toString();
    }

    public static String generateCreateDatabaseScript(String catalogName, ISQLConnection conn) throws SQLException {
        DatabaseFile file;
        int i;
        StringBuilder buf = new StringBuilder();
        DatabaseFileInfo dbInfo = MssqlIntrospector.getDatabaseFileInfo(catalogName, conn);
        Object[] dataFiles = dbInfo.getDataFiles();
        Object[] logFiles = dbInfo.getLogFiles();
        buf.append("CREATE DATABASE [");
        buf.append(dbInfo.getDatabaseName());
        buf.append("]\nON ");
        String lastFilegroup = "";
        for (i = 0; i < dataFiles.length; ++i) {
            file = (DatabaseFile)dataFiles[i];
            String thisFilegroup = file.getFilegroup();
            if (!thisFilegroup.equals(lastFilegroup)) {
                if (thisFilegroup.equals("PRIMARY")) {
                    buf.append("PRIMARY");
                } else {
                    buf.append("FILEGROUP ");
                    buf.append(thisFilegroup);
                }
                buf.append("\n");
                lastFilegroup = thisFilegroup;
            }
            buf.append("( NAME = ");
            buf.append(file.getName());
            buf.append(",\n\tFILENAME = '");
            buf.append(file.getFilename());
            buf.append("',\n\tSIZE = ");
            buf.append(file.getSize());
            if (!file.getMaxSize().equals("Unlimited")) {
                buf.append(",\n\tMAXSIZE = ");
                buf.append(file.getMaxSize());
            }
            buf.append(",\n\tFILEGROWTH = ");
            buf.append(file.getGrowth());
            buf.append(" )");
            if (i < dataFiles.length - 1) {
                buf.append(",");
            }
            buf.append("\n");
        }
        buf.append("LOG ON\n");
        for (i = 0; i < logFiles.length; ++i) {
            file = (DatabaseFile)logFiles[i];
            buf.append("( NAME = ");
            buf.append(file.getName());
            buf.append(",\n\tFILENAME = '");
            buf.append(file.getFilename());
            buf.append("',\n\tSIZE = ");
            buf.append(file.getSize());
            if (!file.getMaxSize().equals("Unlimited")) {
                buf.append(",\n\tMAXSIZE = ");
                buf.append(file.getMaxSize());
            }
            buf.append(",\n\tFILEGROWTH = ");
            buf.append(file.getGrowth());
            buf.append(" )");
            if (i < logFiles.length - 1) {
                buf.append(",");
            }
            buf.append("\n");
        }
        buf.append("GO\n\n");
        return buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String generateCreateIndexesScript(IDatabaseObjectInfo oi, ISQLConnection conn) throws SQLException {
        Connection c = conn.getConnection();
        StringBuilder buf = new StringBuilder();
        CallableStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = c.prepareCall("{ call sp_helpindex ? }");
            stmt.setString(1, oi.getSimpleName());
            rs = stmt.executeQuery();
        }
        catch (SQLException e) {
            String string;
            try {
                s_log.error((Object)("getTableConstraints: Unexpected exception - " + e.getMessage()), (Throwable)e);
                string = "";
            }
            catch (Throwable throwable) {
                SQLUtilities.closeResultSet(rs);
                SQLUtilities.closeStatement((Statement)stmt);
                throw throwable;
            }
            SQLUtilities.closeResultSet((ResultSet)rs);
            SQLUtilities.closeStatement((Statement)stmt);
            return string;
        }
        SQLUtilities.closeResultSet((ResultSet)rs);
        SQLUtilities.closeStatement((Statement)stmt);
        while (rs.next()) {
            int i;
            String indexName = rs.getString(1);
            String[] info = rs.getString(2).split(" located on ");
            String[] keys = rs.getString(3).split(", ");
            String[] attribs = info[0].split(", ");
            boolean isUnique = false;
            boolean isClustered = false;
            for (i = 0; i < attribs.length; ++i) {
                if (attribs[i].equals("clustered")) {
                    isClustered = true;
                    continue;
                }
                if (!attribs[i].equals("unique")) continue;
                isUnique = true;
            }
            buf.append("CREATE ");
            if (isUnique) {
                buf.append("UNIQUE ");
            }
            buf.append(isClustered ? "CLUSTERED " : "NONCLUSTERED ");
            buf.append("INDEX [");
            buf.append(indexName);
            buf.append("]\n\tON [");
            buf.append(oi.getSimpleName());
            buf.append("] (");
            for (i = 0; i < keys.length; ++i) {
                boolean isDesc = false;
                String keyName = keys[i];
                if (keyName.endsWith("(-)")) {
                    isDesc = true;
                    keyName = keyName.substring(0, keyName.length() - 3);
                }
                buf.append(keyName);
                if (isDesc) {
                    buf.append(" DESC");
                }
                if (i >= keys.length - 1) continue;
                buf.append(", ");
            }
            buf.append(")\n\tON [");
            buf.append(info[1]);
            buf.append("]\nGO\n\n");
        }
        return buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String generateCreateTriggersScript(IDatabaseObjectInfo oi, ISQLConnection conn) throws SQLException {
        Connection c = conn.getConnection();
        StringBuilder buf = new StringBuilder();
        CallableStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = c.prepareCall("{ call sp_helptrigger ? }");
            stmt.setString(1, oi.getSimpleName());
            rs = stmt.executeQuery();
        }
        catch (SQLException e) {
            String string;
            try {
                s_log.error((Object)("generateCreateTriggersScript: Unexpected exception - " + e.getMessage()), (Throwable)e);
                string = "";
            }
            catch (Throwable throwable) {
                SQLUtilities.closeResultSet(rs);
                SQLUtilities.closeStatement((Statement)stmt);
                throw throwable;
            }
            SQLUtilities.closeResultSet((ResultSet)rs);
            SQLUtilities.closeStatement((Statement)stmt);
            return string;
        }
        SQLUtilities.closeResultSet((ResultSet)rs);
        SQLUtilities.closeStatement((Statement)stmt);
        while (rs.next()) {
            String triggerName = rs.getString(1);
            buf.append(MssqlIntrospector.getHelpTextForObject(triggerName, c));
            buf.append("\nGO\n\n");
        }
        return buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String generatePermissionsScript(IDatabaseObjectInfo oi, ISQLConnection conn) throws SQLException {
        Connection c = conn.getConnection();
        StringBuilder buf = new StringBuilder();
        CallableStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = c.prepareCall("{ call sp_helprotect ? }");
            stmt.setString(1, MssqlIntrospector.getFixedVersionedObjectName(oi.getSimpleName()));
            rs = stmt.executeQuery();
        }
        catch (SQLException e) {
            String string;
            try {
                s_log.error((Object)("generatePermissionsScript: Unexpected exception - " + e.getMessage()), (Throwable)e);
                string = "";
            }
            catch (Throwable throwable) {
                SQLUtilities.closeResultSet(rs);
                SQLUtilities.closeStatement((Statement)stmt);
                throw throwable;
            }
            SQLUtilities.closeResultSet((ResultSet)rs);
            SQLUtilities.closeStatement((Statement)stmt);
            return string;
        }
        SQLUtilities.closeResultSet((ResultSet)rs);
        SQLUtilities.closeStatement((Statement)stmt);
        while (rs.next()) {
            String grantee = rs.getString(3);
            String protectType = rs.getString(5).trim();
            String action = rs.getString(6);
            if (protectType.equals("Grant")) {
                buf.append("GRANT ");
            } else if (protectType.equals("Deny")) {
                buf.append("REVOKE ");
            }
            buf.append(action.toUpperCase());
            buf.append(" ON [");
            buf.append(MssqlIntrospector.getFixedVersionedObjectName(oi.getSimpleName()));
            buf.append("] ");
            if (protectType.equals("Grant")) {
                buf.append("TO ");
            } else if (protectType.equals("Deny")) {
                buf.append("FROM ");
            }
            buf.append(grantee);
            buf.append("\nGO\n\n");
        }
        return buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String generateCreateTableScript(IDatabaseObjectInfo oi, ISQLConnection conn, boolean withConstraints) throws SQLException {
        ResultSet rs;
        CallableStatement stmt;
        TableConstraints constraints;
        StringBuilder buf;
        block21: {
            block20: {
                block19: {
                    Connection c = conn.getConnection();
                    buf = new StringBuilder();
                    constraints = MssqlIntrospector.getTableConstraints(oi, conn);
                    stmt = null;
                    rs = null;
                    stmt = c.prepareCall("{ call sp_help ? }");
                    stmt.setString(1, oi.getSimpleName());
                    if (stmt.execute()) break block19;
                    String string = null;
                    SQLUtilities.closeResultSet(rs);
                    SQLUtilities.closeStatement((Statement)stmt);
                    return string;
                }
                rs = stmt.getResultSet();
                if (rs.next()) break block20;
                String string = null;
                SQLUtilities.closeResultSet((ResultSet)rs);
                SQLUtilities.closeStatement((Statement)stmt);
                return string;
            }
            buf.append("CREATE TABLE [");
            buf.append(rs.getString(2));
            buf.append("].[");
            buf.append(rs.getString(1));
            buf.append("] (");
            buf.append("\n");
            if (stmt.getMoreResults()) break block21;
            String string = null;
            SQLUtilities.closeResultSet((ResultSet)rs);
            SQLUtilities.closeStatement((Statement)stmt);
            return string;
        }
        try {
            rs = stmt.getResultSet();
            while (rs.next()) {
                List<DefaultConstraint> defs;
                String colName = rs.getString(1);
                String colType = rs.getString(2);
                buf.append("\t[");
                buf.append(colName);
                buf.append("] [");
                buf.append(colType);
                buf.append("] ");
                if (colType.equals("char") || colType.equals("varchar")) {
                    buf.append("(");
                    buf.append(rs.getInt(4));
                    buf.append(") COLLATE ");
                    buf.append(rs.getString(10));
                    buf.append(" ");
                }
                if (rs.getString(7).equals("yes")) {
                    buf.append("NULL ");
                } else {
                    buf.append("NOT NULL ");
                }
                if (withConstraints && (defs = constraints.getDefaultsForColumn(colName)) != null && defs.size() == 1) {
                    DefaultConstraint def = defs.get(0);
                    buf.append("CONSTRAINT [");
                    buf.append(def.getConstraintName());
                    buf.append("] DEFAULT ");
                    buf.append(def.getDefaultExpression());
                    buf.append(" ");
                }
                buf.append(",\n");
            }
        }
        catch (SQLException e) {
            try {
                s_log.error((Object)("generateCreateTableScript: Unexpected exception - " + e.getMessage()), (Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtilities.closeResultSet(rs);
                SQLUtilities.closeStatement((Statement)stmt);
                throw throwable;
            }
            SQLUtilities.closeResultSet((ResultSet)rs);
            SQLUtilities.closeStatement((Statement)stmt);
        }
        SQLUtilities.closeResultSet((ResultSet)rs);
        SQLUtilities.closeStatement((Statement)stmt);
        if (withConstraints) {
            List<PrimaryKeyConstraint> pks = constraints.getPrimaryKeyConstraints();
            if (pks != null && pks.size() == 1) {
                PrimaryKeyConstraint pk = pks.get(0);
                buf.append("\tCONSTRAINT [");
                buf.append(pk.getConstraintName());
                buf.append("] PRIMARY KEY ");
                buf.append(pk.isClustered() ? "CLUSTERED" : "NONCLUSTERED");
                buf.append("\n\t(\n\t\t");
                Object[] cols = pk.getConstraintColumns();
                for (int i = 0; i < cols.length; ++i) {
                    buf.append("[");
                    buf.append((String)cols[i]);
                    buf.append("]");
                    if (i >= cols.length - 1) continue;
                    buf.append(", ");
                }
                buf.append("\n\t)\n");
            }
            List<ForeignKeyConstraint> fks = constraints.getForeignKeyConstraints();
            for (int i = 0; i < fks.size(); ++i) {
                ForeignKeyConstraint fk = fks.get(i);
                buf.append("\tFOREIGN KEY\n\t(\n\t\t");
                Object[] foreignColumns = fk.getConstraintColumns();
                for (int j = 0; j < foreignColumns.length; ++j) {
                    buf.append("[");
                    buf.append((String)foreignColumns[j]);
                    buf.append("]");
                    if (j >= foreignColumns.length - 1) continue;
                    buf.append(", ");
                }
                buf.append("\n\t) REFERENCES [");
                buf.append(fk.getReferencedTable());
                buf.append("] (\n\t\t");
                Object[] primaryColumns = fk.getPrimaryColumns();
                for (int j = 0; j < primaryColumns.length; ++j) {
                    buf.append("[");
                    buf.append((String)primaryColumns[j]);
                    buf.append("]");
                    if (j >= primaryColumns.length - 1) continue;
                    buf.append(",\n");
                }
                buf.append("\n\t),");
            }
            for (CheckConstraint check : constraints.getCheckConstraints()) {
                buf.append("\tCONSTRAINT [");
                buf.append(check.getConstraintName());
                buf.append("] CHECK ");
                buf.append(check.getCheckExpression());
                buf.append(",\n");
            }
        }
        buf.append(")\n");
        return buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String generateUsersAndRolesScript(String catalogName, ISQLConnection conn) throws SQLException {
        StringBuilder buf = new StringBuilder();
        Connection c = conn.getConnection();
        CallableStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = c.prepareCall("{ call sp_helpuser }");
            rs = stmt.executeQuery();
            while (rs.next()) {
                String userName = rs.getString(1);
                String loginName = rs.getString(3);
                if (userName.equals("dbo")) continue;
                buf.append("if not exists (select * from dbo.sysusers where name = N'");
                buf.append(userName);
                buf.append("' and uid < 16382)\n\tEXEC sp_grantdbaccess N'");
                buf.append(loginName);
                buf.append("', N'");
                buf.append(userName);
                buf.append("'\nGO\n\n");
            }
        }
        catch (SQLException e) {
            try {
                s_log.error((Object)("generateUsersAndRolesScript(1): Unexpected exception - " + e.getMessage()), (Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtilities.closeResultSet(rs);
                SQLUtilities.closeStatement((Statement)stmt);
                throw throwable;
            }
            SQLUtilities.closeResultSet((ResultSet)rs);
            SQLUtilities.closeStatement((Statement)stmt);
        }
        SQLUtilities.closeResultSet((ResultSet)rs);
        SQLUtilities.closeStatement((Statement)stmt);
        CallableStatement userStmt = null;
        ResultSet userRs = null;
        try {
            stmt = c.prepareCall("{ call sp_helprole }");
            rs = stmt.executeQuery();
            while (rs.next()) {
                String roleName = rs.getString(1);
                short roleId = rs.getShort(2);
                if (roleId < 16400) continue;
                buf.append("if not exists (select * from dbo.sysusers where name = N'");
                buf.append(roleName);
                buf.append("' and uid > 16399)\n\tEXEC sp_addrole N'");
                buf.append(roleName);
                buf.append("'\nGO\n\n");
                userStmt = c.prepareCall("{ call sp_helprolemember ? }");
                userStmt.setString(1, roleName);
                userRs = userStmt.executeQuery();
                while (userRs.next()) {
                    String userInRole = userRs.getString(2);
                    buf.append("exec sp_addrolemember N'");
                    buf.append(roleName);
                    buf.append("', N'");
                    buf.append(userInRole);
                    buf.append("'\nGO\n\n");
                }
            }
        }
        catch (SQLException e) {
            s_log.error((Object)("generateUsersAndRolesScript(2): Unexpected exception - " + e.getMessage()), (Throwable)e);
        }
        finally {
            SQLUtilities.closeResultSet((ResultSet)rs);
            SQLUtilities.closeResultSet(userRs);
            SQLUtilities.closeStatement((Statement)stmt);
            SQLUtilities.closeStatement(userStmt);
        }
        return buf.toString();
    }

    public static String generateDropScript(IDatabaseObjectInfo oi) {
        StringBuilder buf = new StringBuilder();
        int objectType = MssqlIntrospector.getObjectInfoType(oi);
        String useThisName = objectType == 3 || objectType == 4 ? oi.getSimpleName().split(";")[0] : oi.getSimpleName();
        buf.append("IF EXISTS ( SELECT * FROM sysobjects WHERE id = OBJECT_ID('");
        buf.append(oi.getSchemaName());
        buf.append(".");
        buf.append(useThisName);
        buf.append("') )\n\tDROP ");
        switch (objectType) {
            case 1: {
                buf.append("TABLE");
                break;
            }
            case 2: {
                buf.append("VIEW");
                break;
            }
            case 4: {
                buf.append("FUNCTION");
                break;
            }
            case 3: {
                buf.append("PROCEDURE");
            }
        }
        buf.append(" ");
        buf.append(useThisName);
        buf.append("\nGO\n\n");
        return buf.toString();
    }

    public static String getFixedVersionedObjectName(String objectName) {
        String[] parts = objectName.split(";");
        return parts[0];
    }

    public static String formatDataType(String dataType, short dataLength, int dataPrec, int dataScale) {
        StringBuilder buf = new StringBuilder();
        if (dataType.endsWith("char")) {
            buf.append(dataType);
            buf.append("(");
            buf.append(dataLength);
            buf.append(")");
        } else if (dataType.equals("float")) {
            buf.append(dataType);
            buf.append("(");
            buf.append(dataPrec);
            buf.append(")");
        } else if (dataType.equals("decimal") || dataType.equals("numeric")) {
            buf.append(dataType);
            buf.append("(");
            buf.append(dataPrec);
            buf.append(",");
            buf.append(dataScale);
            buf.append(")");
        } else {
            buf.append(dataType);
        }
        return buf.toString();
    }
}

