/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.mysql.tab;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.tabs.BasePreparedStatementTab;
import net.sourceforge.squirrel_sql.fw.sql.IDatabaseObjectInfo;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class MysqlTriggerDetailsTab
extends BasePreparedStatementTab {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(MysqlTriggerDetailsTab.class);
    private static String SQL = "SELECT trigger_name, trigger_schema, definer, event_manipulation, action_timing, action_orientation, event_object_table FROM information_schema.TRIGGERS WHERE trigger_schema = ? and trigger_name = ? ";
    private static final ILogger s_log = LoggerController.createLogger(MysqlTriggerDetailsTab.class);

    public MysqlTriggerDetailsTab() {
        super(i18n.TITLE, i18n.HINT, true);
    }

    protected PreparedStatement createStatement() throws SQLException {
        ISession session = this.getSession();
        IDatabaseObjectInfo doi = this.getDatabaseObjectInfo();
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Trigger details SQL: " + SQL));
            s_log.debug((Object)("Trigger catalog: " + doi.getCatalogName()));
            s_log.debug((Object)("Trigger name: " + doi.getSimpleName()));
        }
        PreparedStatement pstmt = session.getSQLConnection().prepareStatement(SQL);
        pstmt.setString(1, doi.getCatalogName());
        pstmt.setString(2, doi.getSimpleName());
        return pstmt;
    }

    static /* synthetic */ StringManager access$000() {
        return s_stringMgr;
    }

    private static interface i18n {
        public static final String TITLE = MysqlTriggerDetailsTab.access$000().getString("MysqlTriggerDetailsTab.title");
        public static final String HINT = MysqlTriggerDetailsTab.access$000().getString("MysqlTriggerDetailsTab.hint");
    }
}

