/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.datasetviewer;

import java.sql.ResultSet;
import java.sql.SQLException;
import net.sourceforge.squirrel_sql.fw.datasetviewer.BlockMode;
import net.sourceforge.squirrel_sql.fw.datasetviewer.StatementCallback;
import net.sourceforge.squirrel_sql.fw.sql.SQLUtilities;

public class ResultSetWrapper {
    private final ResultSet _resultSet;
    private final StatementCallback _parent;
    private int _countRowsRead = 0;
    private boolean _resNextHasReturnedFalse;
    private boolean _followUpBlockReached;
    private boolean limitRead = false;

    public ResultSetWrapper(ResultSet resultSet, StatementCallback parent) {
        this._resultSet = resultSet;
        this._parent = parent;
    }

    public ResultSetWrapper(ResultSet resultSet) {
        this(resultSet, null);
    }

    public ResultSet getResultSet() {
        return this._resultSet;
    }

    public void closeIfContinueReadIsNotActive() {
        if (this.isContinueReadActive()) {
            return;
        }
        this.closeStatementAndResultSet();
    }

    private boolean isContinueReadActive() {
        return null != this._parent && this._parent.isContinueReadActive();
    }

    public boolean next(BlockMode blockMode) throws SQLException {
        if (!this.isContinueReadActive()) {
            return this._nextOnResultSet();
        }
        if (BlockMode.FIRST_BLOCK == blockMode) {
            boolean ret;
            boolean bl = ret = this._countRowsRead < this._parent.getFirstBlockCount() && this._nextOnResultSet();
            if (!ret) {
                this._countRowsRead = 0;
            }
            return ret;
        }
        if (BlockMode.FOLLOW_UP_BLOCK == blockMode) {
            boolean ret;
            this._followUpBlockReached = true;
            boolean bl = ret = this._countRowsRead < this._parent.getContinueBlockCount() && this._nextOnResultSet();
            if (!ret) {
                this._countRowsRead = 0;
            }
            return ret;
        }
        if (BlockMode.INDIFFERENT == blockMode) {
            return this._nextOnResultSet();
        }
        throw new IllegalStateException("Unknown BlockMode " + (Object)((Object)blockMode));
    }

    private boolean _nextOnResultSet() throws SQLException {
        boolean ret = this._resultSet.next();
        if (ret) {
            ++this._countRowsRead;
        } else {
            this._resNextHasReturnedFalse = true;
            if (this._followUpBlockReached) {
                this.closeStatementAndResultSet();
            }
        }
        return ret;
    }

    public boolean isAllResultsRead() {
        return this._resNextHasReturnedFalse || false == this.isContinueReadActive();
    }

    public void closeStatementAndResultSet() {
        try {
            SQLUtilities.closeResultSet(this._resultSet);
        }
        finally {
            if (null != this._parent) {
                this._parent.closeStatementIfContinueReadActive();
            }
        }
    }

    public boolean areAllPossibleResultsOfSQLRead() {
        if (!this._resNextHasReturnedFalse) {
            return false;
        }
        if (null != this._parent && this._parent.isMaxRowsWasSet()) {
            return this._countRowsRead != this._parent.getMaxRowsCount();
        }
        return true;
    }

    public boolean isLimitRead() {
        return this.limitRead;
    }

    public void setLimitRead(boolean limitRead) {
        this.limitRead = limitRead;
    }
}

