/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.datasetviewer;

import javax.swing.DefaultCellEditor;
import net.sourceforge.squirrel_sql.client.session.DataModelImplementationDetails;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ColumnDisplayDefinition;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ColumnHeaderDisplay;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ContinueReadChannel;
import net.sourceforge.squirrel_sql.fw.datasetviewer.DataSetException;
import net.sourceforge.squirrel_sql.fw.datasetviewer.DataSetViewerTablePanel;
import net.sourceforge.squirrel_sql.fw.datasetviewer.IDataSet;
import net.sourceforge.squirrel_sql.fw.datasetviewer.IDataSetUpdateableModel;
import net.sourceforge.squirrel_sql.fw.datasetviewer.IDataSetViewer;
import net.sourceforge.squirrel_sql.fw.datasetviewer.RowColSelectedCountListener;
import net.sourceforge.squirrel_sql.fw.datasetviewer.TableState;
import net.sourceforge.squirrel_sql.fw.util.IMessageHandler;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public abstract class BaseDataSetViewerDestination
implements IDataSetViewer {
    private static ILogger s_log = LoggerController.createLogger(BaseDataSetViewerDestination.class);
    private boolean _showHeadings = true;
    private ColumnDisplayDefinition[] _colDefs = new ColumnDisplayDefinition[0];
    private IDataSetUpdateableModel _updateableModelReference = null;
    private DefaultCellEditor currentCellEditor = null;

    @Override
    public void init(IDataSetUpdateableModel updateableObject, ISession session) {
        this.init(updateableObject, null, session);
    }

    @Override
    public void init(IDataSetUpdateableModel updateableModel, DataModelImplementationDetails dataModelImplementationDetails, ISession session) {
    }

    @Override
    public void setColumnDefinitions(ColumnDisplayDefinition[] colDefs) {
        this._colDefs = colDefs != null ? colDefs : new ColumnDisplayDefinition[]{};
    }

    @Override
    public ColumnDisplayDefinition[] getColumnDefinitions() {
        return this._colDefs;
    }

    @Override
    public void showHeadings(boolean show) {
        this._showHeadings = show;
    }

    @Override
    public boolean getShowHeadings() {
        return this._showHeadings;
    }

    @Override
    public synchronized void show(IDataSet ds) throws DataSetException {
        this.show(ds, null);
    }

    @Override
    public synchronized void show(IDataSet ds, IMessageHandler msgHandler) throws DataSetException {
        if (this.currentCellEditor != null) {
            this.currentCellEditor.cancelCellEditing();
            this.currentCellEditor = null;
        }
        if (ds == null) {
            throw new IllegalArgumentException("IDataSet == null");
        }
        this.clear();
        if (ds.getDataSetDefinition() != null) {
            this.setColumnDefinitions(ds.getDataSetDefinition().getColumnDefinitions());
            int colCount = ds.getColumnCount();
            while (ds.next(msgHandler)) {
                this.addRow(ds, colCount);
            }
            this.allRowsAdded();
            this.moveToTop();
        }
    }

    protected void addRow(IDataSet ds, int columnCount) throws DataSetException {
        Object[] row = new Object[columnCount];
        for (int i = 0; i < columnCount; ++i) {
            row[i] = ds.get(i);
        }
        this.addRow(row);
    }

    public void setUpdateableModelReference(IDataSetUpdateableModel updateableObject) {
        this._updateableModelReference = updateableObject;
    }

    @Override
    public IDataSetUpdateableModel getUpdateableModelReference() {
        return this._updateableModelReference;
    }

    protected abstract void allRowsAdded() throws DataSetException;

    protected abstract void addRow(Object[] var1) throws DataSetException;

    public static IDataSetViewer getInstance(String sName, IDataSetUpdateableModel updateableModel, ISession session) {
        return BaseDataSetViewerDestination.getInstance(sName, updateableModel, null, session);
    }

    public static IDataSetViewer getInstance(String sName, IDataSetUpdateableModel updateableModel, DataModelImplementationDetails dataModelImplementationDetails, ISession session) {
        IDataSetViewer dsv = null;
        try {
            Class<?> cls = Class.forName(sName);
            dsv = (IDataSetViewer)cls.newInstance();
            dsv.init(updateableModel, dataModelImplementationDetails, session);
        }
        catch (Exception e) {
            s_log.error("Error", e);
        }
        if (dsv == null) {
            dsv = new DataSetViewerTablePanel();
            dsv.init(updateableModel, dataModelImplementationDetails, session);
        }
        return dsv;
    }

    @Override
    public TableState getResultSortableTableState() {
        return null;
    }

    @Override
    public void applyResultSortableTableState(TableState sortableTableState) {
    }

    @Override
    public void setContinueReadChannel(ContinueReadChannel continueReadChannel) {
    }

    @Override
    public void disableContinueRead() {
    }

    @Override
    public void setRowColSelectedCountListener(RowColSelectedCountListener rowColSelectedCountListener) {
    }

    @Override
    public void switchColumnHeader(ColumnHeaderDisplay columnHeaderDisplay) {
    }

    protected DefaultCellEditor getCurrentCellEditor() {
        return this.currentCellEditor;
    }

    protected void setCurrentCellEditor(DefaultCellEditor currentCellEditor) {
        this.currentCellEditor = currentCellEditor;
    }

    protected ColumnDisplayDefinition[] getColDefs() {
        return this._colDefs;
    }

    protected void setColDefs(ColumnDisplayDefinition[] colDefs) {
        this._colDefs = colDefs;
    }
}

